/*! START TRANSACTION */;
CREATE TABLE education_training_experience (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  category DECIMAL(3,0),
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(5,2),
  lower_ci_bound DECIMAL(5,2),
  upper_ci_bound DECIMAL(5,2),
  recommend_suppress CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id),
  FOREIGN KEY (element_id, scale_id, category) REFERENCES ete_categories(element_id, scale_id, category));
/*! COMMIT */;
/*! START TRANSACTION */;

INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 1, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 2, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 3, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 4, 6.05, 27, 4.43, 1.28, 24.19, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 5, 4.23, 27, 4.27, 0.50, 27.80, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 6, 21.61, 27, 9.79, 7.76, 47.47, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 7, 13.66, 27, 8.42, 3.52, 40.70, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 8, 25.83, 27, 11.34, 9.35, 54.03, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 9, 19.23, 27, 16.21, 2.71, 67.05, 'Y', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 10, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 11, 9.39, 27, 6.68, 2.02, 34.26, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 12, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 1, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 2, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 3, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 4, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 5, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 6, 5.55, 27, 5.48, 0.68, 33.52, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 7, 12.75, 27, 8.16, 3.13, 39.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 8, 9.17, 27, 5.63, 2.46, 28.82, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 9, 28.17, 27, 11.44, 10.93, 55.63, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 10, 12.63, 27, 7.39, 3.52, 36.41, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 11, 31.74, 27, 9.93, 15.34, 54.40, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 1, 26.49, 27, 13.04, 8.34, 58.81, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 2, 3.24, 27, 3.28, 0.39, 22.32, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 3, 13.64, 27, 7.30, 4.23, 36.07, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 4, 0.43, 27, 0.45, 0.05, 3.55, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 5, 5.55, 27, 5.48, 0.68, 33.52, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 6, 19.36, 27, 9.34, 6.56, 45.07, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 7, 7.83, 27, 4.83, 2.10, 25.15, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 8, 13.85, 27, 8.54, 3.56, 41.17, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 9, 9.61, 27, 8.11, 1.54, 41.99, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 1, 36.53, 27, 11.81, 16.81, 62.12, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 2, 9.55, 27, 6.47, 2.22, 32.97, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 3, 12.50, 27, 8.23, 2.96, 40.14, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 4, 2.89, 27, 2.95, 0.34, 20.49, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 5, 14.38, 27, 7.08, 4.89, 35.40, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 6, 12.08, 27, 6.06, 4.08, 30.74, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 7, 7.83, 27, 4.83, 2.10, 25.15, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 8, 4.23, 27, 4.27, 0.50, 27.80, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 9, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 1, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 2, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 3, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 4, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 5, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 6, 42.31, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 7, 19.23, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 8, 30.77, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 9, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 10, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 11, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 12, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 1, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 2, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 3, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 4, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 5, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 6, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 7, 19.23, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 8, 15.38, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 9, 26.92, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 10, 15.38, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 11, 19.23, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 1, 15.38, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 2, 26.92, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 3, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 4, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 5, 11.54, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 6, 7.69, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 7, 11.54, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 8, 19.23, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 9, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 1, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 2, 19.23, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 3, 15.38, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 4, 11.54, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 5, 15.38, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 6, 7.69, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 7, 7.69, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 8, 15.38, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 9, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 1, 0.00, 55, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 2, 15.20, 55, 5.68, 6.90, 30.24, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 3, 9.00, 55, 7.37, 1.60, 37.56, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 4, 19.18, 55, 6.91, 8.85, 36.70, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 5, 8.59, 55, 4.24, 3.09, 21.71, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 6, 29.29, 55, 9.64, 14.01, 51.29, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 7, 14.58, 55, 7.77, 4.66, 37.35, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 8, 0.80, 55, 0.81, 0.10, 5.89, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 9, 3.37, 55, 3.20, 0.48, 20.02, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 10, 0.00, 55, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 11, 0.00, 55, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 12, 0.00, 55, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 1, 1.08, 54, 1.10, 0.14, 7.86, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 2, 0.00, 54, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 3, 0.00, 54, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 4, 0.00, 54, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 5, 5.09, 54, 4.58, 0.80, 26.38, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 6, 11.27, 54, 5.06, 4.40, 25.96, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 7, 22.06, 54, 8.78, 9.23, 44.07, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 8, 24.36, 54, 9.00, 10.78, 46.18, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 9, 8.65, 54, 4.52, 2.92, 22.95, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 10, 13.04, 54, 6.68, 4.39, 32.85, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 11, 14.44, 54, 7.77, 4.57, 37.32, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 1, 6.82, 54, 3.77, 2.18, 19.41, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 2, 27.29, 54, 9.39, 12.69, 49.24, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 3, 12.03, 54, 7.51, 3.19, 36.20, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 4, 15.58, 54, 6.95, 6.01, 34.74, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 5, 16.76, 54, 7.80, 6.16, 38.20, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 6, 11.53, 54, 5.41, 4.31, 27.40, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 7, 4.83, 54, 2.73, 1.52, 14.30, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 8, 4.84, 54, 4.14, 0.83, 23.57, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 9, 0.31, 54, 0.32, 0.04, 2.36, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 1, 3.68, 54, 2.99, 0.70, 17.16, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 2, 24.78, 54, 7.86, 12.39, 43.42, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 3, 8.56, 54, 3.74, 3.47, 19.61, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 4, 18.25, 54, 6.91, 8.11, 36.11, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 5, 30.95, 54, 8.09, 17.34, 48.93, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 6, 6.28, 54, 4.98, 1.21, 26.78, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 7, 2.68, 54, 2.18, 0.51, 12.86, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 8, 4.50, 54, 4.12, 0.68, 24.39, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 9, 0.31, 54, 0.32, 0.04, 2.36, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 1, 4.71, 24, 4.51, 0.62, 28.28, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 2, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 3, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 4, 13.57, 24, 8.00, 3.69, 39.15, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 5, 22.07, 24, 16.18, 3.89, 66.46, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 6, 54.30, 24, 14.47, 26.24, 79.87, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 7, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 8, 5.36, 24, 3.97, 1.11, 22.23, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 9, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 10, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 11, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 12, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 1, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 2, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 3, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 4, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 5, 5.00, 24, 3.38, 1.19, 18.68, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 6, 25.05, 24, 16.23, 5.29, 66.66, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 7, 41.06, 24, 14.42, 16.89, 70.49, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 8, 12.34, 24, 6.98, 3.57, 34.84, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 9, 11.58, 24, 6.58, 3.35, 33.11, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 10, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 11, 4.96, 24, 3.67, 1.04, 20.67, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 1, 16.35, 24, 8.41, 5.19, 41.09, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 2, 14.31, 24, 7.13, 4.77, 35.72, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 3, 18.25, 24, 8.63, 6.32, 42.48, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 4, 26.72, 24, 15.97, 6.32, 66.35, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 5, 11.98, 24, 7.12, 3.26, 35.50, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 6, 6.78, 24, 5.56, 1.17, 30.95, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 7, 0.90, 24, 0.93, 0.10, 7.27, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 8, 4.71, 24, 4.69, 0.57, 30.06, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 9, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 1, 6.95, 24, 5.01, 1.48, 27.04, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 2, 6.48, 24, 4.76, 1.34, 26.03, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 3, 26.41, 24, 10.65, 10.35, 52.72, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 4, 32.43, 24, 14.87, 10.54, 66.15, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 5, 15.37, 24, 7.10, 5.55, 35.95, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 6, 1.47, 24, 1.54, 0.16, 11.87, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 7, 6.19, 24, 4.60, 1.27, 25.35, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 8, 4.71, 24, 4.69, 0.57, 30.06, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 9, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 1, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 2, 3.53, 37, 3.56, 0.44, 23.40, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 3, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 4, 2.80, 37, 2.07, 0.61, 11.88, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 5, 3.03, 37, 2.06, 0.75, 11.48, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 6, 55.76, 37, 16.96, 23.82, 83.56, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 7, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 8, 24.36, 37, 9.60, 10.06, 48.09, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 9, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 10, 10.52, 37, 9.00, 1.66, 44.97, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 11, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 12, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 1, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 2, 1.43, 37, 1.46, 0.17, 10.69, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 3, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 4, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 5, 9.04, 37, 6.85, 1.80, 35.00, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 6, 7.23, 37, 4.34, 2.05, 22.44, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 7, 12.08, 37, 6.27, 3.99, 31.28, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 8, 18.80, 37, 8.06, 7.35, 40.33, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 9, 14.98, 37, 8.92, 4.08, 42.18, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 10, 33.99, 37, 10.86, 16.17, 57.87, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 11, 2.47, 37, 1.70, 0.60, 9.55, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 1, 33.95, 37, 9.41, 17.99, 54.63, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 2, 14.98, 37, 6.52, 5.87, 33.24, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 3, 32.96, 37, 10.19, 16.18, 55.60, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 4, 11.25, 37, 6.80, 3.09, 33.55, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 5, 5.71, 37, 3.27, 1.73, 17.20, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 6, 1.15, 37, 1.18, 0.14, 8.77, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 7, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 8, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 9, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 1, 2.40, 36, 2.44, 0.29, 16.94, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 2, 8.91, 36, 4.53, 3.06, 23.29, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 3, 52.82, 36, 11.25, 30.93, 73.68, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 4, 15.63, 36, 7.81, 5.27, 38.14, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 5, 9.71, 36, 4.34, 3.79, 22.71, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 6, 0.00, 36, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 7, 10.53, 36, 9.01, 1.66, 45.05, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 8, 0.00, 36, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 9, 0.00, 36, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 2, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 3, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 4, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 5, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 6, 57.14, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 7, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 8, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 10, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 11, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 12, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 2, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 3, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 4, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 5, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 6, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 7, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 8, 42.86, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 9, 23.81, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 10, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 11, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 1, 19.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 2, 33.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 3, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 4, 9.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 5, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 6, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 7, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 8, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 1, 9.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 2, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 3, 19.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 4, 19.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 5, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 6, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 7, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 8, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 1, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 2, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 3, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 4, 6.48, 36, 6.19, 0.86, 35.53, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 5, 7.43, 36, 7.05, 0.99, 39.12, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 6, 78.31, 36, 10.02, 52.15, 92.28, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 7, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 8, 7.79, 36, 6.32, 1.40, 33.49, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 9, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 10, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 11, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 12, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 1, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 2, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 3, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 4, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 5, 0.75, 36, 0.46, 0.22, 2.56, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 6, 5.44, 36, 5.04, 0.78, 29.60, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 7, 30.61, 36, 10.52, 13.90, 54.66, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 8, 24.10, 36, 10.93, 8.62, 51.64, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 9, 18.26, 36, 8.68, 6.42, 42.12, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 10, 5.09, 36, 3.75, 1.09, 20.62, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 11, 15.75, 36, 8.60, 4.78, 41.05, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 1, 42.57, 36, 10.26, 24.03, 63.47, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 2, 29.97, 36, 12.58, 11.25, 59.10, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 3, 8.61, 36, 5.54, 2.21, 28.22, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 4, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 5, 10.82, 36, 7.28, 2.56, 35.95, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 6, 0.38, 36, 0.39, 0.05, 2.97, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 7, 6.55, 36, 6.24, 0.88, 35.69, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 8, 1.10, 36, 1.11, 0.14, 8.12, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 9, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 1, 12.72, 36, 7.63, 3.48, 37.02, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 2, 28.77, 36, 8.09, 15.35, 47.36, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 3, 9.14, 36, 6.46, 2.03, 32.77, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 4, 5.52, 36, 5.04, 0.81, 29.38, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 5, 23.69, 36, 8.80, 10.36, 45.47, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 6, 6.48, 36, 6.19, 0.86, 35.53, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 7, 1.95, 36, 1.96, 0.25, 13.69, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 8, 11.74, 36, 7.69, 2.87, 37.50, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 9, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 1, 2.19, 37, 2.21, 0.27, 15.38, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 2, 18.73, 37, 7.97, 7.38, 39.99, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 3, 15.20, 37, 7.49, 5.23, 36.80, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 4, 13.40, 37, 6.80, 4.50, 33.68, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 5, 19.03, 37, 13.93, 3.62, 59.51, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 6, 27.95, 37, 8.83, 13.75, 48.57, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 7, 0.00, 37, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 8, 3.49, 37, 3.28, 0.50, 20.70, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 9, 0.00, 37, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 10, 0.00, 37, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 11, 0.00, 37, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 12, 0.00, 37, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 1, 13.66, 36, 7.50, 4.17, 36.52, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 2, 2.12, 36, 2.14, 0.27, 14.96, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 3, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 4, 0.22, 36, 0.23, 0.03, 1.78, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 5, 5.85, 36, 3.47, 1.70, 18.24, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 6, 34.87, 36, 14.01, 13.28, 65.20, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 7, 25.40, 36, 10.23, 10.22, 50.46, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 8, 11.79, 36, 5.86, 4.09, 29.54, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 9, 3.15, 36, 3.06, 0.42, 20.01, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 10, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 11, 2.94, 36, 2.88, 0.39, 19.03, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 1, 39.72, 36, 12.39, 18.73, 65.32, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 2, 12.05, 36, 6.73, 3.64, 33.22, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 3, 15.91, 36, 6.32, 6.76, 33.04, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 4, 6.53, 36, 4.07, 1.77, 21.27, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 5, 22.37, 36, 8.01, 10.15, 42.35, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 6, 3.15, 36, 3.06, 0.42, 19.92, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 7, 0.28, 36, 0.29, 0.03, 2.24, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 8, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 9, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 1, 8.30, 36, 4.93, 2.37, 25.22, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 2, 24.86, 36, 9.06, 11.00, 46.97, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 3, 33.98, 36, 13.67, 12.99, 63.95, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 4, 5.22, 36, 3.86, 1.12, 21.15, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 5, 27.36, 36, 8.32, 13.86, 46.84, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 6, 0.28, 36, 0.29, 0.03, 2.24, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 7, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 8, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 9, 0.00, 36, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 1, 0.00, 32, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 2, 0.00, 32, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 3, 0.00, 32, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 4, 2.50, 32, 1.86, 0.54, 10.82, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 5, 0.00, 32, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 6, 61.64, 32, 21.78, 19.71, 91.32, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 7, 0.00, 32, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 8, 35.87, 32, 22.21, 7.24, 80.03, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 9, 0.00, 32, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 10, 0.00, 32, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 11, 0.00, 32, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 12, 0.00, 32, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 1, 0.00, 32, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 2, 0.00, 32, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 3, 0.00, 32, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 4, 0.00, 32, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 5, 1.59, 32, 1.69, 0.18, 12.79, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 6, 1.11, 32, 0.92, 0.21, 5.80, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 7, 48.21, 32, 20.75, 14.60, 83.52, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 8, 18.31, 32, 9.56, 5.73, 45.22, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 9, 6.01, 32, 3.86, 1.56, 20.49, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 10, 23.03, 32, 18.46, 3.45, 71.45, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 11, 1.74, 32, 1.44, 0.32, 8.99, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 1, 4.72, 31, 2.98, 1.26, 16.11, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 2, 29.76, 31, 18.79, 6.33, 72.64, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 3, 33.80, 31, 22.95, 5.91, 80.58, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 4, 13.17, 31, 10.71, 2.19, 50.66, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 5, 7.21, 31, 4.37, 2.01, 22.80, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 6, 2.55, 31, 1.89, 0.55, 11.02, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 7, 8.79, 31, 7.31, 1.47, 38.28, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 8, 0.00, 31, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 9, 0.00, 31, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 1, 3.36, 32, 2.28, 0.82, 12.71, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 2, 4.71, 32, 3.00, 1.25, 16.19, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 3, 23.66, 32, 18.40, 3.74, 71.21, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 4, 5.76, 32, 3.78, 1.46, 20.18, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 5, 47.25, 32, 20.70, 14.13, 82.97, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 6, 12.04, 32, 7.95, 2.88, 38.74, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 7, 3.22, 32, 2.34, 0.72, 13.31, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 8, 0.00, 32, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 9, 0.00, 32, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 1, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 2, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 3, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 4, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 5, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 6, 36.67, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 7, 20.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 8, 43.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 9, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 10, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 11, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 12, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 1, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 2, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 3, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 4, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 5, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 6, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 7, 10.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 8, 20.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 9, 13.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 10, 23.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 11, 30.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 1, 50.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 2, 16.67, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 3, 13.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 4, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 5, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 6, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 7, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 8, 10.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 9, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 1, 20.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 2, 40.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 3, 10.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 4, 10.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 5, 13.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 6, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 7, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 8, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 9, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 1, 0.00, 31, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 2, 16.88, 31, 9.45, 4.88, 44.54, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 3, 1.75, 31, 1.83, 0.20, 13.56, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 4, 7.42, 31, 6.56, 1.13, 36.05, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 5, 3.42, 31, 2.49, 0.76, 14.14, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 6, 50.19, 31, 15.92, 21.53, 78.72, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 7, 6.43, 31, 5.95, 0.91, 34.08, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 8, 13.57, 31, 8.27, 3.59, 39.84, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 9, 0.00, 31, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 10, 0.35, 31, 0.36, 0.04, 2.84, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 11, 0.00, 31, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 12, 0.00, 31, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 1, 3.13, 31, 3.20, 0.37, 21.77, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 2, 0.00, 31, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 3, 0.00, 31, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 4, 6.43, 31, 6.33, 0.80, 37.04, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 5, 6.43, 31, 6.33, 0.80, 37.04, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 6, 1.06, 31, 0.82, 0.21, 5.07, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 7, 13.37, 31, 7.61, 3.88, 37.14, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 8, 22.15, 31, 9.49, 8.46, 46.67, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 9, 30.70, 31, 18.17, 7.19, 71.70, 'Y', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 10, 13.75, 31, 8.51, 3.55, 40.83, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 11, 2.98, 31, 2.23, 0.63, 12.96, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 1, 14.27, 31, 8.30, 4.00, 39.95, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 2, 32.42, 31, 17.68, 8.45, 71.38, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 3, 16.51, 31, 9.63, 4.53, 45.15, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 4, 13.61, 31, 6.86, 4.56, 34.16, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 5, 2.41, 31, 1.73, 0.55, 10.01, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 6, 6.43, 31, 6.47, 0.76, 38.15, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 7, 7.03, 31, 4.72, 1.71, 24.81, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 8, 7.32, 31, 6.54, 1.09, 36.14, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 9, 0.00, 31, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 1, 0.00, 31, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 2, 16.69, 31, 8.78, 5.23, 42.10, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 3, 46.93, 31, 16.39, 18.75, 77.22, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 4, 12.28, 31, 6.62, 3.84, 32.92, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 5, 8.75, 31, 6.60, 1.74, 34.19, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 6, 7.13, 31, 5.95, 1.21, 32.46, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 7, 1.78, 31, 1.54, 0.30, 9.93, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 8, 6.43, 31, 6.47, 0.76, 38.15, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 9, 0.00, 31, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 1, 0.62, 38, 0.63, 0.08, 4.71, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 2, 6.66, 38, 5.59, 1.14, 30.64, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 3, 2.55, 38, 2.51, 0.34, 16.87, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 4, 30.32, 38, 10.51, 13.70, 54.40, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 5, 15.11, 38, 9.53, 3.80, 44.50, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 6, 42.38, 38, 9.49, 25.08, 61.77, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 7, 0.00, 38, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 8, 2.37, 38, 1.94, 0.44, 11.70, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 9, 0.00, 38, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 10, 0.00, 38, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 11, 0.00, 38, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 12, 0.00, 38, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 1, 0.00, 37, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 2, 0.00, 37, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 3, 0.00, 37, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 4, 1.84, 37, 1.87, 0.23, 13.30, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 5, 8.38, 37, 5.04, 2.36, 25.70, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 6, 1.21, 37, 0.89, 0.27, 5.26, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 7, 30.79, 37, 10.37, 14.22, 54.41, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 8, 28.89, 37, 10.39, 12.71, 53.12, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 9, 12.95, 37, 6.47, 4.44, 32.27, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 10, 7.72, 37, 4.62, 2.20, 23.74, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 11, 8.23, 37, 4.34, 2.72, 22.34, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 1, 0.00, 38, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 2, 25.23, 38, 9.81, 10.53, 49.18, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 3, 15.00, 38, 7.00, 5.48, 34.93, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 4, 22.23, 38, 8.89, 9.16, 44.75, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 5, 6.96, 38, 3.86, 2.19, 20.03, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 6, 16.73, 38, 9.76, 4.63, 45.39, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 7, 9.74, 38, 5.00, 3.30, 25.46, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 8, 1.84, 38, 1.42, 0.38, 8.43, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 9, 2.27, 38, 2.31, 0.28, 16.06, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 1, 0.98, 38, 1.01, 0.12, 7.51, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 2, 12.38, 38, 6.64, 3.92, 32.83, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 3, 22.01, 38, 9.17, 8.73, 45.44, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 4, 13.61, 38, 6.58, 4.83, 32.86, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 5, 14.20, 38, 7.02, 4.89, 34.74, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 6, 28.41, 38, 9.73, 13.08, 51.13, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 7, 5.65, 38, 4.83, 0.95, 27.26, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 8, 2.76, 38, 2.02, 0.61, 11.56, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 9, 0.00, 38, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 1, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 2, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 3, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 4, 10.81, 17, 9.41, 1.51, 48.96, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 5, 1.12, 17, 1.17, 0.12, 9.61, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 6, 73.33, 17, 13.32, 39.36, 92.09, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 7, 3.75, 17, 3.84, 0.41, 27.06, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 8, 10.99, 17, 9.38, 1.59, 48.53, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 9, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 10, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 11, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 12, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 1, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 2, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 3, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 4, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 5, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 6, 1.12, 17, 1.18, 0.12, 9.75, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 7, 26.46, 17, 13.73, 7.46, 61.63, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 8, 48.42, 17, 16.75, 18.47, 79.56, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 9, 10.78, 17, 10.26, 1.24, 53.68, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 10, 13.21, 17, 11.38, 1.82, 55.52, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 11, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 1, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 2, 28.79, 17, 16.19, 7.04, 68.33, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 3, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 4, 28.07, 17, 16.50, 6.46, 68.81, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 5, 3.55, 17, 2.32, 0.87, 13.38, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 6, 25.37, 17, 13.20, 7.20, 59.85, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 7, 11.90, 17, 10.32, 1.65, 52.13, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 8, 2.32, 17, 1.77, 0.45, 11.03, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 9, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 1, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 2, 12.09, 17, 11.33, 1.41, 56.87, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 3, 15.57, 17, 13.98, 1.90, 63.71, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 4, 40.00, 17, 16.91, 13.02, 74.81, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 5, 11.93, 17, 9.45, 1.97, 47.68, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 6, 6.18, 17, 4.41, 1.30, 24.81, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 7, 13.03, 17, 10.39, 2.10, 51.16, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 8, 1.20, 17, 1.26, 0.13, 10.32, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 9, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 1, 0.00, 20, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 2, 11.15, 20, 7.24, 2.65, 36.68, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 3, 18.91, 20, 9.32, 6.14, 45.40, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 4, 47.61, 20, 14.85, 20.72, 75.97, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 5, 2.72, 20, 2.87, 0.29, 21.31, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 6, 14.61, 20, 12.34, 2.11, 57.57, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 7, 4.99, 20, 4.89, 0.60, 31.30, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 8, 0.00, 20, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 9, 0.00, 20, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 10, 0.00, 20, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 11, 0.00, 20, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 12, 0.00, 20, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 1, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 2, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 3, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 4, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 5, 11.46, 21, 5.96, 3.67, 30.57, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 6, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 7, 14.67, 21, 8.25, 4.17, 40.45, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 8, 19.57, 21, 8.72, 7.12, 43.58, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 9, 12.48, 21, 8.10, 2.94, 40.12, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 10, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 11, 41.82, 21, 12.78, 19.38, 68.26, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 1, 2.61, 21, 2.78, 0.27, 20.73, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 2, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 3, 9.56, 21, 5.58, 2.68, 28.87, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 4, 7.19, 21, 5.42, 1.41, 29.63, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 5, 23.73, 21, 9.63, 9.30, 48.57, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 6, 18.48, 21, 10.76, 4.86, 50.16, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 7, 2.61, 21, 2.78, 0.27, 20.73, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 8, 30.16, 21, 10.17, 13.62, 54.17, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 9, 5.66, 21, 4.41, 1.06, 25.16, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 1, 2.61, 21, 2.78, 0.27, 20.73, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 2, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 3, 6.81, 21, 5.36, 1.24, 29.85, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 4, 2.61, 21, 2.78, 0.27, 20.73, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 5, 30.54, 21, 6.65, 18.62, 45.81, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 6, 16.33, 21, 6.98, 6.30, 36.17, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 7, 15.02, 21, 8.81, 4.02, 42.74, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 8, 20.43, 21, 10.26, 6.44, 48.93, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 9, 5.66, 21, 4.41, 1.06, 25.16, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 1, 0.00, 49, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 2, 10.75, 49, 9.40, 1.65, 46.36, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 3, 1.95, 49, 1.18, 0.57, 6.45, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 4, 0.55, 49, 0.43, 0.11, 2.64, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 5, 22.13, 49, 10.36, 7.82, 48.78, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 6, 64.06, 49, 12.03, 38.41, 83.60, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 7, 0.28, 49, 0.29, 0.03, 2.29, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 8, 0.28, 49, 0.29, 0.03, 2.21, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 9, 0.00, 49, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 10, 0.00, 49, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 11, 0.00, 49, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 12, 0.00, 49, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 1, 10.19, 49, 9.54, 1.38, 47.98, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 2, 0.00, 49, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 3, 0.00, 49, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 4, 0.00, 49, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 5, 10.19, 49, 9.39, 1.42, 47.15, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 6, 0.55, 49, 0.43, 0.12, 2.62, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 7, 20.94, 49, 12.80, 5.30, 55.62, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 8, 13.78, 49, 9.68, 3.01, 45.12, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 9, 11.87, 49, 8.60, 2.51, 41.31, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 10, 20.38, 49, 11.07, 6.09, 50.24, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 11, 12.09, 49, 8.25, 2.81, 39.56, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 1, 10.19, 49, 8.40, 1.76, 41.81, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 2, 21.62, 49, 12.20, 6.09, 53.98, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 3, 10.19, 49, 9.54, 1.38, 47.98, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 4, 13.21, 49, 9.67, 2.72, 45.36, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 5, 2.38, 49, 1.14, 0.90, 6.16, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 6, 1.11, 49, 0.66, 0.33, 3.61, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 7, 30.27, 49, 14.74, 9.64, 63.86, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 8, 0.55, 49, 0.43, 0.11, 2.64, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 9, 10.47, 49, 8.37, 1.90, 41.34, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 1, 9.92, 49, 8.43, 1.62, 42.32, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 2, 0.55, 49, 0.43, 0.11, 2.63, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 3, 11.30, 49, 9.42, 1.89, 45.74, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 4, 33.61, 49, 14.60, 11.96, 65.36, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 5, 10.72, 49, 9.54, 1.59, 47.09, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 6, 1.39, 49, 0.76, 0.46, 4.13, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 7, 31.13, 49, 12.48, 12.30, 59.29, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 8, 1.39, 49, 0.76, 0.45, 4.15, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 9, 0.00, 49, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 4, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 5, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 6, 75.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 7, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 8, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 10, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 11, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 12, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 4, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 6, 12.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 7, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 8, 25.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 9, 29.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 10, 20.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 11, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 1, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 2, 25.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 3, 25.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 4, 16.67, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 5, 16.67, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 6, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 8, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 1, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 2, 41.67, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 3, 12.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 4, 16.67, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 5, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 6, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 8, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 1, 0.00, 35, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 2, 34.21, 35, 9.42, 18.17, 54.90, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 3, 0.00, 35, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 4, 1.05, 35, 1.06, 0.13, 7.80, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 5, 23.95, 35, 8.97, 10.37, 46.16, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 6, 40.79, 35, 10.83, 21.68, 63.16, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 7, 0.00, 35, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 8, 0.00, 35, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 9, 0.00, 35, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 10, 0.00, 35, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 11, 0.00, 35, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 12, 0.00, 35, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 1, 5.54, 35, 5.20, 0.77, 30.65, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 2, 0.00, 35, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 3, 7.56, 35, 5.12, 1.81, 26.62, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 4, 0.00, 35, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 5, 6.28, 35, 4.88, 1.22, 26.56, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 6, 7.02, 35, 3.63, 2.38, 18.97, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 7, 26.94, 35, 10.33, 11.26, 51.72, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 8, 24.65, 35, 8.66, 11.26, 45.77, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 9, 12.55, 35, 6.94, 3.82, 34.17, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 10, 3.74, 35, 3.28, 0.61, 19.81, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 11, 5.71, 35, 3.94, 1.35, 21.13, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 1, 16.20, 35, 7.14, 6.22, 36.01, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 2, 29.70, 35, 10.27, 13.46, 53.43, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 3, 16.20, 35, 6.92, 6.42, 35.26, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 4, 4.99, 35, 3.39, 1.21, 18.33, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 5, 14.62, 35, 7.24, 5.01, 35.74, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 6, 8.67, 35, 5.52, 2.25, 28.15, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 7, 5.47, 35, 3.55, 1.42, 18.94, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 8, 1.88, 35, 1.84, 0.25, 12.74, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 9, 2.29, 35, 2.31, 0.28, 16.10, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 1, 9.70, 35, 6.06, 2.57, 30.45, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 2, 13.61, 35, 6.48, 4.89, 32.56, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 3, 32.19, 35, 11.40, 14.10, 57.85, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 4, 22.20, 35, 8.45, 9.55, 43.53, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 5, 9.31, 35, 4.92, 3.04, 25.14, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 6, 6.08, 35, 5.20, 1.01, 29.14, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 7, 4.62, 35, 3.43, 0.99, 19.09, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 8, 0.00, 35, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 9, 2.29, 35, 2.31, 0.28, 16.10, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 2, 20.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 4, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 5, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 6, 58.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 7, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 10, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 11, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 12, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 2, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 4, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 5, 12.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 6, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 7, 16.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 8, 33.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 9, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 10, 12.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 11, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 1, 12.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 2, 33.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 3, 20.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 4, 12.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 6, 12.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 7, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 9, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 1, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 2, 20.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 3, 29.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 4, 20.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 5, 12.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 6, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 8, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '2.D.1', 'RL', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '2.D.1', 'RL', 2, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '2.D.1', 'RL', 3, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '2.D.1', 'RL', 4, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '2.D.1', 'RL', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '2.D.1', 'RL', 6, 73.91, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '2.D.1', 'RL', 7, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '2.D.1', 'RL', 8, 8.70, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '2.D.1', 'RL', 9, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '2.D.1', 'RL', 10, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '2.D.1', 'RL', 11, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '2.D.1', 'RL', 12, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.1', 'RW', 1, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.1', 'RW', 2, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.1', 'RW', 3, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.1', 'RW', 4, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.1', 'RW', 5, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.1', 'RW', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.1', 'RW', 7, 21.74, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.1', 'RW', 8, 43.48, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.1', 'RW', 9, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.1', 'RW', 10, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.1', 'RW', 11, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.2', 'PT', 1, 8.70, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.2', 'PT', 2, 39.13, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.2', 'PT', 3, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.2', 'PT', 4, 8.70, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.2', 'PT', 5, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.2', 'PT', 6, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.2', 'PT', 7, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.2', 'PT', 8, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.2', 'PT', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.3', 'OJ', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.3', 'OJ', 2, 21.74, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.3', 'OJ', 3, 21.74, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.3', 'OJ', 4, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.3', 'OJ', 5, 17.39, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.3', 'OJ', 6, 17.39, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.3', 'OJ', 7, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.3', 'OJ', 8, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '3.A.3', 'OJ', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 2, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 3, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 4, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 5, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 6, 71.43, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 7, 19.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 8, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 10, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 11, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 12, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 2, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 3, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 4, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 5, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 7, 9.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 8, 28.57, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 9, 28.57, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 10, 19.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 11, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 1, 33.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 2, 19.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 3, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 4, 9.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 5, 23.81, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 7, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 8, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 1, 33.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 2, 23.81, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 3, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 4, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 5, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 7, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 8, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 3, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 4, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 5, 4.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 6, 68.18, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 7, 9.09, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 8, 18.18, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 10, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 11, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 3, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 4, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 5, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 6, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 8, 59.09, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 9, 31.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 10, 4.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 11, 4.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 1, 31.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 2, 22.73, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 3, 22.73, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 4, 4.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 5, 9.09, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 6, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 7, 4.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 8, 4.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 1, 27.27, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 2, 31.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 3, 13.64, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 4, 9.09, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 5, 18.18, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 6, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 8, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 4, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 5, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 6, 62.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 7, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 8, 20.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 10, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 11, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 12, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 4, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 6, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 7, 29.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 8, 29.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 9, 20.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 10, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 11, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 1, 20.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 2, 12.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 3, 29.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 4, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 5, 20.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 6, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 8, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 1, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 2, 20.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 3, 33.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 4, 16.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 5, 20.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 6, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 1, 0.00, 24, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 2, 4.16, 24, 3.58, 0.68, 21.71, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 3, 8.82, 24, 5.99, 2.03, 31.12, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 4, 18.50, 24, 13.83, 3.29, 60.22, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 5, 23.84, 24, 14.11, 5.90, 60.98, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 6, 44.67, 24, 15.95, 17.53, 75.41, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 7, 0.00, 24, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 8, 0.00, 24, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 9, 0.00, 24, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 10, 0.00, 24, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 11, 0.00, 24, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 12, 0.00, 24, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 1, 0.00, 24, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 2, 1.63, 24, 1.69, 0.19, 12.85, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 3, 0.00, 24, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 4, 2.27, 24, 2.26, 0.28, 16.01, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 5, 3.58, 24, 2.88, 0.66, 17.30, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 6, 3.71, 24, 3.52, 0.50, 22.82, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 7, 46.98, 24, 16.36, 18.55, 77.52, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 8, 15.74, 24, 10.91, 3.29, 50.60, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 9, 15.27, 24, 13.90, 1.92, 62.46, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 10, 5.36, 24, 4.74, 0.81, 28.13, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 11, 5.47, 24, 3.38, 1.47, 18.28, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 1, 21.16, 24, 14.01, 4.51, 60.40, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 2, 10.25, 24, 4.88, 3.68, 25.49, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 3, 1.57, 24, 1.62, 0.18, 12.24, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 4, 26.53, 24, 15.58, 6.47, 65.36, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 5, 10.01, 24, 8.67, 1.50, 44.91, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 6, 6.32, 24, 4.89, 1.21, 27.14, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 7, 23.78, 24, 14.09, 5.88, 60.90, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 8, 0.37, 24, 0.39, 0.04, 3.11, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 9, 0.00, 24, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 1, 0.00, 24, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 2, 6.52, 24, 4.01, 1.76, 21.38, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 3, 3.62, 24, 3.64, 0.43, 24.49, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 4, 29.29, 24, 15.45, 8.13, 65.97, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 5, 27.45, 24, 15.05, 7.35, 64.36, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 6, 9.91, 24, 6.26, 2.51, 31.94, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 7, 21.22, 24, 14.07, 4.51, 60.57, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 8, 0.37, 24, 0.39, 0.04, 3.11, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 9, 1.63, 24, 1.69, 0.19, 12.85, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '2.D.1', 'RL', 1, 1.01, 24, 0.92, 0.15, 6.40, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '2.D.1', 'RL', 2, 29.51, 24, 17.18, 7.05, 69.79, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '2.D.1', 'RL', 3, 27.30, 24, 16.62, 6.23, 67.98, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '2.D.1', 'RL', 4, 2.91, 24, 2.25, 0.57, 13.43, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '2.D.1', 'RL', 5, 1.54, 24, 1.07, 0.36, 6.31, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '2.D.1', 'RL', 6, 37.55, 24, 19.58, 9.65, 77.18, 'Y', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '2.D.1', 'RL', 7, 0.19, 24, 0.20, 0.02, 1.70, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '2.D.1', 'RL', 8, 0.00, 24, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '2.D.1', 'RL', 9, 0.00, 24, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '2.D.1', 'RL', 10, 0.00, 24, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '2.D.1', 'RL', 11, 0.00, 24, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '2.D.1', 'RL', 12, 0.00, 24, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.1', 'RW', 1, 18.76, 24, 15.60, 2.70, 65.73, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.1', 'RW', 2, 0.00, 24, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.1', 'RW', 3, 0.19, 24, 0.20, 0.02, 1.69, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.1', 'RW', 4, 8.91, 24, 8.69, 1.06, 47.28, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.1', 'RW', 5, 1.90, 24, 1.91, 0.23, 13.95, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.1', 'RW', 6, 7.55, 24, 7.17, 0.97, 40.60, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.1', 'RW', 7, 24.43, 24, 15.61, 5.33, 65.01, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.1', 'RW', 8, 1.01, 24, 0.91, 0.15, 6.29, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.1', 'RW', 9, 18.31, 24, 16.25, 2.31, 67.97, 'Y', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.1', 'RW', 10, 0.00, 24, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.1', 'RW', 11, 18.94, 24, 15.58, 2.78, 65.60, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.2', 'PT', 1, 4.57, 24, 2.84, 1.23, 15.56, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.2', 'PT', 2, 24.32, 24, 16.95, 4.56, 68.35, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.2', 'PT', 3, 17.74, 24, 16.25, 2.11, 68.35, 'Y', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.2', 'PT', 4, 0.76, 24, 0.65, 0.13, 4.41, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.2', 'PT', 5, 14.17, 24, 9.59, 3.13, 45.77, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.2', 'PT', 6, 36.65, 24, 18.54, 9.98, 75.11, 'Y', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.2', 'PT', 7, 0.78, 24, 0.68, 0.13, 4.65, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.2', 'PT', 8, 0.00, 24, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.2', 'PT', 9, 1.01, 24, 1.07, 0.11, 8.46, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.3', 'OJ', 1, 0.19, 24, 0.20, 0.02, 1.68, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.3', 'OJ', 2, 25.52, 24, 16.99, 5.12, 68.53, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.3', 'OJ', 3, 1.66, 24, 1.58, 0.23, 11.09, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.3', 'OJ', 4, 0.19, 24, 0.20, 0.02, 1.69, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.3', 'OJ', 5, 17.03, 24, 10.63, 4.15, 49.33, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.3', 'OJ', 6, 54.22, 24, 19.10, 19.43, 85.33, 'Y', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.3', 'OJ', 7, 0.19, 24, 0.20, 0.02, 1.68, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.3', 'OJ', 8, 0.00, 24, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.02', '3.A.3', 'OJ', 9, 1.01, 24, 1.07, 0.11, 8.46, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 1, 0.00, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 2, 3.23, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 3, 0.00, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 4, 6.45, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 5, 3.23, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 6, 48.39, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 7, 9.68, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 8, 22.58, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 9, 0.00, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 10, 0.00, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 11, 6.45, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 12, 0.00, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 1, 3.23, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 2, 0.00, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 3, 0.00, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 4, 0.00, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 5, 6.45, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 6, 16.13, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 7, 25.81, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 8, 25.81, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 9, 9.68, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 10, 3.23, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 11, 9.68, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 1, 19.35, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 2, 22.58, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 3, 12.90, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 4, 9.68, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 5, 22.58, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 6, 3.23, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 7, 6.45, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 8, 0.00, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 9, 3.23, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 1, 6.45, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 2, 12.90, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 3, 19.35, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 4, 9.68, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 5, 29.03, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 6, 9.68, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 7, 9.68, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 8, 0.00, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 9, 3.23, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 1, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 2, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 3, 4.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 4, 12.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 5, 4.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 6, 76.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 7, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 8, 4.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 9, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 10, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 11, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 12, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 1, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 2, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 3, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 4, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 5, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 6, 4.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 7, 4.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 8, 36.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 9, 20.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 10, 8.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 11, 28.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 1, 12.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 2, 8.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 3, 8.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 4, 8.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 5, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 6, 12.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 7, 16.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 8, 28.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 9, 8.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 1, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 2, 8.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 3, 20.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 4, 12.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 5, 4.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 6, 16.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 7, 20.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 8, 16.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 9, 4.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 1, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 2, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 3, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 4, 6.62, 22, 5.82, 0.99, 33.41, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 5, 24.00, 22, 13.73, 6.19, 60.19, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 6, 63.36, 22, 14.34, 32.37, 86.20, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 7, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 8, 4.01, 22, 2.56, 1.04, 14.29, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 9, 2.00, 22, 1.51, 0.41, 9.21, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 10, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 11, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 12, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 1, 13.66, 22, 11.53, 2.03, 54.72, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 2, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 3, 4.21, 22, 4.30, 0.47, 28.82, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 4, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 5, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 6, 39.71, 22, 14.75, 15.46, 70.33, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 7, 29.19, 22, 14.03, 9.13, 62.84, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 8, 10.46, 22, 5.76, 3.15, 29.54, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 9, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 10, 1.76, 22, 1.80, 0.21, 13.46, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 11, 1.03, 22, 1.06, 0.12, 8.36, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 1, 18.95, 22, 11.90, 4.46, 53.93, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 2, 28.68, 22, 12.90, 9.77, 59.89, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 3, 14.73, 22, 11.43, 2.54, 53.39, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 4, 10.15, 22, 6.52, 2.49, 33.31, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 5, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 6, 14.11, 22, 9.94, 2.89, 47.50, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 7, 13.38, 22, 11.30, 1.99, 54.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 8, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 9, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 1, 13.66, 22, 11.40, 2.07, 54.15, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 2, 24.00, 22, 12.58, 7.00, 57.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 3, 26.05, 22, 12.88, 8.06, 58.60, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 4, 3.88, 22, 2.89, 0.80, 16.83, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 5, 20.00, 22, 11.23, 5.49, 51.82, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 6, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 7, 12.41, 22, 11.31, 1.60, 55.23, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 8, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 9, 0.00, 22, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 1, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 2, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 3, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 4, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 5, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 6, 8.68, 29, 6.96, 1.55, 36.50, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 7, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 8, 62.96, 29, 11.76, 37.70, 82.68, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 9, 21.47, 29, 9.20, 8.21, 45.53, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 10, 6.89, 29, 6.58, 0.90, 37.68, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 11, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 12, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 1, 8.68, 29, 6.96, 1.55, 36.50, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 2, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 3, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 4, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 5, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 6, 8.65, 29, 6.96, 1.53, 36.50, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 7, 11.59, 29, 4.48, 5.08, 24.31, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 8, 35.52, 29, 9.02, 19.74, 55.23, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 9, 8.24, 29, 6.13, 1.67, 32.11, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 10, 11.90, 29, 7.17, 3.22, 35.39, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 11, 15.43, 29, 8.22, 4.78, 39.88, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 1, 32.33, 29, 10.15, 15.59, 55.26, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 2, 12.17, 29, 7.24, 3.34, 35.69, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 3, 6.54, 29, 6.01, 0.93, 34.39, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 4, 17.42, 29, 8.09, 6.26, 40.02, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 5, 9.96, 29, 6.89, 2.24, 34.78, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 6, 13.46, 29, 7.28, 4.14, 35.90, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 7, 1.53, 29, 1.56, 0.19, 11.40, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 8, 6.59, 29, 6.32, 0.86, 36.59, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 9, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 1, 19.61, 29, 9.57, 6.57, 45.82, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 2, 18.90, 29, 9.58, 6.09, 45.59, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 3, 17.86, 29, 7.99, 6.65, 39.88, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 4, 11.89, 29, 6.47, 3.67, 32.36, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 5, 3.49, 29, 2.54, 0.77, 14.47, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 6, 20.30, 29, 9.10, 7.45, 44.62, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 7, 1.36, 29, 1.37, 0.17, 10.12, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 8, 6.59, 29, 6.32, 0.86, 36.59, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 9, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 1, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 2, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 3, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 4, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 5, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 6, 23.13, 29, 11.17, 7.67, 52.16, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 7, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 8, 53.80, 29, 16.70, 22.72, 82.19, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 9, 0.81, 29, 0.88, 0.09, 7.17, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 10, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 11, 22.26, 29, 13.59, 5.42, 58.87, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 12, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 1, 0.81, 29, 0.82, 0.10, 6.21, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 2, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 3, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 4, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 5, 2.47, 29, 2.39, 0.33, 16.21, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 6, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 7, 8.41, 29, 4.62, 2.62, 23.87, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 8, 48.68, 29, 16.64, 19.51, 78.78, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 9, 25.05, 29, 13.84, 6.88, 60.20, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 10, 9.41, 29, 8.04, 1.48, 41.74, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 11, 5.17, 29, 4.98, 0.68, 30.39, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 1, 24.19, 29, 12.14, 7.60, 55.34, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 2, 28.19, 29, 16.72, 6.74, 68.06, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 3, 13.93, 29, 12.55, 1.86, 58.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 4, 4.12, 29, 2.96, 0.92, 16.60, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 5, 8.33, 29, 4.16, 2.89, 21.72, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 6, 7.96, 29, 4.63, 2.32, 24.01, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 7, 8.59, 29, 7.98, 1.16, 43.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 8, 4.69, 29, 4.01, 0.77, 23.65, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 9, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 1, 25.26, 29, 12.83, 7.75, 57.63, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 2, 1.63, 29, 1.25, 0.33, 7.57, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 3, 26.03, 29, 14.68, 6.87, 62.66, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 4, 20.52, 29, 13.07, 4.76, 57.14, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 5, 14.27, 29, 7.16, 4.78, 35.57, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 6, 8.42, 29, 4.56, 2.66, 23.60, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 7, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 8, 0.00, 29, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 9, 3.88, 29, 3.91, 0.47, 25.65, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '2.D.1', 'RL', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '2.D.1', 'RL', 3, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '2.D.1', 'RL', 4, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '2.D.1', 'RL', 5, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '2.D.1', 'RL', 6, 27.27, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '2.D.1', 'RL', 7, 4.55, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '2.D.1', 'RL', 8, 63.64, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '2.D.1', 'RL', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '2.D.1', 'RL', 10, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '2.D.1', 'RL', 11, 4.55, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.1', 'RW', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.1', 'RW', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.1', 'RW', 3, 4.55, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.1', 'RW', 4, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.1', 'RW', 5, 4.55, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.1', 'RW', 6, 18.18, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.1', 'RW', 7, 45.45, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.1', 'RW', 8, 18.18, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.1', 'RW', 9, 9.09, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.1', 'RW', 10, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.1', 'RW', 11, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.2', 'PT', 1, 9.09, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.2', 'PT', 2, 9.09, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.2', 'PT', 3, 22.73, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.2', 'PT', 4, 22.73, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.2', 'PT', 5, 22.73, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.2', 'PT', 6, 9.09, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.2', 'PT', 7, 4.55, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.2', 'PT', 8, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.2', 'PT', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.3', 'OJ', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.3', 'OJ', 2, 13.64, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.3', 'OJ', 3, 22.73, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.3', 'OJ', 4, 18.18, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.3', 'OJ', 5, 45.45, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.3', 'OJ', 6, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.3', 'OJ', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.3', 'OJ', 8, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.01', '3.A.3', 'OJ', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '2.D.1', 'RL', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '2.D.1', 'RL', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '2.D.1', 'RL', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '2.D.1', 'RL', 4, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '2.D.1', 'RL', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '2.D.1', 'RL', 6, 70.83, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '2.D.1', 'RL', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '2.D.1', 'RL', 8, 29.17, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '2.D.1', 'RL', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '2.D.1', 'RL', 10, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '2.D.1', 'RL', 11, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '2.D.1', 'RL', 12, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.1', 'RW', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.1', 'RW', 4, 4.17, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.1', 'RW', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.1', 'RW', 6, 25.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.1', 'RW', 7, 33.33, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.1', 'RW', 8, 29.17, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.1', 'RW', 9, 4.17, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.1', 'RW', 10, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.1', 'RW', 11, 4.17, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.2', 'PT', 1, 16.67, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.2', 'PT', 2, 37.50, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.2', 'PT', 3, 29.17, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.2', 'PT', 4, 8.33, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.2', 'PT', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.2', 'PT', 6, 8.33, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.2', 'PT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.2', 'PT', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.3', 'OJ', 1, 16.67, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.3', 'OJ', 2, 12.50, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.3', 'OJ', 3, 33.33, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.3', 'OJ', 4, 20.83, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.3', 'OJ', 5, 16.67, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.3', 'OJ', 6, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.3', 'OJ', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.3', 'OJ', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9039.02', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 1, 0.00, 42, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 2, 0.00, 42, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 3, 0.00, 42, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 4, 0.00, 42, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 5, 1.64, 42, 1.63, 0.22, 11.39, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 6, 57.18, 42, 8.84, 39.18, 73.46, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 7, 9.20, 42, 5.38, 2.69, 27.11, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 8, 31.97, 42, 9.64, 16.10, 53.50, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 9, 0.00, 42, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 10, 0.00, 42, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 11, 0.00, 42, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 12, 0.00, 42, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 1, 0.47, 42, 0.48, 0.06, 3.72, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 2, 0.00, 42, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 3, 0.00, 42, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 4, 0.00, 42, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 5, 0.00, 42, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 6, 1.84, 42, 1.89, 0.23, 13.37, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 7, 18.15, 42, 8.68, 6.38, 41.92, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 8, 7.07, 42, 3.79, 2.32, 19.61, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 9, 12.38, 42, 5.20, 5.09, 27.10, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 10, 5.17, 42, 3.21, 1.43, 16.99, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 11, 54.93, 42, 8.18, 38.47, 70.38, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 1, 14.46, 42, 8.23, 4.22, 39.32, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 2, 20.13, 42, 10.36, 6.42, 48.08, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 3, 7.92, 42, 3.87, 2.87, 20.06, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 4, 1.77, 42, 1.32, 0.39, 7.67, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 5, 10.71, 42, 4.68, 4.27, 24.35, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 6, 17.78, 42, 9.69, 5.37, 45.19, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 7, 2.29, 42, 2.30, 0.29, 15.74, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 8, 22.70, 42, 8.23, 10.23, 43.08, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 9, 2.24, 42, 2.24, 0.29, 15.28, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 1, 0.00, 42, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 2, 10.78, 42, 4.96, 4.09, 25.49, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 3, 4.80, 42, 2.49, 1.65, 13.15, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 4, 6.28, 42, 4.88, 1.24, 26.33, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 5, 43.59, 42, 9.66, 25.89, 63.08, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 6, 11.38, 42, 4.96, 4.54, 25.73, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 7, 14.43, 42, 8.16, 4.25, 39.05, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 8, 7.10, 42, 4.94, 1.66, 25.74, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 9, 1.64, 42, 1.63, 0.22, 11.39, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 1, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 2, 1.33, 33, 1.40, 0.15, 10.58, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 3, 4.77, 33, 4.68, 0.61, 28.98, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 4, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 5, 5.82, 33, 4.80, 1.03, 26.91, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 6, 55.44, 33, 15.95, 25.03, 82.25, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 7, 1.24, 33, 1.32, 0.14, 10.16, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 8, 28.62, 33, 14.40, 8.71, 62.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 9, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 10, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 11, 1.33, 33, 1.42, 0.15, 10.84, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 12, 1.43, 33, 1.23, 0.25, 7.93, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 1, 1.33, 33, 1.40, 0.15, 10.58, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 2, 1.57, 33, 1.67, 0.18, 12.55, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 3, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 4, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 5, 7.16, 33, 5.28, 1.51, 27.98, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 6, 4.77, 33, 4.43, 0.68, 26.77, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 7, 54.02, 33, 15.90, 24.18, 81.24, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 8, 5.29, 33, 3.87, 1.15, 21.20, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 9, 2.00, 33, 1.81, 0.31, 11.77, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 10, 4.50, 33, 3.50, 0.89, 19.88, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 11, 19.35, 33, 13.31, 4.06, 57.67, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 1, 17.45, 33, 7.58, 6.75, 38.16, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 2, 13.28, 33, 6.97, 4.27, 34.43, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 3, 26.16, 33, 12.98, 8.27, 58.19, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 4, 15.25, 33, 9.89, 3.65, 46.08, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 5, 18.00, 33, 9.80, 5.37, 45.90, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 6, 7.96, 33, 4.35, 2.51, 22.47, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 7, 0.38, 33, 0.40, 0.04, 3.25, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 8, 1.54, 33, 1.61, 0.18, 12.02, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 9, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 1, 1.10, 33, 1.17, 0.12, 9.07, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 2, 13.99, 33, 5.95, 5.60, 30.82, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 3, 28.79, 33, 9.39, 13.72, 50.68, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 4, 32.90, 33, 9.68, 16.71, 54.50, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 5, 3.44, 33, 2.30, 0.87, 12.71, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 6, 4.89, 33, 2.96, 1.38, 15.83, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 7, 14.90, 33, 12.96, 2.14, 58.40, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 8, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 9, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 1, 29.73, 23, 12.45, 10.95, 59.28, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 2, 28.17, 23, 11.64, 10.63, 56.38, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 3, 7.45, 23, 5.95, 1.32, 32.55, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 4, 14.47, 23, 8.75, 3.76, 42.31, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 5, 8.84, 23, 6.29, 1.88, 32.86, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 6, 11.34, 23, 10.55, 1.43, 52.99, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 7, 0.00, 23, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 8, 0.00, 23, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 9, 0.00, 23, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 10, 0.00, 23, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 11, 0.00, 23, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 12, 0.00, 23, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 1, 14.93, 23, 10.62, 3.00, 49.85, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 2, 18.37, 23, 12.13, 4.04, 54.64, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 3, 0.00, 23, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 4, 9.80, 23, 6.91, 2.11, 35.45, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 5, 17.13, 23, 9.32, 5.03, 44.65, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 6, 31.00, 23, 11.75, 12.58, 58.39, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 7, 0.35, 23, 0.29, 0.06, 1.93, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 8, 1.42, 23, 1.45, 0.17, 10.94, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 9, 5.17, 23, 5.06, 0.64, 31.68, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 10, 1.82, 23, 1.84, 0.22, 13.62, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 11, 0.00, 23, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 1, 15.37, 23, 10.93, 3.08, 50.93, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 2, 25.71, 23, 11.92, 8.66, 55.80, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 3, 13.09, 23, 7.27, 3.85, 36.17, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 4, 16.67, 23, 9.55, 4.58, 45.44, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 5, 18.05, 23, 10.67, 4.70, 49.57, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 6, 5.63, 23, 5.08, 0.82, 30.19, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 7, 3.67, 23, 3.74, 0.42, 25.48, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 8, 1.82, 23, 1.84, 0.22, 13.62, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 9, 0.00, 23, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 1, 18.97, 23, 12.04, 4.41, 54.31, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 2, 48.41, 23, 13.24, 23.81, 73.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 3, 5.76, 23, 5.74, 0.68, 35.38, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 4, 13.19, 23, 6.94, 4.15, 34.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 5, 6.22, 23, 3.84, 1.66, 20.64, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 6, 0.46, 23, 0.35, 0.10, 2.15, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 7, 0.00, 23, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 8, 6.99, 23, 5.37, 1.33, 29.45, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 9, 0.00, 23, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '2.D.1', 'RL', 1, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '2.D.1', 'RL', 2, 7.99, 18, 7.61, 0.97, 43.56, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '2.D.1', 'RL', 3, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '2.D.1', 'RL', 4, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '2.D.1', 'RL', 5, 57.28, 18, 15.01, 26.88, 83.02, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '2.D.1', 'RL', 6, 12.49, 18, 11.53, 1.52, 56.92, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '2.D.1', 'RL', 7, 9.49, 18, 9.09, 1.11, 49.43, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '2.D.1', 'RL', 8, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '2.D.1', 'RL', 9, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '2.D.1', 'RL', 10, 12.75, 18, 11.52, 1.62, 56.48, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '2.D.1', 'RL', 11, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '2.D.1', 'RL', 12, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.1', 'RW', 1, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.1', 'RW', 2, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.1', 'RW', 3, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.1', 'RW', 4, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.1', 'RW', 5, 8.28, 18, 7.62, 1.08, 42.83, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.1', 'RW', 6, 54.60, 18, 13.64, 27.37, 79.34, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.1', 'RW', 7, 24.63, 18, 15.80, 5.15, 66.31, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.1', 'RW', 8, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.1', 'RW', 9, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.1', 'RW', 10, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.1', 'RW', 11, 12.49, 18, 12.49, 1.26, 61.41, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.2', 'PT', 1, 20.84, 18, 14.48, 3.97, 62.66, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.2', 'PT', 2, 16.49, 18, 12.87, 2.68, 58.64, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.2', 'PT', 3, 12.49, 18, 11.53, 1.52, 56.92, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.2', 'PT', 4, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.2', 'PT', 5, 10.72, 18, 8.03, 2.00, 41.35, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.2', 'PT', 6, 38.67, 18, 14.32, 14.99, 69.27, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.2', 'PT', 7, 0.80, 18, 0.59, 0.17, 3.70, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.2', 'PT', 8, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.2', 'PT', 9, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.3', 'OJ', 1, 11.35, 18, 11.52, 1.13, 58.92, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.3', 'OJ', 2, 2.15, 18, 1.91, 0.32, 12.97, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.3', 'OJ', 3, 20.48, 18, 12.92, 4.61, 57.86, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.3', 'OJ', 4, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.3', 'OJ', 5, 29.82, 18, 16.62, 7.37, 69.41, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.3', 'OJ', 6, 33.81, 18, 13.90, 12.11, 65.44, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.3', 'OJ', 7, 2.40, 18, 1.93, 0.43, 12.29, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.3', 'OJ', 8, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9061.00', '3.A.3', 'OJ', 9, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 1, 7.99, 30, 5.65, 1.77, 29.47, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 2, 34.91, 30, 10.95, 16.68, 58.98, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 3, 9.81, 30, 5.05, 3.28, 25.88, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 4, 7.02, 30, 4.38, 1.87, 22.97, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 5, 8.46, 30, 6.88, 1.48, 36.27, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 6, 31.81, 30, 10.34, 14.97, 55.29, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 7, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 8, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 9, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 10, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 11, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 12, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 1, 6.32, 30, 6.51, 0.71, 38.96, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 2, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 3, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 4, 1.65, 30, 1.67, 0.21, 12.01, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 5, 3.71, 30, 3.27, 0.59, 20.03, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 6, 12.82, 30, 5.72, 4.91, 29.53, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 7, 26.33, 30, 8.10, 13.21, 45.64, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 8, 26.62, 30, 8.15, 13.39, 45.99, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 9, 14.69, 30, 6.69, 5.47, 33.90, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 10, 2.14, 30, 2.12, 0.27, 14.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 11, 5.71, 30, 3.67, 1.48, 19.65, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 1, 15.64, 30, 9.53, 4.06, 44.82, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 2, 29.68, 30, 8.34, 15.72, 48.86, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 3, 20.44, 30, 7.86, 8.72, 40.85, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 4, 11.38, 30, 6.98, 3.03, 34.57, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 5, 11.73, 30, 6.90, 3.29, 34.18, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 6, 3.64, 30, 2.43, 0.91, 13.51, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 7, 3.71, 30, 3.27, 0.59, 20.03, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 8, 2.14, 30, 2.12, 0.27, 14.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 9, 1.64, 30, 1.65, 0.21, 11.95, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 1, 10.96, 30, 7.06, 2.73, 35.08, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 2, 22.07, 30, 9.21, 8.65, 45.86, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 3, 25.52, 30, 7.70, 13.01, 43.97, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 4, 21.35, 30, 8.77, 8.53, 44.14, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 5, 7.11, 30, 4.55, 1.84, 23.83, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 6, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 7, 2.14, 30, 2.12, 0.27, 14.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 8, 8.46, 30, 6.10, 1.81, 31.64, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 9, 2.40, 30, 1.86, 0.48, 11.14, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 1, 4.85, 20, 5.15, 0.49, 34.46, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 2, 24.56, 20, 12.66, 7.23, 57.64, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 3, 11.57, 20, 8.88, 2.08, 44.59, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 4, 9.23, 20, 9.41, 0.96, 51.59, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 5, 20.87, 20, 12.66, 5.03, 56.75, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 6, 27.72, 20, 10.43, 11.42, 53.28, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 7, 0.00, 20, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 8, 1.20, 20, 1.20, 0.14, 9.22, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 9, 0.00, 20, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 10, 0.00, 20, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 11, 0.00, 20, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 12, 0.00, 20, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 1, 5.34, 19, 5.18, 0.65, 32.67, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 2, 0.00, 19, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 3, 10.17, 19, 10.41, 1.02, 55.33, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 4, 10.17, 19, 10.41, 1.02, 55.33, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 5, 10.17, 19, 9.57, 1.24, 50.55, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 6, 20.60, 19, 11.17, 5.82, 52.13, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 7, 27.46, 19, 12.33, 9.35, 58.15, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 8, 14.76, 19, 8.01, 4.35, 39.75, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 9, 1.32, 19, 1.33, 0.16, 10.22, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 10, 0.00, 19, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 11, 0.00, 19, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 1, 21.67, 19, 13.94, 4.70, 60.83, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 2, 30.97, 19, 12.21, 11.91, 59.82, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 3, 24.24, 19, 14.08, 6.00, 61.58, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 4, 7.00, 19, 4.51, 1.72, 24.41, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 5, 11.49, 19, 9.59, 1.76, 48.47, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 6, 4.64, 19, 3.39, 0.96, 19.61, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 7, 0.00, 19, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 8, 0.00, 19, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 9, 0.00, 19, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 1, 5.34, 19, 5.18, 0.65, 32.67, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 2, 20.35, 19, 12.26, 4.95, 55.59, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 3, 53.45, 19, 12.52, 28.52, 76.77, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 4, 16.59, 19, 10.18, 4.07, 48.25, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 5, 1.32, 19, 1.33, 0.16, 10.22, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 6, 2.95, 19, 2.94, 0.35, 20.77, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 7, 0.00, 19, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 8, 0.00, 19, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 9, 0.00, 19, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 1, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 2, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 3, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 4, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 5, 3.45, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 6, 51.72, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 7, 10.34, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 8, 31.03, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 9, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 10, 3.45, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 11, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 12, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 1, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 2, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 3, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 4, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 5, 10.34, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 6, 17.24, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 7, 13.79, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 8, 37.93, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 9, 17.24, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 10, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 11, 3.45, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 1, 31.03, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 2, 17.24, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 3, 13.79, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 4, 13.79, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 5, 20.69, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 6, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 7, 3.45, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 8, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 9, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 1, 10.34, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 2, 13.79, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 3, 17.24, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 4, 31.03, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 5, 13.79, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 6, 3.45, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 7, 6.90, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 8, 3.45, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 9, 0.00, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 1, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 2, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 3, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 4, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 5, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 6, 42.28, 26, 10.96, 22.51, 64.88, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 7, 7.69, 26, 4.18, 2.42, 21.86, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 8, 17.09, 26, 7.84, 6.19, 39.17, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 10, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 11, 26.21, 26, 12.28, 8.77, 56.77, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 12, 6.72, 26, 6.56, 0.83, 38.36, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 1, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 2, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 3, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 4, 6.74, 26, 4.08, 1.87, 21.58, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 5, 5.53, 26, 4.21, 1.10, 23.50, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 6, 2.16, 26, 2.17, 0.27, 15.44, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 7, 14.44, 26, 7.70, 4.46, 37.87, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 8, 38.97, 26, 9.75, 21.54, 59.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 9, 6.76, 26, 3.36, 2.36, 17.84, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 10, 5.53, 26, 5.62, 0.63, 34.93, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 11, 19.86, 26, 10.45, 6.03, 48.92, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 1, 23.04, 26, 11.75, 7.10, 53.96, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 2, 5.84, 26, 3.51, 1.64, 18.73, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 3, 32.21, 26, 9.81, 15.84, 54.52, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 4, 11.07, 26, 8.41, 2.09, 41.98, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 5, 17.61, 26, 8.86, 5.73, 42.90, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 6, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 7, 5.64, 26, 4.55, 1.02, 25.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 8, 4.59, 26, 4.97, 0.46, 33.20, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 1, 8.88, 26, 7.65, 1.37, 40.60, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 2, 2.16, 26, 2.21, 0.26, 15.96, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 3, 33.18, 26, 9.90, 16.53, 55.46, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 4, 22.05, 26, 10.25, 7.64, 49.14, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 5, 22.57, 26, 8.58, 9.59, 44.47, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 6, 3.09, 26, 3.13, 0.37, 21.53, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 7, 8.08, 26, 3.78, 2.99, 20.03, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 8, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 1, 0.00, 33, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 2, 7.51, 33, 6.87, 1.07, 37.84, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 3, 7.84, 33, 7.16, 1.12, 39.04, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 4, 0.00, 33, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 5, 9.39, 33, 6.11, 2.34, 30.94, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 6, 55.54, 33, 10.97, 33.56, 75.54, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 7, 0.00, 33, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 8, 12.22, 33, 7.63, 3.17, 37.22, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 9, 0.00, 33, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 10, 0.00, 33, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 11, 0.00, 33, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 12, 7.50, 33, 8.26, 0.71, 47.79, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 1, 7.47, 34, 7.14, 0.98, 39.73, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 2, 7.14, 34, 6.84, 0.93, 38.55, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 3, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 4, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 5, 0.70, 34, 0.49, 0.17, 2.88, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 6, 22.03, 34, 12.57, 5.99, 55.60, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 7, 10.09, 34, 4.65, 3.80, 24.16, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 8, 11.73, 34, 7.51, 2.95, 36.78, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 9, 21.67, 34, 11.25, 6.70, 51.60, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 10, 16.97, 34, 11.02, 4.00, 50.07, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 11, 2.20, 34, 2.17, 0.29, 14.92, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 1, 14.62, 34, 10.00, 3.25, 46.65, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 2, 43.81, 34, 12.30, 22.00, 68.30, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 3, 16.66, 34, 4.30, 9.63, 27.28, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 4, 22.47, 34, 14.68, 4.96, 61.67, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 5, 2.09, 34, 1.39, 0.53, 7.84, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 6, 0.34, 34, 0.35, 0.04, 2.71, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 7, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 8, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 9, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 1, 2.20, 34, 2.17, 0.29, 14.92, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 2, 23.27, 34, 8.43, 10.39, 44.22, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 3, 30.20, 34, 12.10, 11.86, 58.16, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 4, 18.59, 34, 8.21, 7.03, 40.78, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 5, 12.64, 34, 7.37, 3.59, 36.02, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 6, 13.10, 34, 7.73, 3.65, 37.50, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 7, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 8, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 9, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 1, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 2, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 3, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 4, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 5, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 6, 55.17, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 7, 3.45, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 8, 41.38, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 9, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 10, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 11, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 12, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 1, 31.03, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 2, 3.45, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 3, 3.45, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 4, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 5, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 6, 24.14, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 7, 10.34, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 8, 17.24, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 9, 10.34, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 10, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 11, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 1, 41.38, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 2, 10.34, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 3, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 4, 10.34, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 5, 6.90, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 6, 13.79, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 7, 13.79, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 8, 3.45, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 9, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 1, 10.34, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 2, 17.24, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 3, 13.79, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 4, 3.45, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 5, 3.45, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 6, 24.14, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 7, 13.79, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 8, 13.79, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 9, 0.00, 29, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 1, 5.82, 23, 5.44, 0.78, 32.64, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 2, 57.03, 23, 12.32, 31.87, 79.01, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 3, 2.67, 23, 2.67, 0.32, 18.84, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 4, 8.08, 23, 4.86, 2.21, 25.45, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 5, 18.90, 23, 10.85, 5.10, 50.29, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 6, 2.60, 23, 2.68, 0.30, 19.33, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 7, 0.00, 23, 0.00, NULL, NULL, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 8, 4.91, 23, 4.69, 0.64, 29.33, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 9, 0.00, 23, 0.00, NULL, NULL, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 10, 0.00, 23, 0.00, NULL, NULL, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 11, 0.00, 23, 0.00, NULL, NULL, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 12, 0.00, 23, 0.00, NULL, NULL, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 1, 7.60, 24, 5.38, 1.66, 28.62, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 2, 0.00, 24, 0.00, NULL, NULL, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 3, 0.00, 24, 0.00, NULL, NULL, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 4, 2.40, 24, 2.41, 0.29, 17.16, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 5, 36.14, 24, 12.73, 15.31, 63.91, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 6, 24.67, 24, 10.18, 9.53, 50.43, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 7, 14.80, 24, 10.34, 3.09, 48.65, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 8, 13.54, 24, 6.77, 4.52, 34.13, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 9, 0.00, 24, 0.00, NULL, NULL, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 10, 0.86, 24, 0.90, 0.10, 7.14, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 11, 0.00, 24, 0.00, NULL, NULL, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 1, 0.00, 24, 0.00, NULL, NULL, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 2, 22.80, 24, 10.36, 8.04, 49.94, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 3, 12.88, 24, 5.98, 4.68, 30.79, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 4, 40.58, 24, 11.60, 20.16, 64.87, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 5, 16.93, 24, 10.12, 4.40, 47.46, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 6, 4.41, 24, 4.25, 0.57, 27.10, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 7, 0.00, 24, 0.00, NULL, NULL, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 8, 2.40, 24, 2.41, 0.29, 17.16, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 9, 0.00, 24, 0.00, NULL, NULL, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 1, 0.00, 24, 0.00, NULL, NULL, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 2, 11.00, 24, 9.28, 1.71, 46.77, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 3, 47.18, 24, 11.15, 26.15, 69.27, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 4, 19.89, 24, 7.89, 8.18, 40.90, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 5, 15.11, 24, 10.02, 3.41, 47.24, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 6, 4.41, 24, 4.25, 0.57, 27.10, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 7, 2.40, 24, 2.41, 0.29, 17.16, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 8, 0.00, 24, 0.00, NULL, NULL, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 9, 0.00, 24, 0.00, NULL, NULL, 'N', '2005-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 1, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 2, 12.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 3, 8.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 4, 12.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 5, 12.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 6, 48.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 7, 4.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 8, 4.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 9, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 10, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 11, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 12, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 1, 7.69, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 2, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 3, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 4, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 5, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 6, 19.23, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 7, 38.46, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 8, 30.77, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 9, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 10, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 11, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 1, 19.23, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 2, 19.23, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 3, 15.38, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 4, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 5, 7.69, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 6, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 7, 11.54, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 8, 23.08, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 9, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 1, 11.54, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 2, 19.23, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 3, 15.38, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 4, 11.54, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 5, 23.08, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 6, 7.69, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 7, 7.69, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 8, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 9, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 1, 0.00, 27, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 2, 9.99, 27, 8.92, 1.42, 46.05, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 3, 0.00, 27, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 4, 9.99, 27, 8.92, 1.42, 46.05, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 5, 0.99, 27, 1.01, 0.12, 7.70, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 6, 50.82, 27, 15.66, 22.18, 78.94, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 7, 1.47, 27, 1.52, 0.17, 11.43, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 8, 14.74, 27, 9.02, 3.80, 43.04, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 9, 2.01, 27, 2.07, 0.24, 15.11, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 10, 0.00, 27, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 11, 9.99, 27, 8.92, 1.42, 46.05, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 12, 0.00, 27, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 1, 0.00, 27, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 2, 0.00, 27, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 3, 0.00, 27, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 4, 9.99, 27, 8.92, 1.42, 46.05, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 5, 10.98, 27, 9.82, 1.54, 49.29, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 6, 1.72, 27, 1.52, 0.28, 10.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 7, 16.16, 27, 9.06, 4.65, 43.24, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 8, 44.61, 27, 10.98, 24.41, 66.75, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 9, 3.31, 27, 2.51, 0.68, 14.63, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 10, 0.00, 27, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 11, 13.22, 27, 11.86, 1.79, 56.06, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 1, 13.95, 26, 9.21, 3.23, 44.07, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 2, 24.88, 26, 12.54, 7.68, 56.87, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 3, 15.09, 26, 10.53, 3.17, 49.12, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 4, 1.33, 26, 1.10, 0.24, 7.03, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 5, 28.21, 26, 18.95, 5.41, 72.98, 'Y', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 6, 16.22, 26, 12.21, 2.95, 55.19, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 7, 0.00, 26, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 8, 0.00, 26, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 9, 0.32, 26, 0.33, 0.04, 2.68, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 1, 0.00, 27, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 2, 11.83, 27, 8.98, 2.24, 44.06, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 3, 14.47, 27, 10.35, 2.94, 48.54, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 4, 18.57, 27, 10.67, 5.07, 49.32, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 5, 41.02, 27, 19.39, 11.81, 78.32, 'Y', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 6, 13.80, 27, 9.08, 3.23, 43.48, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 7, 0.00, 27, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 8, 0.00, 27, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 9, 0.31, 27, 0.33, 0.04, 2.63, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 1, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 2, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 3, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 4, 14.81, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 5, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 6, 51.85, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 7, 11.11, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 8, 14.81, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 9, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 10, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 11, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 12, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 1, 7.41, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 2, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 3, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 4, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 5, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 6, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 7, 25.93, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 8, 40.74, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 9, 14.81, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 10, 7.41, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 11, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 1, 7.41, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 2, 14.81, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 3, 7.41, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 4, 14.81, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 5, 14.81, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 6, 22.22, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 7, 11.11, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 8, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 9, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 1, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 2, 7.41, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 3, 7.41, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 4, 11.11, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 5, 33.33, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 6, 18.52, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 7, 14.81, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 8, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 9, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 1, 0.00, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 2, 0.00, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 3, 0.00, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 4, 0.00, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 5, 0.00, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 6, 63.64, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 7, 6.06, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 8, 21.21, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 9, 3.03, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 10, 3.03, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 11, 3.03, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 12, 0.00, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 1, 0.00, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 2, 0.00, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 3, 0.00, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 4, 0.00, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 5, 6.06, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 6, 3.03, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 7, 36.36, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 8, 27.27, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 9, 18.18, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 10, 6.06, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 11, 3.03, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 1, 18.18, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 2, 27.27, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 3, 21.21, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 4, 9.09, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 5, 12.12, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 6, 9.09, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 7, 3.03, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 8, 0.00, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 9, 0.00, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 1, 3.03, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 2, 12.12, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 3, 36.36, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 4, 9.09, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 5, 21.21, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 6, 12.12, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 7, 3.03, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 8, 3.03, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 9, 0.00, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 1, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 2, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 3, 2.34, 21, 2.52, 0.24, 19.33, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 4, 0.98, 21, 1.05, 0.10, 8.62, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 5, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 6, 65.76, 21, 15.51, 31.34, 88.99, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 7, 9.46, 21, 6.94, 1.89, 36.15, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 8, 13.52, 21, 9.26, 2.91, 44.93, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 9, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 10, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 11, 7.95, 21, 7.50, 1.01, 42.27, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 12, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 1, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 2, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 3, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 4, 2.34, 21, 2.44, 0.26, 18.19, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 5, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 6, 3.54, 21, 3.00, 0.59, 18.64, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 7, 4.90, 21, 3.79, 0.94, 21.95, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 8, 48.12, 21, 10.43, 27.96, 68.91, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 9, 18.40, 21, 11.63, 4.29, 53.15, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 10, 21.51, 21, 14.88, 4.18, 63.26, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 11, 1.19, 21, 0.97, 0.22, 6.31, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 1, 18.40, 21, 11.64, 4.28, 53.17, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 2, 8.59, 21, 5.72, 2.02, 30.02, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 3, 8.94, 21, 6.34, 1.90, 33.26, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 4, 2.34, 21, 2.44, 0.26, 18.19, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 5, 23.52, 21, 15.47, 4.87, 64.91, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 6, 7.35, 21, 7.46, 0.80, 43.84, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 7, 17.80, 21, 11.77, 3.89, 53.68, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 8, 13.07, 21, 7.89, 3.41, 39.01, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 9, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 1, 18.40, 21, 11.64, 4.28, 53.17, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 2, 17.20, 21, 11.90, 3.51, 54.28, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 3, 6.25, 21, 4.86, 1.17, 27.32, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 4, 25.81, 21, 15.12, 6.28, 64.37, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 5, 5.49, 21, 3.42, 1.45, 18.66, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 6, 14.16, 21, 10.50, 2.65, 50.00, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 7, 4.58, 21, 4.27, 0.62, 26.96, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 8, 8.11, 21, 6.24, 1.52, 33.58, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 9, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '2.D.1', 'RL', 1, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '2.D.1', 'RL', 2, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '2.D.1', 'RL', 3, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '2.D.1', 'RL', 4, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '2.D.1', 'RL', 5, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '2.D.1', 'RL', 6, 32.66, 25, 13.05, 12.47, 62.27, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '2.D.1', 'RL', 7, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '2.D.1', 'RL', 8, 63.33, 25, 12.76, 35.72, 84.29, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '2.D.1', 'RL', 9, 2.01, 25, 2.03, 0.24, 14.68, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '2.D.1', 'RL', 10, 2.01, 25, 2.03, 0.24, 14.68, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '2.D.1', 'RL', 11, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '2.D.1', 'RL', 12, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.1', 'RW', 1, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.1', 'RW', 2, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.1', 'RW', 3, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.1', 'RW', 4, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.1', 'RW', 5, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.1', 'RW', 6, 1.51, 25, 1.59, 0.17, 12.18, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.1', 'RW', 7, 1.51, 25, 1.57, 0.18, 11.86, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.1', 'RW', 8, 24.86, 25, 9.96, 9.91, 49.87, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.1', 'RW', 9, 16.35, 25, 4.87, 8.57, 28.96, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.1', 'RW', 10, 28.36, 25, 12.13, 10.35, 57.58, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.1', 'RW', 11, 27.40, 25, 8.46, 13.57, 47.57, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.2', 'PT', 1, 27.75, 25, 10.27, 11.77, 52.50, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.2', 'PT', 2, 14.84, 25, 5.00, 7.15, 28.28, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.2', 'PT', 3, 13.11, 25, 9.77, 2.51, 46.97, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.2', 'PT', 4, 9.18, 25, 6.84, 1.82, 35.48, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.2', 'PT', 5, 14.96, 25, 9.59, 3.58, 45.47, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.2', 'PT', 6, 10.58, 25, 5.66, 3.33, 28.90, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.2', 'PT', 7, 6.07, 25, 4.62, 1.20, 25.58, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.2', 'PT', 8, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.2', 'PT', 9, 3.52, 25, 2.59, 0.75, 14.95, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.3', 'OJ', 1, 16.19, 24, 8.95, 4.70, 43.05, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.3', 'OJ', 2, 13.53, 24, 6.51, 4.72, 33.08, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.3', 'OJ', 3, 0.00, 24, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.3', 'OJ', 4, 9.47, 24, 4.77, 3.20, 24.87, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.3', 'OJ', 5, 28.63, 24, 10.72, 11.93, 54.30, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.3', 'OJ', 6, 20.10, 24, 10.27, 6.28, 48.57, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.3', 'OJ', 7, 8.51, 24, 5.84, 1.93, 30.50, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.3', 'OJ', 8, 1.54, 24, 1.57, 0.18, 11.78, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.03', '3.A.3', 'OJ', 9, 2.04, 24, 2.06, 0.24, 14.98, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 1, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 2, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 3, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 4, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 5, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 6, 66.67, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 7, 7.41, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 8, 14.81, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 9, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 10, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 11, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 12, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 1, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 2, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 3, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 4, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 5, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 6, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 7, 18.52, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 8, 33.33, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 9, 18.52, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 10, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 11, 22.22, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 1, 14.81, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 2, 25.93, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 3, 11.11, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 4, 18.52, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 5, 7.41, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 6, 11.11, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 7, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 8, 7.41, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 9, 0.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
/*! COMMIT */;
/*! START TRANSACTION */;
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 1, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 2, 29.63, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 3, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 4, 22.22, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 5, 14.81, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 6, 14.81, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 7, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 8, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 9, 3.70, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '2.D.1', 'RL', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '2.D.1', 'RL', 3, 5.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '2.D.1', 'RL', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '2.D.1', 'RL', 5, 15.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '2.D.1', 'RL', 6, 60.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '2.D.1', 'RL', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '2.D.1', 'RL', 8, 15.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '2.D.1', 'RL', 9, 5.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '2.D.1', 'RL', 10, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.1', 'RW', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.1', 'RW', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.1', 'RW', 6, 10.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.1', 'RW', 7, 30.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.1', 'RW', 8, 10.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.1', 'RW', 9, 20.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.1', 'RW', 10, 20.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.1', 'RW', 11, 10.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.2', 'PT', 1, 10.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.2', 'PT', 2, 35.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.2', 'PT', 3, 15.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.2', 'PT', 4, 15.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.2', 'PT', 5, 15.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.2', 'PT', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.2', 'PT', 7, 5.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.2', 'PT', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.2', 'PT', 9, 5.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.3', 'OJ', 1, 10.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.3', 'OJ', 2, 25.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.3', 'OJ', 3, 10.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.3', 'OJ', 4, 20.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.3', 'OJ', 5, 25.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.3', 'OJ', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.3', 'OJ', 7, 5.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.3', 'OJ', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.07', '3.A.3', 'OJ', 9, 5.00, 20, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 2, 4.17, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 3, 4.17, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 4, 12.50, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 5, 12.50, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 6, 58.33, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 8, 4.17, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 10, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 11, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 12, 4.17, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 4, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 5, 4.17, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 6, 20.83, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 7, 41.67, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 8, 25.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 9, 4.17, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 10, 4.17, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 11, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 2, 33.33, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 3, 29.17, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 4, 29.17, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 5, 4.17, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 6, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 7, 4.17, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 2, 8.33, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 3, 41.67, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 4, 45.83, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 6, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 7, 4.17, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 1, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 2, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 3, 8.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 4, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 5, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 6, 68.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 7, 12.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 8, 12.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 9, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 10, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 11, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 12, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 1, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 4, 0.00, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 5, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 6, 16.67, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 7, 16.67, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 8, 29.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 9, 12.50, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 10, 12.50, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 11, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 1, 16.67, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 2, 29.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 3, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 4, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 5, 16.67, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 6, 12.50, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 7, 8.33, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 8, 8.33, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 1, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 2, 20.83, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 4, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 5, 41.67, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 6, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 7, 8.33, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 8, 16.67, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 1, 0.52, 34, 0.53, 0.06, 4.04, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 2, 11.64, 34, 7.02, 3.18, 34.56, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 3, 0.00, 34, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 4, 24.65, 34, 10.63, 9.26, 51.19, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 5, 2.55, 34, 2.54, 0.33, 17.30, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 6, 49.79, 34, 11.61, 27.83, 71.83, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 7, 2.70, 34, 2.02, 0.58, 11.74, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 8, 5.60, 34, 4.01, 1.25, 21.74, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 9, 0.00, 34, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 10, 2.55, 34, 2.47, 0.34, 16.53, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 11, 0.00, 34, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 12, 0.00, 34, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 1, 3.85, 32, 3.36, 0.62, 20.31, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 2, 0.00, 32, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 3, 0.00, 32, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 4, 16.87, 32, 11.03, 3.92, 50.24, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 5, 5.33, 32, 3.55, 1.32, 19.11, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 6, 29.93, 32, 10.44, 13.40, 54.10, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 7, 13.67, 32, 8.65, 3.43, 41.38, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 8, 14.50, 32, 6.00, 5.95, 31.27, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 9, 6.26, 32, 6.05, 0.81, 35.34, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 10, 5.02, 32, 5.06, 0.60, 31.50, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 11, 4.57, 32, 3.61, 0.87, 20.60, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 1, 7.73, 33, 5.40, 1.76, 28.17, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 2, 26.03, 33, 10.37, 10.51, 51.32, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 3, 11.69, 33, 5.22, 4.51, 27.04, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 4, 22.93, 33, 11.50, 7.33, 52.83, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 5, 9.64, 33, 4.90, 3.28, 25.11, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 6, 14.10, 33, 8.88, 3.56, 42.21, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 7, 1.62, 33, 1.26, 0.33, 7.59, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 8, 6.26, 33, 4.43, 1.42, 23.69, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 9, 0.00, 33, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 1, 0.00, 33, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 2, 10.24, 33, 4.78, 3.81, 24.77, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 3, 24.58, 33, 10.93, 8.93, 52.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 4, 37.28, 33, 11.16, 18.35, 61.12, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 5, 8.88, 33, 5.87, 2.18, 29.92, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 6, 10.70, 33, 5.79, 3.37, 29.17, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 7, 4.98, 33, 3.27, 1.27, 17.64, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 8, 3.34, 33, 3.35, 0.41, 22.23, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 9, 0.00, 33, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 1, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 2, 7.60, 20, 6.74, 1.09, 38.03, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 3, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 4, 7.28, 20, 6.46, 1.05, 36.75, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 5, 8.29, 20, 7.39, 1.17, 40.89, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 6, 76.83, 20, 11.60, 45.88, 92.84, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 7, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 8, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 9, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 10, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 11, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 12, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 1, 11.27, 20, 8.66, 2.03, 43.78, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 2, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 3, 10.11, 20, 8.72, 1.49, 45.58, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 4, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 5, 7.60, 20, 6.76, 1.09, 38.11, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 6, 13.89, 20, 9.66, 2.89, 46.67, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 7, 13.91, 20, 8.22, 3.70, 40.46, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 8, 7.97, 20, 6.60, 1.30, 36.32, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 9, 1.48, 20, 1.53, 0.17, 11.95, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 10, 15.67, 20, 13.72, 2.07, 61.99, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 11, 18.09, 20, 10.36, 4.86, 48.83, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 1, 5.18, 20, 5.37, 0.55, 34.95, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 2, 18.69, 20, 13.56, 3.43, 59.82, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 3, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 4, 21.12, 20, 11.19, 6.16, 52.21, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 5, 22.07, 20, 17.28, 3.34, 69.87, 'Y', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 6, 9.92, 20, 6.93, 2.13, 35.81, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 7, 10.11, 20, 9.47, 1.25, 49.89, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 8, 6.29, 20, 6.43, 0.68, 39.75, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 9, 6.62, 20, 6.75, 0.72, 41.07, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 1, 5.18, 20, 5.37, 0.55, 34.95, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 2, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 3, 18.32, 20, 13.62, 3.23, 60.11, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 4, 29.99, 20, 13.57, 9.97, 62.36, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 5, 3.78, 20, 2.87, 0.75, 17.03, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 6, 29.83, 20, 17.02, 7.19, 69.98, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 7, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 8, 12.90, 20, 9.11, 2.64, 44.71, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 9, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 1, 13.92, 29, 9.05, 3.33, 43.16, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 2, 20.30, 29, 13.21, 4.56, 57.56, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 3, 10.30, 29, 9.75, 1.31, 49.91, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 4, 8.21, 29, 5.99, 1.73, 31.31, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 5, 11.43, 29, 8.46, 2.28, 41.69, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 6, 34.65, 29, 16.27, 10.85, 69.78, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 7, 0.00, 29, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 8, 0.00, 29, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 9, 1.19, 29, 1.25, 0.14, 9.52, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 10, 0.00, 29, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 11, 0.00, 29, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 12, 0.00, 29, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 1, 15.45, 27, 11.41, 2.95, 52.37, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 2, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 3, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 4, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 5, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 6, 22.47, 27, 14.12, 5.19, 60.53, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 7, 48.58, 27, 17.76, 17.97, 80.30, 'Y', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 8, 12.79, 27, 9.14, 2.65, 44.16, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 9, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 10, 0.70, 27, 0.52, 0.16, 3.13, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 11, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 1, 28.19, 27, 18.73, 5.54, 72.44, 'Y', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 2, 6.02, 27, 4.43, 1.26, 24.25, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 3, 21.74, 27, 14.09, 4.82, 60.38, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 4, 12.84, 27, 10.74, 2.01, 51.43, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 5, 3.63, 27, 2.33, 0.95, 12.91, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 6, 17.11, 27, 12.06, 3.47, 54.24, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 7, 10.48, 27, 8.91, 1.64, 45.17, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 8, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 9, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 1, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 2, 5.52, 26, 4.93, 0.83, 29.05, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 3, 17.27, 26, 11.98, 3.58, 54.00, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 4, 42.07, 26, 19.86, 11.94, 79.56, 'Y', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 5, 21.78, 26, 13.59, 5.11, 59.00, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 6, 12.96, 26, 10.14, 2.28, 48.67, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 7, 0.41, 26, 0.43, 0.05, 3.55, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 8, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 3, 10.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 4, 5.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 6, 85.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 10, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 1, 5.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 6, 25.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 7, 30.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 8, 20.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 9, 5.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 10, 5.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 11, 10.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 1, 20.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 2, 10.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 3, 10.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 4, 25.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 5, 10.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 6, 10.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 7, 15.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 1, 5.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 2, 5.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 3, 20.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 4, 25.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 5, 25.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 6, 10.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 7, 10.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 1, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 2, 11.58, 24, 6.64, 3.31, 33.38, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 3, 5.91, 24, 6.35, 0.59, 40.07, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 4, 7.64, 24, 6.66, 1.16, 36.82, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 5, 5.67, 24, 5.56, 0.70, 33.99, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 6, 69.21, 24, 5.32, 57.27, 79.03, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 7, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 8, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 9, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 10, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 11, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 12, 0.00, 24, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 1, 5.52, 25, 5.41, 0.68, 33.22, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 2, 0.00, 25, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 3, 0.00, 25, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 4, 0.00, 25, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 5, 11.26, 25, 6.52, 3.19, 32.80, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 6, 17.19, 25, 7.87, 6.22, 39.40, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 7, 17.00, 25, 4.08, 10.14, 27.11, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 8, 23.92, 25, 9.52, 9.65, 48.07, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 9, 8.05, 25, 5.06, 2.09, 26.39, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 10, 5.74, 25, 6.17, 0.58, 39.07, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 11, 11.32, 25, 6.95, 2.96, 34.78, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 1, 6.61, 25, 5.47, 1.12, 30.63, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 2, 21.12, 25, 13.67, 4.69, 59.27, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 3, 11.26, 25, 6.52, 3.19, 32.80, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 4, 10.95, 25, 7.87, 2.27, 39.40, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 5, 17.06, 25, 6.93, 6.96, 36.11, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 6, 19.75, 25, 9.57, 6.61, 46.11, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 7, 7.95, 25, 5.19, 1.96, 27.20, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 8, 0.00, 25, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 9, 5.30, 25, 4.92, 0.73, 29.74, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 1, 6.11, 25, 5.45, 0.91, 31.61, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 2, 12.63, 25, 8.05, 3.11, 39.47, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 3, 14.51, 25, 6.41, 5.52, 33.03, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 4, 10.72, 25, 6.89, 2.65, 34.67, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 5, 16.69, 25, 13.29, 2.71, 59.04, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 6, 25.05, 25, 9.79, 10.23, 49.50, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 7, 8.49, 25, 4.95, 2.43, 25.70, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 8, 0.50, 25, 0.51, 0.06, 4.02, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 9, 5.30, 25, 4.92, 0.73, 29.74, 'N', '2010-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 1, 0.00, 32, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 2, 6.02, 32, 3.78, 1.61, 20.01, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 3, 25.43, 32, 8.78, 11.70, 46.73, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 4, 7.05, 32, 5.64, 1.30, 30.51, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 5, 12.86, 32, 7.15, 3.86, 35.17, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 6, 34.94, 32, 10.71, 17.05, 58.40, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 7, 13.70, 32, 7.83, 3.95, 38.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 8, 0.00, 32, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 9, 0.00, 32, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 10, 0.00, 32, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 11, 0.00, 32, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 12, 0.00, 32, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 1, 20.57, 32, 11.59, 5.75, 52.40, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 2, 6.64, 32, 5.68, 1.09, 31.53, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 3, 0.00, 32, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 4, 0.00, 32, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 5, 10.84, 32, 5.91, 3.38, 29.74, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 6, 19.70, 32, 7.10, 8.94, 37.99, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 7, 24.36, 32, 8.02, 11.71, 43.89, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 8, 7.33, 32, 6.34, 1.17, 34.65, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 9, 1.85, 32, 1.61, 0.31, 10.34, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 10, 1.64, 32, 1.70, 0.19, 12.56, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 11, 7.05, 32, 6.45, 1.01, 36.10, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 1, 0.41, 32, 0.44, 0.05, 3.62, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 2, 34.17, 32, 10.15, 17.14, 56.58, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 3, 19.33, 32, 8.76, 7.08, 42.97, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 4, 26.70, 32, 11.63, 9.78, 55.04, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 5, 17.60, 32, 7.29, 7.12, 37.32, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 6, 0.00, 32, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 7, 1.79, 32, 1.10, 0.51, 6.15, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 8, 0.00, 32, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 9, 0.00, 32, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 1, 0.00, 32, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 2, 10.80, 32, 5.88, 3.37, 29.62, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 3, 30.16, 32, 12.41, 11.50, 58.94, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 4, 22.02, 32, 10.70, 7.34, 50.16, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 5, 21.52, 32, 6.82, 10.75, 38.45, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 6, 6.64, 32, 6.79, 0.76, 39.89, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 7, 1.79, 32, 1.10, 0.51, 6.15, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 8, 0.41, 32, 0.44, 0.05, 3.62, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 9, 6.64, 32, 6.61, 0.80, 38.51, 'N', '2009-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 1, 0.00, 27, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 2, 30.86, 27, 8.38, 16.60, 50.02, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 3, 3.51, 27, 2.91, 0.62, 17.52, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 4, 10.67, 27, 10.36, 1.26, 52.71, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 5, 22.99, 27, 8.37, 10.16, 44.09, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 6, 31.96, 27, 4.23, 23.95, 41.20, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 7, 0.00, 27, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 8, 0.00, 27, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 9, 0.00, 27, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 10, 0.00, 27, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 11, 0.00, 27, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 12, 0.00, 27, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 1, 0.25, 26, 0.26, 0.03, 2.08, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 2, 0.00, 26, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 3, 0.06, 26, 0.08, 0.00, 0.76, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 4, 22.60, 26, 8.57, 9.63, 44.47, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 5, 0.73, 26, 0.91, 0.06, 8.83, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 6, 28.53, 26, 6.46, 17.22, 43.39, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 7, 15.79, 26, 12.74, 2.54, 57.45, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 8, 9.34, 26, 9.86, 0.93, 53.12, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 9, 0.09, 26, 0.11, 0.01, 1.12, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 10, 22.60, 26, 8.57, 9.63, 44.47, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 11, 0.00, 26, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 1, 0.00, 26, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 2, 0.60, 26, 0.58, 0.08, 4.20, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 3, 50.08, 26, 14.64, 23.09, 77.02, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 4, 5.92, 26, 5.36, 0.86, 31.33, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 5, 1.58, 26, 1.82, 0.14, 15.29, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 6, 32.05, 26, 4.22, 24.05, 41.27, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 7, 9.77, 26, 10.00, 1.04, 52.82, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 8, 0.00, 26, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 1, 0.00, 27, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 2, 0.71, 27, 0.68, 0.10, 4.98, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 3, 8.56, 27, 9.56, 0.76, 53.52, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 4, 24.52, 27, 7.83, 11.98, 43.67, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 5, 24.64, 27, 7.77, 12.14, 43.60, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 6, 32.26, 27, 4.17, 24.34, 41.34, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 7, 9.32, 27, 9.83, 0.93, 52.87, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 8, 0.00, 27, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 9, 0.00, 27, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 2, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 3, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 4, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 5, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 6, 85.71, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 7, 9.52, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 8, 4.76, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 10, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 11, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 12, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 1, 19.05, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 2, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 3, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 4, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 5, 4.76, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 6, 19.05, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 7, 33.33, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 8, 9.52, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 9, 9.52, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 10, 4.76, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 11, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 1, 14.29, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 2, 14.29, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 3, 19.05, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 4, 4.76, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 5, 23.81, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 6, 23.81, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 8, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 2, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 3, 23.81, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 4, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 5, 38.10, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 6, 19.05, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 7, 19.05, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 8, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 1, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 2, 23.31, 26, 11.09, 7.81, 52.16, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 3, 11.75, 26, 9.54, 1.96, 46.96, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 4, 12.34, 26, 8.55, 2.69, 41.76, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 5, 8.82, 26, 5.07, 2.57, 26.15, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 6, 43.77, 26, 20.61, 12.19, 81.36, 'Y', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 7, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 8, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 10, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 11, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 12, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 1, 10.51, 26, 8.36, 1.85, 42.30, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 2, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 3, 1.04, 26, 1.11, 0.11, 8.88, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 4, 3.86, 26, 3.86, 0.47, 25.47, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 5, 23.04, 26, 11.07, 7.64, 51.99, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 6, 8.39, 26, 5.80, 1.90, 30.25, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 7, 52.12, 26, 16.39, 21.97, 80.81, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 8, 1.04, 26, 1.11, 0.11, 8.88, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 10, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 11, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 1, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 2, 6.23, 26, 3.73, 1.75, 19.85, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 3, 28.23, 26, 9.54, 12.97, 50.92, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 4, 16.60, 26, 10.59, 3.95, 49.03, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 5, 47.97, 26, 17.59, 17.76, 79.74, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 6, 0.98, 26, 1.00, 0.12, 7.69, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 7, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 8, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 1, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 2, 11.42, 26, 8.27, 2.33, 41.00, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 3, 30.52, 26, 6.28, 19.27, 44.70, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 4, 16.59, 26, 10.98, 3.74, 50.47, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 5, 30.97, 26, 12.86, 11.50, 60.75, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 6, 10.51, 26, 8.01, 1.99, 40.43, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 7, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 8, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 1, 0.00, 33, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 2, 0.00, 33, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 3, 0.00, 33, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 4, 14.07, 33, 9.40, 3.25, 44.38, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 5, 0.00, 33, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 6, 65.76, 33, 10.94, 41.65, 83.79, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 7, 4.44, 33, 3.49, 0.86, 19.89, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 8, 11.87, 33, 5.77, 4.20, 29.30, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 9, 1.09, 33, 1.11, 0.14, 8.19, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 10, 2.77, 33, 2.70, 0.37, 18.05, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 11, 0.00, 33, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 12, 0.00, 33, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 1, 6.78, 32, 7.01, 0.75, 41.12, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 2, 0.00, 32, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 3, 0.00, 32, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 4, 0.00, 32, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 5, 7.92, 32, 7.08, 1.18, 38.36, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 6, 8.44, 32, 4.80, 2.53, 24.65, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 7, 43.94, 32, 14.91, 18.57, 72.92, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 8, 20.26, 32, 7.58, 8.89, 39.81, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 9, 3.59, 32, 3.76, 0.41, 25.38, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 10, 7.06, 32, 4.21, 2.01, 21.97, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 11, 2.01, 32, 2.04, 0.25, 14.44, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 1, 17.27, 32, 7.08, 7.07, 36.45, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 2, 15.37, 32, 9.34, 4.03, 43.99, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 3, 21.73, 32, 8.95, 8.66, 44.83, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 4, 7.16, 32, 4.00, 2.21, 20.84, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 5, 10.64, 32, 5.05, 3.87, 26.04, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 6, 16.09, 32, 7.74, 5.62, 38.19, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 7, 2.49, 32, 2.51, 0.31, 17.32, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 8, 9.24, 32, 5.18, 2.81, 26.42, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 9, 0.00, 32, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 1, 5.61, 32, 4.37, 1.09, 24.23, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 2, 20.21, 32, 14.03, 4.12, 59.90, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 3, 12.20, 32, 8.07, 2.90, 39.24, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 4, 25.96, 32, 10.48, 10.35, 51.59, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 5, 14.23, 32, 5.69, 6.03, 30.03, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 6, 8.56, 32, 5.49, 2.20, 28.10, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 7, 0.00, 32, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 8, 13.22, 32, 5.79, 5.16, 29.91, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 9, 0.00, 32, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 1, 0.00, 20, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 2, 29.41, 20, 14.94, 8.45, 65.27, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 3, 41.24, 20, 14.33, 16.92, 70.75, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 4, 0.17, 20, 0.15, 0.03, 1.06, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 5, 24.22, 20, 21.23, 2.76, 78.24, 'Y', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 6, 4.91, 20, 5.90, 0.36, 42.14, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 7, 0.00, 20, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 8, 0.00, 20, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 9, 0.00, 20, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 10, 0.05, 20, 0.06, 0.01, 0.56, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 11, 0.00, 20, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 12, 0.00, 20, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 1, 0.00, 19, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 2, 0.00, 19, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 3, 0.00, 19, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 4, 0.00, 19, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 5, 63.93, 19, 31.32, 9.27, 96.85, 'Y', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 6, 0.89, 19, 0.75, 0.15, 5.10, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 7, 34.45, 19, 30.63, 2.95, 90.08, 'Y', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 8, 0.45, 19, 0.36, 0.08, 2.43, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 9, 0.00, 19, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 10, 0.07, 19, 0.08, 0.01, 0.80, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 11, 0.19, 19, 0.18, 0.03, 1.40, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 1, 24.22, 20, 15.71, 5.06, 65.73, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 2, 0.12, 20, 0.10, 0.02, 0.72, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 3, 40.53, 20, 28.36, 5.49, 88.88, 'Y', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 4, 4.60, 20, 5.79, 0.30, 43.38, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 5, 29.94, 20, 14.85, 8.85, 65.27, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 6, 0.44, 20, 0.29, 0.11, 1.74, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 7, 0.10, 20, 0.11, 0.01, 1.05, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 8, 0.05, 20, 0.06, 0.01, 0.56, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 9, 0.00, 20, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 1, 0.00, 20, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 2, 16.26, 20, 18.23, 1.16, 76.20, 'Y', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 3, 0.00, 20, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 4, 48.83, 20, 14.79, 21.66, 76.70, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 5, 34.33, 20, 14.18, 12.29, 66.10, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 6, 0.32, 20, 0.23, 0.07, 1.49, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 7, 0.17, 20, 0.15, 0.03, 1.06, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 8, 0.10, 20, 0.08, 0.02, 0.50, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 9, 0.00, 20, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 1, 0.00, 31, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 2, 22.58, 31, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 3, 12.90, 31, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 4, 16.13, 31, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 5, 19.35, 31, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 6, 9.68, 31, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 7, 3.23, 31, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 8, 3.23, 31, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 9, 0.00, 31, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 10, 0.00, 31, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 11, 3.23, 31, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 12, 9.68, 31, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 1, 20.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 2, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 3, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 4, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 5, 10.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 6, 20.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 7, 26.67, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 8, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 9, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 10, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 11, 6.67, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 1, 10.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 2, 20.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 3, 16.67, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 4, 20.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 5, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 6, 23.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 7, 0.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 8, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 9, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 1, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 2, 10.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 3, 6.67, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 4, 33.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 5, 10.00, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 6, 23.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 7, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 8, 6.67, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 9, 3.33, 30, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 1, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 2, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 3, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 4, 3.12, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 5, 3.12, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 6, 78.12, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 7, 9.38, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 8, 6.25, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 9, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 10, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 11, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 12, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 1, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 2, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 3, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 4, 3.12, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 5, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 6, 25.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 7, 40.62, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 8, 25.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 9, 6.25, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 10, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 11, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 1, 18.75, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 2, 21.88, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 3, 12.50, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 4, 6.25, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 5, 25.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 6, 12.50, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 7, 3.12, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 8, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 9, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 1, 3.12, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 2, 6.25, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 3, 15.62, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 4, 15.62, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 5, 37.50, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 6, 18.75, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 7, 3.12, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 8, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 9, 0.00, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 1, 0.00, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 2, 0.00, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 3, 3.57, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 4, 7.14, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 5, 14.29, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 6, 64.29, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 7, 0.00, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 8, 7.14, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 9, 3.57, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 10, 0.00, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 11, 0.00, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 12, 0.00, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 1, 14.81, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 2, 0.00, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 3, 0.00, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 4, 0.00, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 5, 3.70, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 6, 11.11, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 7, 29.63, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 8, 22.22, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 9, 11.11, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 10, 3.70, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 11, 3.70, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 1, 10.71, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 2, 7.14, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 3, 17.86, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 4, 17.86, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 5, 14.29, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 6, 10.71, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 7, 10.71, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 8, 10.71, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 9, 0.00, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 1, 3.57, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 2, 7.14, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 3, 7.14, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 4, 3.57, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 5, 35.71, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 6, 10.71, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 7, 28.57, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 8, 3.57, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 9, 0.00, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 1, 0.03, 41, 0.03, 0.00, 0.24, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 2, 8.02, 41, 4.40, 2.55, 22.53, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 3, 3.14, 41, 2.16, 0.77, 12.00, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 4, 28.01, 41, 20.14, 4.92, 74.55, 'Y', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 5, 11.42, 41, 6.23, 3.58, 30.93, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 6, 46.27, 41, 18.36, 16.21, 79.31, 'Y', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 7, 0.00, 41, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 8, 3.10, 41, 3.02, 0.42, 19.60, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 9, 0.00, 41, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 10, 0.00, 41, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 11, 0.00, 41, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 12, 0.00, 41, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 1, 0.06, 41, 0.06, 0.01, 0.48, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 2, 0.00, 41, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 3, 0.00, 41, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 4, 0.00, 41, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 5, 4.61, 41, 3.37, 1.02, 18.54, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 6, 28.05, 41, 20.04, 4.98, 74.36, 'Y', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 7, 21.64, 41, 8.97, 8.66, 44.57, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 8, 42.00, 41, 18.61, 13.40, 77.22, 'Y', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 9, 3.51, 41, 3.07, 0.58, 18.53, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 10, 0.00, 41, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 11, 0.13, 41, 0.13, 0.02, 1.00, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 1, 33.06, 41, 19.79, 7.49, 75.07, 'Y', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 2, 19.03, 41, 11.62, 4.87, 51.92, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 3, 1.60, 41, 1.65, 0.20, 11.86, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 4, 5.62, 41, 3.59, 1.49, 18.98, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 5, 10.56, 41, 6.41, 2.91, 31.75, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 6, 28.67, 41, 19.83, 5.36, 74.05, 'Y', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 7, 1.44, 41, 1.37, 0.21, 9.26, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 8, 0.00, 41, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 9, 0.01, 41, 0.01, 0.00, 0.09, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 1, 24.49, 41, 20.23, 3.43, 74.75, 'Y', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 2, 9.61, 41, 6.17, 2.47, 30.86, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 3, 11.51, 41, 6.36, 3.55, 31.50, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 4, 6.79, 41, 3.95, 2.02, 20.47, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 5, 14.97, 41, 7.27, 5.26, 35.82, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 6, 32.63, 41, 19.76, 7.30, 74.86, 'Y', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 7, 0.00, 41, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 8, 0.01, 41, 0.01, 0.00, 0.09, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 9, 0.00, 41, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 1, 48.00, 13, 21.88, 12.03, 86.17, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 2, 42.83, 13, 22.34, 9.30, 84.55, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 3, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 4, 8.90, 13, 9.13, 0.83, 53.18, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 5, 0.14, 13, 0.16, 0.01, 1.72, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 6, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 7, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 8, 0.14, 13, 0.15, 0.01, 1.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 9, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 10, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 11, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 12, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 1, 18.06, 13, 16.64, 1.87, 71.86, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 2, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 3, 1.38, 13, 1.27, 0.18, 9.68, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 4, 3.83, 13, 4.04, 0.36, 30.31, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 5, 24.37, 13, 20.45, 2.79, 78.32, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 6, 33.54, 13, 21.23, 5.96, 80.08, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 7, 18.68, 13, 16.73, 2.04, 71.67, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 8, 0.14, 13, 0.15, 0.01, 1.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 9, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 10, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 11, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 1, 46.65, 13, 22.21, 11.12, 85.94, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 2, 0.14, 13, 0.15, 0.01, 1.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 3, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 4, 1.10, 13, 1.19, 0.10, 10.78, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 5, 33.41, 13, 21.18, 5.93, 79.97, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 6, 18.70, 13, 16.72, 2.05, 71.63, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 7, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 8, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 9, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 1, 21.89, 13, 17.05, 3.09, 71.10, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 2, 1.38, 13, 1.27, 0.18, 9.68, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 3, 24.63, 13, 20.38, 2.90, 78.13, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 4, 0.14, 13, 0.15, 0.01, 1.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 5, 33.41, 13, 21.18, 5.93, 79.97, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 6, 0.14, 13, 0.16, 0.01, 1.72, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 7, 18.42, 13, 16.70, 1.97, 71.78, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 8, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 9, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 2, 20.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 5, 10.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 6, 30.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 7, 10.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 8, 25.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 10, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 5, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 6, 10.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 7, 35.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 8, 15.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 9, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 10, 10.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 11, 20.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 1, 10.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 2, 20.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 3, 20.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 4, 15.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 5, 20.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 6, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 7, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 8, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 1, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 2, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 3, 25.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 4, 15.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 5, 30.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 6, 10.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 8, 10.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 1, 0.00, 18, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 2, 0.00, 18, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 3, 0.00, 18, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 4, 0.43, 18, 0.46, 0.04, 4.10, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 5, 10.51, 18, 9.46, 1.39, 49.52, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 6, 64.85, 18, 18.39, 25.16, 91.01, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 7, 0.00, 18, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 8, 2.57, 18, 1.49, 0.74, 8.48, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 9, 0.00, 18, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 10, 21.65, 18, 18.74, 2.61, 73.99, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 11, 0.00, 18, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 12, 0.00, 18, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 1, 0.00, 18, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 2, 0.00, 18, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 3, 0.00, 18, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 4, 0.00, 18, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 5, 0.00, 18, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 6, 32.16, 18, 18.46, 7.36, 73.86, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 7, 22.07, 18, 19.32, 2.58, 75.18, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 8, 0.86, 18, 0.70, 0.15, 4.71, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 9, 0.43, 18, 0.46, 0.04, 4.10, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 10, 22.93, 18, 18.71, 3.09, 73.53, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 11, 21.55, 18, 12.52, 5.45, 56.71, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 1, 0.86, 18, 0.70, 0.15, 4.71, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 2, 21.65, 18, 18.74, 2.61, 73.99, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 3, 10.94, 18, 9.47, 1.55, 48.85, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 4, 31.84, 18, 20.41, 6.03, 77.26, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 5, 11.37, 18, 9.48, 1.73, 48.29, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 6, 22.07, 18, 18.73, 2.77, 73.81, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 7, 0.43, 18, 0.46, 0.04, 4.10, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 8, 0.86, 18, 0.70, 0.15, 4.71, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 9, 0.00, 18, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 1, 0.00, 17, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 2, 11.84, 17, 9.54, 1.90, 48.22, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 3, 22.60, 17, 18.80, 2.91, 74.02, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 4, 22.17, 17, 19.40, 2.56, 75.54, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 5, 42.53, 17, 18.96, 12.50, 79.31, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 6, 0.43, 17, 0.47, 0.04, 4.16, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 7, 0.43, 17, 0.47, 0.04, 4.16, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 8, 0.00, 17, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 9, 0.00, 17, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 3, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 4, 9.09, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 5, 13.64, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 6, 50.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 7, 13.64, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 8, 13.64, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 10, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 11, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 1, 4.55, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 3, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 4, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 5, 9.09, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 6, 9.09, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 7, 18.18, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 8, 27.27, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 9, 27.27, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 10, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 11, 4.55, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 1, 13.64, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 2, 18.18, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 3, 9.09, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 4, 4.55, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 5, 22.73, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 6, 22.73, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 7, 9.09, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 8, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 1, 4.55, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 3, 9.09, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 4, 4.55, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 5, 36.36, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 6, 22.73, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 7, 22.73, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 8, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 1, 0.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 2, 0.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 3, 4.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 4, 12.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 5, 8.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 6, 56.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 7, 0.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 8, 20.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 9, 0.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 10, 0.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 11, 0.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 12, 0.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 1, 8.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 2, 0.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 3, 0.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 4, 0.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 5, 0.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 6, 20.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 7, 28.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 8, 20.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 9, 4.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 10, 12.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 11, 8.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 1, 12.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 2, 4.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 3, 20.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 4, 20.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 5, 20.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 6, 0.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 7, 16.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 8, 4.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 9, 4.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 1, 0.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 2, 0.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 3, 20.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 4, 28.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 5, 20.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 6, 16.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 7, 8.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 8, 8.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 9, 0.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 1, 0.00, 19, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 2, 8.63, 19, 7.94, 1.13, 43.91, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 3, 0.00, 19, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 4, 7.38, 19, 7.28, 0.84, 42.73, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 5, 8.23, 19, 7.91, 0.98, 44.77, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 6, 50.62, 19, 17.52, 19.03, 81.72, 'Y', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 7, 0.00, 19, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 8, 19.50, 19, 16.16, 2.71, 67.82, 'Y', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 9, 0.00, 19, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 10, 5.65, 19, 5.67, 0.64, 35.88, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 11, 0.00, 19, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 12, 0.00, 19, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 1, 0.00, 19, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 2, 0.00, 19, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 3, 0.00, 19, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 4, 0.00, 19, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 5, 8.07, 19, 7.91, 0.93, 45.16, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 6, 15.44, 19, 10.55, 3.24, 49.92, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 7, 51.09, 19, 17.51, 19.33, 82.00, 'Y', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 8, 18.99, 19, 16.19, 2.50, 68.14, 'Y', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 9, 0.00, 19, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 10, 5.65, 19, 5.67, 0.64, 35.88, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 11, 0.76, 19, 0.61, 0.14, 4.04, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 1, 14.45, 19, 12.81, 1.88, 59.84, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 2, 19.13, 19, 16.19, 2.56, 68.06, 'Y', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 3, 4.58, 19, 4.38, 0.58, 28.29, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 4, 42.19, 19, 17.25, 14.17, 76.33, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 5, 0.00, 19, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 6, 19.65, 19, 11.03, 5.34, 51.47, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 7, 0.00, 19, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 8, 0.00, 19, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 9, 0.00, 19, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 1, 14.71, 18, 13.54, 1.74, 62.68, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 2, 0.48, 18, 0.52, 0.05, 4.49, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 3, 19.41, 18, 11.20, 5.05, 52.16, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 4, 55.95, 18, 17.62, 21.94, 85.16, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 5, 0.00, 18, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 6, 9.27, 18, 8.44, 1.22, 45.89, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 7, 0.17, 18, 0.18, 0.02, 1.55, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 8, 0.00, 18, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 9, 0.00, 18, 0.00, NULL, NULL, 'N', '2005-12-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 1, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 2, 6.18, 22, 4.59, 1.26, 25.45, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 3, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 4, 14.87, 22, 8.92, 3.88, 43.05, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 5, 28.71, 22, 9.71, 13.06, 51.92, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 6, 47.95, 22, 12.20, 25.00, 71.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 7, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 8, 2.28, 22, 2.32, 0.27, 16.87, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 9, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 10, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 11, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 12, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 1, 5.01, 22, 4.90, 0.62, 31.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 2, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 3, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 4, 4.58, 22, 4.53, 0.55, 29.35, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 5, 4.58, 22, 4.56, 0.54, 29.58, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 6, 32.99, 22, 13.39, 12.26, 63.43, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 7, 44.27, 22, 12.39, 21.85, 69.29, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 8, 4.58, 22, 4.56, 0.54, 29.58, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 9, 4.01, 22, 3.99, 0.48, 26.49, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 10, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 11, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 1, 3.22, 22, 3.25, 0.38, 22.56, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 2, 61.58, 22, 10.65, 38.59, 80.34, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 3, 15.23, 22, 7.08, 5.43, 35.98, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 4, 7.86, 22, 5.62, 1.67, 29.97, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 5, 12.11, 22, 6.63, 3.63, 33.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 6, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 7, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 8, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 9, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 1, 8.74, 22, 6.12, 1.90, 32.07, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 2, 14.55, 22, 6.94, 5.06, 35.22, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 3, 32.22, 22, 13.30, 11.82, 62.78, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 4, 23.04, 22, 10.29, 8.21, 50.03, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 5, 16.44, 22, 7.64, 5.83, 38.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 6, 5.01, 22, 4.90, 0.62, 31.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 7, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 8, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 9, 0.00, 22, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 1, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 2, 3.12, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 3, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 4, 9.38, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 5, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 6, 78.12, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 7, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 8, 6.25, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 9, 3.12, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 10, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 11, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 12, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 1, 6.25, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 2, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 3, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 4, 3.12, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 5, 3.12, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 6, 12.50, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 7, 34.38, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 8, 21.88, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 9, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 10, 12.50, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 11, 6.25, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 1, 40.62, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 2, 28.12, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 3, 15.62, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 4, 6.25, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 5, 6.25, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 6, 3.12, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 7, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 8, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 9, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 1, 21.88, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 2, 34.38, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 3, 12.50, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 4, 9.38, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 5, 15.62, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 6, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 7, 6.25, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 8, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 9, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 1, 0.00, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 2, 0.00, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 3, 0.00, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 4, 5.26, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 5, 5.26, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 6, 89.47, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 7, 0.00, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 8, 0.00, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 9, 0.00, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 10, 0.00, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 11, 0.00, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 12, 0.00, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 4, 5.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 6, 5.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 7, 25.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 8, 40.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 9, 25.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 10, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 1, 40.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 2, 5.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 3, 10.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 4, 15.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 5, 20.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 6, 10.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 1, 5.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 2, 15.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 3, 10.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 4, 20.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 5, 20.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 6, 25.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 8, 5.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 1, 0.00, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 2, 0.00, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 3, 2.78, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 4, 2.78, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 5, 5.56, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 6, 58.33, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 7, 11.11, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 8, 16.67, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 9, 2.78, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 10, 0.00, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 11, 0.00, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 12, 0.00, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 1, 2.86, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 2, 0.00, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 3, 0.00, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 4, 2.86, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 5, 2.86, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 6, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 7, 37.14, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 8, 37.14, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 9, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 10, 0.00, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 11, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 1, 14.29, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 2, 14.29, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 3, 22.86, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 4, 11.43, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 5, 20.00, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 6, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 7, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 8, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 9, 0.00, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 1, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 2, 14.29, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 3, 25.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 4, 22.86, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 5, 11.43, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 6, 11.43, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 7, 2.86, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 8, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 9, 0.00, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 4, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 6, 70.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 7, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 8, 20.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 10, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 11, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 12, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 4, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 5, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 6, 20.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 7, 33.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 8, 20.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 9, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 10, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 11, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 1, 54.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 2, 12.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 3, 16.67, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 4, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 5, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 6, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 8, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 1, 16.67, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 2, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 3, 16.67, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 4, 33.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 5, 12.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 6, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 7, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 8, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 2, 33.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 3, 33.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 4, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 5, 25.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 6, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 10, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 11, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 12, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 1, 13.04, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 2, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 3, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 4, 8.70, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 5, 21.74, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 6, 39.13, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 7, 13.04, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 8, 4.35, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 10, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 11, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 2, 37.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 3, 29.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 4, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 5, 12.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 6, 12.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 2, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 3, 37.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 4, 29.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 5, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 6, 16.67, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.02', '2.D.1', 'RL', 1, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.02', '2.D.1', 'RL', 2, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.02', '2.D.1', 'RL', 3, 7.69, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.02', '2.D.1', 'RL', 4, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.02', '2.D.1', 'RL', 5, 15.38, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.02', '2.D.1', 'RL', 6, 61.54, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_c