/*! START TRANSACTION */;
CREATE TABLE work_context (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  category DECIMAL(3,0),
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(5,2),
  lower_ci_bound DECIMAL(5,2),
  upper_ci_bound DECIMAL(5,2),
  recommend_suppress CHARACTER(1),
  not_relevant CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id),
  FOREIGN KEY (element_id, scale_id, category) REFERENCES work_context_categories(element_id, scale_id, category));
/*! COMMIT */;
/*! START TRANSACTION */;

INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CX', NULL, 3.39, 25, 0.22, 2.93, 3.86, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CXP', 1, 6.02, 25, 5.14, 0.97, 29.49, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CXP', 2, 12.40, 25, 7.33, 3.39, 36.32, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CXP', 3, 23.36, 25, 10.36, 8.45, 50.16, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CXP', 4, 52.55, 25, 12.13, 28.87, 75.14, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CXP', 5, 5.67, 25, 5.53, 0.70, 33.73, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CX', NULL, 5.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CXP', 5, 100.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CX', NULL, 5.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CXP', 5, 100.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CX', NULL, 4.33, 25, 0.19, 3.94, 4.73, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CXP', 3, 20.06, 25, 9.09, 7.22, 44.72, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CXP', 4, 26.54, 25, 10.75, 10.37, 53.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CXP', 5, 53.40, 25, 12.57, 28.78, 76.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CX', NULL, 4.98, 25, 0.01, 4.95, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CXP', 4, 1.98, 25, 1.47, 0.42, 8.84, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CXP', 5, 98.02, 25, 1.47, 91.16, 99.58, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CX', NULL, 4.80, 25, 0.09, 4.61, 4.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CXP', 3, 2.68, 25, 2.62, 0.34, 17.99, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CXP', 4, 14.83, 25, 7.76, 4.67, 38.24, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CXP', 5, 82.49, 25, 7.98, 60.11, 93.64, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CX', NULL, 4.74, 25, 0.11, 4.51, 4.97, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CXP', 3, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CXP', 4, 26.23, 25, 11.06, 9.85, 53.63, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CXP', 5, 73.77, 25, 11.06, 46.37, 90.15, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CX', NULL, 4.33, 25, 0.20, 3.91, 4.75, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CXP', 3, 19.62, 25, 10.59, 5.76, 49.39, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CXP', 4, 27.76, 25, 10.85, 11.18, 54.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CXP', 5, 52.62, 25, 12.33, 28.57, 75.50, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CX', NULL, 4.69, 25, 0.13, 4.42, 4.96, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CXP', 3, 7.18, 25, 5.45, 1.41, 29.48, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CXP', 4, 16.53, 25, 8.19, 5.49, 40.28, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CXP', 5, 76.30, 25, 9.39, 52.43, 90.39, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CX', NULL, 3.80, 25, 0.31, 3.16, 4.43, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CXP', 2, 21.46, 25, 10.57, 6.97, 49.92, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CXP', 3, 23.08, 25, 10.74, 7.93, 51.11, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CXP', 4, 9.86, 25, 6.03, 2.62, 30.72, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CXP', 5, 45.61, 25, 12.21, 23.29, 69.84, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CX', NULL, 4.45, 25, 0.18, 4.08, 4.82, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CXP', 2, 7.86, 25, 5.61, 1.70, 29.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CXP', 3, 2.00, 25, 2.02, 0.24, 14.69, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CXP', 4, 27.49, 25, 11.33, 10.50, 55.06, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CXP', 5, 62.65, 25, 11.41, 38.00, 82.11, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CX', NULL, 4.06, 25, 0.17, 3.70, 4.41, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CXP', 2, 5.18, 25, 5.07, 0.64, 31.52, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CXP', 3, 9.74, 25, 6.23, 2.44, 31.76, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CXP', 4, 59.40, 25, 11.88, 34.60, 80.18, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CXP', 5, 25.69, 25, 10.58, 9.92, 52.04, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CX', NULL, 3.57, 25, 0.24, 3.07, 4.08, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CXP', 2, 12.72, 25, 8.76, 2.78, 42.64, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CXP', 3, 40.82, 25, 12.17, 19.61, 66.10, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CXP', 4, 22.82, 25, 9.46, 8.90, 47.24, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CXP', 5, 23.64, 25, 10.56, 8.47, 50.88, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CX', NULL, 1.86, 25, 0.23, 1.40, 2.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CXP', 1, 46.45, 25, 12.21, 23.95, 70.49, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CXP', 2, 27.73, 25, 10.26, 11.78, 52.46, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CXP', 3, 21.86, 25, 10.99, 6.91, 51.35, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CXP', 4, 1.00, 25, 1.02, 0.12, 7.84, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CXP', 5, 2.96, 25, 2.98, 0.36, 20.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CX', NULL, 4.90, 25, 0.06, 4.78, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CXP', 1, 0.77, 25, 0.78, 0.09, 6.08, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CXP', 2, 1.00, 25, 1.02, 0.12, 7.84, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CXP', 3, 1.43, 25, 1.46, 0.17, 10.94, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CXP', 4, 1.13, 25, 1.16, 0.13, 8.85, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CXP', 5, 95.67, 25, 2.37, 87.14, 98.63, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CX', NULL, 2.26, 25, 0.32, 1.60, 2.93, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CXP', 1, 45.17, 25, 12.18, 22.99, 69.45, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CXP', 2, 15.12, 25, 8.19, 4.55, 39.95, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CXP', 3, 13.03, 25, 7.99, 3.38, 39.08, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CXP', 4, 21.75, 25, 10.83, 6.96, 50.82, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CXP', 5, 4.93, 25, 3.38, 1.16, 18.69, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CX', NULL, 2.21, 25, 0.32, 1.54, 2.87, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CXP', 1, 46.93, 25, 12.52, 23.86, 71.39, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CXP', 2, 14.13, 25, 8.07, 4.00, 39.38, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CXP', 3, 13.36, 25, 8.91, 3.06, 43.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CXP', 4, 22.62, 25, 10.82, 7.54, 51.16, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CXP', 5, 2.96, 25, 2.98, 0.36, 20.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CX', NULL, 1.65, 25, 0.22, 1.20, 2.11, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CXP', 1, 63.67, 25, 11.63, 38.30, 83.18, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CXP', 2, 18.77, 25, 9.21, 6.23, 44.58, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CXP', 3, 9.01, 25, 7.32, 1.54, 38.48, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CXP', 4, 5.59, 25, 4.77, 0.91, 27.64, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CXP', 5, 2.96, 25, 2.98, 0.36, 20.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CX', NULL, 1.60, 25, 0.30, 1.00, 2.22, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CXP', 1, 75.73, 25, 10.94, 47.73, 91.43, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CXP', 2, 4.74, 25, 4.68, 0.58, 29.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CXP', 3, 6.62, 25, 5.78, 1.02, 32.77, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CXP', 4, 9.94, 25, 9.21, 1.30, 47.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CXP', 5, 2.96, 25, 2.98, 0.36, 20.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CX', NULL, 3.04, 25, 0.33, 2.37, 3.71, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CXP', 1, 24.49, 25, 9.37, 10.23, 48.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CXP', 2, 9.31, 25, 6.25, 2.18, 32.10, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CXP', 3, 23.41, 25, 11.39, 7.61, 53.14, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CXP', 4, 23.62, 25, 11.61, 7.57, 53.85, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CXP', 5, 19.18, 25, 8.79, 6.86, 43.34, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CX', NULL, 2.73, 24, 0.29, 2.14, 3.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CXP', 1, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CXP', 2, 71.10, 24, 10.68, 45.63, 87.82, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CXP', 3, 1.55, 24, 1.57, 0.19, 11.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CXP', 4, 10.50, 24, 6.90, 2.51, 34.90, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CXP', 5, 16.85, 24, 9.16, 4.98, 43.95, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CX', NULL, 2.94, 24, 0.32, 2.29, 3.59, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CXP', 1, 17.79, 24, 8.53, 6.08, 41.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CXP', 2, 25.97, 24, 11.70, 9.06, 55.27, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CXP', 3, 16.09, 24, 8.73, 4.79, 42.20, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CXP', 4, 24.77, 24, 12.25, 7.79, 56.20, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CXP', 5, 15.38, 24, 7.92, 4.91, 39.01, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CX', NULL, 2.03, 25, 0.34, 1.32, 2.74, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CXP', 1, 59.48, 25, 12.12, 34.20, 80.57, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CXP', 2, 12.29, 25, 7.84, 3.03, 38.59, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CXP', 3, 1.43, 25, 1.46, 0.17, 10.94, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CXP', 4, 19.10, 25, 10.43, 5.53, 48.75, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CXP', 5, 7.70, 25, 5.01, 1.91, 26.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CX', NULL, 1.88, 25, 0.32, 1.21, 2.54, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CXP', 1, 63.74, 25, 12.09, 37.39, 83.81, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CXP', 2, 10.27, 25, 8.51, 1.67, 43.51, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CXP', 3, 8.34, 25, 6.03, 1.76, 31.64, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CXP', 4, 9.94, 25, 9.21, 1.30, 47.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CXP', 5, 7.70, 25, 5.01, 1.91, 26.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CX', NULL, 2.30, 25, 0.31, 1.66, 2.94, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CXP', 1, 36.11, 25, 11.68, 16.59, 61.63, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CXP', 2, 28.63, 25, 11.34, 11.32, 55.77, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CXP', 3, 12.44, 25, 7.94, 3.06, 38.99, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CXP', 4, 15.12, 25, 10.06, 3.41, 47.30, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CXP', 5, 7.70, 25, 5.01, 1.91, 26.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CX', NULL, 1.45, 25, 0.21, 1.02, 1.89, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CXP', 1, 74.30, 25, 11.00, 46.82, 90.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CXP', 2, 11.95, 25, 7.44, 3.06, 36.88, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CXP', 3, 10.79, 25, 9.20, 1.65, 46.54, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CXP', 5, 2.96, 25, 2.98, 0.36, 20.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CX', NULL, 1.61, 25, 0.32, 1.00, 2.27, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CXP', 1, 82.36, 25, 9.91, 53.31, 95.02, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CXP', 4, 9.94, 25, 9.21, 1.30, 47.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CXP', 5, 7.70, 25, 5.01, 1.91, 26.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CX', NULL, 1.06, 25, 0.05, 1.00, 1.16, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CXP', 1, 94.26, 25, 4.80, 72.46, 99.03, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CXP', 2, 5.74, 25, 4.80, 0.97, 27.54, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CX', NULL, 1.72, 25, 0.22, 1.26, 2.17, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CXP', 1, 61.16, 25, 12.16, 35.38, 81.91, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CXP', 2, 11.83, 25, 8.84, 2.28, 43.54, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CXP', 3, 22.33, 25, 11.08, 7.14, 51.81, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CXP', 4, 3.68, 25, 2.78, 0.75, 16.18, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CXP', 5, 1.00, 25, 1.02, 0.12, 7.84, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CX', NULL, 1.48, 25, 0.21, 1.04, 1.92, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CXP', 1, 75.85, 25, 10.77, 48.27, 91.35, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CXP', 2, 15.61, 25, 10.24, 3.58, 47.92, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CXP', 3, 0.84, 25, 0.86, 0.10, 6.65, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CXP', 5, 7.70, 25, 5.01, 1.91, 26.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CX', NULL, 1.65, 25, 0.23, 1.18, 2.13, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CXP', 1, 65.84, 25, 11.75, 39.61, 84.99, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CXP', 2, 19.95, 25, 10.91, 5.74, 50.52, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CXP', 3, 5.67, 25, 5.53, 0.70, 33.73, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CXP', 5, 8.54, 25, 5.10, 2.37, 26.44, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CX', NULL, 2.16, 24, 0.36, 1.42, 2.91, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CXP', 1, 53.28, 24, 12.62, 28.55, 76.50, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CXP', 2, 12.94, 24, 8.16, 3.21, 39.95, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CXP', 3, 8.66, 24, 7.43, 1.34, 39.83, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CXP', 4, 14.42, 24, 9.75, 3.18, 46.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CXP', 5, 10.69, 24, 7.30, 2.41, 36.78, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CX', NULL, 1.49, 25, 0.25, 1.00, 2.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CXP', 1, 75.58, 25, 10.96, 47.61, 91.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CXP', 2, 9.74, 25, 6.53, 2.27, 33.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CXP', 3, 9.94, 25, 9.21, 1.30, 47.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CXP', 5, 4.74, 25, 4.68, 0.58, 29.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CX', NULL, 3.83, 25, 0.20, 3.42, 4.23, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CXP', 3, 38.61, 25, 12.42, 17.58, 64.97, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CXP', 4, 40.21, 25, 12.36, 18.88, 66.02, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CXP', 5, 21.18, 25, 10.76, 6.64, 50.40, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CX', NULL, 2.34, 25, 0.12, 2.10, 2.59, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CXP', 1, 0.84, 25, 0.85, 0.10, 6.53, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CXP', 2, 64.13, 25, 11.78, 38.33, 83.72, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CXP', 3, 35.03, 25, 11.79, 15.62, 61.10, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CX', NULL, 1.24, 25, 0.11, 1.02, 1.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CXP', 1, 75.73, 25, 10.94, 47.73, 91.43, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CXP', 2, 24.27, 25, 10.94, 8.57, 52.27, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CX', NULL, 2.14, 25, 0.11, 1.92, 2.36, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CXP', 1, 2.84, 25, 2.22, 0.55, 13.30, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CXP', 2, 80.55, 25, 10.31, 51.56, 94.16, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CXP', 3, 16.61, 25, 10.25, 4.14, 47.83, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CX', NULL, 1.43, 25, 0.19, 1.05, 1.82, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CXP', 1, 66.88, 25, 11.45, 40.99, 85.44, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CXP', 2, 23.18, 25, 9.15, 9.46, 46.56, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CXP', 3, 9.94, 25, 9.21, 1.30, 47.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CX', NULL, 1.34, 25, 0.19, 1.00, 1.73, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CXP', 1, 75.73, 25, 10.94, 47.73, 91.43, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CXP', 2, 14.33, 25, 7.55, 4.48, 37.32, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CXP', 3, 9.94, 25, 9.21, 1.30, 47.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CX', NULL, 1.86, 25, 0.25, 1.36, 2.37, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CXP', 1, 48.35, 25, 12.18, 25.49, 71.92, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CXP', 2, 29.22, 25, 10.98, 12.12, 55.27, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CXP', 3, 10.04, 25, 8.61, 1.54, 44.37, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CXP', 4, 12.39, 25, 7.55, 3.26, 37.26, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CXP', 5, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CX', NULL, 1.48, 24, 0.21, 1.05, 1.92, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CXP', 1, 67.48, 24, 11.67, 40.85, 86.18, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CXP', 2, 16.68, 24, 7.46, 6.19, 37.79, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CXP', 3, 15.84, 24, 10.45, 3.59, 48.80, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CXP', 4, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CX', NULL, 2.19, 25, 0.28, 1.61, 2.77, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CXP', 1, 37.98, 25, 11.71, 18.00, 63.07, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CXP', 2, 24.46, 25, 9.44, 10.14, 48.16, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CXP', 3, 24.96, 25, 12.11, 8.05, 55.80, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CXP', 4, 5.95, 25, 5.13, 0.94, 29.58, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CXP', 5, 6.66, 25, 5.63, 1.09, 31.61, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CX', NULL, 2.01, 25, 0.29, 1.41, 2.61, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CXP', 1, 47.09, 25, 12.52, 23.98, 71.51, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CXP', 2, 31.05, 25, 11.55, 12.88, 57.83, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CXP', 3, 0.84, 25, 0.85, 0.10, 6.53, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CXP', 4, 16.08, 25, 9.96, 4.01, 46.79, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CXP', 5, 4.93, 25, 3.38, 1.16, 18.69, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CX', NULL, 1.35, 25, 0.17, 1.00, 1.71, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CXP', 1, 84.28, 25, 7.70, 61.75, 94.68, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CXP', 2, 7.18, 25, 5.88, 1.24, 32.34, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CXP', 3, 0.84, 25, 0.86, 0.10, 6.65, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CXP', 4, 4.74, 25, 4.68, 0.58, 29.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CXP', 5, 2.96, 25, 2.98, 0.36, 20.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CX', NULL, 3.45, 25, 0.38, 2.66, 4.24, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CXP', 1, 18.54, 25, 9.88, 5.57, 46.77, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CXP', 2, 11.17, 25, 8.65, 2.04, 43.20, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CXP', 3, 15.53, 25, 9.80, 3.79, 46.22, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CXP', 4, 16.26, 25, 8.24, 5.27, 40.39, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CXP', 5, 38.49, 25, 11.76, 18.34, 63.55, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CX', NULL, 4.87, 25, 0.09, 4.69, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CXP', 3, 0.84, 25, 0.86, 0.10, 6.65, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CXP', 4, 11.70, 25, 8.61, 2.32, 42.51, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CXP', 5, 87.46, 25, 8.64, 57.86, 97.25, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CX', NULL, 4.91, 25, 0.06, 4.79, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CXP', 3, 3.52, 25, 2.76, 0.68, 16.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CXP', 4, 2.24, 25, 1.67, 0.47, 9.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CXP', 5, 94.23, 25, 3.22, 82.79, 98.23, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CX', NULL, 4.91, 25, 0.06, 4.79, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CXP', 3, 1.00, 25, 1.02, 0.12, 7.84, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CXP', 4, 6.62, 25, 5.78, 1.02, 32.77, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CXP', 5, 92.38, 25, 5.88, 68.36, 98.55, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CX', NULL, 2.68, 24, 0.26, 2.13, 3.22, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CXP', 1, 22.82, 24, 8.64, 9.67, 44.94, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CXP', 2, 22.62, 24, 10.49, 7.80, 50.25, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CXP', 3, 18.66, 24, 11.50, 4.56, 52.37, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CXP', 4, 35.91, 24, 11.74, 16.32, 61.67, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CXP', 5, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CX', NULL, 4.16, 24, 0.20, 3.75, 4.57, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CXP', 1, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CXP', 2, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CXP', 3, 24.43, 24, 10.35, 9.21, 50.75, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CXP', 4, 35.09, 24, 12.11, 15.26, 61.88, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CXP', 5, 40.47, 24, 12.87, 18.38, 67.24, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CX', NULL, 3.23, 24, 0.30, 2.60, 3.86, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CXP', 1, 14.93, 24, 8.16, 4.44, 39.86, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CXP', 2, 15.11, 24, 8.13, 4.58, 39.77, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CXP', 3, 17.19, 24, 10.42, 4.37, 48.54, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CXP', 4, 37.40, 24, 12.47, 16.57, 64.25, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CXP', 5, 15.37, 24, 8.56, 4.45, 41.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CX', NULL, 4.98, 24, 0.01, 4.95, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CXP', 1, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CXP', 2, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CXP', 3, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CXP', 4, 1.96, 24, 1.45, 0.42, 8.71, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CXP', 5, 98.04, 24, 1.45, 91.29, 99.58, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CX', NULL, 4.18, 24, 0.25, 3.66, 4.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CXP', 1, 2.85, 24, 2.78, 0.37, 18.97, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CXP', 2, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CXP', 3, 27.44, 24, 12.26, 9.57, 57.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CXP', 4, 15.74, 24, 8.18, 4.96, 40.09, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CXP', 5, 53.96, 24, 12.94, 28.53, 77.49, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CX', NULL, 4.20, 24, 0.22, 3.75, 4.65, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CXP', 1, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CXP', 2, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CXP', 3, 27.13, 24, 11.41, 10.13, 55.13, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CXP', 4, 25.70, 24, 10.26, 10.22, 51.25, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CXP', 5, 47.17, 24, 12.74, 23.67, 72.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CX', NULL, 1.66, 24, 0.24, 1.17, 2.15, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CXP', 1, 66.77, 24, 12.26, 39.06, 86.30, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CXP', 2, 11.79, 24, 9.77, 1.88, 48.25, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CXP', 3, 13.24, 24, 8.43, 3.24, 41.04, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CXP', 4, 5.05, 24, 4.98, 0.62, 31.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CXP', 5, 3.15, 24, 3.18, 0.38, 21.91, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.4', 'CT', NULL, 1.30, 24, 0.13, 1.03, 1.57, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.4', 'CTP', 1, 74.85, 24, 10.59, 48.17, 90.51, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.4', 'CTP', 2, 20.10, 24, 10.03, 6.47, 47.80, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.4', 'CTP', 3, 5.05, 24, 4.98, 0.62, 31.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.8', 'CT', NULL, 2.89, 23, 0.11, 2.66, 3.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.8', 'CTP', 1, 5.61, 23, 5.49, 0.69, 33.79, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.8', 'CTP', 2, 0.00, 23, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.8', 'CTP', 3, 94.39, 23, 5.49, 66.21, 99.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CX', NULL, 2.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CXP', 2, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CXP', 3, 61.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CXP', 4, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CX', NULL, 4.88, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CXP', 4, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CXP', 5, 88.46, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CX', NULL, 4.96, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CXP', 4, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CXP', 5, 96.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CX', NULL, 3.96, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CXP', 3, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CXP', 4, 60.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CXP', 5, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CX', NULL, 4.76, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CXP', 3, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CXP', 4, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CXP', 5, 80.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CX', NULL, 4.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CXP', 3, 15.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CXP', 4, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CXP', 5, 53.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CX', NULL, 4.48, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CXP', 3, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CXP', 4, 44.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CXP', 5, 52.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CX', NULL, 3.73, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CXP', 1, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CXP', 2, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CXP', 3, 15.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CXP', 4, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CXP', 5, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CX', NULL, 4.12, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CXP', 3, 19.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CXP', 4, 50.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CXP', 5, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CX', NULL, 2.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CXP', 1, 19.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CXP', 2, 42.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CXP', 3, 15.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CXP', 4, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CXP', 5, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CX', NULL, 3.36, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CXP', 1, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CXP', 2, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CXP', 3, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CXP', 4, 44.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CXP', 5, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CX', NULL, 2.76, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CXP', 1, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CXP', 2, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CXP', 3, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CXP', 4, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CXP', 5, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CX', NULL, 2.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CXP', 1, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CXP', 2, 53.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CXP', 3, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CXP', 4, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CX', NULL, 1.04, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CXP', 1, 96.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CX', NULL, 4.46, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CXP', 1, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CXP', 2, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CXP', 4, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CXP', 5, 76.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CX', NULL, 2.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CXP', 1, 26.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CXP', 2, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CXP', 3, 19.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CXP', 4, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CX', NULL, 1.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CXP', 1, 34.62, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CXP', 2, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CXP', 3, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CXP', 4, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CX', NULL, 1.84, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CXP', 1, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CXP', 2, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CXP', 3, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CXP', 4, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CX', NULL, 1.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CXP', 1, 100.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CX', NULL, 2.72, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CXP', 1, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CXP', 2, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CXP', 3, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CXP', 4, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CXP', 5, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CX', NULL, 2.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CXP', 2, 26.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CXP', 3, 61.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CXP', 4, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CXP', 5, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CX', NULL, 2.04, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CXP', 1, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CXP', 2, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CXP', 3, 24.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CXP', 4, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CX', NULL, 1.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CXP', 1, 42.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CXP', 2, 50.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CXP', 4, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CX', NULL, 1.42, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CXP', 1, 57.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CXP', 2, 42.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CX', NULL, 1.65, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CXP', 1, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CXP', 2, 42.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CXP', 3, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CX', NULL, 1.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CXP', 1, 65.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CXP', 2, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CX', NULL, 1.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CXP', 1, 92.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CXP', 2, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CX', NULL, 1.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CXP', 1, 96.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CX', NULL, 1.12, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CXP', 1, 88.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CXP', 2, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CX', NULL, 1.50, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CXP', 1, 50.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CXP', 2, 50.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CX', NULL, 1.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CXP', 1, 76.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CXP', 2, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CX', NULL, 1.17, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CXP', 1, 87.50, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CXP', 2, 8.33, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CXP', 3, 4.17, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CXP', 4, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CXP', 5, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CX', NULL, 1.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CXP', 1, 84.62, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CXP', 2, 15.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CX', NULL, 4.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CXP', 3, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CXP', 4, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CXP', 5, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CX', NULL, 1.96, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CXP', 1, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CXP', 2, 88.46, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CX', NULL, 1.36, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CXP', 1, 64.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CXP', 2, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CX', NULL, 1.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CXP', 1, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CXP', 2, 69.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CXP', 5, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CX', NULL, 1.12, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CXP', 1, 88.46, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CXP', 2, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CX', NULL, 1.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CXP', 1, 92.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CXP', 2, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CX', NULL, 1.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CXP', 1, 73.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CXP', 2, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CXP', 5, 15.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CX', NULL, 1.19, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CXP', 1, 80.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CXP', 2, 19.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CX', NULL, 2.35, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CXP', 1, 53.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CXP', 2, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CXP', 4, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CXP', 5, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CX', NULL, 2.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CXP', 1, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CXP', 2, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CXP', 3, 19.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CXP', 4, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CXP', 5, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CX', NULL, 1.42, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CXP', 1, 73.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CXP', 2, 19.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CXP', 5, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CX', NULL, 2.35, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CXP', 1, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CXP', 2, 34.62, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CXP', 3, 26.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CXP', 4, 15.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CX', NULL, 3.92, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CXP', 3, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CXP', 4, 56.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CXP', 5, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CX', NULL, 3.60, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CXP', 2, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CXP', 3, 24.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CXP', 4, 44.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CXP', 5, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CX', NULL, 4.42, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CXP', 3, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CXP', 4, 34.62, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CXP', 5, 53.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CX', NULL, 1.72, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CXP', 1, 60.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CXP', 2, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CXP', 3, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CXP', 4, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CX', NULL, 3.42, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CXP', 2, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CXP', 3, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CXP', 4, 42.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CXP', 5, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CX', NULL, 2.24, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CXP', 1, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CXP', 2, 28.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CXP', 3, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CXP', 4, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CXP', 5, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CX', NULL, 4.36, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CXP', 3, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CXP', 4, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CXP', 5, 48.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CX', NULL, 3.46, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CXP', 2, 15.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CXP', 3, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CXP', 4, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CXP', 5, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CX', NULL, 3.65, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CXP', 2, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CXP', 3, 34.62, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CXP', 4, 53.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CXP', 5, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CX', NULL, 1.12, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CXP', 1, 96.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CXP', 4, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.4', 'CT', NULL, 1.35, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.4', 'CTP', 1, 65.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.4', 'CTP', 2, 34.62, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.4', 'CTP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.8', 'CT', NULL, 2.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.8', 'CTP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.8', 'CTP', 2, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.8', 'CTP', 3, 76.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CX', NULL, 2.68, 44, 0.25, 2.18, 3.19, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CXP', 1, 25.59, 44, 8.65, 12.10, 46.22, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CXP', 2, 19.29, 44, 6.90, 8.91, 36.89, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CXP', 3, 20.73, 44, 8.75, 8.20, 43.36, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CXP', 4, 29.91, 44, 10.49, 13.46, 53.93, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CXP', 5, 4.48, 44, 3.32, 0.97, 18.31, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CX', NULL, 5.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CXP', 4, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CXP', 5, 100.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CX', NULL, 4.26, 44, 0.31, 3.63, 4.89, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CXP', 1, 12.16, 44, 7.59, 3.19, 36.74, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CXP', 2, 3.04, 44, 3.03, 0.39, 19.99, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CXP', 4, 16.18, 44, 6.19, 7.13, 32.64, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CXP', 5, 68.63, 44, 9.46, 47.41, 84.15, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CX', NULL, 3.98, 44, 0.27, 3.42, 4.53, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CXP', 1, 7.39, 44, 7.02, 1.00, 38.68, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CXP', 2, 4.89, 44, 2.93, 1.42, 15.49, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CXP', 3, 11.48, 44, 5.50, 4.17, 27.86, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CXP', 4, 34.98, 44, 10.42, 17.59, 57.55, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CXP', 5, 41.25, 44, 10.44, 22.75, 62.61, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CX', NULL, 4.60, 44, 0.20, 4.20, 5.00, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CXP', 1, 4.93, 44, 4.81, 0.65, 29.14, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CXP', 2, 0.83, 44, 0.84, 0.11, 6.12, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CXP', 4, 17.49, 44, 7.41, 7.00, 37.38, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CXP', 5, 76.75, 44, 8.54, 55.70, 89.65, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CX', NULL, 4.76, 44, 0.09, 4.59, 4.93, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CXP', 2, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CXP', 3, 2.54, 44, 2.54, 0.33, 17.14, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CXP', 4, 18.78, 44, 7.15, 8.24, 37.32, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CXP', 5, 78.68, 44, 7.48, 60.04, 90.07, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CX', NULL, 4.28, 44, 0.24, 3.79, 4.76, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CXP', 1, 5.76, 44, 4.87, 0.99, 27.20, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CXP', 2, 3.09, 44, 3.11, 0.39, 20.55, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CXP', 3, 13.55, 44, 6.43, 4.93, 32.16, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CXP', 4, 12.83, 44, 5.77, 4.94, 29.40, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CXP', 5, 64.77, 44, 9.47, 44.33, 80.94, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CX', NULL, 4.48, 43, 0.17, 4.14, 4.82, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CXP', 1, 4.12, 43, 2.82, 1.01, 15.39, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CXP', 2, 2.88, 43, 2.59, 0.46, 16.15, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CXP', 3, 8.93, 43, 4.38, 3.20, 22.53, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CXP', 4, 8.85, 43, 4.80, 2.84, 24.39, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CXP', 5, 75.22, 43, 7.67, 56.94, 87.44, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CX', NULL, 4.20, 44, 0.14, 3.93, 4.48, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CXP', 2, 2.54, 44, 2.54, 0.33, 17.14, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CXP', 3, 12.03, 44, 5.71, 4.40, 28.86, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CXP', 4, 47.87, 44, 10.65, 27.97, 68.46, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CXP', 5, 37.57, 44, 9.98, 20.32, 58.67, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CX', NULL, 3.92, 44, 0.25, 3.41, 4.42, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CXP', 2, 17.17, 44, 7.94, 6.30, 38.98, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CXP', 3, 16.28, 44, 6.16, 7.25, 32.59, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CXP', 4, 24.19, 44, 8.25, 11.41, 44.14, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CXP', 5, 42.36, 44, 10.98, 22.88, 64.55, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CX', NULL, 4.35, 44, 0.22, 3.90, 4.79, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CXP', 2, 7.39, 44, 7.02, 1.00, 38.68, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CXP', 3, 11.57, 44, 5.11, 4.56, 26.36, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CXP', 4, 20.08, 44, 7.36, 9.05, 38.79, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CXP', 5, 60.96, 44, 9.83, 40.44, 78.21, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CX', NULL, 3.65, 44, 0.18, 3.28, 4.01, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CXP', 2, 6.46, 44, 4.05, 1.76, 21.05, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CXP', 3, 42.36, 44, 10.24, 23.97, 63.14, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CXP', 4, 31.08, 44, 9.54, 15.51, 52.54, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CXP', 5, 20.10, 44, 9.21, 7.33, 44.44, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CX', NULL, 3.39, 43, 0.21, 2.96, 3.82, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CXP', 1, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CXP', 2, 17.19, 43, 6.68, 7.45, 34.85, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CXP', 3, 38.66, 43, 10.09, 21.07, 59.80, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CXP', 4, 32.20, 43, 9.89, 15.98, 54.23, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CXP', 5, 11.96, 43, 9.73, 2.06, 46.71, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CX', NULL, 1.60, 44, 0.27, 1.05, 2.14, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CXP', 1, 67.23, 44, 9.85, 45.44, 83.48, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CXP', 2, 18.88, 44, 6.54, 8.96, 35.50, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CXP', 3, 0.69, 44, 0.50, 0.16, 2.95, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CXP', 4, 13.20, 44, 9.34, 2.85, 44.06, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CX', NULL, 4.60, 44, 0.19, 4.22, 4.98, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CXP', 1, 6.91, 44, 4.41, 1.82, 22.85, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CXP', 2, 0.37, 44, 0.38, 0.05, 2.81, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CXP', 3, 2.99, 44, 2.99, 0.39, 19.76, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CXP', 4, 5.31, 44, 3.41, 1.41, 18.02, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CXP', 5, 84.41, 44, 6.32, 67.26, 93.45, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CX', NULL, 1.84, 44, 0.23, 1.37, 2.31, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CXP', 1, 69.54, 44, 8.08, 51.41, 83.12, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CXP', 2, 5.32, 44, 3.25, 1.51, 17.08, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CXP', 3, 5.90, 44, 3.69, 1.61, 19.35, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CXP', 4, 10.34, 44, 5.42, 3.42, 27.28, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CXP', 5, 8.90, 44, 3.87, 3.60, 20.38, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CX', NULL, 1.80, 44, 0.21, 1.37, 2.22, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CXP', 1, 60.17, 44, 10.03, 39.37, 77.85, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CXP', 2, 13.20, 44, 5.66, 5.32, 29.16, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CXP', 3, 15.88, 44, 7.14, 6.04, 35.68, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CXP', 4, 8.38, 44, 5.09, 2.35, 25.83, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CXP', 5, 2.37, 44, 1.50, 0.65, 8.26, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CX', NULL, 1.42, 43, 0.15, 1.12, 1.73, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CXP', 1, 74.22, 43, 8.23, 54.72, 87.28, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CXP', 2, 14.55, 43, 5.78, 6.25, 30.33, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CXP', 3, 6.26, 43, 5.14, 1.13, 28.08, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CXP', 4, 4.63, 43, 3.35, 1.04, 18.30, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CXP', 5, 0.33, 43, 0.34, 0.04, 2.54, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CX', NULL, 1.19, 44, 0.10, 1.00, 1.40, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CXP', 1, 89.92, 44, 5.17, 73.86, 96.57, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CXP', 2, 2.97, 44, 1.61, 0.99, 8.61, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CXP', 3, 5.64, 44, 4.86, 0.94, 27.36, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CXP', 4, 0.80, 44, 0.81, 0.10, 5.93, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CXP', 5, 0.66, 44, 0.66, 0.08, 4.90, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CX', NULL, 2.40, 44, 0.32, 1.74, 3.05, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CXP', 1, 51.67, 44, 10.24, 31.86, 70.96, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CXP', 2, 5.14, 44, 3.00, 1.54, 15.79, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CXP', 3, 11.79, 44, 6.03, 3.99, 30.07, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CXP', 4, 14.70, 44, 7.93, 4.59, 38.15, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CXP', 5, 16.71, 44, 6.56, 7.20, 34.16, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CX', NULL, 3.10, 44, 0.19, 2.72, 3.48, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CXP', 2, 32.24, 44, 9.27, 16.81, 52.82, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CXP', 3, 30.34, 44, 8.32, 16.45, 49.07, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CXP', 4, 32.85, 44, 11.13, 15.02, 57.52, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CXP', 5, 4.58, 44, 3.26, 1.05, 17.76, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CX', NULL, 3.05, 44, 0.37, 2.30, 3.80, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CXP', 1, 28.53, 44, 9.47, 13.53, 50.46, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CXP', 2, 16.63, 44, 6.78, 6.93, 34.84, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CXP', 3, 6.65, 44, 4.89, 1.43, 25.85, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CXP', 4, 17.62, 44, 6.83, 7.65, 35.57, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CXP', 5, 30.56, 44, 10.78, 13.65, 55.07, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CX', NULL, 1.82, 44, 0.29, 1.24, 2.39, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CXP', 1, 60.81, 44, 9.78, 40.40, 78.03, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CXP', 2, 16.64, 44, 6.78, 6.93, 34.87, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CXP', 3, 10.72, 44, 5.78, 3.43, 28.89, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CXP', 4, 3.78, 44, 1.86, 1.38, 9.94, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CXP', 5, 8.05, 44, 7.02, 1.28, 37.23, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CX', NULL, 1.79, 43, 0.38, 1.03, 2.56, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CXP', 1, 65.36, 43, 10.54, 42.45, 82.84, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CXP', 2, 16.24, 43, 7.11, 6.33, 35.75, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CXP', 3, 3.58, 43, 1.78, 1.30, 9.51, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CXP', 4, 3.48, 43, 3.17, 0.53, 19.48, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CXP', 5, 11.34, 43, 9.80, 1.76, 47.77, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CX', NULL, 2.11, 43, 0.29, 1.52, 2.70, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CXP', 1, 58.19, 43, 9.55, 38.66, 75.45, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CXP', 2, 10.11, 43, 4.89, 3.66, 24.99, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CXP', 3, 7.35, 43, 3.75, 2.54, 19.43, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CXP', 4, 11.19, 43, 5.88, 3.68, 29.36, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CXP', 5, 13.15, 43, 6.20, 4.82, 31.16, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CX', NULL, 1.32, 44, 0.09, 1.13, 1.51, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CXP', 1, 74.49, 44, 7.77, 56.15, 86.94, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CXP', 2, 19.30, 44, 7.36, 8.44, 38.28, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CXP', 3, 6.21, 44, 3.36, 2.03, 17.47, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CXP', 4, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CX', NULL, 1.15, 44, 0.10, 1.00, 1.35, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CXP', 1, 89.97, 44, 5.70, 71.50, 96.98, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CXP', 2, 5.10, 44, 3.21, 1.39, 17.02, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CXP', 3, 4.93, 44, 4.81, 0.65, 29.14, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CX', NULL, 1.01, 44, 0.01, 1.00, 1.02, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CXP', 1, 99.68, 44, 0.32, 97.59, 99.96, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CXP', 2, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CXP', 3, 0.32, 44, 0.32, 0.04, 2.41, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CX', NULL, 1.68, 44, 0.32, 1.02, 2.33, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CXP', 1, 78.12, 44, 9.06, 55.06, 91.23, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CXP', 2, 3.34, 44, 2.68, 0.65, 15.53, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CXP', 3, 4.93, 44, 4.81, 0.65, 29.14, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CXP', 4, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CXP', 5, 13.61, 44, 7.96, 3.87, 38.17, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CX', NULL, 1.76, 44, 0.27, 1.23, 2.30, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CXP', 1, 55.70, 44, 10.25, 35.24, 74.39, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CXP', 2, 23.54, 44, 7.92, 11.24, 42.79, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CXP', 3, 10.02, 44, 5.14, 3.41, 25.99, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CXP', 4, 10.43, 44, 9.36, 1.52, 46.77, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CXP', 5, 0.32, 44, 0.32, 0.04, 2.41, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CX', NULL, 1.40, 44, 0.12, 1.16, 1.64, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CXP', 1, 72.55, 44, 8.59, 52.54, 86.32, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CXP', 2, 18.24, 44, 7.33, 7.65, 37.54, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CXP', 3, 6.45, 44, 3.67, 1.98, 19.03, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CXP', 4, 2.04, 44, 1.42, 0.50, 8.01, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CXP', 5, 0.71, 44, 0.72, 0.09, 5.32, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CX', NULL, 1.68, 44, 0.21, 1.26, 2.10, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CXP', 1, 69.29, 44, 8.33, 50.61, 83.24, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CXP', 2, 10.42, 44, 5.77, 3.24, 28.81, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CXP', 3, 8.85, 44, 3.97, 3.48, 20.75, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CXP', 4, 6.05, 44, 4.87, 1.13, 26.57, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CXP', 5, 5.39, 44, 3.33, 1.50, 17.54, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CX', NULL, 2.19, 44, 0.32, 1.54, 2.84, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CXP', 1, 50.88, 44, 10.41, 30.89, 70.58, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CXP', 2, 19.99, 44, 7.61, 8.73, 39.48, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CXP', 3, 3.19, 44, 1.56, 1.18, 8.34, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CXP', 4, 11.05, 44, 7.49, 2.60, 36.60, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CXP', 5, 14.91, 44, 7.54, 5.02, 36.73, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CX', NULL, 3.15, 44, 0.23, 2.68, 3.62, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CXP', 2, 40.05, 44, 11.14, 20.77, 63.00, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CXP', 3, 13.54, 44, 6.46, 4.89, 32.27, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CXP', 4, 37.62, 44, 9.10, 21.62, 56.86, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CXP', 5, 8.80, 44, 4.82, 2.79, 24.49, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CX', NULL, 3.13, 44, 0.27, 2.58, 3.68, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CXP', 1, 2.35, 44, 2.32, 0.31, 15.64, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CXP', 2, 40.08, 44, 9.77, 22.76, 60.30, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CXP', 3, 19.74, 44, 7.41, 8.74, 38.72, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CXP', 4, 18.20, 44, 9.79, 5.58, 45.59, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CXP', 5, 19.62, 44, 9.51, 6.75, 45.17, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CX', NULL, 1.40, 44, 0.10, 1.20, 1.61, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CXP', 1, 60.50, 44, 10.02, 39.68, 78.11, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CXP', 2, 38.86, 44, 10.03, 21.34, 59.83, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CXP', 3, 0.32, 44, 0.32, 0.04, 2.41, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CXP', 4, 0.32, 44, 0.32, 0.04, 2.41, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CX', NULL, 2.73, 44, 0.22, 2.29, 3.18, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CXP', 1, 2.60, 44, 1.75, 0.66, 9.68, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CXP', 2, 56.80, 44, 10.89, 34.95, 76.28, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CXP', 3, 10.80, 44, 7.54, 2.43, 37.01, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CXP', 4, 24.26, 44, 10.93, 8.80, 51.51, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CXP', 5, 5.55, 44, 4.00, 1.25, 21.47, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CX', NULL, 1.44, 43, 0.10, 1.24, 1.64, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CXP', 1, 57.10, 43, 9.74, 37.38, 74.80, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CXP', 2, 42.58, 43, 9.72, 24.95, 62.33, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CXP', 5, 0.32, 43, 0.32, 0.04, 2.42, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CX', NULL, 1.50, 44, 0.28, 1.00, 2.06, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CXP', 1, 74.82, 44, 9.39, 52.10, 89.03, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CXP', 2, 16.66, 44, 7.50, 6.31, 37.27, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CXP', 4, 1.12, 44, 0.80, 0.26, 4.67, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CXP', 5, 7.39, 44, 7.02, 1.00, 38.68, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CX', NULL, 2.77, 44, 0.37, 2.02, 3.52, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CXP', 1, 30.06, 44, 10.13, 13.99, 53.18, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CXP', 2, 26.25, 44, 7.97, 13.43, 44.95, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CXP', 3, 7.81, 44, 5.59, 1.74, 28.82, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CXP', 4, 8.02, 44, 4.54, 2.45, 23.19, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CXP', 5, 27.86, 44, 10.11, 12.28, 51.59, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CX', NULL, 1.91, 44, 0.28, 1.35, 2.46, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CXP', 1, 45.87, 44, 10.14, 27.12, 65.88, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CXP', 2, 37.79, 44, 10.12, 20.32, 59.14, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CXP', 3, 3.96, 44, 3.18, 0.76, 18.19, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CXP', 4, 4.66, 44, 3.93, 0.82, 22.52, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CXP', 5, 7.71, 44, 7.01, 1.13, 37.88, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CX', NULL, 2.43, 44, 0.30, 1.81, 3.04, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CXP', 1, 24.16, 44, 9.95, 9.62, 48.79, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CXP', 2, 43.43, 44, 10.37, 24.68, 64.26, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CXP', 3, 8.41, 44, 4.39, 2.83, 22.45, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CXP', 4, 13.77, 44, 8.06, 3.90, 38.58, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CXP', 5, 10.25, 44, 7.34, 2.23, 36.34, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CX', NULL, 2.35, 44, 0.34, 1.67, 3.03, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CXP', 1, 54.11, 44, 10.16, 34.06, 72.91, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CXP', 2, 4.96, 44, 2.71, 1.61, 14.28, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CXP', 3, 11.82, 44, 5.79, 4.19, 29.13, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CXP', 4, 10.19, 44, 4.74, 3.84, 24.39, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CXP', 5, 18.91, 44, 8.26, 7.29, 40.88, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CX', NULL, 1.22, 43, 0.08, 1.05, 1.38, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CXP', 1, 78.45, 43, 8.07, 58.16, 90.51, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CXP', 2, 21.55, 43, 8.07, 9.49, 41.84, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CXP', 3, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CX', NULL, 3.04, 43, 0.36, 2.31, 3.77, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CXP', 1, 34.66, 43, 11.08, 16.50, 58.73, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CXP', 2, 4.06, 43, 3.43, 0.71, 19.96, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CXP', 3, 8.82, 43, 4.29, 3.19, 22.11, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CXP', 4, 27.50, 43, 9.01, 13.22, 48.56, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CXP', 5, 24.96, 43, 8.15, 12.14, 44.46, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CX', NULL, 4.69, 43, 0.10, 4.48, 4.90, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CXP', 2, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CXP', 3, 3.90, 43, 3.88, 0.50, 24.70, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CXP', 4, 23.31, 43, 8.89, 10.02, 45.34, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CXP', 5, 72.79, 43, 8.85, 52.05, 86.83, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CX', NULL, 4.57, 44, 0.19, 4.19, 4.94, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CXP', 1, 3.86, 44, 3.84, 0.50, 24.45, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CXP', 2, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CXP', 3, 7.20, 44, 5.06, 1.66, 26.33, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CXP', 4, 13.62, 44, 5.57, 5.72, 29.06, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CXP', 5, 75.32, 44, 8.08, 55.95, 88.00, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CX', NULL, 4.80, 44, 0.10, 4.60, 5.00, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CXP', 2, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CXP', 3, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CXP', 4, 19.83, 44, 9.80, 6.66, 46.18, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CXP', 5, 80.17, 44, 9.80, 53.82, 93.34, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CX', NULL, 2.32, 44, 0.28, 1.75, 2.88, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CXP', 1, 37.44, 44, 10.12, 20.03, 58.85, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CXP', 2, 23.63, 44, 7.60, 11.68, 41.99, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CXP', 3, 13.06, 44, 5.87, 5.03, 29.88, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CXP', 4, 21.66, 44, 9.55, 8.16, 46.24, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CXP', 5, 4.20, 44, 4.14, 0.55, 25.82, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CX', NULL, 3.79, 44, 0.22, 3.35, 4.22, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CXP', 1, 3.09, 44, 3.11, 0.39, 20.55, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CXP', 2, 10.28, 44, 7.48, 2.18, 37.04, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CXP', 3, 15.57, 44, 9.85, 3.91, 45.52, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CXP', 4, 47.12, 44, 9.59, 29.09, 65.94, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CXP', 5, 23.94, 44, 7.94, 11.56, 43.12, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CX', NULL, 2.82, 44, 0.22, 2.37, 3.27, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CXP', 1, 12.44, 44, 5.52, 4.87, 28.29, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CXP', 2, 33.14, 44, 11.09, 15.31, 57.62, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CXP', 3, 21.44, 44, 7.88, 9.61, 41.21, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CXP', 4, 25.97, 44, 8.78, 12.25, 46.85, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CXP', 5, 7.00, 44, 4.44, 1.87, 22.93, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CX', NULL, 4.79, 44, 0.12, 4.55, 5.00, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CXP', 2, 3.33, 44, 3.34, 0.42, 21.84, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CXP', 3, 0.80, 44, 0.81, 0.10, 5.93, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CXP', 4, 9.65, 44, 5.74, 2.75, 28.74, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CXP', 5, 86.21, 44, 6.66, 66.89, 95.09, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CX', NULL, 3.71, 42, 0.24, 3.24, 4.19, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CXP', 1, 9.20, 42, 4.76, 3.11, 24.26, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CXP', 2, 6.19, 42, 4.41, 1.40, 23.45, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CXP', 3, 19.88, 42, 7.27, 8.98, 38.42, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CXP', 4, 33.63, 42, 10.89, 15.90, 57.58, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CXP', 5, 31.11, 42, 10.10, 14.85, 53.90, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CX', NULL, 4.08, 44, 0.29, 3.49, 4.66, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CXP', 1, 7.39, 44, 7.02, 1.00, 38.68, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CXP', 2, 4.99, 44, 3.36, 1.25, 17.96, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CXP', 3, 12.29, 44, 5.84, 4.49, 29.49, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CXP', 4, 23.18, 44, 8.33, 10.51, 43.66, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CXP', 5, 52.14, 44, 10.49, 31.82, 71.78, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CX', NULL, 1.42, 44, 0.18, 1.06, 1.78, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CXP', 1, 77.53, 44, 8.58, 56.10, 90.30, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CXP', 2, 15.33, 44, 7.73, 5.17, 37.56, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CXP', 3, 0.80, 44, 0.81, 0.10, 5.93, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CXP', 4, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CXP', 5, 6.33, 44, 4.11, 1.65, 21.48, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.4', 'CT', NULL, 1.37, 43, 0.15, 1.06, 1.67, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.4', 'CTP', 1, 70.55, 43, 9.84, 47.95, 86.17, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.4', 'CTP', 2, 21.98, 43, 8.06, 9.84, 42.11, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.4', 'CTP', 3, 7.47, 43, 7.09, 1.01, 39.00, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.8', 'CT', NULL, 2.67, 44, 0.11, 2.46, 2.89, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.8', 'CTP', 1, 3.09, 44, 3.11, 0.39, 20.55, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.8', 'CTP', 2, 26.49, 44, 8.95, 12.48, 47.67, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.8', 'CTP', 3, 70.42, 44, 9.35, 49.05, 85.48, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CX', NULL, 2.37, 19, 0.41, 1.50, 3.25, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CXP', 1, 26.46, 19, 20.25, 3.89, 76.20, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CXP', 2, 35.62, 19, 14.86, 12.41, 68.34, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CXP', 3, 14.94, 19, 8.94, 3.85, 43.51, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CXP', 4, 19.98, 19, 10.52, 5.90, 49.86, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CXP', 5, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CX', NULL, 5.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CXP', 5, 100.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CX', NULL, 5.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CXP', 5, 100.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CX', NULL, 3.50, 19, 0.25, 2.97, 4.04, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CXP', 2, 16.34, 19, 9.78, 4.17, 46.74, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CXP', 3, 31.48, 19, 14.47, 10.10, 65.28, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CXP', 4, 37.86, 19, 18.47, 10.48, 76.03, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CXP', 5, 14.31, 19, 8.94, 3.48, 43.60, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CX', NULL, 4.56, 19, 0.18, 4.18, 4.94, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CXP', 4, 43.66, 19, 18.08, 14.19, 78.40, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CXP', 5, 56.34, 19, 18.08, 21.60, 85.81, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CX', NULL, 4.65, 19, 0.19, 4.25, 5.00, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CXP', 4, 34.79, 19, 18.96, 8.44, 75.54, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CXP', 5, 65.21, 19, 18.96, 24.46, 91.56, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CX', NULL, 3.99, 19, 0.33, 3.30, 4.69, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CXP', 2, 2.90, 19, 2.98, 0.32, 21.68, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CXP', 3, 40.84, 19, 18.36, 12.27, 77.31, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CXP', 4, 10.15, 19, 8.76, 1.48, 45.96, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CXP', 5, 46.12, 19, 16.28, 17.77, 77.22, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CX', NULL, 3.89, 19, 0.35, 3.16, 4.62, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CXP', 2, 11.95, 19, 9.18, 2.12, 45.89, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CXP', 3, 31.28, 19, 19.54, 6.31, 75.45, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CXP', 4, 13.04, 19, 9.26, 2.63, 45.45, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CXP', 5, 43.73, 19, 15.93, 16.63, 75.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CX', NULL, 4.12, 19, 0.23, 3.65, 4.60, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CXP', 2, 10.15, 19, 8.76, 1.48, 45.96, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CXP', 3, 1.58, 19, 1.64, 0.17, 12.88, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CXP', 4, 53.92, 19, 16.30, 22.77, 82.29, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CXP', 5, 34.35, 19, 13.82, 12.62, 65.47, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CX', NULL, 1.83, 19, 0.28, 1.24, 2.42, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CXP', 1, 46.67, 19, 17.48, 16.68, 79.28, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CXP', 2, 25.21, 19, 12.53, 7.70, 57.67, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CXP', 3, 26.92, 19, 12.46, 8.88, 58.22, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CXP', 4, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CX', NULL, 3.71, 19, 0.28, 3.13, 4.29, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CXP', 1, 10.15, 19, 8.76, 1.48, 45.96, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CXP', 3, 10.15, 19, 8.74, 1.48, 45.85, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CXP', 4, 68.07, 19, 13.76, 36.06, 88.96, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CXP', 5, 11.63, 19, 6.40, 3.43, 32.76, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CX', NULL, 2.94, 19, 0.32, 2.28, 3.61, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CXP', 2, 44.35, 19, 17.96, 14.73, 78.62, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CXP', 3, 21.21, 19, 10.52, 6.69, 50.27, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CXP', 4, 30.20, 19, 13.33, 10.28, 62.03, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CXP', 5, 4.24, 19, 3.48, 0.73, 21.13, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CX', NULL, 2.73, 19, 0.26, 2.19, 3.27, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CXP', 2, 53.88, 19, 16.23, 22.85, 82.17, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CXP', 3, 20.80, 19, 12.00, 5.38, 54.81, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CXP', 4, 24.11, 19, 11.17, 8.10, 53.39, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CXP', 5, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CX', NULL, 1.29, 19, 0.13, 1.01, 1.56, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CXP', 1, 74.58, 19, 12.11, 43.40, 91.82, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CXP', 2, 22.23, 19, 11.71, 6.45, 54.25, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CXP', 3, 3.19, 19, 2.52, 0.59, 15.50, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CX', NULL, 4.84, 19, 0.11, 4.61, 5.00, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CXP', 1, 1.20, 19, 1.26, 0.13, 10.13, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CXP', 2, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CXP', 4, 1.98, 19, 2.08, 0.21, 16.01, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CXP', 5, 93.81, 19, 4.14, 77.19, 98.55, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CX', NULL, 1.83, 19, 0.39, 1.01, 2.65, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CXP', 1, 56.38, 19, 16.12, 24.60, 83.66, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CXP', 2, 23.33, 19, 11.74, 7.11, 54.71, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CXP', 3, 10.15, 19, 8.74, 1.48, 45.85, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CXP', 4, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CXP', 5, 8.94, 19, 8.65, 1.04, 47.79, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CX', NULL, 1.66, 19, 0.26, 1.12, 2.20, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CXP', 1, 57.59, 19, 15.75, 25.94, 84.04, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CXP', 2, 20.37, 19, 10.85, 5.90, 51.04, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CXP', 3, 20.84, 19, 11.43, 5.78, 53.02, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CXP', 4, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CX', NULL, 1.57, 19, 0.23, 1.09, 2.06, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CXP', 1, 61.82, 19, 14.88, 30.11, 85.89, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CXP', 2, 20.37, 19, 10.85, 5.90, 51.04, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CXP', 3, 16.60, 19, 9.81, 4.30, 46.87, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CXP', 4, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CX', NULL, 1.04, 19, 0.03, 1.00, 1.11, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CXP', 1, 95.79, 19, 3.42, 79.28, 99.27, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CXP', 2, 4.21, 19, 3.42, 0.73, 20.72, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CX', NULL, 1.95, 19, 0.38, 1.16, 2.73, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CXP', 1, 54.60, 19, 15.97, 23.71, 82.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CXP', 2, 14.98, 19, 9.77, 3.40, 46.90, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CXP', 3, 18.71, 19, 8.68, 6.48, 43.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CXP', 4, 4.58, 19, 3.59, 0.85, 21.25, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CXP', 5, 7.13, 19, 7.07, 0.81, 41.99, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CX', NULL, 2.60, 19, 0.26, 2.04, 3.15, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CXP', 2, 62.61, 19, 15.05, 30.27, 86.60, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CXP', 3, 22.05, 19, 12.45, 5.82, 56.44, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CXP', 4, 8.21, 19, 4.84, 2.27, 25.62, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CXP', 5, 7.13, 19, 7.07, 0.81, 41.99, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CX', NULL, 2.49, 19, 0.54, 1.34, 3.63, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CXP', 1, 46.69, 19, 17.42, 16.76, 79.21, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CXP', 2, 13.51, 19, 9.14, 2.93, 44.70, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CXP', 3, 7.24, 19, 4.87, 1.67, 26.38, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CXP', 4, 9.50, 19, 9.13, 1.11, 49.44, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CXP', 5, 23.06, 19, 11.90, 6.82, 55.08, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CX', NULL, 1.29, 19, 0.13, 1.02, 1.57, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CXP', 1, 74.58, 19, 11.84, 44.15, 91.59, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CXP', 2, 22.63, 19, 11.43, 6.91, 53.54, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CXP', 3, 1.58, 19, 1.64, 0.17, 12.88, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CXP', 4, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CX', NULL, 1.39, 19, 0.29, 1.00, 2.00, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CXP', 1, 83.48, 19, 9.05, 56.02, 95.25, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CXP', 2, 8.19, 19, 5.37, 1.95, 28.55, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CXP', 3, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CXP', 5, 7.13, 19, 7.07, 0.81, 41.99, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CX', NULL, 1.12, 19, 0.08, 1.00, 1.29, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CXP', 1, 91.79, 19, 4.84, 74.38, 97.73, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CXP', 2, 4.00, 19, 3.09, 0.76, 18.46, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CXP', 3, 4.21, 19, 3.42, 0.73, 20.72, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CX', NULL, 1.53, 19, 0.18, 1.16, 1.91, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CXP', 1, 56.38, 19, 17.91, 21.86, 85.65, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CXP', 2, 35.41, 19, 19.27, 8.54, 76.30, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CXP', 3, 6.63, 19, 4.37, 1.59, 23.83, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CXP', 4, 1.58, 19, 1.64, 0.17, 12.88, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CX', NULL, 1.03, 19, 0.03, 1.00, 1.09, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CXP', 1, 97.00, 19, 3.09, 77.69, 99.67, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CXP', 2, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CX', NULL, 1.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CXP', 1, 100.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CX', NULL, 1.17, 19, 0.12, 1.00, 1.42, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CXP', 1, 82.56, 19, 11.57, 46.66, 96.24, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CXP', 2, 17.44, 19, 11.57, 3.76, 53.34, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CX', NULL, 1.12, 19, 0.09, 1.00, 1.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CXP', 1, 88.05, 19, 9.18, 54.11, 97.88, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CXP', 2, 11.95, 19, 9.18, 2.12, 45.89, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CX', NULL, 1.03, 19, 0.03, 1.00, 1.09, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CXP', 1, 97.00, 19, 3.09, 77.69, 99.67, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CXP', 2, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CX', NULL, 1.11, 19, 0.09, 1.00, 1.29, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CXP', 1, 89.48, 19, 8.82, 54.29, 98.38, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CXP', 2, 10.52, 19, 8.82, 1.62, 45.71, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CX', NULL, 1.31, 19, 0.20, 1.00, 1.72, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CXP', 1, 69.33, 19, 19.57, 24.63, 93.99, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CXP', 2, 30.67, 19, 19.57, 6.01, 75.37, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CX', NULL, 4.24, 19, 0.17, 3.89, 4.59, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CXP', 3, 9.53, 19, 7.38, 1.71, 38.90, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CXP', 4, 56.87, 19, 16.09, 24.94, 83.95, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CXP', 5, 33.60, 19, 14.71, 11.24, 66.91, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CX', NULL, 1.99, 19, 0.12, 1.74, 2.24, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CXP', 1, 10.70, 19, 9.23, 1.55, 47.69, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CXP', 2, 79.77, 19, 11.62, 46.50, 94.70, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CXP', 3, 9.53, 19, 7.38, 1.71, 38.90, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CX', NULL, 1.06, 19, 0.04, 1.00, 1.14, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CXP', 1, 94.22, 19, 3.93, 78.20, 98.67, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CXP', 2, 5.78, 19, 3.93, 1.33, 21.80, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CX', NULL, 2.30, 19, 0.22, 1.84, 2.76, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CXP', 1, 9.62, 19, 5.90, 2.50, 30.69, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CXP', 2, 53.78, 19, 17.52, 20.92, 83.66, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CXP', 3, 33.59, 19, 19.46, 7.48, 75.97, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CXP', 4, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CX', NULL, 1.41, 19, 0.19, 1.02, 1.80, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CXP', 1, 62.32, 19, 18.51, 24.00, 89.65, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CXP', 2, 34.67, 19, 18.94, 8.39, 75.46, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CXP', 3, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CX', NULL, 1.32, 19, 0.29, 1.00, 1.91, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CXP', 1, 89.87, 19, 7.77, 59.60, 98.16, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CXP', 2, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CXP', 5, 7.13, 19, 7.07, 0.81, 41.99, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CX', NULL, 2.94, 19, 0.47, 1.95, 3.94, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CXP', 1, 32.60, 19, 14.00, 11.26, 64.84, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CXP', 2, 11.73, 19, 8.93, 2.12, 44.84, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CXP', 3, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CXP', 4, 34.17, 19, 19.09, 8.03, 75.53, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CXP', 5, 18.50, 19, 11.27, 4.50, 52.20, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CX', NULL, 1.37, 19, 0.19, 1.00, 1.77, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CXP', 1, 65.33, 19, 18.94, 24.54, 91.61, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CXP', 2, 33.47, 19, 19.13, 7.65, 75.35, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CXP', 4, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CX', NULL, 2.61, 19, 0.49, 1.57, 3.64, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CXP', 1, 41.32, 19, 15.97, 15.01, 73.75, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CXP', 2, 7.74, 19, 5.23, 1.77, 28.11, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CXP', 3, 1.20, 19, 1.24, 0.14, 9.87, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CXP', 4, 48.53, 19, 17.25, 18.10, 80.09, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CXP', 5, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CX', NULL, 1.14, 19, 0.10, 1.00, 1.34, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CXP', 1, 90.03, 19, 6.00, 68.93, 97.35, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CXP', 2, 5.78, 19, 3.93, 1.33, 21.80, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CXP', 3, 4.18, 19, 4.25, 0.47, 28.79, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CX', NULL, 1.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CXP', 1, 100.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CX', NULL, 2.06, 19, 0.24, 1.56, 2.55, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CXP', 1, 34.30, 19, 14.82, 11.60, 67.52, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CXP', 2, 35.40, 19, 18.82, 8.86, 75.54, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CXP', 3, 23.69, 19, 12.02, 7.13, 55.66, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CXP', 4, 3.61, 19, 3.72, 0.40, 26.10, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CXP', 5, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CX', NULL, 4.14, 19, 0.24, 3.63, 4.65, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CXP', 1, 1.20, 19, 1.26, 0.13, 10.13, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CXP', 2, 8.94, 19, 8.65, 1.04, 47.79, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CXP', 3, 2.90, 19, 2.98, 0.32, 21.68, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CXP', 4, 48.51, 19, 17.23, 18.12, 80.05, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CXP', 5, 38.44, 19, 15.04, 14.11, 70.36, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CX', NULL, 4.07, 19, 0.35, 3.34, 4.80, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CXP', 1, 1.20, 19, 1.26, 0.13, 10.13, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CXP', 3, 40.73, 19, 18.39, 12.18, 77.30, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CXP', 4, 6.96, 19, 4.88, 1.52, 26.69, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CXP', 5, 51.10, 19, 17.08, 19.92, 81.46, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CX', NULL, 4.15, 19, 0.30, 3.52, 4.77, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CXP', 1, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CXP', 2, 1.20, 19, 1.26, 0.13, 10.13, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CXP', 3, 22.06, 19, 11.28, 6.66, 52.91, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CXP', 4, 25.44, 19, 12.42, 7.94, 57.46, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CXP', 5, 48.29, 19, 17.25, 17.95, 79.95, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CX', NULL, 2.56, 18, 0.19, 2.17, 2.96, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CXP', 1, 8.67, 18, 5.83, 1.97, 30.97, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CXP', 2, 30.70, 18, 13.95, 10.00, 63.86, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CXP', 3, 56.11, 18, 16.33, 23.99, 83.81, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CXP', 4, 4.52, 18, 3.04, 1.06, 17.33, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CXP', 5, 0.00, 18, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CX', NULL, 3.98, 19, 0.41, 3.11, 4.85, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CXP', 1, 8.49, 19, 8.26, 0.99, 46.37, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CXP', 2, 4.10, 19, 3.32, 0.72, 20.12, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CXP', 3, 19.64, 19, 12.16, 4.62, 55.22, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CXP', 4, 16.35, 19, 8.83, 4.79, 43.16, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CXP', 5, 51.41, 19, 16.78, 20.50, 81.27, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CX', NULL, 3.12, 19, 0.38, 2.31, 3.92, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CXP', 1, 23.42, 19, 11.36, 7.48, 53.65, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CXP', 2, 6.56, 19, 4.32, 1.57, 23.58, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CXP', 3, 14.36, 19, 9.44, 3.23, 45.67, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CXP', 4, 46.11, 19, 17.61, 16.18, 79.13, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CXP', 5, 9.55, 19, 7.56, 1.65, 39.92, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CX', NULL, 4.41, 19, 0.20, 4.00, 4.83, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CXP', 2, 4.21, 19, 3.39, 0.74, 20.48, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CXP', 3, 8.93, 19, 5.68, 2.21, 29.86, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CXP', 4, 28.04, 19, 19.97, 4.65, 75.71, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CXP', 5, 58.82, 19, 18.12, 22.88, 87.30, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CX', NULL, 3.12, 19, 0.26, 2.58, 3.66, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CXP', 1, 10.15, 19, 8.76, 1.48, 45.96, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CXP', 2, 10.70, 19, 9.21, 1.56, 47.58, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CXP', 3, 45.02, 19, 17.71, 15.41, 78.64, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CXP', 4, 25.69, 19, 12.14, 8.33, 56.80, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CXP', 5, 8.45, 19, 5.11, 2.25, 27.00, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CX', NULL, 4.67, 19, 0.15, 4.36, 4.97, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CXP', 2, 1.20, 19, 1.26, 0.13, 10.13, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CXP', 3, 2.43, 19, 2.51, 0.27, 18.74, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CXP', 4, 24.97, 19, 12.84, 7.31, 58.40, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CXP', 5, 71.40, 19, 13.30, 38.85, 90.75, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CX', NULL, 1.93, 19, 0.41, 1.07, 2.78, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CXP', 1, 60.63, 19, 18.55, 23.12, 88.74, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CXP', 2, 1.58, 19, 1.64, 0.17, 12.88, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CXP', 3, 29.47, 19, 19.77, 5.36, 75.51, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CXP', 4, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CXP', 5, 7.13, 19, 7.07, 0.81, 41.99, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.4', 'CT', NULL, 1.04, 19, 0.03, 1.00, 1.09, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.4', 'CTP', 1, 96.02, 19, 2.59, 85.32, 99.01, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.4', 'CTP', 2, 3.98, 19, 2.59, 0.99, 14.68, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.4', 'CTP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.8', 'CT', NULL, 2.51, 18, 0.14, 2.20, 2.81, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.8', 'CTP', 1, 1.64, 18, 1.65, 0.19, 12.64, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.8', 'CTP', 2, 46.12, 18, 14.67, 19.76, 74.83, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.8', 'CTP', 3, 52.25, 18, 14.47, 24.35, 78.81, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CX', NULL, 2.56, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CXP', 1, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CXP', 2, 48.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CXP', 3, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CXP', 4, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CX', NULL, 5.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CXP', 5, 100.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CX', NULL, 5.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CXP', 5, 100.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CX', NULL, 4.48, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CXP', 3, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CXP', 4, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CXP', 5, 56.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CX', NULL, 4.84, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CXP', 4, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CXP', 5, 84.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CX', NULL, 4.64, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CXP', 4, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CXP', 5, 64.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CX', NULL, 4.44, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CXP', 3, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CXP', 4, 48.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CXP', 5, 48.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CX', NULL, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CXP', 2, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CXP', 3, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CXP', 4, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CXP', 5, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CX', NULL, 3.72, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CXP', 3, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CXP', 4, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CXP', 5, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CX', NULL, 1.92, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CXP', 1, 48.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CXP', 2, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CXP', 3, 24.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CXP', 4, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CX', NULL, 3.56, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CXP', 1, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CXP', 2, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CXP', 3, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CXP', 4, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CXP', 5, 28.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CX', NULL, 2.88, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CXP', 1, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CXP', 2, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CXP', 3, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CXP', 4, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CXP', 5, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CX', NULL, 2.56, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CXP', 1, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CXP', 2, 48.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CXP', 3, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CXP', 4, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CX', NULL, 1.12, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CXP', 1, 88.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CXP', 2, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CX', NULL, 4.12, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CXP', 1, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CXP', 3, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CXP', 4, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CXP', 5, 72.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CX', NULL, 1.24, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CXP', 1, 84.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CXP', 2, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CXP', 3, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CX', NULL, 1.76, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CXP', 1, 52.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CXP', 2, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CXP', 3, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CXP', 4, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CXP', 5, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CX', NULL, 1.40, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CXP', 1, 64.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CXP', 2, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CXP', 3, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CX', NULL, 1.08, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CXP', 1, 95.83, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CXP', 2, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CXP', 3, 4.17, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CXP', 4, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CX', NULL, 2.17, 23, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CXP', 1, 43.48, 23, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CXP', 2, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CXP', 3, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CXP', 4, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CXP', 5, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CX', NULL, 2.88, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CXP', 2, 44.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CXP', 3, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CXP', 4, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CXP', 5, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CX', NULL, 2.12, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CXP', 1, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CXP', 2, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CXP', 3, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CXP', 4, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CXP', 5, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CX', NULL, 1.28, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CXP', 1, 80.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CXP', 2, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CXP', 3, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CX', NULL, 1.20, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CXP', 1, 84.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CXP', 2, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CXP', 3, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CX', NULL, 1.16, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CXP', 1, 84.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CXP', 2, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CX', NULL, 1.21, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CXP', 1, 91.67, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CXP', 2, 4.17, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CXP', 3, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CXP', 4, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CXP', 5, 4.17, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CX', NULL, 1.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CXP', 1, 100.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CX', NULL, 1.00, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CXP', 1, 100.00, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CXP', 2, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CX', NULL, 1.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CXP', 1, 100.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CX', NULL, 1.17, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CXP', 1, 87.50, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CXP', 2, 8.33, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CXP', 3, 4.17, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CX', NULL, 1.04, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CXP', 1, 96.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CX', NULL, 1.12, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CXP', 1, 92.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CXP', 3, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CX', NULL, 1.04, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CXP', 1, 96.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CX', NULL, 4.24, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CXP', 3, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CXP', 4, 60.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CXP', 5, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CX', NULL, 2.12, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CXP', 1, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CXP', 2, 64.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CXP', 3, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CXP', 4, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CX', NULL, 1.04, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CXP', 1, 96.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CX', NULL, 1.60, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CXP', 1, 48.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CXP', 2, 44.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CXP', 3, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CX', NULL, 1.04, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CXP', 1, 96.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CX', NULL, 1.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CXP', 1, 100.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CX', NULL, 1.84, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CXP', 1, 60.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CXP', 2, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CXP', 4, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CXP', 5, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CX', NULL, 1.12, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CXP', 1, 88.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CXP', 2, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CX', NULL, 2.08, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CXP', 1, 50.00, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CXP', 2, 12.50, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CXP', 3, 20.83, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CXP', 4, 12.50, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CXP', 5, 4.17, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CX', NULL, 1.28, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CXP', 1, 80.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CXP', 2, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CXP', 4, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CX', NULL, 1.12, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CXP', 1, 96.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CXP', 4, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CX', NULL, 2.40, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CXP', 1, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CXP', 2, 24.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CXP', 3, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CXP', 4, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CXP', 5, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CX', NULL, 4.20, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CXP', 3, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CXP', 4, 52.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CXP', 5, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CX', NULL, 3.84, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CXP', 2, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CXP', 3, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CXP', 4, 28.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CXP', 5, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CX', NULL, 4.20, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CXP', 3, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CXP', 4, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CXP', 5, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CX', NULL, 2.08, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CXP', 1, 44.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CXP', 2, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CXP', 3, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CXP', 4, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CX', NULL, 3.76, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CXP', 2, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CXP', 3, 24.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CXP', 4, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CXP', 5, 24.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CX', NULL, 2.60, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CXP', 1, 28.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CXP', 2, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CXP', 3, 28.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CXP', 4, 24.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CXP', 5, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CX', NULL, 4.32, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CXP', 3, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CXP', 4, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CXP', 5, 48.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CX', NULL, 3.88, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CXP', 3, 28.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CXP', 4, 44.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CXP', 5, 24.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CX', NULL, 4.20, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CXP', 3, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CXP', 4, 44.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CXP', 5, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CX', NULL, 1.20, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CXP', 1, 92.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CXP', 3, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CXP', 4, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.4', 'CT', NULL, 1.28, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.4', 'CTP', 1, 72.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.4', 'CTP', 2, 28.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.4', 'CTP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.8', 'CT', NULL, 2.68, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.8', 'CTP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.8', 'CTP', 2, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.8', 'CTP', 3, 68.00, 25, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CX', NULL, 2.95, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CXP', 1, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CXP', 2, 33.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CXP', 3, 42.86, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CXP', 4, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CXP', 5, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CX', NULL, 5.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CXP', 4, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CXP', 5, 100.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CX', NULL, 5.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CXP', 5, 100.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CX', NULL, 4.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CXP', 1, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CXP', 2, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CXP', 3, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CXP', 4, 47.62, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CXP', 5, 28.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CX', NULL, 4.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CXP', 2, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CXP', 4, 28.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CXP', 5, 66.67, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CX', NULL, 4.67, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CXP', 1, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CXP', 2, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CXP', 3, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CXP', 4, 23.81, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CXP', 5, 71.43, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CX', NULL, 3.95, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CXP', 1, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CXP', 2, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CXP', 3, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CXP', 4, 42.86, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CXP', 5, 33.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CX', NULL, 4.14, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CXP', 1, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CXP', 2, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CXP', 3, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CXP', 4, 47.62, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CXP', 5, 38.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CX', NULL, 3.19, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CXP', 1, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CXP', 2, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CXP', 3, 28.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CXP', 4, 28.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CXP', 5, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CX', NULL, 2.30, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CXP', 1, 20.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CXP', 2, 45.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CXP', 3, 25.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CXP', 4, 5.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CXP', 5, 5.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CX', NULL, 3.38, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CXP', 1, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CXP', 2, 23.81, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CXP', 3, 23.81, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CXP', 4, 23.81, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CXP', 5, 23.81, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CX', NULL, 3.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CXP', 1, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CXP', 2, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CXP', 3, 42.86, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CXP', 4, 38.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CXP', 5, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CX', NULL, 3.14, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CXP', 1, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CXP', 2, 23.81, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CXP', 3, 38.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CXP', 4, 38.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CX', NULL, 1.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CXP', 1, 66.67, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CXP', 2, 33.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CXP', 4, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CX', NULL, 3.38, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CXP', 1, 23.81, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CXP', 2, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CXP', 3, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CXP', 4, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CXP', 5, 42.86, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CX', NULL, 2.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CXP', 1, 47.62, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CXP', 2, 28.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CXP', 3, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CXP', 4, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CXP', 5, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CX', NULL, 2.43, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CXP', 1, 47.62, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CXP', 2, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CXP', 3, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CXP', 4, 28.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CXP', 5, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CX', NULL, 1.60, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CXP', 1, 60.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CXP', 2, 30.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CXP', 3, 0.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CXP', 4, 10.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CXP', 5, 0.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CX', NULL, 1.24, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CXP', 1, 85.71, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CXP', 2, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CXP', 4, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CX', NULL, 3.62, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CXP', 1, 23.81, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CXP', 2, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CXP', 3, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CXP', 4, 33.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CXP', 5, 38.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CX', NULL, 3.35, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CXP', 1, 5.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CXP', 2, 20.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CXP', 3, 25.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CXP', 4, 35.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CXP', 5, 15.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CX', NULL, 2.19, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CXP', 1, 38.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CXP', 2, 33.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CXP', 3, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CXP', 4, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CXP', 5, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CX', NULL, 1.95, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CXP', 1, 47.62, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CXP', 2, 23.81, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CXP', 3, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CXP', 4, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CX', NULL, 1.90, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CXP', 1, 52.38, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CXP', 2, 28.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CXP', 3, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CXP', 4, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CXP', 5, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CX', NULL, 1.81, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CXP', 1, 61.90, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CXP', 2, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CXP', 3, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CXP', 4, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CXP', 5, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CX', NULL, 1.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CXP', 1, 76.19, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CXP', 2, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CXP', 4, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CX', NULL, 1.14, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CXP', 1, 85.71, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CXP', 2, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CX', NULL, 1.24, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CXP', 1, 85.71, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CXP', 2, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CXP', 4, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CX', NULL, 1.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CXP', 1, 85.71, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CXP', 2, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CXP', 4, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CXP', 5, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CX', NULL, 1.19, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CXP', 1, 85.71, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CXP', 2, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CXP', 3, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CX', NULL, 1.43, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CXP', 1, 71.43, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CXP', 2, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CXP', 3, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CXP', 4, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CX', NULL, 1.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CXP', 1, 80.95, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CXP', 2, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CXP', 3, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CXP', 4, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CX', NULL, 1.24, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CXP', 1, 85.71, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CXP', 2, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CXP', 4, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CX', NULL, 3.86, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CXP', 2, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CXP', 3, 33.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CXP', 4, 47.62, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CXP', 5, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CX', NULL, 2.48, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CXP', 1, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CXP', 2, 52.38, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CXP', 3, 33.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CXP', 4, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CX', NULL, 1.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CXP', 1, 95.24, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CXP', 2, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CX', NULL, 1.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CXP', 1, 38.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CXP', 2, 52.38, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CXP', 3, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CXP', 4, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CX', NULL, 1.14, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CXP', 1, 85.71, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CXP', 2, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CX', NULL, 1.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CXP', 1, 90.48, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CXP', 2, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CX', NULL, 1.95, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CXP', 1, 55.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CXP', 2, 20.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CXP', 3, 5.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CXP', 4, 15.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CXP', 5, 5.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CX', NULL, 1.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CXP', 1, 71.43, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CXP', 2, 28.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CXP', 4, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CX', NULL, 2.14, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CXP', 1, 42.86, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CXP', 2, 28.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CXP', 3, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CXP', 4, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CXP', 5, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CX', NULL, 1.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CXP', 1, 71.43, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CXP', 2, 28.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CXP', 4, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CX', NULL, 1.14, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CXP', 1, 90.48, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CXP', 2, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CXP', 3, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CX', NULL, 2.48, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CXP', 1, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CXP', 2, 38.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CXP', 3, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CXP', 4, 23.81, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CX', NULL, 3.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CXP', 2, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CXP', 3, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CXP', 4, 57.14, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CXP', 5, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CX', NULL, 3.62, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CXP', 1, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CXP', 2, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CXP', 3, 33.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CXP', 4, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CXP', 5, 33.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CX', NULL, 4.43, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CXP', 1, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CXP', 2, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CXP', 3, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CXP', 4, 38.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CXP', 5, 52.38, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CX', NULL, 2.62, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CXP', 1, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CXP', 2, 33.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CXP', 3, 42.86, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CXP', 4, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CXP', 5, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CX', NULL, 3.71, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CXP', 1, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CXP', 2, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CXP', 3, 23.81, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CXP', 4, 47.62, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CXP', 5, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CX', NULL, 2.67, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CXP', 1, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CXP', 2, 28.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CXP', 3, 28.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CXP', 4, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CXP', 5, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CX', NULL, 4.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CXP', 1, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CXP', 2, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
/*! COMMIT */;
/*! START TRANSACTION */;
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CXP', 4, 52.38, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CXP', 5, 42.86, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CX', NULL, 4.38, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CXP', 1, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CXP', 2, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CXP', 3, 14.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CXP', 4, 33.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CXP', 5, 52.38, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CX', NULL, 3.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CXP', 1, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CXP', 2, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CXP', 3, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CXP', 4, 66.67, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CXP', 5, 9.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CX', NULL, 1.38, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CXP', 1, 85.71, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CXP', 2, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CXP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CXP', 4, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CXP', 5, 4.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.4', 'CT', NULL, 1.19, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.4', 'CTP', 1, 80.95, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.4', 'CTP', 2, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.4', 'CTP', 3, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.8', 'CT', NULL, 2.81, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.8', 'CTP', 1, 0.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.8', 'CTP', 2, 19.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.8', 'CTP', 3, 80.95, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.c', 'CX', NULL, 3.10, 30, 0.25, 2.58, 3.61, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.c', 'CXP', 1, 6.84, 30, 4.74, 1.58, 25.16, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.c', 'CXP', 2, 15.14, 30, 8.42, 4.46, 40.54, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.c', 'CXP', 3, 42.95, 30, 13.35, 19.81, 69.65, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.c', 'CXP', 4, 31.75, 30, 16.57, 8.87, 68.97, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.c', 'CXP', 5, 3.31, 30, 2.19, 0.84, 12.18, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.f', 'CX', NULL, 4.90, 30, 0.09, 4.72, 5.00, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.f', 'CXP', 4, 9.71, 30, 9.16, 1.26, 47.67, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.f', 'CXP', 5, 90.29, 30, 9.16, 52.33, 98.74, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.h', 'CX', NULL, 5.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.h', 'CXP', 5, 100.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.j', 'CX', NULL, 4.36, 30, 0.13, 4.10, 4.62, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.j', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.j', 'CXP', 2, 0.89, 30, 0.93, 0.11, 7.12, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.j', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.j', 'CXP', 4, 61.27, 30, 12.94, 34.14, 82.84, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.j', 'CXP', 5, 37.84, 30, 12.82, 16.65, 64.98, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.l', 'CX', NULL, 5.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.l', 'CXP', 4, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.l', 'CXP', 5, 100.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.4', 'CX', NULL, 4.80, 30, 0.11, 4.58, 5.00, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.4', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.4', 'CXP', 2, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.4', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.4', 'CXP', 4, 19.78, 30, 10.87, 5.73, 50.02, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.4', 'CXP', 5, 80.22, 30, 10.87, 49.98, 94.27, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.e', 'CX', NULL, 4.67, 30, 0.13, 4.41, 4.93, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.e', 'CXP', 2, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.e', 'CXP', 3, 0.97, 30, 1.01, 0.12, 7.73, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.e', 'CXP', 4, 31.04, 30, 12.36, 12.14, 59.46, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.e', 'CXP', 5, 67.99, 30, 12.45, 39.72, 87.25, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.f', 'CX', NULL, 4.76, 30, 0.12, 4.51, 5.00, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.f', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.f', 'CXP', 2, 3.31, 30, 3.16, 0.45, 20.51, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.f', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.f', 'CXP', 4, 13.77, 30, 7.09, 4.50, 35.13, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.f', 'CXP', 5, 82.92, 30, 7.91, 60.76, 93.84, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.g', 'CX', NULL, 4.41, 30, 0.22, 3.96, 4.86, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.g', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.g', 'CXP', 2, 5.89, 30, 5.81, 0.73, 34.79, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.g', 'CXP', 3, 3.59, 30, 3.64, 0.43, 24.18, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.g', 'CXP', 4, 34.52, 30, 12.52, 14.52, 62.06, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.g', 'CXP', 5, 56.00, 30, 13.93, 28.59, 80.18, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.1', 'CX', NULL, 2.74, 30, 0.27, 2.19, 3.29, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.1', 'CXP', 1, 7.68, 30, 4.46, 2.24, 23.17, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.1', 'CXP', 2, 40.52, 30, 15.61, 15.34, 71.92, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.1', 'CXP', 3, 31.09, 30, 12.00, 12.54, 58.66, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.1', 'CXP', 4, 11.38, 30, 9.28, 1.92, 45.73, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.1', 'CXP', 5, 9.33, 30, 6.41, 2.13, 32.66, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.2', 'CX', NULL, 4.15, 30, 0.29, 3.55, 4.75, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.2', 'CXP', 1, 5.50, 30, 5.45, 0.68, 33.17, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.2', 'CXP', 2, 4.57, 30, 3.81, 0.80, 22.21, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.2', 'CXP', 3, 8.95, 30, 5.30, 2.53, 27.10, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.2', 'CXP', 4, 30.95, 30, 12.10, 12.34, 58.79, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.2', 'CXP', 5, 50.04, 30, 14.72, 23.10, 76.95, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.1', 'CX', NULL, 3.62, 30, 0.22, 3.17, 4.06, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.1', 'CXP', 1, 3.25, 30, 3.28, 0.39, 22.15, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.1', 'CXP', 2, 17.27, 30, 8.65, 5.71, 41.85, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.1', 'CXP', 3, 9.54, 30, 5.18, 3.00, 26.45, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.1', 'CXP', 4, 54.46, 30, 14.07, 27.27, 79.23, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.1', 'CXP', 5, 15.48, 30, 7.54, 5.33, 37.33, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.2', 'CX', NULL, 3.03, 30, 0.18, 2.66, 3.41, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.2', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.2', 'CXP', 2, 25.47, 30, 10.47, 9.96, 51.36, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.2', 'CXP', 3, 52.91, 30, 14.32, 25.75, 78.45, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.2', 'CXP', 4, 14.47, 30, 9.43, 3.44, 44.56, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.2', 'CXP', 5, 7.14, 30, 5.68, 1.32, 30.73, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.3', 'CX', NULL, 1.31, 30, 0.19, 1.00, 1.69, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.3', 'CXP', 1, 80.11, 30, 10.24, 51.97, 93.75, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.3', 'CXP', 2, 8.82, 30, 4.97, 2.66, 25.53, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.3', 'CXP', 3, 11.07, 30, 9.23, 1.80, 45.84, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.3', 'CXP', 4, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.3', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.a', 'CX', NULL, 4.37, 30, 0.31, 3.74, 5.00, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.a', 'CXP', 1, 13.93, 30, 7.65, 4.21, 37.38, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.a', 'CXP', 2, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.a', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.a', 'CXP', 4, 7.17, 30, 5.75, 1.30, 31.11, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.a', 'CXP', 5, 78.90, 30, 9.49, 53.83, 92.30, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.b', 'CX', NULL, 1.41, 30, 0.17, 1.07, 1.75, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.b', 'CXP', 1, 70.78, 30, 11.90, 42.75, 88.72, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.b', 'CXP', 2, 19.56, 30, 10.36, 5.95, 48.33, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.b', 'CXP', 3, 7.33, 30, 6.01, 1.28, 32.59, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.b', 'CXP', 4, 2.33, 30, 1.77, 0.48, 10.47, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.b', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.c', 'CX', NULL, 1.44, 30, 0.16, 1.11, 1.77, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.c', 'CXP', 1, 67.42, 30, 11.55, 41.38, 85.85, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.c', 'CXP', 2, 22.37, 30, 9.63, 8.49, 47.24, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.c', 'CXP', 3, 8.85, 30, 6.01, 2.07, 30.82, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.c', 'CXP', 4, 1.35, 30, 1.39, 0.16, 10.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.c', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.d', 'CX', NULL, 1.54, 30, 0.14, 1.25, 1.83, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.d', 'CXP', 1, 48.73, 30, 14.13, 23.01, 75.14, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.d', 'CXP', 2, 49.92, 30, 14.30, 23.63, 76.25, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.d', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.d', 'CXP', 4, 1.35, 30, 1.39, 0.16, 10.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.d', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.e', 'CX', NULL, 1.03, 30, 0.03, 1.00, 1.09, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.e', 'CXP', 1, 96.56, 30, 2.61, 84.88, 99.29, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.e', 'CXP', 2, 3.44, 30, 2.61, 0.71, 15.12, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.e', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.e', 'CXP', 4, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.f', 'CX', NULL, 2.35, 30, 0.25, 1.84, 2.87, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.f', 'CXP', 1, 38.72, 30, 12.33, 17.92, 64.65, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.f', 'CXP', 2, 2.09, 30, 2.14, 0.25, 15.39, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.f', 'CXP', 3, 48.22, 30, 14.58, 22.00, 75.45, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.f', 'CXP', 4, 6.99, 30, 5.68, 1.24, 30.99, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.f', 'CXP', 5, 3.99, 30, 2.55, 1.05, 13.97, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.3', 'CX', NULL, 2.26, 30, 0.11, 2.04, 2.48, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.3', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.3', 'CXP', 2, 78.17, 30, 9.33, 53.94, 91.63, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.3', 'CXP', 3, 17.75, 30, 8.69, 6.00, 42.17, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.3', 'CXP', 4, 4.08, 30, 2.61, 1.08, 14.24, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.3', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.a', 'CX', NULL, 2.49, 30, 0.22, 2.05, 2.94, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.a', 'CXP', 1, 10.41, 30, 5.74, 3.19, 29.05, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.a', 'CXP', 2, 51.60, 30, 14.05, 25.23, 77.11, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.a', 'CXP', 3, 19.76, 30, 10.77, 5.78, 49.70, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.a', 'CXP', 4, 14.63, 30, 7.52, 4.76, 37.01, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.a', 'CXP', 5, 3.59, 30, 3.64, 0.43, 24.18, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.b', 'CX', NULL, 1.50, 30, 0.17, 1.16, 1.85, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.b', 'CXP', 1, 60.81, 30, 13.25, 33.23, 82.87, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.b', 'CXP', 2, 29.76, 30, 12.15, 11.43, 58.18, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.b', 'CXP', 3, 7.88, 30, 5.80, 1.64, 30.46, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.b', 'CXP', 4, 1.35, 30, 1.39, 0.16, 10.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.b', 'CXP', 5, 0.20, 30, 0.21, 0.02, 1.69, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.c', 'CX', NULL, 1.48, 30, 0.19, 1.10, 1.86, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.c', 'CXP', 1, 66.16, 30, 12.73, 37.93, 86.21, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.c', 'CXP', 2, 21.10, 30, 10.68, 6.72, 49.84, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.c', 'CXP', 3, 11.39, 30, 7.74, 2.61, 38.14, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.c', 'CXP', 4, 1.35, 30, 1.39, 0.16, 10.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.c', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.d', 'CX', NULL, 1.39, 30, 0.16, 1.06, 1.73, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.d', 'CXP', 1, 72.48, 30, 10.62, 46.99, 88.67, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.d', 'CXP', 2, 17.07, 30, 8.08, 6.03, 39.80, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.d', 'CXP', 3, 9.09, 30, 6.56, 1.94, 33.62, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.d', 'CXP', 4, 1.35, 30, 1.39, 0.16, 10.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.d', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.e', 'CX', NULL, 1.14, 30, 0.08, 1.00, 1.31, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.e', 'CXP', 1, 88.26, 30, 6.78, 66.36, 96.63, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.e', 'CXP', 2, 10.39, 30, 6.56, 2.67, 32.90, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.e', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.e', 'CXP', 4, 1.35, 30, 1.39, 0.16, 10.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.f', 'CX', NULL, 1.03, 30, 0.02, 1.00, 1.07, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.f', 'CXP', 1, 97.21, 30, 2.08, 87.88, 99.41, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.f', 'CXP', 2, 2.79, 30, 2.08, 0.59, 12.12, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.a', 'CX', NULL, 1.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.a', 'CXP', 1, 100.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.a', 'CXP', 2, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.b', 'CX', NULL, 1.35, 30, 0.17, 1.01, 1.69, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.b', 'CXP', 1, 68.12, 30, 16.66, 30.80, 91.12, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.b', 'CXP', 2, 30.52, 30, 16.84, 7.97, 69.03, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.b', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.b', 'CXP', 4, 1.35, 30, 1.39, 0.16, 10.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.b', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.c', 'CX', NULL, 1.08, 30, 0.05, 1.00, 1.18, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.c', 'CXP', 1, 95.08, 30, 3.12, 83.19, 98.69, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.c', 'CXP', 2, 3.57, 30, 2.69, 0.74, 15.48, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.c', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.c', 'CXP', 4, 1.35, 30, 1.39, 0.16, 10.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.d', 'CX', NULL, 1.10, 30, 0.06, 1.00, 1.22, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.d', 'CXP', 1, 93.03, 30, 4.52, 76.26, 98.23, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.d', 'CXP', 2, 5.62, 30, 4.22, 1.16, 23.25, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.d', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.d', 'CXP', 4, 1.35, 30, 1.39, 0.16, 10.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.e', 'CX', NULL, 1.12, 30, 0.07, 1.00, 1.27, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.e', 'CXP', 1, 91.06, 30, 6.10, 68.77, 97.92, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.e', 'CXP', 2, 7.59, 30, 5.89, 1.45, 31.37, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.e', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.e', 'CXP', 4, 1.35, 30, 1.39, 0.16, 10.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.e', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.f', 'CX', NULL, 1.17, 30, 0.09, 1.00, 1.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.f', 'CXP', 1, 84.11, 30, 8.34, 59.62, 94.99, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.f', 'CXP', 2, 14.54, 30, 8.17, 4.25, 39.48, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.f', 'CXP', 3, 1.35, 30, 1.39, 0.16, 10.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.a', 'CX', NULL, 4.45, 30, 0.18, 4.08, 4.81, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.a', 'CXP', 2, 1.35, 30, 1.39, 0.16, 10.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.a', 'CXP', 3, 8.14, 30, 5.87, 1.74, 30.65, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.a', 'CXP', 4, 34.79, 30, 12.13, 15.17, 61.42, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.a', 'CXP', 5, 55.72, 30, 13.70, 28.78, 79.67, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.b', 'CX', NULL, 2.03, 30, 0.05, 1.93, 2.13, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.b', 'CXP', 1, 4.06, 30, 3.22, 0.78, 18.68, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.b', 'CXP', 2, 90.54, 30, 4.67, 75.85, 96.69, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.b', 'CXP', 3, 4.04, 30, 2.60, 1.06, 14.23, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.b', 'CXP', 4, 1.35, 30, 1.39, 0.16, 10.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.c', 'CX', NULL, 1.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.c', 'CXP', 1, 100.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.c', 'CXP', 2, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.d', 'CX', NULL, 1.88, 30, 0.09, 1.69, 2.07, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.d', 'CXP', 1, 12.34, 30, 9.23, 2.40, 44.66, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.d', 'CXP', 2, 87.66, 30, 9.23, 55.34, 97.60, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.d', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.d', 'CXP', 4, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.e', 'CX', NULL, 1.22, 30, 0.10, 1.02, 1.43, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.e', 'CXP', 1, 77.75, 30, 10.07, 51.51, 91.99, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.e', 'CXP', 2, 22.25, 30, 10.07, 8.01, 48.49, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.f', 'CX', NULL, 1.02, 30, 0.02, 1.00, 1.06, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.f', 'CXP', 1, 97.91, 30, 2.14, 84.61, 99.75, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.f', 'CXP', 2, 2.09, 30, 2.14, 0.25, 15.39, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.g', 'CX', NULL, 2.08, 30, 0.28, 1.51, 2.65, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.g', 'CXP', 1, 51.40, 30, 14.38, 24.58, 77.43, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.g', 'CXP', 2, 25.97, 30, 17.29, 5.28, 68.82, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.g', 'CXP', 3, 1.49, 30, 1.53, 0.18, 11.27, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.g', 'CXP', 4, 5.50, 30, 5.45, 0.68, 33.17, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.g', 'CXP', 5, 15.65, 30, 7.22, 5.71, 36.22, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.h', 'CX', NULL, 1.25, 30, 0.10, 1.04, 1.46, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.h', 'CXP', 1, 74.94, 30, 10.25, 49.49, 90.12, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.h', 'CXP', 2, 25.06, 30, 10.25, 9.88, 50.51, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.h', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.h', 'CXP', 4, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.i', 'CX', NULL, 2.61, 29, 0.31, 1.98, 3.24, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.i', 'CXP', 1, 27.89, 29, 11.24, 10.96, 54.86, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.i', 'CXP', 2, 20.12, 29, 9.00, 7.41, 44.23, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.i', 'CXP', 3, 30.24, 29, 18.03, 7.00, 71.39, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.i', 'CXP', 4, 6.82, 29, 4.97, 1.45, 26.64, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.i', 'CXP', 5, 14.94, 29, 8.31, 4.39, 40.15, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.d', 'CX', NULL, 1.23, 30, 0.11, 1.00, 1.46, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.d', 'CXP', 1, 79.86, 30, 10.70, 50.41, 93.93, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.d', 'CXP', 2, 18.79, 30, 10.61, 5.28, 48.96, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.d', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.d', 'CXP', 4, 1.35, 30, 1.39, 0.16, 10.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.d', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.e', 'CX', NULL, 1.03, 30, 0.02, 1.00, 1.07, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.e', 'CXP', 1, 97.16, 30, 2.12, 87.69, 99.40, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.e', 'CXP', 2, 2.84, 30, 2.12, 0.60, 12.31, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.e', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.1', 'CX', NULL, 2.65, 30, 0.24, 2.15, 3.15, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.1', 'CXP', 1, 18.16, 30, 8.14, 6.76, 40.47, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.1', 'CXP', 2, 28.88, 30, 11.81, 11.13, 56.82, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.1', 'CXP', 3, 31.62, 30, 16.61, 8.77, 69.00, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.1', 'CXP', 4, 12.39, 30, 6.82, 3.77, 33.81, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.1', 'CXP', 5, 8.94, 30, 6.59, 1.84, 33.98, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.a', 'CX', NULL, 4.66, 30, 0.14, 4.37, 4.94, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.a', 'CXP', 2, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.a', 'CXP', 3, 5.69, 30, 5.17, 0.84, 30.16, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.a', 'CXP', 4, 22.92, 30, 8.84, 9.65, 45.27, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.a', 'CXP', 5, 71.39, 30, 10.39, 46.84, 87.60, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.b', 'CX', NULL, 4.61, 30, 0.18, 4.24, 4.98, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.b', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.b', 'CXP', 2, 5.18, 30, 5.13, 0.64, 31.60, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.b', 'CXP', 3, 4.25, 30, 2.63, 1.17, 14.28, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.b', 'CXP', 4, 15.31, 30, 6.81, 5.81, 34.62, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.b', 'CXP', 5, 75.27, 30, 9.21, 52.52, 89.33, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.4', 'CX', NULL, 4.49, 30, 0.15, 4.19, 4.79, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.4', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.4', 'CXP', 2, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.4', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.4', 'CXP', 4, 51.08, 30, 14.60, 24.02, 77.52, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.4', 'CXP', 5, 48.92, 30, 14.60, 22.48, 75.98, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.2', 'CX', NULL, 2.07, 30, 0.36, 1.32, 2.81, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.2', 'CXP', 1, 55.80, 30, 13.50, 29.18, 79.45, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.2', 'CXP', 2, 8.10, 30, 5.07, 2.15, 26.18, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.2', 'CXP', 3, 11.95, 30, 7.06, 3.33, 34.87, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.2', 'CXP', 4, 22.06, 30, 11.07, 7.05, 51.36, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.2', 'CXP', 5, 2.09, 30, 2.14, 0.25, 15.39, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.4', 'CX', NULL, 4.69, 30, 0.13, 4.43, 4.94, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.4', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.4', 'CXP', 2, 0.89, 30, 0.93, 0.11, 7.12, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.4', 'CXP', 3, 4.05, 30, 3.62, 0.62, 22.14, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.4', 'CXP', 4, 20.40, 30, 9.26, 7.39, 45.15, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.4', 'CXP', 5, 74.66, 30, 10.20, 49.44, 89.87, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.7', 'CX', NULL, 3.43, 30, 0.42, 2.57, 4.28, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.7', 'CXP', 1, 15.67, 30, 7.50, 5.50, 37.25, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.7', 'CXP', 2, 6.50, 30, 4.13, 1.70, 21.84, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.7', 'CXP', 3, 32.73, 30, 12.66, 13.06, 61.19, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.7', 'CXP', 4, 9.80, 30, 5.27, 3.11, 26.88, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.7', 'CXP', 5, 35.30, 30, 15.97, 11.54, 69.52, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.8', 'CX', NULL, 4.58, 30, 0.16, 4.26, 4.90, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.8', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.8', 'CXP', 2, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.8', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.8', 'CXP', 4, 41.73, 30, 15.67, 16.09, 72.79, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.8', 'CXP', 5, 58.27, 30, 15.67, 27.21, 83.91, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.c.1', 'CX', NULL, 3.72, 30, 0.16, 3.38, 4.05, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.c.1', 'CXP', 1, 0.89, 30, 0.93, 0.11, 7.12, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.c.1', 'CXP', 2, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.c.1', 'CXP', 3, 41.40, 30, 13.61, 18.32, 68.99, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.c.1', 'CXP', 4, 41.94, 30, 15.21, 16.76, 72.16, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.c.1', 'CXP', 5, 15.77, 30, 7.58, 5.51, 37.57, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.1', 'CX', NULL, 4.21, 30, 0.15, 3.91, 4.52, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.1', 'CXP', 1, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.1', 'CXP', 2, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.1', 'CXP', 3, 14.18, 30, 8.27, 3.95, 39.90, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.1', 'CXP', 4, 50.32, 30, 14.60, 23.48, 76.98, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.1', 'CXP', 5, 35.50, 30, 12.27, 15.54, 62.21, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.3', 'CX', NULL, 1.12, 30, 0.08, 1.00, 1.29, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.3', 'CXP', 1, 92.41, 30, 5.89, 68.63, 98.55, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.3', 'CXP', 2, 5.50, 30, 5.45, 0.68, 33.17, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.3', 'CXP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.3', 'CXP', 4, 2.09, 30, 2.14, 0.25, 15.39, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.3', 'CXP', 5, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.4', 'CT', NULL, 1.14, 30, 0.07, 1.00, 1.28, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.4', 'CTP', 1, 86.45, 30, 7.23, 64.34, 95.76, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.4', 'CTP', 2, 13.55, 30, 7.23, 4.24, 35.66, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.4', 'CTP', 3, 0.00, 30, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.8', 'CT', NULL, 2.82, 30, 0.09, 2.64, 3.00, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.8', 'CTP', 1, 0.50, 30, 0.52, 0.06, 4.07, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.8', 'CTP', 2, 17.13, 30, 8.75, 5.54, 42.17, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.8', 'CTP', 3, 82.37, 30, 8.80, 57.49, 94.16, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.c', 'CX', NULL, 1.97, 44, 0.16, 1.65, 2.30, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.c', 'CXP', 1, 30.66, 44, 9.11, 15.70, 51.21, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.c', 'CXP', 2, 51.61, 44, 8.94, 34.13, 68.70, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.c', 'CXP', 3, 10.36, 44, 5.19, 3.62, 26.28, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.c', 'CXP', 4, 4.56, 44, 3.23, 1.06, 17.62, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.c', 'CXP', 5, 2.81, 44, 2.14, 0.59, 12.30, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.f', 'CX', NULL, 4.98, 44, 0.02, 4.94, 5.00, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.f', 'CXP', 3, 0.28, 44, 0.28, 0.04, 2.12, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.f', 'CXP', 4, 1.61, 44, 1.57, 0.22, 10.83, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.f', 'CXP', 5, 98.12, 44, 1.60, 90.12, 99.66, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.h', 'CX', NULL, 4.85, 44, 0.09, 4.66, 5.00, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.h', 'CXP', 1, 2.31, 44, 1.99, 0.40, 12.32, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.h', 'CXP', 4, 6.14, 44, 4.63, 1.28, 24.84, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.h', 'CXP', 5, 91.55, 44, 4.99, 74.68, 97.55, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.j', 'CX', NULL, 4.32, 44, 0.11, 4.10, 4.54, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.j', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.j', 'CXP', 2, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.j', 'CXP', 3, 10.60, 44, 5.04, 3.90, 25.74, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.j', 'CXP', 4, 47.24, 44, 9.23, 29.79, 65.39, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.j', 'CXP', 5, 42.16, 44, 8.77, 26.08, 60.09, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.l', 'CX', NULL, 4.94, 44, 0.05, 4.83, 5.00, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.l', 'CXP', 3, 2.17, 44, 2.22, 0.27, 15.49, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.l', 'CXP', 4, 2.17, 44, 2.17, 0.28, 14.84, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.l', 'CXP', 5, 95.67, 44, 3.14, 82.71, 99.03, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.4', 'CX', NULL, 4.60, 44, 0.12, 4.36, 4.84, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.4', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.4', 'CXP', 2, 2.17, 44, 2.17, 0.28, 14.84, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.4', 'CXP', 3, 2.58, 44, 2.57, 0.33, 17.23, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.4', 'CXP', 4, 28.24, 44, 9.79, 12.93, 51.05, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.4', 'CXP', 5, 67.02, 44, 9.92, 45.11, 83.40, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.e', 'CX', NULL, 4.32, 44, 0.19, 3.93, 4.71, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.e', 'CXP', 1, 2.17, 44, 2.17, 0.28, 14.84, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.e', 'CXP', 2, 5.00, 44, 4.62, 0.73, 27.26, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.e', 'CXP', 3, 7.53, 44, 4.38, 2.24, 22.47, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.e', 'CXP', 4, 29.28, 44, 9.65, 13.92, 51.44, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.e', 'CXP', 5, 56.03, 44, 11.28, 33.60, 76.24, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.f', 'CX', NULL, 3.94, 44, 0.20, 3.53, 4.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.f', 'CXP', 1, 4.38, 44, 3.17, 0.98, 17.44, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.f', 'CXP', 2, 8.34, 44, 5.43, 2.12, 27.62, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.f', 'CXP', 3, 10.97, 44, 5.49, 3.82, 27.67, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.f', 'CXP', 4, 41.98, 44, 10.26, 23.63, 62.85, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.f', 'CXP', 5, 34.33, 44, 9.01, 18.93, 53.92, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.g', 'CX', NULL, 3.88, 44, 0.26, 3.37, 4.40, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.g', 'CXP', 1, 7.16, 44, 4.95, 1.69, 25.73, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.g', 'CXP', 2, 0.07, 44, 0.08, 0.01, 0.58, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.g', 'CXP', 3, 26.55, 44, 8.64, 12.89, 46.90, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.g', 'CXP', 4, 29.56, 44, 9.41, 14.43, 51.08, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.g', 'CXP', 5, 36.65, 44, 9.92, 19.64, 57.79, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.1', 'CX', NULL, 3.45, 44, 0.35, 2.75, 4.15, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.1', 'CXP', 1, 19.71, 44, 9.28, 7.00, 44.49, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.1', 'CXP', 2, 6.75, 44, 4.49, 1.68, 23.40, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.1', 'CXP', 3, 18.22, 44, 6.69, 8.26, 35.52, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.1', 'CXP', 4, 19.86, 44, 7.56, 8.68, 39.23, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.1', 'CXP', 5, 35.46, 44, 10.44, 17.96, 57.96, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.2', 'CX', NULL, 3.69, 44, 0.26, 3.16, 4.22, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.2', 'CXP', 1, 7.35, 44, 4.95, 1.80, 25.56, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.2', 'CXP', 2, 12.63, 44, 5.56, 4.97, 28.53, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.2', 'CXP', 3, 8.35, 44, 4.01, 3.07, 20.77, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.2', 'CXP', 4, 47.06, 44, 10.34, 27.79, 67.25, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.2', 'CXP', 5, 24.62, 44, 8.22, 11.79, 44.37, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.1', 'CX', NULL, 3.54, 44, 0.19, 3.16, 3.93, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.1', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.1', 'CXP', 2, 11.54, 44, 6.58, 3.43, 32.39, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.1', 'CXP', 3, 43.26, 44, 9.68, 25.61, 62.80, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.1', 'CXP', 4, 24.71, 44, 8.65, 11.39, 45.59, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.1', 'CXP', 5, 20.49, 44, 8.04, 8.70, 41.08, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.2', 'CX', NULL, 3.48, 44, 0.20, 3.08, 3.88, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.2', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.2', 'CXP', 2, 18.00, 44, 7.34, 7.45, 37.44, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.2', 'CXP', 3, 34.34, 44, 10.16, 17.41, 56.48, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.2', 'CXP', 4, 29.36, 44, 8.09, 15.92, 47.71, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.2', 'CXP', 5, 18.29, 44, 8.22, 6.87, 40.44, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.3', 'CX', NULL, 1.39, 44, 0.11, 1.17, 1.61, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.3', 'CXP', 1, 65.53, 44, 9.41, 45.07, 81.49, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.3', 'CXP', 2, 29.64, 44, 9.04, 14.94, 50.25, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.3', 'CXP', 3, 4.83, 44, 3.47, 1.10, 18.88, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.3', 'CXP', 4, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.3', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.a', 'CX', NULL, 4.43, 44, 0.29, 3.83, 5.00, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.a', 'CXP', 1, 13.72, 44, 7.36, 4.34, 35.79, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.a', 'CXP', 2, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.a', 'CXP', 3, 0.64, 44, 0.66, 0.08, 4.85, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.a', 'CXP', 4, 0.90, 44, 0.91, 0.11, 6.63, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.a', 'CXP', 5, 84.74, 44, 7.44, 63.52, 94.66, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.b', 'CX', NULL, 2.21, 43, 0.25, 1.71, 2.72, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.b', 'CXP', 1, 45.71, 43, 9.19, 28.50, 63.99, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.b', 'CXP', 2, 23.81, 43, 8.34, 10.99, 44.16, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.b', 'CXP', 3, 8.97, 43, 4.22, 3.36, 21.85, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.b', 'CXP', 4, 6.53, 43, 4.66, 1.47, 24.62, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.b', 'CXP', 5, 14.98, 43, 6.47, 5.95, 32.94, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.c', 'CX', NULL, 1.82, 43, 0.21, 1.40, 2.23, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.c', 'CXP', 1, 58.01, 43, 10.46, 36.75, 76.67, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.c', 'CXP', 2, 17.98, 43, 10.16, 5.18, 46.80, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.c', 'CXP', 3, 14.11, 43, 6.70, 5.11, 33.38, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.c', 'CXP', 4, 3.87, 43, 3.48, 0.61, 21.01, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.c', 'CXP', 5, 6.02, 43, 4.01, 1.51, 21.12, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.d', 'CX', NULL, 1.50, 43, 0.18, 1.14, 1.86, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.d', 'CXP', 1, 71.03, 43, 10.03, 47.83, 86.77, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.d', 'CXP', 2, 16.86, 43, 9.25, 5.08, 43.45, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.d', 'CXP', 3, 6.00, 43, 5.72, 0.82, 33.07, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.d', 'CXP', 4, 3.09, 43, 2.90, 0.45, 18.42, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.d', 'CXP', 5, 3.01, 43, 3.00, 0.39, 19.80, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.e', 'CX', NULL, 1.30, 43, 0.13, 1.03, 1.57, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.e', 'CXP', 1, 85.24, 43, 5.66, 69.95, 93.47, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.e', 'CXP', 2, 5.96, 43, 3.19, 1.97, 16.66, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.e', 'CXP', 3, 2.70, 43, 2.69, 0.35, 17.98, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.e', 'CXP', 4, 6.10, 43, 4.01, 1.56, 21.07, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.f', 'CX', NULL, 1.84, 43, 0.24, 1.35, 2.33, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.f', 'CXP', 1, 64.35, 43, 9.39, 44.15, 80.47, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.f', 'CXP', 2, 7.05, 43, 4.06, 2.13, 20.95, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.f', 'CXP', 3, 11.95, 43, 5.69, 4.36, 28.80, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.f', 'CXP', 4, 13.34, 43, 6.96, 4.37, 34.18, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.f', 'CXP', 5, 3.30, 43, 2.91, 0.54, 17.73, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.3', 'CX', NULL, 2.94, 43, 0.23, 2.48, 3.40, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.3', 'CXP', 1, 2.27, 43, 2.27, 0.29, 15.50, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.3', 'CXP', 2, 46.19, 43, 10.74, 26.41, 67.25, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.3', 'CXP', 3, 19.57, 43, 9.64, 6.60, 45.59, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.3', 'CXP', 4, 19.15, 43, 10.26, 5.85, 47.44, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.3', 'CXP', 5, 12.82, 43, 6.21, 4.58, 31.08, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.a', 'CX', NULL, 2.41, 43, 0.29, 1.83, 2.98, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.a', 'CXP', 1, 40.24, 43, 9.94, 22.62, 60.80, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.a', 'CXP', 2, 18.00, 43, 6.28, 8.51, 34.14, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.a', 'CXP', 3, 15.32, 43, 6.69, 6.01, 33.87, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.a', 'CXP', 4, 13.63, 43, 6.80, 4.69, 33.60, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.a', 'CXP', 5, 12.81, 43, 6.14, 4.62, 30.83, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.b', 'CX', NULL, 1.47, 43, 0.13, 1.21, 1.74, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.b', 'CXP', 1, 69.87, 43, 7.44, 53.20, 82.55, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.b', 'CXP', 2, 16.15, 43, 6.47, 6.84, 33.57, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.b', 'CXP', 3, 10.68, 43, 4.72, 4.22, 24.48, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.b', 'CXP', 4, 3.30, 43, 3.02, 0.50, 18.71, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.b', 'CXP', 5, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.c', 'CX', NULL, 1.44, 43, 0.20, 1.04, 1.83, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.c', 'CXP', 1, 76.96, 43, 8.05, 57.21, 89.30, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.c', 'CXP', 2, 14.23, 43, 7.10, 4.88, 34.94, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.c', 'CXP', 3, 1.76, 43, 1.65, 0.26, 10.92, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.c', 'CXP', 4, 2.30, 43, 2.04, 0.37, 12.85, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.c', 'CXP', 5, 4.75, 43, 4.63, 0.63, 28.26, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.d', 'CX', NULL, 2.33, 44, 0.31, 1.71, 2.95, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.d', 'CXP', 1, 49.51, 44, 10.18, 30.13, 69.04, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.d', 'CXP', 2, 12.07, 44, 5.21, 4.86, 26.96, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.d', 'CXP', 3, 8.34, 44, 5.43, 2.12, 27.62, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.d', 'CXP', 4, 16.01, 44, 6.79, 6.44, 34.53, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.d', 'CXP', 5, 14.07, 44, 6.12, 5.57, 31.26, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.e', 'CX', NULL, 1.48, 43, 0.17, 1.14, 1.83, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.e', 'CXP', 1, 72.30, 43, 9.76, 49.41, 87.46, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.e', 'CXP', 2, 17.33, 43, 9.39, 5.29, 44.03, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.e', 'CXP', 3, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.e', 'CXP', 4, 10.37, 43, 5.42, 3.44, 27.28, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.f', 'CX', NULL, 1.09, 44, 0.06, 1.00, 1.21, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.f', 'CXP', 1, 93.60, 44, 3.60, 81.34, 98.00, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.f', 'CXP', 2, 3.52, 44, 2.46, 0.84, 13.59, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.f', 'CXP', 3, 2.88, 44, 2.78, 0.40, 18.03, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.a', 'CX', NULL, 1.24, 43, 0.19, 1.00, 1.62, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.a', 'CXP', 1, 89.60, 43, 7.01, 65.37, 97.52, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.a', 'CXP', 2, 5.77, 43, 5.61, 0.76, 32.91, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.a', 'CXP', 5, 4.63, 43, 4.52, 0.61, 27.73, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.b', 'CX', NULL, 1.86, 44, 0.29, 1.27, 2.44, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.b', 'CXP', 1, 65.57, 44, 10.38, 42.98, 82.79, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.b', 'CXP', 2, 13.52, 44, 8.73, 3.35, 41.33, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.b', 'CXP', 3, 2.58, 44, 2.57, 0.33, 17.23, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.b', 'CXP', 4, 6.31, 44, 5.54, 1.01, 30.80, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.b', 'CXP', 5, 12.02, 44, 6.67, 3.69, 32.78, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.c', 'CX', NULL, 1.12, 44, 0.08, 1.00, 1.29, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.c', 'CXP', 1, 94.24, 44, 3.21, 83.22, 98.18, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.c', 'CXP', 2, 2.60, 44, 1.73, 0.67, 9.57, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.c', 'CXP', 3, 0.28, 44, 0.28, 0.04, 2.12, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.c', 'CXP', 4, 2.88, 44, 2.78, 0.40, 18.03, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.d', 'CX', NULL, 1.33, 43, 0.20, 1.00, 1.74, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.d', 'CXP', 1, 89.97, 43, 5.26, 73.46, 96.67, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.d', 'CXP', 2, 1.61, 43, 1.58, 0.22, 10.86, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.d', 'CXP', 3, 0.92, 43, 0.72, 0.19, 4.39, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.d', 'CXP', 4, 0.07, 43, 0.08, 0.01, 0.58, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.d', 'CXP', 5, 7.42, 43, 5.09, 1.76, 26.35, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.e', 'CX', NULL, 1.16, 44, 0.11, 1.00, 1.39, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.e', 'CXP', 1, 94.24, 44, 3.21, 83.22, 98.18, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.e', 'CXP', 2, 1.88, 44, 1.60, 0.34, 9.88, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.e', 'CXP', 3, 0.07, 44, 0.08, 0.01, 0.58, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.e', 'CXP', 4, 0.92, 44, 0.72, 0.19, 4.37, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.e', 'CXP', 5, 2.88, 44, 2.78, 0.40, 18.03, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.f', 'CX', NULL, 1.33, 44, 0.15, 1.02, 1.64, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.f', 'CXP', 1, 83.83, 44, 6.85, 65.17, 93.49, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.f', 'CXP', 2, 6.06, 44, 3.60, 1.77, 18.79, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.f', 'CXP', 3, 6.57, 44, 5.52, 1.13, 30.16, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.f', 'CXP', 4, 0.67, 44, 0.69, 0.08, 5.23, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.f', 'CXP', 5, 2.88, 44, 2.78, 0.40, 18.03, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.a', 'CX', NULL, 3.99, 44, 0.14, 3.71, 4.27, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.a', 'CXP', 2, 4.56, 44, 2.61, 1.41, 13.80, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.a', 'CXP', 3, 17.42, 44, 7.22, 7.13, 36.72, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.a', 'CXP', 4, 52.08, 44, 9.31, 33.88, 69.75, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.a', 'CXP', 5, 25.93, 44, 7.54, 13.69, 43.59, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.b', 'CX', NULL, 2.16, 44, 0.15, 1.85, 2.47, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.b', 'CXP', 1, 13.95, 44, 8.88, 3.52, 41.90, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.b', 'CXP', 2, 61.00, 44, 10.92, 38.26, 79.78, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.b', 'CXP', 3, 20.30, 44, 8.41, 8.20, 42.07, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.b', 'CXP', 4, 4.75, 44, 2.62, 1.52, 13.83, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.c', 'CX', NULL, 1.14, 44, 0.06, 1.01, 1.27, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.c', 'CXP', 1, 86.15, 44, 6.48, 67.55, 94.89, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.c', 'CXP', 2, 13.85, 44, 6.48, 5.11, 32.45, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.d', 'CX', NULL, 1.99, 44, 0.11, 1.77, 2.21, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.d', 'CXP', 1, 17.17, 44, 6.75, 7.37, 35.07, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.d', 'CXP', 2, 72.49, 44, 7.23, 55.91, 84.56, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.d', 'CXP', 3, 4.75, 44, 3.28, 1.14, 17.73, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.d', 'CXP', 4, 5.59, 44, 3.33, 1.63, 17.45, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.e', 'CX', NULL, 1.30, 44, 0.09, 1.11, 1.48, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.e', 'CXP', 1, 70.14, 44, 9.17, 49.28, 85.03, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.e', 'CXP', 2, 29.86, 44, 9.17, 14.97, 50.72, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.f', 'CX', NULL, 1.04, 43, 0.03, 1.00, 1.10, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.f', 'CXP', 1, 96.10, 43, 2.86, 84.07, 99.14, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.f', 'CXP', 2, 3.72, 43, 2.86, 0.77, 16.19, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.f', 'CXP', 3, 0.19, 43, 0.19, 0.02, 1.45, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.g', 'CX', NULL, 2.52, 44, 0.32, 1.88, 3.17, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.g', 'CXP', 1, 36.48, 44, 10.42, 18.82, 58.72, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.g', 'CXP', 2, 23.45, 44, 9.61, 9.43, 47.41, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.g', 'CXP', 3, 8.86, 44, 4.44, 3.11, 22.74, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.g', 'CXP', 4, 13.65, 44, 6.54, 4.91, 32.63, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.g', 'CXP', 5, 17.56, 44, 7.83, 6.68, 38.81, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.h', 'CX', NULL, 1.53, 44, 0.12, 1.29, 1.77, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.h', 'CXP', 1, 51.67, 44, 10.67, 31.12, 71.68, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.h', 'CXP', 2, 44.38, 44, 10.19, 25.76, 64.73, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.h', 'CXP', 3, 3.60, 44, 2.84, 0.71, 16.32, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.h', 'CXP', 4, 0.35, 44, 0.29, 0.06, 1.88, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.i', 'CX', NULL, 2.59, 44, 0.31, 1.97, 3.20, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.i', 'CXP', 1, 24.15, 44, 8.60, 11.00, 45.07, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.i', 'CXP', 2, 34.45, 44, 10.35, 17.26, 56.97, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.i', 'CXP', 3, 16.00, 44, 6.69, 6.52, 34.20, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.i', 'CXP', 4, 9.30, 44, 4.16, 3.66, 21.70, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.i', 'CXP', 5, 16.10, 44, 8.96, 4.79, 42.25, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.d', 'CX', NULL, 1.47, 44, 0.17, 1.12, 1.82, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.d', 'CXP', 1, 75.13, 44, 8.68, 54.20, 88.52, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.d', 'CXP', 2, 8.68, 44, 5.70, 2.19, 28.82, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.d', 'CXP', 3, 13.31, 44, 7.13, 4.23, 34.80, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.d', 'CXP', 4, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.d', 'CXP', 5, 2.88, 44, 2.78, 0.40, 18.03, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.e', 'CX', NULL, 1.18, 44, 0.10, 1.00, 1.39, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.e', 'CXP', 1, 86.67, 44, 7.17, 65.04, 95.78, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.e', 'CXP', 2, 8.80, 44, 5.99, 2.10, 30.28, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.e', 'CXP', 3, 4.53, 44, 4.43, 0.60, 27.21, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.1', 'CX', NULL, 2.54, 44, 0.20, 2.13, 2.95, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.1', 'CXP', 1, 15.93, 44, 6.10, 7.03, 32.19, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.1', 'CXP', 2, 34.10, 44, 10.00, 17.42, 55.93, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.1', 'CXP', 3, 35.26, 44, 8.48, 20.47, 53.54, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.1', 'CXP', 4, 9.72, 44, 4.88, 3.39, 24.84, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.1', 'CXP', 5, 5.00, 44, 4.62, 0.73, 27.26, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.a', 'CX', NULL, 4.02, 43, 0.18, 3.67, 4.37, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.a', 'CXP', 2, 7.37, 43, 4.67, 1.96, 24.03, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.a', 'CXP', 3, 20.42, 43, 9.12, 7.64, 44.33, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.a', 'CXP', 4, 35.12, 43, 9.76, 18.56, 56.24, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.a', 'CXP', 5, 37.09, 43, 9.12, 21.13, 56.49, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.b', 'CX', NULL, 4.27, 43, 0.17, 3.93, 4.61, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.b', 'CXP', 1, 0.00, 43, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.b', 'CXP', 2, 2.17, 43, 2.17, 0.28, 14.87, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.b', 'CXP', 3, 13.98, 43, 9.32, 3.29, 43.70, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.b', 'CXP', 4, 38.35, 43, 9.43, 21.76, 58.19, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.b', 'CXP', 5, 45.51, 43, 9.59, 27.67, 64.58, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.4', 'CX', NULL, 4.44, 44, 0.14, 4.16, 4.72, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.4', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.4', 'CXP', 2, 1.80, 44, 1.82, 0.23, 12.72, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.4', 'CXP', 3, 10.43, 44, 5.07, 3.74, 25.83, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.4', 'CXP', 4, 30.02, 44, 9.94, 14.17, 52.70, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.4', 'CXP', 5, 57.76, 44, 10.52, 36.43, 76.54, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.2', 'CX', NULL, 2.53, 44, 0.20, 2.12, 2.93, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.2', 'CXP', 1, 17.08, 44, 7.32, 6.77, 36.88, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.2', 'CXP', 2, 27.50, 44, 9.88, 12.25, 50.76, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.2', 'CXP', 3, 40.89, 44, 8.52, 25.35, 58.48, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.2', 'CXP', 4, 14.53, 44, 7.11, 5.09, 35.04, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.2', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.4', 'CX', NULL, 4.03, 44, 0.22, 3.58, 4.48, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.4', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.4', 'CXP', 2, 12.44, 44, 8.74, 2.74, 41.77, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.4', 'CXP', 3, 9.14, 44, 4.45, 3.31, 22.86, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.4', 'CXP', 4, 41.60, 44, 9.37, 24.66, 60.80, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.4', 'CXP', 5, 36.81, 44, 8.76, 21.43, 55.46, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.7', 'CX', NULL, 3.81, 44, 0.22, 3.36, 4.26, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.7', 'CXP', 1, 3.40, 44, 3.15, 0.51, 19.60, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.7', 'CXP', 2, 9.68, 44, 4.72, 3.49, 24.13, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.7', 'CXP', 3, 25.18, 44, 9.85, 10.49, 49.12, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.7', 'CXP', 4, 26.26, 44, 7.68, 13.79, 44.21, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.7', 'CXP', 5, 35.49, 44, 8.64, 20.44, 54.07, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.8', 'CX', NULL, 4.54, 44, 0.17, 4.19, 4.90, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.8', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.8', 'CXP', 2, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.8', 'CXP', 3, 11.17, 44, 8.60, 2.14, 41.95, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.8', 'CXP', 4, 23.23, 44, 7.74, 11.21, 42.06, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.8', 'CXP', 5, 65.60, 44, 10.37, 43.01, 82.81, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.c.1', 'CX', NULL, 2.79, 44, 0.23, 2.32, 3.26, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.c.1', 'CXP', 1, 19.81, 44, 7.44, 8.77, 38.84, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.c.1', 'CXP', 2, 8.27, 44, 5.09, 2.28, 25.86, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.c.1', 'CXP', 3, 45.40, 44, 10.55, 26.05, 66.24, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.c.1', 'CXP', 4, 26.53, 44, 10.00, 11.37, 50.40, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.c.1', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.1', 'CX', NULL, 4.05, 44, 0.17, 3.72, 4.39, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.1', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.1', 'CXP', 2, 0.16, 44, 0.12, 0.04, 0.72, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.1', 'CXP', 3, 26.84, 44, 9.81, 11.81, 50.13, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.1', 'CXP', 4, 40.58, 44, 8.51, 25.10, 58.19, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.1', 'CXP', 5, 32.41, 44, 8.78, 17.60, 51.84, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.3', 'CX', NULL, 1.22, 44, 0.14, 1.00, 1.51, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.3', 'CXP', 1, 91.81, 44, 4.81, 75.52, 97.60, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.3', 'CXP', 2, 0.28, 44, 0.28, 0.04, 2.12, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.3', 'CXP', 3, 1.61, 44, 1.57, 0.22, 10.83, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.3', 'CXP', 4, 6.31, 44, 4.61, 1.38, 24.51, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.3', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.4', 'CT', NULL, 1.11, 44, 0.06, 1.00, 1.23, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.4', 'CTP', 1, 88.81, 44, 5.66, 71.56, 96.16, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.4', 'CTP', 2, 11.19, 44, 5.66, 3.84, 28.44, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.4', 'CTP', 3, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.8', 'CT', NULL, 2.37, 44, 0.12, 2.13, 2.62, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.8', 'CTP', 1, 8.57, 44, 5.20, 2.40, 26.34, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.8', 'CTP', 2, 45.74, 44, 10.87, 25.85, 67.09, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.8', 'CTP', 3, 45.69, 44, 10.26, 26.77, 65.94, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CX', NULL, 2.48, 41, 0.16, 2.15, 2.81, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CXP', 1, 2.62, 41, 1.64, 0.72, 9.01, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CXP', 2, 49.25, 41, 16.29, 20.63, 78.37, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CXP', 3, 45.43, 41, 15.90, 18.55, 75.26, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CXP', 4, 2.71, 41, 1.50, 0.87, 8.11, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CX', NULL, 4.99, 41, 0.01, 4.97, 5.00, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CXP', 4, 1.08, 41, 1.09, 0.14, 7.88, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CXP', 5, 98.92, 41, 1.09, 92.12, 99.86, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CX', NULL, 4.99, 41, 0.01, 4.98, 5.00, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CXP', 4, 0.62, 41, 0.64, 0.08, 4.77, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CXP', 5, 99.38, 41, 0.64, 95.23, 99.92, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CX', NULL, 3.14, 40, 0.22, 2.69, 3.58, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CXP', 1, 0.63, 40, 0.64, 0.08, 4.82, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CXP', 2, 24.41, 40, 16.40, 5.08, 66.11, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CXP', 3, 44.26, 40, 16.39, 17.16, 75.28, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CXP', 4, 22.23, 40, 9.01, 9.06, 45.06, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CXP', 5, 8.47, 40, 3.86, 3.27, 20.21, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CX', NULL, 4.82, 41, 0.16, 4.49, 5.00, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CXP', 4, 17.55, 41, 16.42, 2.10, 67.83, 'Y', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CXP', 5, 82.45, 41, 16.42, 32.17, 97.90, 'Y', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CX', NULL, 4.53, 41, 0.16, 4.20, 4.85, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CXP', 1, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CXP', 2, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CXP', 3, 2.62, 41, 1.65, 0.72, 9.04, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CXP', 4, 41.97, 41, 15.60, 16.54, 72.51, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CXP', 5, 55.41, 41, 15.80, 25.45, 81.90, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CX', NULL, 4.17, 41, 0.40, 3.37, 4.97, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CXP', 2, 18.34, 41, 16.40, 2.40, 67.26, 'Y', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CXP', 3, 1.30, 41, 0.94, 0.29, 5.51, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CXP', 4, 25.69, 41, 13.13, 7.93, 58.14, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CXP', 5, 54.67, 41, 10.01, 34.77, 73.18, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CX', NULL, 3.15, 40, 0.45, 2.24, 4.06, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CXP', 1, 11.57, 40, 4.67, 4.94, 24.77, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CXP', 2, 14.87, 40, 10.92, 2.96, 50.00, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CXP', 3, 43.73, 40, 11.82, 22.73, 67.25, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CXP', 4, 6.70, 40, 3.36, 2.36, 17.57, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CXP', 5, 23.12, 40, 16.42, 4.44, 66.07, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CX', NULL, 4.03, 41, 0.32, 3.38, 4.68, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CXP', 1, 0.62, 41, 0.64, 0.08, 4.77, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CXP', 2, 2.77, 41, 2.17, 0.56, 12.69, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CXP', 3, 28.02, 41, 16.68, 6.81, 67.44, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CXP', 4, 30.06, 41, 9.01, 15.30, 50.55, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CXP', 5, 38.53, 41, 16.39, 13.40, 71.75, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CX', NULL, 2.62, 41, 0.45, 1.72, 3.52, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CXP', 1, 31.10, 41, 16.63, 8.60, 68.41, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CXP', 2, 20.21, 41, 10.79, 6.15, 49.48, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CXP', 3, 23.67, 41, 12.20, 7.34, 54.84, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CXP', 4, 5.81, 41, 3.06, 1.96, 16.02, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CXP', 5, 19.21, 41, 10.06, 6.03, 46.83, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CX', NULL, 3.83, 41, 0.35, 3.11, 4.54, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CXP', 1, 7.61, 41, 6.02, 1.43, 31.76, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CXP', 2, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CXP', 3, 34.92, 41, 17.68, 10.02, 72.10, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CXP', 4, 17.03, 41, 6.79, 7.22, 35.15, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CXP', 5, 40.44, 41, 15.61, 15.49, 71.56, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CX', NULL, 3.32, 41, 0.27, 2.77, 3.86, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CXP', 1, 6.20, 41, 5.96, 0.82, 34.41, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CXP', 2, 6.42, 41, 3.30, 2.21, 17.26, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CXP', 3, 46.39, 41, 16.34, 18.66, 76.55, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CXP', 4, 31.55, 41, 16.26, 9.14, 67.85, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CXP', 5, 9.44, 41, 8.78, 1.29, 45.36, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CX', NULL, 2.90, 41, 0.26, 2.37, 3.43, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CXP', 1, 7.66, 41, 6.08, 1.44, 32.02, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CXP', 2, 25.44, 41, 13.18, 7.72, 58.16, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CXP', 3, 46.77, 41, 16.74, 18.42, 77.37, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CXP', 4, 9.51, 41, 3.96, 3.99, 21.02, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CXP', 5, 10.62, 41, 8.74, 1.81, 43.33, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CX', NULL, 1.55, 39, 0.27, 1.00, 2.09, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CXP', 1, 65.73, 39, 12.21, 39.04, 85.18, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CXP', 2, 24.09, 39, 11.38, 8.26, 52.80, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CXP', 3, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CXP', 4, 10.18, 39, 9.40, 1.40, 47.59, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CXP', 5, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CX', NULL, 4.86, 41, 0.09, 4.68, 5.00, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CXP', 1, 0.79, 41, 0.80, 0.10, 5.92, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CXP', 2, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CXP', 3, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CXP', 4, 10.55, 41, 8.79, 1.76, 43.66, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CXP', 5, 88.67, 41, 8.79, 57.20, 97.86, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CX', NULL, 1.63, 41, 0.28, 1.06, 2.19, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CXP', 1, 71.61, 41, 10.61, 46.76, 87.87, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CXP', 2, 5.14, 41, 2.93, 1.59, 15.41, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CXP', 3, 13.02, 41, 8.09, 3.41, 38.81, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CXP', 4, 9.44, 41, 8.78, 1.29, 45.36, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CXP', 5, 0.79, 41, 0.80, 0.10, 5.92, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CX', NULL, 1.38, 40, 0.29, 1.00, 1.97, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CXP', 1, 83.45, 40, 9.61, 55.25, 95.37, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CXP', 2, 5.76, 40, 2.46, 2.39, 13.27, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CXP', 3, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CXP', 4, 10.79, 40, 9.85, 1.50, 48.92, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CX', NULL, 1.16, 39, 0.10, 1.00, 1.36, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CXP', 1, 84.22, 39, 9.76, 54.70, 95.93, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CXP', 2, 15.78, 39, 9.76, 4.07, 45.30, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CXP', 3, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CXP', 4, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CXP', 5, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CX', NULL, 1.00, 40, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CXP', 1, 100.00, 40, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CXP', 2, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CXP', 3, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CXP', 4, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CX', NULL, 2.17, 39, 0.28, 1.61, 2.73, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CXP', 1, 36.12, 39, 15.83, 12.36, 69.40, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CXP', 2, 30.38, 39, 18.09, 7.18, 71.13, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CXP', 3, 13.85, 39, 7.13, 4.58, 35.02, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CXP', 4, 19.64, 39, 10.76, 5.79, 49.26, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CXP', 5, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CX', NULL, 2.33, 40, 0.10, 2.14, 2.52, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CXP', 1, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CXP', 2, 72.86, 40, 8.23, 53.64, 86.17, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CXP', 3, 21.96, 40, 7.90, 9.97, 41.69, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CXP', 4, 4.28, 40, 2.34, 1.38, 12.46, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CXP', 5, 0.90, 40, 0.91, 0.11, 6.69, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CX', NULL, 2.32, 40, 0.16, 1.99, 2.65, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CXP', 1, 15.94, 40, 7.29, 5.93, 36.32, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CXP', 2, 49.53, 40, 9.92, 30.54, 68.65, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CXP', 3, 25.64, 40, 10.91, 9.77, 52.32, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CXP', 4, 4.62, 40, 2.39, 1.59, 12.68, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CXP', 5, 4.28, 40, 2.28, 1.43, 12.10, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CX', NULL, 1.37, 40, 0.11, 1.14, 1.59, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CXP', 1, 70.17, 40, 10.40, 46.27, 86.53, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CXP', 2, 26.11, 40, 10.63, 10.39, 51.85, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CXP', 3, 1.34, 40, 1.03, 0.28, 6.15, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CXP', 4, 1.68, 40, 1.66, 0.22, 11.55, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CXP', 5, 0.71, 40, 0.73, 0.09, 5.41, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CX', NULL, 1.44, 40, 0.11, 1.22, 1.66, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CXP', 1, 64.67, 40, 9.93, 43.18, 81.52, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CXP', 2, 27.46, 40, 10.55, 11.48, 52.49, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CXP', 3, 7.15, 40, 3.85, 2.33, 19.91, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CXP', 4, 0.71, 40, 0.73, 0.09, 5.41, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CX', NULL, 1.37, 41, 0.14, 1.09, 1.66, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CXP', 1, 73.77, 41, 9.89, 50.03, 88.76, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CXP', 2, 21.42, 41, 9.64, 7.89, 46.45, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CXP', 3, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CXP', 4, 3.34, 41, 2.07, 0.94, 11.20, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CXP', 5, 1.47, 41, 1.46, 0.19, 10.34, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CX', NULL, 1.55, 41, 0.17, 1.20, 1.91, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CXP', 1, 63.86, 41, 11.00, 40.28, 82.23, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CXP', 2, 18.71, 41, 8.97, 6.53, 43.11, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CXP', 3, 15.56, 41, 8.23, 4.94, 39.52, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CXP', 4, 1.87, 41, 1.44, 0.39, 8.47, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CX', NULL, 1.01, 41, 0.01, 1.00, 1.02, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CXP', 1, 99.38, 41, 0.64, 95.23, 99.92, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CXP', 2, 0.62, 41, 0.64, 0.08, 4.77, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CX', NULL, 1.03, 40, 0.02, 1.00, 1.07, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CXP', 1, 98.31, 40, 1.26, 92.60, 99.63, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CXP', 2, 1.06, 40, 1.08, 0.13, 7.91, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CXP', 4, 0.63, 40, 0.64, 0.08, 4.84, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CX', NULL, 1.14, 41, 0.06, 1.02, 1.26, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CXP', 1, 92.66, 41, 2.78, 84.69, 96.64, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CXP', 2, 2.51, 41, 1.54, 0.72, 8.39, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CXP', 3, 2.96, 41, 1.58, 1.00, 8.47, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CXP', 4, 1.87, 41, 1.44, 0.39, 8.47, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CX', NULL, 1.23, 41, 0.13, 1.00, 1.49, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CXP', 1, 83.51, 41, 8.20, 60.33, 94.40, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CXP', 2, 10.29, 41, 6.18, 2.88, 30.75, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CXP', 3, 6.20, 41, 5.96, 0.82, 34.41, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CX', NULL, 1.15, 41, 0.12, 1.00, 1.39, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CXP', 1, 90.89, 41, 6.11, 69.18, 97.79, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CXP', 2, 2.92, 41, 1.61, 0.94, 8.68, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CXP', 3, 6.20, 41, 5.96, 0.82, 34.41, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CXP', 4, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CX', NULL, 1.06, 41, 0.03, 1.00, 1.13, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CXP', 1, 94.41, 41, 2.89, 84.79, 98.08, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CXP', 2, 4.97, 41, 2.81, 1.55, 14.83, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CXP', 3, 0.62, 41, 0.64, 0.08, 4.77, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CXP', 4, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CX', NULL, 1.08, 41, 0.03, 1.01, 1.15, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CXP', 1, 93.31, 41, 2.82, 84.84, 97.20, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CXP', 2, 5.59, 41, 2.51, 2.21, 13.41, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CXP', 3, 1.10, 41, 1.12, 0.14, 8.18, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CX', NULL, 4.29, 41, 0.24, 3.81, 4.77, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CXP', 2, 9.44, 41, 8.78, 1.29, 45.36, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CXP', 3, 2.87, 41, 1.79, 0.80, 9.74, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CXP', 4, 37.06, 41, 11.03, 18.46, 60.48, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CXP', 5, 50.63, 41, 10.67, 30.20, 70.85, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CX', NULL, 1.91, 41, 0.22, 1.47, 2.35, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CXP', 1, 24.97, 41, 16.29, 5.43, 65.86, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CXP', 2, 59.01, 41, 17.03, 25.77, 85.66, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CXP', 3, 16.02, 41, 11.00, 3.53, 49.88, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CXP', 4, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CX', NULL, 1.09, 41, 0.06, 1.00, 1.22, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CXP', 1, 90.75, 41, 6.10, 69.31, 97.71, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CXP', 2, 9.25, 41, 6.10, 2.29, 30.69, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CX', NULL, 1.64, 41, 0.17, 1.30, 1.98, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CXP', 1, 36.82, 41, 16.84, 11.89, 71.57, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CXP', 2, 62.55, 41, 16.81, 28.15, 87.69, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CXP', 3, 0.62, 41, 0.64, 0.08, 4.77, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CXP', 4, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CX', NULL, 1.30, 41, 0.10, 1.11, 1.50, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CXP', 1, 69.70, 41, 9.55, 47.97, 85.16, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CXP', 2, 30.30, 41, 9.55, 14.84, 52.03, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CX', NULL, 1.04, 41, 0.03, 1.00, 1.10, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CXP', 1, 95.68, 41, 2.88, 84.41, 98.91, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CXP', 2, 4.32, 41, 2.88, 1.09, 15.59, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CX', NULL, 3.04, 39, 0.41, 2.21, 3.87, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CXP', 1, 30.30, 39, 12.39, 11.71, 58.77, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CXP', 2, 19.61, 39, 7.82, 8.20, 39.96, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CXP', 3, 2.72, 39, 1.47, 0.90, 7.94, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CXP', 4, 10.86, 39, 4.11, 4.90, 22.36, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CXP', 5, 36.50, 39, 9.97, 19.40, 57.86, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CX', NULL, 1.41, 41, 0.16, 1.10, 1.73, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CXP', 1, 59.56, 41, 15.48, 28.67, 84.37, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CXP', 2, 39.82, 41, 15.41, 15.28, 70.83, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CXP', 3, 0.62, 41, 0.64, 0.08, 4.77, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CXP', 4, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CX', NULL, 2.54, 41, 0.49, 1.55, 3.54, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CXP', 1, 38.22, 41, 17.23, 12.40, 73.00, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CXP', 2, 10.70, 41, 4.50, 4.42, 23.68, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CXP', 3, 13.57, 41, 6.65, 4.75, 33.06, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CXP', 4, 33.51, 41, 15.76, 10.77, 67.79, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CXP', 5, 4.00, 41, 2.97, 0.86, 16.62, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CX', NULL, 1.34, 41, 0.19, 1.00, 1.72, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CXP', 1, 80.02, 41, 9.94, 53.27, 93.37, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CXP', 2, 12.99, 41, 8.83, 2.98, 42.01, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CXP', 3, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CXP', 4, 6.99, 41, 6.00, 1.15, 32.67, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CX', NULL, 1.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CXP', 1, 100.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CXP', 2, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CXP', 3, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CX', NULL, 3.37, 40, 0.36, 2.64, 4.11, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CXP', 1, 6.09, 40, 2.94, 2.24, 15.51, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CXP', 2, 21.18, 40, 16.46, 3.53, 66.37, 'Y', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CXP', 3, 22.35, 40, 9.14, 9.03, 45.50, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CXP', 4, 30.17, 40, 15.33, 9.03, 65.30, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CXP', 5, 20.21, 40, 9.46, 7.18, 45.34, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CX', NULL, 4.22, 41, 0.20, 3.82, 4.62, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CXP', 1, 1.08, 41, 1.09, 0.14, 7.88, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CXP', 2, 2.00, 41, 1.22, 0.58, 6.69, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CXP', 3, 15.80, 41, 6.93, 6.14, 34.96, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CXP', 4, 35.75, 41, 16.30, 11.70, 70.02, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CXP', 5, 45.37, 41, 16.42, 17.88, 76.01, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CX', NULL, 4.14, 41, 0.18, 3.77, 4.50, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CXP', 1, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CXP', 2, 1.41, 41, 1.04, 0.31, 6.10, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CXP', 3, 18.92, 41, 8.25, 7.29, 40.91, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CXP', 4, 44.28, 41, 16.81, 16.71, 75.90, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CXP', 5, 35.38, 41, 15.34, 12.37, 68.00, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CX', NULL, 4.49, 41, 0.11, 4.26, 4.71, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CXP', 1, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CXP', 2, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CXP', 3, 3.00, 41, 1.61, 1.00, 8.65, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CXP', 4, 45.37, 41, 10.23, 26.50, 65.67, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CXP', 5, 51.63, 41, 10.54, 31.26, 71.47, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CX', NULL, 2.16, 40, 0.24, 1.68, 2.65, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CXP', 1, 35.50, 40, 9.42, 19.33, 55.84, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CXP', 2, 32.25, 40, 11.82, 13.75, 58.70, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CXP', 3, 15.41, 40, 6.75, 6.00, 34.19, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CXP', 4, 14.29, 40, 9.01, 3.63, 42.49, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CXP', 5, 2.56, 40, 2.50, 0.35, 16.59, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CX', NULL, 4.22, 41, 0.19, 3.84, 4.60, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CXP', 1, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CXP', 2, 3.17, 41, 2.56, 0.60, 15.02, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CXP', 3, 7.34, 41, 3.54, 2.69, 18.48, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CXP', 4, 54.07, 41, 16.25, 23.88, 81.54, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CXP', 5, 35.42, 41, 16.57, 11.26, 70.34, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CX', NULL, 3.51, 41, 0.43, 2.64, 4.38, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CXP', 1, 22.62, 41, 11.55, 7.16, 52.58, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CXP', 2, 6.56, 41, 2.62, 2.88, 14.27, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CXP', 3, 0.84, 41, 0.62, 0.19, 3.64, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CXP', 4, 37.20, 41, 15.17, 13.75, 68.76, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CXP', 5, 32.78, 41, 16.19, 9.95, 68.27, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CX', NULL, 4.56, 41, 0.24, 4.07, 5.00, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CXP', 1, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CXP', 2, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CXP', 3, 12.47, 41, 11.17, 1.77, 52.97, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CXP', 4, 19.49, 41, 11.52, 5.20, 51.63, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CXP', 5, 68.04, 41, 15.28, 33.97, 89.81, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CX', NULL, 3.35, 40, 0.35, 2.64, 4.06, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CXP', 1, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CXP', 2, 21.23, 40, 16.44, 3.56, 66.33, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CXP', 3, 39.01, 40, 11.51, 19.38, 62.99, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CXP', 4, 23.70, 40, 12.92, 6.82, 56.86, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CXP', 5, 16.06, 40, 9.04, 4.70, 42.62, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CX', NULL, 4.02, 41, 0.16, 3.69, 4.35, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CXP', 1, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CXP', 2, 1.41, 41, 1.04, 0.31, 6.10, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CXP', 3, 21.96, 41, 8.36, 9.50, 42.99, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CXP', 4, 49.83, 41, 16.49, 20.75, 79.02, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CXP', 5, 26.81, 41, 14.10, 7.89, 61.02, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CX', NULL, 1.09, 41, 0.06, 1.00, 1.20, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CXP', 1, 95.45, 41, 2.87, 84.63, 98.76, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CXP', 2, 0.60, 41, 0.61, 0.08, 4.56, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CXP', 3, 3.96, 41, 2.78, 0.93, 15.33, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CXP', 4, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CXP', 5, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.4', 'CT', NULL, 1.27, 41, 0.12, 1.01, 1.52, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.4', 'CTP', 1, 73.44, 41, 12.40, 43.33, 90.91, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.4', 'CTP', 2, 26.56, 41, 12.40, 9.09, 56.67, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.4', 'CTP', 3, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.8', 'CT', NULL, 2.57, 41, 0.10, 2.37, 2.77, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.8', 'CTP', 1, 0.00, 41, 0.00, NULL, NULL, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.8', 'CTP', 2, 42.81, 41, 10.04, 24.63, 63.17, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.8', 'CTP', 3, 57.19, 41, 10.04, 36.83, 75.37, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CX', NULL, 2.57, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CXP', 1, 6.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CXP', 2, 46.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CXP', 3, 33.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CXP', 4, 10.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CXP', 5, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CX', NULL, 4.97, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CXP', 2, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CXP', 3, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CXP', 4, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CXP', 5, 96.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CX', NULL, 4.97, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CXP', 2, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CXP', 3, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CXP', 4, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CXP', 5, 96.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CX', NULL, 4.17, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CXP', 2, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CXP', 3, 20.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CXP', 4, 43.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CXP', 5, 36.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CX', NULL, 4.93, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CXP', 2, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CXP', 3, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CXP', 4, 6.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CXP', 5, 93.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CX', NULL, 4.27, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CXP', 2, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CXP', 3, 16.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CXP', 4, 30.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CXP', 5, 50.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CX', NULL, 4.37, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CXP', 2, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CXP', 3, 6.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CXP', 4, 50.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CXP', 5, 43.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CX', NULL, 3.17, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CXP', 1, 10.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CXP', 2, 26.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CXP', 3, 20.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CXP', 4, 23.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CXP', 5, 20.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CX', NULL, 3.97, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CXP', 2, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CXP', 3, 20.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CXP', 4, 53.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CXP', 5, 23.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CX', NULL, 2.43, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CXP', 1, 10.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CXP', 2, 56.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CXP', 3, 16.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CXP', 4, 13.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CXP', 5, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CX', NULL, 4.13, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CXP', 2, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CXP', 3, 6.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CXP', 4, 63.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CXP', 5, 26.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CX', NULL, 3.07, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CXP', 2, 30.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CXP', 3, 40.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CXP', 4, 23.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CXP', 5, 6.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CX', NULL, 2.70, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CXP', 1, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CXP', 2, 36.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CXP', 3, 46.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CXP', 4, 13.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CXP', 5, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CX', NULL, 1.30, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CXP', 1, 76.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CXP', 2, 16.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CXP', 3, 6.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CXP', 4, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CXP', 5, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.a', 'CX', NULL, 5.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.a', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.a', 'CXP', 2, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.a', 'CXP', 3, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.a', 'CXP', 4, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.a', 'CXP', 5, 100.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.b', 'CX', NULL, 1.37, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.b', 'CXP', 1, 63.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.b', 'CXP', 2, 36.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.b', 'CXP', 3, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.b', 'CXP', 4, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.b', 'CXP', 5, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.c', 'CX', NULL, 1.17, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.c', 'CXP', 1, 86.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.c', 'CXP', 2, 10.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.c', 'CXP', 3, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.c', 'CXP', 4, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.c', 'CXP', 5, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.d', 'CX', NULL, 1.10, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.d', 'CXP', 1, 90.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.d', 'CXP', 2, 10.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.d', 'CXP', 3, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.d', 'CXP', 4, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.d', 'CXP', 5, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.e', 'CX', NULL, 1.03, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.e', 'CXP', 1, 96.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.e', 'CXP', 2, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.e', 'CXP', 3, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.e', 'CXP', 4, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupa