CREATE TABLE occupation_level_metadata (
  onetsoc_code CHARACTER(10) NOT NULL,
  item CHARACTER VARYING(150) NOT NULL,
  response CHARACTER VARYING(75),
  n DECIMAL(4,0),
  [percent] DECIMAL(4,1),
  date_updated DATE NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code));
GO

INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'Data Collection Mode', 'Paper', 87, 66.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'Data Collection Mode', 'Web', 87, 33.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '1-5 Years', 87, 35.6, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '10 Years or More', 87, 43.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '6-9 Years', 87, 9.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '<1 Year', 87, 11.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'How Long at Current Job', 'Missing', 87, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 87, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 87, 9.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 87, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 87, 25.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 87, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 87, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 87, 9.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 87, 3.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 87, 39.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 87, 6.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 87, 6.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Accommodation and food services', 87, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 87, 5.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 87, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 87, 1.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Construction', 87, 9.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Education services', 87, 4.6, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Finance and insurance', 87, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Health care and social assistance', 87, 25.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Information', 87, 6.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Management of Companies and Enterprises', 87, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Manufacturing', 87, 23.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Mining', 87, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Other services, except public administration', 87, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 87, 3.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Public administration', 87, 9.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Real estate and rental and leasing', 87, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Retail trade', 87, 3.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Transportation and warehousing', 87, 1.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Unclassified', 87, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Utilities', 87, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Wholesale trade', 87, 6.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 87.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 60.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 63.8, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.00', 'Total Completes for O*NET-SOC', NULL, 87, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'Data Collection Mode', 'Paper', 26, 34.6, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'Data Collection Mode', 'Web', 26, 65.4, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'How Long at Current Job', '1-5 Years', 26, 19.2, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'How Long at Current Job', '10 Years or More', 26, 46.2, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'How Long at Current Job', '6-9 Years', 26, 34.6, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'How Long at Current Job', '<1 Year', 26, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'How Long at Current Job', 'Missing', 26, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Construction', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Education services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Information', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Mining', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Retail trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Unclassified', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Utilities', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 92.9, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 82.4, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'O*NET-SOC Employee Response Rate', NULL, NULL, 96.6, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1011.03', 'Total Completes for O*NET-SOC', NULL, 26, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'Data Collection Mode', 'Paper', 120, 79.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'Data Collection Mode', 'Web', 120, 20.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '1-5 Years', 120, 25.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '10 Years or More', 120, 57.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '6-9 Years', 120, 12.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '<1 Year', 120, 3.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'How Long at Current Job', 'Missing', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 120, 5.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 120, 33.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 120, 4.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 120, 16.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 120, 0.0, '2008-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 120, 6.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 120, 10.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 120, 15.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 120, 3.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 120, 4.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Accommodation and food services', 120, 1.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 120, 2.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 120, 1.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Construction', 120, 33.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Education services', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Finance and insurance', 120, 4.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Health care and social assistance', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Information', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Manufacturing', 120, 20.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Mining', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Other services, except public administration', 120, 3.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 120, 9.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Public administration', 120, 6.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Real estate and rental and leasing', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Retail trade', 120, 9.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Transportation and warehousing', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Unclassified', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Utilities', 120, 2.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Wholesale trade', 120, 4.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 90.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 76.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 64.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-1021.00', 'Total Completes for O*NET-SOC', NULL, 120, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'Data Collection Mode', 'Paper', 62, 72.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'Data Collection Mode', 'Web', 62, 27.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '1-5 Years', 62, 40.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '10 Years or More', 62, 25.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '6-9 Years', 62, 17.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '<1 Year', 62, 16.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'How Long at Current Job', 'Missing', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 62, 14.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 62, 48.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 62, 37.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Accommodation and food services', 62, 11.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 62, 4.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 62, 4.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Construction', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Education services', 62, 4.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Finance and insurance', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Health care and social assistance', 62, 1.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Information', 62, 51.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Management of Companies and Enterprises', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Manufacturing', 62, 6.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Mining', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Other services, except public administration', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 62, 12.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Public administration', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Real estate and rental and leasing', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Retail trade', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Transportation and warehousing', 62, 1.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Unclassified', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Utilities', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Wholesale trade', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 81.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 75.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 59.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2011.00', 'Total Completes for O*NET-SOC', NULL, 62, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'Data Collection Mode', 'Paper', 25, 60.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'Data Collection Mode', 'Web', 25, 40.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '1-5 Years', 25, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '10 Years or More', 25, 80.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '6-9 Years', 25, 20.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '<1 Year', 25, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'How Long at Current Job', 'Missing', 25, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 75.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2021.00', 'Total Completes for O*NET-SOC', NULL, 25, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'Data Collection Mode', 'Paper', 21, 90.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'Data Collection Mode', 'Web', 21, 9.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'How Long at Current Job', '1-5 Years', 21, 19.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'How Long at Current Job', '10 Years or More', 21, 61.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'How Long at Current Job', '6-9 Years', 21, 19.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'How Long at Current Job', '<1 Year', 21, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'How Long at Current Job', 'Missing', 21, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 62.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 79.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2022.00', 'Total Completes for O*NET-SOC', NULL, 21, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'Data Collection Mode', 'Paper', 103, 68.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'Data Collection Mode', 'Web', 103, 32.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'How Long at Current Job', '1-5 Years', 103, 38.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'How Long at Current Job', '10 Years or More', 103, 26.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'How Long at Current Job', '6-9 Years', 103, 23.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'How Long at Current Job', '<1 Year', 103, 11.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'How Long at Current Job', 'Missing', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 103, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 103, 12.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 103, 84.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 103, 1.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Accommodation and food services', 103, 2.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 103, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 103, 2.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Construction', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Education services', 103, 32.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Finance and insurance', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Health care and social assistance', 103, 13.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Information', 103, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Management of Companies and Enterprises', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Manufacturing', 103, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Mining', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Other services, except public administration', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 103, 32.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Public administration', 103, 12.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Real estate and rental and leasing', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Retail trade', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Transportation and warehousing', 103, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Unclassified', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Utilities', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Wholesale trade', 103, 0.0, '2009-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 92.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 70.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 62.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-2031.00', 'Total Completes for O*NET-SOC', NULL, 103, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'Data Collection Mode', 'Paper', 116, 82.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'Data Collection Mode', 'Web', 116, 17.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'How Long at Current Job', '1-5 Years', 116, 27.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'How Long at Current Job', '10 Years or More', 116, 43.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'How Long at Current Job', '6-9 Years', 116, 21.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'How Long at Current Job', '<1 Year', 116, 6.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'How Long at Current Job', 'Missing', 116, 1.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 116, 3.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 116, 2.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 116, 5.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 116, 6.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 116, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 116, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 116, 14.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 116, 6.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 116, 56.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 116, 4.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 116, 0.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Accommodation and food services', 116, 1.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 116, 1.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 116, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 116, 1.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Construction', 116, 2.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Education services', 116, 30.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Finance and insurance', 116, 5.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Health care and social assistance', 116, 17.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Information', 116, 4.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Management of Companies and Enterprises', 116, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Manufacturing', 116, 5.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Mining', 116, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Other services, except public administration', 116, 0.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 116, 4.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Public administration', 116, 14.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Real estate and rental and leasing', 116, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Retail trade', 116, 5.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Transportation and warehousing', 116, 3.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Unclassified', 116, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Utilities', 116, 0.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Wholesale trade', 116, 0.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 89.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 82.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 66.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3011.00', 'Total Completes for O*NET-SOC', NULL, 116, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'Data Collection Mode', 'Paper', 120, 38.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'Data Collection Mode', 'Web', 120, 61.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '1-5 Years', 120, 41.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '10 Years or More', 120, 25.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '6-9 Years', 120, 22.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '<1 Year', 120, 9.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'How Long at Current Job', 'Missing', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 120, 3.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 120, 14.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 120, 25.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 120, 50.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 120, 4.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Accommodation and food services', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 120, 1.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Construction', 120, 1.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Education services', 120, 21.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Finance and insurance', 120, 2.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Health care and social assistance', 120, 15.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Information', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Manufacturing', 120, 14.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Mining', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Other services, except public administration', 120, 4.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 120, 6.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Public administration', 120, 25.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Real estate and rental and leasing', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Retail trade', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Transportation and warehousing', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Unclassified', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Utilities', 120, 3.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Wholesale trade', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 67.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 59.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3021.00', 'Total Completes for O*NET-SOC', NULL, 120, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'Data Collection Mode', 'Paper', 30, 50.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'Data Collection Mode', 'Web', 30, 50.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'How Long at Current Job', '1-5 Years', 30, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'How Long at Current Job', '10 Years or More', 30, 96.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'How Long at Current Job', '6-9 Years', 30, 3.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'How Long at Current Job', '<1 Year', 30, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'How Long at Current Job', 'Missing', 30, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2012-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Construction', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Education services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Information', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Mining', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 65.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 86.5, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.01', 'Total Completes for O*NET-SOC', NULL, 30, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'Data Collection Mode', 'Paper', 86, 62.8, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'Data Collection Mode', 'Web', 86, 37.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'How Long at Current Job', '1-5 Years', 86, 40.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'How Long at Current Job', '10 Years or More', 86, 39.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'How Long at Current Job', '6-9 Years', 86, 14.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'How Long at Current Job', '<1 Year', 86, 4.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'How Long at Current Job', 'Missing', 86, 1.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 86, 100.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Accommodation and food services', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Construction', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Education services', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Finance and insurance', 86, 98.8, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Health care and social assistance', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Information', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Management of Companies and Enterprises', 86, 1.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Manufacturing', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Mining', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Other services, except public administration', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Public administration', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Real estate and rental and leasing', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Retail trade', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Transportation and warehousing', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Unclassified', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Utilities', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Wholesale trade', 86, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 69.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 51.8, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3031.02', 'Total Completes for O*NET-SOC', NULL, 86, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'Data Collection Mode', 'Paper', 118, 61.9, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'Data Collection Mode', 'Web', 118, 38.1, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '1-5 Years', 118, 31.4, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '10 Years or More', 118, 46.6, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '6-9 Years', 118, 15.3, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '<1 Year', 118, 4.2, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'How Long at Current Job', 'Missing', 118, 2.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 118, 100.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Accommodation and food services', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Construction', 118, 0.0, '2013-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Education services', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Finance and insurance', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Health care and social assistance', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Information', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Management of Companies and Enterprises', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Manufacturing', 118, 100.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Mining', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Other services, except public administration', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Public administration', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Real estate and rental and leasing', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Retail trade', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Transportation and warehousing', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Unclassified', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Utilities', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Wholesale trade', 118, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 94.4, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 66.8, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 70.4, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.00', 'Total Completes for O*NET-SOC', NULL, 118, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'Data Collection Mode', 'Paper', 60, 41.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'Data Collection Mode', 'Web', 60, 58.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'How Long at Current Job', '1-5 Years', 60, 43.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'How Long at Current Job', '10 Years or More', 60, 31.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'How Long at Current Job', '6-9 Years', 60, 18.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'How Long at Current Job', '<1 Year', 60, 6.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'How Long at Current Job', 'Missing', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 60, 1.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 60, 76.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 60, 3.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 60, 18.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Accommodation and food services', 60, 3.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 60, 6.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Construction', 60, 6.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Education services', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Finance and insurance', 60, 3.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Health care and social assistance', 60, 11.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Information', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Management of Companies and Enterprises', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Manufacturing', 60, 16.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Mining', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Other services, except public administration', 60, 1.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 60, 28.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Public administration', 60, 1.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Real estate and rental and leasing', 60, 3.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Retail trade', 60, 6.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Transportation and warehousing', 60, 1.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Unclassified', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Utilities', 60, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Wholesale trade', 60, 8.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 65.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 77.1, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.01', 'Total Completes for O*NET-SOC', NULL, 60, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'Data Collection Mode', 'Paper', 52, 50.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'Data Collection Mode', 'Web', 52, 50.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '1-5 Years', 52, 30.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '10 Years or More', 52, 40.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '6-9 Years', 52, 23.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '<1 Year', 52, 3.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'How Long at Current Job', 'Missing', 52, 1.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 52, 9.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 52, 25.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 52, 65.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Accommodation and food services', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Construction', 52, 9.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Education services', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Finance and insurance', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Health care and social assistance', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Information', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Management of Companies and Enterprises', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Manufacturing', 52, 25.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Mining', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Other services, except public administration', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Public administration', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Real estate and rental and leasing', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Retail trade', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Transportation and warehousing', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Unclassified', 52, 0.0, '2011-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Utilities', 52, 65.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Wholesale trade', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 94.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 69.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 94.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.02', 'Total Completes for O*NET-SOC', NULL, 52, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'Data Collection Mode', 'Paper', 138, 68.1, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'Data Collection Mode', 'Web', 138, 31.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'How Long at Current Job', '1-5 Years', 138, 35.5, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'How Long at Current Job', '10 Years or More', 138, 44.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'How Long at Current Job', '6-9 Years', 138, 14.5, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'How Long at Current Job', '<1 Year', 138, 5.1, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'How Long at Current Job', 'Missing', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 138, 0.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 138, 7.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 138, 1.4, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 138, 21.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 138, 2.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 138, 8.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 138, 2.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 138, 56.5, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Accommodation and food services', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 138, 0.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Arts, entertainment, and recreation', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Construction', 138, 7.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Education services', 138, 0.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Finance and insurance', 138, 3.6, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Health care and social assistance', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Information', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Management of Companies and Enterprises', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Manufacturing', 138, 21.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Mining', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Other services, except public administration', 138, 1.4, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Professional, Scientific and Technical Services', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Public administration', 138, 2.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Real estate and rental and leasing', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Retail trade', 138, 8.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Transportation and warehousing', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Unclassified', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Utilities', 138, 54.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Wholesale trade', 138, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'O*NET-SOC Employee Response Rate', NULL, NULL, 86.6, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 92.4, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3051.04', 'Total Completes for O*NET-SOC', NULL, 138, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'Data Collection Mode', 'Paper', 24, 66.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'Data Collection Mode', 'Web', 24, 33.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'How Long at Current Job', '1-5 Years', 24, 4.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'How Long at Current Job', '10 Years or More', 24, 87.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'How Long at Current Job', '6-9 Years', 24, 8.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'How Long at Current Job', '<1 Year', 24, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'How Long at Current Job', 'Missing', 24, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 66.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3061.00', 'Total Completes for O*NET-SOC', NULL, 24, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'Data Collection Mode', 'Paper', 98, 56.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'Data Collection Mode', 'Web', 98, 43.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'How Long at Current Job', '1-5 Years', 98, 30.6, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'How Long at Current Job', '10 Years or More', 98, 53.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'How Long at Current Job', '6-9 Years', 98, 8.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'How Long at Current Job', '<1 Year', 98, 8.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'How Long at Current Job', 'Missing', 98, 0.0, '2014-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 98, 1.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 98, 10.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 98, 19.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 98, 2.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 98, 5.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 98, 59.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 98, 3.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Accommodation and food services', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 98, 1.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Construction', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Education services', 98, 5.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Finance and insurance', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Health care and social assistance', 98, 6.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Information', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Management of Companies and Enterprises', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Manufacturing', 98, 10.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Mining', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Other services, except public administration', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Public administration', 98, 19.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Real estate and rental and leasing', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Retail trade', 98, 2.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Transportation and warehousing', 98, 53.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Unclassified', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Utilities', 98, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Wholesale trade', 98, 3.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 86.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 74.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 75.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.01', 'Total Completes for O*NET-SOC', NULL, 98, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'Data Collection Mode', 'Paper', 24, 70.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'Data Collection Mode', 'Web', 24, 29.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'How Long at Current Job', '1-5 Years', 24, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'How Long at Current Job', '10 Years or More', 24, 91.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'How Long at Current Job', '6-9 Years', 24, 8.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'How Long at Current Job', '<1 Year', 24, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'How Long at Current Job', 'Missing', 24, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 75.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.02', 'Total Completes for O*NET-SOC', NULL, 24, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'Data Collection Mode', 'Paper', 23, 39.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'Data Collection Mode', 'Web', 23, 60.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'How Long at Current Job', '1-5 Years', 23, 4.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'How Long at Current Job', '10 Years or More', 23, 87.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'How Long at Current Job', '6-9 Years', 23, 8.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'How Long at Current Job', '<1 Year', 23, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'How Long at Current Job', 'Missing', 23, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 82.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3071.03', 'Total Completes for O*NET-SOC', NULL, 23, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'Data Collection Mode', 'Paper', 21, 61.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'Data Collection Mode', 'Web', 21, 38.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'How Long at Current Job', '1-5 Years', 21, 4.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'How Long at Current Job', '10 Years or More', 21, 81.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'How Long at Current Job', '6-9 Years', 21, 14.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'How Long at Current Job', '<1 Year', 21, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'How Long at Current Job', 'Missing', 21, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 61.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 75.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3111.00', 'Total Completes for O*NET-SOC', NULL, 21, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'Data Collection Mode', 'Paper', 22, 72.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'Data Collection Mode', 'Web', 22, 27.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'How Long at Current Job', '1-5 Years', 22, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'How Long at Current Job', '10 Years or More', 22, 86.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'How Long at Current Job', '6-9 Years', 22, 13.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'How Long at Current Job', '<1 Year', 22, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'How Long at Current Job', 'Missing', 22, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 73.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 88.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3121.00', 'Total Completes for O*NET-SOC', NULL, 22, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'Data Collection Mode', 'Paper', 24, 91.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'Data Collection Mode', 'Web', 24, 8.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'How Long at Current Job', '1-5 Years', 24, 8.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'How Long at Current Job', '10 Years or More', 24, 75.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'How Long at Current Job', '6-9 Years', 24, 16.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'How Long at Current Job', '<1 Year', 24, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'How Long at Current Job', 'Missing', 24, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 77.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-3131.00', 'Total Completes for O*NET-SOC', NULL, 24, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'Data Collection Mode', 'Paper', 92, 85.9, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'Data Collection Mode', 'Web', 92, 14.1, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'How Long at Current Job', '1-5 Years', 92, 23.9, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'How Long at Current Job', '10 Years or More', 92, 58.7, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'How Long at Current Job', '6-9 Years', 92, 13.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'How Long at Current Job', '<1 Year', 92, 4.3, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'How Long at Current Job', 'Missing', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 92, 83.7, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 92, 8.7, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 92, 2.2, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 92, 5.4, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 90.2, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 66.2, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 69.1, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.01', 'Total Completes for O*NET-SOC', NULL, 92, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'Data Collection Mode', 'Paper', 70, 78.6, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'Data Collection Mode', 'Web', 70, 21.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'How Long at Current Job', '1-5 Years', 70, 7.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'How Long at Current Job', '10 Years or More', 70, 84.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'How Long at Current Job', '6-9 Years', 70, 8.6, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'How Long at Current Job', '<1 Year', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'How Long at Current Job', 'Missing', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 70, 100.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Accommodation and food services', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 70, 100.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 70, 0.0, '2014-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Construction', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Education services', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Finance and insurance', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Health care and social assistance', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Information', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Management of Companies and Enterprises', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Manufacturing', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Mining', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Other services, except public administration', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Public administration', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Real estate and rental and leasing', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Retail trade', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Transportation and warehousing', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Unclassified', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Utilities', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Wholesale trade', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 87.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 82.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 79.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.02', 'Total Completes for O*NET-SOC', NULL, 70, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'Data Collection Mode', 'Paper', 31, 100.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'Data Collection Mode', 'Web', 31, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'How Long at Current Job', '1-5 Years', 31, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'How Long at Current Job', '10 Years or More', 31, 71.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'How Long at Current Job', '6-9 Years', 31, 29.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'How Long at Current Job', '<1 Year', 31, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'How Long at Current Job', 'Missing', 31, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.2, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 81.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'O*NET-SOC Employee Response Rate', NULL, NULL, 87.2, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9013.03', 'Total Completes for O*NET-SOC', NULL, 31, NULL, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'Data Collection Mode', 'Paper', 25, 32.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'Data Collection Mode', 'Web', 25, 68.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'How Long at Current Job', '1-5 Years', 25, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'How Long at Current Job', '10 Years or More', 25, 92.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'How Long at Current Job', '6-9 Years', 25, 8.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'How Long at Current Job', '<1 Year', 25, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'How Long at Current Job', 'Missing', 25, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Construction', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Education services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Information', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Mining', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 86.2, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 82.9, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 93.6, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9021.00', 'Total Completes for O*NET-SOC', NULL, 25, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'Data Collection Mode', 'Paper', 67, 89.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'Data Collection Mode', 'Web', 67, 10.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '1-5 Years', 67, 32.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '10 Years or More', 67, 40.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '6-9 Years', 67, 20.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '<1 Year', 67, 6.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'How Long at Current Job', 'Missing', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 67, 0.0, '2010-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 67, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Accommodation and food services', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Construction', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Education services', 67, 25.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Finance and insurance', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Health care and social assistance', 67, 71.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Information', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Management of Companies and Enterprises', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Manufacturing', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Mining', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Other services, except public administration', 67, 3.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Public administration', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Real estate and rental and leasing', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Retail trade', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Transportation and warehousing', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Unclassified', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Utilities', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Wholesale trade', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 81.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 80.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 67.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9031.00', 'Total Completes for O*NET-SOC', NULL, 67, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'Data Collection Mode', 'Paper', 93, 69.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'Data Collection Mode', 'Web', 93, 30.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '1-5 Years', 93, 46.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '10 Years or More', 93, 25.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '6-9 Years', 93, 19.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '<1 Year', 93, 8.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'How Long at Current Job', 'Missing', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 93, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Accommodation and food services', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Construction', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Education services', 93, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Finance and insurance', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Health care and social assistance', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Information', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Management of Companies and Enterprises', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Manufacturing', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Mining', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Other services, except public administration', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Public administration', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Real estate and rental and leasing', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Retail trade', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Transportation and warehousing', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Unclassified', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Utilities', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Wholesale trade', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 82.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 70.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9032.00', 'Total Completes for O*NET-SOC', NULL, 93, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'Data Collection Mode', 'Paper', 102, 69.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'Data Collection Mode', 'Web', 102, 30.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '1-5 Years', 102, 40.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '10 Years or More', 102, 29.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '6-9 Years', 102, 22.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '<1 Year', 102, 7.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'How Long at Current Job', 'Missing', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 102, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Accommodation and food services', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Construction', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Education services', 102, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Finance and insurance', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Health care and social assistance', 102, 0.0, '2010-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Information', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Management of Companies and Enterprises', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Manufacturing', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Mining', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Other services, except public administration', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Public administration', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Real estate and rental and leasing', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Retail trade', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Transportation and warehousing', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Unclassified', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Utilities', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Wholesale trade', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 70.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 72.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9033.00', 'Total Completes for O*NET-SOC', NULL, 102, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'Data Collection Mode', 'Paper', 22, 22.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'Data Collection Mode', 'Web', 22, 77.3, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'How Long at Current Job', '1-5 Years', 22, 4.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'How Long at Current Job', '10 Years or More', 22, 54.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'How Long at Current Job', '6-9 Years', 22, 40.9, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'How Long at Current Job', '<1 Year', 22, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'How Long at Current Job', 'Missing', 22, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Construction', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Education services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Information', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Mining', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 88.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 71.4, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 89.3, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9039.01', 'Total Completes for O*NET-SOC', NULL, 22, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'Data Collection Mode', 'Paper', 127, 56.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'Data Collection Mode', 'Web', 127, 43.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '1-5 Years', 127, 44.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '10 Years or More', 127, 39.4, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '6-9 Years', 127, 8.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '<1 Year', 127, 6.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'How Long at Current Job', 'Missing', 127, 0.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 127, 77.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 127, 13.4, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 127, 7.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 127, 1.6, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Accommodation and food services', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Construction', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Education services', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Finance and insurance', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Health care and social assistance', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Information', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Management of Companies and Enterprises', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Manufacturing', 127, 77.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Mining', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Other services, except public administration', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 127, 7.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Public administration', 127, 13.4, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Real estate and rental and leasing', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Retail trade', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Transportation and warehousing', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Unclassified', 127, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Utilities', 127, 1.6, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Wholesale trade', 127, 0.0, '2012-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 94.1, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 69.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 58.5, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.00', 'Total Completes for O*NET-SOC', NULL, 127, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'Data Collection Mode', 'Paper', 100, 36.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'Data Collection Mode', 'Web', 100, 64.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'How Long at Current Job', '1-5 Years', 100, 52.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'How Long at Current Job', '10 Years or More', 100, 15.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'How Long at Current Job', '6-9 Years', 100, 18.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'How Long at Current Job', '<1 Year', 100, 15.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'How Long at Current Job', 'Missing', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 100, 4.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 100, 78.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 100, 3.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 100, 12.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 100, 3.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Accommodation and food services', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Construction', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Education services', 100, 1.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Finance and insurance', 100, 4.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Health care and social assistance', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Information', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Management of Companies and Enterprises', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Manufacturing', 100, 77.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Mining', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Other services, except public administration', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 100, 11.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Public administration', 100, 3.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Real estate and rental and leasing', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Retail trade', 100, 1.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Transportation and warehousing', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Unclassified', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Utilities', 100, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Wholesale trade', 100, 3.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 80.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 85.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9041.01', 'Total Completes for O*NET-SOC', NULL, 100, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'Data Collection Mode', 'Paper', 69, 89.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'Data Collection Mode', 'Web', 69, 10.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '1-5 Years', 69, 31.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '10 Years or More', 69, 49.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '6-9 Years', 69, 13.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '<1 Year', 69, 5.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'How Long at Current Job', 'Missing', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 69, 20.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 69, 62.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 69, 17.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Accommodation and food services', 69, 59.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Construction', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Education services', 69, 4.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Finance and insurance', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Health care and social assistance', 69, 10.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Information', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Management of Companies and Enterprises', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Manufacturing', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Mining', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Other services, except public administration', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Public administration', 69, 20.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Real estate and rental and leasing', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Retail trade', 69, 5.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Transportation and warehousing', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Unclassified', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Utilities', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Wholesale trade', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 84.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 62.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 61.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9051.00', 'Total Completes for O*NET-SOC', NULL, 69, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'Data Collection Mode', 'Paper', 56, 67.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'Data Collection Mode', 'Web', 56, 32.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'How Long at Current Job', '1-5 Years', 56, 23.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'How Long at Current Job', '10 Years or More', 56, 69.6, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'How Long at Current Job', '6-9 Years', 56, 7.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'How Long at Current Job', '<1 Year', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'How Long at Current Job', 'Missing', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 56, 0.0, '2014-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 56, 100.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Accommodation and food services', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Construction', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Education services', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Finance and insurance', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Health care and social assistance', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Information', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Management of Companies and Enterprises', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Manufacturing', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Mining', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Other services, except public administration', 56, 100.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Public administration', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Real estate and rental and leasing', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Retail trade', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Transportation and warehousing', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Unclassified', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Utilities', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Wholesale trade', 56, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 83.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 68.8, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9061.00', 'Total Completes for O*NET-SOC', NULL, 56, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'Data Collection Mode', 'Paper', 91, 61.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'Data Collection Mode', 'Web', 91, 38.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '1-5 Years', 91, 24.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '10 Years or More', 91, 48.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '6-9 Years', 91, 18.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '<1 Year', 91, 8.8, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'How Long at Current Job', 'Missing', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 91, 100.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Accommodation and food services', 91, 44.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 91, 56.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Construction', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Education services', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Finance and insurance', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Health care and social assistance', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Information', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Management of Companies and Enterprises', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Manufacturing', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Mining', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Other services, except public administration', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Public administration', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Real estate and rental and leasing', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Retail trade', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Transportation and warehousing', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Unclassified', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Utilities', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Wholesale trade', 91, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 95.8, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 58.6, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 53.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9071.00', 'Total Completes for O*NET-SOC', NULL, 91, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'Data Collection Mode', 'Paper', 61, 60.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'Data Collection Mode', 'Web', 61, 39.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '1-5 Years', 61, 32.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '10 Years or More', 61, 21.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '6-9 Years', 61, 16.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '<1 Year', 61, 26.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'How Long at Current Job', 'Missing', 61, 3.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 61, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Accommodation and food services', 61, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Construction', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Education services', 61, 0.0, '2010-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Finance and insurance', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Health care and social assistance', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Information', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Management of Companies and Enterprises', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Manufacturing', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Mining', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Other services, except public administration', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Public administration', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Real estate and rental and leasing', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Retail trade', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Transportation and warehousing', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Unclassified', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Utilities', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Wholesale trade', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 62.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 54.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9081.00', 'Total Completes for O*NET-SOC', NULL, 61, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'Data Collection Mode', 'Paper', 29, 86.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'Data Collection Mode', 'Web', 29, 13.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'How Long at Current Job', '1-5 Years', 29, 3.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'How Long at Current Job', '10 Years or More', 29, 89.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'How Long at Current Job', '6-9 Years', 29, 6.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'How Long at Current Job', '<1 Year', 29, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'How Long at Current Job', 'Missing', 29, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 83.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 93.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9111.00', 'Total Completes for O*NET-SOC', NULL, 29, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'Data Collection Mode', 'Paper', 70, 60.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'Data Collection Mode', 'Web', 70, 40.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '1-5 Years', 70, 30.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '10 Years or More', 70, 48.6, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '6-9 Years', 70, 15.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '<1 Year', 70, 5.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'How Long at Current Job', 'Missing', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 70, 8.6, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 70, 60.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 70, 14.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 70, 10.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 70, 7.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Accommodation and food services', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Construction', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Education services', 70, 11.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Finance and insurance', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Health care and social assistance', 70, 1.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Information', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Management of Companies and Enterprises', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Manufacturing', 70, 8.6, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Mining', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Other services, except public administration', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 70, 1.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Public administration', 70, 60.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Real estate and rental and leasing', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Retail trade', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Transportation and warehousing', 70, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Unclassified', 70, 0.0, '2014-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Utilities', 70, 10.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Wholesale trade', 70, 7.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 86.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 66.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 68.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.00', 'Total Completes for O*NET-SOC', NULL, 70, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'Data Collection Mode', 'Paper', 74, 70.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'Data Collection Mode', 'Web', 74, 29.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '1-5 Years', 74, 52.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '10 Years or More', 74, 17.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '6-9 Years', 74, 21.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '<1 Year', 74, 8.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'How Long at Current Job', 'Missing', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 74, 9.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 74, 90.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Accommodation and food services', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Construction', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Education services', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Finance and insurance', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Health care and social assistance', 74, 35.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Information', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Management of Companies and Enterprises', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Manufacturing', 74, 9.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Mining', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Other services, except public administration', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 74, 55.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Public administration', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Real estate and rental and leasing', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Retail trade', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Transportation and warehousing', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Unclassified', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Utilities', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Wholesale trade', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 66.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 75.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.01', 'Total Completes for O*NET-SOC', NULL, 74, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'Data Collection Mode', 'Paper', 29, 48.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'Data Collection Mode', 'Web', 29, 51.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'How Long at Current Job', '1-5 Years', 29, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'How Long at Current Job', '10 Years or More', 29, 100.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'How Long at Current Job', '6-9 Years', 29, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'How Long at Current Job', '<1 Year', 29, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'How Long at Current Job', 'Missing', 29, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Construction', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Education services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Information', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Mining', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Retail trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Unclassified', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Utilities', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.6, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 88.6, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 88.6, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9121.02', 'Total Completes for O*NET-SOC', NULL, 29, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'Data Collection Mode', 'Paper', 104, 87.5, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'Data Collection Mode', 'Web', 104, 12.5, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '1-5 Years', 104, 29.8, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '10 Years or More', 104, 42.3, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '6-9 Years', 104, 25.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '<1 Year', 104, 1.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'How Long at Current Job', 'Missing', 104, 1.9, '2005-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 104, 100.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 88.9, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 67.2, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 97.6, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9131.00', 'Total Completes for O*NET-SOC', NULL, 104, NULL, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'Data Collection Mode', 'Paper', 26, 38.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'Data Collection Mode', 'Web', 26, 61.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'How Long at Current Job', '1-5 Years', 26, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'How Long at Current Job', '10 Years or More', 26, 100.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'How Long at Current Job', '6-9 Years', 26, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'How Long at Current Job', '<1 Year', 26, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'How Long at Current Job', 'Missing', 26, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Construction', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Education services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Information', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Mining', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.3, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 57.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 87.1, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9141.00', 'Total Completes for O*NET-SOC', NULL, 26, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'Data Collection Mode', 'Paper', 73, 78.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'Data Collection Mode', 'Web', 73, 21.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '1-5 Years', 73, 37.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '10 Years or More', 73, 32.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '6-9 Years', 73, 13.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '<1 Year', 73, 15.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'How Long at Current Job', 'Missing', 73, 1.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 73, 17.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 73, 82.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Accommodation and food services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Construction', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Education services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Finance and insurance', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Health care and social assistance', 73, 71.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Information', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Management of Companies and Enterprises', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Manufacturing', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Mining', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Other services, except public administration', 73, 11.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Public administration', 73, 17.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Real estate and rental and leasing', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Retail trade', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Transportation and warehousing', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Unclassified', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Utilities', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Wholesale trade', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 88.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 72.2, '2009-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 77.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9151.00', 'Total Completes for O*NET-SOC', NULL, 73, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'Data Collection Mode', 'Paper', 27, 44.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'Data Collection Mode', 'Web', 27, 55.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'How Long at Current Job', '1-5 Years', 27, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'How Long at Current Job', '10 Years or More', 27, 81.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'How Long at Current Job', '6-9 Years', 27, 18.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'How Long at Current Job', '<1 Year', 27, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'How Long at Current Job', 'Missing', 27, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Construction', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Education services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Information', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Mining', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 87.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 96.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9161.00', 'Total Completes for O*NET-SOC', NULL, 27, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'Data Collection Mode', 'Paper', 33, 63.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'Data Collection Mode', 'Web', 33, 36.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'How Long at Current Job', '1-5 Years', 33, 6.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'How Long at Current Job', '10 Years or More', 33, 72.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'How Long at Current Job', '6-9 Years', 33, 21.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'How Long at Current Job', '<1 Year', 33, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'How Long at Current Job', 'Missing', 33, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 97.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 94.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 97.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.01', 'Total Completes for O*NET-SOC', NULL, 33, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'Data Collection Mode', 'Paper', 57, 64.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'Data Collection Mode', 'Web', 57, 35.1, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'How Long at Current Job', '1-5 Years', 57, 43.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'How Long at Current Job', '10 Years or More', 57, 29.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'How Long at Current Job', '6-9 Years', 57, 19.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'How Long at Current Job', '<1 Year', 57, 7.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'How Long at Current Job', 'Missing', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 57, 29.8, '2012-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 57, 24.6, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 57, 14.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 57, 29.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 57, 1.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Accommodation and food services', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 57, 1.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Construction', 57, 1.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Education services', 57, 1.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Finance and insurance', 57, 31.6, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Health care and social assistance', 57, 15.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Information', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Management of Companies and Enterprises', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Manufacturing', 57, 14.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Mining', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Other services, except public administration', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 57, 5.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Public administration', 57, 12.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Real estate and rental and leasing', 57, 8.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Retail trade', 57, 3.5, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Transportation and warehousing', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Unclassified', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Utilities', 57, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Wholesale trade', 57, 3.5, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.4, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 73.5, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 75.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.02', 'Total Completes for O*NET-SOC', NULL, 57, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'Data Collection Mode', 'Paper', 81, 56.8, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'Data Collection Mode', 'Web', 81, 43.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'How Long at Current Job', '1-5 Years', 81, 25.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'How Long at Current Job', '10 Years or More', 81, 46.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'How Long at Current Job', '6-9 Years', 81, 22.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'How Long at Current Job', '<1 Year', 81, 3.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'How Long at Current Job', 'Missing', 81, 1.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 81, 100.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Accommodation and food services', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Arts, entertainment, and recreation', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Construction', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Education services', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Finance and insurance', 81, 100.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Health care and social assistance', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Information', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Management of Companies and Enterprises', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Manufacturing', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Mining', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Other services, except public administration', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Professional, Scientific and Technical Services', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Public administration', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Real estate and rental and leasing', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Retail trade', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Transportation and warehousing', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Unclassified', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Utilities', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Wholesale trade', 81, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 95.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'O*NET-SOC Employee Response Rate', NULL, NULL, 66.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 46.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.03', 'Total Completes for O*NET-SOC', NULL, 81, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'Data Collection Mode', 'Paper', 27, 40.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'Data Collection Mode', 'Web', 27, 59.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'How Long at Current Job', '1-5 Years', 27, 3.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'How Long at Current Job', '10 Years or More', 27, 88.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'How Long at Current Job', '6-9 Years', 27, 7.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'How Long at Current Job', '<1 Year', 27, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'How Long at Current Job', 'Missing', 27, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Construction', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Education services', NULL, NULL, '2010-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Information', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Mining', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Retail trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Unclassified', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Utilities', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 76.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'O*NET-SOC Employee Response Rate', NULL, NULL, 90.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.04', 'Total Completes for O*NET-SOC', NULL, 27, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'Data Collection Mode', 'Paper', 20, 45.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'Data Collection Mode', 'Web', 20, 55.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'How Long at Current Job', '1-5 Years', 20, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'How Long at Current Job', '10 Years or More', 20, 90.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'How Long at Current Job', '6-9 Years', 20, 10.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'How Long at Current Job', '<1 Year', 20, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'How Long at Current Job', 'Missing', 20, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Construction', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Education services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Information', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Mining', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Retail trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Unclassified', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Utilities', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 87.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 67.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'O*NET-SOC Employee Response Rate', NULL, NULL, 100.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.07', 'Total Completes for O*NET-SOC', NULL, 20, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'Data Collection Mode', 'Paper', 25, 32.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'Data Collection Mode', 'Web', 25, 68.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'How Long at Current Job', '1-5 Years', 25, 4.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'How Long at Current Job', '10 Years or More', 25, 92.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'How Long at Current Job', '6-9 Years', 25, 4.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'How Long at Current Job', '<1 Year', 25, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'How Long at Current Job', 'Missing', 25, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Construction', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Education services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Information', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Mining', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Retail trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2012-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Unclassified', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Utilities', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 89.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 70.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'O*NET-SOC Employee Response Rate', NULL, NULL, 93.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.08', 'Total Completes for O*NET-SOC', NULL, 25, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'Data Collection Mode', 'Paper', 25, 48.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'Data Collection Mode', 'Web', 25, 52.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'How Long at Current Job', '1-5 Years', 25, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'How Long at Current Job', '10 Years or More', 25, 84.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'How Long at Current Job', '6-9 Years', 25, 16.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'How Long at Current Job', '<1 Year', 25, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'How Long at Current Job', 'Missing', 25, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Construction', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Education services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Information', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Mining', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Retail trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Unclassified', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Utilities', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 84.9, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'O*NET-SOC Employee Response Rate', NULL, NULL, 86.2, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('11-9199.11', 'Total Completes for O*NET-SOC', NULL, 25, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'Data Collection Mode', 'Paper', 136, 80.9, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'Data Collection Mode', 'Web', 136, 19.1, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '1-5 Years', 136, 26.5, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '10 Years or More', 136, 48.5, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '6-9 Years', 136, 15.4, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '<1 Year', 136, 7.4, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'How Long at Current Job', 'Missing', 136, 2.2, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 136, 100.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.3, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 54.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 70.4, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1011.00', 'Total Completes for O*NET-SOC', NULL, 136, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'Data Collection Mode', 'Paper', 71, 67.6, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'Data Collection Mode', 'Web', 71, 32.4, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '1-5 Years', 71, 28.2, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '10 Years or More', 71, 39.4, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '6-9 Years', 71, 19.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '<1 Year', 71, 12.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'How Long at Current Job', 'Missing', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 71, 22.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 71, 77.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Accommodation and food services', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Construction', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Education services', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Finance and insurance', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Health care and social assistance', 71, 0.0, '2013-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Information', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Manufacturing', 71, 22.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Mining', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Other services, except public administration', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Public administration', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Real estate and rental and leasing', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Retail trade', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Transportation and warehousing', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Unclassified', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Utilities', 71, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Wholesale trade', 71, 77.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 94.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 70.8, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 85.9, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1021.00', 'Total Completes for O*NET-SOC', NULL, 71, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'Data Collection Mode', 'Paper', 73, 87.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'Data Collection Mode', 'Web', 73, 12.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '1-5 Years', 73, 31.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '10 Years or More', 73, 41.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '6-9 Years', 73, 12.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '<1 Year', 73, 15.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'How Long at Current Job', 'Missing', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 73, 41.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 73, 58.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Accommodation and food services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Construction', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Education services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Finance and insurance', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Health care and social assistance', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Information', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Management of Companies and Enterprises', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Manufacturing', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Mining', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Other services, except public administration', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Public administration', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Real estate and rental and leasing', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Retail trade', 73, 38.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Transportation and warehousing', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Unclassified', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Utilities', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Wholesale trade', 73, 61.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 81.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 60.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1022.00', 'Total Completes for O*NET-SOC', NULL, 73, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'Data Collection Mode', 'Paper', 21, 57.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'Data Collection Mode', 'Web', 21, 42.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'How Long at Current Job', '1-5 Years', 21, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'How Long at Current Job', '10 Years or More', 21, 61.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'How Long at Current Job', '6-9 Years', 21, 28.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'How Long at Current Job', '<1 Year', 21, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'How Long at Current Job', 'Missing', 21, 9.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 95.5, '2011-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 61.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 91.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1023.00', 'Total Completes for O*NET-SOC', NULL, 21, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'Data Collection Mode', 'Paper', 64, 81.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'Data Collection Mode', 'Web', 64, 18.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'How Long at Current Job', '1-5 Years', 64, 39.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'How Long at Current Job', '10 Years or More', 64, 35.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'How Long at Current Job', '6-9 Years', 64, 20.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'How Long at Current Job', '<1 Year', 64, 4.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'How Long at Current Job', 'Missing', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 64, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Accommodation and food services', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Construction', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Education services', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Finance and insurance', 64, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Health care and social assistance', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Information', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Management of Companies and Enterprises', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Manufacturing', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Mining', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Other services, except public administration', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Public administration', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Real estate and rental and leasing', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Retail trade', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Transportation and warehousing', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Unclassified', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Utilities', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Wholesale trade', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 95.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 78.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 52.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.01', 'Total Completes for O*NET-SOC', NULL, 64, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'Data Collection Mode', 'Paper', 99, 75.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'Data Collection Mode', 'Web', 99, 24.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'How Long at Current Job', '1-5 Years', 99, 19.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'How Long at Current Job', '10 Years or More', 99, 56.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'How Long at Current Job', '6-9 Years', 99, 20.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'How Long at Current Job', '<1 Year', 99, 4.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'How Long at Current Job', 'Missing', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 99, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Accommodation and food services', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Construction', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Education services', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Finance and insurance', 99, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Health care and social assistance', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Information', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Management of Companies and Enterprises', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Manufacturing', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Mining', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Other services, except public administration', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Public administration', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Real estate and rental and leasing', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Retail trade', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Transportation and warehousing', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Unclassified', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Utilities', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Wholesale trade', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 94.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 71.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 46.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1031.02', 'Total Completes for O*NET-SOC', NULL, 99, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'Data Collection Mode', 'Paper', 114, 92.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'Data Collection Mode', 'Web', 114, 7.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '1-5 Years', 114, 31.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '10 Years or More', 114, 43.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '6-9 Years', 114, 18.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '<1 Year', 114, 7.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'How Long at Current Job', 'Missing', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 114, 99.1, '2005-12-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 114, 0.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 97.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 70.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 60.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1032.00', 'Total Completes for O*NET-SOC', NULL, 114, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'Data Collection Mode', 'Paper', 21, 28.6, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'Data Collection Mode', 'Web', 21, 71.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'How Long at Current Job', '1-5 Years', 21, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'How Long at Current Job', '10 Years or More', 21, 90.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'How Long at Current Job', '6-9 Years', 21, 9.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'How Long at Current Job', '<1 Year', 21, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'How Long at Current Job', 'Missing', 21, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Construction', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Education services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Information', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Mining', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 72.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 95.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.01', 'Total Completes for O*NET-SOC', NULL, 21, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'Data Collection Mode', 'Paper', 144, 91.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'Data Collection Mode', 'Web', 144, 9.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'How Long at Current Job', '1-5 Years', 144, 29.9, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'How Long at Current Job', '10 Years or More', 144, 47.2, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'How Long at Current Job', '6-9 Years', 144, 19.4, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'How Long at Current Job', '<1 Year', 144, 2.8, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'How Long at Current Job', 'Missing', 144, 0.7, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 144, 100.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 92.9, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 68.9, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 90.6, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.02', 'Total Completes for O*NET-SOC', NULL, 144, NULL, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'Data Collection Mode', 'Paper', 91, 78.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'Data Collection Mode', 'Web', 91, 22.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '1-5 Years', 91, 36.3, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '10 Years or More', 91, 42.8, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '6-9 Years', 91, 15.4, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '<1 Year', 91, 2.2, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'How Long at Current Job', 'Missing', 91, 3.3, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 91, 81.3, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 91, 18.7, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.8, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'O*NET-SOC Employee Response Rate', NULL, NULL, 53.6, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 86.9, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.03', 'Total Completes for O*NET-SOC', NULL, 91, NULL, '2006-12-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'Data Collection Mode', 'Paper', 75, 84.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'Data Collection Mode', 'Web', 75, 16.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '1-5 Years', 75, 26.7, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '10 Years or More', 75, 34.7, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '6-9 Years', 75, 29.3, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '<1 Year', 75, 9.3, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'How Long at Current Job', 'Missing', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 75, 100.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 88.2, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'O*NET-SOC Employee Response Rate', NULL, NULL, 66.9, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 96.8, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.04', 'Total Completes for O*NET-SOC', NULL, 75, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'Data Collection Mode', 'Paper', 31, 87.1, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'Data Collection Mode', 'Web', 31, 12.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'How Long at Current Job', '1-5 Years', 31, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'How Long at Current Job', '10 Years or More', 31, 100.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'How Long at Current Job', '6-9 Years', 31, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'How Long at Current Job', '<1 Year', 31, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'How Long at Current Job', 'Missing', 31, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Construction', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Education services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Information', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Mining', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Retail trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Unclassified', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Utilities', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 84.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'O*NET-SOC Employee Response Rate', NULL, NULL, 94.1, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.06', 'Total Completes for O*NET-SOC', NULL, 31, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'Data Collection Mode', 'Paper', 33, 60.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'Data Collection Mode', 'Web', 33, 39.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'How Long at Current Job', '1-5 Years', 33, 6.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'How Long at Current Job', '10 Years or More', 33, 27.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'How Long at Current Job', '6-9 Years', 33, 63.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'How Long at Current Job', '<1 Year', 33, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'How Long at Current Job', 'Missing', 33, 3.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 97.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'O*NET-SOC Employee Response Rate', NULL, NULL, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1041.07', 'Total Completes for O*NET-SOC', NULL, 33, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'Data Collection Mode', 'Paper', 28, 67.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'Data Collection Mode', 'Web', 28, 32.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'How Long at Current Job', '1-5 Years', 28, 3.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'How Long at Current Job', '10 Years or More', 28, 82.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'How Long at Current Job', '6-9 Years', 28, 14.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'How Long at Current Job', '<1 Year', 28, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'How Long at Current Job', 'Missing', 28, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 81.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 90.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1051.00', 'Total Completes for O*NET-SOC', NULL, 28, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'Data Collection Mode', 'Paper', 124, 62.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'Data Collection Mode', 'Web', 124, 37.1, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'How Long at Current Job', '1-5 Years', 124, 38.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'How Long at Current Job', '10 Years or More', 124, 37.1, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'How Long at Current Job', '6-9 Years', 124, 13.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'How Long at Current Job', '<1 Year', 124, 9.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'How Long at Current Job', 'Missing', 124, 0.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 124, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 124, 4.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 124, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 124, 20.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 124, 0.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 124, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 124, 8.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 124, 13.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 124, 46.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 124, 0.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 124, 4.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Accommodation and food services', 124, 3.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 124, 3.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 124, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 124, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Construction', 124, 4.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Education services', 124, 11.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Finance and insurance', 124, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Health care and social assistance', 124, 16.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Information', 124, 4.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Management of Companies and Enterprises', 124, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Manufacturing', 124, 16.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Mining', 124, 0.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Other services, except public administration', 124, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 124, 11.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Public administration', 124, 8.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Real estate and rental and leasing', 124, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Retail trade', 124, 12.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Transportation and warehousing', 124, 0.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Unclassified', 124, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Utilities', 124, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Wholesale trade', 124, 4.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 83.1, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 59.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1071.00', 'Total Completes for O*NET-SOC', NULL, 124, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'Data Collection Mode', 'Paper', 57, 87.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'Data Collection Mode', 'Web', 57, 12.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '1-5 Years', 57, 15.8, '2008-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '10 Years or More', 57, 70.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '6-9 Years', 57, 10.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '<1 Year', 57, 3.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'How Long at Current Job', 'Missing', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 57, 98.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 57, 1.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 75.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 59.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 73.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1074.00', 'Total Completes for O*NET-SOC', NULL, 57, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'Data Collection Mode', 'Paper', 82, 69.5, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'Data Collection Mode', 'Web', 82, 30.5, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'How Long at Current Job', '1-5 Years', 82, 35.4, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'How Long at Current Job', '10 Years or More', 82, 31.7, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'How Long at Current Job', '6-9 Years', 82, 15.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'How Long at Current Job', '<1 Year', 82, 11.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'How Long at Current Job', 'Missing', 82, 6.1, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 82, 17.1, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 82, 65.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 82, 4.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 82, 12.2, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 90.1, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 75.2, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 60.6, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.00', 'Total Completes for O*NET-SOC', NULL, 82, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'Data Collection Mode', 'Paper', 22, 54.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'Data Collection Mode', 'Web', 22, 45.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'How Long at Current Job', '1-5 Years', 22, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'How Long at Current Job', '10 Years or More', 22, 90.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'How Long at Current Job', '6-9 Years', 22, 9.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'How Long at Current Job', '<1 Year', 22, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'How Long at Current Job', 'Missing', 22, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 80.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.01', 'Total Completes for O*NET-SOC', NULL, 22, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'Data Collection Mode', 'Paper', 26, 50.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'Data Collection Mode', 'Web', 26, 50.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'How Long at Current Job', '1-5 Years', 26, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'How Long at Current Job', '10 Years or More', 26, 80.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'How Long at Current Job', '6-9 Years', 26, 15.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'How Long at Current Job', '<1 Year', 26, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'How Long at Current Job', 'Missing', 26, 3.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 89.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 65.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 85.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1081.02', 'Total Completes for O*NET-SOC', NULL, 26, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'Data Collection Mode', 'Paper', 81, 71.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'Data Collection Mode', 'Web', 81, 28.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'How Long at Current Job', '1-5 Years', 81, 39.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'How Long at Current Job', '10 Years or More', 81, 33.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'How Long at Current Job', '6-9 Years', 81, 18.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'How Long at Current Job', '<1 Year', 81, 7.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'How Long at Current Job', 'Missing', 81, 1.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 81, 3.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 81, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 81, 16.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 81, 4.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 81, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 81, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 81, 43.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 81, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 81, 29.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 81, 2.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 81, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 81.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 60.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 67.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1111.00', 'Total Completes for O*NET-SOC', NULL, 81, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'Data Collection Mode', 'Paper', 72, 65.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'Data Collection Mode', 'Web', 72, 34.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '1-5 Years', 72, 30.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '10 Years or More', 72, 19.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '6-9 Years', 72, 23.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '<1 Year', 72, 26.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'How Long at Current Job', 'Missing', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 72, 1.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 72, 5.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 72, 1.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 72, 90.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 72, 1.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Accommodation and food services', 72, 56.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 72, 5.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Construction', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Education services', 72, 20.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Finance and insurance', 72, 1.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Health care and social assistance', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Information', 72, 2.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Management of Companies and Enterprises', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Manufacturing', 72, 4.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Mining', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Other services, except public administration', 72, 1.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 72, 6.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Public administration', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Real estate and rental and leasing', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Retail trade', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Transportation and warehousing', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Unclassified', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Utilities', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Wholesale trade', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 62.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 63.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1121.00', 'Total Completes for O*NET-SOC', NULL, 72, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'Data Collection Mode', 'Paper', 32, 46.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'Data Collection Mode', 'Web', 32, 53.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'How Long at Current Job', '1-5 Years', 32, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'How Long at Current Job', '10 Years or More', 32, 87.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'How Long at Current Job', '6-9 Years', 32, 12.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'How Long at Current Job', '<1 Year', 32, 0.0, '2014-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'How Long at Current Job', 'Missing', 32, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Construction', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Education services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Information', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Mining', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 97.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 89.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 97.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1131.00', 'Total Completes for O*NET-SOC', NULL, 32, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'Data Collection Mode', 'Paper', 20, 70.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'Data Collection Mode', 'Web', 20, 30.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'How Long at Current Job', '1-5 Years', 20, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'How Long at Current Job', '10 Years or More', 20, 65.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'How Long at Current Job', '6-9 Years', 20, 35.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'How Long at Current Job', '<1 Year', 20, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'How Long at Current Job', 'Missing', 20, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 60.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 83.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1141.00', 'Total Completes for O*NET-SOC', NULL, 20, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'Data Collection Mode', 'Paper', 36, 38.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'Data Collection Mode', 'Web', 36, 61.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'How Long at Current Job', '1-5 Years', 36, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'How Long at Current Job', '10 Years or More', 36, 97.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'How Long at Current Job', '6-9 Years', 36, 2.8, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'How Long at Current Job', '<1 Year', 36, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'How Long at Current Job', 'Missing', 36, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2014-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Construction', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Education services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Information', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Mining', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 92.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 100.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1151.00', 'Total Completes for O*NET-SOC', NULL, 36, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'Data Collection Mode', 'Paper', 24, 45.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'Data Collection Mode', 'Web', 24, 54.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'How Long at Current Job', '1-5 Years', 24, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'How Long at Current Job', '10 Years or More', 24, 79.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'How Long at Current Job', '6-9 Years', 24, 16.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'How Long at Current Job', '<1 Year', 24, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'How Long at Current Job', 'Missing', 24, 4.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 75.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1161.00', 'Total Completes for O*NET-SOC', NULL, 24, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'Data Collection Mode', 'Paper', 25, 76.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'Data Collection Mode', 'Web', 25, 24.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'How Long at Current Job', '1-5 Years', 25, 16.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'How Long at Current Job', '10 Years or More', 25, 56.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'How Long at Current Job', '6-9 Years', 25, 28.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'How Long at Current Job', '<1 Year', 25, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'How Long at Current Job', 'Missing', 25, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 92.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 77.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 93.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.01', 'Total Completes for O*NET-SOC', NULL, 25, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'Data Collection Mode', 'Paper', 26, 30.8, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'Data Collection Mode', 'Web', 26, 69.2, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'How Long at Current Job', '1-5 Years', 26, 3.8, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'How Long at Current Job', '10 Years or More', 26, 88.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'How Long at Current Job', '6-9 Years', 26, 7.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'How Long at Current Job', '<1 Year', 26, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'How Long at Current Job', 'Missing', 26, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Construction', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Education services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Information', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Mining', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Retail trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Unclassified', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Utilities', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 92.9, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 75.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 87.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.02', 'Total Completes for O*NET-SOC', NULL, 26, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'Data Collection Mode', 'Paper', 28, 57.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'Data Collection Mode', 'Web', 28, 42.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'How Long at Current Job', '1-5 Years', 28, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'How Long at Current Job', '10 Years or More', 28, 92.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'How Long at Current Job', '6-9 Years', 28, 3.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'How Long at Current Job', '<1 Year', 28, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'How Long at Current Job', 'Missing', 28, 3.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 87.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 69.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'O*NET-SOC Employee Response Rate', NULL, NULL, 88.9, '2011-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.03', 'Total Completes for O*NET-SOC', NULL, 28, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'Data Collection Mode', 'Paper', 30, 36.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'Data Collection Mode', 'Web', 30, 63.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'How Long at Current Job', '1-5 Years', 30, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'How Long at Current Job', '10 Years or More', 30, 83.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'How Long at Current Job', '6-9 Years', 30, 16.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'How Long at Current Job', '<1 Year', 30, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'How Long at Current Job', 'Missing', 30, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 90.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'O*NET-SOC Employee Response Rate', NULL, NULL, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.04', 'Total Completes for O*NET-SOC', NULL, 30, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'Data Collection Mode', 'Paper', 28, 53.6, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'Data Collection Mode', 'Web', 28, 46.4, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'How Long at Current Job', '1-5 Years', 28, 17.9, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'How Long at Current Job', '10 Years or More', 28, 35.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'How Long at Current Job', '6-9 Years', 28, 46.4, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'How Long at Current Job', '<1 Year', 28, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'How Long at Current Job', 'Missing', 28, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Construction', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Education services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Information', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Mining', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Retail trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Unclassified', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Utilities', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.3, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 75.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'O*NET-SOC Employee Response Rate', NULL, NULL, 90.9, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.05', 'Total Completes for O*NET-SOC', NULL, 28, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'Data Collection Mode', 'Paper', 75, 42.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'Data Collection Mode', 'Web', 75, 57.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'How Long at Current Job', '1-5 Years', 75, 44.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'How Long at Current Job', '10 Years or More', 75, 26.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'How Long at Current Job', '6-9 Years', 75, 20.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'How Long at Current Job', '<1 Year', 75, 9.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'How Long at Current Job', 'Missing', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 75, 4.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 75, 0.0, '2014-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 75, 84.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 75, 8.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 75, 4.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Accommodation and food services', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 75, 5.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Arts, entertainment, and recreation', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Construction', 75, 4.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Education services', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Finance and insurance', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Health care and social assistance', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Information', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Management of Companies and Enterprises', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Manufacturing', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Mining', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Other services, except public administration', 75, 2.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Professional, Scientific and Technical Services', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Public administration', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Real estate and rental and leasing', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Retail trade', 75, 88.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Transportation and warehousing', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Unclassified', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Utilities', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Wholesale trade', 75, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 84.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'O*NET-SOC Employee Response Rate', NULL, NULL, 65.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 56.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-1199.06', 'Total Completes for O*NET-SOC', NULL, 75, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'Data Collection Mode', 'Paper', 192, 73.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'Data Collection Mode', 'Web', 192, 26.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'How Long at Current Job', '1-5 Years', 192, 34.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'How Long at Current Job', '10 Years or More', 192, 42.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'How Long at Current Job', '6-9 Years', 192, 15.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'How Long at Current Job', '<1 Year', 192, 7.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'How Long at Current Job', 'Missing', 192, 0.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 192, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 192, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 192, 2.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 192, 25.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 192, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 192, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 192, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 192, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 192, 62.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 192, 5.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 192, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Accommodation and food services', 192, 2.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 192, 2.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 192, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 192, 3.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Construction', 192, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Education services', 192, 9.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Finance and insurance', 192, 2.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Health care and social assistance', 192, 8.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Information', 192, 3.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Management of Companies and Enterprises', 192, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Manufacturing', 192, 22.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Mining', 192, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Other services, except public administration', 192, 0.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 192, 35.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Public administration', 192, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Real estate and rental and leasing', 192, 0.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Retail trade', 192, 0.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Transportation and warehousing', 192, 0.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Unclassified', 192, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Utilities', 192, 3.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Wholesale trade', 192, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 75.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 67.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.01', 'Total Completes for O*NET-SOC', NULL, 192, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'Data Collection Mode', 'Paper', 25, 76.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'Data Collection Mode', 'Web', 25, 24.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'How Long at Current Job', '1-5 Years', 25, 8.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'How Long at Current Job', '10 Years or More', 25, 88.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'How Long at Current Job', '6-9 Years', 25, 4.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'How Long at Current Job', '<1 Year', 25, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'How Long at Current Job', 'Missing', 25, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 72.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 78.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2011.02', 'Total Completes for O*NET-SOC', NULL, 25, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'Data Collection Mode', 'Paper', 79, 72.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'Data Collection Mode', 'Web', 79, 27.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'How Long at Current Job', '1-5 Years', 79, 34.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'How Long at Current Job', '10 Years or More', 79, 48.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'How Long at Current Job', '6-9 Years', 79, 13.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'How Long at Current Job', '<1 Year', 79, 2.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'How Long at Current Job', 'Missing', 79, 1.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 79, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Accommodation and food services', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Construction', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Education services', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Finance and insurance', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Health care and social assistance', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Information', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Management of Companies and Enterprises', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Manufacturing', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Mining', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Other services, except public administration', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Public administration', 79, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Real estate and rental and leasing', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Retail trade', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Transportation and warehousing', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Unclassified', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Utilities', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Wholesale trade', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 95.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 76.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 80.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.01', 'Total Completes for O*NET-SOC', NULL, 79, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'Data Collection Mode', 'Paper', 20, 45.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'Data Collection Mode', 'Web', 20, 55.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'How Long at Current Job', '1-5 Years', 20, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'How Long at Current Job', '10 Years or More', 20, 100.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'How Long at Current Job', '6-9 Years', 20, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'How Long at Current Job', '<1 Year', 20, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'How Long at Current Job', 'Missing', 20, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Construction', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Education services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Information', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Mining', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Public administration', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Retail trade', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Unclassified', NULL, NULL, '2014-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Utilities', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 90.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 57.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 84.6, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2021.02', 'Total Completes for O*NET-SOC', NULL, 20, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'Data Collection Mode', 'Paper', 114, 64.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'Data Collection Mode', 'Web', 114, 35.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '1-5 Years', 114, 44.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '10 Years or More', 114, 27.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '6-9 Years', 114, 16.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '<1 Year', 114, 11.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'How Long at Current Job', 'Missing', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 114, 5.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 114, 8.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 114, 63.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 114, 18.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 114, 4.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Accommodation and food services', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Construction', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Education services', 114, 15.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Finance and insurance', 114, 5.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Health care and social assistance', 114, 0.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Information', 114, 2.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Management of Companies and Enterprises', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Manufacturing', 114, 7.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Mining', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Other services, except public administration', 114, 1.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Public administration', 114, 63.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Real estate and rental and leasing', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Retail trade', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Transportation and warehousing', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Unclassified', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Utilities', 114, 2.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Wholesale trade', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 67.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 73.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2031.00', 'Total Completes for O*NET-SOC', NULL, 114, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'Data Collection Mode', 'Paper', 30, 60.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'Data Collection Mode', 'Web', 30, 40.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'How Long at Current Job', '1-5 Years', 30, 6.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'How Long at Current Job', '10 Years or More', 30, 73.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'How Long at Current Job', '6-9 Years', 30, 20.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'How Long at Current Job', '<1 Year', 30, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'How Long at Current Job', 'Missing', 30, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 62.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 96.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2041.00', 'Total Completes for O*NET-SOC', NULL, 30, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'Data Collection Mode', 'Paper', 87, 59.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'Data Collection Mode', 'Web', 87, 40.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'How Long at Current Job', '1-5 Years', 87, 57.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'How Long at Current Job', '10 Years or More', 87, 13.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'How Long at Current Job', '6-9 Years', 87, 16.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'How Long at Current Job', '<1 Year', 87, 11.5, '2005-12-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'How Long at Current Job', 'Missing', 87, 1.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 87, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 87, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 87, 67.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 87, 13.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 87, 2.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 87, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 87, 4.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 87, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 87, 10.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 87, 1.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 87, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 80.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 60.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 50.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2051.00', 'Total Completes for O*NET-SOC', NULL, 87, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'Data Collection Mode', 'Paper', 28, 64.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'Data Collection Mode', 'Web', 28, 35.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'How Long at Current Job', '1-5 Years', 28, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'How Long at Current Job', '10 Years or More', 28, 96.4, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'How Long at Current Job', '6-9 Years', 28, 3.6, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'How Long at Current Job', '<1 Year', 28, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'How Long at Current Job', 'Missing', 28, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Construction', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Education services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Information', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Mining', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 71.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 90.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2052.00', 'Total Completes for O*NET-SOC', NULL, 28, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'Data Collection Mode', 'Paper', 26, 65.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'Data Collection Mode', 'Web', 26, 34.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'How Long at Current Job', '1-5 Years', 26, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'How Long at Current Job', '10 Years or More', 26, 80.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'How Long at Current Job', '6-9 Years', 26, 19.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'How Long at Current Job', '<1 Year', 26, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'How Long at Current Job', 'Missing', 26, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.3, '2009-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 61.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 90.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2053.00', 'Total Completes for O*NET-SOC', NULL, 26, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'Data Collection Mode', 'Paper', 25, 40.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'Data Collection Mode', 'Web', 25, 60.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'How Long at Current Job', '1-5 Years', 25, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'How Long at Current Job', '10 Years or More', 25, 92.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'How Long at Current Job', '6-9 Years', 25, 8.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'How Long at Current Job', '<1 Year', 25, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'How Long at Current Job', 'Missing', 25, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Construction', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Education services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Information', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Mining', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 61.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2061.00', 'Total Completes for O*NET-SOC', NULL, 25, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'Data Collection Mode', 'Paper', 33, 54.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'Data Collection Mode', 'Web', 33, 45.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'How Long at Current Job', '1-5 Years', 33, 3.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'How Long at Current Job', '10 Years or More', 33, 66.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'How Long at Current Job', '6-9 Years', 33, 30.3, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'How Long at Current Job', '<1 Year', 33, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'How Long at Current Job', 'Missing', 33, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Construction', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Education services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Information', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Mining', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 94.3, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 97.1, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.00', 'Total Completes for O*NET-SOC', NULL, 33, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'Data Collection Mode', 'Paper', 64, 75.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'Data Collection Mode', 'Web', 64, 25.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'How Long at Current Job', '1-5 Years', 64, 50.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'How Long at Current Job', '10 Years or More', 64, 20.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'How Long at Current Job', '6-9 Years', 64, 7.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'How Long at Current Job', '<1 Year', 64, 20.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'How Long at Current Job', 'Missing', 64, 1.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 64, 0.0, '2005-12-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 64, 34.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 64, 10.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 64, 54.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 94.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 60.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 55.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2071.01', 'Total Completes for O*NET-SOC', NULL, 64, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'Data Collection Mode', 'Paper', 108, 86.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'Data Collection Mode', 'Web', 108, 13.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '1-5 Years', 108, 37.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '10 Years or More', 108, 37.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '6-9 Years', 108, 19.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '<1 Year', 108, 5.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'How Long at Current Job', 'Missing', 108, 0.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 108, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Accommodation and food services', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Construction', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Education services', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Finance and insurance', 108, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Health care and social assistance', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Information', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Management of Companies and Enterprises', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Manufacturing', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Mining', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Other services, except public administration', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Public administration', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Real estate and rental and leasing', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Retail trade', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Transportation and warehousing', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Unclassified', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Utilities', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Wholesale trade', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 95.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 68.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 63.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2072.00', 'Total Completes for O*NET-SOC', NULL, 108, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'Data Collection Mode', 'Paper', 111, 82.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'Data Collection Mode', 'Web', 111, 18.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '1-5 Years', 111, 35.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '10 Years or More', 111, 44.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '6-9 Years', 111, 15.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '<1 Year', 111, 5.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'How Long at Current Job', 'Missing', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 111, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Accommodation and food services', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Construction', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Education services', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Finance and insurance', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Health care and social assistance', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Information', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Management of Companies and Enterprises', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Manufacturing', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Mining', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Other services, except public administration', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Public administration', 111, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Real estate and rental and leasing', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Retail trade', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Transportation and warehousing', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Unclassified', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Utilities', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Wholesale trade', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 85.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 73.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 74.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2081.00', 'Total Completes for O*NET-SOC', NULL, 111, NULL, '2011-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'Data Collection Mode', 'Paper', 20, 50.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'Data Collection Mode', 'Web', 20, 50.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'How Long at Current Job', '1-5 Years', 20, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'How Long at Current Job', '10 Years or More', 20, 90.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'How Long at Current Job', '6-9 Years', 20, 10.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'How Long at Current Job', '<1 Year', 20, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'How Long at Current Job', 'Missing', 20, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Construction', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Education services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Information', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Mining', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 90.9, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 57.9, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 81.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2082.00', 'Total Completes for O*NET-SOC', NULL, 20, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'Data Collection Mode', 'Paper', 47, 36.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'Data Collection Mode', 'Web', 47, 63.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'How Long at Current Job', '1-5 Years', 47, 2.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'How Long at Current Job', '10 Years or More', 47, 66.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'How Long at Current Job', '6-9 Years', 47, 27.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'How Long at Current Job', '<1 Year', 47, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'How Long at Current Job', 'Missing', 47, 4.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 94.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 59.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 89.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.02', 'Total Completes for O*NET-SOC', NULL, 47, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'Data Collection Mode', 'Paper', 32, 56.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'Data Collection Mode', 'Web', 32, 43.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'How Long at Current Job', '1-5 Years', 32, 3.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'How Long at Current Job', '10 Years or More', 32, 96.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'How Long at Current Job', '6-9 Years', 32, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'How Long at Current Job', '<1 Year', 32, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'How Long at Current Job', 'Missing', 32, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2010-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Construction', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Education services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Information', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Mining', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Retail trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Unclassified', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Utilities', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 91.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'O*NET-SOC Employee Response Rate', NULL, NULL, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('13-2099.04', 'Total Completes for O*NET-SOC', NULL, 32, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'Data Collection Mode', 'Paper', 109, 38.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'Data Collection Mode', 'Web', 109, 61.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'How Long at Current Job', '1-5 Years', 109, 44.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'How Long at Current Job', '10 Years or More', 109, 33.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'How Long at Current Job', '6-9 Years', 109, 18.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'How Long at Current Job', '<1 Year', 109, 4.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'How Long at Current Job', 'Missing', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 109, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 62.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 85.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1111.00', 'Total Completes for O*NET-SOC', NULL, 109, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'Data Collection Mode', 'Paper', 123, 52.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'Data Collection Mode', 'Web', 123, 47.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'How Long at Current Job', '1-5 Years', 123, 28.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'How Long at Current Job', '10 Years or More', 123, 30.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'How Long at Current Job', '6-9 Years', 123, 26.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'How Long at Current Job', '<1 Year', 123, 13.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'How Long at Current Job', 'Missing', 123, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 123, 2.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 123, 4.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 123, 30.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 123, 61.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 123, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Accommodation and food services', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 123, 2.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Construction', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Education services', 123, 12.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Finance and insurance', 123, 2.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Health care and social assistance', 123, 15.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Information', 123, 8.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Management of Companies and Enterprises', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Manufacturing', 123, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Mining', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Other services, except public administration', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 123, 26.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Public administration', 123, 30.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Real estate and rental and leasing', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Retail trade', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Transportation and warehousing', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Unclassified', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Utilities', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Wholesale trade', 123, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 87.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 63.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 70.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.00', 'Total Completes for O*NET-SOC', NULL, 123, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'Data Collection Mode', 'Paper', 20, 10.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'Data Collection Mode', 'Web', 20, 90.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'How Long at Current Job', '1-5 Years', 20, 15.0, '2013-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'How Long at Current Job', '10 Years or More', 20, 60.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'How Long at Current Job', '6-9 Years', 20, 20.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'How Long at Current Job', '<1 Year', 20, 5.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'How Long at Current Job', 'Missing', 20, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Construction', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Education services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Information', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Mining', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 95.2, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 67.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 87.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1121.01', 'Total Completes for O*NET-SOC', NULL, 20, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'Data Collection Mode', 'Paper', 74, 44.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'Data Collection Mode', 'Web', 74, 55.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'How Long at Current Job', '1-5 Years', 74, 37.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'How Long at Current Job', '10 Years or More', 74, 27.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'How Long at Current Job', '6-9 Years', 74, 29.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'How Long at Current Job', '<1 Year', 74, 5.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'How Long at Current Job', 'Missing', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 74, 14.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 74, 14.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 74, 14.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 74, 4.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 74, 50.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 74, 1.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Accommodation and food services', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Construction', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Education services', 74, 33.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Finance and insurance', 74, 14.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Health care and social assistance', 74, 5.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Information', 74, 4.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Management of Companies and Enterprises', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Manufacturing', 74, 12.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Mining', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Other services, except public administration', 74, 2.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 74, 6.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Public administration', 74, 14.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Real estate and rental and leasing', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Retail trade', 74, 4.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Transportation and warehousing', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Unclassified', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Utilities', 74, 1.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Wholesale trade', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 64.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 69.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1122.00', 'Total Completes for O*NET-SOC', NULL, 74, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'Data Collection Mode', 'Paper', 112, 50.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'Data Collection Mode', 'Web', 112, 49.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'How Long at Current Job', '1-5 Years', 112, 32.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'How Long at Current Job', '10 Years or More', 112, 36.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'How Long at Current Job', '6-9 Years', 112, 23.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'How Long at Current Job', '<1 Year', 112, 8.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'How Long at Current Job', 'Missing', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 112, 5.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 112, 10.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 112, 5.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 112, 77.7, '2009-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 112, 0.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Accommodation and food services', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Construction', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Education services', 112, 42.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Finance and insurance', 112, 5.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Health care and social assistance', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Information', 112, 9.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Management of Companies and Enterprises', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Manufacturing', 112, 7.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Mining', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Other services, except public administration', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 112, 30.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Public administration', 112, 5.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Real estate and rental and leasing', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Retail trade', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Transportation and warehousing', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Unclassified', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Utilities', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Wholesale trade', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 68.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 69.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1131.00', 'Total Completes for O*NET-SOC', NULL, 112, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'Data Collection Mode', 'Paper', 85, 43.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'Data Collection Mode', 'Web', 85, 56.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'How Long at Current Job', '1-5 Years', 85, 27.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'How Long at Current Job', '10 Years or More', 85, 36.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'How Long at Current Job', '6-9 Years', 85, 23.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'How Long at Current Job', '<1 Year', 85, 12.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'How Long at Current Job', 'Missing', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 85, 24.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 85, 4.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 85, 70.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Accommodation and food services', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Construction', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Education services', 85, 14.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Finance and insurance', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Health care and social assistance', 85, 1.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Information', 85, 9.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Management of Companies and Enterprises', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Manufacturing', 85, 23.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Mining', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Other services, except public administration', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 85, 47.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Public administration', 85, 4.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Real estate and rental and leasing', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Retail trade', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Transportation and warehousing', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Unclassified', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Utilities', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Wholesale trade', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 87.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 61.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 71.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1132.00', 'Total Completes for O*NET-SOC', NULL, 85, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'Data Collection Mode', 'Paper', 116, 33.6, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'Data Collection Mode', 'Web', 116, 66.4, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'How Long at Current Job', '1-5 Years', 116, 34.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'How Long at Current Job', '10 Years or More', 116, 43.1, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'How Long at Current Job', '6-9 Years', 116, 18.1, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'How Long at Current Job', '<1 Year', 116, 2.6, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'How Long at Current Job', 'Missing', 116, 1.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 116, 2.6, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 116, 6.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 116, 16.4, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 116, 20.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 116, 52.6, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 116, 1.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Accommodation and food services', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Construction', 116, 2.6, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Education services', 116, 8.6, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Finance and insurance', 116, 6.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Health care and social assistance', 116, 5.2, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Information', 116, 1.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Management of Companies and Enterprises', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Manufacturing', 116, 16.4, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Mining', 116, 0.0, '2013-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Other services, except public administration', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 116, 38.8, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Public administration', 116, 20.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Real estate and rental and leasing', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Retail trade', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Transportation and warehousing', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Unclassified', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Utilities', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Wholesale trade', 116, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.3, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 66.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 79.2, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1133.00', 'Total Completes for O*NET-SOC', NULL, 116, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'Data Collection Mode', 'Paper', 30, 26.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'Data Collection Mode', 'Web', 30, 73.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'How Long at Current Job', '1-5 Years', 30, 3.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'How Long at Current Job', '10 Years or More', 30, 30.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'How Long at Current Job', '6-9 Years', 30, 63.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'How Long at Current Job', '<1 Year', 30, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'How Long at Current Job', 'Missing', 30, 3.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 84.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 88.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1134.00', 'Total Completes for O*NET-SOC', NULL, 30, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'Data Collection Mode', 'Paper', 85, 55.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'Data Collection Mode', 'Web', 85, 44.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'How Long at Current Job', '1-5 Years', 85, 32.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'How Long at Current Job', '10 Years or More', 85, 30.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'How Long at Current Job', '6-9 Years', 85, 28.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'How Long at Current Job', '<1 Year', 85, 7.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'How Long at Current Job', 'Missing', 85, 1.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 85, 12.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 85, 25.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 85, 5.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 85, 55.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Accommodation and food services', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 85, 2.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Construction', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Education services', 85, 35.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Finance and insurance', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Health care and social assistance', 85, 4.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Information', 85, 4.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Management of Companies and Enterprises', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Manufacturing', 85, 8.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Mining', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Other services, except public administration', 85, 2.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 85, 10.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Public administration', 85, 25.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Real estate and rental and leasing', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Retail trade', 85, 5.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Transportation and warehousing', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Unclassified', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Utilities', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Wholesale trade', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 83.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 65.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 62.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1141.00', 'Total Completes for O*NET-SOC', NULL, 85, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'Data Collection Mode', 'Paper', 77, 41.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'Data Collection Mode', 'Web', 77, 58.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'How Long at Current Job', '1-5 Years', 77, 48.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'How Long at Current Job', '10 Years or More', 77, 18.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'How Long at Current Job', '6-9 Years', 77, 23.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'How Long at Current Job', '<1 Year', 77, 10.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'How Long at Current Job', 'Missing', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 77, 1.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 77, 15.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 77, 1.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 77, 10.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 77, 1.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 77, 63.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 77, 2.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 77, 3.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Accommodation and food services', 77, 5.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 77, 3.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 77, 0.0, '2008-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Construction', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Education services', 77, 27.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Finance and insurance', 77, 1.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Health care and social assistance', 77, 11.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Information', 77, 7.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Management of Companies and Enterprises', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Manufacturing', 77, 13.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Mining', 77, 1.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Other services, except public administration', 77, 3.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 77, 9.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Public administration', 77, 10.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Real estate and rental and leasing', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Retail trade', 77, 1.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Transportation and warehousing', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Unclassified', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Utilities', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Wholesale trade', 77, 3.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 88.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 48.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 60.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1142.00', 'Total Completes for O*NET-SOC', NULL, 77, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'Data Collection Mode', 'Paper', 23, 43.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'Data Collection Mode', 'Web', 23, 56.5, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'How Long at Current Job', '1-5 Years', 23, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'How Long at Current Job', '10 Years or More', 23, 95.7, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'How Long at Current Job', '6-9 Years', 23, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'How Long at Current Job', '<1 Year', 23, 0.0, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'How Long at Current Job', 'Missing', 23, 4.3, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Construction', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Education services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Information', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Mining', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 85.2, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 87.1, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 87.1, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1143.01', 'Total Completes for O*NET-SOC', NULL, 23, NULL, '2013-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'Data Collection Mode', 'Paper', 141, 42.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'Data Collection Mode', 'Web', 141, 57.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'How Long at Current Job', '1-5 Years', 141, 47.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'How Long at Current Job', '10 Years or More', 141, 17.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'How Long at Current Job', '6-9 Years', 141, 22.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'How Long at Current Job', '<1 Year', 141, 9.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'How Long at Current Job', 'Missing', 141, 2.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 141, 5.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 141, 10.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 141, 0.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 141, 11.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 141, 2.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 141, 67.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 141, 2.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Accommodation and food services', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 141, 0.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 141, 0.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Construction', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Education services', 141, 44.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Finance and insurance', 141, 5.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Health care and social assistance', 141, 2.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Information', 141, 5.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Management of Companies and Enterprises', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Manufacturing', 141, 9.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Mining', 141, 0.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Other services, except public administration', 141, 3.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 141, 11.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Public administration', 141, 11.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Real estate and rental and leasing', 141, 0.0, '2008-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Retail trade', 141, 2.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Transportation and warehousing', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Unclassified', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Utilities', 141, 2.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Wholesale trade', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 65.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 70.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1151.00', 'Total Completes for O*NET-SOC', NULL, 141, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'Data Collection Mode', 'Paper', 118, 35.6, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'Data Collection Mode', 'Web', 118, 64.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'How Long at Current Job', '1-5 Years', 118, 28.8, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'How Long at Current Job', '10 Years or More', 118, 42.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'How Long at Current Job', '6-9 Years', 118, 16.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'How Long at Current Job', '<1 Year', 118, 9.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'How Long at Current Job', 'Missing', 118, 2.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 118, 0.8, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 118, 2.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 118, 9.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 118, 12.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 118, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 118, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 118, 6.8, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 118, 2.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 118, 54.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 118, 8.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 118, 2.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Accommodation and food services', 118, 4.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 118, 4.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 118, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 118, 1.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Construction', 118, 2.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Education services', 118, 19.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Finance and insurance', 118, 5.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Health care and social assistance', 118, 1.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Information', 118, 5.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Management of Companies and Enterprises', 118, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Manufacturing', 118, 10.2, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Mining', 118, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Other services, except public administration', 118, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 118, 23.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Public administration', 118, 6.8, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Real estate and rental and leasing', 118, 3.4, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Retail trade', 118, 2.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Transportation and warehousing', 118, 5.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Unclassified', 118, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Utilities', 118, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Wholesale trade', 118, 2.5, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 86.8, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 63.9, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 62.6, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1152.00', 'Total Completes for O*NET-SOC', NULL, 118, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'Data Collection Mode', 'Paper', 23, 47.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'Data Collection Mode', 'Web', 23, 52.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'How Long at Current Job', '1-5 Years', 23, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'How Long at Current Job', '10 Years or More', 23, 69.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'How Long at Current Job', '6-9 Years', 23, 26.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'How Long at Current Job', '<1 Year', 23, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'How Long at Current Job', 'Missing', 23, 4.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 92.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 75.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.01', 'Total Completes for O*NET-SOC', NULL, 23, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'Data Collection Mode', 'Paper', 23, 65.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'Data Collection Mode', 'Web', 23, 34.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'How Long at Current Job', '1-5 Years', 23, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'How Long at Current Job', '10 Years or More', 23, 78.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'How Long at Current Job', '6-9 Years', 23, 21.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'How Long at Current Job', '<1 Year', 23, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'How Long at Current Job', 'Missing', 23, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 69.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 95.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.02', 'Total Completes for O*NET-SOC', NULL, 23, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'Data Collection Mode', 'Paper', 23, 39.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'Data Collection Mode', 'Web', 23, 60.9, '2008-06-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'How Long at Current Job', '1-5 Years', 23, 4.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'How Long at Current Job', '10 Years or More', 23, 39.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'How Long at Current Job', '6-9 Years', 23, 56.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'How Long at Current Job', '<1 Year', 23, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'How Long at Current Job', 'Missing', 23, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 85.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 81.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'O*NET-SOC Employee Response Rate', NULL, NULL, 90.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.03', 'Total Completes for O*NET-SOC', NULL, 23, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'Data Collection Mode', 'Paper', 28, 46.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'Data Collection Mode', 'Web', 28, 53.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'How Long at Current Job', '1-5 Years', 28, 3.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'How Long at Current Job', '10 Years or More', 28, 75.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'How Long at Current Job', '6-9 Years', 28, 17.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'How Long at Current Job', '<1 Year', 28, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'How Long at Current Job', 'Missing', 28, 3.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 85.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'O*NET-SOC Employee Response Rate', NULL, NULL, 96.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.04', 'Total Completes for O*NET-SOC', NULL, 28, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'Data Collection Mode', 'Paper', 56, 58.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'Data Collection Mode', 'Web', 56, 41.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'How Long at Current Job', '1-5 Years', 56, 41.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'How Long at Current Job', '10 Years or More', 56, 33.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'How Long at Current Job', '6-9 Years', 56, 23.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'How Long at Current Job', '<1 Year', 56, 1.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'How Long at Current Job', 'Missing', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 56, 75.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 56, 25.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Accommodation and food services', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Arts, entertainment, and recreation', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Construction', 56, 3.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Education services', 56, 3.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Finance and insurance', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Health care and social assistance', 56, 1.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Information', 56, 1.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Management of Companies and Enterprises', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Manufacturing', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Mining', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Other services, except public administration', 56, 5.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Professional, Scientific and Technical Services', 56, 17.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Public administration', 56, 57.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Real estate and rental and leasing', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Retail trade', 56, 5.4, '2011-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Transportation and warehousing', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Unclassified', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Utilities', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Wholesale trade', 56, 3.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'O*NET-SOC Employee Response Rate', NULL, NULL, 90.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 88.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.05', 'Total Completes for O*NET-SOC', NULL, 56, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'Data Collection Mode', 'Paper', 24, 29.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'Data Collection Mode', 'Web', 24, 70.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'How Long at Current Job', '1-5 Years', 24, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'How Long at Current Job', '10 Years or More', 24, 75.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'How Long at Current Job', '6-9 Years', 24, 25.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'How Long at Current Job', '<1 Year', 24, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'How Long at Current Job', 'Missing', 24, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Construction', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Education services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Information', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Mining', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Retail trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Unclassified', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Utilities', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 80.7, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'O*NET-SOC Employee Response Rate', NULL, NULL, 86.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.08', 'Total Completes for O*NET-SOC', NULL, 24, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'Data Collection Mode', 'Paper', 31, 19.4, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'Data Collection Mode', 'Web', 31, 80.6, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'How Long at Current Job', '1-5 Years', 31, 3.2, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'How Long at Current Job', '10 Years or More', 31, 71.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'How Long at Current Job', '6-9 Years', 31, 25.8, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'How Long at Current Job', '<1 Year', 31, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'How Long at Current Job', 'Missing', 31, 0.0, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Construction', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Education services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Information', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Mining', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Public administration', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Retail trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Unclassified', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Utilities', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.9, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 94.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'O*NET-SOC Employee Response Rate', NULL, NULL, 94.3, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.09', 'Total Completes for O*NET-SOC', NULL, 31, NULL, '2012-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'Data Collection Mode', 'Paper', 23, 21.7, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'Data Collection Mode', 'Web', 23, 78.3, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'How Long at Current Job', '1-5 Years', 23, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'How Long at Current Job', '10 Years or More', 23, 73.9, '2014-07-01');
GO
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'How Long at Current Job', '6-9 Years', 23, 26.1, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'How Long at Current Job', '<1 Year', 23, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'How Long at Current Job', 'Missing', 23, 0.0, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'NAICS Sector', 'Construction', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'NAICS Sector', 'Education services', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'NAICS Sector', 'Information', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-1199.10', 'NAICS Sector', 'Mining', NULL, NULL, '2014-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, [percent], date_updated) VALUES ('15-119