CREATE TABLE level_scale_anchors (
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  anchor_value DECIMAL(3,0) NOT NULL,
  anchor_description CHARACTER VARYING(1000) NOT NULL,
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id));
GO

INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.a.1', 'LV', 2, 'Understand a television commercial');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.a.1', 'LV', 4, 'Understand a coach''s oral instructions for a sport');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.a.1', 'LV', 6, 'Understand a lecture on advanced physics');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.a.2', 'LV', 2, 'Understand signs on the highway');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.a.2', 'LV', 4, 'Understand an apartment lease');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.a.2', 'LV', 6, 'Understand an instruction book on repairing missile guidance systems');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.a.3', 'LV', 2, 'Cancel newspaper delivery by phone');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.a.3', 'LV', 4, 'Give instructions to a lost motorist');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.a.3', 'LV', 6, 'Explain advanced principles of genetics to college freshmen');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.a.4', 'LV', 1, 'Write a note to remind someone to take food out of the freezer');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.a.4', 'LV', 4, 'Write a job recommendation for a subordinate');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.a.4', 'LV', 6, 'Write an advanced economics textbook');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.1', 'LV', 2, 'Name four different uses for a screwdriver');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.1', 'LV', 4, 'Think of as many ideas as possible for the name of a new company');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.1', 'LV', 6, 'Name all the possible strategies for a military battle');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.2', 'LV', 2, 'Use a credit card to open a locked door');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.2', 'LV', 4, 'Redesign job tasks to be interesting for employees');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.2', 'LV', 6, 'Invent a new type of man-made fiber');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.3', 'LV', 2, 'Recognize that an unplugged lamp won''t work');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.3', 'LV', 4, 'Recognize from the mood of prisoners that a prison riot is likely to occur');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.3', 'LV', 6, 'Recognize an illness at an early stage of a disease when there are only a few symptoms');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.4', 'LV', 2, 'Know that a stalled car can coast downhill');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.4', 'LV', 5, 'Decide what factors to consider in selecting stocks');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.4', 'LV', 6, 'Design an aircraft wing using principles of aerodynamics');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.5', 'LV', 2, 'Decide what to wear based on the weather report');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.5', 'LV', 4, 'Determine the prime suspect based on crime scene evidence');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.5', 'LV', 6, 'Diagnose a disease using results of many different lab tests');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.6', 'LV', 1, 'Put things in numerical order');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.6', 'LV', 2, 'Follow the correct steps to make change');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.6', 'LV', 6, 'Assemble a nuclear warhead');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.7', 'LV', 2, 'Sort nails in a toolbox on the basis of length');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.7', 'LV', 3, 'Classify flowers according to size, color, and smell');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.b.7', 'LV', 6, 'Classify man-made fibers in terms of their strength, cost, flexibility, melting points, etc.');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.c.1', 'LV', 1, 'Determine how much 10 oranges will cost when they are priced at 2 for 20 cents');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.c.1', 'LV', 4, 'Decide how to calculate profits to determine the amounts of yearly bonuses');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.c.1', 'LV', 6, 'Determine the mathematics required to simulate a space craft landing on the moon');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.c.2', 'LV', 1, 'Add 2 and 7');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.c.2', 'LV', 3, 'Balance a checkbook');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.c.2', 'LV', 5, 'Compute the interest payment that should be generated from an investment');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.d.1', 'LV', 1, 'Remember the number on your bus to be sure you get back on the right one');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.d.1', 'LV', 4, 'Recite the first names of the five people you just met');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.d.1', 'LV', 6, 'Recite the Gettysburg Address after studying it for 15 minutes');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.e.1', 'LV', 3, 'Recognize a song after hearing only the first few notes');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.e.1', 'LV', 4, 'Make sense out of strange handwriting');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.e.1', 'LV', 5, 'Interpret patterns on weather radar to decide if the weather is changing');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.e.2', 'LV', 2, 'Tune in a radio in a noisy truck');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.e.2', 'LV', 4, 'Look for a golf ball in the rough');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.e.2', 'LV', 6, 'Identify camouflaged tanks from a high-speed airplane');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.e.3', 'LV', 2, 'Sort mail according to ZIP codes with no time pressure');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.e.3', 'LV', 4, 'Read five temperature gauges in 10 seconds to make sure each temperature is within safe limits');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.e.3', 'LV', 6, 'Inspect electrical parts for defects as they flow by on a fast-moving assembly line');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.f.1', 'LV', 2, 'Use the floor plan to locate a store in a mall');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.f.1', 'LV', 3, 'Find your way through a dark room without hitting anything');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.f.1', 'LV', 6, 'Navigate an ocean voyage using only the positions of the sun and stars');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.f.2', 'LV', 2, 'Imagine how to put paper in a typewriter so that the letterhead comes out on top');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.f.2', 'LV', 4, 'Follow a diagram to assemble a metal storage cabinet');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.f.2', 'LV', 6, 'Anticipate opponent''s as well as your own future moves in a chess game');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.g.1', 'LV', 2, 'Answer a business call with coworkers talking nearby');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.g.1', 'LV', 4, 'Monitor security TV screens for intruders throughout the night shift');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.g.1', 'LV', 6, 'Study a technical manual in a noisy boiler room');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.g.2', 'LV', 2, 'Listen to music while filing papers');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.g.2', 'LV', 3, 'Watch street signs while driving at 30 miles an hour');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.1.g.2', 'LV', 6, 'Monitor radar and radio transmissions to keep track of aircraft during periods of heavy traffic');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.a.1', 'LV', 2, 'Light a candle');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.a.1', 'LV', 4, 'Thread a needle');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.a.1', 'LV', 6, 'Cut facets in a diamond');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.a.2', 'LV', 1, 'Screw a light bulb into a light socket');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.a.2', 'LV', 4, 'Pack oranges in crates as quickly as possible');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.a.2', 'LV', 7, 'Perform open heart surgery with surgical instruments');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.a.3', 'LV', 2, 'Put coins in a parking meter');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.a.3', 'LV', 4, 'Attach small knobs to stereo equipment on an assembly line');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.a.3', 'LV', 6, 'Put together the inner workings of a small wrist watch');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.b.1', 'LV', 2, 'Adjust a room light with a dimmer switch');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.b.1', 'LV', 4, 'Adjust farm tractor controls');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.b.1', 'LV', 6, 'Drill a tooth');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.b.2', 'LV', 2, 'Row a boat');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.b.2', 'LV', 4, 'Operate a forklift truck in a warehouse');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.b.2', 'LV', 6, 'Play the drum set in a jazz band');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.b.3', 'LV', 2, 'When the doorbell and telephone ring at the same time, quickly select which to answer first');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.b.3', 'LV', 4, 'Hit either the automobile brake or gas pedal in a skid situation');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.b.3', 'LV', 7, 'In an out of control spacecraft, react quickly to restore control');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.b.4', 'LV', 1, 'Ride a bicycle alongside a jogger');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.b.4', 'LV', 4, 'Keep up with a car that changes speed');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.b.4', 'LV', 5, 'Shoot a duck in flight');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.c.1', 'LV', 2, 'Start to slow down the car when a traffic light turns yellow');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.c.1', 'LV', 4, 'Throw a switch when a red warning light goes off');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.c.1', 'LV', 6, 'Hit the brake when a pedestrian steps in front of the car');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.c.2', 'LV', 2, 'Use a manual pencil sharpener');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.c.2', 'LV', 3, 'Carve roast beef in a cafeteria');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.c.2', 'LV', 6, 'Type a document at 90 words per minute');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.c.3', 'LV', 2, 'Saw through a thin piece of wood');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.c.3', 'LV', 4, 'Swat a fly with a fly swatter');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.2.c.3', 'LV', 6, 'Throw punches in a boxing match');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.a.1', 'LV', 1, 'Push an empty shopping cart');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.a.1', 'LV', 4, 'Pull a 40-pound sack of fertilizer across the lawn');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.a.1', 'LV', 6, 'Lift 75-pound bags of cement onto a truck');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.a.2', 'LV', 2, 'Hit a nail with a hammer');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.a.2', 'LV', 4, 'Jump onto a 3-foot high platform');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.a.2', 'LV', 7, 'Throw a shot-put in a track meet');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.a.3', 'LV', 2, 'Use pruning shears to trim a bush');
GO
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.a.3', 'LV', 5, 'Climb a 48-foot long ladder');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.a.3', 'LV', 6, 'Perform a gymnastics routine using the rings');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.a.4', 'LV', 2, 'Sit up in an office chair');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.a.4', 'LV', 4, 'Shovel snow for half an hour');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.a.4', 'LV', 6, 'Do 100 sit-ups');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.b.1', 'LV', 1, 'Walk 1/4 mile');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.b.1', 'LV', 4, 'Climb 6 flights of stairs');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.b.1', 'LV', 6, 'Run 10 miles');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.c.1', 'LV', 2, 'Reach for a microphone in a patrol car');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.c.1', 'LV', 4, 'Reach for a box on a high warehouse shelf');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.c.1', 'LV', 6, 'Work under the dashboard of a car');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.c.2', 'LV', 2, 'Hand pick a bushel of apples from a tree');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.c.2', 'LV', 5, 'Perform a dance routine as part of a cheerleading squad');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.c.2', 'LV', 6, 'Maneuver a kayak through swift rapids');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.c.3', 'LV', 2, 'Get in and out of a truck');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.c.3', 'LV', 4, 'Swim the length of a pool');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.c.3', 'LV', 6, 'Perform a ballet dance');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.c.4', 'LV', 2, 'Stand on a ladder');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.c.4', 'LV', 4, 'Walk on ice across a pond');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.3.c.4', 'LV', 6, 'Walk on narrow beams in high-rise construction');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.1', 'LV', 2, 'Read dials on the dashboard of a car');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.1', 'LV', 5, 'Read the fine print of a legal document');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.1', 'LV', 6, 'Detect minor defects in a diamond');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.2', 'LV', 2, 'Read a roadside billboard');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.2', 'LV', 4, 'Focus a slide projector');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.2', 'LV', 7, 'Detect differences in ships on the horizon');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.3', 'LV', 1, 'Separate laundry into colors and whites');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.3', 'LV', 4, 'Trace electrical circuits marked by various colored wires');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.3', 'LV', 6, 'Paint a color portrait of a live person');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.4', 'LV', 2, 'Read street signs at dusk (just after sunset)');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.4', 'LV', 4, 'Take notes during a slide presentation');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.4', 'LV', 6, 'Find your way through the woods on a moonless night');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.5', 'LV', 2, 'Keep in step while marching in a military formation');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.5', 'LV', 4, 'Be aware of the location of your teammates while dribbling a basketball');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.5', 'LV', 6, 'Distinguish friendly from enemy planes during air combat');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.6', 'LV', 2, 'Merge a car into traffic on a city street');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.6', 'LV', 4, 'Operate a crane to move materials from a truck bed to the ground');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.6', 'LV', 6, 'Throw a long pass to a closely guarded teammate');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.7', 'LV', 2, 'Drive on a familiar road on a cloudy day');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.7', 'LV', 5, 'See boats on the horizon when sailing');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.a.7', 'LV', 6, 'Snow ski in bright sunlight');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.b.1', 'LV', 2, 'Notice when a watch alarm goes off');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.b.1', 'LV', 4, 'Diagnose what''s wrong with a car engine from its sound');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.b.1', 'LV', 6, 'Tune an orchestra');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.b.2', 'LV', 2, 'Listen to a lecture while people nearby are talking');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.b.2', 'LV', 4, 'Listen for your flight announcement at a busy airport');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.b.2', 'LV', 6, 'Listen to instructions from a coworker in a noisy saw mill');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.b.3', 'LV', 2, 'Listen to a stereo to determine which speaker is working');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.b.3', 'LV', 4, 'Find a ringing telephone in an unfamiliar apartment');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.b.3', 'LV', 6, 'Determining the direction of an emergency vehicle from the sound of the siren');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.b.4', 'LV', 2, 'Recognize the voice of a coworker');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.b.4', 'LV', 4, 'Identify a former customer''s voice over the telephone');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.b.4', 'LV', 6, 'Understand a speech presented by someone with a strange accent');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.b.5', 'LV', 1, 'Call numbers in a bingo game');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.b.5', 'LV', 4, 'Make announcements over the loudspeaker at a sports event');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('1.A.4.b.5', 'LV', 6, 'Give a lecture to a large audience');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.a', 'LV', 2, 'Read step-by-step instructions for completing a form');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.a', 'LV', 4, 'Read a memo from management describing new personnel policies');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.a', 'LV', 6, 'Read a scientific journal article describing surgical procedures');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.b', 'LV', 2, 'Take a customer''s order');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.b', 'LV', 4, 'Answer inquiries regarding credit references');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.b', 'LV', 6, 'Preside as judge in a complex legal disagreement');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.c', 'LV', 2, 'Take a telephone message');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.c', 'LV', 4, 'Write a memo to staff outlining new directives');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.c', 'LV', 6, 'Write a novel for publication');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.d', 'LV', 2, 'Greet tourists and explain tourist attractions');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.d', 'LV', 4, 'Interview applicants to obtain personal and work history');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.d', 'LV', 6, 'Argue a legal case before the Supreme Court');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.e', 'LV', 2, 'Count the amount of change to be given to a customer');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.e', 'LV', 4, 'Calculate the square footage of a new home under construction');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.e', 'LV', 6, 'Develop a mathematical model to simulate and resolve an engineering problem');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.f', 'LV', 2, 'Conduct standard tests to determine soil quality');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.f', 'LV', 4, 'Conduct product tests to ensure safety standards are met, following written instructions');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.1.f', 'LV', 6, 'Conduct analyses of aerodynamic systems to determine the practicality of an aircraft design');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.2.a', 'LV', 2, 'Determine whether a subordinate has a good excuse for being late');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.2.a', 'LV', 4, 'Evaluate customer complaints and determine appropriate responses');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.2.a', 'LV', 6, 'Write legal brief challenging a federal law');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.2.b', 'LV', 2, 'Think about the implications of a newspaper article for job opportunities');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.2.b', 'LV', 4, 'Determine the impact of new menu changes on a restaurant''s purchasing requirements');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.2.b', 'LV', 6, 'Identify the implications of a new scientific theory for product design');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.2.c', 'LV', 2, 'Learn a different method of completing a task from a coworker');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.2.c', 'LV', 4, 'Identify an alternative approach that might help trainees who are having difficulties');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.2.c', 'LV', 6, 'Apply principles of educational psychology to develop new teaching methods');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.2.d', 'LV', 2, 'Proofread and correct a letter');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.2.d', 'LV', 4, 'Monitor a meeting''s progress and revise the agenda to ensure that important topics are discussed');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.A.2.d', 'LV', 6, 'Review corporate productivity and develop a plan to increase productivity');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.a', 'LV', 2, 'Notice that customers are angry because they have been waiting too long');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.a', 'LV', 4, 'Be aware of how a coworker''s promotion will affect a work group');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.a', 'LV', 6, 'Counsel depressive patients during a crisis period');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.b', 'LV', 2, 'Schedule appointments for a medical clinic');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.b', 'LV', 4, 'Work with others to put a new roof on a house');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.b', 'LV', 6, 'Work as director of a consulting project calling for interaction with multiple subcontractors');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.c', 'LV', 2, 'Solicit donations for a charity');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.c', 'LV', 4, 'Convince a supervisor to purchase a new copy machine');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.c', 'LV', 6, 'Change the opinion of the jury in a complex legal case');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.d', 'LV', 2, 'Present justification to a manager for altering work schedule');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.d', 'LV', 4, 'Contract with a wholesaler to sell items at a given cost');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.d', 'LV', 6, 'Work as an ambassador in negotiating a new treaty');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.e', 'LV', 2, 'Instruct a new employee in the use of a time clock');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.e', 'LV', 4, 'Instruct a coworker in how to operate a software program');
GO
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.e', 'LV', 6, 'Demonstrate surgical procedure to interns in a teaching hospital');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.f', 'LV', 2, 'Ask customers if they would like cups of coffee');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.f', 'LV', 4, 'Make flight reservations for customers, using airline reservation system');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.1.f', 'LV', 6, 'Direct relief agency operations in a disaster area');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.2.i', 'LV', 2, 'Lay out tools to complete a job');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.2.i', 'LV', 4, 'Redesign a floor layout to take advantage of new manufacturing techniques');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.2.i', 'LV', 6, 'Develop and implement a plan to provide emergency relief for a major metropolitan area');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.a', 'LV', 2, 'Select a photocopy machine for an office');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.a', 'LV', 4, 'Suggest changes in software to make a system more user friendly');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.a', 'LV', 6, 'Identify the control system needed for a new process production plant');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.b', 'LV', 2, 'Adjust exercise equipment for use by a customer');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.b', 'LV', 4, 'Redesign the handle on a hand tool for easier gripping');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.b', 'LV', 6, 'Create new technology for producing industrial diamonds');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.c', 'LV', 2, 'Select a screwdriver to use in adjusting a vehicle''s carburetor');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.c', 'LV', 4, 'Choose a software application to use to complete a work assignment');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.c', 'LV', 6, 'Identify the equipment needed to produce a new product line');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.d', 'LV', 2, 'Install a new air filter in an air conditioner');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.d', 'LV', 4, 'Install new switches for a telephone exchange');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.d', 'LV', 6, 'Install a "one of a kind" process production molding machine');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.e', 'LV', 2, 'Write a program in BASIC to sort objects in a database');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.e', 'LV', 4, 'Write a statistical analysis program to analyze demographic data');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.e', 'LV', 6, 'Write expert system programs to analyze ground radar geological data for probable existence of mineral deposits');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.g', 'LV', 2, 'Monitor completion times while running a computer program');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.g', 'LV', 4, 'Monitor machine functions on an automated production line');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.g', 'LV', 6, 'Monitor and integrate control feedback in a petrochemical processing facility to maintain production flow');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.h', 'LV', 2, 'Adjust the settings on a copy machine to make reduced size photocopies');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.h', 'LV', 4, 'Adjust the speed of assembly line equipment based on the type of product being assembled');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.h', 'LV', 6, 'Control aircraft approach and landing at a large airport during a busy period');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.j', 'LV', 2, 'Add oil to an engine as indicated by a gauge or warning light');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.j', 'LV', 4, 'Clean moving parts in production machinery');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.j', 'LV', 6, 'Conduct maintenance checks on an experimental aircraft');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.k', 'LV', 2, 'Identify the source of a leak by looking under a machine');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.k', 'LV', 4, 'Identify the circuit causing an electrical system to fail');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.k', 'LV', 6, 'Direct the debugging of control code for a new operating system');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.l', 'LV', 2, 'Tighten a screw to get a door to close properly');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.l', 'LV', 4, 'Replace a faulty hydraulic valve');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.l', 'LV', 6, 'Repair structural damage after an earthquake');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.m', 'LV', 2, 'Inspect a draft memorandum for clerical errors');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.m', 'LV', 4, 'Measure new part requisitions for tolerance to specifications');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.3.m', 'LV', 6, 'Develop procedures to test a prototype of a new computer system');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.4.e', 'LV', 2, 'Decide how scheduling a break will affect work flow');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.4.e', 'LV', 4, 'Evaluate a loan application for degree of risk');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.4.e', 'LV', 6, 'Decide whether a manufacturing company should invest in new robotics technology');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.4.g', 'LV', 2, 'Determine how loss of a team member will affect the completion of a job');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.4.g', 'LV', 4, 'Determine how the introduction of a new piece of equipment will affect production rates');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.4.g', 'LV', 6, 'Identify how changes in tax laws are likely to affect preferred sites for manufacturing operations in different industries');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.4.h', 'LV', 2, 'Determine why a co-worker has been overly optimistic about how long it would take to complete a task');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.4.h', 'LV', 4, 'Identify the major reasons why a client might be unhappy with a product');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.4.h', 'LV', 6, 'Evaluate the long-term performance problem of a new computer system');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.5.a', 'LV', 2, 'Keep a monthly calendar of appointments');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.5.a', 'LV', 4, 'Allocate the time of subordinates to projects for the coming week');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.5.a', 'LV', 6, 'Allocate the time of scientists to multiple research projects');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.5.b', 'LV', 2, 'Take money from petty cash to buy office supplies and record the amount of the expenditure');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.5.b', 'LV', 4, 'Prepare and manage a budget for a short-term project');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.5.b', 'LV', 6, 'Develop and approve yearly budgets for a large corporation and obtain financing as necessary');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.5.c', 'LV', 2, 'Rent a meeting room for a management meeting');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.5.c', 'LV', 4, 'Evaluate an annual uniform service contract for delivery drivers');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.5.c', 'LV', 6, 'Determine the computer system needs of a large corporation and monitor use of the equipment');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.5.d', 'LV', 2, 'Encourage a coworker who is having difficulty finishing a piece of work');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.5.d', 'LV', 4, 'Direct the activities of a road repair crew with minimal disruption of traffic flow');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.B.5.d', 'LV', 6, 'Plan, implement, and manage recruitment, training, and incentive programs for a high performance company');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.a', 'LV', 2, 'Sign a pay voucher');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.a', 'LV', 4, 'Monitor progress of a project to ensure timely completion');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.a', 'LV', 6, 'Manage a $10 million company');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.b', 'LV', 2, 'File letters alphabetically');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.b', 'LV', 3, 'Type 30 words per minute');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.b', 'LV', 5, 'Organize a storage system for company forms');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.c', 'LV', 2, 'Answer billing questions from credit card customers');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.c', 'LV', 4, 'Develop financial investment programs for individual clients');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.c', 'LV', 6, 'Keep a major corporation''s financial records');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.d', 'LV', 2, 'Sell cakes at a bake sale');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.d', 'LV', 4, 'Call a list of clients to introduce them to a new product line');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.d', 'LV', 6, 'Develop a marketing plan for a nationwide telephone system');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.e', 'LV', 2, 'Process customer dry-cleaning drop off');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.e', 'LV', 4, 'Work as a day care aide supervising 10 children');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.e', 'LV', 6, 'Respond to a citizen''s request for assistance after a major disaster');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.f', 'LV', 2, 'Fill out a medical claim form');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.f', 'LV', 3, 'Interview applicants for a secretarial position');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.1.f', 'LV', 6, 'Design a new personnel selection and promotion system for the Army');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.10', 'LV', 2, 'Ride a train to work');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.10', 'LV', 5, 'Steer a large freighter through a busy harbor');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.10', 'LV', 6, 'Control air traffic at a busy airport');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.2.a', 'LV', 2, 'Put a computer back into its packing materials');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.2.a', 'LV', 4, 'Supervise an appliance assembly line');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.2.a', 'LV', 6, 'Manage an international shipping company distribution center');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.2.b', 'LV', 2, 'Keep an herb box in the kitchen');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.2.b', 'LV', 5, 'Operate a commercial fishing boat');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.2.b', 'LV', 6, 'Run a 100,000-acre farm');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.3.a', 'LV', 1, 'Operate a VCR to watch a pre-recorded training tape');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.3.a', 'LV', 3, 'Use a word processor');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.3.a', 'LV', 6, 'Create a program to scan computer disks for viruses');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.3.b', 'LV', 2, 'Install a door lock');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.3.b', 'LV', 4, 'Design a more stable grocery cart');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.3.b', 'LV', 6, 'Plan for the impact of weather in designing a bridge');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.3.c', 'LV', 2, 'Draw a straight line 4 3/16 inches long');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.3.c', 'LV', 4, 'Draw plans for remodeling a kitchen');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.3.c', 'LV', 6, 'Develop detailed plans for a high-rise office building');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.3.d', 'LV', 2, 'Choose the proper type of wood for adding a deck onto a house');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.3.d', 'LV', 4, 'Fix a plumbing leak in the ceiling');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.3.d', 'LV', 6, 'Build a high-rise office tower');
GO
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.3.e', 'LV', 2, 'Replace the filters in a furnace');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.3.e', 'LV', 4, 'Replace a valve on a steam pipe');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.3.e', 'LV', 7, 'Overhaul an airplane jet engine');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.a', 'LV', 1, 'Add two numbers');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.a', 'LV', 4, 'Analyze data to determine areas with the highest sales');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.a', 'LV', 6, 'Derive a complex mathematical equation');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.b', 'LV', 1, 'Use a crowbar to pry open a box');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.b', 'LV', 4, 'Calculate water pressure through a pipe');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.b', 'LV', 6, 'Design a cleaner burning gasoline engine');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.c', 'LV', 2, 'Use a common household bug spray');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.c', 'LV', 4, 'Use the proper concentration of chlorine to purify a water source');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.c', 'LV', 6, 'Develop a safe commercial cleaner');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.d', 'LV', 1, 'Feed domestic animals');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.d', 'LV', 5, 'Investigate the effects of pollution on marine plants and animals');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.d', 'LV', 7, 'Isolate and identify a new virus');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.e', 'LV', 2, 'Monitor several children on a playground');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.e', 'LV', 4, 'Understand the impact of alcohol on human responses');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.e', 'LV', 6, 'Treat a person with severe mental illness');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.f', 'LV', 2, 'Identify two cultures in a story as being different');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.f', 'LV', 5, 'Write a pamphlet about cultural differences');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.f', 'LV', 7, 'Create a new theory about the development of civilizations');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.g', 'LV', 2, 'Know the capital of the United States');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.g', 'LV', 4, 'Identify Turkey on a world map');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.4.g', 'LV', 6, 'Develop a map of the world showing mountains, deserts, and rivers');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.5.a', 'LV', 1, 'Use a band-aid');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.5.a', 'LV', 5, 'Fill a tooth cavity');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.5.a', 'LV', 7, 'Perform open heart surgery');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.5.b', 'LV', 2, 'Put ice on a sprained ankle');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.5.b', 'LV', 4, 'Provide job counseling to the unemployed');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.5.b', 'LV', 6, 'Counsel an abused child');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.6', 'LV', 2, 'Show someone how to bowl');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.6', 'LV', 4, 'Lead a quality improvement seminar');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.6', 'LV', 6, 'Design a training program for new employees');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.7.a', 'LV', 2, 'Write a thank you note');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.7.a', 'LV', 4, 'Edit a feature article in a local newspaper');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.7.a', 'LV', 6, 'Teach a college English class');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.7.b', 'LV', 1, 'Say "please" and "thank you" in a foreign language');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.7.b', 'LV', 3, 'Ask directions in a foreign city');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.7.b', 'LV', 5, 'Write an English language review of a book written in a foreign language');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.7.c', 'LV', 1, 'Attend a popular music concert');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.7.c', 'LV', 3, 'Play a minor part in a local theater play');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.7.c', 'LV', 5, 'Design an artistic display for a major trade show');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.7.d', 'LV', 3, 'Take a class in US history');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.7.d', 'LV', 4, 'Teach local history to school children');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.7.d', 'LV', 6, 'Determine the age of bones for placing them in fossil history');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.7.e', 'LV', 2, 'Watch a TV program on family values');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.7.e', 'LV', 4, 'Understand another culture''s religious practices');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.7.e', 'LV', 6, 'Compare the teachings of major philosophers');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.8.a', 'LV', 1, 'Use a seatbelt');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.8.a', 'LV', 4, 'Inspect a building site for safety violations');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.8.a', 'LV', 6, 'Command a military operation');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.8.b', 'LV', 2, 'Register to vote in a national election');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.8.b', 'LV', 4, 'Prepare documents and title papers for the purchase of a new house');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.8.b', 'LV', 6, 'Serve as a judge in a federal court');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.9.a', 'LV', 1, 'Dial a phone');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.9.a', 'LV', 2, 'Install a satellite TV dish');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.9.a', 'LV', 7, 'Develop a new, world-wide telecommunications network');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.9.b', 'LV', 2, 'Write a thank you note');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.9.b', 'LV', 4, 'Be a radio disk jockey');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('2.C.9.b', 'LV', 5, 'Write a novel');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.1.a.1', 'LV', 2, 'Follow a standard blueprint');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.1.a.1', 'LV', 4, 'Review a budget');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.1.a.1', 'LV', 6, 'Study international tax laws');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.1.a.2', 'LV', 2, 'Check to see if baking bread is done');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.1.a.2', 'LV', 4, 'Test electrical circuits');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.1.a.2', 'LV', 6, 'Check the status of a patient in critical medical care');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.1.b.1', 'LV', 2, 'Test an automobile transmission');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.1.b.1', 'LV', 4, 'Judge the acceptability of food products');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.1.b.1', 'LV', 6, 'Determine the reaction of a virus to a new drug');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.1.b.2', 'LV', 1, 'Check that doors to building are locked');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.1.b.2', 'LV', 4, 'Inspect equipment in a chemical processing plant');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.1.b.2', 'LV', 6, 'Inspect a nuclear reactor');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.1.b.3', 'LV', 2, 'Estimate the size of household furnishings to be crated');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.1.b.3', 'LV', 4, 'Estimate the time required to evacuate a city in the event of a major disaster');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.1.b.3', 'LV', 6, 'Estimate the amount of natural resources that lie beneath the world''s oceans');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.a.1', 'LV', 2, 'Determine whether to remove a tree that has been damaged');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.a.1', 'LV', 4, 'Determine the value of property lost in a fire');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.a.1', 'LV', 6, 'Establish the value of a recently discovered ancient art work');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.a.2', 'LV', 2, 'Tabulate the costs of parcel deliveries');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.a.2', 'LV', 4, 'Calculate the adjustments for insurance claims');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.a.2', 'LV', 6, 'Compile data for a complex scientific report');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.a.3', 'LV', 1, 'Review forms for completeness');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.a.3', 'LV', 4, 'Evaluate a complicated insurance claim for compliance with policy terms');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.a.3', 'LV', 6, 'Make a ruling in court on a complicated motion');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.a.4', 'LV', 1, 'Determine the location of a lost order');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.a.4', 'LV', 4, 'Determine the interest cost to finance a new building');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.a.4', 'LV', 6, 'Analyze the cost of medical care services for all hospitals in the country');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.1', 'LV', 2, 'Determine the meal selection for a cafeteria');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.1', 'LV', 4, 'Select the location for a major department store');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.1', 'LV', 6, 'Make the final decision about a company''s 5-year plan');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.2', 'LV', 1, 'Change the spacing on a printed report');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.2', 'LV', 4, 'Adapt popular music for a high school marching band');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.2', 'LV', 6, 'Create new computer software');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.3', 'LV', 2, 'Keep up with price changes in a small retail store');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.3', 'LV', 4, 'Keep current on changes in maintenance procedures for repairing sports cars');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.3', 'LV', 6, 'Learn information related to a complex and rapidly changing technology');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.4', 'LV', 2, 'Plan the holiday schedule for an airline workforce');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.4', 'LV', 4, 'Develop the plan to complete the merger of two organizations over a 3-year period');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.4', 'LV', 6, 'Develop a 10-year business plan for an organization');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.5', 'LV', 2, 'Make appointments for patients using a predetermined schedule');
GO
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.5', 'LV', 4, 'Prepare the work schedule for salesclerks in a large retail store');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.5', 'LV', 6, 'Schedule a complex conference program with multiple, parallel sessions');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.6', 'LV', 2, 'Organize a work schedule that is repetitive and easy to plan');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.6', 'LV', 4, 'Plan and organize your own activities that often change');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.2.b.6', 'LV', 6, 'Prioritize and plan multiple tasks several months ahead');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.a.1', 'LV', 1, 'Walk between work stations in a small office');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.a.1', 'LV', 4, 'Paint the outside of a house');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.a.1', 'LV', 6, 'Climb up and down poles to install electricity');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.a.2', 'LV', 2, 'Change settings on copy machines');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.a.2', 'LV', 4, 'Arrange books in a library');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.a.2', 'LV', 6, 'Load boxes on an assembly line');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.a.3', 'LV', 2, 'Operate a cash register');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.a.3', 'LV', 4, 'Operate a drilling rig');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.a.3', 'LV', 6, 'Operate a precision milling machine');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.a.4', 'LV', 2, 'Drive a car');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.a.4', 'LV', 4, 'Drive an 18-wheel tractor-trailer');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.a.4', 'LV', 6, 'Hover a helicopter in strong wind');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.b.1', 'LV', 2, 'Enter employee information into a computer database');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.b.1', 'LV', 4, 'Write software for keeping track of parts in inventory');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.b.1', 'LV', 6, 'Set up a new computer system for a large multinational company');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.b.2', 'LV', 2, 'Specify the lighting for a work area');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.b.2', 'LV', 4, 'Specify the furnishings for a new school');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.b.2', 'LV', 6, 'Draw the electronic circuitry for a high-speed scientific computer');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.b.4', 'LV', 2, 'Make simple, external adjustments to a door hinge with ordinary hand tools');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.b.4', 'LV', 4, 'Adjust a grandfather clock');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.b.4', 'LV', 6, 'Overhaul a power plant turbine');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.b.5', 'LV', 1, 'Use knobs to adjust a television picture');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.b.5', 'LV', 4, 'Make repairs by removing and replacing circuit boards');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.b.5', 'LV', 6, 'Use complex test equipment to calibrate electronic equipment');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.b.6', 'LV', 2, 'Record the weights of trucks that use the highways');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.b.6', 'LV', 4, 'Document the results of a crime scene investigation');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.3.b.6', 'LV', 6, 'Maintain information about the use of orbiting satellites for private industry communications');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.1', 'LV', 1, 'Interpret a blood pressure reading');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.1', 'LV', 4, 'Interpret how foreign tax laws apply to U.S. exports');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.1', 'LV', 6, 'Interpret a complex experiment in physics for general audiences');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.2', 'LV', 1, 'Write brief notes to others');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.2', 'LV', 4, 'Report the results of a sales meeting to a supervisor');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.2', 'LV', 6, 'Create a videotaped presentation of a company''s internal policies');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.3', 'LV', 1, 'Have little contact with people outside the organization');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.3', 'LV', 4, 'Make standard presentations about available services');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.3', 'LV', 6, 'Prepare or deliver press releases');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.4', 'LV', 1, 'Exchange greetings with a coworker');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.4', 'LV', 4, 'Maintain good working relationships with almost all coworkers and clients');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.4', 'LV', 7, 'Gain cooperation from a culturally diverse group of executives hostile to your company');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.5', 'LV', 2, 'Help a coworker complete an assignment');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.5', 'LV', 4, 'Assist a stranded traveler in finding lodging');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.5', 'LV', 6, 'Care for seriously injured persons in an emergency room');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.6', 'LV', 1, 'Convince a coworker to assist with an assignment');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.6', 'LV', 4, 'Deliver standard arguments or sales pitches to convince others to buy popular products');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.6', 'LV', 6, 'Deliver major sales campaign in a new market');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.7', 'LV', 2, 'Apologize to a customer who complains about waiting too long');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.7', 'LV', 4, 'Get two subordinates to agree about vacation schedules');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.7', 'LV', 7, 'Negotiate a major labor-management contract');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.8', 'LV', 1, 'Tend a highway toll booth');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.8', 'LV', 4, 'Sell shoes in a popular shoe store');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.a.8', 'LV', 6, 'Perform a monologue on national TV');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.1', 'LV', 2, 'Exchange information during a shift change');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.1', 'LV', 4, 'Organize the cleanup crew after a major sporting event');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.1', 'LV', 7, 'Act as general contractor for building a large industrial complex');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.2', 'LV', 1, 'Encourage two coworkers to stick with a tough assignment');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.2', 'LV', 4, 'Lead an assembly team in an automobile plant');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.2', 'LV', 6, 'Lead a large team to design and build a new aircraft');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.3', 'LV', 2, 'Give coworkers brief instructions on a simple procedural change');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.3', 'LV', 4, 'Teach a social sciences course to high school students');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.3', 'LV', 6, 'Develop and conduct training programs for a medical school');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.4', 'LV', 2, 'Work occasionally as a backup supervisor');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.4', 'LV', 4, 'Supervise a small number of subordinates in a well-paid industry');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.4', 'LV', 7, 'Manage a severely downsized unit');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.5', 'LV', 2, 'Show a coworker how to operate a piece of equipment');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.5', 'LV', 4, 'Provide on-the-job training for clerical workers');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.5', 'LV', 6, 'Coach a college athletic team');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.6', 'LV', 1, 'Work in a position that requires little advising of others');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.6', 'LV', 4, 'Recommend a new software package to increase operational efficiency');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.b.6', 'LV', 7, 'Provide ideas for changing an organization to increase profitability');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.c.1', 'LV', 2, 'Complete routine paperwork on standard forms');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.c.1', 'LV', 4, 'Complete tax forms required of self-employed people');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.c.1', 'LV', 6, 'Serve as the benefits director for a large computer sales organization');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.c.2', 'LV', 1, 'Work in a position that has minimal staffing requirements');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.c.2', 'LV', 4, 'Interview candidates for a sales position and make hiring recommendations');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.c.2', 'LV', 7, 'Direct a large recruiting and employment program for a large international manufacturing organization');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.c.3', 'LV', 2, 'Work as a housekeeper responsible for keeping track of linens');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.c.3', 'LV', 4, 'Work as a chef responsible for ordering food for the menu');
INSERT INTO level_scale_anchors (element_id, scale_id, anchor_value, anchor_description) VALUES ('4.A.4.c.3', 'LV', 6, 'Serve as a financial executive in charge of a large company''s budget');
GO

