CREATE TABLE occupation_data (
  onetsoc_code CHARACTER(10) NOT NULL,
  title CHARACTER VARYING(150) NOT NULL,
  description CHARACTER VARYING(1000) NOT NULL,
  PRIMARY KEY (onetsoc_code));
GO

INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-1011.00', 'Chief Executives', 'Determine and formulate policies and provide overall direction of companies or private and public sector organizations within guidelines set up by a board of directors or similar governing body. Plan, direct, or coordinate operational activities at the highest level of management with the help of subordinate executives and staff managers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-1011.03', 'Chief Sustainability Officers', 'Communicate and coordinate with management, shareholders, customers, and employees to address sustainability issues. Enact or oversee a corporate sustainability strategy.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-1021.00', 'General and Operations Managers', 'Plan, direct, or coordinate the operations of public or private sector organizations. Duties and responsibilities include formulating policies, managing daily operations, and planning the use of materials and human resources, but are too diverse and general in nature to be classified in any one functional area of management or administration, such as personnel, purchasing, or administrative services.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-1031.00', 'Legislators', 'Develop, introduce or enact laws and statutes at the local, tribal, State, or Federal level. Includes only workers in elected positions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-2011.00', 'Advertising and Promotions Managers', 'Plan, direct, or coordinate advertising policies and programs or produce collateral materials, such as posters, contests, coupons, or give-aways, to create extra interest in the purchase of a product or service for a department, an entire organization, or on an account basis.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-2011.01', 'Green Marketers', 'Create and implement methods to market green products and services.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-2021.00', 'Marketing Managers', 'Plan, direct, or coordinate marketing policies and programs, such as determining the demand for products and services offered by a firm and its competitors, and identify potential customers. Develop pricing strategies with the goal of maximizing the firm''s profits or share of the market while ensuring the firm''s customers are satisfied. Oversee product development or monitor trends that indicate the need for new products and services.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-2022.00', 'Sales Managers', 'Plan, direct, or coordinate the actual distribution or movement of a product or service to the customer. Coordinate sales distribution by establishing sales territories, quotas, and goals and establish training programs for sales representatives. Analyze sales statistics gathered by staff to determine sales potential and inventory requirements and monitor the preferences of customers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-2031.00', 'Public Relations and Fundraising Managers', 'Plan, direct, or coordinate activities designed to create or maintain a favorable public image or raise issue awareness for their organization or client; or if engaged in fundraising, plan, direct, or coordinate activities to solicit and maintain funds for special projects or nonprofit organizations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3011.00', 'Administrative Services Managers', 'Plan, direct, or coordinate one or more administrative services of an organization, such as records and information management, mail distribution, facilities planning and maintenance, custodial operations, and other office support services.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3021.00', 'Computer and Information Systems Managers', 'Plan, direct, or coordinate activities in such fields as electronic data processing, information systems, systems analysis, and computer programming.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3031.00', 'Financial Managers', 'Plan, direct, or coordinate accounting, investing, banking, insurance, securities, and other financial activities of a branch, office, or department of an establishment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3031.01', 'Treasurers and Controllers', 'Direct financial activities, such as planning, procurement, and investments for all or part of an organization.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3031.02', 'Financial Managers, Branch or Department', 'Direct and coordinate financial activities of workers in a branch, office, or department of an establishment, such as branch bank, brokerage firm, risk and insurance department, or credit department.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3051.00', 'Industrial Production Managers', 'Plan, direct, or coordinate the work activities and resources necessary for manufacturing products in accordance with cost, quality, and quantity specifications.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3051.01', 'Quality Control Systems Managers', 'Plan, direct, or coordinate quality assurance programs. Formulate quality control policies and control quality of laboratory and production efforts.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3051.02', 'Geothermal Production Managers', 'Manage operations at geothermal power generation facilities. Maintain and monitor geothermal plant equipment for efficient and safe plant operations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3051.03', 'Biofuels Production Managers', 'Manage biofuels production and plant operations. Collect and process information on plant production and performance, diagnose problems, and design corrective procedures.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3051.04', 'Biomass Power Plant Managers', 'Manage operations at biomass power generation facilities. Direct work activities at plant, including supervision of operations and maintenance staff.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3051.05', 'Methane/Landfill Gas Collection System Operators', 'Direct daily operations, maintenance, or repair of landfill gas projects, including maintenance of daily logs, determination of service priorities, and compliance with reporting requirements.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3051.06', 'Hydroelectric Production Managers', 'Manage operations at hydroelectric power generation facilities. Maintain and monitor hydroelectric plant equipment for efficient and safe plant operations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3061.00', 'Purchasing Managers', 'Plan, direct, or coordinate the activities of buyers, purchasing officers, and related workers involved in purchasing materials, products, and services. Includes wholesale or retail trade merchandising managers and procurement managers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3071.00', 'Transportation, Storage, and Distribution Managers', 'Plan, direct, or coordinate transportation, storage, or distribution activities in accordance with organizational policies and applicable government laws or regulations. Includes logistics managers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3071.01', 'Transportation Managers', 'Plan, direct, or coordinate the transportation operations within an organization or the activities of organizations that provide transportation services.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3071.02', 'Storage and Distribution Managers', 'Plan, direct, or coordinate the storage or distribution operations within an organization or the activities of organizations that are engaged in storing or distributing materials or products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3071.03', 'Logistics Managers', 'Plan, direct, or coordinate purchasing, warehousing, distribution, forecasting, customer service, or planning services. Manage logistics personnel and logistics systems and direct daily operations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3111.00', 'Compensation and Benefits Managers', 'Plan, direct, or coordinate compensation and benefits activities of an organization.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3121.00', 'Human Resources Managers', 'Plan, direct, or coordinate human resources activities and staff of an organization.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-3131.00', 'Training and Development Managers', 'Plan, direct, or coordinate the training and development activities and staff of an organization.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9013.00', 'Farmers, Ranchers, and Other Agricultural Managers', 'Plan, direct, or coordinate the management or operation of farms, ranches, greenhouses, aquacultural operations, nurseries, timber tracts, or other agricultural establishments. May hire, train, and supervise farm workers or contract for services to carry out the day-to-day activities of the managed operation. May engage in or supervise planting, cultivating, harvesting, and financial and marketing activities.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9013.01', 'Nursery and Greenhouse Managers', 'Plan, organize, direct, control, and coordinate activities of workers engaged in propagating, cultivating, and harvesting horticultural specialties, such as trees, shrubs, flowers, mushrooms, and other plants.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9013.02', 'Farm and Ranch Managers', 'Plan, direct, or coordinate the management or operation of farms, ranches, greenhouses, aquacultural operations, nurseries, timber tracts, or other agricultural establishments. May hire, train, or supervise farm workers or contract for services to carry out the day-to-day activities of the managed operation. May engage in or supervise planting, cultivating, harvesting, financial, or marketing activities.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9013.03', 'Aquacultural Managers', 'Direct and coordinate, through subordinate supervisory personnel, activities of workers engaged in fish hatchery production for corporations, cooperatives, or other owners.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9021.00', 'Construction Managers', 'Plan, direct, or coordinate, usually through subordinate supervisory personnel, activities concerned with the construction and maintenance of structures, facilities, and systems. Participate in the conceptual development of a construction project and oversee its organization, scheduling, budgeting, and implementation. Includes managers in specialized construction fields, such as carpentry or plumbing.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9031.00', 'Education Administrators, Preschool and Childcare Center/Program', 'Plan, direct, or coordinate the academic and nonacademic activities of preschool and childcare centers or programs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9032.00', 'Education Administrators, Elementary and Secondary School', 'Plan, direct, or coordinate the academic, administrative, or auxiliary activities of public or private elementary or secondary level schools.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9033.00', 'Education Administrators, Postsecondary', 'Plan, direct, or coordinate research, instructional, student administration and services, and other educational activities at postsecondary institutions, including universities, colleges, and junior and community colleges.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9039.00', 'Education Administrators, All Other', 'All education administrators not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9039.01', 'Distance Learning Coordinators', 'Coordinate day-to-day operations of distance learning programs and schedule courses.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9039.02', 'Fitness and Wellness Coordinators', 'Manage or coordinate fitness and wellness programs and services. Manage and train staff of wellness specialists, health educators, or fitness instructors.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9041.00', 'Architectural and Engineering Managers', 'Plan, direct, or coordinate activities in such fields as architecture and engineering or research and development in these fields.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9041.01', 'Biofuels/Biodiesel Technology and Product Development Managers', 'Define, plan, or execute biofuels/biodiesel research programs that evaluate alternative feedstock and process technologies with near-term commercial potential.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9051.00', 'Food Service Managers', 'Plan, direct, or coordinate activities of an organization or department that serves food and beverages.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9061.00', 'Funeral Service Managers', 'Plan, direct, or coordinate the services or resources of funeral homes. Includes activities such as determining prices for services or merchandise and managing the facilities of funeral homes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9071.00', 'Gaming Managers', 'Plan, direct, or coordinate gaming operations in a casino. May formulate house rules.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9081.00', 'Lodging Managers', 'Plan, direct, or coordinate activities of an organization or department that provides lodging and other accommodations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9111.00', 'Medical and Health Services Managers', 'Plan, direct, or coordinate medical and health services in hospitals, clinics, managed care organizations, public health agencies, or similar organizations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9121.00', 'Natural Sciences Managers', 'Plan, direct, or coordinate activities in such fields as life sciences, physical sciences, mathematics, statistics, and research and development in these fields.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9121.01', 'Clinical Research Coordinators', 'Plan, direct, or coordinate clinical research projects. Direct the activities of workers engaged in clinical research projects to ensure compliance with protocols and overall clinical objectives. May evaluate and analyze clinical data.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9121.02', 'Water Resource Specialists', 'Design or implement programs and strategies related to water resource issues such as supply, quality, and regulatory compliance issues.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9131.00', 'Postmasters and Mail Superintendents', 'Plan, direct, or coordinate operational, administrative, management, and supportive services of a U.S. post office; or coordinate activities of workers engaged in postal and related work in assigned post office.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9141.00', 'Property, Real Estate, and Community Association Managers', 'Plan, direct, or coordinate the selling, buying, leasing, or governance activities of commercial, industrial, or residential real estate properties. Includes managers of homeowner and condominium associations, rented or leased housing units, buildings, or land (including rights-of-way).');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9151.00', 'Social and Community Service Managers', 'Plan, direct, or coordinate the activities of a social service program or community outreach organization. Oversee the program or organization''s budget and policies regarding participant involvement, program requirements, and benefits. Work may involve directing social workers, counselors, or probation officers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9161.00', 'Emergency Management Directors', 'Plan and direct disaster response or crisis management activities, provide disaster preparedness training, and prepare emergency plans and procedures for natural (e.g., hurricanes, floods, earthquakes), wartime, or technological (e.g., nuclear power plant emergencies or hazardous materials spills) disasters or hostage situations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9199.00', 'Managers, All Other', 'All managers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9199.01', 'Regulatory Affairs Managers', 'Plan, direct, or coordinate production activities of an organization to ensure compliance with regulations and standard operating procedures.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9199.02', 'Compliance Managers', 'Plan, direct, or coordinate activities of an organization to ensure compliance with ethical or regulatory standards.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9199.03', 'Investment Fund Managers', 'Plan, direct, or coordinate investment strategy or operations for a large pool of liquid assets supplied by institutional investors or individual investors.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9199.04', 'Supply Chain Managers', 'Direct or coordinate production, purchasing, warehousing, distribution, or financial forecasting services or activities to limit costs and improve accuracy, customer service, or safety. Examine existing procedures or opportunities for streamlining activities to meet product distribution needs. Direct the movement, storage, or processing of inventory.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9199.07', 'Security Managers', 'Direct an organization''s security functions, including physical security and safety of employees, facilities, and assets.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9199.08', 'Loss Prevention Managers', 'Plan and direct policies, procedures, or systems to prevent the loss of assets. Determine risk exposure or potential liability, and develop risk control measures.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9199.09', 'Wind Energy Operations Managers', 'Manage wind field operations, including personnel, maintenance activities, financial activities, and planning.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9199.10', 'Wind Energy Project Managers', 'Lead or manage the development and evaluation of potential wind energy business opportunities, including environmental studies, permitting, and proposals. May also manage construction of projects.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('11-9199.11', 'Brownfield Redevelopment Specialists and Site Managers', 'Plan and direct cleanup and redevelopment of contaminated properties for reuse. Does not include properties sufficiently contaminated to qualify as Superfund sites.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1011.00', 'Agents and Business Managers of Artists, Performers, and Athletes', 'Represent and promote artists, performers, and athletes in dealings with current or prospective employers. May handle contract negotiation and other business matters for clients.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1021.00', 'Buyers and Purchasing Agents, Farm Products', 'Purchase farm products either for further processing or resale. Includes tree farm contractors, grain brokers and market operators, grain buyers, and tobacco buyers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1022.00', 'Wholesale and Retail Buyers, Except Farm Products', 'Buy merchandise or commodities, other than farm products, for resale to consumers at the wholesale or retail level, including both durable and nondurable goods. Analyze past buying trends, sales records, price, and quality of merchandise to determine value and yield. Select, order, and authorize payment for merchandise according to contractual agreements. May conduct meetings with sales personnel and introduce new products. Includes assistant wholesale and retail buyers of nonfarm products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1023.00', 'Purchasing Agents, Except Wholesale, Retail, and Farm Products', 'Purchase machinery, equipment, tools, parts, supplies, or services necessary for the operation of an establishment. Purchase raw or semi-finished materials for manufacturing.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1031.00', 'Claims Adjusters, Examiners, and Investigators', 'Review settled claims to determine that payments and settlements are made in accordance with company practices and procedures. Confer with legal counsel on claims requiring litigation. May also settle insurance claims.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1031.01', 'Claims Examiners, Property and Casualty Insurance', 'Review settled insurance claims to determine that payments and settlements have been made in accordance with company practices and procedures. Report overpayments, underpayments, and other irregularities. Confer with legal counsel on claims requiring litigation.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1031.02', 'Insurance Adjusters, Examiners, and Investigators', 'Investigate, analyze, and determine the extent of insurance company''s liability concerning personal, casualty, or property loss or damages, and attempt to effect settlement with claimants. Correspond with or interview medical specialists, agents, witnesses, or claimants to compile information. Calculate benefit payments and approve payment of claims within a certain monetary limit.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1032.00', 'Insurance Appraisers, Auto Damage', 'Appraise automobile or other vehicle damage to determine repair costs for insurance claim settlement. Prepare insurance forms to indicate repair cost or cost estimates and recommendations. May seek agreement with automotive repair shop on repair costs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1041.00', 'Compliance Officers', 'Examine, evaluate, and investigate eligibility for or conformity with laws and regulations governing contract compliance of licenses and permits, and perform other compliance and enforcement inspection and analysis activities not classified elsewhere.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1041.01', 'Environmental Compliance Inspectors', 'Inspect and investigate sources of pollution to protect the public and environment and ensure conformance with Federal, State, and local regulations and ordinances.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1041.02', 'Licensing Examiners and Inspectors', 'Examine, evaluate, and investigate eligibility for, conformity with, or liability under licenses or permits.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1041.03', 'Equal Opportunity Representatives and Officers', 'Monitor and evaluate compliance with equal opportunity laws, guidelines, and policies to ensure that employment practices and contracting arrangements give equal opportunity without regard to race, religion, color, national origin, sex, age, or disability.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1041.04', 'Government Property Inspectors and Investigators', 'Investigate or inspect government property to ensure compliance with contract agreements and government regulations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1041.06', 'Coroners', 'Direct activities such as autopsies, pathological and toxicological analyses, and inquests relating to the investigation of deaths occurring within a legal jurisdiction to determine cause of death or to fix responsibility for accidental, violent, or unexplained deaths.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1041.07', 'Regulatory Affairs Specialists', 'Coordinate and document internal regulatory processes, such as internal audits, inspections, license renewals, or registrations. May compile and prepare materials for submission to regulatory agencies.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1051.00', 'Cost Estimators', 'Prepare cost estimates for product manufacturing, construction projects, or services to aid management in bidding on or determining price of product or service. May specialize according to particular service performed or type of product manufactured.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1071.00', 'Human Resources Specialists', 'Perform activities in the human resource area. Includes employment specialists who screen, recruit, interview, and place workers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1074.00', 'Farm Labor Contractors', 'Recruit and hire seasonal or temporary agricultural laborers. May transport, house, and provide meals for workers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1075.00', 'Labor Relations Specialists', 'Resolve disputes between workers and managers, negotiate collective bargaining agreements, or coordinate grievance procedures to handle employee complaints.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1081.00', 'Logisticians', 'Analyze and coordinate the logistical functions of a firm or organization. Responsible for the entire life cycle of a product, including acquisition, distribution, internal allocation, delivery, and final disposal of resources.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1081.01', 'Logistics Engineers', 'Design or analyze operational solutions for projects such as transportation optimization, network modeling, process and methods analysis, cost containment, capacity enhancement, routing and shipment optimization, or information management.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1081.02', 'Logistics Analysts', 'Analyze product delivery or supply chain processes to identify or recommend changes. May manage route activity including invoicing, electronic bills, and shipment tracing.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1111.00', 'Management Analysts', 'Conduct organizational studies and evaluations, design systems and procedures, conduct work simplification and measurement studies, and prepare operations and procedures manuals to assist management in operating more efficiently and effectively. Includes program analysts and management consultants.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1121.00', 'Meeting, Convention, and Event Planners', 'Coordinate activities of staff, convention personnel, or clients to make arrangements for group meetings, events, or conventions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1131.00', 'Fundraisers', 'Organize activities to raise funds or otherwise solicit and gather monetary donations or other gifts for an organization. May design and produce promotional materials. May also raise awareness of the organization''s work, goals, and financial needs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1141.00', 'Compensation, Benefits, and Job Analysis Specialists', 'Conduct programs of compensation and benefits and job analysis for employer. May specialize in specific areas, such as position classification and pension programs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1151.00', 'Training and Development Specialists', 'Design and conduct training and development programs to improve individual and organizational performance. May analyze training needs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1161.00', 'Market Research Analysts and Marketing Specialists', 'Research market conditions in local, regional, or national areas, or gather information to determine potential sales of a product or service, or create a marketing campaign. May gather information on competitors, prices, sales, and methods of marketing and distribution.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1199.00', 'Business Operations Specialists, All Other', 'All business operations specialists not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1199.01', 'Energy Auditors', 'Conduct energy audits of buildings, building systems, or process systems. May also conduct investment grade audits of buildings or systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1199.02', 'Security Management Specialists', 'Conduct security assessments for organizations, and design security systems and processes. May specialize in areas such as physical security, personnel security, and information security. May work in fields such as health care, banking, gaming, security engineering, or manufacturing.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1199.03', 'Customs Brokers', 'Prepare customs documentation and ensure that shipments meet all applicable laws to facilitate the import and export of goods. Determine and track duties and taxes payable and process payments on behalf of client. Sign documents under a power of attorney. Represent clients in meetings with customs officials and apply for duty refunds and tariff reclassifications. Coordinate transportation and storage of imported goods.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1199.04', 'Business Continuity Planners', 'Develop, maintain, or implement business continuity and disaster recovery strategies and solutions, including risk assessments, business impact analyses, strategy selection, and documentation of business continuity and disaster recovery procedures. Plan, conduct, and debrief regular mock-disaster exercises to test the adequacy of existing plans and strategies, updating procedures and plans regularly. Act as a coordinator for continuity efforts after a disruption event.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1199.05', 'Sustainability Specialists', 'Address organizational sustainability issues, such as waste stream management, green building practices, and green procurement plans.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-1199.06', 'Online Merchants', 'Conduct retail activities of businesses operating exclusively online. May perform duties such as preparing business strategies, buying merchandise, managing inventory, implementing marketing activities, fulfilling and shipping online orders, and balancing financial records.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2011.00', 'Accountants and Auditors', 'Examine, analyze, and interpret accounting records to prepare financial statements, give advice, or audit and evaluate statements prepared by others. Install or advise on systems of recording costs or other financial and budgetary data.');
GO
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2011.01', 'Accountants', 'Analyze financial information and prepare financial reports to determine or maintain record of assets, liabilities, profit and loss, tax liability, or other financial activities within an organization.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2011.02', 'Auditors', 'Examine and analyze accounting records to determine financial status of establishment and prepare financial reports concerning operating procedures.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2021.00', 'Appraisers and Assessors of Real Estate', 'Appraise real property and estimate its fair value. May assess taxes in accordance with prescribed schedules.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2021.01', 'Assessors', 'Appraise real and personal property to determine its fair value. May assess taxes in accordance with prescribed schedules.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2021.02', 'Appraisers, Real Estate', 'Appraise real property to determine its value for purchase, sales, investment, mortgage, or loan purposes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2031.00', 'Budget Analysts', 'Examine budget estimates for completeness, accuracy, and conformance with procedures and regulations. Analyze budgeting and accounting reports.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2041.00', 'Credit Analysts', 'Analyze credit data and financial statements of individuals or firms to determine the degree of risk involved in extending credit or lending money. Prepare reports with credit information for use in decision making.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2051.00', 'Financial Analysts', 'Conduct quantitative analyses of information affecting investment programs of public or private institutions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2052.00', 'Personal Financial Advisors', 'Advise clients on financial plans using knowledge of tax and investment strategies, securities, insurance, pension plans, and real estate. Duties include assessing clients'' assets, liabilities, cash flow, insurance coverage, tax status, and financial objectives.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2053.00', 'Insurance Underwriters', 'Review individual applications for insurance to evaluate degree of risk involved and determine acceptance of applications.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2061.00', 'Financial Examiners', 'Enforce or ensure compliance with laws and regulations governing financial and securities institutions and financial and real estate transactions. May examine, verify, or authenticate records.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2071.00', 'Credit Counselors', 'Advise and educate individuals or organizations on acquiring and managing debt. May provide guidance in determining the best type of loan and explaining loan requirements or restrictions. May help develop debt management plans, advise on credit issues, or provide budget, mortgage, and bankruptcy counseling.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2071.01', 'Loan Counselors', 'Provide guidance to prospective loan applicants who have problems qualifying for traditional loans. Guidance may include determining the best type of loan and explaining loan requirements or restrictions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2072.00', 'Loan Officers', 'Evaluate, authorize, or recommend approval of commercial, real estate, or credit loans. Advise borrowers on financial status and payment methods. Includes mortgage loan officers and agents, collection analysts, loan servicing officers, and loan underwriters.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2081.00', 'Tax Examiners and Collectors, and Revenue Agents', 'Determine tax liability or collect taxes from individuals or business firms according to prescribed laws and regulations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2082.00', 'Tax Preparers', 'Prepare tax returns for individuals or small businesses.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2099.00', 'Financial Specialists, All Other', 'All financial specialists not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2099.01', 'Financial Quantitative Analysts', 'Develop quantitative financial products used to inform individuals or financial institutions engaged in saving, lending, investing, borrowing, or managing risk. Investigate methods for financial analysis to create mathematical models used to develop improved analytical tools or advanced financial investment instruments.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2099.02', 'Risk Management Specialists', 'Analyze and manage risk management issues by identifying, measuring, and making decisions on operational or enterprise risks for an organization.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2099.03', 'Investment Underwriters', 'Manage communications or negotiations between corporate issuers of securities and clients regarding private equity investments. Underwrite the issuance of securities to provide capital for client growth. Negotiate and structure the terms of mergers or acquisitions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('13-2099.04', 'Fraud Examiners, Investigators and Analysts', 'Obtain evidence, take statements, produce reports, and testify to findings regarding resolution of fraud allegations. May coordinate fraud detection and prevention activities.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1111.00', 'Computer and Information Research Scientists', 'Conduct research into fundamental computer and information science as theorists, designers, or inventors. Develop solutions to problems in the field of computer hardware and software.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1121.00', 'Computer Systems Analysts', 'Analyze science, engineering, business, and other data processing problems to implement and improve computer systems. Analyze user requirements, procedures, and problems to automate or improve existing systems and review computer system capabilities, workflow, and scheduling limitations. May analyze or recommend commercially available software.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1121.01', 'Informatics Nurse Specialists', 'Apply knowledge of nursing and informatics to assist in the design, development, and ongoing modification of computerized health care systems. May educate staff and assist in problem solving to promote the implementation of the health care system.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1122.00', 'Information Security Analysts', 'Plan, implement, upgrade, or monitor security measures for the protection of computer networks and information. May ensure appropriate security controls are in place that will safeguard digital files and vital electronic infrastructure. May respond to computer security breaches and viruses.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1131.00', 'Computer Programmers', 'Create, modify, and test the code, forms, and script that allow computer applications to run. Work from specifications drawn up by software developers or other individuals. May assist software developers by analyzing user needs and designing software solutions. May develop and write computer programs to store, locate, and retrieve specific documents, data, and information.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1132.00', 'Software Developers, Applications', 'Develop, create, and modify general computer applications software or specialized utility programs. Analyze user needs and develop software solutions. Design software or customize software for client use with the aim of optimizing operational efficiency. May analyze and design databases within an application area, working individually or coordinating database development as part of a team. May supervise computer programmers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1133.00', 'Software Developers, Systems Software', 'Research, design, develop, and test operating systems-level software, compilers, and network distribution software for medical, industrial, military, communications, aerospace, business, scientific, and general computing applications. Set operational specifications and formulate and analyze software requirements. May design embedded systems software. Apply principles and techniques of computer science, engineering, and mathematical analysis.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1134.00', 'Web Developers', 'Design, create, and modify Web sites. Analyze user needs to implement Web site content, graphics, performance, and capacity. May integrate Web sites with other computer applications. May convert written, graphic, audio, and video components to compatible Web formats by using software designed to facilitate the creation of Web and multimedia content.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1141.00', 'Database Administrators', 'Administer, test, and implement computer databases, applying knowledge of database management systems. Coordinate changes to computer databases. May plan, coordinate, and implement security measures to safeguard computer databases.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1142.00', 'Network and Computer Systems Administrators', 'Install, configure, and support an organization''s local area network (LAN), wide area network (WAN), and Internet systems or a segment of a network system. Monitor network to ensure network availability to all system users and may perform necessary maintenance to support network availability. May monitor and test Web site performance to ensure Web sites operate correctly and without interruption. May assist in network modeling, analysis, planning, and coordination between network and data communications hardware and software. May supervise computer user support specialists and computer network support specialists. May administer network security measures.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1143.00', 'Computer Network Architects', 'Design and implement computer and information networks, such as local area networks (LAN), wide area networks (WAN), intranets, extranets, and other data communications networks. Perform network modeling, analysis, and planning. May also design network and computer security measures. May research and recommend network and data communications hardware and software.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1143.01', 'Telecommunications Engineering Specialists', 'Design or configure voice, video, and data communications systems. Supervise installation and post-installation service and maintenance.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1151.00', 'Computer User Support Specialists', 'Provide technical assistance to computer users. Answer questions or resolve computer problems for clients in person, or via telephone or electronically. May provide assistance concerning the use of computer hardware and software, including printing, installation, word processing, electronic mail, and operating systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1152.00', 'Computer Network Support Specialists', 'Analyze, test, troubleshoot, and evaluate existing network systems, such as local area network (LAN), wide area network (WAN), and Internet systems or a segment of a network system. Perform network maintenance to ensure networks operate correctly with minimal interruption.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1199.00', 'Computer Occupations, All Other', 'All computer occupations not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1199.01', 'Software Quality Assurance Engineers and Testers', 'Develop and execute software test plans in order to identify software problems and their causes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1199.02', 'Computer Systems Engineers/Architects', 'Design and develop solutions to complex applications problems, system administration issues, or network concerns. Perform systems management and integration functions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1199.03', 'Web Administrators', 'Manage web environment design, deployment, development and maintenance activities. Perform testing and quality assurance of web sites and web applications.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1199.04', 'Geospatial Information Scientists and Technologists', 'Research or develop geospatial technologies. May produce databases, perform applications programming, or coordinate projects. May specialize in areas such as agriculture, mining, health care, retail trade, urban planning, or military intelligence.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1199.05', 'Geographic Information Systems Technicians', 'Assist scientists, technologists, or related professionals in building, maintaining, modifying, or using geographic information systems (GIS) databases. May also perform some custom application development or provide user support.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1199.06', 'Database Architects', 'Design strategies for enterprise database systems and set standards for operations, programming, and security. Design and construct large relational databases. Integrate new systems with existing warehouse structure and refine system performance and functionality.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1199.07', 'Data Warehousing Specialists', 'Design, model, or implement corporate data warehousing activities. Program and configure warehouses of database information and provide support to warehouse users.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1199.08', 'Business Intelligence Analysts', 'Produce financial and market intelligence by querying data repositories and generating periodic reports. Devise methods for identifying data patterns and trends in available information sources.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1199.09', 'Information Technology Project Managers', 'Plan, initiate, and manage information technology (IT) projects. Lead and guide the work of technical staff. Serve as liaison between business and technical aspects of projects. Plan project stages and assess business implications for each stage. Monitor progress to assure deadlines, standards, and cost targets are met.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1199.10', 'Search Marketing Strategists', 'Employ search marketing tactics to increase visibility and engagement with content, products, or services in Internet-enabled devices or interfaces. Examine search query behaviors on general or specialty search engines or other Internet-based content. Analyze research, data, or technology to understand user intent and measure outcomes for ongoing optimization.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1199.11', 'Video Game Designers', 'Design core features of video games. Specify innovative game and role-play mechanics, story lines, and character biographies. Create and maintain design documentation. Guide and collaborate with production staff to produce games as designed.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-1199.12', 'Document Management Specialists', 'Implement and administer enterprise-wide document management systems and related procedures that allow organizations to capture, store, retrieve, share, and destroy electronic records and documents.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-2011.00', 'Actuaries', 'Analyze statistical data, such as mortality, accident, sickness, disability, and retirement rates and construct probability tables to forecast risk and liability for payment of future benefits. May ascertain insurance rates required and cash reserves necessary to ensure payment of future benefits.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-2021.00', 'Mathematicians', 'Conduct research in fundamental mathematics or in application of mathematical techniques to science, management, and other fields. Solve problems in various fields using mathematical methods.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-2031.00', 'Operations Research Analysts', 'Formulate and apply mathematical modeling and other optimizing methods to develop and interpret information that assists management with decision making, policy formulation, or other managerial functions. May collect and analyze data and develop decision support software, service, or products. May develop and supply optimal time, cost, or logistics networks for program evaluation, review, or implementation.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-2041.00', 'Statisticians', 'Develop or apply mathematical or statistical theory and methods to collect, organize, interpret, and summarize numerical data to provide usable information. May specialize in fields such as bio-statistics, agricultural statistics, business statistics, or economic statistics. Includes mathematical and survey statisticians.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-2041.01', 'Biostatisticians', 'Develop and apply biostatistical theory and methods to the study of life sciences.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-2041.02', 'Clinical Data Managers', 'Apply knowledge of health care and database management to analyze clinical data, and to identify and report trends.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-2091.00', 'Mathematical Technicians', 'Apply standardized mathematical formulas, principles, and methodology to technological problems in engineering and physical sciences in relation to specific industrial and research objectives, processes, equipment, and products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('15-2099.00', 'Mathematical Science Occupations, All Other', 'All mathematical scientists not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-1011.00', 'Architects, Except Landscape and Naval', 'Plan and design structures, such as private residences, office buildings, theaters, factories, and other structural property.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-1012.00', 'Landscape Architects', 'Plan and design land areas for projects such as parks and other recreational facilities, airports, highways, hospitals, schools, land subdivisions, and commercial, industrial, and residential sites.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-1021.00', 'Cartographers and Photogrammetrists', 'Collect, analyze, and interpret geographic information provided by geodetic surveys, aerial photographs, and satellite data. Research, study, and prepare maps and other spatial data in digital or graphic form for legal, social, political, educational, and design purposes. May work with Geographic Information Systems (GIS). May design and evaluate algorithms, data structures, and user interfaces for GIS and mapping systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-1022.00', 'Surveyors', 'Make exact measurements and determine property boundaries. Provide data relevant to the shape, contour, gravitation, location, elevation, or dimension of land or land features on or near the earth''s surface for engineering, mapmaking, mining, land evaluation, construction, and other purposes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-1022.01', 'Geodetic Surveyors', 'Measure large areas of the Earth''s surface using satellite observations, global navigation satellite systems (GNSS), light detection and ranging (LIDAR), or related sources.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2011.00', 'Aerospace Engineers', 'Perform engineering duties in designing, constructing, and testing aircraft, missiles, and spacecraft. May conduct basic and applied research to evaluate adaptability of materials and equipment to aircraft design and manufacture. May recommend improvements in testing equipment and techniques.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2021.00', 'Agricultural Engineers', 'Apply knowledge of engineering technology and biological science to agricultural problems concerned with power and machinery, electrification, structures, soil and water conservation, and processing of agricultural products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2031.00', 'Biomedical Engineers', 'Apply knowledge of engineering, biology, and biomechanical principles to the design, development, and evaluation of biological and health systems and products, such as artificial organs, prostheses, instrumentation, medical information systems, and health management and care delivery systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2041.00', 'Chemical Engineers', 'Design chemical plant equipment and devise processes for manufacturing chemicals and products, such as gasoline, synthetic rubber, plastics, detergents, cement, paper, and pulp, by applying principles and technology of chemistry, physics, and engineering.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2051.00', 'Civil Engineers', 'Perform engineering duties in planning, designing, and overseeing construction and maintenance of building structures, and facilities, such as roads, railroads, airports, bridges, harbors, channels, dams, irrigation projects, pipelines, power plants, and water and sewage systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2051.01', 'Transportation Engineers', 'Develop plans for surface transportation projects, according to established engineering standards and state or federal construction policy. Prepare designs, specifications, or estimates for transportation facilities. Plan modifications of existing streets, highways, or freeways to improve traffic flow.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2061.00', 'Computer Hardware Engineers', 'Research, design, develop, or test computer or computer-related equipment for commercial, industrial, military, or scientific use. May supervise the manufacturing and installation of computer or computer-related equipment and components.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2071.00', 'Electrical Engineers', 'Research, design, develop, test, or supervise the manufacturing and installation of electrical equipment, components, or systems for commercial, industrial, military, or scientific use.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2072.00', 'Electronics Engineers, Except Computer', 'Research, design, develop, or test electronic components and systems for commercial, industrial, military, or scientific use employing knowledge of electronic theory and materials properties. Design electronic circuits and components for use in fields such as telecommunications, aerospace guidance and propulsion control, acoustics, or instruments and controls.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2072.01', 'Radio Frequency Identification Device Specialists', 'Design and implement radio frequency identification device (RFID) systems used to track shipments or goods.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2081.00', 'Environmental Engineers', 'Research, design, plan, or perform engineering duties in the prevention, control, and remediation of environmental hazards using various engineering disciplines. Work may include waste treatment, site remediation, or pollution control technology.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2081.01', 'Water/Wastewater Engineers', 'Design or oversee projects involving provision of potable water, disposal of wastewater and sewage, or prevention of flood-related damage. Prepare environmental documentation for water resources, regulatory program compliance, data management and analysis, and field work. Perform hydraulic modeling and pipeline design.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2111.00', 'Health and Safety Engineers, Except Mining Safety Engineers and Inspectors', 'Promote worksite or product safety by applying knowledge of industrial processes, mechanics, chemistry, psychology, and industrial health and safety laws. Includes industrial product safety engineers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2111.01', 'Industrial Safety and Health Engineers', 'Plan, implement, and coordinate safety programs, requiring application of engineering principles and technology, to prevent or correct unsafe environmental working conditions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2111.02', 'Fire-Prevention and Protection Engineers', 'Research causes of fires, determine fire protection methods, and design or recommend materials or equipment such as structural components or fire-detection equipment to assist organizations in safeguarding life and property against fire, explosion, and related hazards.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2111.03', 'Product Safety Engineers', 'Develop and conduct tests to evaluate product safety levels and recommend measures to reduce or eliminate hazards.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2112.00', 'Industrial Engineers', 'Design, develop, test, and evaluate integrated systems for managing industrial production processes, including human work factors, quality control, inventory control, logistics and material flow, cost analysis, and production coordination.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2112.01', 'Human Factors Engineers and Ergonomists', 'Design objects, facilities, and environments to optimize human well-being and overall system performance, applying theory, principles, and data regarding the relationship between humans and respective technology. Investigate and analyze characteristics of human behavior and performance as it relates to the use of technology.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2121.00', 'Marine Engineers and Naval Architects', 'Design, develop, and evaluate the operation of marine vessels, ship machinery, and related equipment, such as power supply and propulsion systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2121.01', 'Marine Engineers', 'Design, develop, and take responsibility for the installation of ship machinery and related equipment including propulsion machines and power supply systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2121.02', 'Marine Architects', 'Design and oversee construction and repair of marine craft and floating structures such as ships, barges, tugs, dredges, submarines, torpedoes, floats, and buoys. May confer with marine engineers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2131.00', 'Materials Engineers', 'Evaluate materials and develop machinery and processes to manufacture materials for use in products that must meet specialized design and performance specifications. Develop new uses for known materials. Includes those engineers working with composite materials or specializing in one type of material, such as graphite, metal and metal alloys, ceramics and glass, plastics and polymers, and naturally occurring materials. Includes metallurgists and metallurgical engineers, ceramic engineers, and welding engineers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2141.00', 'Mechanical Engineers', 'Perform engineering duties in planning and designing tools, engines, machines, and other mechanically functioning equipment. Oversee installation, operation, maintenance, and repair of equipment such as centralized heat, gas, water, and steam systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2141.01', 'Fuel Cell Engineers', 'Design, evaluate, modify, or construct fuel cell components or systems for transportation, stationary, or portable applications.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2141.02', 'Automotive Engineers', 'Develop new or improved designs for vehicle structural members, engines, transmissions, or other vehicle systems, using computer-assisted design technology. Direct building, modification, or testing of vehicle or components.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2151.00', 'Mining and Geological Engineers, Including Mining Safety Engineers', 'Conduct sub-surface surveys to identify the characteristics of potential land or mining development sites. May specify the ground support systems, processes and equipment for safe, economical, and environmentally sound extraction or underground construction activities. May inspect areas for unsafe geological conditions, equipment, and working conditions. May design, implement, and coordinate mine safety programs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2161.00', 'Nuclear Engineers', 'Conduct research on nuclear engineering projects or apply principles and theory of nuclear science to problems concerned with release, control, and use of nuclear energy and nuclear waste disposal.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2171.00', 'Petroleum Engineers', 'Devise methods to improve oil and gas extraction and production and determine the need for new or modified tool designs. Oversee drilling and offer technical advice.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2199.00', 'Engineers, All Other', 'All engineers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2199.01', 'Biochemical Engineers', 'Develop usable, tangible products, using knowledge of biology, chemistry, or engineering. Solve problems related to materials, systems, or processes that interact with humans, plants, animals, microorganisms, or biological materials.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2199.02', 'Validation Engineers', 'Design or plan protocols for equipment or processes to produce products meeting internal and external purity, safety, and quality requirements.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2199.03', 'Energy Engineers', 'Design, develop, or evaluate energy-related projects or programs to reduce energy costs or improve energy efficiency during the designing, building, or remodeling stages of construction. May specialize in electrical systems; heating, ventilation, and air-conditioning (HVAC) systems; green buildings; lighting; air quality; or energy procurement.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2199.04', 'Manufacturing Engineers', 'Design, integrate, or improve manufacturing systems or related processes. May work with commercial or industrial designers to refine product designs to increase producibility and decrease costs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2199.05', 'Mechatronics Engineers', 'Research, design, develop, or test automation, intelligent systems, smart devices, or industrial systems control.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2199.06', 'Microsystems Engineers', 'Research, design, develop, or test microelectromechanical systems (MEMS) devices.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2199.07', 'Photonics Engineers', 'Design technologies specializing in light information or light energy, such as laser or fiber optics technology.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2199.08', 'Robotics Engineers', 'Research, design, develop, or test robotic applications.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2199.09', 'Nanosystems Engineers', 'Design, develop, or supervise the production of materials, devices, or systems of unique molecular or macromolecular composition, applying principles of nanoscale physics and electrical, chemical, or biological engineering.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2199.10', 'Wind Energy Engineers', 'Design underground or overhead wind farm collector systems and prepare and develop site specifications.');
GO
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-2199.11', 'Solar Energy Systems Engineers', 'Perform site-specific engineering analysis or evaluation of energy efficiency and solar projects involving residential, commercial, or industrial customers. Design solar domestic hot water and space heating systems for new and existing structures, applying knowledge of structural energy requirements, local climates, solar technology, and thermodynamics.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3011.00', 'Architectural and Civil Drafters', 'Prepare detailed drawings of architectural and structural features of buildings or drawings and topographical relief maps used in civil engineering projects, such as highways, bridges, and public works. Use knowledge of building materials, engineering practices, and mathematics to complete drawings.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3011.01', 'Architectural Drafters', 'Prepare detailed drawings of architectural designs and plans for buildings and structures according to specifications provided by architect.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3011.02', 'Civil Drafters', 'Prepare drawings and topographical and relief maps used in civil engineering projects, such as highways, bridges, pipelines, flood control projects, and water and sewerage control systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3012.00', 'Electrical and Electronics Drafters', 'Prepare wiring diagrams, circuit board assembly diagrams, and layout drawings used for the manufacture, installation, or repair of electrical equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3012.01', 'Electronic Drafters', 'Draw wiring diagrams, circuit board assembly diagrams, schematics, and layout drawings used for manufacture, installation, and repair of electronic equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3012.02', 'Electrical Drafters', 'Develop specifications and instructions for installation of voltage transformers, overhead or underground cables, and related electrical equipment used to conduct electrical energy from transmission lines or high-voltage distribution lines to consumers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3013.00', 'Mechanical Drafters', 'Prepare detailed working diagrams of machinery and mechanical devices, including dimensions, fastening methods, and other engineering information.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3019.00', 'Drafters, All Other', 'All drafters not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3021.00', 'Aerospace Engineering and Operations Technicians', 'Operate, install, calibrate, and maintain integrated computer/communications systems, consoles, simulators, and other data acquisition, test, and measurement instruments and equipment, which are used to launch, track, position, and evaluate air and space vehicles. May record and interpret test data.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3022.00', 'Civil Engineering Technicians', 'Apply theory and principles of civil engineering in planning, designing, and overseeing construction and maintenance of structures and facilities under the direction of engineering staff or physical scientists.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3023.00', 'Electrical and Electronic Engineering Technicians', 'Apply electrical and electronic theory and related knowledge, usually under the direction of engineering staff, to design, build, repair, calibrate, and modify electrical components, circuitry, controls, and machinery for subsequent evaluation and use by engineering staff in making engineering design decisions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3023.01', 'Electronics Engineering Technicians', 'Lay out, build, test, troubleshoot, repair, and modify developmental and production electronic components, parts, equipment, and systems, such as computer equipment, missile control instrumentation, electron tubes, test equipment, and machine tool numerical controls, applying principles and theories of electronics, electrical circuitry, engineering mathematics, electronic and electrical testing, and physics. Usually work under direction of engineering staff.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3023.03', 'Electrical Engineering Technicians', 'Test or modify developmental or operational electrical machinery or electrical control equipment and circuitry in industrial or commercial plants or laboratories. Usually work under direction of engineers or technologists.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3024.00', 'Electro-Mechanical Technicians', 'Operate, test, maintain, or calibrate unmanned, automated, servo-mechanical, or electromechanical equipment. May operate unmanned submarines, aircraft, or other equipment at worksites, such as oil rigs, deep ocean exploration, or hazardous waste removal. May assist engineers in testing and designing robotics equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3024.01', 'Robotics Technicians', 'Build, install, test, or maintain robotic equipment or related automated production systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3025.00', 'Environmental Engineering Technicians', 'Apply theory and principles of environmental engineering to modify, test, and operate equipment and devices used in the prevention, control, and remediation of environmental problems, including waste treatment and site remediation, under the direction of engineering staff or scientist. May assist in the development of environmental remediation devices.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3026.00', 'Industrial Engineering Technicians', 'Apply engineering theory and principles to problems of industrial layout or manufacturing production, usually under the direction of engineering staff. May perform time and motion studies on worker operations in a variety of industries for purposes such as establishing standard production rates or improving efficiency.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3027.00', 'Mechanical Engineering Technicians', 'Apply theory and principles of mechanical engineering to modify, develop, test, or calibrate machinery and equipment under direction of engineering staff or physical scientists.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3027.01', 'Automotive Engineering Technicians', 'Assist engineers in determining the practicality of proposed product design changes and plan and carry out tests on experimental test devices or equipment for performance, durability, or efficiency.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3029.00', 'Engineering Technicians, Except Drafters, All Other', 'All engineering technicians, except drafters, not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3029.01', 'Non-Destructive Testing Specialists', 'Test the safety of structures, vehicles, or vessels using x-ray, ultrasound, fiber optic or related equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3029.02', 'Electrical Engineering Technologists', 'Assist electrical engineers in such activities as process control, electrical power distribution, or instrumentation design. May prepare layouts of electrical transmission or distribution systems, supervise the flow of work, estimate project costs, or participate in research studies.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3029.03', 'Electromechanical Engineering Technologists', 'Assist electromechanical engineers in such activities as computer-based process control, instrumentation, or machine design. May prepare layouts of machinery or equipment, plan the flow of work, conduct statistical studies, or analyze production costs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3029.04', 'Electronics Engineering Technologists', 'Assist electronics engineers in such activities as electronics systems and instrumentation design or digital signal processing.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3029.05', 'Industrial Engineering Technologists', 'Assist industrial engineers in such activities as quality control, inventory control, or material flow methods. May conduct statistical studies or analyze production costs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3029.06', 'Manufacturing Engineering Technologists', 'Develop tools, implement designs, or integrate machinery, equipment, or computer technologies to ensure effective manufacturing processes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3029.07', 'Mechanical Engineering Technologists', 'Assist mechanical engineers in such activities as generation, transmission, or use of mechanical or fluid energy. Prepare layouts of machinery or equipment or plan the flow of work. May conduct statistical studies or analyze production costs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3029.08', 'Photonics Technicians', 'Build, install, test, or maintain optical or fiber optic equipment, such as lasers, lenses, or mirrors, using spectrometers, interferometers, or related equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3029.09', 'Manufacturing Production Technicians', 'Set up, test, and adjust manufacturing machinery or equipment, using any combination of electrical, electronic, mechanical, hydraulic, pneumatic, or computer technologies.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3029.10', 'Fuel Cell Technicians', 'Install, operate, or maintain integrated fuel cell systems in transportation, stationary, or portable applications.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3029.11', 'Nanotechnology Engineering Technologists', 'Implement production processes for nanoscale designs to produce or modify materials, devices, or systems of unique molecular or macromolecular composition. Operate advanced microscopy equipment to manipulate nanoscale objects. Work under the supervision of nanoengineering staff.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3029.12', 'Nanotechnology Engineering Technicians', 'Operate commercial-scale production equipment to produce, test, or modify materials, devices, or systems of molecular or macromolecular composition. Work under the supervision of engineering staff.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3031.00', 'Surveying and Mapping Technicians', 'Perform surveying and mapping duties, usually under the direction of an engineer, surveyor, cartographer, or photogrammetrist to obtain data used for construction, mapmaking, boundary location, mining, or other purposes. May calculate mapmaking information and create maps from source data, such as surveying notes, aerial photography, satellite data, or other maps to show topographical features, political boundaries, and other features. May verify accuracy and completeness of maps.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3031.01', 'Surveying Technicians', 'Adjust and operate surveying instruments, such as the theodolite and electronic distance-measuring equipment, and compile notes, make sketches and enter data into computers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('17-3031.02', 'Mapping Technicians', 'Calculate mapmaking information from field notes, and draw and verify accuracy of topographical maps.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1011.00', 'Animal Scientists', 'Conduct research in the genetics, nutrition, reproduction, growth, and development of domestic farm animals.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1012.00', 'Food Scientists and Technologists', 'Use chemistry, microbiology, engineering, and other sciences to study the principles underlying the processing and deterioration of foods; analyze food content to determine levels of vitamins, fat, sugar, and protein; discover new food sources; research ways to make processed foods safe, palatable, and healthful; and apply food science knowledge to determine best ways to process, package, preserve, store, and distribute food.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1013.00', 'Soil and Plant Scientists', 'Conduct research in breeding, physiology, production, yield, and management of crops and agricultural plants or trees, shrubs, and nursery stock, their growth in soils, and control of pests; or study the chemical, physical, biological, and mineralogical composition of soils as they relate to plant or crop growth. May classify and map soils and investigate effects of alternative practices on soil and crop productivity.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1020.01', 'Biologists', 'Research or study basic principles of plant and animal life, such as origin, relationship, development, anatomy, and functions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1021.00', 'Biochemists and Biophysicists', 'Study the chemical composition or physical principles of living cells and organisms, their electrical and mechanical energy, and related phenomena. May conduct research to further understanding of the complex chemical combinations and reactions involved in metabolism, reproduction, growth, and heredity. May determine the effects of foods, drugs, serums, hormones, and other substances on tissues and vital processes of living organisms.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1022.00', 'Microbiologists', 'Investigate the growth, structure, development, and other characteristics of microscopic organisms, such as bacteria, algae, or fungi. Includes medical microbiologists who study the relationship between organisms and disease or the effects of antibiotics on microorganisms.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1023.00', 'Zoologists and Wildlife Biologists', 'Study the origins, behavior, diseases, genetics, and life processes of animals and wildlife. May specialize in wildlife research and management. May collect and analyze biological data to determine the environmental effects of present and potential use of land and water habitats.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1029.00', 'Biological Scientists, All Other', 'All biological scientists not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1029.01', 'Bioinformatics Scientists', 'Conduct research using bioinformatics theory and methods in areas such as pharmaceuticals, medical technology, biotechnology, computational biology, proteomics, computer information science, biology and medical informatics. May design databases and develop algorithms for processing and analyzing genomic information, or other biological information.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1029.02', 'Molecular and Cellular Biologists', 'Research and study cellular molecules and organelles to understand cell function and organization.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1029.03', 'Geneticists', 'Research and study the inheritance of traits at the molecular, organism or population level. May evaluate or treat patients with genetic disorders.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1031.00', 'Conservation Scientists', 'Manage, improve, and protect natural resources to maximize their use without damaging the environment. May conduct soil surveys and develop plans to eliminate soil erosion or to protect rangelands. May instruct farmers, agricultural production managers, or ranchers in best ways to use crop rotation, contour plowing, or terracing to conserve soil and water; in the number and kind of livestock and forage plants best suited to particular ranges; and in range and farm improvements, such as fencing and reservoirs for stock watering.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1031.01', 'Soil and Water Conservationists', 'Plan or develop coordinated practices for soil erosion control, soil or water conservation, or sound land use.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1031.02', 'Range Managers', 'Research or study range land management practices to provide sustained production of forage, livestock, and wildlife.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1031.03', 'Park Naturalists', 'Plan, develop, and conduct programs to inform public of historical, natural, and scientific features of national, state, or local park.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1032.00', 'Foresters', 'Manage public and private forested lands for economic, recreational, and conservation purposes. May inventory the type, amount, and location of standing timber, appraise the timber''s worth, negotiate the purchase, and draw up contracts for procurement. May determine how to conserve wildlife habitats, creek beds, water quality, and soil stability, and how best to comply with environmental regulations. May devise plans for planting and growing new trees, monitor trees for healthy growth, and determine optimal harvesting schedules.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1041.00', 'Epidemiologists', 'Investigate and describe the determinants and distribution of disease, disability, or health outcomes. May develop the means for prevention and control.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1042.00', 'Medical Scientists, Except Epidemiologists', 'Conduct research dealing with the understanding of human diseases and the improvement of human health. Engage in clinical investigation, research and development, or other related activities. Includes physicians, dentists, public health specialists, pharmacologists, and medical pathologists who primarily conduct research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-1099.00', 'Life Scientists, All Other', 'All life scientists not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-2011.00', 'Astronomers', 'Observe, research, and interpret astronomical phenomena to increase basic knowledge or apply such information to practical problems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-2012.00', 'Physicists', 'Conduct research into physical phenomena, develop theories on the basis of observation and experiments, and devise methods to apply physical laws and theories.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-2021.00', 'Atmospheric and Space Scientists', 'Investigate atmospheric phenomena and interpret meteorological data, gathered by surface and air stations, satellites, and radar to prepare reports and forecasts for public and other uses. Includes weather analysts and forecasters whose functions require the detailed knowledge of meteorology.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-2031.00', 'Chemists', 'Conduct qualitative and quantitative chemical analyses or experiments in laboratories for quality or process control or to develop new products or knowledge.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-2032.00', 'Materials Scientists', 'Research and study the structures and chemical properties of various natural and synthetic or composite materials, including metals, alloys, rubber, ceramics, semiconductors, polymers, and glass. Determine ways to strengthen or combine materials or develop new materials with new or specific properties for use in a variety of products and applications. Includes glass scientists, ceramic scientists, metallurgical scientists, and polymer scientists.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-2041.00', 'Environmental Scientists and Specialists, Including Health', 'Conduct research or perform investigation for the purpose of identifying, abating, or eliminating sources of pollutants or hazards that affect either the environment or the health of the population. Using knowledge of various scientific disciplines, may collect, synthesize, study, report, and recommend action based on data derived from measurements or observations of air, food, soil, water, and other sources.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-2041.01', 'Climate Change Analysts', 'Research and analyze policy developments related to climate change. Make climate-related recommendations for actions such as legislation, awareness campaigns, or fundraising approaches.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-2041.02', 'Environmental Restoration Planners', 'Collaborate with field and biology staff to oversee the implementation of restoration projects and to develop new products. Process and synthesize complex scientific data into practical strategies for restoration, monitoring or management.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-2041.03', 'Industrial Ecologists', 'Apply principles and processes of natural ecosystems to develop models for efficient industrial systems. Use knowledge from the physical and social sciences to maximize effective use of natural resources in the production and use of goods and services. Examine societal issues and their relationship with both technical systems and the environment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-2042.00', 'Geoscientists, Except Hydrologists and Geographers', 'Study the composition, structure, and other physical aspects of the Earth. May use geological, physics, and mathematics knowledge in exploration for oil, gas, minerals, or underground water; or in waste disposal, land reclamation, or other environmental problems. May study the Earth''s internal composition, atmospheres, oceans, and its magnetic, electrical, and gravitational forces. Includes mineralogists, crystallographers, paleontologists, stratigraphers, geodesists, and seismologists.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-2043.00', 'Hydrologists', 'Research the distribution, circulation, and physical properties of underground and surface waters; and study the form and intensity of precipitation, its rate of infiltration into the soil, movement through the earth, and its return to the ocean and atmosphere.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-2099.00', 'Physical Scientists, All Other', 'All physical scientists not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-2099.01', 'Remote Sensing Scientists and Technologists', 'Apply remote sensing principles and methods to analyze data and solve problems in areas such as natural resource management, urban planning, or homeland security. May develop new sensor systems, analytical techniques, or new applications for existing systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3011.00', 'Economists', 'Conduct research, prepare reports, or formulate plans to address economic problems related to the production and distribution of goods and services or monetary and fiscal policy. May collect and process economic and statistical data using sampling techniques and econometric methods.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3011.01', 'Environmental Economists', 'Conduct economic analysis related to environmental protection and use of the natural environment, such as water, air, land, and renewable energy resources. Evaluate and quantify benefits, costs, incentives, and impacts of alternative options using economic principles and statistical techniques.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3022.00', 'Survey Researchers', 'Plan, develop, or conduct surveys. May analyze and interpret the meaning of survey data, determine survey objectives, or suggest or test question wording. Includes social scientists who primarily design questionnaires or supervise survey teams.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3031.00', 'Clinical, Counseling, and School Psychologists', 'Diagnose and treat mental disorders; learning disabilities; and cognitive, behavioral, and emotional problems, using individual, child, family, and group therapies. May design and implement behavior modification programs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3031.01', 'School Psychologists', 'Investigate processes of learning and teaching and develop psychological principles and techniques applicable to educational problems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3031.02', 'Clinical Psychologists', 'Diagnose or evaluate mental and emotional disorders of individuals through observation, interview, and psychological tests, and formulate and administer programs of treatment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3031.03', 'Counseling Psychologists', 'Assess and evaluate individuals'' problems through the use of case history, interview, and observation and provide individual or group counseling services to assist individuals in achieving more effective personal, social, educational, and vocational development and adjustment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3032.00', 'Industrial-Organizational Psychologists', 'Apply principles of psychology to human resources, administration, management, sales, and marketing problems. Activities may include policy planning; employee testing and selection, training and development; and organizational development and analysis. May work with management to organize the work setting to improve worker productivity.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3039.00', 'Psychologists, All Other', 'All psychologists not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3039.01', 'Neuropsychologists and Clinical Neuropsychologists', 'Apply theories and principles of neuropsychology to diagnose and treat disorders of higher cerebral functioning.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3041.00', 'Sociologists', 'Study human society and social behavior by examining the groups and social institutions that people form, as well as various social, religious, political, and business organizations. May study the behavior and interaction of groups, trace their origin and growth, and analyze the influence of group activities on individual members.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3051.00', 'Urban and Regional Planners', 'Develop comprehensive plans and programs for use of land and physical facilities of jurisdictions, such as towns, cities, counties, and metropolitan areas.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3091.00', 'Anthropologists and Archeologists', 'Study the origin, development, and behavior of human beings. May study the way of life, language, or physical characteristics of people in various parts of the world. May engage in systematic recovery and examination of material evidence, such as tools or pottery remaining from past human cultures, in order to determine the history, customs, and living habits of earlier civilizations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3091.01', 'Anthropologists', 'Research, evaluate, and establish public policy concerning the origins of humans; their physical, social, linguistic, and cultural development; and their behavior, as well as the cultures, organizations, and institutions they have created.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3091.02', 'Archeologists', 'Conduct research to reconstruct record of past human life and culture from human remains, artifacts, architectural features, and structures recovered through excavation, underwater recovery, or other means of discovery.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3092.00', 'Geographers', 'Study the nature and use of areas of the Earth''s surface, relating and interpreting interactions of physical and cultural phenomena. Conduct research on physical aspects of a region, including land forms, climates, soils, plants, and animals, and conduct research on the spatial implications of human activities within a given area, including social characteristics, economic activities, and political organization, as well as researching interdependence between regions at scales ranging from local to global.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3093.00', 'Historians', 'Research, analyze, record, and interpret the past as recorded in sources, such as government and institutional records, newspapers and other periodicals, photographs, interviews, films, electronic media, and unpublished manuscripts, such as personal diaries and letters.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3094.00', 'Political Scientists', 'Study the origin, development, and operation of political systems. May study topics, such as public opinion, political decision-making, and ideology. May analyze the structure and operation of governments, as well as various political entities. May conduct public opinion surveys, analyze election results, or analyze public documents.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3099.00', 'Social Scientists and Related Workers, All Other', 'All social scientists and related workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-3099.01', 'Transportation Planners', 'Prepare studies for proposed transportation projects. Gather, compile, and analyze data. Study the use and operation of transportation systems. Develop transportation models or simulations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4011.00', 'Agricultural and Food Science Technicians', 'Work with agricultural and food scientists in food, fiber, and animal research, production, and processing; and assist with animal breeding and nutrition. Conduct tests and experiments to improve yield and quality of crops or to increase the resistance of plants and animals to disease or insects. Includes technicians who assist food scientists or technologists in the research and development of production technology, quality control, packaging, processing, and use of foods.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4011.01', 'Agricultural Technicians', 'Set up or maintain laboratory equipment and collect samples from crops or animals. Prepare specimens or record data to assist scientists in biology or related life science experiments.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4011.02', 'Food Science Technicians', 'Perform standardized qualitative and quantitative tests to determine physical or chemical properties of food or beverage products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4021.00', 'Biological Technicians', 'Assist biological and medical scientists in laboratories. Set up, operate, and maintain laboratory instruments and equipment, monitor experiments, make observations, and calculate and record results. May analyze organic substances, such as blood, food, and drugs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4031.00', 'Chemical Technicians', 'Conduct chemical and physical laboratory tests to assist scientists in making qualitative and quantitative analyses of solids, liquids, and gaseous materials for research and development of new products or processes, quality control, maintenance of environmental standards, and other work involving experimental, theoretical, or practical application of chemistry and related sciences.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4041.00', 'Geological and Petroleum Technicians', 'Assist scientists or engineers in the use of electronic, sonic, or nuclear measuring instruments in both laboratory and production activities to obtain data indicating potential resources such as metallic ore, minerals, gas, coal, or petroleum. Analyze mud and drill cuttings. Chart pressure, temperature, and other characteristics of wells or bore holes. Investigate and collect information leading to the possible discovery of new metallic ore, minerals, gas, coal, or petroleum deposits.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4041.01', 'Geophysical Data Technicians', 'Measure, record, or evaluate geological data, using sonic, electronic, electrical, seismic, or gravity-measuring instruments to prospect for oil or gas. May collect or evaluate core samples or cuttings.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4041.02', 'Geological Sample Test Technicians', 'Test or analyze geological samples, crude oil, or minerals to detect presence of petroleum, gas, or mineral deposits indicating potential for exploration or production or to determine physical or chemical properties to ensure that products meet quality standards.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4051.00', 'Nuclear Technicians', 'Assist nuclear physicists, nuclear engineers, or other scientists in laboratory or production activities. May operate, maintain, or provide quality control for nuclear testing and research equipment. May monitor radiation.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4051.01', 'Nuclear Equipment Operation Technicians', 'Operate equipment used for the release, control, or utilization of nuclear energy to assist scientists in laboratory or production activities.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4051.02', 'Nuclear Monitoring Technicians', 'Collect and test samples to monitor results of nuclear experiments and contamination of humans, facilities, and environment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4061.00', 'Social Science Research Assistants', 'Assist social scientists in laboratory, survey, and other social science research. May help prepare findings for publication and assist in laboratory analysis, quality control, or data management.');
GO
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4061.01', 'City and Regional Planning Aides', 'Compile data from various sources, such as maps, reports, and field and file investigations, for use by city planner in making planning studies.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4091.00', 'Environmental Science and Protection Technicians, Including Health', 'Perform laboratory and field tests to monitor the environment and investigate sources of pollution, including those that affect health, under the direction of an environmental scientist, engineer, or other specialist. May collect samples of gases, soil, water, and other materials for testing.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4092.00', 'Forensic Science Technicians', 'Collect, identify, classify, and analyze physical evidence related to criminal investigations. Perform tests on weapons or substances, such as fiber, hair, and tissue to determine significance to investigation. May testify as expert witnesses on evidence or crime laboratory techniques. May serve as specialists in area of expertise, such as ballistics, fingerprinting, handwriting, or biochemistry.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4093.00', 'Forest and Conservation Technicians', 'Provide technical assistance regarding the conservation of soil, water, forests, or related natural resources. May compile data pertaining to size, content, condition, and other characteristics of forest tracts, under the direction of foresters; or train and lead forest workers in forest propagation, fire prevention and suppression. May assist conservation scientists in managing, improving, and protecting rangelands and wildlife habitats.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4099.00', 'Life, Physical, and Social Science Technicians, All Other', 'All life, physical, and social science technicians not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4099.01', 'Quality Control Analysts', 'Conduct tests to determine quality of raw materials, bulk intermediate and finished products. May conduct stability sample tests.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4099.02', 'Precision Agriculture Technicians', 'Apply geospatial technologies, including geographic information systems (GIS) and Global Positioning System (GPS), to agricultural production or management activities, such as pest scouting, site-specific pesticide application, yield mapping, or variable-rate irrigation. May use computers to develop or analyze maps or remote sensing images to compare physical topography with data on soils, fertilizer, pests, or weather.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('19-4099.03', 'Remote Sensing Technicians', 'Apply remote sensing technologies to assist scientists in areas such as natural resources, urban planning, or homeland security. May prepare flight plans or sensor configurations for flight trips.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-1011.00', 'Substance Abuse and Behavioral Disorder Counselors', 'Counsel and advise individuals with alcohol, tobacco, drug, or other problems, such as gambling and eating disorders. May counsel individuals, families, or groups or engage in prevention programs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-1012.00', 'Educational, Guidance, School, and Vocational Counselors', 'Counsel individuals and provide group educational and vocational guidance services.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-1013.00', 'Marriage and Family Therapists', 'Diagnose and treat mental and emotional disorders, whether cognitive, affective, or behavioral, within the context of marriage and family systems. Apply psychotherapeutic and family systems theories and techniques in the delivery of services to individuals, couples, and families for the purpose of treating such diagnosed nervous and mental disorders.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-1014.00', 'Mental Health Counselors', 'Counsel with emphasis on prevention. Work with individuals and groups to promote optimum mental and emotional health. May help individuals deal with issues associated with addictions and substance abuse; family, parenting, and marital problems; stress management; self-esteem; and aging.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-1015.00', 'Rehabilitation Counselors', 'Counsel individuals to maximize the independence and employability of persons coping with personal, social, and vocational difficulties that result from birth defects, illness, disease, accidents, or the stress of daily life. Coordinate activities for residents of care and treatment facilities. Assess client needs and design and implement rehabilitation programs that may include personal and vocational counseling, training, and job placement.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-1019.00', 'Counselors, All Other', 'All counselors not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-1021.00', 'Child, Family, and School Social Workers', 'Provide social services and assistance to improve the social and psychological functioning of children and their families and to maximize the family well-being and the academic functioning of children. May assist parents, arrange adoptions, and find foster homes for abandoned or abused children. In schools, they address such problems as teenage pregnancy, misbehavior, and truancy. May also advise teachers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-1022.00', 'Healthcare Social Workers', 'Provide individuals, families, and groups with the psychosocial support needed to cope with chronic, acute, or terminal illnesses. Services include advising family care givers, providing patient education and counseling, and making referrals for other services. May also provide care and case management or interventions designed to promote health, prevent disease, and address barriers to access to healthcare.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-1023.00', 'Mental Health and Substance Abuse Social Workers', 'Assess and treat individuals with mental, emotional, or substance abuse problems, including abuse of alcohol, tobacco, and/or other drugs. Activities may include individual and group therapy, crisis intervention, case management, client advocacy, prevention, and education.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-1029.00', 'Social Workers, All Other', 'All social workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-1091.00', 'Health Educators', 'Provide and manage health education programs that help individuals, families, and their communities maximize and maintain healthy lifestyles. Collect and analyze data to identify community needs prior to planning, implementing, monitoring, and evaluating programs designed to encourage healthy lifestyles, policies, and environments. May serve as a resource to assist individuals, other healthcare workers, or the community, and may administer fiscal resources for health education programs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-1092.00', 'Probation Officers and Correctional Treatment Specialists', 'Provide social services to assist in rehabilitation of law offenders in custody or on probation or parole. Make recommendations for actions involving formulation of rehabilitation plan and treatment of offender, including conditional release and education and employment stipulations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-1093.00', 'Social and Human Service Assistants', 'Assist in providing client services in a wide variety of fields, such as psychology, rehabilitation, or social work, including support for families. May assist clients in identifying and obtaining available benefits and social and community services. May assist social workers with developing, organizing, and conducting programs to prevent and resolve problems relevant to substance abuse, human relationships, rehabilitation, or dependent care.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-1094.00', 'Community Health Workers', 'Assist individuals and communities to adopt healthy behaviors. Conduct outreach for medical personnel or health organizations to implement programs in the community that promote, maintain, and improve individual and community health. May provide information on available resources, provide social support and informal counseling, advocate for individuals and community health needs, and provide services such as first aid and blood pressure screening. May collect data to help identify community health needs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-1099.00', 'Community and Social Service Specialists, All Other', 'All community and social service specialists not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-2011.00', 'Clergy', 'Conduct religious worship and perform other spiritual functions associated with beliefs and practices of religious faith or denomination. Provide spiritual and moral guidance and assistance to members.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-2021.00', 'Directors, Religious Activities and Education', 'Plan, direct, or coordinate programs designed to promote the religious education or activities of a denominational group. May provide counseling and guidance relative to marital, health, financial, and religious problems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('21-2099.00', 'Religious Workers, All Other', 'All religious workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('23-1011.00', 'Lawyers', 'Represent clients in criminal and civil litigation and other legal proceedings, draw up legal documents, or manage or advise clients on legal transactions. May specialize in a single area or may practice broadly in many areas of law.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('23-1012.00', 'Judicial Law Clerks', 'Assist judges in court or by conducting research or preparing legal documents.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('23-1021.00', 'Administrative Law Judges, Adjudicators, and Hearing Officers', 'Conduct hearings to recommend or make decisions on claims concerning government programs or other government-related matters. Determine liability, sanctions, or penalties, or recommend the acceptance or rejection of claims or settlements.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('23-1022.00', 'Arbitrators, Mediators, and Conciliators', 'Facilitate negotiation and conflict resolution through dialogue. Resolve conflicts outside of the court system by mutual consent of parties involved.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('23-1023.00', 'Judges, Magistrate Judges, and Magistrates', 'Arbitrate, advise, adjudicate, or administer justice in a court of law. May sentence defendant in criminal cases according to government statutes or sentencing guidelines. May determine liability of defendant in civil cases. May perform wedding ceremonies.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('23-2011.00', 'Paralegals and Legal Assistants', 'Assist lawyers by investigating facts, preparing legal documents, or researching legal precedent. Conduct research to support a legal proceeding, to formulate a defense, or to initiate legal action.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('23-2091.00', 'Court Reporters', 'Use verbatim methods and equipment to capture, store, retrieve, and transcribe pretrial and trial proceedings or other information. Includes stenocaptioners who operate computerized stenographic captioning equipment to provide captions of live or prerecorded broadcasts for hearing-impaired viewers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('23-2093.00', 'Title Examiners, Abstractors, and Searchers', 'Search real estate records, examine titles, or summarize pertinent legal or insurance documents or details for a variety of purposes. May compile lists of mortgages, contracts, and other instruments pertaining to titles by searching public and private records for law firms, real estate agencies, or title insurance companies.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('23-2099.00', 'Legal Support Workers, All Other', 'All legal support workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1011.00', 'Business Teachers, Postsecondary', 'Teach courses in business administration and management, such as accounting, finance, human resources, labor and industrial relations, marketing, and operations research. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1021.00', 'Computer Science Teachers, Postsecondary', 'Teach courses in computer science. May specialize in a field of computer science, such as the design and function of computers or operations and research analysis. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1022.00', 'Mathematical Science Teachers, Postsecondary', 'Teach courses pertaining to mathematical concepts, statistics, and actuarial science and to the application of original and standardized mathematical techniques in solving specific problems and situations. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1031.00', 'Architecture Teachers, Postsecondary', 'Teach courses in architecture and architectural design, such as architectural environmental design, interior architecture/design, and landscape architecture. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1032.00', 'Engineering Teachers, Postsecondary', 'Teach courses pertaining to the application of physical laws and principles of engineering for the development of machines, materials, instruments, processes, and services. Includes teachers of subjects such as chemical, civil, electrical, industrial, mechanical, mineral, and petroleum engineering. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1041.00', 'Agricultural Sciences Teachers, Postsecondary', 'Teach courses in the agricultural sciences. Includes teachers of agronomy, dairy sciences, fisheries management, horticultural sciences, poultry sciences, range management, and agricultural soil conservation. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1042.00', 'Biological Science Teachers, Postsecondary', 'Teach courses in biological sciences. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1043.00', 'Forestry and Conservation Science Teachers, Postsecondary', 'Teach courses in forestry and conservation science. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1051.00', 'Atmospheric, Earth, Marine, and Space Sciences Teachers, Postsecondary', 'Teach courses in the physical sciences, except chemistry and physics. Includes both teachers primarily engaged in teaching, and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1052.00', 'Chemistry Teachers, Postsecondary', 'Teach courses pertaining to the chemical and physical properties and compositional changes of substances. Work may include instruction in the methods of qualitative and quantitative chemical analysis. Includes both teachers primarily engaged in teaching, and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1053.00', 'Environmental Science Teachers, Postsecondary', 'Teach courses in environmental science. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1054.00', 'Physics Teachers, Postsecondary', 'Teach courses pertaining to the laws of matter and energy. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1061.00', 'Anthropology and Archeology Teachers, Postsecondary', 'Teach courses in anthropology or archeology. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1062.00', 'Area, Ethnic, and Cultural Studies Teachers, Postsecondary', 'Teach courses pertaining to the culture and development of an area, an ethnic group, or any other group, such as Latin American studies, women''s studies, or urban affairs. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1063.00', 'Economics Teachers, Postsecondary', 'Teach courses in economics. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1064.00', 'Geography Teachers, Postsecondary', 'Teach courses in geography. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1065.00', 'Political Science Teachers, Postsecondary', 'Teach courses in political science, international affairs, and international relations. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1066.00', 'Psychology Teachers, Postsecondary', 'Teach courses in psychology, such as child, clinical, and developmental psychology, and psychological counseling. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1067.00', 'Sociology Teachers, Postsecondary', 'Teach courses in sociology. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1069.00', 'Social Sciences Teachers, Postsecondary, All Other', 'All postsecondary social sciences teachers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1071.00', 'Health Specialties Teachers, Postsecondary', 'Teach courses in health specialties, in fields such as dentistry, laboratory technology, medicine, pharmacy, public health, therapy, and veterinary medicine.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1072.00', 'Nursing Instructors and Teachers, Postsecondary', 'Demonstrate and teach patient care in classroom and clinical units to nursing students. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1081.00', 'Education Teachers, Postsecondary', 'Teach courses pertaining to education, such as counseling, curriculum, guidance, instruction, teacher education, and teaching English as a second language. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1082.00', 'Library Science Teachers, Postsecondary', 'Teach courses in library science. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1111.00', 'Criminal Justice and Law Enforcement Teachers, Postsecondary', 'Teach courses in criminal justice, corrections, and law enforcement administration. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1112.00', 'Law Teachers, Postsecondary', 'Teach courses in law. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1113.00', 'Social Work Teachers, Postsecondary', 'Teach courses in social work. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1121.00', 'Art, Drama, and Music Teachers, Postsecondary', 'Teach courses in drama, music, and the arts including fine and applied art, such as painting and sculpture, or design and crafts. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1122.00', 'Communications Teachers, Postsecondary', 'Teach courses in communications, such as organizational communications, public relations, radio/television broadcasting, and journalism. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1123.00', 'English Language and Literature Teachers, Postsecondary', 'Teach courses in English language and literature, including linguistics and comparative literature. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1124.00', 'Foreign Language and Literature Teachers, Postsecondary', 'Teach languages and literature courses in languages other than English. Includes teachers of American Sign Language (ASL). Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1125.00', 'History Teachers, Postsecondary', 'Teach courses in human history and historiography. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1126.00', 'Philosophy and Religion Teachers, Postsecondary', 'Teach courses in philosophy, religion, and theology. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1191.00', 'Graduate Teaching Assistants', 'Assist faculty or other instructional staff in postsecondary institutions by performing teaching or teaching-related duties, such as teaching lower level courses, developing teaching materials, preparing and giving examinations, and grading examinations or papers. Graduate teaching assistants must be enrolled in a graduate school program. Graduate assistants who primarily perform non-teaching duties, such as research, should be reported in the occupational category related to the work performed.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1192.00', 'Home Economics Teachers, Postsecondary', 'Teach courses in childcare, family relations, finance, nutrition, and related subjects pertaining to home management. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1193.00', 'Recreation and Fitness Studies Teachers, Postsecondary', 'Teach courses pertaining to recreation, leisure, and fitness studies, including exercise physiology and facilities management. Includes both teachers primarily engaged in teaching and those who do a combination of teaching and research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1194.00', 'Vocational Education Teachers, Postsecondary', 'Teach or instruct vocational or occupational subjects at the postsecondary level (but at less than the baccalaureate) to students who have graduated or left high school. Includes correspondence school, industrial, and commercial instructors; and adult education teachers and instructors who prepare persons to operate industrial machinery and equipment and transportation and communications equipment. Teaching may take place in public or private schools whose primary business is education or in a school associated with an organization whose primary business is other than education.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-1199.00', 'Postsecondary Teachers, All Other', 'All postsecondary teachers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-2011.00', 'Preschool Teachers, Except Special Education', 'Instruct preschool-aged children in activities designed to promote social, physical, and intellectual growth needed for primary school in preschool, day care center, or other child development facility. May be required to hold State certification.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-2012.00', 'Kindergarten Teachers, Except Special Education', 'Teach elemental natural and social science, personal hygiene, music, art, and literature to kindergarten students. Promote physical, mental, and social development. May be required to hold State certification.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-2021.00', 'Elementary School Teachers, Except Special Education', 'Teach students basic academic, social, and other formative skills in public or private schools at the elementary level.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-2022.00', 'Middle School Teachers, Except Special and Career/Technical Education', 'Teach students in one or more subjects in public or private schools at the middle, intermediate, or junior high level, which falls between elementary and senior high school as defined by applicable laws and regulations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-2023.00', 'Career/Technical Education Teachers, Middle School', 'Teach occupational, career and technical, or vocational subjects in public or private schools at the middle, intermediate, or junior high level, which falls between elementary and senior high school as defined by applicable laws and regulations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-2031.00', 'Secondary School Teachers, Except Special and Career/Technical Education', 'Teach students in one or more subjects, such as English, mathematics, or social studies at the secondary level in public or private schools. May be designated according to subject matter specialty.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-2032.00', 'Career/Technical Education Teachers, Secondary School', 'Teach occupational, career and technical, or vocational subjects at the secondary school level in public or private schools.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-2051.00', 'Special Education Teachers, Preschool', 'Teach preschool school subjects to educationally and physically handicapped students. Includes teachers who specialize and work with audibly and visually handicapped students and those who teach basic academic and life processes skills to the mentally impaired.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-2052.00', 'Special Education Teachers, Kindergarten and Elementary School', 'Teach elementary school subjects to educationally and physically handicapped students. Includes teachers who specialize and work with audibly and visually handicapped students and those who teach basic academic and life processes skills to the mentally impaired.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-2053.00', 'Special Education Teachers, Middle School', 'Teach middle school subjects to educationally and physically handicapped students. Includes teachers who specialize and work with audibly and visually handicapped students and those who teach basic academic and life processes skills to the mentally impaired.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-2054.00', 'Special Education Teachers, Secondary School', 'Teach secondary school subjects to educationally and physically handicapped students. Includes teachers who specialize and work with audibly and visually handicapped students and those who teach basic academic and life processes skills to the mentally impaired.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-2059.00', 'Special Education Teachers, All Other', 'All special education teachers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-2059.01', 'Adapted Physical Education Specialists', 'Provide individualized physical education instruction or services to children, youth, or adults with exceptional physical needs due to gross motor developmental delays or other impairments.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-3011.00', 'Adult Basic and Secondary Education and Literacy Teachers and Instructors', 'Teach or instruct out-of-school youths and adults in remedial education classes, preparatory classes for the General Educational Development test, literacy, or English as a Second Language. Teaching may or may not take place in a traditional educational institution.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-3021.00', 'Self-Enrichment Education Teachers', 'Teach or instruct courses other than those that normally lead to an occupational objective or degree. Courses may include self-improvement, nonvocational, and nonacademic subjects. Teaching may or may not take place in a traditional educational institution.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-3099.00', 'Teachers and Instructors, All Other', 'All teachers and instructors not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-3099.02', 'Tutors', 'Provide non-classroom, academic instruction to students on an individual or small-group basis for proactive or remedial purposes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-4011.00', 'Archivists', 'Appraise, edit, and direct safekeeping of permanent records and historically valuable documents. Participate in research activities based on archival materials.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-4012.00', 'Curators', 'Administer collections, such as artwork, collectibles, historic items, or scientific specimens of museums or other institutions. May conduct instructional, research, or public service activities of institution.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-4013.00', 'Museum Technicians and Conservators', 'Restore, maintain, or prepare objects in museum collections for storage, research, or exhibit. May work with specimens such as fossils, skeletal parts, or botanicals; or artifacts, textiles, or art. May identify and record objects or install and arrange them in exhibits. Includes book or document conservators.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-4021.00', 'Librarians', 'Administer libraries and perform related library services. Work in a variety of settings, including public libraries, educational institutions, museums, corporations, government agencies, law firms, non-profit organizations, and healthcare providers. Tasks may include selecting, acquiring, cataloguing, classifying, circulating, and maintaining library materials; and furnishing reference, bibliographical, and readers'' advisory services. May perform in-depth, strategic research, and synthesize, analyze, edit, and filter information. May set up or work with databases and information systems to catalogue and access information.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-4031.00', 'Library Technicians', 'Assist librarians by helping readers in the use of library catalogs, databases, and indexes to locate books and other materials; and by answering questions that require only brief consultation of standard reference. Compile records; sort and shelve books or other media; remove or repair damaged books or other media; register patrons; and check materials in and out of the circulation process. Replace materials in shelving area (stacks) or files. Includes bookmobile drivers who assist with providing services in mobile libraries.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-9011.00', 'Audio-Visual and Multimedia Collections Specialists', 'Prepare, plan, and operate multimedia teaching aids for use in education. May record, catalogue, and file materials.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-9021.00', 'Farm and Home Management Advisors', 'Advise, instruct, and assist individuals and families engaged in agriculture, agricultural-related processes, or home economics activities. Demonstrate procedures and apply research findings to solve problems; and instruct and train in product development, sales, and the use of machinery and equipment to promote general welfare. Includes county agricultural agents, feed and farm management advisors, home economists, and extension service advisors.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-9031.00', 'Instructional Coordinators', 'Develop instructional material, coordinate educational content, and incorporate current technology in specialized fields that provide guidelines to educators and instructors for developing curricula and conducting courses. Includes educational consultants and specialists, and instructional material directors.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-9031.01', 'Instructional Designers and Technologists', 'Develop instructional materials and products and assist in the technology-based redesign of courses. Assist faculty in learning about, becoming proficient in, and applying instructional technology.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-9041.00', 'Teacher Assistants', 'Perform duties that are instructional in nature or deliver direct services to students or parents. Serve in a position for which a teacher has ultimate responsibility for the design and implementation of educational programs and services.');
GO
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('25-9099.00', 'Education, Training, and Library Workers, All Other', 'All education, training, and library workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-1011.00', 'Art Directors', 'Formulate design concepts and presentation approaches for visual communications media, such as print, broadcasting, and advertising. Direct workers engaged in art work or layout design.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-1012.00', 'Craft Artists', 'Create or reproduce hand-made objects for sale and exhibition using a variety of techniques, such as welding, weaving, pottery, and needlecraft.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-1013.00', 'Fine Artists, Including Painters, Sculptors, and Illustrators', 'Create original artwork using any of a wide variety of media and techniques.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-1014.00', 'Multimedia Artists and Animators', 'Create special effects, animation, or other visual images using film, video, computers, or other electronic tools and media for use in products or creations, such as computer games, movies, music videos, and commercials.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-1019.00', 'Artists and Related Workers, All Other', 'All artists and related workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-1021.00', 'Commercial and Industrial Designers', 'Develop and design manufactured products, such as cars, home appliances, and children''s toys. Combine artistic talent with research on product use, marketing, and materials to create the most functional and appealing product design.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-1022.00', 'Fashion Designers', 'Design clothing and accessories. Create original designs or adapt fashion trends.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-1023.00', 'Floral Designers', 'Design, cut, and arrange live, dried, or artificial flowers and foliage.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-1024.00', 'Graphic Designers', 'Design or create graphics to meet specific commercial or promotional needs, such as packaging, displays, or logos. May use a variety of mediums to achieve artistic or decorative effects.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-1025.00', 'Interior Designers', 'Plan, design, and furnish interiors of residential, commercial, or industrial buildings. Formulate design which is practical, aesthetic, and conducive to intended purposes, such as raising productivity, selling merchandise, or improving life style. May specialize in a particular field, style, or phase of interior design.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-1026.00', 'Merchandise Displayers and Window Trimmers', 'Plan and erect commercial displays, such as those in windows and interiors of retail stores and at trade exhibitions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-1027.00', 'Set and Exhibit Designers', 'Design special exhibits and movie, television, and theater sets. May study scripts, confer with directors, and conduct research to determine appropriate architectural styles.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-1029.00', 'Designers, All Other', 'All designers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2011.00', 'Actors', 'Play parts in stage, television, radio, video, motion picture productions, or other settings for entertainment, information, or instruction. Interpret serious or comic role by speech, gesture, and body movement to entertain or inform audience. May dance and sing.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2012.00', 'Producers and Directors', 'Produce or direct stage, television, radio, video, or motion picture productions for entertainment, information, or instruction. Responsible for creative decisions, such as interpretation of script, choice of actors or guests, set design, sound, special effects, and choreography.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2012.01', 'Producers', 'Plan and coordinate various aspects of radio, television, stage, or motion picture production, such as selecting script, coordinating writing, directing and editing, and arranging financing.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2012.02', 'Directors- Stage, Motion Pictures, Television, and Radio', 'Interpret script, conduct rehearsals, and direct activities of cast and technical crew for stage, motion pictures, television, or radio programs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2012.03', 'Program Directors', 'Direct and coordinate activities of personnel engaged in preparation of radio or television station program schedules and programs, such as sports or news.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2012.04', 'Talent Directors', 'Audition and interview performers to select most appropriate talent for parts in stage, television, radio, or motion picture productions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2012.05', 'Technical Directors/Managers', 'Coordinate activities of technical departments, such as taping, editing, engineering, and maintenance, to produce radio or television programs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2021.00', 'Athletes and Sports Competitors', 'Compete in athletic events.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2022.00', 'Coaches and Scouts', 'Instruct or coach groups or individuals in the fundamentals of sports. Demonstrate techniques and methods of participation. May evaluate athletes'' strengths and weaknesses as possible recruits or to improve the athletes'' technique to prepare them for competition. Those required to hold teaching degrees should be reported in the appropriate teaching category.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2023.00', 'Umpires, Referees, and Other Sports Officials', 'Officiate at competitive athletic or sporting events. Detect infractions of rules and decide penalties according to established regulations. Includes all sporting officials, referees, and competition judges.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2031.00', 'Dancers', 'Perform dances. May perform on stage, for on-air broadcasting, or for video recording.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2032.00', 'Choreographers', 'Create new dance routines. Rehearse performance of routines. May direct and stage presentations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2041.00', 'Music Directors and Composers', 'Conduct, direct, plan, and lead instrumental or vocal performances by musical groups, such as orchestras, bands, choirs, and glee clubs. Includes arrangers, composers, choral directors, and orchestrators.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2041.01', 'Music Directors', 'Direct and conduct instrumental or vocal performances by musical groups, such as orchestras or choirs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2041.04', 'Music Composers and Arrangers', 'Write and transcribe musical scores.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2042.00', 'Musicians and Singers', 'Play one or more musical instruments or sing. May perform on stage, for on-air broadcasting, or for sound or video recording.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2042.01', 'Singers', 'Sing songs on stage, radio, television, or motion pictures.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2042.02', 'Musicians, Instrumental', 'Play one or more musical instruments in recital, in accompaniment, or as members of an orchestra, band, or other musical group.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-2099.00', 'Entertainers and Performers, Sports and Related Workers, All Other', 'All entertainers and performers, sports and related workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-3011.00', 'Radio and Television Announcers', 'Speak or read from scripted materials, such as news reports or commercial messages, on radio or television. May announce artist or title of performance, identify station, or interview guests.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-3012.00', 'Public Address System and Other Announcers', 'Make announcements over public address system at sporting or other public events. May act as master of ceremonies or disc jockey at weddings, parties, clubs, or other gathering places.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-3021.00', 'Broadcast News Analysts', 'Analyze, interpret, and broadcast news received from various sources.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-3022.00', 'Reporters and Correspondents', 'Collect and analyze facts about newsworthy events by interview, investigation, or observation. Report and write stories for newspaper, news magazine, radio, or television.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-3031.00', 'Public Relations Specialists', 'Engage in promoting or creating an intended public image for individuals, groups, or organizations. May write or select material for release to various communications media.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-3041.00', 'Editors', 'Plan, coordinate, or edit content of material for publication. May review proposals and drafts for possible publication. Includes technical editors.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-3042.00', 'Technical Writers', 'Write technical materials, such as equipment manuals, appendices, or operating and maintenance instructions. May assist in layout work.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-3043.00', 'Writers and Authors', 'Originate and prepare written material, such as scripts, stories, advertisements, and other material.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-3043.04', 'Copy Writers', 'Write advertising copy for use by publication or broadcast media to promote sale of goods and services.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-3043.05', 'Poets, Lyricists and Creative Writers', 'Create original written works, such as scripts, essays, prose, poetry or song lyrics, for publication or performance.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-3091.00', 'Interpreters and Translators', 'Interpret oral or sign language, or translate written text from one language into another.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-3099.00', 'Media and Communication Workers, All Other', 'All media and communication workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-4011.00', 'Audio and Video Equipment Technicians', 'Set up, or set up and operate audio and video equipment including microphones, sound speakers, video screens, projectors, video monitors, recording equipment, connecting wires and cables, sound and mixing boards, and related electronic equipment for concerts, sports events, meetings and conventions, presentations, and news conferences. May also set up and operate associated spotlights and other custom lighting systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-4012.00', 'Broadcast Technicians', 'Set up, operate, and maintain the electronic equipment used to transmit radio and television programs. Control audio equipment to regulate volume level and quality of sound during radio and television broadcasts. Operate transmitter to broadcast radio or television programs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-4013.00', 'Radio Operators', 'Receive and transmit communications using radiotelephone equipment in accordance with government regulations. May repair equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-4014.00', 'Sound Engineering Technicians', 'Operate machines and equipment to record, synchronize, mix, or reproduce music, voices, or sound effects in sporting arenas, theater productions, recording studios, or movie and video productions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-4021.00', 'Photographers', 'Photograph people, landscapes, merchandise, or other subjects, using digital or film cameras and equipment. May develop negatives or use computer software to produce finished images and prints. Includes scientific photographers, aerial photographers, and photojournalists.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-4031.00', 'Camera Operators, Television, Video, and Motion Picture', 'Operate television, video, or motion picture camera to record images or scenes for various purposes, such as TV broadcasts, advertising, video production, or motion pictures.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-4032.00', 'Film and Video Editors', 'Edit moving images on film, video, or other media. May edit or synchronize soundtracks with images.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('27-4099.00', 'Media and Communication Equipment Workers, All Other', 'All media and communication equipment workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1011.00', 'Chiropractors', 'Assess, treat, and care for patients by manipulation of spine and musculoskeletal system. May provide spinal adjustment or address sacral or pelvic misalignment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1021.00', 'Dentists, General', 'Examine, diagnose, and treat diseases, injuries, and malformations of teeth and gums. May treat diseases of nerve, pulp, and other dental tissues affecting oral hygiene and retention of teeth. May fit dental appliances or provide preventive care.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1022.00', 'Oral and Maxillofacial Surgeons', 'Perform surgery and related procedures on the hard and soft tissues of the oral and maxillofacial regions to treat diseases, injuries, or defects. May diagnose problems of the oral and maxillofacial regions. May perform surgery to improve function or appearance.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1023.00', 'Orthodontists', 'Examine, diagnose, and treat dental malocclusions and oral cavity anomalies. Design and fabricate appliances to realign teeth and jaws to produce and maintain normal function and to improve appearance.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1024.00', 'Prosthodontists', 'Construct oral prostheses to replace missing teeth and other oral structures to correct natural and acquired deformation of mouth and jaws, to restore and maintain oral function, such as chewing and speaking, and to improve appearance.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1029.00', 'Dentists, All Other Specialists', 'All dentists not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1031.00', 'Dietitians and Nutritionists', 'Plan and conduct food service or nutritional programs to assist in the promotion of health and control of disease. May supervise activities of a department providing quantity food services, counsel individuals, or conduct nutritional research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1041.00', 'Optometrists', 'Diagnose, manage, and treat conditions and diseases of the human eye and visual system. Examine eyes and visual system, diagnose problems or impairments, prescribe corrective lenses, and provide treatment. May prescribe therapeutic drugs to treat specific eye conditions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1051.00', 'Pharmacists', 'Dispense drugs prescribed by physicians and other health practitioners and provide information to patients about medications and their use. May advise physicians and other health practitioners on the selection, dosage, interactions, and side effects of medications.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1061.00', 'Anesthesiologists', 'Physicians who administer anesthetics prior to, during, or after surgery or other medical procedures.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1062.00', 'Family and General Practitioners', 'Physicians who diagnose, treat, and help prevent diseases and injuries that commonly occur in the general population. May refer patients to specialists when needed for further diagnosis or treatment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1063.00', 'Internists, General', 'Physicians who diagnose and provide non-surgical treatment of diseases and injuries of internal organ systems. Provide care mainly for adults who have a wide range of problems associated with the internal organs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1064.00', 'Obstetricians and Gynecologists', 'Physicians who provide medical care related to pregnancy or childbirth and those who diagnose, treat, and help prevent diseases of women, particularly those affecting the reproductive system. May also provide general medical care to women.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1065.00', 'Pediatricians, General', 'Physicians who diagnose, treat, and help prevent children''s diseases and injuries.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1066.00', 'Psychiatrists', 'Physicians who diagnose, treat, and help prevent disorders of the mind.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1067.00', 'Surgeons', 'Physicians who treat diseases, injuries, and deformities by invasive, minimally-invasive, or non-invasive surgical methods, such as using instruments, appliances, or by manual manipulation.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1069.00', 'Physicians and Surgeons, All Other', 'All physicians and surgeons not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1069.01', 'Allergists and Immunologists', 'Diagnose, treat, and help prevent allergic diseases and disease processes affecting the immune system.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1069.02', 'Dermatologists', 'Diagnose, treat, and help prevent diseases or other conditions of the skin.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1069.03', 'Hospitalists', 'Provide inpatient care predominantly in settings such as medical wards, acute care units, intensive care units, rehabilitation centers, or emergency rooms. Manage and coordinate patient care throughout treatment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1069.04', 'Neurologists', 'Diagnose, treat, and help prevent diseases and disorders of the nervous system.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1069.05', 'Nuclear Medicine Physicians', 'Diagnose and treat diseases using radioactive materials and techniques. May monitor radionuclide preparation, administration, and disposition.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1069.06', 'Ophthalmologists', 'Diagnose, treat, and help prevent diseases and injuries of the eyes and related structures.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1069.07', 'Pathologists', 'Diagnose presence and stage of diseases using laboratory techniques and patient specimens. Study the nature, cause, and development of diseases. May perform autopsies.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1069.08', 'Physical Medicine and Rehabilitation Physicians', 'Diagnose and treat disorders requiring physiotherapy to provide physical, mental, and occupational rehabilitation.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1069.09', 'Preventive Medicine Physicians', 'Apply knowledge of general preventive medicine and public health issues to promote health care to groups or individuals, and aid in the prevention or reduction of risk of disease, injury, disability, or death. May practice population-based medicine or diagnose and treat patients in the context of clinical health promotion and disease prevention.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1069.10', 'Radiologists', 'Examine and diagnose disorders and diseases using x-rays and radioactive materials. May treat patients.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1069.11', 'Sports Medicine Physicians', 'Diagnose, treat, and help prevent injuries that occur during sporting events, athletic training, and physical activities.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1069.12', 'Urologists', 'Diagnose, treat, and help prevent benign and malignant medical and surgical disorders of the genitourinary system and the renal glands.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1071.00', 'Physician Assistants', 'Provide healthcare services typically performed by a physician, under the supervision of a physician. Conduct complete physicals, provide treatment, and counsel patients. May, in some cases, prescribe medication. Must graduate from an accredited educational program for physician assistants.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1071.01', 'Anesthesiologist Assistants', 'Assist anesthesiologists in the administration of anesthesia for surgical and non-surgical procedures. Monitor patient status and provide patient care during surgical treatment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1081.00', 'Podiatrists', 'Diagnose and treat diseases and deformities of the human foot.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1122.00', 'Occupational Therapists', 'Assess, plan, organize, and participate in rehabilitative programs that help build or restore vocational, homemaking, and daily living skills, as well as general independence, to persons with disabilities or developmental delays.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1122.01', 'Low Vision Therapists, Orientation and Mobility Specialists, and Vision Rehabilitation Therapists', 'Provide therapy to patients with visual impairments to improve their functioning in daily life activities. May train patients in activities such as computer use, communication skills, or home management skills.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1123.00', 'Physical Therapists', 'Assess, plan, organize, and participate in rehabilitative programs that improve mobility, relieve pain, increase strength, and improve or correct disabling conditions resulting from disease or injury.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1124.00', 'Radiation Therapists', 'Provide radiation therapy to patients as prescribed by a radiologist according to established practices and standards. Duties may include reviewing prescription and diagnosis; acting as liaison with physician and supportive care personnel; preparing equipment, such as immobilization, treatment, and protection devices; and maintaining records, reports, and files. May assist in dosimetry procedures and tumor localization.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1125.00', 'Recreational Therapists', 'Plan, direct, or coordinate medically-approved recreation programs for patients in hospitals, nursing homes, or other institutions. Activities include sports, trips, dramatics, social activities, and arts and crafts. May assess a patient condition and recommend appropriate recreational activity.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1125.01', 'Art Therapists', 'Plan or conduct art therapy sessions or programs to improve clients'' physical, cognitive, or emotional well-being.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1125.02', 'Music Therapists', 'Plan, organize, or direct medically prescribed music therapy activities designed to positively influence patients'' psychological or behavioral status.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1126.00', 'Respiratory Therapists', 'Assess, treat, and care for patients with breathing disorders. Assume primary responsibility for all respiratory care modalities, including the supervision of respiratory therapy technicians. Initiate and conduct therapeutic procedures; maintain patient records; and select, assemble, check, and operate equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1127.00', 'Speech-Language Pathologists', 'Assess and treat persons with speech, language, voice, and fluency disorders. May select alternative communication systems and teach their use. May perform research related to speech and language problems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1128.00', 'Exercise Physiologists', 'Assess, plan, or implement fitness programs that include exercise or physical activities such as those designed to improve cardiorespiratory function, body composition, muscular strength, muscular endurance, or flexibility.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1129.00', 'Therapists, All Other', 'All therapists not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1131.00', 'Veterinarians', 'Diagnose, treat, or research diseases and injuries of animals. Includes veterinarians who conduct research and development, inspect livestock, or care for pets and companion animals.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1141.00', 'Registered Nurses', 'Assess patient health problems and needs, develop and implement nursing care plans, and maintain medical records. Administer nursing care to ill, injured, convalescent, or disabled patients. May advise patients on health maintenance and disease prevention or provide case management. Licensing or registration required.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1141.01', 'Acute Care Nurses', 'Provide advanced nursing care for patients with acute conditions such as heart attacks, respiratory distress syndrome, or shock. May care for pre- and post-operative patients or perform advanced, invasive diagnostic or therapeutic procedures.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1141.02', 'Advanced Practice Psychiatric Nurses', 'Provide advanced nursing care for patients with psychiatric disorders. May provide psychotherapy under the direction of a psychiatrist.');
GO
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1141.03', 'Critical Care Nurses', 'Provide advanced nursing care for patients in critical or coronary care units.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1141.04', 'Clinical Nurse Specialists', 'Plan, direct, or coordinate the daily patient care activities in a clinical practice. Ensure adherence to established clinical policies, protocols, regulations, and standards.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1151.00', 'Nurse Anesthetists', 'Administer anesthesia, monitor patient''s vital signs, and oversee patient recovery from anesthesia. May assist anesthesiologists, surgeons, other physicians, or dentists. Must be registered nurses who have specialized graduate education.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1161.00', 'Nurse Midwives', 'Diagnose and coordinate all aspects of the birthing process, either independently or as part of a healthcare team. May provide well-woman gynecological care. Must have specialized, graduate nursing education.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1171.00', 'Nurse Practitioners', 'Diagnose and treat acute, episodic, or chronic illness, independently or as part of a healthcare team. May focus on health promotion and disease prevention. May order, perform, or interpret diagnostic tests such as lab work and x rays. May prescribe medication. Must be registered nurses who have specialized graduate education.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1181.00', 'Audiologists', 'Assess and treat persons with hearing and related disorders. May fit hearing aids and provide auditory training. May perform research related to hearing problems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1199.00', 'Health Diagnosing and Treating Practitioners, All Other', 'All health diagnosing and treating practitioners not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1199.01', 'Acupuncturists', 'Provide treatment of symptoms and disorders using needles and small electrical currents. May provide massage treatment. May also provide preventive treatments.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1199.04', 'Naturopathic Physicians', 'Diagnose, treat, and help prevent diseases using a system of practice that is based on the natural healing capacity of individuals. May use physiological, psychological or mechanical methods. May also use natural medicines, prescription or legend drugs, foods, herbs, or other natural remedies.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-1199.05', 'Orthoptists', 'Diagnose and treat visual system disorders such as binocular vision and eye movement impairments.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2011.00', 'Medical and Clinical Laboratory Technologists', 'Perform complex medical laboratory tests for diagnosis, treatment, and prevention of disease. May train or supervise staff.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2011.01', 'Cytogenetic Technologists', 'Analyze chromosomes found in biological specimens such as amniotic fluids, bone marrow, and blood to aid in the study, diagnosis, or treatment of genetic diseases.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2011.02', 'Cytotechnologists', 'Stain, mount, and study cells to detect evidence of cancer, hormonal abnormalities, and other pathological conditions following established standards and practices.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2011.03', 'Histotechnologists and Histologic Technicians', 'Prepare histologic slides from tissue sections for microscopic examination and diagnosis by pathologists. May assist in research studies.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2012.00', 'Medical and Clinical Laboratory Technicians', 'Perform routine medical laboratory tests for the diagnosis, treatment, and prevention of disease. May work under the supervision of a medical technologist.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2021.00', 'Dental Hygienists', 'Clean teeth and examine oral areas, head, and neck for signs of oral disease. May educate patients on oral hygiene, take and develop x rays, or apply fluoride or sealants.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2031.00', 'Cardiovascular Technologists and Technicians', 'Conduct tests on pulmonary or cardiovascular systems of patients for diagnostic purposes. May conduct or assist in electrocardiograms, cardiac catheterizations, pulmonary functions, lung capacity, and similar tests. Includes vascular technologists.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2032.00', 'Diagnostic Medical Sonographers', 'Produce ultrasonic recordings of internal organs for use by physicians.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2033.00', 'Nuclear Medicine Technologists', 'Prepare, administer, and measure radioactive isotopes in therapeutic, diagnostic, and tracer studies using a variety of radioisotope equipment. Prepare stock solutions of radioactive materials and calculate doses to be administered by radiologists. Subject patients to radiation. Execute blood volume, red cell survival, and fat absorption studies following standard laboratory techniques.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2034.00', 'Radiologic Technologists', 'Take x rays and CAT scans or administer nonradioactive materials into patient''s blood stream for diagnostic purposes. Includes technologists who specialize in other scanning modalities.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2035.00', 'Magnetic Resonance Imaging Technologists', 'Operate Magnetic Resonance Imaging (MRI) scanners. Monitor patient safety and comfort, and view images of area being scanned to ensure quality of pictures. May administer gadolinium contrast dosage intravenously. May interview patient, explain MRI procedures, and position patient on examining table. May enter into the computer data such as patient history, anatomical area to be scanned, orientation specified, and position of entry.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2041.00', 'Emergency Medical Technicians and Paramedics', 'Assess injuries, administer emergency medical care, and extricate trapped individuals. Transport injured or sick persons to medical facilities.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2051.00', 'Dietetic Technicians', 'Assist in the provision of food service and nutritional programs, under the supervision of a dietitian. May plan and produce meals based on established guidelines, teach principles of food and nutrition, or counsel individuals.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2052.00', 'Pharmacy Technicians', 'Prepare medications under the direction of a pharmacist. May measure, mix, count out, label, and record amounts and dosages of medications according to prescription orders.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2053.00', 'Psychiatric Technicians', 'Care for individuals with mental or emotional conditions or disabilities, following the instructions of physicians or other health practitioners. Monitor patients'' physical and emotional well-being and report to medical staff. May participate in rehabilitation and treatment programs, help with personal hygiene, and administer oral or injectable medications.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2054.00', 'Respiratory Therapy Technicians', 'Provide respiratory care under the direction of respiratory therapists and physicians.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2055.00', 'Surgical Technologists', 'Assist in operations, under the supervision of surgeons, registered nurses, or other surgical personnel. May help set up operating room, prepare and transport patients for surgery, adjust lights and equipment, pass instruments and other supplies to surgeons and surgeon''s assistants, hold retractors, cut sutures, and help count sponges, needles, supplies, and instruments.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2056.00', 'Veterinary Technologists and Technicians', 'Perform medical tests in a laboratory environment for use in the treatment and diagnosis of diseases in animals. Prepare vaccines and serums for prevention of diseases. Prepare tissue samples, take blood samples, and execute laboratory tests, such as urinalysis and blood counts. Clean and sterilize instruments and materials and maintain equipment and machines. May assist a veterinarian during surgery.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2057.00', 'Ophthalmic Medical Technicians', 'Assist ophthalmologists by performing ophthalmic clinical functions. May administer eye exams, administer eye medications, and instruct the patient in care and use of corrective lenses.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2061.00', 'Licensed Practical and Licensed Vocational Nurses', 'Care for ill, injured, or convalescing patients or persons with disabilities in hospitals, nursing homes, clinics, private homes, group homes, and similar institutions. May work under the supervision of a registered nurse. Licensing required.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2071.00', 'Medical Records and Health Information Technicians', 'Compile, process, and maintain medical records of hospital and clinic patients in a manner consistent with medical, administrative, ethical, legal, and regulatory requirements of the health care system. Process, maintain, compile, and report patient information for health requirements and standards in a manner consistent with the healthcare industry''s numerical coding system.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2081.00', 'Opticians, Dispensing', 'Design, measure, fit, and adapt lenses and frames for client according to written optical prescription or specification. Assist client with inserting, removing, and caring for contact lenses. Assist client with selecting frames. Measure customer for size of eyeglasses and coordinate frames with facial and eye measurements and optical prescription. Prepare work order for optical laboratory containing instructions for grinding and mounting lenses in frames. Verify exactness of finished lens spectacles. Adjust frame and lens position to fit client. May shape or reshape frames. Includes contact lens opticians.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2091.00', 'Orthotists and Prosthetists', 'Design, measure, fit, and adapt orthopedic braces, appliances or prostheses, such as limbs or facial parts for patients with disabling conditions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2092.00', 'Hearing Aid Specialists', 'Select and fit hearing aids for customers. Administer and interpret tests of hearing. Assess hearing instrument efficacy. Take ear impressions and prepare, design, and modify ear molds.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2099.00', 'Health Technologists and Technicians, All Other', 'All health technologists and technicians not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2099.01', 'Neurodiagnostic Technologists', 'Conduct electroneurodiagnostic (END) tests such as electroencephalograms, evoked potentials, polysomnograms, or electronystagmograms. May perform nerve conduction studies.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2099.05', 'Ophthalmic Medical Technologists', 'Assist ophthalmologists by performing ophthalmic clinical functions and ophthalmic photography. Provide instruction and supervision to other ophthalmic personnel. Assist with minor surgical procedures, applying aseptic techniques and preparing instruments. May perform eye exams, administer eye medications, and instruct patients in care and use of corrective lenses.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2099.06', 'Radiologic Technicians', 'Maintain and use equipment and supplies necessary to demonstrate portions of the human body on x-ray film or fluoroscopic screen for diagnostic purposes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-2099.07', 'Surgical Assistants', 'Assist surgeons during surgery by performing duties such as tissue retraction, insertion of tubes and intravenous lines, or closure of surgical wounds. Perform preoperative and postoperative duties to facilitate patient care.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-9011.00', 'Occupational Health and Safety Specialists', 'Review, evaluate, and analyze work environments and design programs and procedures to control, eliminate, and prevent disease or injury caused by chemical, physical, and biological agents or ergonomic factors. May conduct inspections and enforce adherence to laws and regulations governing the health and safety of individuals. May be employed in the public or private sector. Includes environmental protection officers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-9012.00', 'Occupational Health and Safety Technicians', 'Collect data on work environments for analysis by occupational health and safety specialists. Implement and conduct evaluation of programs designed to limit chemical, physical, biological, and ergonomic risks to workers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-9091.00', 'Athletic Trainers', 'Evaluate and advise individuals to assist recovery from or avoid athletic-related injuries or illnesses, or maintain peak physical fitness. May provide first aid or emergency care.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-9092.00', 'Genetic Counselors', 'Assess individual or family risk for a variety of inherited conditions, such as genetic disorders and birth defects. Provide information to other healthcare providers or to individuals and families concerned with the risk of inherited conditions. Advise individuals and families to support informed decisionmaking and coping methods for those at risk. May help conduct research related to genetic conditions or genetic counseling.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-9099.00', 'Healthcare Practitioners and Technical Workers, All Other', 'All healthcare practitioners and technical workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('29-9099.01', 'Midwives', 'Provide prenatal care and childbirth assistance.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-1011.00', 'Home Health Aides', 'Provide routine individualized healthcare such as changing bandages and dressing wounds, and applying topical medications to the elderly, convalescents, or persons with disabilities at the patient''s home or in a care facility. Monitor or report changes in health status. May also provide personal care such as bathing, dressing, and grooming of patient.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-1013.00', 'Psychiatric Aides', 'Assist mentally impaired or emotionally disturbed patients, working under direction of nursing and medical staff. May assist with daily living activities, lead patients in educational and recreational activities, or accompany patients to and from examinations and treatments. May restrain violent patients. Includes psychiatric orderlies.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-1014.00', 'Nursing Assistants', 'Provide basic patient care under direction of nursing staff. Perform duties such as feed, bathe, dress, groom, or move patients, or change linens. May transfer or transport patients. Includes nursing care attendants, nursing aides, and nursing attendants.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-1015.00', 'Orderlies', 'Transport patients to areas such as operating rooms or x-ray rooms using wheelchairs, stretchers, or moveable beds. May maintain stocks of supplies or clean and transport equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-2011.00', 'Occupational Therapy Assistants', 'Assist occupational therapists in providing occupational therapy treatments and procedures. May, in accordance with State laws, assist in development of treatment plans, carry out routine functions, direct activity programs, and document the progress of treatments. Generally requires formal training.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-2012.00', 'Occupational Therapy Aides', 'Under close supervision of an occupational therapist or occupational therapy assistant, perform only delegated, selected, or routine tasks in specific situations. These duties include preparing patient and treatment room.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-2021.00', 'Physical Therapist Assistants', 'Assist physical therapists in providing physical therapy treatments and procedures. May, in accordance with State laws, assist in the development of treatment plans, carry out routine functions, document the progress of treatment, and modify specific treatments in accordance with patient status and within the scope of treatment plans established by a physical therapist. Generally requires formal training.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-2022.00', 'Physical Therapist Aides', 'Under close supervision of a physical therapist or physical therapy assistant, perform only delegated, selected, or routine tasks in specific situations. These duties include preparing the patient and the treatment area.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-9011.00', 'Massage Therapists', 'Perform therapeutic massages of soft tissues and joints. May assist in the assessment of range of motion and muscle strength, or propose client therapy plans.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-9091.00', 'Dental Assistants', 'Assist dentist, set up equipment, prepare patient for treatment, and keep records.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-9092.00', 'Medical Assistants', 'Perform administrative and certain clinical duties under the direction of a physician. Administrative duties may include scheduling appointments, maintaining medical records, billing, and coding information for insurance purposes. Clinical duties may include taking and recording vital signs and medical histories, preparing patients for examination, drawing blood, and administering medications as directed by physician.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-9093.00', 'Medical Equipment Preparers', 'Prepare, sterilize, install, or clean laboratory or healthcare equipment. May perform routine laboratory tasks and operate or inspect equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-9094.00', 'Medical Transcriptionists', 'Transcribe medical reports recorded by physicians and other healthcare practitioners using various electronic devices, covering office visits, emergency room visits, diagnostic imaging studies, operations, chart reviews, and final summaries. Transcribe dictated reports and translate abbreviations into fully understandable form. Edit as necessary and return reports in either printed or electronic form for review and signature, or correction.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-9095.00', 'Pharmacy Aides', 'Record drugs delivered to the pharmacy, store incoming merchandise, and inform the supervisor of stock needs. May operate cash register and accept prescriptions for filling.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-9096.00', 'Veterinary Assistants and Laboratory Animal Caretakers', 'Feed, water, and examine pets and other nonfarm animals for signs of illness, disease, or injury in laboratories and animal hospitals and clinics. Clean and disinfect cages and work areas, and sterilize laboratory and surgical equipment. May provide routine post-operative care, administer medication orally or topically, or prepare samples for laboratory examination under the supervision of veterinary or laboratory animal technologists or technicians, veterinarians, or scientists.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-9097.00', 'Phlebotomists', 'Draw blood for tests, transfusions, donations, or research. May explain the procedure to patients and assist in the recovery of patients with adverse reactions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-9099.00', 'Healthcare Support Workers, All Other', 'All healthcare support workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-9099.01', 'Speech-Language Pathology Assistants', 'Assist speech-language pathologists in the assessment and treatment of speech, language, voice, and fluency disorders. Implement speech and language programs or activities as planned and directed by speech-language pathologists. Monitor the use of alternative communication devices and systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('31-9099.02', 'Endoscopy Technicians', 'Maintain a sterile field to provide support for physicians and nurses during endoscopy procedures. Prepare and maintain instruments and equipment. May obtain specimens.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-1011.00', 'First-Line Supervisors of Correctional Officers', 'Directly supervise and coordinate activities of correctional officers and jailers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-1012.00', 'First-Line Supervisors of Police and Detectives', 'Directly supervise and coordinate activities of members of police force.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-1021.00', 'First-Line Supervisors of Fire Fighting and Prevention Workers', 'Directly supervise and coordinate activities of workers engaged in fire fighting and fire prevention and control.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-1021.01', 'Municipal Fire Fighting and Prevention Supervisors', 'Supervise fire fighters who control and extinguish municipal fires, protect life and property, and conduct rescue efforts.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-1021.02', 'Forest Fire Fighting and Prevention Supervisors', 'Supervise fire fighters who control and suppress fires in forests or vacant public land.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-1099.00', 'First-Line Supervisors of Protective Service Workers, All Other', 'All protective service supervisors not listed separately above.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-2011.00', 'Firefighters', 'Control and extinguish fires or respond to emergency situations where life, property, or the environment is at risk. Duties may include fire prevention, emergency medical service, hazardous material response, search and rescue, and disaster assistance.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-2011.01', 'Municipal Firefighters', 'Control and extinguish municipal fires, protect life and property and conduct rescue efforts.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-2011.02', 'Forest Firefighters', 'Control and suppress fires in forests or vacant public land.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-2021.00', 'Fire Inspectors and Investigators', 'Inspect buildings to detect fire hazards and enforce local ordinances and State laws, or investigate and gather facts to determine cause of fires and explosions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-2021.01', 'Fire Inspectors', 'Inspect buildings and equipment to detect fire hazards and enforce state and local regulations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-2021.02', 'Fire Investigators', 'Conduct investigations to determine causes of fires and explosions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-2022.00', 'Forest Fire Inspectors and Prevention Specialists', 'Enforce fire regulations, inspect forest for fire hazards and recommend forest fire prevention or control measures. May report forest fires and weather conditions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-3011.00', 'Bailiffs', 'Maintain order in courts of law.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-3012.00', 'Correctional Officers and Jailers', 'Guard inmates in penal or rehabilitative institutions in accordance with established regulations and procedures. May guard prisoners in transit between jail, courtroom, prison, or other point. Includes deputy sheriffs and police who spend the majority of their time guarding prisoners in correctional institutions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-3021.00', 'Detectives and Criminal Investigators', 'Conduct investigations related to suspected violations of Federal, State, or local laws to prevent or solve crimes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-3021.01', 'Police Detectives', 'Conduct investigations to prevent crimes or solve criminal cases.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-3021.02', 'Police Identification and Records Officers', 'Collect evidence at crime scene, classify and identify fingerprints, and photograph evidence for use in criminal and civil cases.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-3021.03', 'Criminal Investigators and Special Agents', 'Investigate alleged or suspected criminal violations of Federal, state, or local laws to determine if evidence is sufficient to recommend prosecution.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-3021.05', 'Immigration and Customs Inspectors', 'Investigate and inspect persons, common carriers, goods, and merchandise, arriving in or departing from the United States or between states to detect violations of immigration and customs laws and regulations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-3021.06', 'Intelligence Analysts', 'Gather, analyze, or evaluate information from a variety of sources, such as law enforcement databases, surveillance, intelligence networks or geographic information systems. Use intelligence data to anticipate and prevent organized crime activities, such as terrorism.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-3031.00', 'Fish and Game Wardens', 'Patrol assigned area to prevent fish and game law violations. Investigate reports of damage to crops or property by wildlife. Compile biological data.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-3041.00', 'Parking Enforcement Workers', 'Patrol assigned area, such as public parking lot or city streets to issue tickets to overtime parking violators and illegally parked vehicles.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-3051.00', 'Police and Sheriff''s Patrol Officers', 'Maintain order and protect life and property by enforcing local, tribal, State, or Federal laws and ordinances. Perform a combination of the following duties: patrol a specific area; direct traffic; issue traffic summonses; investigate accidents; apprehend and arrest suspects, or serve legal processes of courts.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-3051.01', 'Police Patrol Officers', 'Patrol assigned area to enforce laws and ordinances, regulate traffic, control crowds, prevent crime, and arrest violators.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-3051.03', 'Sheriffs and Deputy Sheriffs', 'Enforce law and order in rural or unincorporated districts or serve legal processes of courts. May patrol courthouse, guard court or grand jury, or escort defendants.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-3052.00', 'Transit and Railroad Police', 'Protect and police railroad and transit property, employees, or passengers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-9011.00', 'Animal Control Workers', 'Handle animals for the purpose of investigations of mistreatment, or control of abandoned, dangerous, or unattended animals.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-9021.00', 'Private Detectives and Investigators', 'Gather, analyze, compile and report information regarding individuals or organizations to clients, or detect occurrences of unlawful acts or infractions of rules in private establishment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-9031.00', 'Gaming Surveillance Officers and Gaming Investigators', 'Act as oversight and security agent for management and customers. Observe casino or casino hotel operation for irregular activities such as cheating or theft by either employees or patrons. May use one-way mirrors above the casino floor, cashier''s cage, and from desk. Use of audio/video equipment is also common to observe operation of the business. Usually required to provide verbal and written reports of all violations and suspicious behavior to supervisor.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-9032.00', 'Security Guards', 'Guard, patrol, or monitor premises to prevent theft, violence, or infractions of rules. May operate x-ray and metal detector equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-9091.00', 'Crossing Guards', 'Guide or control vehicular or pedestrian traffic at such places as streets, schools, railroad crossings, or construction sites.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-9092.00', 'Lifeguards, Ski Patrol, and Other Recreational Protective Service Workers', 'Monitor recreational areas, such as pools, beaches, or ski slopes to provide assistance and protection to participants.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-9093.00', 'Transportation Security Screeners', 'Conduct screening of passengers, baggage, or cargo to ensure compliance with Transportation Security Administration (TSA) regulations. May operate basic security equipment such as x-ray machines and hand wands at screening checkpoints.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-9099.00', 'Protective Service Workers, All Other', 'All protective service workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('33-9099.02', 'Retail Loss Prevention Specialists', 'Implement procedures and systems to prevent merchandise loss. Conduct audits and investigations of employee activity. May assist in developing policies, procedures, and systems for safeguarding assets.');
GO
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-1011.00', 'Chefs and Head Cooks', 'Direct and may participate in the preparation, seasoning, and cooking of salads, soups, fish, meats, vegetables, desserts, or other foods. May plan and price menu items, order supplies, and keep records and accounts.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-1012.00', 'First-Line Supervisors of Food Preparation and Serving Workers', 'Directly supervise and coordinate activities of workers engaged in preparing and serving food.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-2011.00', 'Cooks, Fast Food', 'Prepare and cook food in a fast food restaurant with a limited menu. Duties of these cooks are limited to preparation of a few basic items and normally involve operating large-volume single-purpose cooking equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-2012.00', 'Cooks, Institution and Cafeteria', 'Prepare and cook large quantities of food for institutions, such as schools, hospitals, or cafeterias.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-2013.00', 'Cooks, Private Household', 'Prepare meals in private homes. Includes personal chefs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-2014.00', 'Cooks, Restaurant', 'Prepare, season, and cook dishes such as soups, meats, vegetables, or desserts in restaurants. May order supplies, keep records and accounts, price items on menu, or plan menu.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-2015.00', 'Cooks, Short Order', 'Prepare and cook to order a variety of foods that require only a short preparation time. May take orders from customers and serve patrons at counters or tables.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-2019.00', 'Cooks, All Other', 'All cooks not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-2021.00', 'Food Preparation Workers', 'Perform a variety of food preparation duties other than cooking, such as preparing cold foods and shellfish, slicing meat, and brewing coffee or tea.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-3011.00', 'Bartenders', 'Mix and serve drinks to patrons, directly or through waitstaff.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-3021.00', 'Combined Food Preparation and Serving Workers, Including Fast Food', 'Perform duties which combine preparing and serving food and nonalcoholic beverages.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-3022.00', 'Counter Attendants, Cafeteria, Food Concession, and Coffee Shop', 'Serve food to diners at counter or from a steam table.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-3022.01', 'Baristas', 'Prepare or serve specialty coffee or other beverages. Serve food such as baked goods or sandwiches to patrons.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-3031.00', 'Waiters and Waitresses', 'Take orders and serve food and beverages to patrons at tables in dining establishment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-3041.00', 'Food Servers, Nonrestaurant', 'Serve food to individuals outside of a restaurant environment, such as in hotel rooms, hospital rooms, residential care facilities, or cars.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-9011.00', 'Dining Room and Cafeteria Attendants and Bartender Helpers', 'Facilitate food service. Clean tables, remove dirty dishes, replace soiled table linens; set tables; replenish supply of clean linens, silverware, glassware, and dishes; supply service bar with food; and serve items such as water, condiments, and coffee to patrons.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-9021.00', 'Dishwashers', 'Clean dishes, kitchen, food preparation equipment, or utensils.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-9031.00', 'Hosts and Hostesses, Restaurant, Lounge, and Coffee Shop', 'Welcome patrons, seat them at tables or in lounge, and help ensure quality of facilities and service.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('35-9099.00', 'Food Preparation and Serving Related Workers, All Other', 'All food preparation and serving related workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('37-1011.00', 'First-Line Supervisors of Housekeeping and Janitorial Workers', 'Directly supervise and coordinate work activities of cleaning personnel in hotels, hospitals, offices, and other establishments.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('37-1012.00', 'First-Line Supervisors of Landscaping, Lawn Service, and Groundskeeping Workers', 'Directly supervise and coordinate activities of workers engaged in landscaping or groundskeeping activities. Work may involve reviewing contracts to ascertain service, machine, and workforce requirements; answering inquiries from potential customers regarding methods, material, and price ranges; and preparing estimates according to labor, material, and machine costs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('37-2011.00', 'Janitors and Cleaners, Except Maids and Housekeeping Cleaners', 'Keep buildings in clean and orderly condition. Perform heavy cleaning duties, such as cleaning floors, shampooing rugs, washing walls and glass, and removing rubbish. Duties may include tending furnace and boiler, performing routine maintenance activities, notifying management of need for repairs, and cleaning snow or debris from sidewalk.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('37-2012.00', 'Maids and Housekeeping Cleaners', 'Perform any combination of light cleaning duties to maintain private households or commercial establishments, such as hotels and hospitals, in a clean and orderly manner. Duties may include making beds, replenishing linens, cleaning rooms and halls, and vacuuming.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('37-2019.00', 'Building Cleaning Workers, All Other', 'All building cleaning workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('37-2021.00', 'Pest Control Workers', 'Apply or release chemical solutions or toxic gases and set traps to kill or remove pests and vermin that infest buildings and surrounding areas.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('37-3011.00', 'Landscaping and Groundskeeping Workers', 'Landscape or maintain grounds of property using hand or power tools or equipment. Workers typically perform a variety of tasks, which may include any combination of the following: sod laying, mowing, trimming, planting, watering, fertilizing, digging, raking, sprinkler installation, and installation of mortarless segmental concrete masonry wall units.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('37-3012.00', 'Pesticide Handlers, Sprayers, and Applicators, Vegetation', 'Mix or apply pesticides, herbicides, fungicides, or insecticides through sprays, dusts, vapors, soil incorporation, or chemical application on trees, shrubs, lawns, or botanical crops. Usually requires specific training and State or Federal certification.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('37-3013.00', 'Tree Trimmers and Pruners', 'Using sophisticated climbing and rigging techniques, cut away dead or excess branches from trees or shrubs to maintain right-of-way for roads, sidewalks, or utilities, or to improve appearance, health, and value of tree. Prune or treat trees or shrubs using handsaws, hand pruners, clippers, and power pruners. Works off the ground in the tree canopy and may use truck-mounted lifts.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('37-3019.00', 'Grounds Maintenance Workers, All Other', 'All grounds maintenance workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-1011.00', 'Gaming Supervisors', 'Supervise and coordinate activities of workers in assigned gaming areas. Circulate among tables and observe operations. Ensure that stations and games are covered for each shift. May explain and interpret operating rules of house to patrons. May plan and organize activities and services for guests in hotels/casinos. May address service complaints.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-1012.00', 'Slot Supervisors', 'Supervise and coordinate activities of slot department workers to provide service to patrons. Handle and settle complaints of players. Verify and pay off jackpots. Reset slot machines after payoffs. Make repairs or adjustments to slot machines or recommend removal of slot machines for repair. Report hazards and enforce safety rules.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-1021.00', 'First-Line Supervisors of Personal Service Workers', 'Directly supervise and coordinate activities of personal service workers, such as flight attendants, hairdressers, or caddies.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-1021.01', 'Spa Managers', 'Plan, direct, or coordinate activities of a spa facility. Coordinate programs, schedule and direct staff, and oversee financial activities.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-2011.00', 'Animal Trainers', 'Train animals for riding, harness, security, performance, or obedience, or assisting persons with disabilities. Accustom animals to human voice and contact; and condition animals to respond to commands. Train animals according to prescribed standards for show or competition. May train animals to carry pack loads or work as part of pack team.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-2021.00', 'Nonfarm Animal Caretakers', 'Feed, water, groom, bathe, exercise, or otherwise care for pets and other nonfarm animals, such as dogs, cats, ornamental fish or birds, zoo animals, and mice. Work in settings such as kennels, animal shelters, zoos, circuses, and aquariums. May keep records of feedings, treatments, and animals received or discharged. May clean, disinfect, and repair cages, pens, or fish tanks.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-3011.00', 'Gaming Dealers', 'Operate table games. Stand or sit behind table and operate games of chance by dispensing the appropriate number of cards or blocks to players, or operating other gaming equipment. Distribute winnings or collect players'' money or chips. May compare the house''s hand against players'' hands.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-3012.00', 'Gaming and Sports Book Writers and Runners', 'Post information enabling patrons to wager on various races and sporting events. Assist in the operation of games such as keno and bingo. May operate random number generating equipment and announce the numbers for patrons. Receive, verify, and record patrons'' wagers. Scan and process winning tickets presented by patrons and payout winnings for those wagers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-3019.00', 'Gaming Service Workers, All Other', 'All gaming service workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-3021.00', 'Motion Picture Projectionists', 'Set up and operate motion picture projection and related sound reproduction equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-3031.00', 'Ushers, Lobby Attendants, and Ticket Takers', 'Assist patrons at entertainment events by performing duties, such as collecting admission tickets and passes from patrons, assisting in finding seats, searching for lost articles, and locating such facilities as rest rooms and telephones.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-3091.00', 'Amusement and Recreation Attendants', 'Perform variety of attending duties at amusement or recreation facility. May schedule use of recreation facilities, maintain and provide equipment to participants of sporting events or recreational pursuits, or operate amusement concessions and rides.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-3092.00', 'Costume Attendants', 'Select, fit, and take care of costumes for cast members, and aid entertainers. May assist with multiple costume changes during performances.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-3093.00', 'Locker Room, Coatroom, and Dressing Room Attendants', 'Provide personal items to patrons or customers in locker rooms, dressing rooms, or coatrooms.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-3099.00', 'Entertainment Attendants and Related Workers, All Other', 'All entertainment attendants and related workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-4011.00', 'Embalmers', 'Prepare bodies for interment in conformity with legal requirements.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-4021.00', 'Funeral Attendants', 'Perform variety of tasks during funeral, such as placing casket in parlor or chapel prior to service; arranging floral offerings or lights around casket; directing or escorting mourners; closing casket; and issuing and storing funeral equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-4031.00', 'Morticians, Undertakers, and Funeral Directors', 'Perform various tasks to arrange and direct funeral services, such as coordinating transportation of body to mortuary, interviewing family or other authorized person to arrange details, selecting pallbearers, aiding with the selection of officials for religious rites, and providing transportation for mourners.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-5011.00', 'Barbers', 'Provide barbering services, such as cutting, trimming, shampooing, and styling hair, trimming beards, or giving shaves.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-5012.00', 'Hairdressers, Hairstylists, and Cosmetologists', 'Provide beauty services, such as shampooing, cutting, coloring, and styling hair, and massaging and treating scalp. May apply makeup, dress wigs, perform hair removal, and provide nail and skin care services.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-5091.00', 'Makeup Artists, Theatrical and Performance', 'Apply makeup to performers to reflect period, setting, and situation of their role.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-5092.00', 'Manicurists and Pedicurists', 'Clean and shape customers'' fingernails and toenails. May polish or decorate nails.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-5093.00', 'Shampooers', 'Shampoo and rinse customers'' hair.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-5094.00', 'Skincare Specialists', 'Provide skincare treatments to face and body to enhance an individual''s appearance. Includes electrologists and laser hair removal specialists.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-6011.00', 'Baggage Porters and Bellhops', 'Handle baggage for travelers at transportation terminals or for guests at hotels or similar establishments.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-6012.00', 'Concierges', 'Assist patrons at hotel, apartment, or office building with personal services. May take messages, arrange or give advice on transportation, business services or entertainment, or monitor guest requests for housekeeping and maintenance.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-7011.00', 'Tour Guides and Escorts', 'Escort individuals or groups on sightseeing tours or through places of interest, such as industrial establishments, public buildings, and art galleries.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-7012.00', 'Travel Guides', 'Plan, organize, and conduct long distance travel, tours, and expeditions for individuals and groups.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-9011.00', 'Childcare Workers', 'Attend to children at schools, businesses, private households, and childcare institutions. Perform a variety of tasks, such as dressing, feeding, bathing, and overseeing play.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-9011.01', 'Nannies', 'Care for children in private households and provide support and expertise to parents in satisfying children''s physical, emotional, intellectual, and social needs. Duties may include meal planning and preparation, laundry and clothing care, organization of play activities and outings, discipline, intellectual stimulation, language activities, and transportation.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-9021.00', 'Personal Care Aides', 'Assist the elderly, convalescents, or persons with disabilities with daily living activities at the person''s home or in a care facility. Duties performed at a place of residence may include keeping house (making beds, doing laundry, washing dishes) and preparing meals. May provide assistance at non-residential care facilities. May advise families, the elderly, convalescents, and persons with disabilities regarding such things as nutrition, cleanliness, and household activities.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-9031.00', 'Fitness Trainers and Aerobics Instructors', 'Instruct or coach groups or individuals in exercise activities. Demonstrate techniques and form, observe participants, and explain to them corrective measures necessary to improve their skills.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-9032.00', 'Recreation Workers', 'Conduct recreation activities with groups in public, private, or volunteer agencies or recreation facilities. Organize and promote activities, such as arts and crafts, sports, games, music, dramatics, social recreation, camping, and hobbies, taking into account the needs and interests of individual members.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-9041.00', 'Residential Advisors', 'Coordinate activities in residential facilities in secondary and college dormitories, group homes, or similar establishments. Order supplies and determine need for maintenance, repairs, and furnishings. May maintain household records and assign rooms. May assist residents with problem solving or refer them to counseling resources.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('39-9099.00', 'Personal Care and Service Workers, All Other', 'All personal care and service workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-1011.00', 'First-Line Supervisors of Retail Sales Workers', 'Directly supervise and coordinate activities of retail sales workers in an establishment or department. Duties may include management functions, such as purchasing, budgeting, accounting, and personnel work, in addition to supervisory duties.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-1012.00', 'First-Line Supervisors of Non-Retail Sales Workers', 'Directly supervise and coordinate activities of sales workers other than retail sales workers. May perform duties such as budgeting, accounting, and personnel work, in addition to supervisory duties.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-2011.00', 'Cashiers', 'Receive and disburse money in establishments other than financial institutions. May use electronic scanners, cash registers, or related equipment. May process credit or debit card transactions and validate checks.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-2012.00', 'Gaming Change Persons and Booth Cashiers', 'Exchange coins, tokens, and chips for patrons'' money. May issue payoffs and obtain customer''s signature on receipt. May operate a booth in the slot machine area and furnish change persons with money bank at the start of the shift, or count and audit money in drawers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-2021.00', 'Counter and Rental Clerks', 'Receive orders, generally in person, for repairs, rentals, and services. May describe available options, compute costs, and accept payment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-2022.00', 'Parts Salespersons', 'Sell spare and replacement parts and equipment in repair shop or parts store.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-2031.00', 'Retail Salespersons', 'Sell merchandise, such as furniture, motor vehicles, appliances, or apparel to consumers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-3011.00', 'Advertising Sales Agents', 'Sell or solicit advertising space, time, or media in publications, signage, TV, radio, or the Internet. Includes individuals who obtain leases for outdoor advertising sites or persuade retailers to use sales promotion display items.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-3021.00', 'Insurance Sales Agents', 'Sell life, property, casualty, health, automotive, or other types of insurance. May refer clients to independent brokers, work as an independent broker, or be employed by an insurance company.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-3031.00', 'Securities, Commodities, and Financial Services Sales Agents', 'Buy and sell securities or commodities in investment and trading firms, or provide financial services to businesses and individuals. May advise customers about stocks, bonds, mutual funds, commodities, and market conditions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-3031.01', 'Sales Agents, Securities and Commodities', 'Buy and sell securities in investment and trading firms and develop and implement financial plans for individuals, businesses, and organizations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-3031.02', 'Sales Agents, Financial Services', 'Sell financial services, such as loan, tax, and securities counseling to customers of financial institutions and business establishments.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-3031.03', 'Securities and Commodities Traders', 'Buy and sell securities and commodities to transfer debt, capital, or risk. Establish and negotiate unit prices and terms of sale.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-3041.00', 'Travel Agents', 'Plan and sell transportation and accommodations for travel agency customers. Determine destination, modes of transportation, travel dates, costs, and accommodations required. May also describe, plan, and arrange itineraries and sell tour packages. May assist in resolving clients'' travel problems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-3099.00', 'Sales Representatives, Services, All Other', 'All services sales representatives not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-3099.01', 'Energy Brokers', 'Buy or sell energy products on the behalf of residential or commercial customers or utilities. Negotiate and oversee contracts for energy sales.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-4011.00', 'Sales Representatives, Wholesale and Manufacturing, Technical and Scientific Products', 'Sell goods for wholesalers or manufacturers where technical or scientific knowledge is required in such areas as biology, engineering, chemistry, and electronics, normally obtained from at least 2 years of post-secondary education.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-4011.07', 'Solar Sales Representatives and Assessors', 'Contact new or existing customers to determine their solar equipment needs, suggest systems or equipment, or estimate costs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-4012.00', 'Sales Representatives, Wholesale and Manufacturing, Except Technical and Scientific Products', 'Sell goods for wholesalers or manufacturers to businesses or groups of individuals. Work requires substantial knowledge of items sold.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-9011.00', 'Demonstrators and Product Promoters', 'Demonstrate merchandise and answer questions for the purpose of creating public interest in buying the product. May sell demonstrated merchandise.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-9012.00', 'Models', 'Model garments or other apparel and accessories for prospective buyers at fashion shows, private showings, or retail establishments. May pose for photos to be used in magazines or advertisements. May pose as subject for paintings, sculptures, and other types of artistic expression.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-9021.00', 'Real Estate Brokers', 'Operate real estate office, or work for commercial real estate firm, overseeing real estate transactions. Other duties usually include selling real estate or renting properties and arranging loans.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-9022.00', 'Real Estate Sales Agents', 'Rent, buy, or sell property for clients. Perform duties, such as study property listings, interview prospective clients, accompany clients to property site, discuss conditions of sale, and draw up real estate contracts. Includes agents who represent buyer.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-9031.00', 'Sales Engineers', 'Sell business goods or services, the selling of which requires a technical background equivalent to a baccalaureate degree in engineering.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-9041.00', 'Telemarketers', 'Solicit donations or orders for goods or services over the telephone.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-9091.00', 'Door-To-Door Sales Workers, News and Street Vendors, and Related Workers', 'Sell goods or services door-to-door or on the street.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('41-9099.00', 'Sales and Related Workers, All Other', 'All sales and related workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-1011.00', 'First-Line Supervisors of Office and Administrative Support Workers', 'Directly supervise and coordinate the activities of clerical and administrative support workers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-2011.00', 'Switchboard Operators, Including Answering Service', 'Operate telephone business systems equipment or switchboards to relay incoming, outgoing, and interoffice calls. May supply information to callers and record messages.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-2021.00', 'Telephone Operators', 'Provide information by accessing alphabetical, geographical, or other directories. Assist customers with special billing requests, such as charges to a third party and credits or refunds for incorrectly dialed numbers or bad connections. May handle emergency calls and assist children or people with physical disabilities to make telephone calls.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-2099.00', 'Communications Equipment Operators, All Other', 'All communications equipment operators not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-3011.00', 'Bill and Account Collectors', 'Locate and notify customers of delinquent accounts by mail, telephone, or personal visit to solicit payment. Duties include receiving payment and posting amount to customer''s account; preparing statements to credit department if customer fails to respond; initiating repossession proceedings or service disconnection; and keeping records of collection and status of accounts.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-3021.00', 'Billing and Posting Clerks', 'Compile, compute, and record billing, accounting, statistical, and other numerical data for billing purposes. Prepare billing invoices for services rendered or for delivery or shipment of goods.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-3021.01', 'Statement Clerks', 'Prepare and distribute bank statements to customers, answer inquiries, and reconcile discrepancies in records and accounts.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-3021.02', 'Billing, Cost, and Rate Clerks', 'Compile data, compute fees and charges, and prepare invoices for billing purposes. Duties include computing costs and calculating rates for goods, services, and shipment of goods; posting data; and keeping other relevant records. May involve use of computer or typewriter, calculator, and adding and bookkeeping machines.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-3031.00', 'Bookkeeping, Accounting, and Auditing Clerks', 'Compute, classify, and record numerical data to keep financial records complete. Perform any combination of routine calculating, posting, and verifying duties to obtain primary financial data for use in maintaining accounting records. May also check the accuracy of figures, calculations, and postings pertaining to business transactions recorded by other workers.');
GO
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-3041.00', 'Gaming Cage Workers', 'In a gaming establishment, conduct financial transactions for patrons. May reconcile daily summaries of transactions to balance books. May accept patron''s credit application and verify credit references to provide check-cashing authorization or to establish house credit accounts. May sell gambling chips, tokens, or tickets to patrons, or to other workers for resale to patrons. May convert gaming chips, tokens, or tickets to currency upon patron''s request. May use a cash register or computer to record transaction.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-3051.00', 'Payroll and Timekeeping Clerks', 'Compile and record employee time and payroll data. May compute employees'' time worked, production, and commission. May compute and post wages and deductions, or prepare paychecks.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-3061.00', 'Procurement Clerks', 'Compile information and records to draw up purchase orders for procurement of materials and services.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-3071.00', 'Tellers', 'Receive and pay out money. Keep records of money and negotiable instruments involved in a financial institution''s various transactions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-3099.00', 'Financial Clerks, All Other', 'All financial clerks not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4011.00', 'Brokerage Clerks', 'Perform duties related to the purchase, sale or holding of securities. Duties include writing orders for stock purchases or sales, computing transfer taxes, verifying stock transactions, accepting and delivering securities, tracking stock price fluctuations, computing equity, distributing dividends, and keeping records of daily transactions and holdings.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4021.00', 'Correspondence Clerks', 'Compose letters or electronic correspondence in reply to requests for merchandise, damage claims, credit and other information, delinquent accounts, incorrect billings, or unsatisfactory services. Duties may include gathering data to formulate reply and preparing correspondence.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4031.00', 'Court, Municipal, and License Clerks', 'Perform clerical duties for courts of law, municipalities, or governmental licensing agencies and bureaus. May prepare docket of cases to be called; secure information for judges and court; prepare draft agendas or bylaws for town or city council; answer official correspondence; keep fiscal records and accounts; issue licenses or permits; and record data, administer tests, or collect fees.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4031.01', 'Court Clerks', 'Perform clerical duties in court of law; prepare docket of cases to be called; secure information for judges; and contact witnesses, attorneys, and litigants to obtain information for court.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4031.02', 'Municipal Clerks', 'Draft agendas and bylaws for town or city council; record minutes of council meetings; answer official correspondence; keep fiscal records and accounts; and prepare reports on civic needs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4031.03', 'License Clerks', 'Issue licenses or permits to qualified applicants. Obtain necessary information, record data, advise applicants on requirements, collect fees, and issue licenses. May conduct oral, written, visual, or performance testing.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4041.00', 'Credit Authorizers, Checkers, and Clerks', 'Authorize credit charges against customers'' accounts. Investigate history and credit standing of individuals or business establishments applying for credit. May interview applicants to obtain personal and financial data; determine credit worthiness; process applications; and notify customers of acceptance or rejection of credit.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4041.01', 'Credit Authorizers', 'Authorize credit charges against customers'' accounts.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4041.02', 'Credit Checkers', 'Investigate history and credit standing of individuals or business establishments applying for credit. Telephone or write to credit departments of business and service establishments to obtain information about applicant''s credit standing.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4051.00', 'Customer Service Representatives', 'Interact with customers to provide information in response to inquiries about products and services and to handle and resolve complaints.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4051.03', 'Patient Representatives', 'Assist patients in obtaining services, understanding policies and making health care decisions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4061.00', 'Eligibility Interviewers, Government Programs', 'Determine eligibility of persons applying to receive assistance from government programs and agency resources, such as welfare, unemployment benefits, social security, and public housing.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4071.00', 'File Clerks', 'File correspondence, cards, invoices, receipts, and other records in alphabetical or numerical order or according to the filing system used. Locate and remove material from file when requested.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4081.00', 'Hotel, Motel, and Resort Desk Clerks', 'Accommodate hotel, motel, and resort patrons by registering and assigning rooms to guests, issuing room keys or cards, transmitting and receiving messages, keeping records of occupied rooms and guests'' accounts, making and confirming reservations, and presenting statements to and collecting payments from departing guests.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4111.00', 'Interviewers, Except Eligibility and Loan', 'Interview persons by telephone, mail, in person, or by other means for the purpose of completing forms, applications, or questionnaires. Ask specific questions, record answers, and assist persons with completing form. May sort, classify, and file forms.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4121.00', 'Library Assistants, Clerical', 'Compile records, sort, shelve, issue, and receive library materials such as books, electronic media, pictures, cards, slides and microfilm. Locate library materials for loan and replace material in shelving area, stacks, or files according to identification number and title. Register patrons to permit them to borrow books, periodicals, and other library materials.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4131.00', 'Loan Interviewers and Clerks', 'Interview loan applicants to elicit information; investigate applicants'' backgrounds and verify references; prepare loan request papers; and forward findings, reports, and documents to appraisal department. Review loan papers to ensure completeness, and complete transactions between loan establishment, borrowers, and sellers upon approval of loan.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4141.00', 'New Accounts Clerks', 'Interview persons desiring to open accounts in financial institutions. Explain account services available to prospective customers and assist them in preparing applications.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4151.00', 'Order Clerks', 'Receive and process incoming orders for materials, merchandise, classified ads, or services such as repairs, installations, or rental of facilities. Generally receives orders via mail, phone, fax, or other electronic means. Duties include informing customers of receipt, prices, shipping dates, and delays; preparing contracts; and handling complaints.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4161.00', 'Human Resources Assistants, Except Payroll and Timekeeping', 'Compile and keep personnel records. Record data for each employee, such as address, weekly earnings, absences, amount of sales or production, supervisory reports, and date of and reason for termination. May prepare reports for employment records, file employment records, or search employee files and furnish information to authorized persons.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4171.00', 'Receptionists and Information Clerks', 'Answer inquiries and provide information to the general public, customers, visitors, and other interested parties regarding activities conducted at establishment and location of departments, offices, and employees within the organization.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4181.00', 'Reservation and Transportation Ticket Agents and Travel Clerks', 'Make and confirm reservations for transportation or lodging, or sell transportation tickets. May check baggage and direct passengers to designated concourse, pier, or track; deliver tickets, contact individuals and groups to inform them of package tours; or provide tourists with travel or transportation information.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-4199.00', 'Information and Record Clerks, All Other', 'All information and record clerks not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5011.00', 'Cargo and Freight Agents', 'Expedite and route movement of incoming and outgoing cargo and freight shipments in airline, train, and trucking terminals, and shipping docks. Take orders from customers and arrange pickup of freight and cargo for delivery to loading platform. Prepare and examine bills of lading to determine shipping charges and tariffs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5011.01', 'Freight Forwarders', 'Research rates, routings, or modes of transport for shipment of products. Maintain awareness of regulations affecting the international movement of cargo. Make arrangements for additional services, such as storage or inland transportation.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5021.00', 'Couriers and Messengers', 'Pick up and deliver messages, documents, packages, and other items between offices or departments within an establishment or directly to other business concerns, traveling by foot, bicycle, motorcycle, automobile, or public conveyance.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5031.00', 'Police, Fire, and Ambulance Dispatchers', 'Operate radio, telephone, or computer equipment at emergency response centers. Receive reports from the public of crimes, disturbances, fires, and medical or police emergencies. Relay information to law enforcement and emergency response personnel. May maintain contact with caller until responders arrive.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5032.00', 'Dispatchers, Except Police, Fire, and Ambulance', 'Schedule and dispatch workers, work crews, equipment, or service vehicles for conveyance of materials, freight, or passengers, or for normal installation, service, or emergency repairs rendered outside the place of business. Duties may include using radio, telephone, or computer to transmit assignments and compiling statistics and reports on work progress.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5041.00', 'Meter Readers, Utilities', 'Read meter and record consumption of electricity, gas, water, or steam.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5051.00', 'Postal Service Clerks', 'Perform any combination of tasks in a post office, such as receive letters and parcels; sell postage and revenue stamps, postal cards, and stamped envelopes; fill out and sell money orders; place mail in pigeon holes of mail rack or in bags; and examine mail for correct postage.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5052.00', 'Postal Service Mail Carriers', 'Sort mail for delivery. Deliver mail on established route by vehicle or on foot.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5053.00', 'Postal Service Mail Sorters, Processors, and Processing Machine Operators', 'Prepare incoming and outgoing mail for distribution. Examine, sort, and route mail. Load, operate, and occasionally adjust and repair mail processing, sorting, and canceling machinery. Keep records of shipments, pouches, and sacks; and other duties related to mail handling within the postal service.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5061.00', 'Production, Planning, and Expediting Clerks', 'Coordinate and expedite the flow of work and materials within or between departments of an establishment according to production schedule. Duties include reviewing and distributing production, work, and shipment schedules; conferring with department supervisors to determine progress of work and completion dates; and compiling reports on progress of work, inventory levels, costs, and production problems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5071.00', 'Shipping, Receiving, and Traffic Clerks', 'Verify and maintain records on incoming and outgoing shipments. Prepare items for shipment. Duties include assembling, addressing, stamping, and shipping merchandise or material; receiving, unpacking, verifying and recording incoming merchandise or material; and arranging for the transportation of products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5081.00', 'Stock Clerks and Order Fillers', 'Receive, store, and issue sales floor merchandise, materials, equipment, and other items from stockroom, warehouse, or storage yard to fill shelves, racks, tables, or customers'' orders. May mark prices on merchandise and set up sales displays.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5081.01', 'Stock Clerks, Sales Floor', 'Receive, store, and issue sales floor merchandise. Stock shelves, racks, cases, bins, and tables with merchandise and arrange merchandise displays to attract customers. May periodically take physical count of stock or check and mark merchandise.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5081.02', 'Marking Clerks', 'Print and attach price tickets to articles of merchandise using one or several methods, such as marking price on tickets by hand or using ticket-printing machine.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5081.03', 'Stock Clerks- Stockroom, Warehouse, or Storage Yard', 'Receive, store, and issue materials, equipment, and other items from stockroom, warehouse, or storage yard. Keep records and compile stock reports.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5081.04', 'Order Fillers, Wholesale and Retail Sales', 'Fill customers'' mail and telephone orders from stored merchandise in accordance with specifications on sales slips or order forms. Duties include computing prices of items, completing order receipts, keeping records of out-going orders, and requisitioning additional materials, supplies, and equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-5111.00', 'Weighers, Measurers, Checkers, and Samplers, Recordkeeping', 'Weigh, measure, and check materials, supplies, and equipment for the purpose of keeping relevant records. Duties are primarily clerical by nature. Includes workers who collect and keep record of samples of products or materials.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-6011.00', 'Executive Secretaries and Executive Administrative Assistants', 'Provide high-level administrative support by conducting research, preparing statistical reports, handling information requests, and performing clerical functions such as preparing correspondence, receiving visitors, arranging conference calls, and scheduling meetings. May also train and supervise lower-level clerical staff.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-6012.00', 'Legal Secretaries', 'Perform secretarial duties using legal terminology, procedures, and documents. Prepare legal papers and correspondence, such as summonses, complaints, motions, and subpoenas. May also assist with legal research.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-6013.00', 'Medical Secretaries', 'Perform secretarial duties using specific knowledge of medical terminology and hospital, clinic, or laboratory procedures. Duties may include scheduling appointments, billing patients, and compiling and recording medical charts, reports, and correspondence.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-6014.00', 'Secretaries and Administrative Assistants, Except Legal, Medical, and Executive', 'Perform routine clerical and administrative functions such as drafting correspondence, scheduling appointments, organizing and maintaining paper and electronic files, or providing information to callers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-9011.00', 'Computer Operators', 'Monitor and control electronic computer and peripheral electronic data processing equipment to process business, scientific, engineering, and other data according to operating instructions. Monitor and respond to operating and error messages. May enter commands at a computer terminal and set controls on computer and peripheral devices.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-9021.00', 'Data Entry Keyers', 'Operate data entry device, such as keyboard or photo composing perforator. Duties may include verifying data and preparing materials for printing.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-9022.00', 'Word Processors and Typists', 'Use word processor, computer or typewriter to type letters, reports, forms, or other material from rough draft, corrected copy, or voice recording. May perform other clerical duties as assigned.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-9031.00', 'Desktop Publishers', 'Format typescript and graphic elements using computer software to produce publication-ready material.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-9041.00', 'Insurance Claims and Policy Processing Clerks', 'Process new insurance policies, modifications to existing policies, and claims forms. Obtain information from policyholders to verify the accuracy and completeness of information on claims forms, applications and related documents, and company records. Update existing policies and company records to reflect changes requested by policyholders and insurance company representatives.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-9041.01', 'Insurance Claims Clerks', 'Obtain information from insured or designated persons for purpose of settling claim with insurance carrier.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-9041.02', 'Insurance Policy Processing Clerks', 'Process applications for, changes to, reinstatement of, and cancellation of insurance policies. Duties include reviewing insurance applications to ensure that all questions have been answered, compiling data on insurance policy changes, changing policy records to conform to insured party''s specifications, compiling data on lapsed insurance policies to determine automatic reinstatement according to company policies, canceling insurance policies as requested by agents, and verifying the accuracy of insurance company records.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-9051.00', 'Mail Clerks and Mail Machine Operators, Except Postal Service', 'Prepare incoming and outgoing mail for distribution. Use hand or mail handling machines to time stamp, open, read, sort, and route incoming mail; and address, seal, stamp, fold, stuff, and affix postage to outgoing mail or packages. Duties may also include keeping necessary records and completed forms.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-9061.00', 'Office Clerks, General', 'Perform duties too varied and diverse to be classified in any specific office clerical occupation, requiring knowledge of office systems and procedures. Clerical duties may be assigned in accordance with the office procedures of individual establishments and may include a combination of answering telephones, bookkeeping, typing or word processing, stenography, office machine operation, and filing.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-9071.00', 'Office Machine Operators, Except Computer', 'Operate one or more of a variety of office machines, such as photocopying, photographic, and duplicating machines, or other office machines.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-9081.00', 'Proofreaders and Copy Markers', 'Read transcript or proof type setup to detect and mark for correction any grammatical, typographical, or compositional errors. Includes proofreaders of Braille.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-9111.00', 'Statistical Assistants', 'Compile and compute data according to statistical formulas for use in statistical studies. May perform actuarial computations and compile charts and graphs for use by actuaries. Includes actuarial clerks.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-9111.01', 'Bioinformatics Technicians', 'Apply principles and methods of bioinformatics to assist scientists in areas such as pharmaceuticals, medical technology, biotechnology, computational biology, proteomics, computer information science, biology and medical informatics. Apply bioinformatics tools to visualize, analyze, manipulate or interpret molecular data. May build and maintain databases for processing and analyzing genomic or other biological information.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('43-9199.00', 'Office and Administrative Support Workers, All Other', 'All office and administrative support workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-1011.00', 'First-Line Supervisors of Farming, Fishing, and Forestry Workers', 'Directly supervise and coordinate the activities of agricultural, forestry, aquacultural, and related workers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-1011.05', 'First-Line Supervisors of Logging Workers', 'Directly supervise and coordinate activities of logging workers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-1011.06', 'First-Line Supervisors of Aquacultural Workers', 'Directly supervise and coordinate activities of aquacultural workers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-1011.07', 'First-Line Supervisors of Agricultural Crop and Horticultural Workers', 'Directly supervise and coordinate activities of agricultural crop or horticultural workers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-1011.08', 'First-Line Supervisors of Animal Husbandry and Animal Care Workers', 'Directly supervise and coordinate activities of animal husbandry or animal care workers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-2011.00', 'Agricultural Inspectors', 'Inspect agricultural commodities, processing equipment, and facilities, and fish and logging operations, to ensure compliance with regulations and laws governing health, quality, and safety.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-2021.00', 'Animal Breeders', 'Select and breed animals according to their genealogy, characteristics, and offspring. May require knowledge of artificial insemination techniques and equipment use. May involve keeping records on heats, birth intervals, or pedigree.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-2041.00', 'Graders and Sorters, Agricultural Products', 'Grade, sort, or classify unprocessed food and other agricultural products by size, weight, color, or condition.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-2091.00', 'Agricultural Equipment Operators', 'Drive and control farm equipment to till soil and to plant, cultivate, and harvest crops. May perform tasks, such as crop baling or hay bucking. May operate stationary equipment to perform post-harvest tasks, such as husking, shelling, threshing, and ginning.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-2092.00', 'Farmworkers and Laborers, Crop, Nursery, and Greenhouse', 'Manually plant, cultivate, and harvest vegetables, fruits, nuts, horticultural specialties, and field crops. Use hand tools, such as shovels, trowels, hoes, tampers, pruning hooks, shears, and knives. Duties may include tilling soil and applying fertilizers; transplanting, weeding, thinning, or pruning crops; applying pesticides; or cleaning, grading, sorting, packing, and loading harvested products. May construct trellises, repair fences and farm buildings, or participate in irrigation activities.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-2092.01', 'Nursery Workers', 'Work in nursery facilities or at customer location planting, cultivating, harvesting, and transplanting trees, shrubs, or plants.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-2092.02', 'Farmworkers and Laborers, Crop', 'Manually plant, cultivate, and harvest vegetables, fruits, nuts and field crops. Use hand tools, such as shovels, trowels, hoes, tampers, pruning hooks, shears, and knives. Duties may include tilling soil and applying fertilizers; transplanting, weeding, thinning, or pruning crops; applying pesticides; cleaning, packing, and loading harvested products. May construct trellises, repair fences and farm buildings, or participate in irrigation activities.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-2093.00', 'Farmworkers, Farm, Ranch, and Aquacultural Animals', 'Attend to live farm, ranch, or aquacultural animals that may include cattle, sheep, swine, goats, horses and other equines, poultry, finfish, shellfish, and bees. Attend to animals produced for animal products, such as meat, fur, skins, feathers, eggs, milk, and honey. Duties may include feeding, watering, herding, grazing, castrating, branding, de-beaking, weighing, catching, and loading animals. May maintain records on animals; examine animals to detect diseases and injuries; assist in birth deliveries; and administer medications, vaccinations, or insecticides as appropriate. May clean and maintain animal housing areas. Includes workers who shear wool from sheep, and collect eggs in hatcheries.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-2099.00', 'Agricultural Workers, All Other', 'All agricultural workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-3011.00', 'Fishers and Related Fishing Workers', 'Use nets, fishing rods, traps, or other equipment to catch and gather fish or other aquatic animals from rivers, lakes, or oceans, for human consumption or other uses. May haul game onto ship.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-3021.00', 'Hunters and Trappers', 'Hunt and trap wild animals for human consumption, fur, feed, bait, or other purposes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-4011.00', 'Forest and Conservation Workers', 'Under supervision, perform manual labor necessary to develop, maintain, or protect areas such as forests, forested areas, woodlands, wetlands, and rangelands through such activities as raising and transporting seedlings; combating insects, pests, and diseases harmful to plant life; and building structures to control water, erosion, and leaching of soil. Includes forester aides, seedling pullers, and tree planters.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-4021.00', 'Fallers', 'Use axes or chainsaws to fell trees using knowledge of tree characteristics and cutting techniques to control direction of fall and minimize tree damage.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-4022.00', 'Logging Equipment Operators', 'Drive logging tractor or wheeled vehicle equipped with one or more accessories such as bulldozer blade, frontal shear, grapple, logging arch, cable winches, hoisting rack, or crane boom, to fell tree; to skid, load, unload, or stack logs; or to pull stumps or clear brush.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-4023.00', 'Log Graders and Scalers', 'Grade logs or estimate the marketable content or value of logs or pulpwood in sorting yards, millpond, log deck, or similar locations. Inspect logs for defects or measure logs to determine volume.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('45-4029.00', 'Logging Workers, All Other', 'All logging workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-1011.00', 'First-Line Supervisors of Construction Trades and Extraction Workers', 'Directly supervise and coordinate activities of construction or extraction workers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-1011.03', 'Solar Energy Installation Managers', 'Direct work crews installing residential or commercial solar photovoltaic or thermal systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2011.00', 'Boilermakers', 'Construct, assemble, maintain, and repair stationary steam boilers and boiler house auxiliaries. Align structures or plate sections to assemble boiler frame tanks or vats, following blueprints. Work involves use of hand and power tools, plumb bobs, levels, wedges, dogs, or turnbuckles. Assist in testing assembled vessels. Direct cleaning of boilers and boiler furnaces. Inspect and repair boiler fittings, such as safety valves, regulators, automatic-control mechanisms, water columns, and auxiliary machines.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2021.00', 'Brickmasons and Blockmasons', 'Lay and bind building materials, such as brick, structural tile, concrete block, cinder block, glass block, and terra-cotta block, with mortar and other substances to construct or repair walls, partitions, arches, sewers, and other structures.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2022.00', 'Stonemasons', 'Build stone structures, such as piers, walls, and abutments. Lay walks, curbstones, or special types of masonry for vats, tanks, and floors.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2031.00', 'Carpenters', 'Construct, erect, install, or repair structures and fixtures made of wood, such as concrete forms; building frameworks, including partitions, joists, studding, and rafters; and wood stairways, window and door frames, and hardwood floors. May also install cabinets, siding, drywall and batt or roll insulation. Includes brattice builders who build doors or brattices (ventilation walls or partitions) in underground passageways.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2031.01', 'Construction Carpenters', 'Construct, erect, install, and repair structures and fixtures of wood, plywood, and wallboard, using carpenter''s hand tools and power tools.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2031.02', 'Rough Carpenters', 'Build rough wooden structures, such as concrete forms, scaffolds, tunnel, bridge, or sewer supports, billboard signs, and temporary frame shelters, according to sketches, blueprints, or oral instructions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2041.00', 'Carpet Installers', 'Lay and install carpet from rolls or blocks on floors. Install padding and trim flooring materials.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2042.00', 'Floor Layers, Except Carpet, Wood, and Hard Tiles', 'Apply blocks, strips, or sheets of shock-absorbing, sound-deadening, or decorative coverings to floors.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2043.00', 'Floor Sanders and Finishers', 'Scrape and sand wooden floors to smooth surfaces using floor scraper and floor sanding machine, and apply coats of finish.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2044.00', 'Tile and Marble Setters', 'Apply hard tile, marble, and wood tile to walls, floors, ceilings, and roof decks.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2051.00', 'Cement Masons and Concrete Finishers', 'Smooth and finish surfaces of poured concrete, such as floors, walks, sidewalks, roads, or curbs using a variety of hand and power tools. Align forms for sidewalks, curbs, or gutters; patch voids; and use saws to cut expansion joints.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2053.00', 'Terrazzo Workers and Finishers', 'Apply a mixture of cement, sand, pigment, or marble chips to floors, stairways, and cabinet fixtures to fashion durable and decorative surfaces.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2061.00', 'Construction Laborers', 'Perform tasks involving physical labor at construction sites. May operate hand and power tools of all types: air hammers, earth tampers, cement mixers, small mechanical hoists, surveying and measuring equipment, and a variety of other equipment and instruments. May clean and prepare sites, dig trenches, set braces to support the sides of excavations, erect scaffolding, and clean up rubble, debris and other waste materials. May assist other craft workers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2071.00', 'Paving, Surfacing, and Tamping Equipment Operators', 'Operate equipment used for applying concrete, asphalt, or other materials to road beds, parking lots, or airport runways and taxiways, or equipment used for tamping gravel, dirt, or other materials. Includes concrete and asphalt paving machine operators, form tampers, tamping machine operators, and stone spreader operators.');
GO
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2072.00', 'Pile-Driver Operators', 'Operate pile drivers mounted on skids, barges, crawler treads, or locomotive cranes to drive pilings for retaining walls, bulkheads, and foundations of structures, such as buildings, bridges, and piers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2073.00', 'Operating Engineers and Other Construction Equipment Operators', 'Operate one or several types of power construction equipment, such as motor graders, bulldozers, scrapers, compressors, pumps, derricks, shovels, tractors, or front-end loaders to excavate, move, and grade earth, erect structures, or pour concrete or other hard surface pavement. May repair and maintain equipment in addition to other duties.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2081.00', 'Drywall and Ceiling Tile Installers', 'Apply plasterboard or other wallboard to ceilings or interior walls of buildings. Apply or mount acoustical tiles or blocks, strips, or sheets of shock-absorbing materials to ceilings and walls of buildings to reduce or reflect sound. Materials may be of decorative quality. Includes lathers who fasten wooden, metal, or rockboard lath to walls, ceilings or partitions of buildings to provide support base for plaster, fire-proofing, or acoustical material.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2082.00', 'Tapers', 'Seal joints between plasterboard or other wallboard to prepare wall surface for painting or papering.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2111.00', 'Electricians', 'Install, maintain, and repair electrical wiring, equipment, and fixtures. Ensure that work is in accordance with relevant codes. May install or service street lights, intercom systems, or electrical control systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2121.00', 'Glaziers', 'Install glass in windows, skylights, store fronts, and display cases, or on surfaces, such as building fronts, interior walls, ceilings, and tabletops.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2131.00', 'Insulation Workers, Floor, Ceiling, and Wall', 'Line and cover structures with insulating materials. May work with batt, roll, or blown insulation materials.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2132.00', 'Insulation Workers, Mechanical', 'Apply insulating materials to pipes or ductwork, or other mechanical systems in order to help control and maintain temperature.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2141.00', 'Painters, Construction and Maintenance', 'Paint walls, equipment, buildings, bridges, and other structural surfaces, using brushes, rollers, and spray guns. May remove old paint to prepare surface prior to painting. May mix colors or oils to obtain desired color or consistency.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2142.00', 'Paperhangers', 'Cover interior walls or ceilings of rooms with decorative wallpaper or fabric, or attach advertising posters on surfaces such as walls and billboards. May remove old materials or prepare surfaces to be papered.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2151.00', 'Pipelayers', 'Lay pipe for storm or sanitation sewers, drains, and water mains. Perform any combination of the following tasks: grade trenches or culverts, position pipe, or seal joints.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2152.00', 'Plumbers, Pipefitters, and Steamfitters', 'Assemble, install, alter, and repair pipelines or pipe systems that carry water, steam, air, or other liquids or gases. May install heating and cooling equipment and mechanical control systems. Includes sprinklerfitters.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2152.01', 'Pipe Fitters and Steamfitters', 'Lay out, assemble, install, or maintain pipe systems, pipe supports, or related hydraulic or pneumatic equipment for steam, hot water, heating, cooling, lubricating, sprinkling, or industrial production or processing systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2152.02', 'Plumbers', 'Assemble, install, or repair pipes, fittings, or fixtures of heating, water, or drainage systems, according to specifications or plumbing codes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2161.00', 'Plasterers and Stucco Masons', 'Apply interior or exterior plaster, cement, stucco, or similar materials. May also set ornamental plaster.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2171.00', 'Reinforcing Iron and Rebar Workers', 'Position and secure steel bars or mesh in concrete forms in order to reinforce concrete. Use a variety of fasteners, rod-bending machines, blowtorches, and hand tools. Includes rod busters.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2181.00', 'Roofers', 'Cover roofs of structures with shingles, slate, asphalt, aluminum, wood, or related materials. May spray roofs, sidings, and walls with material to bind, seal, insulate, or soundproof sections of structures.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2211.00', 'Sheet Metal Workers', 'Fabricate, assemble, install, and repair sheet metal products and equipment, such as ducts, control boxes, drainpipes, and furnace casings. Work may involve any of the following: setting up and operating fabricating machines to cut, bend, and straighten sheet metal; shaping metal over anvils, blocks, or forms using hammer; operating soldering and welding equipment to join sheet metal parts; or inspecting, assembling, and smoothing seams and joints of burred surfaces. Includes sheet metal duct installers who install prefabricated sheet metal ducts used for heating, air conditioning, or other purposes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2221.00', 'Structural Iron and Steel Workers', 'Raise, place, and unite iron or steel girders, columns, and other structural members to form completed structures or structural frameworks. May erect metal storage tanks and assemble prefabricated metal buildings.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-2231.00', 'Solar Photovoltaic Installers', 'Assemble, install, or maintain solar photovoltaic (PV) systems on roofs or other structures in compliance with site assessment and schematics. May include measuring, cutting, assembling, and bolting structural framing and solar modules. May perform minor electrical work such as current checks.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-3011.00', 'Helpers--Brickmasons, Blockmasons, Stonemasons, and Tile and Marble Setters', 'Help brickmasons, blockmasons, stonemasons, or tile and marble setters by performing duties requiring less skill. Duties include using, supplying or holding materials or tools, and cleaning work area and equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-3012.00', 'Helpers--Carpenters', 'Help carpenters by performing duties requiring less skill. Duties include using, supplying or holding materials or tools, and cleaning work area and equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-3013.00', 'Helpers--Electricians', 'Help electricians by performing duties requiring less skill. Duties include using, supplying or holding materials or tools, and cleaning work area and equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-3014.00', 'Helpers--Painters, Paperhangers, Plasterers, and Stucco Masons', 'Help painters, paperhangers, plasterers, or stucco masons by performing duties requiring less skill. Duties include using, supplying or holding materials or tools, and cleaning work area and equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-3015.00', 'Helpers--Pipelayers, Plumbers, Pipefitters, and Steamfitters', 'Help plumbers, pipefitters, steamfitters, or pipelayers by performing duties requiring less skill. Duties include using, supplying or holding materials or tools, and cleaning work area and equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-3016.00', 'Helpers--Roofers', 'Help roofers by performing duties requiring less skill. Duties include using, supplying or holding materials or tools, and cleaning work area and equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-3019.00', 'Helpers, Construction Trades, All Other', 'All construction trades helpers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-4011.00', 'Construction and Building Inspectors', 'Inspect structures using engineering skills to determine structural soundness and compliance with specifications, building codes, and other regulations. Inspections may be general in nature or may be limited to a specific area, such as electrical systems or plumbing.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-4021.00', 'Elevator Installers and Repairers', 'Assemble, install, repair, or maintain electric or hydraulic freight or passenger elevators, escalators, or dumbwaiters.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-4031.00', 'Fence Erectors', 'Erect and repair fences and fence gates, using hand and power tools.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-4041.00', 'Hazardous Materials Removal Workers', 'Identify, remove, pack, transport, or dispose of hazardous materials, including asbestos, lead-based paint, waste oil, fuel, transmission fluid, radioactive materials, or contaminated soil. Specialized training and certification in hazardous materials handling or a confined entry permit are generally required. May operate earth-moving equipment or trucks.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-4051.00', 'Highway Maintenance Workers', 'Maintain highways, municipal and rural roads, airport runways, and rights-of-way. Duties include patching broken or eroded pavement, repairing guard rails, highway markers, and snow fences. May also mow or clear brush from along road or plow snow from roadway.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-4061.00', 'Rail-Track Laying and Maintenance Equipment Operators', 'Lay, repair, and maintain track for standard or narrow-gauge railroad equipment used in regular railroad service or in plant yards, quarries, sand and gravel pits, and mines. Includes ballast cleaning machine operators and railroad bed tamping machine operators.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-4071.00', 'Septic Tank Servicers and Sewer Pipe Cleaners', 'Clean and repair septic tanks, sewer lines, or drains. May patch walls and partitions of tank, replace damaged drain tile, or repair breaks in underground piping.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-4091.00', 'Segmental Pavers', 'Lay out, cut, and place segmental paving units. Includes installers of bedding and restraining materials for the paving units.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-4099.00', 'Construction and Related Workers, All Other', 'All construction and related workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-4099.02', 'Solar Thermal Installers and Technicians', 'Install or repair solar energy systems designed to collect, store, and circulate solar-heated water for residential, commercial or industrial use.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-4099.03', 'Weatherization Installers and Technicians', 'Perform a variety of activities to weatherize homes and make them more energy efficient. Duties include repairing windows, insulating ducts, and performing heating, ventilating, and air-conditioning (HVAC) work. May perform energy audits and advise clients on energy conservation measures.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-5011.00', 'Derrick Operators, Oil and Gas', 'Rig derrick equipment and operate pumps to circulate mud through drill hole.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-5012.00', 'Rotary Drill Operators, Oil and Gas', 'Set up or operate a variety of drills to remove underground oil and gas, or remove core samples for testing during oil and gas exploration.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-5013.00', 'Service Unit Operators, Oil, Gas, and Mining', 'Operate equipment to increase oil flow from producing wells or to remove stuck pipe, casing, tools, or other obstructions from drilling wells. May also perform similar services in mining exploration operations. Includes fishing-tool technicians.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-5021.00', 'Earth Drillers, Except Oil and Gas', 'Operate a variety of drills such as rotary, churn, and pneumatic to tap sub-surface water and salt deposits, to remove core samples during mineral exploration or soil testing, and to facilitate the use of explosives in mining or construction. May use explosives. Includes horizontal and earth boring machine operators.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-5031.00', 'Explosives Workers, Ordnance Handling Experts, and Blasters', 'Place and detonate explosives to demolish structures or to loosen, remove, or displace earth, rock, or other materials. May perform specialized handling, storage, and accounting procedures. Includes seismograph shooters.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-5041.00', 'Continuous Mining Machine Operators', 'Operate self-propelled mining machines that rip coal, metal and nonmetal ores, rock, stone, or sand from the mine face and load it onto conveyors or into shuttle cars in a continuous operation.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-5042.00', 'Mine Cutting and Channeling Machine Operators', 'Operate machinery such as longwall shears, plows, and cutting machines to cut or channel along the face or seams of coal mines, stone quarries, or other mining surfaces to facilitate blasting, separating, or removing minerals or materials from mines or from the Earth''s surface. Includes shale planers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-5049.00', 'Mining Machine Operators, All Other', 'All mining machine operators not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-5051.00', 'Rock Splitters, Quarry', 'Separate blocks of rough dimension stone from quarry mass using jackhammer and wedges.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-5061.00', 'Roof Bolters, Mining', 'Operate machinery to install roof support bolts in underground mine.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-5071.00', 'Roustabouts, Oil and Gas', 'Assemble or repair oil field equipment using hand and power tools. Perform other tasks as needed.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-5081.00', 'Helpers--Extraction Workers', 'Help extraction craft workers, such as earth drillers, blasters and explosives workers, derrick operators, and mining machine operators, by performing duties requiring less skill. Duties include supplying equipment or cleaning work area.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('47-5099.00', 'Extraction Workers, All Other', 'All extraction workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-1011.00', 'First-Line Supervisors of Mechanics, Installers, and Repairers', 'Directly supervise and coordinate the activities of mechanics, installers, and repairers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-2011.00', 'Computer, Automated Teller, and Office Machine Repairers', 'Repair, maintain, or install computers, word processing systems, automated teller machines, and electronic office machines, such as duplicating and fax machines.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-2021.00', 'Radio, Cellular, and Tower Equipment Installers and Repairers', 'Repair, install or maintain mobile or stationary radio transmitting, broadcasting, and receiving equipment, and two-way radio communications systems used in cellular telecommunications, mobile broadband, ship-to-shore, aircraft-to-ground communications, and radio equipment in service and emergency vehicles. May test and analyze network coverage.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-2021.01', 'Radio Mechanics', 'Test or repair mobile or stationary radio transmitting and receiving equipment and two-way radio communications systems used in ship-to-shore communications and found in service and emergency vehicles.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-2022.00', 'Telecommunications Equipment Installers and Repairers, Except Line Installers', 'Install, set-up, rearrange, or remove switching, distribution, routing, and dialing equipment used in central offices or headends. Service or repair telephone, cable television, Internet, and other communications equipment on customers'' property. May install communications equipment or communications wiring in buildings.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-2091.00', 'Avionics Technicians', 'Install, inspect, test, adjust, or repair avionics equipment, such as radar, radio, navigation, and missile control systems in aircraft or space vehicles.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-2092.00', 'Electric Motor, Power Tool, and Related Repairers', 'Repair, maintain, or install electric motors, wiring, or switches.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-2093.00', 'Electrical and Electronics Installers and Repairers, Transportation Equipment', 'Install, adjust, or maintain mobile electronics communication equipment, including sound, sonar, security, navigation, and surveillance systems on trains, watercraft, or other mobile equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-2094.00', 'Electrical and Electronics Repairers, Commercial and Industrial Equipment', 'Repair, test, adjust, or install electronic equipment, such as industrial controls, transmitters, and antennas.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-2095.00', 'Electrical and Electronics Repairers, Powerhouse, Substation, and Relay', 'Inspect, test, repair, or maintain electrical equipment in generating stations, substations, and in-service relays.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-2096.00', 'Electronic Equipment Installers and Repairers, Motor Vehicles', 'Install, diagnose, or repair communications, sound, security, or navigation equipment in motor vehicles.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-2097.00', 'Electronic Home Entertainment Equipment Installers and Repairers', 'Repair, adjust, or install audio or television receivers, stereo systems, camcorders, video systems, or other electronic home entertainment equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-2098.00', 'Security and Fire Alarm Systems Installers', 'Install, program, maintain, or repair security or fire alarm wiring and equipment. Ensure that work is in accordance with relevant codes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3011.00', 'Aircraft Mechanics and Service Technicians', 'Diagnose, adjust, repair, or overhaul aircraft engines and assemblies, such as hydraulic and pneumatic systems. Includes helicopter and aircraft engine specialists.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3021.00', 'Automotive Body and Related Repairers', 'Repair and refinish automotive vehicle bodies and straighten vehicle frames.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3022.00', 'Automotive Glass Installers and Repairers', 'Replace or repair broken windshields and window glass in motor vehicles.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3023.00', 'Automotive Service Technicians and Mechanics', 'Diagnose, adjust, repair, or overhaul automotive vehicles.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3023.01', 'Automotive Master Mechanics', 'Repair automobiles, trucks, buses, and other vehicles. Master mechanics repair virtually any part on the vehicle or specialize in the transmission system.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3023.02', 'Automotive Specialty Technicians', 'Repair only one system or component on a vehicle, such as brakes, suspension, or radiator.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3031.00', 'Bus and Truck Mechanics and Diesel Engine Specialists', 'Diagnose, adjust, repair, or overhaul buses and trucks, or maintain and repair any type of diesel engines. Includes mechanics working primarily with automobile or marine diesel engines.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3041.00', 'Farm Equipment Mechanics and Service Technicians', 'Diagnose, adjust, repair, or overhaul farm machinery and vehicles, such as tractors, harvesters, dairy equipment, and irrigation systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3042.00', 'Mobile Heavy Equipment Mechanics, Except Engines', 'Diagnose, adjust, repair, or overhaul mobile mechanical, hydraulic, and pneumatic equipment, such as cranes, bulldozers, graders, and conveyors, used in construction, logging, and surface mining.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3043.00', 'Rail Car Repairers', 'Diagnose, adjust, repair, or overhaul railroad rolling stock, mine cars, or mass transit rail cars.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3051.00', 'Motorboat Mechanics and Service Technicians', 'Repair and adjust electrical and mechanical equipment of inboard or inboard-outboard boat engines.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3052.00', 'Motorcycle Mechanics', 'Diagnose, adjust, repair, or overhaul motorcycles, scooters, mopeds, dirt bikes, or similar motorized vehicles.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3053.00', 'Outdoor Power Equipment and Other Small Engine Mechanics', 'Diagnose, adjust, repair, or overhaul small engines used to power lawn mowers, chain saws, recreational sporting equipment and related equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3091.00', 'Bicycle Repairers', 'Repair and service bicycles.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3092.00', 'Recreational Vehicle Service Technicians', 'Diagnose, inspect, adjust, repair, or overhaul recreational vehicles including travel trailers. May specialize in maintaining gas, electrical, hydraulic, plumbing, or chassis/towing systems as well as repairing generators, appliances, and interior components. Includes workers who perform customized van conversions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-3093.00', 'Tire Repairers and Changers', 'Repair and replace tires.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9011.00', 'Mechanical Door Repairers', 'Install, service, or repair automatic door mechanisms and hydraulic doors. Includes garage door mechanics.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9012.00', 'Control and Valve Installers and Repairers, Except Mechanical Door', 'Install, repair, and maintain mechanical regulating and controlling devices, such as electric meters, gas regulators, thermostats, safety and flow valves, and other mechanical governors.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9021.00', 'Heating, Air Conditioning, and Refrigeration Mechanics and Installers', 'Install or repair heating, central air conditioning, or refrigeration systems, including oil burners, hot-air furnaces, and heating stoves.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9021.01', 'Heating and Air Conditioning Mechanics and Installers', 'Install, service, or repair heating and air conditioning systems in residences or commercial establishments.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9021.02', 'Refrigeration Mechanics and Installers', 'Install and repair industrial and commercial refrigerating systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9031.00', 'Home Appliance Repairers', 'Repair, adjust, or install all types of electric or gas household appliances, such as refrigerators, washers, dryers, and ovens.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9041.00', 'Industrial Machinery Mechanics', 'Repair, install, adjust, or maintain industrial production and processing machinery or refinery and pipeline distribution systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9043.00', 'Maintenance Workers, Machinery', 'Lubricate machinery, change parts, or perform other routine machinery maintenance.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9044.00', 'Millwrights', 'Install, dismantle, or move machinery and heavy equipment according to layout plans, blueprints, or other drawings.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9045.00', 'Refractory Materials Repairers, Except Brickmasons', 'Build or repair equipment such as furnaces, kilns, cupolas, boilers, converters, ladles, soaking pits and ovens, using refractory materials.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9051.00', 'Electrical Power-Line Installers and Repairers', 'Install or repair cables or wires used in electrical power or distribution systems. May erect poles and light or heavy duty transmission towers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9052.00', 'Telecommunications Line Installers and Repairers', 'Install and repair telecommunications cable, including fiber optics.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9061.00', 'Camera and Photographic Equipment Repairers', 'Repair and adjust cameras and photographic equipment, including commercial video and motion picture camera equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9062.00', 'Medical Equipment Repairers', 'Test, adjust, or repair biomedical or electromedical equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9063.00', 'Musical Instrument Repairers and Tuners', 'Repair percussion, stringed, reed, or wind instruments. May specialize in one area, such as piano tuning.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9064.00', 'Watch Repairers', 'Repair, clean, and adjust mechanisms of timing instruments, such as watches and clocks. Includes watchmakers, watch technicians, and mechanical timepiece repairers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9069.00', 'Precision Instrument and Equipment Repairers, All Other', 'All precision instrument and equipment repairers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9071.00', 'Maintenance and Repair Workers, General', 'Perform work involving the skills of two or more maintenance or craft occupations to keep machines, mechanical equipment, or the structure of an establishment in repair. Duties may involve pipe fitting; boiler making; insulating; welding; machining; carpentry; repairing electrical or mechanical equipment; installing, aligning, and balancing new equipment; and repairing buildings, floors, or stairs.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9081.00', 'Wind Turbine Service Technicians', 'Inspect, diagnose, adjust, or repair wind turbines. Perform maintenance on wind turbine equipment including resolving electrical, mechanical, and hydraulic malfunctions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9091.00', 'Coin, Vending, and Amusement Machine Servicers and Repairers', 'Install, service, adjust, or repair coin, vending, or amusement machines including video games, juke boxes, pinball machines, or slot machines.');
GO
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9092.00', 'Commercial Divers', 'Work below surface of water, using scuba gear to inspect, repair, remove, or install equipment and structures. May use a variety of power and hand tools, such as drills, sledgehammers, torches, and welding equipment. May conduct tests or experiments, rig explosives, or photograph structures or marine life.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9093.00', 'Fabric Menders, Except Garment', 'Repair tears, holes, and other defects in fabrics, such as draperies, linens, parachutes, and tents.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9094.00', 'Locksmiths and Safe Repairers', 'Repair and open locks; make keys; change locks and safe combinations; and install and repair safes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9095.00', 'Manufactured Building and Mobile Home Installers', 'Move or install mobile homes or prefabricated buildings.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9096.00', 'Riggers', 'Set up or repair rigging for construction projects, manufacturing plants, logging yards, ships and shipyards, or for the entertainment industry.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9097.00', 'Signal and Track Switch Repairers', 'Install, inspect, test, maintain, or repair electric gate crossings, signals, signal equipment, track switches, section lines, or intercommunications systems within a railroad system.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9098.00', 'Helpers--Installation, Maintenance, and Repair Workers', 'Help installation, maintenance, and repair workers in maintenance, parts replacement, and repair of vehicles, industrial machinery, and electrical and electronic equipment. Perform duties such as furnishing tools, materials, and supplies to other workers; cleaning work area, machines, and tools; and holding materials or tools for other workers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9099.00', 'Installation, Maintenance, and Repair Workers, All Other', 'All installation, maintenance, and repair workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('49-9099.01', 'Geothermal Technicians', 'Perform technical activities at power plants or individual installations necessary for the generation of power from geothermal energy sources. Monitor and control operating activities at geothermal power generation facilities and perform maintenance and repairs as necessary. Install, test, and maintain residential and commercial geothermal heat pumps.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-1011.00', 'First-Line Supervisors of Production and Operating Workers', 'Directly supervise and coordinate the activities of production and operating workers, such as inspectors, precision workers, machine setters and operators, assemblers, fabricators, and plant and system operators.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-2011.00', 'Aircraft Structure, Surfaces, Rigging, and Systems Assemblers', 'Assemble, fit, fasten, and install parts of airplanes, space vehicles, or missiles, such as tails, wings, fuselage, bulkheads, stabilizers, landing gear, rigging and control equipment, or heating and ventilating systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-2021.00', 'Coil Winders, Tapers, and Finishers', 'Wind wire coils used in electrical components, such as resistors and transformers, and in electrical equipment and instruments, such as field cores, bobbins, armature cores, electrical motors, generators, and control equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-2022.00', 'Electrical and Electronic Equipment Assemblers', 'Assemble or modify electrical or electronic equipment, such as computers, test equipment telemetering systems, electric motors, and batteries.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-2023.00', 'Electromechanical Equipment Assemblers', 'Assemble or modify electromechanical equipment or devices, such as servomechanisms, gyros, dynamometers, magnetic drums, tape drives, brakes, control linkage, actuators, and appliances.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-2031.00', 'Engine and Other Machine Assemblers', 'Construct, assemble, or rebuild machines, such as engines, turbines, and similar equipment used in such industries as construction, extraction, textiles, and paper manufacturing.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-2041.00', 'Structural Metal Fabricators and Fitters', 'Fabricate, position, align, and fit parts of structural metal products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-2091.00', 'Fiberglass Laminators and Fabricators', 'Laminate layers of fiberglass on molds to form boat decks and hulls, bodies for golf carts, automobiles, or other products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-2092.00', 'Team Assemblers', 'Work as part of a team having responsibility for assembling an entire product or component of a product. Team assemblers can perform all tasks conducted by the team in the assembly process and rotate through all or most of them rather than being assigned to a specific task on a permanent basis. May participate in making management decisions affecting the work. Includes team leaders who work as part of the team.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-2093.00', 'Timing Device Assemblers and Adjusters', 'Perform precision assembling, adjusting, or calibrating, within narrow tolerances, of timing devices such as digital clocks or timing devices with electrical or electronic components.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-2099.00', 'Assemblers and Fabricators, All Other', 'All assemblers and fabricators not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-3011.00', 'Bakers', 'Mix and bake ingredients to produce breads, rolls, cookies, cakes, pies, pastries, or other baked goods.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-3021.00', 'Butchers and Meat Cutters', 'Cut, trim, or prepare consumer-sized portions of meat for use or sale in retail establishments.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-3022.00', 'Meat, Poultry, and Fish Cutters and Trimmers', 'Use hand or hand tools to perform routine cutting and trimming of meat, poultry, and seafood.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-3023.00', 'Slaughterers and Meat Packers', 'Work in slaughtering, meat packing, or wholesale establishments performing precision functions involving the preparation of meat. Work may include specialized slaughtering tasks, cutting standard or premium cuts of meat for marketing, making sausage, or wrapping meats.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-3091.00', 'Food and Tobacco Roasting, Baking, and Drying Machine Operators and Tenders', 'Operate or tend food or tobacco roasting, baking, or drying equipment, including hearth ovens, kiln driers, roasters, char kilns, and vacuum drying equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-3092.00', 'Food Batchmakers', 'Set up and operate equipment that mixes or blends ingredients used in the manufacturing of food products. Includes candy makers and cheese makers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-3093.00', 'Food Cooking Machine Operators and Tenders', 'Operate or tend cooking equipment, such as steam cooking vats, deep fry cookers, pressure cookers, kettles, and boilers, to prepare food products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-3099.00', 'Food Processing Workers, All Other', 'All food processing workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4011.00', 'Computer-Controlled Machine Tool Operators, Metal and Plastic', 'Operate computer-controlled machines or robots to perform one or more machine functions on metal or plastic work pieces.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4012.00', 'Computer Numerically Controlled Machine Tool Programmers, Metal and Plastic', 'Develop programs to control machining or processing of metal or plastic parts by automatic machine tools, equipment, or systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4021.00', 'Extruding and Drawing Machine Setters, Operators, and Tenders, Metal and Plastic', 'Set up, operate, or tend machines to extrude or draw thermoplastic or metal materials into tubes, rods, hoses, wire, bars, or structural shapes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4022.00', 'Forging Machine Setters, Operators, and Tenders, Metal and Plastic', 'Set up, operate, or tend forging machines to taper, shape, or form metal or plastic parts.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4023.00', 'Rolling Machine Setters, Operators, and Tenders, Metal and Plastic', 'Set up, operate, or tend machines to roll steel or plastic forming bends, beads, knurls, rolls, or plate or to flatten, temper, or reduce gauge of material.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4031.00', 'Cutting, Punching, and Press Machine Setters, Operators, and Tenders, Metal and Plastic', 'Set up, operate, or tend machines to saw, cut, shear, slit, punch, crimp, notch, bend, or straighten metal or plastic material.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4032.00', 'Drilling and Boring Machine Tool Setters, Operators, and Tenders, Metal and Plastic', 'Set up, operate, or tend drilling machines to drill, bore, ream, mill, or countersink metal or plastic work pieces.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4033.00', 'Grinding, Lapping, Polishing, and Buffing Machine Tool Setters, Operators, and Tenders, Metal and Plastic', 'Set up, operate, or tend grinding and related tools that remove excess material or burrs from surfaces, sharpen edges or corners, or buff, hone, or polish metal or plastic work pieces.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4034.00', 'Lathe and Turning Machine Tool Setters, Operators, and Tenders, Metal and Plastic', 'Set up, operate, or tend lathe and turning machines to turn, bore, thread, form, or face metal or plastic materials, such as wire, rod, or bar stock.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4035.00', 'Milling and Planing Machine Setters, Operators, and Tenders, Metal and Plastic', 'Set up, operate, or tend milling or planing machines to mill, plane, shape, groove, or profile metal or plastic work pieces.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4041.00', 'Machinists', 'Set up and operate a variety of machine tools to produce precision parts and instruments. Includes precision instrument makers who fabricate, modify, or repair mechanical instruments. May also fabricate and modify parts to make or repair machine tools or maintain industrial machines, applying knowledge of mechanics, mathematics, metal properties, layout, and machining procedures.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4051.00', 'Metal-Refining Furnace Operators and Tenders', 'Operate or tend furnaces, such as gas, oil, coal, electric-arc or electric induction, open-hearth, or oxygen furnaces, to melt and refine metal before casting or to produce specified types of steel.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4052.00', 'Pourers and Casters, Metal', 'Operate hand-controlled mechanisms to pour and regulate the flow of molten metal into molds to produce castings or ingots.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4061.00', 'Model Makers, Metal and Plastic', 'Set up and operate machines, such as lathes, milling and engraving machines, and jig borers to make working models of metal or plastic objects. Includes template makers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4062.00', 'Patternmakers, Metal and Plastic', 'Lay out, machine, fit, and assemble castings and parts to metal or plastic foundry patterns, core boxes, or match plates.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4071.00', 'Foundry Mold and Coremakers', 'Make or form wax or sand cores or molds used in the production of metal castings in foundries.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4072.00', 'Molding, Coremaking, and Casting Machine Setters, Operators, and Tenders, Metal and Plastic', 'Set up, operate, or tend metal or plastic molding, casting, or coremaking machines to mold or cast metal or thermoplastic parts or products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4081.00', 'Multiple Machine Tool Setters, Operators, and Tenders, Metal and Plastic', 'Set up, operate, or tend more than one type of cutting or forming machine tool or robot.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4111.00', 'Tool and Die Makers', 'Analyze specifications, lay out metal stock, set up and operate machine tools, and fit and assemble parts to make and repair dies, cutting tools, jigs, fixtures, gauges, and machinists'' hand tools.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4121.00', 'Welders, Cutters, Solderers, and Brazers', 'Use hand-welding, flame-cutting, hand soldering, or brazing equipment to weld or join metal components or to fill holes, indentations, or seams of fabricated metal products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4121.06', 'Welders, Cutters, and Welder Fitters', 'Use hand-welding or flame-cutting equipment to weld or join metal components or to fill holes, indentations, or seams of fabricated metal products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4121.07', 'Solderers and Brazers', 'Braze or solder together components to assemble fabricated metal parts, using soldering iron, torch, or welding machine and flux.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4122.00', 'Welding, Soldering, and Brazing Machine Setters, Operators, and Tenders', 'Set up, operate, or tend welding, soldering, or brazing machines or robots that weld, braze, solder, or heat treat metal products, components, or assemblies. Includes workers who operate laser cutters or laser-beam machines.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4191.00', 'Heat Treating Equipment Setters, Operators, and Tenders, Metal and Plastic', 'Set up, operate, or tend heating equipment, such as heat-treating furnaces, flame-hardening machines, induction machines, soaking pits, or vacuum equipment to temper, harden, anneal, or heat-treat metal or plastic objects.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4192.00', 'Layout Workers, Metal and Plastic', 'Lay out reference points and dimensions on metal or plastic stock or workpieces, such as sheets, plates, tubes, structural shapes, castings, or machine parts, for further processing. Includes shipfitters.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4193.00', 'Plating and Coating Machine Setters, Operators, and Tenders, Metal and Plastic', 'Set up, operate, or tend plating or coating machines to coat metal or plastic products with chromium, zinc, copper, cadmium, nickel, or other metal to protect or decorate surfaces. Includes electrolytic processes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4194.00', 'Tool Grinders, Filers, and Sharpeners', 'Perform precision smoothing, sharpening, polishing, or grinding of metal objects.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-4199.00', 'Metal Workers and Plastic Workers, All Other', 'All metal workers and plastic workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-5111.00', 'Prepress Technicians and Workers', 'Format and proof text and images submitted by designers and clients into finished pages that can be printed. Includes digital and photo typesetting. May produce printing plates.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-5112.00', 'Printing Press Operators', 'Set up and operate digital, letterpress, lithographic, flexographic, gravure, or other printing machines. Includes short-run offset printing presses.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-5113.00', 'Print Binding and Finishing Workers', 'Bind books and other publications or finish printed products by hand or machine. May set up binding and finishing machines.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-6011.00', 'Laundry and Dry-Cleaning Workers', 'Operate or tend washing or dry-cleaning machines to wash or dry-clean industrial or household articles, such as cloth garments, suede, leather, furs, blankets, draperies, linens, rugs, and carpets. Includes spotters and dyers of these articles.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-6021.00', 'Pressers, Textile, Garment, and Related Materials', 'Press or shape articles by hand or machine.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-6031.00', 'Sewing Machine Operators', 'Operate or tend sewing machines to join, reinforce, decorate, or perform related sewing operations in the manufacture of garment or nongarment products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-6041.00', 'Shoe and Leather Workers and Repairers', 'Construct, decorate, or repair leather and leather-like products, such as luggage, shoes, and saddles.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-6042.00', 'Shoe Machine Operators and Tenders', 'Operate or tend a variety of machines to join, decorate, reinforce, or finish shoes and shoe parts.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-6051.00', 'Sewers, Hand', 'Sew, join, reinforce, or finish, usually with needle and thread, a variety of manufactured items. Includes weavers and stitchers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-6052.00', 'Tailors, Dressmakers, and Custom Sewers', 'Design, make, alter, repair, or fit garments.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-6061.00', 'Textile Bleaching and Dyeing Machine Operators and Tenders', 'Operate or tend machines to bleach, shrink, wash, dye, or finish textiles or synthetic or glass fibers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-6062.00', 'Textile Cutting Machine Setters, Operators, and Tenders', 'Set up, operate, or tend machines that cut textiles.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-6063.00', 'Textile Knitting and Weaving Machine Setters, Operators, and Tenders', 'Set up, operate, or tend machines that knit, loop, weave, or draw in textiles.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-6064.00', 'Textile Winding, Twisting, and Drawing Out Machine Setters, Operators, and Tenders', 'Set up, operate, or tend machines that wind or twist textiles; or draw out and combine sliver, such as wool, hemp, or synthetic fibers. Includes slubber machine and drawing frame operators.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-6091.00', 'Extruding and Forming Machine Setters, Operators, and Tenders, Synthetic and Glass Fibers', 'Set up, operate, or tend machines that extrude and form continuous filaments from synthetic materials, such as liquid polymer, rayon, and fiberglass.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-6092.00', 'Fabric and Apparel Patternmakers', 'Draw and construct sets of precision master fabric patterns or layouts. May also mark and cut fabrics and apparel.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-6093.00', 'Upholsterers', 'Make, repair, or replace upholstery for household furniture or transportation vehicles.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-6099.00', 'Textile, Apparel, and Furnishings Workers, All Other', 'All textile, apparel, and furnishings workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-7011.00', 'Cabinetmakers and Bench Carpenters', 'Cut, shape, and assemble wooden articles or set up and operate a variety of woodworking machines, such as power saws, jointers, and mortisers to surface, cut, or shape lumber or to fabricate parts for wood products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-7021.00', 'Furniture Finishers', 'Shape, finish, and refinish damaged, worn, or used furniture or new high-grade furniture to specified color or finish.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-7031.00', 'Model Makers, Wood', 'Construct full-size and scale wooden precision models of products. Includes wood jig builders and loft workers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-7032.00', 'Patternmakers, Wood', 'Plan, lay out, and construct wooden unit or sectional patterns used in forming sand molds for castings.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-7041.00', 'Sawing Machine Setters, Operators, and Tenders, Wood', 'Set up, operate, or tend wood sawing machines. May operate CNC equipment. Includes lead sawyers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-7042.00', 'Woodworking Machine Setters, Operators, and Tenders, Except Sawing', 'Set up, operate, or tend woodworking machines, such as drill presses, lathes, shapers, routers, sanders, planers, and wood nailing machines. May operate CNC equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-7099.00', 'Woodworkers, All Other', 'All woodworkers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-8011.00', 'Nuclear Power Reactor Operators', 'Operate or control nuclear reactors. Move control rods, start and stop equipment, monitor and adjust controls, and record data in logs. Implement emergency procedures when needed. May respond to abnormalities, determine cause, and recommend corrective action.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-8012.00', 'Power Distributors and Dispatchers', 'Coordinate, regulate, or distribute electricity or steam.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-8013.00', 'Power Plant Operators', 'Control, operate, or maintain machinery to generate electric power. Includes auxiliary equipment operators.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-8021.00', 'Stationary Engineers and Boiler Operators', 'Operate or maintain stationary engines, boilers, or other mechanical equipment to provide utilities for buildings or industrial processes. Operate equipment, such as steam engines, generators, motors, turbines, and steam boilers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-8031.00', 'Water and Wastewater Treatment Plant and System Operators', 'Operate or control an entire process or system of machines, often through the use of control boards, to transfer or treat water or wastewater.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-8091.00', 'Chemical Plant and System Operators', 'Control or operate entire chemical processes or system of machines.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-8092.00', 'Gas Plant Operators', 'Distribute or process gas for utility companies and others by controlling compressors to maintain specified pressures on main pipelines.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-8093.00', 'Petroleum Pump System Operators, Refinery Operators, and Gaugers', 'Operate or control petroleum refining or processing units. May specialize in controlling manifold and pumping systems, gauging or testing oil in storage tanks, or regulating the flow of oil into pipelines.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-8099.00', 'Plant and System Operators, All Other', 'All plant and system operators not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-8099.01', 'Biofuels Processing Technicians', 'Calculate, measure, load, mix, and process refined feedstock with additives in fermentation or reaction process vessels and monitor production process. Perform, and keep records of, plant maintenance, repairs, and safety inspections.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-8099.02', 'Methane/Landfill Gas Generation System Technicians', 'Monitor, operate, and maintain landfill gas collection system components and environmental monitoring and control systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-8099.03', 'Biomass Plant Technicians', 'Control and monitor biomass plant activities and perform maintenance as needed.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-8099.04', 'Hydroelectric Plant Technicians', 'Monitor and control activities associated with hydropower generation. Operate plant equipment, such as turbines, pumps, valves, gates, fans, electric control boards, and battery banks. Monitor equipment operation and performance and make necessary adjustments to ensure optimal performance. Perform equipment maintenance and repair as necessary.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9011.00', 'Chemical Equipment Operators and Tenders', 'Operate or tend equipment to control chemical changes or reactions in the processing of industrial or consumer products. Equipment used includes devulcanizers, steam-jacketed kettles, and reactor vessels.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9012.00', 'Separating, Filtering, Clarifying, Precipitating, and Still Machine Setters, Operators, and Tenders', 'Set up, operate, or tend continuous flow or vat-type equipment; filter presses; shaker screens; centrifuges; condenser tubes; precipitating, fermenting, or evaporating tanks; scrubbing towers; or batch stills. These machines extract, sort, or separate liquids, gases, or solids from other materials to recover a refined product. Includes dairy processing equipment operators.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9021.00', 'Crushing, Grinding, and Polishing Machine Setters, Operators, and Tenders', 'Set up, operate, or tend machines to crush, grind, or polish materials, such as coal, glass, grain, stone, food, or rubber.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9022.00', 'Grinding and Polishing Workers, Hand', 'Grind, sand, or polish, using hand tools or hand-held power tools, a variety of metal, wood, stone, clay, plastic, or glass objects. Includes chippers, buffers, and finishers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9023.00', 'Mixing and Blending Machine Setters, Operators, and Tenders', 'Set up, operate, or tend machines to mix or blend materials, such as chemicals, tobacco, liquids, color pigments, or explosive ingredients.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9031.00', 'Cutters and Trimmers, Hand', 'Use hand tools or hand-held power tools to cut and trim a variety of manufactured items, such as carpet, fabric, stone, glass, or rubber.');
GO
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9032.00', 'Cutting and Slicing Machine Setters, Operators, and Tenders', 'Set up, operate, or tend machines that cut or slice materials, such as glass, stone, cork, rubber, tobacco, food, paper, or insulating material.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9041.00', 'Extruding, Forming, Pressing, and Compacting Machine Setters, Operators, and Tenders', 'Set up, operate, or tend machines, such as glass forming machines, plodder machines, and tuber machines, to shape and form products, such as glassware, food, rubber, soap, brick, tile, clay, wax, tobacco, or cosmetics.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9051.00', 'Furnace, Kiln, Oven, Drier, and Kettle Operators and Tenders', 'Operate or tend heating equipment other than basic metal, plastic, or food processing equipment. Includes activities, such as annealing glass, drying lumber, curing rubber, removing moisture from materials, or boiling soap.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9061.00', 'Inspectors, Testers, Sorters, Samplers, and Weighers', 'Inspect, test, sort, sample, or weigh nonagricultural raw materials or processed, machined, fabricated, or assembled parts or products for defects, wear, and deviations from specifications. May use precision measuring instruments and complex test equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9071.00', 'Jewelers and Precious Stone and Metal Workers', 'Design, fabricate, adjust, repair, or appraise jewelry, gold, silver, other precious metals, or gems. Includes diamond polishers and gem cutters, and persons who perform precision casting and modeling of molds, casting metal in molds, or setting precious and semi-precious stones for jewelry and related products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9071.01', 'Jewelers', 'Fabricate and repair jewelry articles. Make models or molds to create jewelry items.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9071.06', 'Gem and Diamond Workers', 'Fabricate, finish, or evaluate the quality of gems and diamonds used in jewelry or industrial tools.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9071.07', 'Precious Metal Workers', 'Cast, anneal, solder, hammer, or shape gold, silver, pewter or other metals to form jewelry or other metal items such as goblets or candlesticks.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9081.00', 'Dental Laboratory Technicians', 'Construct and repair full or partial dentures or dental appliances.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9082.00', 'Medical Appliance Technicians', 'Construct, fit, maintain, or repair medical supportive devices, such as braces, orthotics and prosthetic devices, joints, arch supports, and other surgical and medical appliances.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9083.00', 'Ophthalmic Laboratory Technicians', 'Cut, grind, and polish eyeglasses, contact lenses, or other precision optical elements. Assemble and mount lenses into frames or process other optical elements. Includes precision lens polishers or grinders, centerer-edgers, and lens mounters.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9111.00', 'Packaging and Filling Machine Operators and Tenders', 'Operate or tend machines to prepare industrial or consumer products for storage or shipment. Includes cannery workers who pack food products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9121.00', 'Coating, Painting, and Spraying Machine Setters, Operators, and Tenders', 'Set up, operate, or tend machines to coat or paint any of a wide variety of products, including glassware, cloth, ceramics, metal, plastic, paper, or wood, with lacquer, silver, copper, rubber, varnish, glaze, enamel, oil, or rust-proofing materials.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9122.00', 'Painters, Transportation Equipment', 'Operate or tend painting machines to paint surfaces of transportation equipment, such as automobiles, buses, trucks, trains, boats, and airplanes. Includes painters in auto body repair facilities.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9123.00', 'Painting, Coating, and Decorating Workers', 'Paint, coat, or decorate articles such as furniture, glass, plateware, pottery, jewelry, toys, books, or leather.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9141.00', 'Semiconductor Processors', 'Perform any or all of the following functions in the manufacture of electronic semiconductors: load semiconductor material into furnace; saw formed ingots into segments; load individual segment into crystal growing chamber and monitor controls; locate crystal axis in ingot using x-ray equipment and saw ingots into wafers; and clean, polish, and load wafers into series of special purpose furnaces, chemical baths, and equipment used to form circuitry and change conductive properties.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9151.00', 'Photographic Process Workers and Processing Machine Operators', 'Perform work involved in developing and processing photographic images from film or digital media. May perform precision tasks such as editing photographic negatives and prints.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9191.00', 'Adhesive Bonding Machine Operators and Tenders', 'Operate or tend bonding machines that use adhesives to join items for further processing or to form a completed product. Processes include joining veneer sheets into plywood; gluing paper; or joining rubber and rubberized fabric parts, plastic, simulated leather, or other materials.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9192.00', 'Cleaning, Washing, and Metal Pickling Equipment Operators and Tenders', 'Operate or tend machines to wash or clean products, such as barrels or kegs, glass items, tin plate, food, pulp, coal, plastic, or rubber, to remove impurities.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9193.00', 'Cooling and Freezing Equipment Operators and Tenders', 'Operate or tend equipment, such as cooling and freezing units, refrigerators, batch freezers, and freezing tunnels, to cool or freeze products, food, blood plasma, and chemicals.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9194.00', 'Etchers and Engravers', 'Engrave or etch metal, wood, rubber, or other materials. Includes such workers as etcher-circuit processors, pantograph engravers, and silk screen etchers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9195.00', 'Molders, Shapers, and Casters, Except Metal and Plastic', 'Mold, shape, form, cast, or carve products such as food products, figurines, tile, pipes, and candles consisting of clay, glass, plaster, concrete, stone, or combinations of materials.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9195.03', 'Stone Cutters and Carvers, Manufacturing', 'Cut or carve stone according to diagrams and patterns.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9195.04', 'Glass Blowers, Molders, Benders, and Finishers', 'Shape molten glass according to patterns.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9195.05', 'Potters, Manufacturing', 'Operate production machines such as pug mill, jigger machine, or potter''s wheel to process clay in manufacture of ceramic, pottery and stoneware products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9195.07', 'Molding and Casting Workers', 'Perform a variety of duties such as mixing materials, assembling mold parts, filling molds, and stacking molds to mold and cast a wide range of products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9196.00', 'Paper Goods Machine Setters, Operators, and Tenders', 'Set up, operate, or tend paper goods machines that perform a variety of functions, such as converting, sawing, corrugating, banding, wrapping, boxing, stitching, forming, or sealing paper or paperboard sheets into products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9197.00', 'Tire Builders', 'Operate machines to build tires.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9198.00', 'Helpers--Production Workers', 'Help production workers by performing duties requiring less skill. Duties include supplying or holding materials or tools, and cleaning work area and equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9199.00', 'Production Workers, All Other', 'All production workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('51-9199.01', 'Recycling and Reclamation Workers', 'Prepare and sort materials or products for recycling. Identify and remove hazardous substances. Dismantle components of products such as appliances.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-1011.00', 'Aircraft Cargo Handling Supervisors', 'Supervise and coordinate the activities of ground crew in the loading, unloading, securing, and staging of aircraft cargo or baggage. May determine the quantity and orientation of cargo and compute aircraft center of gravity. May accompany aircraft as member of flight crew and monitor and handle cargo in flight, and assist and brief passengers on safety and emergency procedures. Includes loadmasters.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-1021.00', 'First-Line Supervisors of Helpers, Laborers, and Material Movers, Hand', 'Directly supervise and coordinate the activities of helpers, laborers, or material movers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-1021.01', 'Recycling Coordinators', 'Supervise curbside and drop-off recycling programs for municipal governments or private firms.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-1031.00', 'First-Line Supervisors of Transportation and Material-Moving Machine and Vehicle Operators', 'Directly supervise and coordinate activities of transportation and material-moving machine and vehicle operators and helpers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-2011.00', 'Airline Pilots, Copilots, and Flight Engineers', 'Pilot and navigate the flight of fixed-wing, multi-engine aircraft, usually on scheduled air carrier routes, for the transport of passengers and cargo. Requires Federal Air Transport Pilot certificate and rating for specific aircraft type used. Includes regional, National, and international airline pilots and flight instructors of airline pilots.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-2012.00', 'Commercial Pilots', 'Pilot and navigate the flight of fixed-winged aircraft on nonscheduled air carrier routes, or helicopters. Requires Commercial Pilot certificate. Includes charter pilots with similar certification, and air ambulance and air tour pilots.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-2021.00', 'Air Traffic Controllers', 'Control air traffic on and within vicinity of airport and movement of air traffic between altitude sectors and control centers according to established procedures and policies. Authorize, regulate, and control commercial airline flights according to government or company regulations to expedite and ensure flight safety.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-2022.00', 'Airfield Operations Specialists', 'Ensure the safe takeoff and landing of commercial and military aircraft. Duties include coordination between air-traffic control and maintenance personnel; dispatching; using airfield landing and navigational aids; implementing airfield safety procedures; monitoring and maintaining flight records; and applying knowledge of weather information.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-2031.00', 'Flight Attendants', 'Provide personal services to ensure the safety, security, and comfort of airline passengers during flight. Greet passengers, verify tickets, explain use of safety equipment, and serve food or beverages.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-3011.00', 'Ambulance Drivers and Attendants, Except Emergency Medical Technicians', 'Drive ambulance or assist ambulance driver in transporting sick, injured, or convalescent persons. Assist in lifting patients.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-3021.00', 'Bus Drivers, Transit and Intercity', 'Drive bus or motor coach, including regular route operations, charters, and private carriage. May assist passengers with baggage. May collect fares or tickets.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-3022.00', 'Bus Drivers, School or Special Client', 'Transport students or special clients, such as the elderly or persons with disabilities. Ensure adherence to safety rules. May assist passengers in boarding or exiting.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-3031.00', 'Driver/Sales Workers', 'Drive truck or other vehicle over established routes or within an established territory and sell or deliver goods, such as food products, including restaurant take-out items, or pick up or deliver items such as commercial laundry. May also take orders, collect payment, or stock merchandise at point of delivery. Includes newspaper delivery drivers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-3032.00', 'Heavy and Tractor-Trailer Truck Drivers', 'Drive a tractor-trailer combination or a truck with a capacity of at least 26,000 pounds Gross Vehicle Weight (GVW). May be required to unload truck. Requires commercial drivers'' license.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-3033.00', 'Light Truck or Delivery Services Drivers', 'Drive a light vehicle, such as a truck or van, with a capacity of less than 26,000 pounds Gross Vehicle Weight (GVW), primarily to deliver or pick up merchandise or to deliver packages. May load and unload vehicle.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-3041.00', 'Taxi Drivers and Chauffeurs', 'Drive automobiles, vans, or limousines to transport passengers. May occasionally carry cargo. Includes hearse drivers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-3099.00', 'Motor Vehicle Operators, All Other', 'All motor vehicle operators not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-4011.00', 'Locomotive Engineers', 'Drive electric, diesel-electric, steam, or gas-turbine-electric locomotives to transport passengers or freight. Interpret train orders, electronic or manual signals, and railroad rules and regulations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-4012.00', 'Locomotive Firers', 'Monitor locomotive instruments and watch for dragging equipment, obstacles on rights-of-way, and train signals during run. Watch for and relay traffic signals from yard workers to yard engineer in railroad yard.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-4013.00', 'Rail Yard Engineers, Dinkey Operators, and Hostlers', 'Drive switching or other locomotive or dinkey engines within railroad yard, industrial plant, quarry, construction project, or similar location.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-4021.00', 'Railroad Brake, Signal, and Switch Operators', 'Operate railroad track switches. Couple or uncouple rolling stock to make up or break up trains. Signal engineers by hand or flagging. May inspect couplings, air hoses, journal boxes, and hand brakes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-4031.00', 'Railroad Conductors and Yardmasters', 'Coordinate activities of switch-engine crew within railroad yard, industrial plant, or similar location. Conductors coordinate activities of train crew on passenger or freight trains. Yardmasters review train schedules and switching orders and coordinate activities of workers engaged in railroad traffic operations, such as the makeup or breakup of trains and yard switching.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-4041.00', 'Subway and Streetcar Operators', 'Operate subway or elevated suburban trains with no separate locomotive, or electric-powered streetcar, to transport passengers. May handle fares.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-4099.00', 'Rail Transportation Workers, All Other', 'All rail transportation workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-5011.00', 'Sailors and Marine Oilers', 'Stand watch to look for obstructions in path of vessel, measure water depth, turn wheel on bridge, or use emergency equipment as directed by captain, mate, or pilot. Break out, rig, overhaul, and store cargo-handling gear, stationary rigging, and running gear. Perform a variety of maintenance tasks to preserve the painted surface of the ship and to maintain line and ship equipment. Must hold government-issued certification and tankerman certification when working aboard liquid-carrying vessels. Includes able seamen and ordinary seamen.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-5021.00', 'Captains, Mates, and Pilots of Water Vessels', 'Command or supervise operations of ships and water vessels, such as tugboats and ferryboats. Required to hold license issued by U.S. Coast Guard.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-5021.01', 'Ship and Boat Captains', 'Command vessels in oceans, bays, lakes, rivers, or coastal waters.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-5021.02', 'Mates- Ship, Boat, and Barge', 'Supervise or coordinate activities of crew aboard ships, boats, barges, or dredges.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-5021.03', 'Pilots, Ship', 'Command ships to steer them into and out of harbors, estuaries, straits, or sounds, or on rivers, lakes, or bays. Must be licensed by U.S. Coast Guard with limitations indicating class and tonnage of vessels for which license is valid and route and waters that may be piloted.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-5022.00', 'Motorboat Operators', 'Operate small motor-driven boats. May assist in navigational activities.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-5031.00', 'Ship Engineers', 'Supervise and coordinate activities of crew engaged in operating and maintaining engines, boilers, deck machinery, and electrical, sanitary, and refrigeration equipment aboard ship.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-6011.00', 'Bridge and Lock Tenders', 'Operate and tend bridges, canal locks, and lighthouses to permit marine passage on inland waterways, near shores, and at danger points in waterway passages. May supervise such operations. Includes drawbridge operators, lock operators, and slip bridge operators.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-6021.00', 'Parking Lot Attendants', 'Park vehicles or issue tickets for customers in a parking lot or garage. May collect fee.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-6031.00', 'Automotive and Watercraft Service Attendants', 'Service automobiles, buses, trucks, boats, and other automotive or marine vehicles with fuel, lubricants, and accessories. Collect payment for services and supplies. May lubricate vehicle, change motor oil, install antifreeze, or replace lights or other accessories, such as windshield wiper blades or fan belts. May repair or replace tires.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-6041.00', 'Traffic Technicians', 'Conduct field studies to determine traffic volume, speed, effectiveness of signals, adequacy of lighting, and other factors influencing traffic conditions, under direction of traffic engineer.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-6051.00', 'Transportation Inspectors', 'Inspect equipment or goods in connection with the safe transport of cargo or people. Includes rail transportation inspectors, such as freight inspectors; rail inspectors; and other inspectors of transportation vehicles, not elsewhere classified.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-6051.01', 'Aviation Inspectors', 'Inspect aircraft, maintenance procedures, air navigational aids, air traffic controls, and communications equipment to ensure conformance with Federal safety regulations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-6051.07', 'Transportation Vehicle, Equipment and Systems Inspectors, Except Aviation', 'Inspect and monitor transportation equipment, vehicles, or systems to ensure compliance with regulations and safety standards.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-6051.08', 'Freight and Cargo Inspectors', 'Inspect the handling, storage, and stowing of freight and cargoes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-6061.00', 'Transportation Attendants, Except Flight Attendants', 'Provide services to ensure the safety and comfort of passengers aboard ships, buses, trains, or within the station or terminal. Perform duties such as greeting passengers, explaining the use of safety equipment, serving meals or beverages, or answering questions related to travel.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-6099.00', 'Transportation Workers, All Other', 'All transportation workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7011.00', 'Conveyor Operators and Tenders', 'Control or tend conveyors or conveyor systems that move materials or products to and from stockpiles, processing stations, departments, or vehicles. May control speed and routing of materials or products.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7021.00', 'Crane and Tower Operators', 'Operate mechanical boom and cable or tower and cable equipment to lift and move materials, machines, or products in many directions.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7031.00', 'Dredge Operators', 'Operate dredge to remove sand, gravel, or other materials in order to excavate and maintain navigable channels in waterways.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7032.00', 'Excavating and Loading Machine and Dragline Operators', 'Operate or tend machinery equipped with scoops, shovels, or buckets, to excavate and load loose materials.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7033.00', 'Loading Machine Operators, Underground Mining', 'Operate underground loading machine to load coal, ore, or rock into shuttle or mine car or onto conveyors. Loading equipment may include power shovels, hoisting engines equipped with cable-drawn scraper or scoop, or machines equipped with gathering arms and conveyor.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7041.00', 'Hoist and Winch Operators', 'Operate or tend hoists or winches to lift and pull loads using power-operated cable equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7051.00', 'Industrial Truck and Tractor Operators', 'Operate industrial trucks or tractors equipped to move materials around a warehouse, storage yard, factory, construction site, or similar location.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7061.00', 'Cleaners of Vehicles and Equipment', 'Wash or otherwise clean vehicles, machinery, and other equipment. Use such materials as water, cleaning agents, brushes, cloths, and hoses.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7062.00', 'Laborers and Freight, Stock, and Material Movers, Hand', 'Manually move freight, stock, or other materials or perform other general labor. Includes all manual laborers not elsewhere classified.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7063.00', 'Machine Feeders and Offbearers', 'Feed materials into or remove materials from machines or equipment that is automatic or tended by other workers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7064.00', 'Packers and Packagers, Hand', 'Pack or package by hand a wide variety of products and materials.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7071.00', 'Gas Compressor and Gas Pumping Station Operators', 'Operate steam, gas, electric motor, or internal combustion engine driven compressors. Transmit, compress, or recover gases, such as butane, nitrogen, hydrogen, and natural gas.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7072.00', 'Pump Operators, Except Wellhead Pumpers', 'Tend, control, or operate power-driven, stationary, or portable pumps and manifold systems to transfer gases, oil, other liquids, slurries, or powdered materials to and from various vessels and processes.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7073.00', 'Wellhead Pumpers', 'Operate power pumps and auxiliary equipment to produce flow of oil or gas from wells in oil field.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7081.00', 'Refuse and Recyclable Material Collectors', 'Collect and dump refuse or recyclable materials from containers into truck. May drive truck.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7111.00', 'Mine Shuttle Car Operators', 'Operate diesel or electric-powered shuttle car in underground mine to transport materials from working face to mine cars or conveyor.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7121.00', 'Tank Car, Truck, and Ship Loaders', 'Load and unload chemicals and bulk solids, such as coal, sand, and grain into or from tank cars, trucks, or ships using material moving equipment. May perform a variety of other tasks relating to shipment of products. May gauge or sample shipping tanks and test them for leaks.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('53-7199.00', 'Material Moving Workers, All Other', 'All material moving workers not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-1011.00', 'Air Crew Officers', 'Perform and direct in-flight duties to ensure the successful completion of combat, reconnaissance, transport, and search and rescue missions. Duties include operating aircraft communications and radar equipment, such as establishing satellite linkages and jamming enemy communications capabilities; operating aircraft weapons and defensive systems; conducting pre-flight, in-flight, and post-flight inspections of onboard equipment; and directing cargo and personnel drops.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-1012.00', 'Aircraft Launch and Recovery Officers', 'Plan and direct the operation and maintenance of catapults, arresting gear, and associated mechanical, hydraulic, and control systems involved primarily in aircraft carrier takeoff and landing operations. Duties include supervision of readiness and safety of arresting gear, launching equipment, barricades, and visual landing aid systems; planning and coordinating the design, development, and testing of launch and recovery systems; preparing specifications for catapult and arresting gear installations; evaluating design proposals; determining handling equipment needed for new aircraft; preparing technical data and instructions for operation of landing aids; and training personnel in carrier takeoff and landing procedures.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-1013.00', 'Armored Assault Vehicle Officers', 'Direct the operation of tanks, light armor, and amphibious assault vehicle units during combat situations on land or in aquatic environments. Duties include directing crew members in the operation of targeting and firing systems; coordinating the operation of advanced onboard communications and navigation equipment; directing the transport of personnel and equipment during combat; formulating and implementing battle plans, including the tactical employment of armored vehicle units; and coordinating with infantry, artillery, and air support units.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-1014.00', 'Artillery and Missile Officers', 'Manage personnel and weapons operations to destroy enemy positions, aircraft, and vessels. Duties include planning, targeting, and coordinating the tactical deployment of field artillery and air defense artillery missile systems units; directing the establishment and operation of fire control communications systems; targeting and launching intercontinental ballistic missiles; directing the storage and handling of nuclear munitions and components; overseeing security of weapons storage and launch facilities; and managing maintenance of weapons systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-1015.00', 'Command and Control Center Officers', 'Manage the operation of communications, detection, and weapons systems essential for controlling air, ground, and naval operations. Duties include managing critical communication links between air, naval, and ground forces; formulating and implementing emergency plans for natural and wartime disasters; coordinating emergency response teams and agencies; evaluating command center information and need for high-level military and government reporting; managing the operation of surveillance and detection systems; providing technical information and advice on capabilities and operational readiness; and directing operation of weapons targeting, firing, and launch computer systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-1016.00', 'Infantry Officers', 'Direct, train, and lead infantry units in ground combat operations. Duties include directing deployment of infantry weapons, vehicles, and equipment; directing location, construction, and camouflage of infantry positions and equipment; managing field communications operations; coordinating with armor, artillery, and air support units; performing strategic and tactical planning, including battle plan development; and leading basic reconnaissance operations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-1017.00', 'Special Forces Officers', 'Lead elite teams that implement unconventional operations by air, land, or sea during combat or peacetime. These activities include offensive raids, demolitions, reconnaissance, search and rescue, and counterterrorism. In addition to their combat training, special forces officers often have specialized training in swimming, diving, parachuting, survival, emergency medicine, and foreign languages. Duties include directing advanced reconnaissance operations and evaluating intelligence information; recruiting, training, and equipping friendly forces; leading raids and invasions on enemy territories; training personnel to implement individual missions and contingency plans; performing strategic and tactical planning for politically sensitive missions; and operating sophisticated communications equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-1019.00', 'Military Officer Special and Tactical Operations Leaders, All Other', 'All military officer special and tactical operations leaders not listed separately.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-2011.00', 'First-Line Supervisors of Air Crew Members', 'Supervise and coordinate the activities of air crew members. Supervisors may also perform the same activities as the workers they supervise.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-2012.00', 'First-Line Supervisors of Weapons Specialists/Crew Members', 'Supervise and coordinate the activities of weapons specialists/crew members. Supervisors may also perform the same activities as the workers they supervise.');
GO
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-2013.00', 'First-Line Supervisors of All Other Tactical Operations Specialists', 'Supervise and coordinate the activities of all other tactical operations specialists not classified separately above. Supervisors may also perform the same activities as the workers they supervise.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-3011.00', 'Air Crew Members', 'Perform in-flight duties to ensure the successful completion of combat, reconnaissance, transport, and search and rescue missions. Duties include operating aircraft communications and detection equipment, including establishing satellite linkages and jamming enemy communications capabilities; conducting pre-flight, in-flight, and post-flight inspections of onboard equipment; operating and maintaining aircraft weapons and defensive systems; operating and maintaining aircraft in-flight refueling systems; executing aircraft safety and emergency procedures; computing and verifying passenger, cargo, fuel, and emergency and special equipment weight and balance data; and conducting cargo and personnel drops.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-3012.00', 'Aircraft Launch and Recovery Specialists', 'Operate and maintain catapults, arresting gear, and associated mechanical, hydraulic, and control systems involved primarily in aircraft carrier takeoff and landing operations. Duties include installing and maintaining visual landing aids; testing and maintaining launch and recovery equipment using electric and mechanical test equipment and hand tools; activating airfield arresting systems, such as crash barriers and cables, during emergency landing situations; directing aircraft launch and recovery operations using hand or light signals; and maintaining logs of airplane launches, recoveries, and equipment maintenance.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-3013.00', 'Armored Assault Vehicle Crew Members', 'Operate tanks, light armor, and amphibious assault vehicles during combat situations on land or in aquatic environments. Duties include driving armored vehicles which require specialized training; operating and maintaining targeting and firing systems; operating and maintaining advanced onboard communications and navigation equipment; transporting personnel and equipment in a combat environment; and operating and maintaining auxiliary weapons, including machine guns and grenade launchers.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-3014.00', 'Artillery and Missile Crew Members', 'Target, fire, and maintain weapons used to destroy enemy positions, aircraft, and vessels. Field artillery crew members predominantly use guns, cannons, and howitzers in ground combat operations, while air defense artillery crew members predominantly use missiles and rockets. Naval artillery crew members predominantly use torpedoes and missiles launched from a ship or submarine. Duties include testing, inspecting, and storing ammunition, missiles, and torpedoes; conducting preventive and routine maintenance on weapons and related equipment; establishing and maintaining radio and wire communications; and operating weapons targeting, firing, and launch computer systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-3015.00', 'Command and Control Center Specialists', 'Operate and monitor communications, detection, and weapons systems essential for controlling air, ground, and naval operations. Duties include maintaining and relaying critical communications between air, naval, and ground forces; implementing emergency plans for natural and wartime disasters; relaying command center information to high-level military and government decision makers; monitoring surveillance and detection systems, such as air defense; interpreting and evaluating tactical situations and making recommendations to superiors; and operating weapons targeting, firing, and launch computer systems.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-3016.00', 'Infantry', 'Operate weapons and equipment in ground combat operations. Duties include operating and maintaining weapons, such as rifles, machine guns, mortars, and hand grenades; locating, constructing, and camouflaging infantry positions and equipment; evaluating terrain and recording topographical information; operating and maintaining field communications equipment; assessing need for and directing supporting fire; placing explosives and performing minesweeping activities on land; and participating in basic reconnaissance operations.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-3017.00', 'Radar and Sonar Technicians', 'Operate equipment using radio or sound wave technology to identify, track, and analyze objects or natural phenomena of military interest. Includes airborne, shipboard, and terrestrial positions. May perform minor maintenance.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-3018.00', 'Special Forces', 'Implement unconventional operations by air, land, or sea during combat or peacetime as members of elite teams. These activities include offensive raids, demolitions, reconnaissance, search and rescue, and counterterrorism. In addition to their combat training, special forces members often have specialized training in swimming, diving, parachuting, survival, emergency medicine, and foreign languages. Duties include conducting advanced reconnaissance operations and collecting intelligence information; recruiting, training, and equipping friendly forces; conducting raids and invasions on enemy territories; laying and detonating explosives for demolition targets; locating, identifying, defusing, and disposing of ordnance; and operating and maintaining sophisticated communications equipment.');
INSERT INTO occupation_data (onetsoc_code, title, description) VALUES ('55-3019.00', 'Military Enlisted Tactical Operations and Air/Weapons Specialists and Crew Members, All Other', 'All military enlisted tactical operations and air/weapons specialists and crew members not listed separately.');
GO

