CREATE TABLE abilities (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(5,2),
  lower_ci_bound DECIMAL(5,2),
  upper_ci_bound DECIMAL(5,2),
  recommend_suppress CHARACTER(1),
  not_relevant CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id));

INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.1', 'IM', 4.50, 8, 0.19, 4.13, 4.87, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.1', 'LV', 4.75, 8, 0.25, 4.26, 5.24, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.2', 'IM', 4.38, 8, 0.18, 4.02, 4.73, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.2', 'LV', 4.63, 8, 0.32, 3.99, 5.26, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.3', 'IM', 4.50, 8, 0.19, 4.13, 4.87, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.3', 'LV', 4.88, 8, 0.23, 4.43, 5.32, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.4', 'IM', 4.25, 8, 0.25, 3.76, 4.74, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.4', 'LV', 4.50, 8, 0.27, 3.98, 5.02, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.1', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.1', 'LV', 4.75, 8, 0.31, 4.14, 5.36, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.2', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.2', 'LV', 4.50, 8, 0.19, 4.13, 4.87, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.3', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.3', 'LV', 5.00, 8, 0.33, 4.36, 5.64, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.4', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.4', 'LV', 5.00, 8, 0.00, 5.00, 5.00, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.5', 'IM', 4.13, 8, 0.13, 3.88, 4.37, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.5', 'LV', 5.00, 8, 0.27, 4.48, 5.52, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.6', 'IM', 3.63, 8, 0.18, 3.27, 3.98, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.6', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.7', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.7', 'LV', 4.00, 8, 0.38, 3.26, 4.74, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.c.1', 'IM', 3.13, 8, 0.23, 2.68, 3.57, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.c.1', 'LV', 3.63, 8, 0.42, 2.80, 4.45, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.c.2', 'IM', 3.13, 8, 0.23, 2.68, 3.57, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.c.2', 'LV', 4.00, 8, 0.46, 3.09, 4.91, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.d.1', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.d.1', 'LV', 3.13, 8, 0.48, 2.19, 4.06, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.e.1', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.e.1', 'LV', 3.50, 8, 0.46, 2.59, 4.41, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.e.2', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.e.2', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.e.3', 'IM', 3.13, 8, 0.23, 2.68, 3.57, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.e.3', 'LV', 2.75, 8, 0.31, 2.14, 3.36, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.f.2', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.f.2', 'LV', 3.75, 8, 0.49, 2.79, 4.71, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.g.1', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.g.1', 'LV', 3.38, 8, 0.32, 2.74, 4.01, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.g.2', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.g.2', 'LV', 2.88, 8, 0.40, 2.09, 3.66, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.a.3', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.a.3', 'LV', 2.13, 8, 0.30, 1.55, 2.70, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.1', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.1', 'LV', 1.50, 8, 0.38, 0.76, 2.24, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.2', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.2', 'LV', 1.13, 8, 0.30, 0.55, 1.70, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.3', 'IM', 1.13, 8, 0.13, 1.00, 1.37, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.3', 'LV', 0.13, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.c.1', 'IM', 1.13, 8, 0.13, 1.00, 1.37, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.c.1', 'LV', 0.13, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.1', 'IM', 3.63, 8, 0.18, 3.27, 3.98, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.1', 'LV', 4.25, 8, 0.31, 3.64, 4.86, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.2', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.2', 'LV', 3.38, 8, 0.32, 2.74, 4.01, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.3', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.3', 'LV', 1.88, 8, 0.35, 1.19, 2.56, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.6', 'IM', 2.13, 8, 0.13, 1.88, 2.37, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.6', 'LV', 2.13, 8, 0.13, 1.88, 2.37, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.1', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.1', 'LV', 1.88, 8, 0.30, 1.30, 2.45, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.2', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.2', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.4', 'IM', 4.25, 8, 0.25, 3.76, 4.74, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.4', 'LV', 4.88, 8, 0.30, 4.30, 5.45, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.5', 'IM', 4.25, 8, 0.25, 3.76, 4.74, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.5', 'LV', 5.13, 8, 0.40, 4.34, 5.91, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.1', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.1', 'LV', 4.50, 8, 0.19, 4.13, 4.87, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.2', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.2', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.3', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.3', 'LV', 4.62, 8, 0.18, 4.27, 4.98, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.4', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.1', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.1', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.2', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.2', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.3', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.3', 'LV', 4.25, 8, 0.25, 3.76, 4.74, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.4', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.4', 'LV', 4.50, 8, 0.19, 4.13, 4.87, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.5', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.5', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.6', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.6', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.7', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.7', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.c.1', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.c.1', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.c.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.c.2', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.d.1', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.d.1', 'LV', 2.50, 8, 0.27, 1.98, 3.02, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.e.1', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.e.1', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.e.2', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.e.2', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.e.3', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.e.3', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.f.1', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.f.1', 'LV', 0.25, 8, 0.16, 0.00, 0.57, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.f.2', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.f.2', 'LV', 3.12, 8, 0.44, 2.26, 3.99, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.g.1', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.g.1', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.g.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.g.2', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.a.3', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.a.3', 'LV', 2.00, 8, 0.19, 1.63, 2.37, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.1', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.1', 'LV', 1.25, 8, 0.37, 0.53, 1.97, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.2', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.2', 'LV', 1.00, 8, 0.38, 0.26, 1.74, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.3', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.3', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.4', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.4', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.c.1', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.c.1', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.c.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.c.2', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.4', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.4', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.1', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.1', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.2', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.2', 'LV', 2.75, 8, 0.31, 2.14, 3.36, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.3', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.3', 'LV', 1.62, 8, 0.32, 0.99, 2.26, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.6', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.6', 'LV', 1.88, 8, 0.13, 1.63, 2.12, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.1', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.1', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.2', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.2', 'LV', 1.62, 8, 0.26, 1.11, 2.14, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.3', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.3', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.4', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.4', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.5', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.5', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.1', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.2', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.2', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.3', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.4', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.4', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.1', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.1', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.2', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.2', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.3', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.3', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.4', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.4', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.5', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.5', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.6', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.6', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.7', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.7', 'LV', 3.12, 8, 0.30, 2.55, 3.70, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.c.1', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.c.1', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.c.2', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.c.2', 'LV', 2.50, 8, 0.38, 1.76, 3.24, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.d.1', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.d.1', 'LV', 2.12, 8, 0.35, 1.44, 2.81, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.e.1', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.e.1', 'LV', 2.00, 8, 0.38, 1.26, 2.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.e.2', 'IM', 2.75, 8, 0.31, 2.14, 3.36, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.e.2', 'LV', 2.38, 8, 0.26, 1.86, 2.89, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.e.3', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.e.3', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.f.1', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.f.1', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.f.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.f.2', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.g.1', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.g.1', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.g.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.g.2', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.a.1', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.a.1', 'LV', 2.12, 8, 0.23, 1.68, 2.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.a.2', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.a.2', 'LV', 2.25, 8, 0.31, 1.64, 2.86, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.a.3', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.a.3', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.1', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.1', 'LV', 2.25, 8, 0.25, 1.76, 2.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.2', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.2', 'LV', 2.25, 8, 0.25, 1.76, 2.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.3', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.3', 'LV', 1.62, 8, 0.38, 0.89, 2.36, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.4', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.4', 'LV', 1.50, 8, 0.46, 0.59, 2.41, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.c.1', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.c.1', 'LV', 1.38, 8, 0.42, 0.55, 2.20, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.c.3', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.c.3', 'LV', 1.50, 8, 0.38, 0.76, 2.24, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.1', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.1', 'LV', 1.75, 8, 0.37, 1.03, 2.47, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.4', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.4', 'LV', 2.12, 8, 0.30, 1.55, 2.70, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.b.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.b.1', 'LV', 1.38, 8, 0.26, 0.86, 1.89, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.3', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.3', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.1', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.1', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.2', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.2', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.3', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.3', 'LV', 2.12, 8, 0.30, 1.55, 2.70, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.4', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.4', 'LV', 1.38, 8, 0.26, 0.86, 1.89, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.5', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.5', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.6', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.6', 'LV', 1.62, 8, 0.26, 1.11, 2.14, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.7', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.7', 'LV', 0.88, 8, 0.30, 0.30, 1.45, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.1', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.1', 'LV', 2.25, 8, 0.25, 1.76, 2.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.2', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.2', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.3', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.3', 'LV', 1.25, 8, 0.37, 0.53, 1.97, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.4', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.4', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.5', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.5', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.1', 'IM', 4.12, 8, 0.23, 3.68, 4.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.1', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.2', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.2', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.3', 'IM', 4.38, 8, 0.18, 4.02, 4.73, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.3', 'LV', 4.62, 8, 0.18, 4.27, 4.98, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.4', 'LV', 4.00, 8, 0.27, 3.48, 4.52, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.1', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.1', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.2', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.2', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.3', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.3', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.4', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.5', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.5', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.6', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.6', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.7', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.c.1', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.c.1', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.c.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.c.2', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.d.1', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.d.1', 'LV', 2.38, 8, 0.38, 1.64, 3.11, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.e.1', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.e.1', 'LV', 2.88, 8, 0.35, 2.19, 3.56, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.e.2', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.e.2', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.e.3', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.e.3', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.f.2', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.f.2', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.g.1', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.g.1', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.g.2', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.g.2', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.a.1', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.a.1', 'LV', 1.25, 8, 0.31, 0.64, 1.86, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.a.2', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.a.2', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.a.3', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.a.3', 'LV', 1.75, 8, 0.31, 1.14, 2.36, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.1', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.1', 'LV', 0.62, 8, 0.26, 0.11, 1.14, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.2', 'IM', 1.38, 8, 0.26, 1.00, 1.89, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.2', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.c.2', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.c.2', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.4', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.4', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.1', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.1', 'LV', 4.25, 8, 0.25, 3.76, 4.74, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.2', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.2', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.3', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.3', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.6', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.6', 'LV', 1.50, 8, 0.38, 0.76, 2.24, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.1', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.1', 'LV', 1.50, 8, 0.33, 0.86, 2.14, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.2', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.2', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.4', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.4', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.5', 'IM', 4.00, 8, 0.33, 3.36, 4.64, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.5', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.1', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.1', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.2', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.2', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.3', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.4', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.4', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.1', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.1', 'LV', 4.25, 8, 0.25, 3.76, 4.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.2', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.2', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.3', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.3', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.4', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.5', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.5', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.6', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.6', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.7', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.c.1', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.c.1', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.c.2', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.c.2', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.d.1', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.d.1', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.e.1', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.e.1', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.e.2', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.e.2', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.e.3', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.e.3', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.f.1', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.f.1', 'LV', 0.25, 8, 0.16, 0.00, 0.57, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.f.2', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.f.2', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.g.1', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.g.1', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.g.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.g.2', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.a.1', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.a.1', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.a.3', 'IM', 2.12, 8, 0.30, 1.55, 2.70, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.a.3', 'LV', 1.75, 8, 0.45, 0.86, 2.64, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.3', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.3', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.c.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.c.2', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.4', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.4', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.1', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.1', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.2', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.2', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.3', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.3', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.6', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.6', 'LV', 1.00, 8, 0.33, 0.36, 1.64, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.7', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.7', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.1', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.1', 'LV', 1.75, 8, 0.45, 0.86, 2.64, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.2', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.2', 'LV', 1.50, 8, 0.38, 0.76, 2.24, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.4', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.4', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.5', 'IM', 3.62, 8, 0.26, 3.11, 4.14, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.5', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.1', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.1', 'LV', 4.50, 8, 0.19, 4.13, 4.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.2', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.2', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.3', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.3', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.4', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.4', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.1', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.1', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.2', 'IM', 3.62, 8, 0.26, 3.11, 4.14, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.2', 'LV', 4.12, 8, 0.30, 3.55, 4.70, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.3', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.3', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.4', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.4', 'LV', 4.12, 8, 0.30, 3.55, 4.70, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.5', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.5', 'LV', 3.62, 8, 0.42, 2.80, 4.45, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.6', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.6', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.7', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.7', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.c.1', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.c.1', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.c.2', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.c.2', 'LV', 3.62, 8, 0.32, 2.99, 4.26, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.d.1', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.d.1', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.e.1', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.e.1', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.e.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.e.2', 'LV', 2.88, 8, 0.35, 2.19, 3.56, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.e.3', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.e.3', 'LV', 2.50, 8, 0.27, 1.98, 3.02, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.f.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.f.1', 'LV', 1.25, 8, 0.25, 0.76, 1.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.f.2', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.f.2', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.g.1', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.g.1', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.g.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.g.2', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.a.1', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.a.1', 'LV', 1.62, 8, 0.18, 1.27, 1.98, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.a.2', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.a.2', 'LV', 1.62, 8, 0.18, 1.27, 1.98, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.a.3', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.a.3', 'LV', 2.12, 8, 0.35, 1.44, 2.81, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.1', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.1', 'LV', 2.25, 8, 0.25, 1.76, 2.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.2', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.2', 'LV', 2.12, 8, 0.23, 1.68, 2.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.3', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.3', 'LV', 1.62, 8, 0.18, 1.27, 1.98, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.4', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.4', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.c.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.c.1', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.c.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.c.2', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.c.3', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.c.3', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.3', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.3', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.1', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.1', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.2', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.2', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.3', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.3', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.4', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.4', 'LV', 1.75, 8, 0.31, 1.14, 2.36, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.5', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.5', 'LV', 1.50, 8, 0.33, 0.86, 2.14, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.6', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.6', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.7', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.7', 'LV', 1.75, 8, 0.31, 1.14, 2.36, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.1', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.1', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.2', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.2', 'LV', 1.62, 8, 0.38, 0.89, 2.36, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.3', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.3', 'LV', 1.25, 8, 0.41, 0.44, 2.06, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.4', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.4', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.5', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.5', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.a.1', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.a.1', 'LV', 4.62, 8, 0.26, 4.11, 5.14, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.a.2', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.a.2', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.a.3', 'IM', 4.50, 8, 0.19, 4.13, 4.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.a.3', 'LV', 4.75, 8, 0.16, 4.43, 5.07, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.a.4', 'IM', 4.25, 8, 0.25, 3.76, 4.74, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.a.4', 'LV', 4.62, 8, 0.18, 4.27, 4.98, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.b.1', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.b.1', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.b.2', 'IM', 3.50, 8, 0.27, 2.98, 4.02, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.b.2', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.b.3', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.b.3', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.b.4', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.b.4', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.b.5', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.b.5', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.b.6', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.b.6', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.b.7', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.c.1', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.c.1', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.c.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.c.2', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.d.1', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.d.1', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.e.1', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.e.1', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.e.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.e.2', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.e.3', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.e.3', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.f.2', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.f.2', 'LV', 2.62, 8, 0.42, 1.80, 3.45, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.g.1', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.g.1', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.g.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.1.g.2', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.a.3', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.a.3', 'LV', 2.62, 8, 0.32, 1.99, 3.26, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.b.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.b.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.c.2', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.c.2', 'LV', 0.62, 8, 0.32, 0.00, 1.26, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.a.4', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.a.4', 'LV', 0.75, 8, 0.37, 0.03, 1.47, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.a.1', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.a.1', 'LV', 4.12, 8, 0.35, 3.44, 4.81, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.a.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.a.2', 'LV', 2.75, 8, 0.31, 2.14, 3.36, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.a.3', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.a.3', 'LV', 2.38, 8, 0.46, 1.47, 3.28, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.a.6', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.a.6', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.a.7', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.a.7', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.b.1', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.b.1', 'LV', 2.00, 8, 0.38, 1.26, 2.74, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.b.2', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.b.2', 'LV', 2.00, 8, 0.19, 1.63, 2.37, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.b.4', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.b.4', 'LV', 4.25, 8, 0.31, 3.64, 4.86, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.b.5', 'IM', 4.25, 8, 0.25, 3.76, 4.74, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '1.A.4.b.5', 'LV', 4.62, 8, 0.32, 3.99, 5.26, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.a.1', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.a.2', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.a.2', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.a.3', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.a.4', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.a.4', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.b.1', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.b.1', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.b.2', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.b.2', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.b.3', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.b.3', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.b.4', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.b.4', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.b.5', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.b.5', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.b.6', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.b.6', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.b.7', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.b.7', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.c.1', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.c.1', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.c.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.c.2', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.d.1', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.d.1', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.e.1', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.e.1', 'LV', 2.50, 8, 0.27, 1.98, 3.02, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.e.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.e.2', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.e.3', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.e.3', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.f.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.f.2', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.g.1', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.g.1', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.g.2', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.1.g.2', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.a.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.a.1', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.a.2', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.a.2', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.a.3', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.a.3', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.b.1', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.b.1', 'LV', 1.62, 8, 0.32, 0.99, 2.26, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.b.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.b.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.a.1', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.a.1', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.a.2', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.a.2', 'LV', 2.50, 8, 0.42, 1.67, 3.33, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.a.3', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.a.3', 'LV', 2.00, 8, 0.38, 1.26, 2.74, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.a.6', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.a.6', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.b.1', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.b.1', 'LV', 1.75, 8, 0.41, 0.94, 2.56, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.b.2', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.b.2', 'LV', 1.50, 8, 0.33, 0.86, 2.14, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.b.4', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.b.4', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.b.5', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '1.A.4.b.5', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.1', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.1', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.2', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.2', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.3', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.3', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.4', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.4', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.1', 'IM', 3.25, 8, 0.31, 2.64, 3.86, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.1', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.2', 'IM', 3.25, 8, 0.31, 2.64, 3.86, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.2', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.3', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.3', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.4', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.5', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.5', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.6', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.6', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.7', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.c.1', 'IM', 2.75, 8, 0.31, 2.14, 3.36, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.c.1', 'LV', 3.00, 8, 0.38, 2.26, 3.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.c.2', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.c.2', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.d.1', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.d.1', 'LV', 2.75, 8, 0.31, 2.14, 3.36, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.e.1', 'IM', 2.62, 8, 0.32, 1.99, 3.26, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.e.1', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.e.2', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.e.2', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.e.3', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.e.3', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.f.1', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.f.1', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.f.2', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.f.2', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.g.1', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.g.1', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.g.2', 'IM', 2.62, 8, 0.32, 1.99, 3.26, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.g.2', 'LV', 2.38, 8, 0.42, 1.55, 3.20, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.a.1', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.a.1', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.a.2', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.a.2', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.a.3', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.a.3', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.1', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.1', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.2', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.2', 'LV', 1.38, 8, 0.38, 0.64, 2.11, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.3', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.3', 'LV', 1.00, 8, 0.33, 0.36, 1.64, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.4', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.4', 'LV', 1.00, 8, 0.33, 0.36, 1.64, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.c.1', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.c.1', 'LV', 1.00, 8, 0.38, 0.26, 1.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.c.2', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.c.2', 'LV', 1.12, 8, 0.40, 0.34, 1.91, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.4', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.4', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.1', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.1', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.2', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.2', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.3', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.3', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.6', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.6', 'LV', 1.75, 8, 0.45, 0.86, 2.64, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.1', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.1', 'LV', 2.12, 8, 0.35, 1.44, 2.81, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.2', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.2', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.4', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.4', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.5', 'IM', 3.62, 8, 0.26, 3.11, 4.14, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.5', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.1', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.1', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.2', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.2', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.3', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.3', 'LV', 4.62, 8, 0.18, 4.27, 4.98, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.4', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.1', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.1', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.2', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.2', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.3', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.3', 'LV', 4.75, 8, 0.16, 4.43, 5.07, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.4', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.4', 'LV', 4.50, 8, 0.19, 4.13, 4.87, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.5', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.5', 'LV', 4.12, 8, 0.35, 3.44, 4.81, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.6', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.6', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.7', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.7', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.c.1', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.c.1', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.c.2', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.c.2', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.d.1', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.d.1', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.e.1', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.e.1', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.e.2', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.e.2', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.e.3', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.e.3', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.f.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.f.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.f.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.f.2', 'LV', 2.75, 8, 0.37, 2.03, 3.47, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.g.1', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.g.1', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.g.2', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.g.2', 'LV', 2.12, 8, 0.13, 1.88, 2.37, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.a.3', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.a.3', 'LV', 2.12, 8, 0.35, 1.44, 2.81, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.4', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.4', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.1', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.1', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.2', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.3', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.3', 'LV', 1.50, 8, 0.33, 0.86, 2.14, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.6', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.6', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.1', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.1', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.2', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.2', 'LV', 1.50, 8, 0.33, 0.86, 2.14, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.4', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.4', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.5', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.5', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.a.1', 'IM', 4.38, 8, 0.18, 4.02, 4.73, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.a.1', 'LV', 4.50, 8, 0.19, 4.13, 4.87, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.a.2', 'IM', 4.38, 8, 0.18, 4.02, 4.73, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.a.2', 'LV', 4.13, 8, 0.13, 3.88, 4.37, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.a.3', 'IM', 4.50, 8, 0.19, 4.13, 4.87, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.a.3', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.a.4', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.a.4', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.b.1', 'IM', 3.63, 8, 0.18, 3.27, 3.98, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.b.1', 'LV', 3.63, 8, 0.18, 3.27, 3.98, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.b.2', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.b.2', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.b.3', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.b.3', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.b.4', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.b.4', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.b.5', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.b.5', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.b.6', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.b.6', 'LV', 3.63, 8, 0.18, 3.27, 3.98, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.b.7', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.b.7', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.c.1', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.c.1', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.c.2', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.c.2', 'LV', 4.25, 8, 0.25, 3.76, 4.74, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.d.1', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.d.1', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.e.1', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.e.1', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.e.2', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.e.2', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.e.3', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.e.3', 'LV', 2.63, 8, 0.18, 2.27, 2.98, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.f.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.f.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.f.2', 'IM', 2.13, 8, 0.23, 1.68, 2.57, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.f.2', 'LV', 2.25, 8, 0.37, 1.53, 2.97, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.g.1', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.g.1', 'LV', 2.88, 8, 0.30, 2.30, 3.45, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.g.2', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.1.g.2', 'LV', 3.00, 8, 0.33, 2.36, 3.64, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.a.3', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.a.3', 'LV', 2.38, 8, 0.26, 1.86, 2.89, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.b.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.b.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.c.2', 'IM', 1.13, 8, 0.13, 1.00, 1.37, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.c.2', 'LV', 0.13, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.a.4', 'IM', 1.13, 8, 0.13, 1.00, 1.37, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.a.4', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.b.1', 'IM', 1.13, 8, 0.13, 1.00, 1.37, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.b.1', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.a.1', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.a.1', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.a.2', 'IM', 2.50, 8, 0.33, 1.86, 3.14, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.a.2', 'LV', 2.63, 8, 0.46, 1.72, 3.53, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.a.3', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.a.3', 'LV', 2.00, 8, 0.50, 1.02, 2.98, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.a.6', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.a.6', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.b.1', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.b.1', 'LV', 0.88, 8, 0.35, 0.19, 1.56, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.b.2', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.b.2', 'LV', 1.25, 8, 0.41, 0.44, 2.06, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.b.4', 'IM', 4.13, 8, 0.23, 3.68, 4.57, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.b.4', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.b.5', 'IM', 4.13, 8, 0.13, 3.88, 4.37, 'N', NULL, '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '1.A.4.b.5', 'LV', 3.88, 8, 0.35, 3.19, 4.56, 'N', 'N', '2006-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.1', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.2', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.2', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.3', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.3', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.4', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.4', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.1', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.1', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.2', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.2', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.3', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.3', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.4', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.4', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.5', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.5', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.6', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.6', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.7', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.c.1', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.c.1', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.c.2', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.c.2', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.d.1', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.d.1', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.e.1', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.e.1', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.e.2', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.e.2', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.e.3', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.e.3', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.f.1', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.f.1', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.f.2', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.f.2', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.g.1', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.g.1', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.g.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.g.2', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.a.1', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.a.1', 'LV', 1.88, 8, 0.13, 1.63, 2.12, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.a.2', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.a.2', 'LV', 1.62, 8, 0.26, 1.11, 2.14, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.a.3', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.a.3', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.1', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.1', 'LV', 1.88, 8, 0.13, 1.63, 2.12, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.2', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.2', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.3', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.3', 'LV', 1.25, 8, 0.25, 0.76, 1.74, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.4', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.4', 'LV', 1.75, 8, 0.25, 1.26, 2.24, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.c.1', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.c.1', 'LV', 2.38, 8, 0.26, 1.86, 2.89, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.c.2', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.c.2', 'LV', 1.88, 8, 0.13, 1.63, 2.12, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.c.3', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.c.3', 'LV', 1.38, 8, 0.18, 1.02, 1.73, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.1', 'LV', 1.50, 8, 0.33, 0.86, 2.14, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.3', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.3', 'LV', 0.50, 8, 0.19, 0.13, 0.87, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.4', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.4', 'LV', 2.25, 8, 0.16, 1.93, 2.57, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.b.1', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.b.1', 'LV', 1.38, 8, 0.18, 1.02, 1.73, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.1', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.1', 'LV', 0.75, 8, 0.16, 0.43, 1.07, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.3', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.3', 'LV', 1.38, 8, 0.18, 1.02, 1.73, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.4', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.4', 'LV', 0.25, 8, 0.16, 0.00, 0.57, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.1', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.1', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.2', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.2', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.3', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.3', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.6', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.6', 'LV', 1.75, 8, 0.16, 1.43, 2.07, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.1', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.1', 'LV', 2.12, 8, 0.13, 1.88, 2.37, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.2', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.3', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.3', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.4', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.4', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.5', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.5', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.1', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.1', 'LV', 4.25, 8, 0.25, 3.76, 4.74, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.2', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.2', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.3', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.3', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.4', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.4', 'LV', 3.88, 8, 0.30, 3.30, 4.45, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.1', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.1', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.2', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.2', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.3', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.3', 'LV', 4.25, 8, 0.25, 3.76, 4.74, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.4', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.5', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.5', 'LV', 4.00, 8, 0.27, 3.48, 4.52, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.6', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.6', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.7', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.7', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.c.1', 'IM', 3.25, 8, 0.31, 2.64, 3.86, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.c.1', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.c.2', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.c.2', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.d.1', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.d.1', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.e.1', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.e.1', 'LV', 3.00, 8, 0.33, 2.36, 3.64, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.e.2', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.e.2', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.e.3', 'IM', 3.12, 8, 0.30, 2.55, 3.70, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.e.3', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.f.1', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.f.1', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.f.2', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.f.2', 'LV', 2.88, 8, 0.44, 2.01, 3.74, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.g.1', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.g.1', 'LV', 3.62, 8, 0.32, 2.99, 4.26, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.g.2', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.g.2', 'LV', 3.12, 8, 0.30, 2.55, 3.70, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.a.1', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.a.1', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.a.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.a.2', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.a.3', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.a.3', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.1', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.1', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.2', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.2', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.3', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.3', 'LV', 1.38, 8, 0.38, 0.64, 2.11, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.4', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.4', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.c.1', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.c.1', 'LV', 1.25, 8, 0.37, 0.53, 1.97, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.c.2', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.c.2', 'LV', 1.38, 8, 0.38, 0.64, 2.11, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.1', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.1', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.3', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.3', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.4', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.4', 'LV', 1.75, 8, 0.31, 1.14, 2.36, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.b.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.b.1', 'LV', 1.25, 8, 0.25, 0.76, 1.74, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.1', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.1', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.3', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.3', 'LV', 0.88, 8, 0.30, 0.30, 1.45, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.4', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.4', 'LV', 0.88, 8, 0.30, 0.30, 1.45, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.1', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.1', 'LV', 4.00, 8, 0.27, 3.48, 4.52, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.2', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.2', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.3', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.3', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.6', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.6', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.1', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.1', 'LV', 2.50, 8, 0.42, 1.67, 3.33, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.2', 'IM', 2.50, 8, 0.33, 1.86, 3.14, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.2', 'LV', 2.75, 8, 0.45, 1.86, 3.64, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.4', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.4', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.5', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.5', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.1', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.1', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.2', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.2', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.3', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.3', 'LV', 4.25, 8, 0.25, 3.76, 4.74, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.4', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.4', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.1', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.1', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.2', 'IM', 2.88, 8, 0.30, 2.30, 3.45, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.2', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.3', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.3', 'LV', 4.12, 8, 0.30, 3.55, 4.70, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.4', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.4', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.5', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.5', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.6', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.6', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.7', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.7', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.c.1', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.c.1', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.c.2', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.c.2', 'LV', 3.50, 8, 0.33, 2.86, 4.14, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.d.1', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.d.1', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.e.1', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.e.1', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.e.2', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.e.2', 'LV', 3.12, 8, 0.12, 2.88, 3.37, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.e.3', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.e.3', 'LV', 3.25, 8, 0.31, 2.64, 3.86, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.f.1', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.f.1', 'LV', 1.75, 8, 0.31, 1.14, 2.36, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.f.2', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.f.2', 'LV', 3.00, 8, 0.33, 2.36, 3.64, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.g.1', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.g.1', 'LV', 3.25, 8, 0.31, 2.64, 3.86, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.g.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.g.2', 'LV', 2.50, 8, 0.27, 1.98, 3.02, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.a.1', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.a.1', 'LV', 2.25, 8, 0.45, 1.36, 3.14, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.a.2', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.a.2', 'LV', 2.12, 8, 0.40, 1.34, 2.91, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.a.3', 'IM', 2.88, 8, 0.12, 2.63, 3.12, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.a.3', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.1', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.1', 'LV', 2.62, 8, 0.46, 1.72, 3.53, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.2', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.2', 'LV', 2.12, 8, 0.44, 1.26, 2.99, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.3', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.3', 'LV', 1.62, 8, 0.32, 0.99, 2.26, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.4', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.4', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.c.1', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.c.1', 'LV', 2.38, 8, 0.46, 1.47, 3.28, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.c.2', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.c.2', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.c.3', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.c.3', 'LV', 1.12, 8, 0.35, 0.44, 1.81, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.1', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.1', 'LV', 0.62, 8, 0.42, 0.00, 1.45, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.2', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.3', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.3', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.4', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.4', 'LV', 2.00, 8, 0.38, 1.26, 2.74, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.b.1', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.b.1', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.1', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.1', 'LV', 0.50, 8, 0.38, 0.00, 1.24, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.2', 'LV', 0.38, 8, 0.38, 0.00, 1.11, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.3', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.3', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.4', 'IM', 1.88, 8, 0.12, 1.63, 2.12, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.4', 'LV', 1.62, 8, 0.32, 0.99, 2.26, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.1', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.1', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.2', 'IM', 3.12, 8, 0.12, 2.88, 3.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.2', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.3', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.3', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.4', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.4', 'LV', 0.75, 8, 0.31, 0.14, 1.36, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.5', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.5', 'LV', 1.25, 8, 0.41, 0.44, 2.06, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.6', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.6', 'LV', 2.00, 8, 0.19, 1.63, 2.37, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.7', 'IM', 1.62, 8, 0.26, 1.11, 2.14, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.7', 'LV', 0.88, 8, 0.40, 0.09, 1.66, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.1', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.1', 'LV', 2.38, 8, 0.42, 1.55, 3.20, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.2', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.2', 'LV', 2.75, 8, 0.31, 2.14, 3.36, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.3', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.3', 'LV', 1.12, 8, 0.35, 0.44, 1.81, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.4', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.4', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.5', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.5', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.1', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.1', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.2', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.2', 'LV', 4.25, 8, 0.25, 3.76, 4.74, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.3', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.3', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.4', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.4', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.1', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.1', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.2', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.3', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.3', 'LV', 4.62, 8, 0.18, 4.27, 4.98, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.4', 'LV', 4.00, 8, 0.27, 3.48, 4.52, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.5', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.5', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.6', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.6', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.7', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.7', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.c.1', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.c.1', 'LV', 3.50, 8, 0.33, 2.86, 4.14, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.c.2', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.c.2', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.d.1', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.d.1', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.e.1', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.e.1', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.e.2', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.e.2', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.e.3', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.e.3', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.f.1', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.f.1', 'LV', 0.50, 8, 0.33, 0.00, 1.14, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.f.2', 'IM', 2.75, 8, 0.31, 2.14, 3.36, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.f.2', 'LV', 3.25, 8, 0.37, 2.53, 3.97, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.g.1', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.g.1', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.g.2', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.g.2', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.a.1', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.a.1', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.a.2', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.a.2', 'LV', 2.25, 8, 0.25, 1.76, 2.74, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.a.3', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.a.3', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.1', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.1', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.2', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.2', 'LV', 2.25, 8, 0.31, 1.64, 2.86, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.3', 'IM', 1.50, 8, 0.27, 1.00, 2.02, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.3', 'LV', 0.75, 8, 0.41, 0.00, 1.56, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.4', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.4', 'LV', 1.62, 8, 0.26, 1.11, 2.14, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.c.1', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.c.1', 'LV', 2.50, 8, 0.46, 1.59, 3.41, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.c.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.c.2', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.c.3', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.c.3', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.1', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.1', 'LV', 1.25, 8, 0.31, 0.64, 1.86, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.2', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.3', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.3', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.4', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.4', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.b.1', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.b.1', 'LV', 1.25, 8, 0.16, 0.93, 1.57, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.1', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.1', 'LV', 1.38, 8, 0.18, 1.02, 1.73, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.2', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.3', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.3', 'LV', 1.38, 8, 0.18, 1.02, 1.73, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.4', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.4', 'LV', 1.62, 8, 0.18, 1.27, 1.98, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.1', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.1', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.2', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.2', 'LV', 3.38, 8, 0.32, 2.74, 4.01, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.3', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.3', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.5', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.5', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.6', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.6', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.7', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.7', 'LV', 0.88, 8, 0.30, 0.30, 1.45, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.1', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.1', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.2', 'LV', 2.75, 8, 0.31, 2.14, 3.36, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.3', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.3', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.4', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.4', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.5', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.5', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.1', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.1', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.2', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.2', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.3', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.3', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.4', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.1', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.1', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.2', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.2', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.3', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.3', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.4', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.4', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.5', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.5', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.6', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.6', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.7', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.c.1', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.c.1', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.c.2', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.c.2', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.d.1', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.d.1', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.e.1', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.e.1', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.e.2', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.e.2', 'LV', 2.88, 8, 0.44, 2.01, 3.74, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.e.3', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.e.3', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.f.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.f.2', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.g.1', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.g.1', 'LV', 3.00, 8, 0.33, 2.36, 3.64, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.g.2', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.g.2', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.a.1', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.a.1', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.a.3', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.a.3', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.c.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.c.2', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.4', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.4', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.b.1', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.b.1', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.1', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.1', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.2', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.2', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.3', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.3', 'LV', 2.25, 8, 0.37, 1.53, 2.97, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.6', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.6', 'LV', 1.38, 8, 0.42, 0.55, 2.20, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.1', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.1', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.2', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.2', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.3', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.3', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.4', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.5', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.5', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.a.1', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.a.1', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.a.2', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.a.2', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.a.3', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.a.3', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.a.4', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.a.4', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.b.1', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.b.1', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.b.2', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.b.2', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.b.3', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.b.3', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.b.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.b.4', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.b.5', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.b.5', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.b.6', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.b.6', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.b.7', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.b.7', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.c.1', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.c.1', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.c.2', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.c.2', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.d.1', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.d.1', 'LV', 2.25, 8, 0.37, 1.53, 2.97, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.e.1', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.e.1', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.e.2', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.e.2', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.e.3', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.e.3', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.f.1', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.f.1', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.f.2', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.f.2', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.g.1', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.g.1', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.g.2', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.1.g.2', 'LV', 2.12, 8, 0.35, 1.44, 2.81, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.a.3', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.a.3', 'LV', 1.75, 8, 0.31, 1.14, 2.36, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.b.1', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.b.1', 'LV', 1.38, 8, 0.38, 0.64, 2.11, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.b.2', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.b.2', 'LV', 1.12, 8, 0.40, 0.34, 1.91, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.c.3', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.2.c.3', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.a.4', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.a.4', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.a.1', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.a.1', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.a.2', 'IM', 2.88, 8, 0.30, 2.30, 3.45, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.a.2', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.a.3', 'IM', 2.25, 8, 0.31, 1.64, 2.86, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.a.3', 'LV', 1.88, 8, 0.35, 1.19, 2.56, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.a.6', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.a.6', 'LV', 1.50, 8, 0.38, 0.76, 2.24, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.b.1', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.b.1', 'LV', 1.75, 8, 0.31, 1.14, 2.36, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.b.2', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.b.2', 'LV', 1.75, 8, 0.31, 1.14, 2.36, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.b.4', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.b.4', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.b.5', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '1.A.4.b.5', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', '2009-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.a.1', 'IM', 3.88, 8, 0.30, 3.30, 4.45, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.a.1', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.a.2', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.a.2', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.a.3', 'IM', 3.88, 8, 0.30, 3.30, 4.45, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.a.3', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.a.4', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.a.4', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.b.1', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.b.1', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.b.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.b.2', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.b.3', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.b.3', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.b.4', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.b.4', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.b.5', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.b.5', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.b.6', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.b.6', 'LV', 3.25, 8, 0.31, 2.64, 3.86, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.b.7', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.b.7', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.c.1', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.c.1', 'LV', 3.12, 8, 0.30, 2.55, 3.70, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.c.2', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.c.2', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.d.1', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.d.1', 'LV', 2.25, 8, 0.31, 1.64, 2.86, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.e.1', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.e.1', 'LV', 2.12, 8, 0.13, 1.88, 2.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.e.2', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.e.2', 'LV', 2.38, 8, 0.26, 1.86, 2.89, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.e.3', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.e.3', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.f.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.f.1', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.f.2', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.f.2', 'LV', 2.25, 8, 0.16, 1.93, 2.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.g.1', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.g.1', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.g.2', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.1.g.2', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.a.1', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.a.1', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.a.2', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.a.2', 'LV', 1.88, 8, 0.35, 1.19, 2.56, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.a.3', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.a.3', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.b.1', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.b.1', 'LV', 1.75, 8, 0.25, 1.26, 2.24, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.b.2', 'IM', 2.25, 8, 0.31, 1.64, 2.86, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.b.2', 'LV', 1.88, 8, 0.44, 1.01, 2.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.b.3', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.b.3', 'LV', 1.75, 8, 0.37, 1.03, 2.47, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.b.4', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.b.4', 'LV', 1.38, 8, 0.38, 0.64, 2.11, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.c.1', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.c.1', 'LV', 1.62, 8, 0.32, 0.99, 2.26, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.c.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.c.2', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.c.3', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.2.c.3', 'LV', 1.50, 8, 0.42, 0.67, 2.33, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.a.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.a.1', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.a.3', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.a.3', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.a.4', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.a.4', 'LV', 2.25, 8, 0.25, 1.76, 2.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.b.1', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.b.1', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.c.1', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.c.1', 'LV', 1.62, 8, 0.32, 0.99, 2.26, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.c.3', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.c.3', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.c.4', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.3.c.4', 'LV', 1.25, 8, 0.31, 0.64, 1.86, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.a.1', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.a.1', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.a.2', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.a.2', 'LV', 2.25, 8, 0.37, 1.53, 2.97, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.a.3', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.a.3', 'LV', 2.00, 8, 0.38, 1.26, 2.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.a.4', 'IM', 1.62, 8, 0.26, 1.11, 2.14, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.a.4', 'LV', 0.75, 8, 0.31, 0.14, 1.36, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.a.5', 'IM', 1.62, 8, 0.26, 1.11, 2.14, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.a.5', 'LV', 0.75, 8, 0.31, 0.14, 1.36, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.a.6', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.a.6', 'LV', 1.75, 8, 0.31, 1.14, 2.36, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.a.7', 'IM', 1.62, 8, 0.26, 1.11, 2.14, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.a.7', 'LV', 0.88, 8, 0.40, 0.09, 1.66, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.b.1', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.b.1', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.b.2', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.b.2', 'LV', 1.62, 8, 0.42, 0.80, 2.45, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.b.3', 'IM', 1.62, 8, 0.26, 1.11, 2.14, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.b.3', 'LV', 0.75, 8, 0.31, 0.14, 1.36, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.b.4', 'IM', 3.50, 8, 0.27, 2.98, 4.02, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.b.4', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.b.5', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '1.A.4.b.5', 'LV', 3.12, 8, 0.35, 2.44, 3.81, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.a.1', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.a.1', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.a.2', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.a.2', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.a.3', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.a.3', 'LV', 4.12, 8, 0.12, 3.88, 4.37, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.a.4', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.a.4', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.b.1', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.b.1', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.b.2', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.b.2', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.b.3', 'IM', 3.88, 8, 0.12, 3.63, 4.12, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.b.3', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.b.4', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.b.4', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.b.5', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.b.5', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.b.6', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.b.6', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.b.7', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.b.7', 'LV', 3.88, 8, 0.35, 3.19, 4.56, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.c.1', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.c.1', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.c.2', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.c.2', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.d.1', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.d.1', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.e.1', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.e.1', 'LV', 2.75, 8, 0.37, 2.03, 3.47, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.e.2', 'IM', 2.75, 8, 0.31, 2.14, 3.36, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.e.2', 'LV', 2.75, 8, 0.45, 1.86, 3.64, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.e.3', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.e.3', 'LV', 2.38, 8, 0.26, 1.86, 2.89, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.f.1', 'IM', 1.25, 8, 0.25, 1.00, 1.74, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.f.1', 'LV', 0.38, 8, 0.38, 0.00, 1.11, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.f.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.f.2', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.g.1', 'IM', 2.88, 8, 0.12, 2.63, 3.12, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.g.1', 'LV', 3.12, 8, 0.30, 2.55, 3.70, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.g.2', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.1.g.2', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.a.3', 'IM', 2.12, 8, 0.40, 1.34, 2.91, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.a.3', 'LV', 1.62, 8, 0.50, 0.65, 2.60, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.b.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.b.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.a.4', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.a.4', 'LV', 0.75, 8, 0.37, 0.03, 1.47, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.b.1', 'IM', 1.12, 8, 0.12, 1.00, 1.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.b.1', 'LV', 0.12, 8, 0.12, 0.00, 0.37, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.a.1', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.a.1', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.a.2', 'IM', 2.88, 8, 0.30, 2.30, 3.45, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.a.2', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.a.3', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.a.3', 'LV', 2.25, 8, 0.31, 1.64, 2.86, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.a.6', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.a.6', 'LV', 1.62, 8, 0.38, 0.89, 2.36, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.b.1', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.b.1', 'LV', 1.88, 8, 0.30, 1.30, 2.45, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.b.2', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.b.2', 'LV', 2.25, 8, 0.41, 1.44, 3.06, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.b.3', 'IM', 1.12, 8, 0.12, 1.00, 1.37, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.b.3', 'LV', 0.38, 8, 0.38, 0.00, 1.11, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.b.4', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.b.4', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.b.5', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '1.A.4.b.5', 'LV', 3.75, 8, 0.31, 3.14, 4.36, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.1', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.2', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.2', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.3', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.4', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.4', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.1', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.1', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.2', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.3', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.3', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.4', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.4', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.5', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.5', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.6', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.6', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.7', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.7', 'LV', 2.88, 8, 0.30, 2.30, 3.45, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.c.1', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.c.1', 'LV', 3.25, 8, 0.31, 2.64, 3.86, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.c.2', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.c.2', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.d.1', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.d.1', 'LV', 2.38, 8, 0.26, 1.86, 2.89, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.e.1', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.e.1', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.e.2', 'IM', 2.50, 8, 0.38, 1.76, 3.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.e.2', 'LV', 2.12, 8, 0.35, 1.44, 2.81, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.e.3', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.e.3', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.f.2', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.f.2', 'LV', 1.50, 8, 0.38, 0.76, 2.24, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.g.1', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.g.1', 'LV', 2.38, 8, 0.26, 1.86, 2.89, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.g.2', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.g.2', 'LV', 1.88, 8, 0.30, 1.30, 2.45, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.a.3', 'IM', 2.00, 8, 0.33, 1.36, 2.64, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.a.3', 'LV', 1.38, 8, 0.42, 0.55, 2.20, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.4', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.4', 'LV', 0.50, 8, 0.33, 0.00, 1.14, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.1', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.1', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.2', 'IM', 2.38, 8, 0.32, 1.74, 3.01, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.2', 'LV', 2.12, 8, 0.35, 1.44, 2.81, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.3', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.3', 'LV', 1.50, 8, 0.38, 0.76, 2.24, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.6', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.6', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.1', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.1', 'LV', 1.25, 8, 0.41, 0.44, 2.06, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.2', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.2', 'LV', 1.38, 8, 0.38, 0.64, 2.11, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.4', 'IM', 3.50, 8, 0.27, 2.98, 4.02, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.4', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.5', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.5', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.1', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.1', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.2', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.2', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.3', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.4', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.4', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.1', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.1', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.2', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.2', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.3', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.3', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.4', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.4', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.5', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.5', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.6', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.6', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.7', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.c.1', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.c.1', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.c.2', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.c.2', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.d.1', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.d.1', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.e.1', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.e.1', 'LV', 3.12, 8, 0.35, 2.44, 3.81, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.e.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.e.2', 'LV', 3.00, 8, 0.33, 2.36, 3.64, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.e.3', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.e.3', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.f.2', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.f.2', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.g.1', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.g.1', 'LV', 2.75, 8, 0.31, 2.14, 3.36, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.g.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.g.2', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.a.1', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.a.1', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.a.3', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.a.3', 'LV', 2.38, 8, 0.26, 1.86, 2.89, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.c.2', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.c.2', 'LV', 0.25, 8, 0.16, 0.00, 0.57, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.4', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.4', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.1', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.1', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.2', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.2', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.3', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.3', 'LV', 1.88, 8, 0.40, 1.09, 2.66, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.6', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.6', 'LV', 1.25, 8, 0.37, 0.53, 1.97, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.1', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.1', 'LV', 1.75, 8, 0.41, 0.94, 2.56, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.2', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.2', 'LV', 1.75, 8, 0.37, 1.03, 2.47, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.4', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.4', 'LV', 4.62, 8, 0.26, 4.11, 5.14, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.5', 'IM', 3.75, 8, 0.31, 3.14, 4.36, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.5', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.1', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.2', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.2', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.3', 'IM', 4.38, 8, 0.18, 4.02, 4.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.3', 'LV', 4.88, 8, 0.13, 4.63, 5.12, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.4', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.4', 'LV', 4.50, 8, 0.19, 4.13, 4.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.1', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.1', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.2', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.2', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.3', 'IM', 3.50, 8, 0.27, 2.98, 4.02, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.3', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.4', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.5', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.5', 'LV', 3.75, 8, 0.37, 3.03, 4.47, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.6', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.6', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.7', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.c.1', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.c.1', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.c.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.c.2', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.d.1', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.d.1', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.e.1', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.e.1', 'LV', 2.62, 8, 0.42, 1.80, 3.45, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.e.2', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.e.2', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.e.3', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.e.3', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.f.1', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.f.1', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.f.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.f.2', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.g.1', 'IM', 3.12, 8, 0.30, 2.55, 3.70, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.g.1', 'LV', 2.75, 8, 0.37, 2.03, 3.47, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.g.2', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.g.2', 'LV', 2.12, 8, 0.40, 1.34, 2.91, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.a.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.a.1', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.a.2', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.a.2', 'LV', 1.00, 8, 0.19, 0.63, 1.37, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.a.3', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.a.3', 'LV', 2.38, 8, 0.26, 1.86, 2.89, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.1', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.1', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.2', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.c.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.c.2', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.4', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.4', 'LV', 1.75, 8, 0.25, 1.26, 2.24, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.1', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.1', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.2', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.2', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.3', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.3', 'LV', 2.38, 8, 0.38, 1.64, 3.11, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.6', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.6', 'LV', 1.38, 8, 0.42, 0.55, 2.20, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.1', 'IM', 2.12, 8, 0.30, 1.55, 2.70, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.1', 'LV', 1.88, 8, 0.44, 1.01, 2.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.2', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.2', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.4', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.5', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.5', 'LV', 5.00, 8, 0.33, 4.36, 5.64, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.a.1', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.a.1', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.a.2', 'IM', 3.63, 8, 0.18, 3.27, 3.98, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.a.2', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.a.3', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.a.3', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.a.4', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.a.4', 'LV', 3.63, 8, 0.26, 3.11, 4.14, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.b.1', 'IM', 3.13, 8, 0.35, 2.44, 3.81, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.b.1', 'LV', 3.00, 8, 0.33, 2.36, 3.64, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.b.2', 'IM', 3.25, 8, 0.37, 2.53, 3.97, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.b.2', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.b.3', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.b.3', 'LV', 3.88, 8, 0.30, 3.30, 4.45, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.b.4', 'IM', 3.63, 8, 0.18, 3.27, 3.98, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.b.4', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.b.5', 'IM', 3.63, 8, 0.18, 3.27, 3.98, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.b.5', 'LV', 3.63, 8, 0.18, 3.27, 3.98, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.b.6', 'IM', 3.63, 8, 0.18, 3.27, 3.98, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.b.6', 'LV', 3.50, 8, 0.33, 2.86, 4.14, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.b.7', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.b.7', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.c.1', 'IM', 2.13, 8, 0.23, 1.68, 2.57, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.c.1', 'LV', 2.00, 8, 0.38, 1.26, 2.74, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.c.2', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.c.2', 'LV', 2.63, 8, 0.18, 2.27, 2.98, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.d.1', 'IM', 2.38, 8, 0.32, 1.74, 3.01, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.d.1', 'LV', 2.13, 8, 0.40, 1.34, 2.91, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.e.1', 'IM', 2.38, 8, 0.38, 1.64, 3.11, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.e.1', 'LV', 2.13, 8, 0.35, 1.44, 2.81, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.e.2', 'IM', 3.13, 8, 0.35, 2.44, 3.81, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.e.2', 'LV', 2.88, 8, 0.30, 2.30, 3.45, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.e.3', 'IM', 2.75, 8, 0.37, 2.03, 3.47, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.e.3', 'LV', 2.38, 8, 0.42, 1.55, 3.20, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.f.1', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.f.1', 'LV', 1.00, 8, 0.33, 0.36, 1.64, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.f.2', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.f.2', 'LV', 3.13, 8, 0.23, 2.68, 3.57, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.g.1', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.g.1', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.g.2', 'IM', 2.88, 8, 0.30, 2.30, 3.45, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.1.g.2', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.a.1', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.a.1', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.a.2', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.a.2', 'LV', 2.63, 8, 0.26, 2.11, 3.14, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.a.3', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.a.3', 'LV', 2.63, 8, 0.18, 2.27, 2.98, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.b.1', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.b.1', 'LV', 2.63, 8, 0.18, 2.27, 2.98, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.b.2', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.b.2', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.b.3', 'IM', 1.88, 8, 0.30, 1.30, 2.45, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.b.3', 'LV', 1.38, 8, 0.46, 0.47, 2.28, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.b.4', 'IM', 1.63, 8, 0.26, 1.11, 2.14, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.b.4', 'LV', 0.88, 8, 0.35, 0.19, 1.56, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.c.1', 'IM', 1.63, 8, 0.26, 1.11, 2.14, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.c.1', 'LV', 0.88, 8, 0.35, 0.19, 1.56, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.c.2', 'IM', 1.63, 8, 0.26, 1.11, 2.14, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.c.2', 'LV', 0.88, 8, 0.35, 0.19, 1.56, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.c.3', 'IM', 1.63, 8, 0.26, 1.11, 2.14, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.2.c.3', 'LV', 0.88, 8, 0.35, 0.19, 1.56, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.a.1', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.a.1', 'LV', 2.25, 8, 0.37, 1.53, 2.97, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.a.3', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.a.3', 'LV', 1.25, 8, 0.41, 0.44, 2.06, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.a.4', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.a.4', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.b.1', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.b.1', 'LV', 1.88, 8, 0.30, 1.30, 2.45, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.c.1', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.c.1', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.c.3', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.c.3', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.c.4', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.3.c.4', 'LV', 1.13, 8, 0.35, 0.44, 1.81, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.a.1', 'IM', 3.63, 8, 0.18, 3.27, 3.98, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.a.1', 'LV', 3.25, 8, 0.31, 2.64, 3.86, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.a.2', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.a.2', 'LV', 2.75, 8, 0.37, 2.03, 3.47, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.a.3', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.a.3', 'LV', 2.63, 8, 0.18, 2.27, 2.98, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.a.4', 'IM', 1.63, 8, 0.26, 1.11, 2.14, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.a.4', 'LV', 0.88, 8, 0.35, 0.19, 1.56, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.a.5', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.a.5', 'LV', 1.00, 8, 0.33, 0.36, 1.64, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.a.6', 'IM', 2.50, 8, 0.33, 1.86, 3.14, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.a.6', 'LV', 2.13, 8, 0.40, 1.34, 2.91, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.a.7', 'IM', 1.63, 8, 0.26, 1.11, 2.14, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.a.7', 'LV', 0.88, 8, 0.35, 0.19, 1.56, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.b.1', 'IM', 2.50, 8, 0.33, 1.86, 3.14, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.b.1', 'LV', 2.38, 8, 0.38, 1.64, 3.11, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.b.2', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.b.2', 'LV', 2.38, 8, 0.26, 1.86, 2.89, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.b.3', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.b.3', 'LV', 0.88, 8, 0.35, 0.19, 1.56, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.b.4', 'IM', 3.50, 8, 0.27, 2.98, 4.02, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.b.4', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.b.5', 'IM', 3.63, 8, 0.18, 3.27, 3.98, 'N', NULL, '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '1.A.4.b.5', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2007-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.a.1', 'IM', 4.13, 8, 0.13, 3.88, 4.37, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.a.1', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.a.2', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.a.2', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.a.3', 'IM', 4.13, 8, 0.23, 3.68, 4.57, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.a.3', 'LV', 4.25, 8, 0.25, 3.76, 4.74, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.a.4', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.a.4', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.b.1', 'IM', 3.25, 8, 0.31, 2.64, 3.86, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.b.1', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.b.2', 'IM', 3.13, 8, 0.23, 2.68, 3.57, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.b.2', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.b.3', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.b.3', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.b.4', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.b.4', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.b.5', 'IM', 3.63, 8, 0.18, 3.27, 3.98, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.b.5', 'LV', 3.63, 8, 0.18, 3.27, 3.98, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.b.6', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.b.6', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.b.7', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.b.7', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.c.1', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.c.1', 'LV', 3.13, 8, 0.13, 2.88, 3.37, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.c.2', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.c.2', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.d.1', 'IM', 2.63, 8, 0.18, 2.27, 2.98, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.d.1', 'LV', 2.63, 8, 0.26, 2.11, 3.14, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.e.1', 'IM', 2.63, 8, 0.32, 1.99, 3.26, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.e.1', 'LV', 2.25, 8, 0.37, 1.53, 2.97, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.e.2', 'IM', 3.25, 8, 0.37, 2.53, 3.97, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.e.2', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.e.3', 'IM', 2.88, 8, 0.30, 2.30, 3.45, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.e.3', 'LV', 2.88, 8, 0.30, 2.30, 3.45, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.f.1', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.f.1', 'LV', 1.00, 8, 0.33, 0.36, 1.64, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.f.2', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.f.2', 'LV', 2.88, 8, 0.30, 2.30, 3.45, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.g.1', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.g.1', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.g.2', 'IM', 2.63, 8, 0.18, 2.27, 2.98, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.1.g.2', 'LV', 2.63, 8, 0.18, 2.27, 2.98, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.a.1', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.a.1', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.a.2', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.a.2', 'LV', 2.63, 8, 0.18, 2.27, 2.98, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.a.3', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.a.3', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.b.1', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.b.1', 'LV', 3.00, 8, 0.33, 2.36, 3.64, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.b.2', 'IM', 2.63, 8, 0.26, 2.11, 3.14, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.b.2', 'LV', 2.63, 8, 0.46, 1.72, 3.53, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.b.3', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.b.3', 'LV', 1.63, 8, 0.42, 0.80, 2.45, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.b.4', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.b.4', 'LV', 1.63, 8, 0.42, 0.80, 2.45, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.c.1', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.c.1', 'LV', 1.88, 8, 0.52, 0.86, 2.89, 'Y', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.c.2', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.c.2', 'LV', 1.13, 8, 0.40, 0.34, 1.91, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.c.3', 'IM', 1.50, 8, 0.27, 1.00, 2.02, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.2.c.3', 'LV', 0.63, 8, 0.38, 0.00, 1.36, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.a.1', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.a.1', 'LV', 1.50, 8, 0.38, 0.76, 2.24, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.a.3', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.a.3', 'LV', 1.50, 8, 0.42, 0.67, 2.33, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.a.4', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.a.4', 'LV', 2.00, 8, 0.38, 1.26, 2.74, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.b.1', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.b.1', 'LV', 0.63, 8, 0.26, 0.11, 1.14, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.c.1', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.c.1', 'LV', 2.00, 8, 0.57, 0.89, 3.11, 'Y', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.c.2', 'IM', 1.13, 8, 0.13, 1.00, 1.37, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.c.2', 'LV', 0.13, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.c.3', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.c.3', 'LV', 1.25, 8, 0.49, 0.29, 2.21, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.c.4', 'IM', 1.63, 8, 0.26, 1.11, 2.14, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.3.c.4', 'LV', 0.88, 8, 0.40, 0.09, 1.66, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.a.1', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.a.1', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.a.2', 'IM', 2.88, 8, 0.30, 2.30, 3.45, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.a.2', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.a.3', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.a.3', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.a.4', 'IM', 1.63, 8, 0.26, 1.11, 2.14, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.a.4', 'LV', 0.88, 8, 0.40, 0.09, 1.66, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.a.5', 'IM', 1.63, 8, 0.26, 1.11, 2.14, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.a.5', 'LV', 0.75, 8, 0.31, 0.14, 1.36, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.a.6', 'IM', 2.63, 8, 0.32, 1.99, 3.26, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.a.6', 'LV', 2.50, 8, 0.42, 1.67, 3.33, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.a.7', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.a.7', 'LV', 1.63, 8, 0.42, 0.80, 2.45, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.b.1', 'IM', 2.38, 8, 0.32, 1.74, 3.01, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.b.1', 'LV', 2.38, 8, 0.38, 1.64, 3.11, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.b.2', 'IM', 2.63, 8, 0.26, 2.11, 3.14, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.b.2', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.b.3', 'IM', 1.88, 8, 0.30, 1.30, 2.45, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.b.3', 'LV', 1.00, 8, 0.33, 0.36, 1.64, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.b.4', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.b.4', 'LV', 3.13, 8, 0.23, 2.68, 3.57, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.b.5', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '1.A.4.b.5', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', '2006-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.1', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.1', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.2', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.2', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.3', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.3', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.4', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.4', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.1', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.1', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.2', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.2', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.3', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.3', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.4', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.4', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.5', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.5', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.6', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.6', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.7', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.7', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.c.1', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.c.1', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.c.2', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.c.2', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.d.1', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.d.1', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.e.1', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.e.1', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.e.2', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.e.2', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.e.3', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.e.3', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.f.1', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.f.1', 'LV', 1.38, 8, 0.26, 0.86, 1.89, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.f.2', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.f.2', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.g.1', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.g.1', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.g.2', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.g.2', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.a.1', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.a.1', 'LV', 0.62, 8, 0.32, 0.00, 1.26, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.a.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.a.2', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.a.3', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.a.3', 'LV', 2.25, 8, 0.16, 1.93, 2.57, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.1', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.1', 'LV', 1.88, 8, 0.13, 1.63, 2.12, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.2', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.2', 'LV', 1.88, 8, 0.13, 1.63, 2.12, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.c.1', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.c.1', 'LV', 2.00, 8, 0.00, 2.00, 2.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.c.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.c.2', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.1', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.1', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.3', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.3', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.4', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.4', 'LV', 1.12, 8, 0.35, 0.44, 1.81, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.b.1', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.b.1', 'LV', 0.25, 8, 0.16, 0.00, 0.57, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.1', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.1', 'LV', 0.38, 8, 0.18, 0.02, 0.73, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.3', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.3', 'LV', 0.50, 8, 0.27, 0.00, 1.02, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.4', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.4', 'LV', 1.12, 8, 0.35, 0.44, 1.81, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.1', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.1', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.2', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.2', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.3', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.3', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.6', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.6', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.7', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.7', 'LV', 1.62, 8, 0.38, 0.89, 2.36, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.1', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.1', 'LV', 2.25, 8, 0.16, 1.93, 2.57, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.2', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.4', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.4', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.5', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.5', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.1', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.2', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.2', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.3', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.3', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.4', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.4', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.1', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.1', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.2', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.2', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.3', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.3', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.4', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.4', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.5', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.5', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.6', 'IM', 3.50, 8, 0.27, 2.98, 4.02, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.6', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.7', 'IM', 3.12, 8, 0.30, 2.55, 3.70, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.7', 'LV', 3.12, 8, 0.30, 2.55, 3.70, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.c.1', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.c.1', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.c.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.c.2', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.d.1', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.d.1', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.e.1', 'IM', 2.75, 8, 0.31, 2.14, 3.36, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.e.1', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.e.2', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.e.2', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.e.3', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.e.3', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.f.1', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.f.1', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.f.2', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.f.2', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.g.1', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.g.1', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.g.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.g.2', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.a.1', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.a.1', 'LV', 2.00, 8, 0.19, 1.63, 2.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.a.2', 'IM', 1.25, 8, 0.25, 1.00, 1.74, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.a.2', 'LV', 0.38, 8, 0.38, 0.00, 1.11, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.a.3', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.a.3', 'LV', 2.12, 8, 0.35, 1.44, 2.81, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.2', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.2', 'LV', 1.00, 8, 0.33, 0.36, 1.64, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.1', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.1', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.3', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.3', 'LV', 0.88, 8, 0.30, 0.30, 1.45, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.4', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.4', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.b.1', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.b.1', 'LV', 0.88, 8, 0.30, 0.30, 1.45, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.1', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.1', 'LV', 0.88, 8, 0.30, 0.30, 1.45, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.3', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.3', 'LV', 1.00, 8, 0.33, 0.36, 1.64, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.4', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.4', 'LV', 0.88, 8, 0.30, 0.30, 1.45, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.1', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.1', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.2', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.2', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.3', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.3', 'LV', 1.88, 8, 0.35, 1.19, 2.56, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.6', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.6', 'LV', 1.12, 8, 0.40, 0.34, 1.91, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.1', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.1', 'LV', 1.75, 8, 0.45, 0.86, 2.64, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.2', 'IM', 2.12, 8, 0.30, 1.55, 2.70, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.2', 'LV', 1.62, 8, 0.38, 0.89, 2.36, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.3', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.3', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.4', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.4', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.5', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.5', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.1', 'IM', 4.38, 8, 0.18, 4.02, 4.73, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.1', 'LV', 4.50, 8, 0.27, 3.98, 5.02, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.2', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.2', 'LV', 4.25, 8, 0.25, 3.76, 4.74, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.3', 'IM', 4.38, 8, 0.18, 4.02, 4.73, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.3', 'LV', 4.62, 8, 0.18, 4.27, 4.98, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.4', 'IM', 4.12, 8, 0.23, 3.68, 4.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.4', 'LV', 4.38, 8, 0.32, 3.74, 5.01, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.1', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.1', 'LV', 4.00, 8, 0.27, 3.48, 4.52, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.2', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.2', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.3', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.3', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.4', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.4', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.5', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.5', 'LV', 4.00, 8, 0.27, 3.48, 4.52, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.6', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.6', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.7', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.7', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.c.1', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.c.1', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.c.2', 'IM', 2.62, 8, 0.32, 1.99, 3.26, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.c.2', 'LV', 2.75, 8, 0.45, 1.86, 3.64, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.d.1', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.d.1', 'LV', 2.75, 8, 0.31, 2.14, 3.36, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.e.1', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.e.1', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.e.2', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.e.2', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.e.3', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.e.3', 'LV', 2.38, 8, 0.26, 1.86, 2.89, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.f.2', 'IM', 2.75, 8, 0.31, 2.14, 3.36, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.f.2', 'LV', 2.88, 8, 0.30, 2.30, 3.45, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.g.1', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.g.1', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.g.2', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.g.2', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.a.1', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.a.1', 'LV', 0.75, 8, 0.25, 0.26, 1.24, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.a.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.a.2', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.a.3', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.a.3', 'LV', 1.88, 8, 0.13, 1.63, 2.12, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.2', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.2', 'LV', 0.62, 8, 0.26, 0.11, 1.14, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.3', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.3', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.c.1', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.c.1', 'LV', 0.88, 8, 0.35, 0.19, 1.56, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.c.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.c.2', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.c.3', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.c.3', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.1', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.2', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.2', 'LV', 0.62, 8, 0.26, 0.11, 1.14, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.3', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.3', 'LV', 0.75, 8, 0.16, 0.43, 1.07, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.4', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.4', 'LV', 2.00, 8, 0.19, 1.63, 2.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.b.1', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.b.1', 'LV', 1.00, 8, 0.27, 0.48, 1.52, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.1', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.1', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.2', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.3', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.3', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.4', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.4', 'LV', 1.00, 8, 0.27, 0.48, 1.52, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.1', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.1', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.2', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.2', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.3', 'IM', 2.00, 8, 0.33, 1.36, 2.64, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.3', 'LV', 1.50, 8, 0.46, 0.59, 2.41, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.6', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.6', 'LV', 1.25, 8, 0.31, 0.64, 1.86, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.1', 'IM', 2.12, 8, 0.30, 1.55, 2.70, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.1', 'LV', 1.75, 8, 0.41, 0.94, 2.56, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.2', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.2', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.4', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.4', 'LV', 4.12, 8, 0.35, 3.44, 4.81, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.5', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.5', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.1', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.1', 'LV', 4.62, 8, 0.18, 4.27, 4.98, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.2', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.2', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.3', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.3', 'LV', 4.62, 8, 0.18, 4.27, 4.98, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.4', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.4', 'LV', 4.50, 8, 0.19, 4.13, 4.87, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.1', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.1', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.2', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.2', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.3', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.3', 'LV', 4.00, 8, 0.27, 3.48, 4.52, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.4', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.5', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.5', 'LV', 4.25, 8, 0.25, 3.76, 4.74, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.6', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.6', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.7', 'IM', 3.62, 8, 0.32, 2.99, 4.26, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.7', 'LV', 3.50, 8, 0.38, 2.76, 4.24, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.c.1', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.c.1', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.c.2', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.c.2', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.d.1', 'IM', 3.12, 8, 0.30, 2.55, 3.70, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.d.1', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.e.1', 'IM', 2.88, 8, 0.35, 2.19, 3.56, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.e.1', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.e.2', 'IM', 3.12, 8, 0.30, 2.55, 3.70, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.e.2', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.e.3', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.e.3', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.f.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.f.2', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.g.1', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.g.1', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.g.2', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.g.2', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.a.1', 'IM', 1.38, 8, 0.26, 1.00, 1.89, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.a.1', 'LV', 0.62, 8, 0.42, 0.00, 1.45, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.a.2', 'IM', 1.25, 8, 0.25, 1.00, 1.74, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.a.2', 'LV', 0.38, 8, 0.38, 0.00, 1.11, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.a.3', 'IM', 2.38, 8, 0.38, 1.64, 3.11, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.a.3', 'LV', 1.88, 8, 0.44, 1.01, 2.74, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.4', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.4', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.1', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.1', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.2', 'IM', 2.62, 8, 0.38, 1.89, 3.36, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.2', 'LV', 2.50, 8, 0.38, 1.76, 3.24, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.3', 'IM', 2.25, 8, 0.31, 1.64, 2.86, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.3', 'LV', 1.88, 8, 0.35, 1.19, 2.56, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.6', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.6', 'LV', 0.50, 8, 0.27, 0.00, 1.02, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.1', 'IM', 2.12, 8, 0.30, 1.55, 2.70, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.1', 'LV', 1.75, 8, 0.41, 0.94, 2.56, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.2', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.2', 'LV', 1.38, 8, 0.42, 0.55, 2.20, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.4', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.4', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.5', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.5', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.a.1', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.a.1', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.a.2', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.a.2', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.a.3', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.a.3', 'LV', 4.25, 8, 0.25, 3.76, 4.74, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.a.4', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.a.4', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.b.1', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.b.1', 'LV', 3.75, 8, 0.31, 3.14, 4.36, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.b.2', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.b.2', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.b.3', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.b.3', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.b.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.b.4', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.b.5', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.b.5', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.b.6', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.b.6', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.b.7', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.b.7', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.c.1', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.c.1', 'LV', 3.12, 8, 0.30, 2.55, 3.70, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.c.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.c.2', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.d.1', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.d.1', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.e.1', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.e.1', 'LV', 2.12, 8, 0.23, 1.68, 2.57, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.e.2', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.e.2', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.e.3', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.e.3', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.f.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.f.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.f.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.f.2', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.g.1', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.g.1', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.g.2', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.1.g.2', 'LV', 2.25, 8, 0.16, 1.93, 2.57, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.a.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.a.1', 'LV', 1.00, 8, 0.19, 0.63, 1.37, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.a.2', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.a.2', 'LV', 0.75, 8, 0.16, 0.43, 1.07, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.a.3', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.a.3', 'LV', 2.12, 8, 0.13, 1.88, 2.37, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.b.1', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.b.1', 'LV', 0.75, 8, 0.25, 0.26, 1.24, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.b.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.b.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.c.2', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.c.2', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.a.4', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.a.4', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.a.1', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.a.1', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.a.2', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.a.2', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.a.3', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.a.3', 'LV', 1.88, 8, 0.30, 1.30, 2.45, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.a.6', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.a.6', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.b.1', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.b.1', 'LV', 1.62, 8, 0.26, 1.11, 2.14, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.b.2', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.b.2', 'LV', 1.88, 8, 0.30, 1.30, 2.45, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.b.4', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.b.4', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.b.5', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '1.A.4.b.5', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2013-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.1', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.1', 'LV', 4.75, 8, 0.31, 4.14, 5.36, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.2', 'IM', 4.38, 8, 0.18, 4.02, 4.73, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.2', 'LV', 4.62, 8, 0.26, 4.11, 5.14, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.3', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.3', 'LV', 4.50, 8, 0.19, 4.13, 4.87, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.4', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.4', 'LV', 4.50, 8, 0.19, 4.13, 4.87, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.1', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.1', 'LV', 4.00, 8, 0.27, 3.48, 4.52, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.2', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.2', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.3', 'IM', 4.00, 8, 0.27, 3.48, 4.52, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.3', 'LV', 4.38, 8, 0.38, 3.64, 5.11, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.4', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.4', 'LV', 4.38, 8, 0.32, 3.74, 5.01, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.5', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.5', 'LV', 4.38, 8, 0.26, 3.86, 4.89, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.6', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.6', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.7', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.c.1', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.c.1', 'LV', 4.12, 8, 0.35, 3.44, 4.81, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.c.2', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.c.2', 'LV', 4.12, 8, 0.35, 3.44, 4.81, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.d.1', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.d.1', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.e.1', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.e.1', 'LV', 3.12, 8, 0.30, 2.55, 3.70, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.e.2', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.e.2', 'LV', 3.50, 8, 0.33, 2.86, 4.14, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.e.3', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.e.3', 'LV', 3.25, 8, 0.31, 2.64, 3.86, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.f.1', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.f.1', 'LV', 0.62, 8, 0.42, 0.00, 1.45, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.f.2', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.f.2', 'LV', 4.38, 8, 0.38, 3.64, 5.11, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.g.1', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.g.1', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.g.2', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.g.2', 'LV', 2.62, 8, 0.50, 1.65, 3.60, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.a.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.a.1', 'LV', 1.50, 8, 0.33, 0.86, 2.14, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.a.2', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.a.2', 'LV', 1.62, 8, 0.32, 0.99, 2.26, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.a.3', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.a.3', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.1', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.2', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.2', 'LV', 1.25, 8, 0.37, 0.53, 1.97, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.4', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.4', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.1', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.1', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.2', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.2', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.3', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.3', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.6', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.6', 'LV', 2.12, 8, 0.35, 1.44, 2.81, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.1', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.1', 'LV', 1.50, 8, 0.38, 0.76, 2.24, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.2', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.2', 'LV', 2.25, 8, 0.37, 1.53, 2.97, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.4', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.4', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.5', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.5', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.1', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.1', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.2', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.2', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.3', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.3', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.4', 'IM', 3.50, 8, 0.33, 2.86, 4.14, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.4', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.1', 'IM', 3.12, 8, 0.30, 2.55, 3.70, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.1', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.2', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.2', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.3', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.3', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.4', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.4', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.5', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.5', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.6', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.6', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.7', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.c.1', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.c.1', 'LV', 2.75, 8, 0.37, 2.03, 3.47, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.c.2', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.c.2', 'LV', 3.00, 8, 0.38, 2.26, 3.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.d.1', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.d.1', 'LV', 2.50, 8, 0.27, 1.98, 3.02, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.e.1', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.e.1', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.e.2', 'IM', 2.75, 8, 0.31, 2.14, 3.36, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.e.2', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.e.3', 'IM', 2.88, 8, 0.30, 2.30, 3.45, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.e.3', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.f.2', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.f.2', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.g.1', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.g.1', 'LV', 2.88, 8, 0.30, 2.30, 3.45, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.g.2', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.g.2', 'LV', 2.88, 8, 0.30, 2.30, 3.45, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.a.1', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.a.1', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.a.2', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.a.2', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.a.3', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.a.3', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.1', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.1', 'LV', 2.25, 8, 0.37, 1.53, 2.97, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.2', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.2', 'LV', 1.88, 8, 0.35, 1.19, 2.56, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.3', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.3', 'LV', 1.50, 8, 0.42, 0.67, 2.33, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.4', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.4', 'LV', 1.25, 8, 0.31, 0.64, 1.86, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.c.1', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.c.1', 'LV', 1.00, 8, 0.33, 0.36, 1.64, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.c.2', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.c.2', 'LV', 1.25, 8, 0.31, 0.64, 1.86, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.c.3', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.c.3', 'LV', 1.75, 8, 0.45, 0.86, 2.64, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.1', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.1', 'LV', 2.12, 8, 0.35, 1.44, 2.81, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.3', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.3', 'LV', 1.62, 8, 0.32, 0.99, 2.26, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.4', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.4', 'LV', 2.50, 8, 0.27, 1.98, 3.02, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.b.1', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.b.1', 'LV', 1.88, 8, 0.35, 1.19, 2.56, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.1', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.1', 'LV', 2.12, 8, 0.40, 1.34, 2.91, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.3', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.3', 'LV', 1.75, 8, 0.31, 1.14, 2.36, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.4', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.4', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.1', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.1', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.2', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.2', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.3', 'IM', 2.62, 8, 0.38, 1.89, 3.36, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.3', 'LV', 2.38, 8, 0.46, 1.47, 3.28, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.6', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.6', 'LV', 2.12, 8, 0.23, 1.68, 2.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.1', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.1', 'LV', 2.25, 8, 0.16, 1.93, 2.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.2', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.2', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.4', 'IM', 3.25, 8, 0.31, 2.64, 3.86, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.4', 'LV', 2.88, 8, 0.30, 2.30, 3.45, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.5', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.5', 'LV', 3.12, 8, 0.30, 2.55, 3.70, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.1', 'IM', 4.13, 8, 0.13, 3.88, 4.37, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.1', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.2', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.2', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.3', 'IM', 4.13, 8, 0.13, 3.88, 4.37, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.3', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.4', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.4', 'LV', 3.63, 8, 0.18, 3.27, 3.98, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.1', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.1', 'LV', 3.13, 8, 0.30, 2.55, 3.70, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.2', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.2', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.3', 'IM', 4.13, 8, 0.13, 3.88, 4.37, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.3', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.4', 'LV', 4.13, 8, 0.23, 3.68, 4.57, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.5', 'IM', 4.13, 8, 0.13, 3.88, 4.37, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.5', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.6', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.6', 'LV', 3.63, 8, 0.18, 3.27, 3.98, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.7', 'IM', 3.13, 8, 0.13, 2.88, 3.37, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.7', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.c.1', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.c.1', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.c.2', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.c.2', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.d.1', 'IM', 2.88, 8, 0.35, 2.19, 3.56, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.d.1', 'LV', 2.88, 8, 0.44, 2.01, 3.74, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.e.1', 'IM', 3.00, 8, 0.33, 2.36, 3.64, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.e.1', 'LV', 3.00, 8, 0.42, 2.17, 3.83, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.e.2', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.e.2', 'LV', 3.38, 8, 0.38, 2.64, 4.11, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.e.3', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.e.3', 'LV', 2.75, 8, 0.37, 2.03, 3.47, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.f.1', 'IM', 1.13, 8, 0.13, 1.00, 1.37, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.f.1', 'LV', 0.13, 8, 0.13, 0.00, 0.37, 'N', 'Y', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.f.2', 'IM', 2.25, 8, 0.31, 1.64, 2.86, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.f.2', 'LV', 1.88, 8, 0.44, 1.01, 2.74, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.g.1', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.g.1', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.g.2', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.g.2', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.a.1', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.a.1', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.a.2', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.a.2', 'LV', 1.13, 8, 0.30, 0.55, 1.70, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.a.3', 'IM', 2.13, 8, 0.23, 1.68, 2.57, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.a.3', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.1', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.1', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.2', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.2', 'LV', 1.25, 8, 0.31, 0.64, 1.86, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.3', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.3', 'LV', 1.50, 8, 0.38, 0.76, 2.24, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.c.1', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.c.1', 'LV', 1.75, 8, 0.37, 1.03, 2.47, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.c.3', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.c.3', 'LV', 1.25, 8, 0.25, 0.76, 1.74, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.1', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.1', 'LV', 2.13, 8, 0.44, 1.26, 2.99, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.2', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.2', 'LV', 1.75, 8, 0.45, 0.86, 2.64, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.3', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.3', 'LV', 1.25, 8, 0.25, 0.76, 1.74, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.4', 'IM', 2.63, 8, 0.18, 2.27, 2.98, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.4', 'LV', 2.63, 8, 0.18, 2.27, 2.98, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.b.1', 'IM', 2.63, 8, 0.18, 2.27, 2.98, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.b.1', 'LV', 1.50, 8, 0.19, 1.13, 1.87, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.1', 'IM', 1.63, 8, 0.18, 1.27, 1.98, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.1', 'LV', 1.00, 8, 0.33, 0.36, 1.64, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.3', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.3', 'LV', 1.63, 8, 0.18, 1.27, 1.98, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.4', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.4', 'LV', 1.38, 8, 0.26, 0.86, 1.89, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.1', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.1', 'LV', 3.13, 8, 0.23, 2.68, 3.57, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.2', 'IM', 3.13, 8, 0.30, 2.55, 3.70, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.2', 'LV', 3.88, 8, 0.44, 3.01, 4.74, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.3', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.3', 'LV', 2.75, 8, 0.31, 2.14, 3.36, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.4', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.4', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.5', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.5', 'LV', 0.88, 8, 0.58, 0.00, 2.01, 'Y', 'Y', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.6', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.6', 'LV', 1.63, 8, 0.26, 1.11, 2.14, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.7', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.7', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.1', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.1', 'LV', 1.88, 8, 0.30, 1.30, 2.45, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.2', 'IM', 2.63, 8, 0.26, 2.11, 3.14, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.2', 'LV', 2.25, 8, 0.41, 1.44, 3.06, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.4', 'IM', 4.13, 8, 0.13, 3.88, 4.37, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.4', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.5', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.5', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2005-12-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.1', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.1', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.2', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.2', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.3', 'IM', 4.38, 8, 0.18, 4.02, 4.73, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.3', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.4', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.1', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.1', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.2', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.2', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.3', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.3', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.4', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.5', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.5', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.6', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.6', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.7', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.c.1', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.c.1', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.c.2', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.c.2', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.d.1', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.d.1', 'LV', 2.88, 8, 0.30, 2.30, 3.45, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.e.1', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.e.1', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.e.2', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.e.2', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.e.3', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.e.3', 'LV', 2.62, 8, 0.26, 2.11, 3.14, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.f.1', 'IM', 1.62, 8, 0.32, 1.00, 2.26, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.f.1', 'LV', 0.88, 8, 0.44, 0.01, 1.74, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.f.2', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.f.2', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.g.1', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.g.1', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.g.2', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.g.2', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.a.1', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.a.1', 'LV', 2.25, 8, 0.16, 1.93, 2.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.a.2', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.a.2', 'LV', 2.00, 8, 0.19, 1.63, 2.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.a.3', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.a.3', 'LV', 2.25, 8, 0.25, 1.76, 2.74, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.b.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.b.1', 'LV', 1.88, 8, 0.30, 1.30, 2.45, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.b.2', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.b.2', 'LV', 2.12, 8, 0.13, 1.88, 2.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.b.3', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.b.3', 'LV', 1.62, 8, 0.26, 1.11, 2.14, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.b.4', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.b.4', 'LV', 0.62, 8, 0.26, 0.11, 1.14, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.c.1', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.c.1', 'LV', 0.75, 8, 0.25, 0.26, 1.24, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.c.2', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.c.2', 'LV', 0.88, 8, 0.23, 0.43, 1.32, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.a.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.a.1', 'LV', 1.25, 8, 0.25, 0.76, 1.74, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.a.3', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.a.3', 'LV', 1.00, 8, 0.27, 0.48, 1.52, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.a.4', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.a.4', 'LV', 2.00, 8, 0.19, 1.63, 2.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.b.1', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.b.1', 'LV', 1.25, 8, 0.16, 0.93, 1.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.c.1', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.c.1', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.c.3', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.c.3', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.c.4', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.3.c.4', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.a.1', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.a.1', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.a.2', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.a.2', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.a.3', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.a.3', 'LV', 2.12, 8, 0.35, 1.44, 2.81, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.a.6', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.a.6', 'LV', 2.12, 8, 0.13, 1.88, 2.37, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.b.1', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.b.1', 'LV', 1.88, 8, 0.30, 1.30, 2.45, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.b.2', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.b.2', 'LV', 1.88, 8, 0.30, 1.30, 2.45, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.b.4', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.b.4', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.b.5', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.4.b.5', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2010-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.a.1', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.a.1', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.a.2', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.a.2', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.a.3', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.a.3', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.a.4', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.a.4', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.b.1', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.b.1', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.b.2', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.b.2', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.b.3', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.b.3', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.b.4', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.b.5', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.b.5', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.b.6', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, '2008-06-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '1.A.1.b.6', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', '2008-06-01', 'Analy