CREATE TABLE occupation_level_metadata (
  onetsoc_code CHARACTER(10) NOT NULL,
  item CHARACTER VARYING(150) NOT NULL,
  response CHARACTER VARYING(75),
  n DECIMAL(4,0),
  percent DECIMAL(4,1),
  date_updated DATE NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code));

INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Data Collection Mode', 'Paper', 105, 80.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Data Collection Mode', 'Web', 105, 20.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '1-5 Years', 105, 36.2, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '10 Years or More', 105, 41.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '6-9 Years', 105, 17.1, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '<1 Year', 105, 4.8, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'How Long at Current Job', 'Missing', 105, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 105, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 105, 1.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 105, 1.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 105, 12.4, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 105, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 105, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 105, 9.5, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 105, 1.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 105, 48.6, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 105, 22.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 105, 1.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 95.5, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 43.8, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 75.6, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Total Completes for O*NET-SOC', NULL, 105, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Data Collection Mode', 'Paper', 120, 79.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Data Collection Mode', 'Web', 120, 20.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '1-5 Years', 120, 25.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '10 Years or More', 120, 57.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '6-9 Years', 120, 12.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '<1 Year', 120, 3.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'How Long at Current Job', 'Missing', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 120, 5.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 120, 33.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 120, 4.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 120, 16.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 120, 6.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 120, 10.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 120, 15.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 120, 3.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 120, 4.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Accommodation and food services', 120, 1.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 120, 2.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 120, 1.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Construction', 120, 33.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Education services', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Finance and insurance', 120, 4.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Health care and social assistance', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Information', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Manufacturing', 120, 20.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Mining', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Other services, except public administration', 120, 3.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 120, 9.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Public administration', 120, 6.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Real estate and rental and leasing', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Retail trade', 120, 9.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Transportation and warehousing', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Unclassified', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Utilities', 120, 2.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Wholesale trade', 120, 4.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 90.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 76.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 64.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Total Completes for O*NET-SOC', NULL, 120, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Data Collection Mode', 'Paper', 62, 72.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Data Collection Mode', 'Web', 62, 27.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '1-5 Years', 62, 40.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '10 Years or More', 62, 25.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '6-9 Years', 62, 17.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '<1 Year', 62, 16.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'How Long at Current Job', 'Missing', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 62, 14.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 62, 48.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 62, 37.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Accommodation and food services', 62, 11.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 62, 4.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 62, 4.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Construction', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Education services', 62, 4.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Finance and insurance', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Health care and social assistance', 62, 1.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Information', 62, 51.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Management of Companies and Enterprises', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Manufacturing', 62, 6.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Mining', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Other services, except public administration', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 62, 12.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Public administration', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Real estate and rental and leasing', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Retail trade', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Transportation and warehousing', 62, 1.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Unclassified', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Utilities', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Wholesale trade', 62, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 81.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 75.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 59.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Total Completes for O*NET-SOC', NULL, 62, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Data Collection Mode', 'Paper', 25, 60.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Data Collection Mode', 'Web', 25, 40.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '1-5 Years', 25, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '10 Years or More', 25, 80.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '6-9 Years', 25, 20.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '<1 Year', 25, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'How Long at Current Job', 'Missing', 25, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 75.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Total Completes for O*NET-SOC', NULL, 25, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Data Collection Mode', 'Paper', 21, 90.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Data Collection Mode', 'Web', 21, 9.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Long at Current Job', '1-5 Years', 21, 19.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Long at Current Job', '10 Years or More', 21, 61.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Long at Current Job', '6-9 Years', 21, 19.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Long at Current Job', '<1 Year', 21, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Long at Current Job', 'Missing', 21, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 62.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 79.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Total Completes for O*NET-SOC', NULL, 21, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Data Collection Mode', 'Paper', 103, 68.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Data Collection Mode', 'Web', 103, 32.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'How Long at Current Job', '1-5 Years', 103, 38.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'How Long at Current Job', '10 Years or More', 103, 26.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'How Long at Current Job', '6-9 Years', 103, 23.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'How Long at Current Job', '<1 Year', 103, 11.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'How Long at Current Job', 'Missing', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 103, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 103, 12.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 103, 84.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 103, 1.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Accommodation and food services', 103, 2.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 103, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 103, 2.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Construction', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Education services', 103, 32.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Finance and insurance', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Health care and social assistance', 103, 13.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Information', 103, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Management of Companies and Enterprises', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Manufacturing', 103, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Mining', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Other services, except public administration', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 103, 32.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Public administration', 103, 12.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Real estate and rental and leasing', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Retail trade', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Transportation and warehousing', 103, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Unclassified', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Utilities', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Wholesale trade', 103, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 92.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 70.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 62.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Total Completes for O*NET-SOC', NULL, 103, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Data Collection Mode', 'Paper', 116, 82.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Data Collection Mode', 'Web', 116, 17.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'How Long at Current Job', '1-5 Years', 116, 27.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'How Long at Current Job', '10 Years or More', 116, 43.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'How Long at Current Job', '6-9 Years', 116, 21.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'How Long at Current Job', '<1 Year', 116, 6.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'How Long at Current Job', 'Missing', 116, 1.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 116, 3.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 116, 2.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 116, 5.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 116, 6.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 116, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 116, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 116, 14.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 116, 6.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 116, 56.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 116, 4.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 116, 0.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Accommodation and food services', 116, 1.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 116, 1.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 116, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 116, 1.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Construction', 116, 2.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Education services', 116, 30.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Finance and insurance', 116, 5.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Health care and social assistance', 116, 17.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Information', 116, 4.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Management of Companies and Enterprises', 116, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Manufacturing', 116, 5.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Mining', 116, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Other services, except public administration', 116, 0.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 116, 4.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Public administration', 116, 14.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Real estate and rental and leasing', 116, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Retail trade', 116, 5.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Transportation and warehousing', 116, 3.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Unclassified', 116, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Utilities', 116, 0.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Wholesale trade', 116, 0.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 89.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 82.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 66.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Total Completes for O*NET-SOC', NULL, 116, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Data Collection Mode', 'Paper', 120, 38.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Data Collection Mode', 'Web', 120, 61.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '1-5 Years', 120, 41.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '10 Years or More', 120, 25.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '6-9 Years', 120, 22.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '<1 Year', 120, 9.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'How Long at Current Job', 'Missing', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 120, 3.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 120, 14.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 120, 25.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 120, 50.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 120, 4.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Accommodation and food services', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 120, 1.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Construction', 120, 1.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Education services', 120, 21.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Finance and insurance', 120, 2.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Health care and social assistance', 120, 15.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Information', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Manufacturing', 120, 14.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Mining', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Other services, except public administration', 120, 4.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 120, 6.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Public administration', 120, 25.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Real estate and rental and leasing', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Retail trade', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Transportation and warehousing', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Unclassified', 120, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Utilities', 120, 3.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Wholesale trade', 120, 0.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 67.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 59.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Total Completes for O*NET-SOC', NULL, 120, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Data Collection Mode', 'Paper', 173, 65.3, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Data Collection Mode', 'Web', 173, 34.7, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Long at Current Job', '1-5 Years', 173, 31.8, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Long at Current Job', '10 Years or More', 173, 42.8, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Long at Current Job', '6-9 Years', 173, 17.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Long at Current Job', '<1 Year', 173, 7.5, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Long at Current Job', 'Missing', 173, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 173, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 173, 0.6, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 173, 0.6, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 173, 15.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 173, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 173, 39.3, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 173, 9.8, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 173, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 173, 19.1, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 173, 13.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 173, 1.7, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 88.3, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 62.8, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 73.6, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Total Completes for O*NET-SOC', NULL, 173, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Data Collection Mode', 'Paper', 65, 84.6, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Data Collection Mode', 'Web', 65, 15.4, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'How Long at Current Job', '1-5 Years', 65, 41.5, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'How Long at Current Job', '10 Years or More', 65, 30.8, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'How Long at Current Job', '6-9 Years', 65, 20.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'How Long at Current Job', '<1 Year', 65, 7.7, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'How Long at Current Job', 'Missing', 65, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 65, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 65, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 65, 100.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 65, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 65, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 65, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 65, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 65, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 65, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 65, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 65, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 89.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 83.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 75.6, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Total Completes for O*NET-SOC', NULL, 65, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Data Collection Mode', 'Paper', 128, 75.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Data Collection Mode', 'Web', 128, 24.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '1-5 Years', 128, 28.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '10 Years or More', 128, 40.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '6-9 Years', 128, 20.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '<1 Year', 128, 7.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'How Long at Current Job', 'Missing', 128, 2.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 128, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Accommodation and food services', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Construction', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Education services', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Finance and insurance', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Health care and social assistance', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Information', 128, 4.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Management of Companies and Enterprises', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Manufacturing', 128, 95.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Mining', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Other services, except public administration', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Public administration', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Real estate and rental and leasing', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Retail trade', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Transportation and warehousing', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Unclassified', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Utilities', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Wholesale trade', 128, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 90.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 75.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 60.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Total Completes for O*NET-SOC', NULL, 128, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Data Collection Mode', 'Paper', 52, 50.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Data Collection Mode', 'Web', 52, 50.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '1-5 Years', 52, 30.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '10 Years or More', 52, 40.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '6-9 Years', 52, 23.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '<1 Year', 52, 3.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'How Long at Current Job', 'Missing', 52, 1.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 52, 9.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 52, 25.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 52, 65.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Accommodation and food services', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Construction', 52, 9.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Education services', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Finance and insurance', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Health care and social assistance', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Information', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Management of Companies and Enterprises', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Manufacturing', 52, 25.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Mining', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Other services, except public administration', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Public administration', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Real estate and rental and leasing', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Retail trade', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Transportation and warehousing', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Unclassified', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Utilities', 52, 65.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Wholesale trade', 52, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 94.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 69.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 94.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Total Completes for O*NET-SOC', NULL, 52, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Data Collection Mode', 'Paper', 24, 66.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Data Collection Mode', 'Web', 24, 33.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Long at Current Job', '1-5 Years', 24, 4.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Long at Current Job', '10 Years or More', 24, 87.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Long at Current Job', '6-9 Years', 24, 8.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Long at Current Job', '<1 Year', 24, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Long at Current Job', 'Missing', 24, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 66.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Total Completes for O*NET-SOC', NULL, 24, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Data Collection Mode', 'Paper', 23, 52.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Data Collection Mode', 'Web', 23, 47.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'How Long at Current Job', '1-5 Years', 23, 4.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'How Long at Current Job', '10 Years or More', 23, 87.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'How Long at Current Job', '6-9 Years', 23, 8.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'How Long at Current Job', '<1 Year', 23, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'How Long at Current Job', 'Missing', 23, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 53.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 85.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Total Completes for O*NET-SOC', NULL, 23, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Data Collection Mode', 'Paper', 24, 70.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Data Collection Mode', 'Web', 24, 29.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'How Long at Current Job', '1-5 Years', 24, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'How Long at Current Job', '10 Years or More', 24, 91.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'How Long at Current Job', '6-9 Years', 24, 8.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'How Long at Current Job', '<1 Year', 24, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'How Long at Current Job', 'Missing', 24, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 75.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Total Completes for O*NET-SOC', NULL, 24, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Data Collection Mode', 'Paper', 23, 39.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Data Collection Mode', 'Web', 23, 60.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'How Long at Current Job', '1-5 Years', 23, 4.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'How Long at Current Job', '10 Years or More', 23, 87.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'How Long at Current Job', '6-9 Years', 23, 8.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'How Long at Current Job', '<1 Year', 23, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'How Long at Current Job', 'Missing', 23, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 82.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Total Completes for O*NET-SOC', NULL, 23, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Data Collection Mode', 'Paper', 21, 61.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Data Collection Mode', 'Web', 21, 38.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Long at Current Job', '1-5 Years', 21, 4.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Long at Current Job', '10 Years or More', 21, 81.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Long at Current Job', '6-9 Years', 21, 14.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Long at Current Job', '<1 Year', 21, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Long at Current Job', 'Missing', 21, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 61.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 75.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Total Completes for O*NET-SOC', NULL, 21, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Data Collection Mode', 'Paper', 22, 72.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Data Collection Mode', 'Web', 22, 27.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Long at Current Job', '1-5 Years', 22, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Long at Current Job', '10 Years or More', 22, 86.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Long at Current Job', '6-9 Years', 22, 13.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Long at Current Job', '<1 Year', 22, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Long at Current Job', 'Missing', 22, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 73.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 88.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Total Completes for O*NET-SOC', NULL, 22, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Data Collection Mode', 'Paper', 24, 91.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Data Collection Mode', 'Web', 24, 8.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Long at Current Job', '1-5 Years', 24, 8.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Long at Current Job', '10 Years or More', 24, 75.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Long at Current Job', '6-9 Years', 24, 16.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Long at Current Job', '<1 Year', 24, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Long at Current Job', 'Missing', 24, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 77.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Total Completes for O*NET-SOC', NULL, 24, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Data Collection Mode', 'Paper', 92, 85.9, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Data Collection Mode', 'Web', 92, 14.1, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'How Long at Current Job', '1-5 Years', 92, 23.9, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'How Long at Current Job', '10 Years or More', 92, 58.7, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'How Long at Current Job', '6-9 Years', 92, 13.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'How Long at Current Job', '<1 Year', 92, 4.3, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'How Long at Current Job', 'Missing', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 92, 83.7, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 92, 8.7, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 92, 2.2, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 92, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 92, 5.4, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 90.2, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 66.2, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 69.1, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Total Completes for O*NET-SOC', NULL, 92, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Data Collection Mode', 'Paper', 31, 100.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Data Collection Mode', 'Web', 31, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'How Long at Current Job', '1-5 Years', 31, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'How Long at Current Job', '10 Years or More', 31, 71.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'How Long at Current Job', '6-9 Years', 31, 29.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'How Long at Current Job', '<1 Year', 31, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'How Long at Current Job', 'Missing', 31, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.2, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 81.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'O*NET-SOC Employee Response Rate', NULL, NULL, 87.2, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Total Completes for O*NET-SOC', NULL, 31, NULL, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Data Collection Mode', 'Paper', 32, 65.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Data Collection Mode', 'Web', 32, 34.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Long at Current Job', '1-5 Years', 32, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Long at Current Job', '10 Years or More', 32, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Long at Current Job', '6-9 Years', 32, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Long at Current Job', '<1 Year', 32, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Long at Current Job', 'Missing', 32, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 86.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 91.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Total Completes for O*NET-SOC', NULL, 32, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Data Collection Mode', 'Paper', 67, 89.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Data Collection Mode', 'Web', 67, 10.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '1-5 Years', 67, 32.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '10 Years or More', 67, 40.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '6-9 Years', 67, 20.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '<1 Year', 67, 6.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'How Long at Current Job', 'Missing', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 67, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Accommodation and food services', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Construction', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Education services', 67, 25.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Finance and insurance', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Health care and social assistance', 67, 71.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Information', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Management of Companies and Enterprises', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Manufacturing', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Mining', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Other services, except public administration', 67, 3.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Public administration', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Real estate and rental and leasing', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Retail trade', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Transportation and warehousing', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Unclassified', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Utilities', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Wholesale trade', 67, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 81.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 80.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 67.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Total Completes for O*NET-SOC', NULL, 67, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Data Collection Mode', 'Paper', 93, 69.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Data Collection Mode', 'Web', 93, 30.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '1-5 Years', 93, 46.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '10 Years or More', 93, 25.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '6-9 Years', 93, 19.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '<1 Year', 93, 8.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'How Long at Current Job', 'Missing', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 93, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Accommodation and food services', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Construction', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Education services', 93, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Finance and insurance', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Health care and social assistance', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Information', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Management of Companies and Enterprises', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Manufacturing', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Mining', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Other services, except public administration', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Public administration', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Real estate and rental and leasing', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Retail trade', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Transportation and warehousing', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Unclassified', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Utilities', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Wholesale trade', 93, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 82.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 70.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Total Completes for O*NET-SOC', NULL, 93, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Data Collection Mode', 'Paper', 102, 69.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Data Collection Mode', 'Web', 102, 30.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '1-5 Years', 102, 40.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '10 Years or More', 102, 29.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '6-9 Years', 102, 22.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '<1 Year', 102, 7.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'How Long at Current Job', 'Missing', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 102, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Accommodation and food services', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Construction', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Education services', 102, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Finance and insurance', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Health care and social assistance', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Information', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Management of Companies and Enterprises', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Manufacturing', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Mining', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Other services, except public administration', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Public administration', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Real estate and rental and leasing', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Retail trade', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Transportation and warehousing', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Unclassified', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Utilities', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Wholesale trade', 102, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 70.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 72.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Total Completes for O*NET-SOC', NULL, 102, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Data Collection Mode', 'Paper', 180, 67.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Data Collection Mode', 'Web', 180, 32.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '1-5 Years', 180, 35.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '10 Years or More', 180, 37.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '6-9 Years', 180, 22.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '<1 Year', 180, 5.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'How Long at Current Job', 'Missing', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 180, 55.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 180, 22.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 180, 22.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Accommodation and food services', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Construction', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Education services', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Finance and insurance', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Health care and social assistance', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Information', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Management of Companies and Enterprises', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Manufacturing', 180, 55.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Mining', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Other services, except public administration', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 180, 22.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Public administration', 180, 22.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Real estate and rental and leasing', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Retail trade', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Transportation and warehousing', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Unclassified', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Utilities', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Wholesale trade', 180, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 78.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 62.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Total Completes for O*NET-SOC', NULL, 180, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Data Collection Mode', 'Paper', 69, 89.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Data Collection Mode', 'Web', 69, 10.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '1-5 Years', 69, 31.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '10 Years or More', 69, 49.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '6-9 Years', 69, 13.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '<1 Year', 69, 5.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'How Long at Current Job', 'Missing', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 69, 20.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 69, 62.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 69, 17.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Accommodation and food services', 69, 59.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Construction', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Education services', 69, 4.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Finance and insurance', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Health care and social assistance', 69, 10.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Information', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Management of Companies and Enterprises', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Manufacturing', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Mining', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Other services, except public administration', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Public administration', 69, 20.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Real estate and rental and leasing', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Retail trade', 69, 5.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Transportation and warehousing', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Unclassified', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Utilities', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Wholesale trade', 69, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 84.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 62.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 61.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Total Completes for O*NET-SOC', NULL, 69, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Data Collection Mode', 'Paper', 124, 75.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Data Collection Mode', 'Web', 124, 24.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '1-5 Years', 124, 35.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '10 Years or More', 124, 32.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '6-9 Years', 124, 24.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '<1 Year', 124, 6.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'How Long at Current Job', 'Missing', 124, 1.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 124, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 124, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 124, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 124, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 124, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 124, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 124, 8.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 124, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 124, 91.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 124, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 124, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 87.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 65.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 64.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Total Completes for O*NET-SOC', NULL, 124, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Data Collection Mode', 'Paper', 61, 60.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Data Collection Mode', 'Web', 61, 39.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '1-5 Years', 61, 32.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '10 Years or More', 61, 21.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '6-9 Years', 61, 16.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '<1 Year', 61, 26.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'How Long at Current Job', 'Missing', 61, 3.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 61, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Accommodation and food services', 61, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Construction', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Education services', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Finance and insurance', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Health care and social assistance', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Information', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Management of Companies and Enterprises', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Manufacturing', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Mining', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Other services, except public administration', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Public administration', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Real estate and rental and leasing', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Retail trade', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Transportation and warehousing', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Unclassified', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Utilities', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Wholesale trade', 61, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 62.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 54.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Total Completes for O*NET-SOC', NULL, 61, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Data Collection Mode', 'Paper', 29, 86.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Data Collection Mode', 'Web', 29, 13.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Long at Current Job', '1-5 Years', 29, 3.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Long at Current Job', '10 Years or More', 29, 89.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Long at Current Job', '6-9 Years', 29, 6.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Long at Current Job', '<1 Year', 29, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Long at Current Job', 'Missing', 29, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 83.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 93.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Total Completes for O*NET-SOC', NULL, 29, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Data Collection Mode', 'Paper', 95, 83.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Data Collection Mode', 'Web', 95, 16.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '1-5 Years', 95, 31.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '10 Years or More', 95, 44.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '6-9 Years', 95, 20.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '<1 Year', 95, 4.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'How Long at Current Job', 'Missing', 95, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 95, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 95, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 95, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 95, 10.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 95, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 95, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 95, 74.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 95, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 95, 14.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 95, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 95, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 92.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 71.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 74.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Total Completes for O*NET-SOC', NULL, 95, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Data Collection Mode', 'Paper', 74, 70.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Data Collection Mode', 'Web', 74, 29.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '1-5 Years', 74, 52.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '10 Years or More', 74, 17.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '6-9 Years', 74, 21.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '<1 Year', 74, 8.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'How Long at Current Job', 'Missing', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 74, 9.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 74, 90.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Accommodation and food services', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Construction', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Education services', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Finance and insurance', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Health care and social assistance', 74, 35.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Information', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Management of Companies and Enterprises', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Manufacturing', 74, 9.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Mining', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Other services, except public administration', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 74, 55.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Public administration', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Real estate and rental and leasing', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Retail trade', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Transportation and warehousing', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Unclassified', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Utilities', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Wholesale trade', 74, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 66.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 75.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Total Completes for O*NET-SOC', NULL, 74, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Data Collection Mode', 'Paper', 104, 87.5, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Data Collection Mode', 'Web', 104, 12.5, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '1-5 Years', 104, 29.8, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '10 Years or More', 104, 42.3, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '6-9 Years', 104, 25.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '<1 Year', 104, 1.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'How Long at Current Job', 'Missing', 104, 1.9, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 104, 100.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 104, 0.0, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 88.9, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 67.2, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 97.6, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Total Completes for O*NET-SOC', NULL, 104, NULL, '2005-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Data Collection Mode', 'Paper', 76, 89.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Data Collection Mode', 'Web', 76, 10.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Long at Current Job', '1-5 Years', 76, 35.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Long at Current Job', '10 Years or More', 76, 32.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Long at Current Job', '6-9 Years', 76, 25.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Long at Current Job', '<1 Year', 76, 6.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Long at Current Job', 'Missing', 76, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 76, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 76, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 76, 98.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 76, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 76, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 76, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 76, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 76, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 76, 1.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 76, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 76, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 87.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 69.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 62.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Total Completes for O*NET-SOC', NULL, 76, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Data Collection Mode', 'Paper', 73, 78.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Data Collection Mode', 'Web', 73, 21.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '1-5 Years', 73, 37.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '10 Years or More', 73, 32.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '6-9 Years', 73, 13.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '<1 Year', 73, 15.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'How Long at Current Job', 'Missing', 73, 1.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 73, 17.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 73, 82.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Accommodation and food services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Construction', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Education services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Finance and insurance', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Health care and social assistance', 73, 71.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Information', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Management of Companies and Enterprises', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Manufacturing', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Mining', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Other services, except public administration', 73, 11.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Public administration', 73, 17.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Real estate and rental and leasing', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Retail trade', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Transportation and warehousing', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Unclassified', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Utilities', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Wholesale trade', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 88.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 72.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 77.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Total Completes for O*NET-SOC', NULL, 73, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Data Collection Mode', 'Paper', 27, 44.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Data Collection Mode', 'Web', 27, 55.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Long at Current Job', '1-5 Years', 27, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Long at Current Job', '10 Years or More', 27, 81.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Long at Current Job', '6-9 Years', 27, 18.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Long at Current Job', '<1 Year', 27, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Long at Current Job', 'Missing', 27, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Construction', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Education services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Information', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Mining', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 87.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 96.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Total Completes for O*NET-SOC', NULL, 27, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Data Collection Mode', 'Paper', 33, 63.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Data Collection Mode', 'Web', 33, 36.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Long at Current Job', '1-5 Years', 33, 6.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Long at Current Job', '10 Years or More', 33, 72.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Long at Current Job', '6-9 Years', 33, 21.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Long at Current Job', '<1 Year', 33, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Long at Current Job', 'Missing', 33, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 97.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 94.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 97.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Total Completes for O*NET-SOC', NULL, 33, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Data Collection Mode', 'Paper', 27, 40.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Data Collection Mode', 'Web', 27, 59.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'How Long at Current Job', '1-5 Years', 27, 3.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'How Long at Current Job', '10 Years or More', 27, 88.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'How Long at Current Job', '6-9 Years', 27, 7.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'How Long at Current Job', '<1 Year', 27, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'How Long at Current Job', 'Missing', 27, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Construction', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Education services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Information', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Mining', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Retail trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Unclassified', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Utilities', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 76.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'O*NET-SOC Employee Response Rate', NULL, NULL, 90.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Total Completes for O*NET-SOC', NULL, 27, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Data Collection Mode', 'Paper', 136, 80.9, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Data Collection Mode', 'Web', 136, 19.1, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '1-5 Years', 136, 26.5, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '10 Years or More', 136, 48.5, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '6-9 Years', 136, 15.4, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '<1 Year', 136, 7.4, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'How Long at Current Job', 'Missing', 136, 2.2, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 136, 100.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 136, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.3, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 54.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 70.4, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Total Completes for O*NET-SOC', NULL, 136, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Data Collection Mode', 'Paper', 121, 86.8, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Data Collection Mode', 'Web', 121, 13.2, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '1-5 Years', 121, 19.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '10 Years or More', 121, 60.3, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '6-9 Years', 121, 15.7, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '<1 Year', 121, 3.3, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'How Long at Current Job', 'Missing', 121, 1.6, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 121, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 121, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 121, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 121, 18.2, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 121, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 121, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 121, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 121, 0.8, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 121, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 121, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 121, 81.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 83.4, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 69.7, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 87.3, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Total Completes for O*NET-SOC', NULL, 121, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Data Collection Mode', 'Paper', 73, 87.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Data Collection Mode', 'Web', 73, 12.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '1-5 Years', 73, 31.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '10 Years or More', 73, 41.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '6-9 Years', 73, 12.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '<1 Year', 73, 15.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'How Long at Current Job', 'Missing', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 73, 41.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 73, 58.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Accommodation and food services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Construction', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Education services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Finance and insurance', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Health care and social assistance', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Information', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Management of Companies and Enterprises', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Manufacturing', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Mining', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Other services, except public administration', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Public administration', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Real estate and rental and leasing', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Retail trade', 73, 38.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Transportation and warehousing', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Unclassified', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Utilities', 73, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Wholesale trade', 73, 61.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 81.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 60.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Total Completes for O*NET-SOC', NULL, 73, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Data Collection Mode', 'Paper', 21, 57.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Data Collection Mode', 'Web', 21, 42.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Long at Current Job', '1-5 Years', 21, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Long at Current Job', '10 Years or More', 21, 61.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Long at Current Job', '6-9 Years', 21, 28.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Long at Current Job', '<1 Year', 21, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Long at Current Job', 'Missing', 21, 9.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 95.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 61.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 91.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Total Completes for O*NET-SOC', NULL, 21, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Data Collection Mode', 'Paper', 64, 81.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Data Collection Mode', 'Web', 64, 18.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'How Long at Current Job', '1-5 Years', 64, 39.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'How Long at Current Job', '10 Years or More', 64, 35.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'How Long at Current Job', '6-9 Years', 64, 20.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'How Long at Current Job', '<1 Year', 64, 4.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'How Long at Current Job', 'Missing', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 64, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Accommodation and food services', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Construction', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Education services', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Finance and insurance', 64, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Health care and social assistance', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Information', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Management of Companies and Enterprises', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Manufacturing', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Mining', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Other services, except public administration', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Public administration', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Real estate and rental and leasing', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Retail trade', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Transportation and warehousing', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Unclassified', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Utilities', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Wholesale trade', 64, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 95.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 78.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 52.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Total Completes for O*NET-SOC', NULL, 64, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Data Collection Mode', 'Paper', 99, 75.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Data Collection Mode', 'Web', 99, 24.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'How Long at Current Job', '1-5 Years', 99, 19.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'How Long at Current Job', '10 Years or More', 99, 56.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'How Long at Current Job', '6-9 Years', 99, 20.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'How Long at Current Job', '<1 Year', 99, 4.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'How Long at Current Job', 'Missing', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 99, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Accommodation and food services', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Construction', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Education services', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Finance and insurance', 99, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Health care and social assistance', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Information', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Management of Companies and Enterprises', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Manufacturing', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Mining', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Other services, except public administration', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Public administration', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Real estate and rental and leasing', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Retail trade', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Transportation and warehousing', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Unclassified', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Utilities', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Wholesale trade', 99, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 94.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 71.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 46.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Total Completes for O*NET-SOC', NULL, 99, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Data Collection Mode', 'Paper', 114, 92.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Data Collection Mode', 'Web', 114, 7.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '1-5 Years', 114, 31.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '10 Years or More', 114, 43.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '6-9 Years', 114, 18.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '<1 Year', 114, 7.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'How Long at Current Job', 'Missing', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 114, 99.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 114, 0.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 114, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 97.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 70.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 60.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Total Completes for O*NET-SOC', NULL, 114, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Data Collection Mode', 'Paper', 57, 100.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Data Collection Mode', 'Web', 57, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Long at Current Job', '1-5 Years', 57, 3.5, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Long at Current Job', '10 Years or More', 57, 80.7, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Long at Current Job', '6-9 Years', 57, 15.8, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Long at Current Job', '<1 Year', 57, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Long at Current Job', 'Missing', 57, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.6, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 92.2, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 95.2, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Total Completes for O*NET-SOC', NULL, 57, NULL, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Data Collection Mode', 'Paper', 144, 91.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Data Collection Mode', 'Web', 144, 9.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'How Long at Current Job', '1-5 Years', 144, 29.9, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'How Long at Current Job', '10 Years or More', 144, 47.2, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'How Long at Current Job', '6-9 Years', 144, 19.4, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'How Long at Current Job', '<1 Year', 144, 2.8, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'How Long at Current Job', 'Missing', 144, 0.7, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 144, 100.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 144, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 92.9, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 68.9, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 90.6, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Total Completes for O*NET-SOC', NULL, 144, NULL, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Data Collection Mode', 'Paper', 91, 78.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Data Collection Mode', 'Web', 91, 22.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '1-5 Years', 91, 36.3, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '10 Years or More', 91, 42.8, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '6-9 Years', 91, 15.4, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '<1 Year', 91, 2.2, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'How Long at Current Job', 'Missing', 91, 3.3, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 91, 81.3, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 91, 18.7, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 91, 0.0, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.8, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'O*NET-SOC Employee Response Rate', NULL, NULL, 53.6, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 86.9, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Total Completes for O*NET-SOC', NULL, 91, NULL, '2006-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Data Collection Mode', 'Paper', 75, 84.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Data Collection Mode', 'Web', 75, 16.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '1-5 Years', 75, 26.7, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '10 Years or More', 75, 34.7, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '6-9 Years', 75, 29.3, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '<1 Year', 75, 9.3, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'How Long at Current Job', 'Missing', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 75, 100.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 75, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 88.2, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'O*NET-SOC Employee Response Rate', NULL, NULL, 66.9, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 96.8, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Total Completes for O*NET-SOC', NULL, 75, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Data Collection Mode', 'Paper', 20, 100.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Data Collection Mode', 'Web', 20, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Long at Current Job', '1-5 Years', 20, 5.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Long at Current Job', '10 Years or More', 20, 60.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Long at Current Job', '6-9 Years', 20, 25.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Long at Current Job', '<1 Year', 20, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Long at Current Job', 'Missing', 20, 10.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 76.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 68.4, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'O*NET-SOC Employee Response Rate', NULL, NULL, 100.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Total Completes for O*NET-SOC', NULL, 20, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Data Collection Mode', 'Paper', 33, 60.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Data Collection Mode', 'Web', 33, 39.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Long at Current Job', '1-5 Years', 33, 6.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Long at Current Job', '10 Years or More', 33, 27.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Long at Current Job', '6-9 Years', 33, 63.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Long at Current Job', '<1 Year', 33, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Long at Current Job', 'Missing', 33, 3.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 97.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'O*NET-SOC Employee Response Rate', NULL, NULL, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Total Completes for O*NET-SOC', NULL, 33, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Data Collection Mode', 'Paper', 28, 67.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Data Collection Mode', 'Web', 28, 32.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Long at Current Job', '1-5 Years', 28, 3.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Long at Current Job', '10 Years or More', 28, 82.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Long at Current Job', '6-9 Years', 28, 14.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Long at Current Job', '<1 Year', 28, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Long at Current Job', 'Missing', 28, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 81.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 90.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Total Completes for O*NET-SOC', NULL, 28, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Data Collection Mode', 'Paper', 57, 87.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Data Collection Mode', 'Web', 57, 12.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '1-5 Years', 57, 15.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '10 Years or More', 57, 70.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '6-9 Years', 57, 10.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '<1 Year', 57, 3.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'How Long at Current Job', 'Missing', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 57, 98.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 57, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 57, 1.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 75.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 59.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 73.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Total Completes for O*NET-SOC', NULL, 57, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Data Collection Mode', 'Paper', 82, 69.5, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Data Collection Mode', 'Web', 82, 30.5, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Long at Current Job', '1-5 Years', 82, 35.4, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Long at Current Job', '10 Years or More', 82, 31.7, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Long at Current Job', '6-9 Years', 82, 15.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Long at Current Job', '<1 Year', 82, 11.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Long at Current Job', 'Missing', 82, 6.1, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 82, 17.1, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 82, 65.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 82, 4.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 82, 12.2, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 90.1, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 75.2, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 60.6, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Total Completes for O*NET-SOC', NULL, 82, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Data Collection Mode', 'Paper', 22, 54.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Data Collection Mode', 'Web', 22, 45.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Long at Current Job', '1-5 Years', 22, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Long at Current Job', '10 Years or More', 22, 90.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Long at Current Job', '6-9 Years', 22, 9.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Long at Current Job', '<1 Year', 22, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Long at Current Job', 'Missing', 22, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 80.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Total Completes for O*NET-SOC', NULL, 22, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Data Collection Mode', 'Paper', 26, 50.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Data Collection Mode', 'Web', 26, 50.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Long at Current Job', '1-5 Years', 26, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Long at Current Job', '10 Years or More', 26, 80.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Long at Current Job', '6-9 Years', 26, 15.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Long at Current Job', '<1 Year', 26, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Long at Current Job', 'Missing', 26, 3.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 89.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 65.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 85.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Total Completes for O*NET-SOC', NULL, 26, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Data Collection Mode', 'Paper', 81, 71.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Data Collection Mode', 'Web', 81, 28.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Long at Current Job', '1-5 Years', 81, 39.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Long at Current Job', '10 Years or More', 81, 33.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Long at Current Job', '6-9 Years', 81, 18.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Long at Current Job', '<1 Year', 81, 7.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Long at Current Job', 'Missing', 81, 1.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 81, 3.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 81, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 81, 16.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 81, 4.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 81, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 81, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 81, 43.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 81, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 81, 29.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 81, 2.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 81, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 81.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 60.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 67.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Total Completes for O*NET-SOC', NULL, 81, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Data Collection Mode', 'Paper', 72, 65.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Data Collection Mode', 'Web', 72, 34.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '1-5 Years', 72, 30.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '10 Years or More', 72, 19.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '6-9 Years', 72, 23.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '<1 Year', 72, 26.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'How Long at Current Job', 'Missing', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 72, 1.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 72, 5.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 72, 1.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 72, 90.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 72, 1.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Accommodation and food services', 72, 56.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 72, 5.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Construction', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Education services', 72, 20.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Finance and insurance', 72, 1.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Health care and social assistance', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Information', 72, 2.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Management of Companies and Enterprises', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Manufacturing', 72, 4.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Mining', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Other services, except public administration', 72, 1.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 72, 6.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Public administration', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Real estate and rental and leasing', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Retail trade', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Transportation and warehousing', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Unclassified', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Utilities', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Wholesale trade', 72, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 62.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 63.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Total Completes for O*NET-SOC', NULL, 72, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Data Collection Mode', 'Paper', 20, 70.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Data Collection Mode', 'Web', 20, 30.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Long at Current Job', '1-5 Years', 20, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Long at Current Job', '10 Years or More', 20, 65.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Long at Current Job', '6-9 Years', 20, 35.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Long at Current Job', '<1 Year', 20, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Long at Current Job', 'Missing', 20, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 60.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 83.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Total Completes for O*NET-SOC', NULL, 20, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Data Collection Mode', 'Paper', 32, 68.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Data Collection Mode', 'Web', 32, 31.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Long at Current Job', '1-5 Years', 32, 3.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Long at Current Job', '10 Years or More', 32, 62.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Long at Current Job', '6-9 Years', 32, 34.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Long at Current Job', '<1 Year', 32, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Long at Current Job', 'Missing', 32, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 97.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 91.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 97.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Total Completes for O*NET-SOC', NULL, 32, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Data Collection Mode', 'Paper', 24, 45.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Data Collection Mode', 'Web', 24, 54.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Long at Current Job', '1-5 Years', 24, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Long at Current Job', '10 Years or More', 24, 79.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Long at Current Job', '6-9 Years', 24, 16.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Long at Current Job', '<1 Year', 24, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Long at Current Job', 'Missing', 24, 4.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 75.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Total Completes for O*NET-SOC', NULL, 24, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Data Collection Mode', 'Paper', 25, 76.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Data Collection Mode', 'Web', 25, 24.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'How Long at Current Job', '1-5 Years', 25, 16.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'How Long at Current Job', '10 Years or More', 25, 56.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'How Long at Current Job', '6-9 Years', 25, 28.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'How Long at Current Job', '<1 Year', 25, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'How Long at Current Job', 'Missing', 25, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 92.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 77.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 93.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Total Completes for O*NET-SOC', NULL, 25, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Data Collection Mode', 'Paper', 28, 57.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Data Collection Mode', 'Web', 28, 42.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'How Long at Current Job', '1-5 Years', 28, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'How Long at Current Job', '10 Years or More', 28, 92.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'How Long at Current Job', '6-9 Years', 28, 3.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'How Long at Current Job', '<1 Year', 28, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'How Long at Current Job', 'Missing', 28, 3.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 87.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 69.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'O*NET-SOC Employee Response Rate', NULL, NULL, 88.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Total Completes for O*NET-SOC', NULL, 28, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Data Collection Mode', 'Paper', 30, 36.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Data Collection Mode', 'Web', 30, 63.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Long at Current Job', '1-5 Years', 30, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Long at Current Job', '10 Years or More', 30, 83.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Long at Current Job', '6-9 Years', 30, 16.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Long at Current Job', '<1 Year', 30, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Long at Current Job', 'Missing', 30, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 90.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'O*NET-SOC Employee Response Rate', NULL, NULL, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Total Completes for O*NET-SOC', NULL, 30, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Data Collection Mode', 'Paper', 192, 73.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Data Collection Mode', 'Web', 192, 26.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'How Long at Current Job', '1-5 Years', 192, 34.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'How Long at Current Job', '10 Years or More', 192, 42.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'How Long at Current Job', '6-9 Years', 192, 15.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'How Long at Current Job', '<1 Year', 192, 7.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'How Long at Current Job', 'Missing', 192, 0.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 192, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 192, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 192, 2.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 192, 25.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 192, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 192, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 192, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 192, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 192, 62.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 192, 5.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 192, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Accommodation and food services', 192, 2.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 192, 2.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 192, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 192, 3.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Construction', 192, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Education services', 192, 9.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Finance and insurance', 192, 2.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Health care and social assistance', 192, 8.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Information', 192, 3.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Management of Companies and Enterprises', 192, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Manufacturing', 192, 22.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Mining', 192, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Other services, except public administration', 192, 0.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 192, 35.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Public administration', 192, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Real estate and rental and leasing', 192, 0.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Retail trade', 192, 0.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Transportation and warehousing', 192, 0.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Unclassified', 192, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Utilities', 192, 3.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Wholesale trade', 192, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 75.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 67.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Total Completes for O*NET-SOC', NULL, 192, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Data Collection Mode', 'Paper', 25, 76.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Data Collection Mode', 'Web', 25, 24.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'How Long at Current Job', '1-5 Years', 25, 8.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'How Long at Current Job', '10 Years or More', 25, 88.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'How Long at Current Job', '6-9 Years', 25, 4.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'How Long at Current Job', '<1 Year', 25, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'How Long at Current Job', 'Missing', 25, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 72.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 78.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Total Completes for O*NET-SOC', NULL, 25, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Data Collection Mode', 'Paper', 79, 72.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Data Collection Mode', 'Web', 79, 27.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'How Long at Current Job', '1-5 Years', 79, 34.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'How Long at Current Job', '10 Years or More', 79, 48.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'How Long at Current Job', '6-9 Years', 79, 13.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'How Long at Current Job', '<1 Year', 79, 2.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'How Long at Current Job', 'Missing', 79, 1.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 79, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Accommodation and food services', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Construction', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Education services', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Finance and insurance', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Health care and social assistance', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Information', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Management of Companies and Enterprises', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Manufacturing', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Mining', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Other services, except public administration', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Public administration', 79, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Real estate and rental and leasing', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Retail trade', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Transportation and warehousing', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Unclassified', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Utilities', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Wholesale trade', 79, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 95.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 76.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 80.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Total Completes for O*NET-SOC', NULL, 79, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Data Collection Mode', 'Paper', 171, 74.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Data Collection Mode', 'Web', 171, 25.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'How Long at Current Job', '1-5 Years', 171, 20.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'How Long at Current Job', '10 Years or More', 171, 59.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'How Long at Current Job', '6-9 Years', 171, 15.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'How Long at Current Job', '<1 Year', 171, 4.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'How Long at Current Job', 'Missing', 171, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 171, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 171, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 171, 100.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 171, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 171, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 171, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 171, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 171, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 171, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 171, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 171, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 92.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 78.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 70.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Total Completes for O*NET-SOC', NULL, 171, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Data Collection Mode', 'Paper', 114, 64.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Data Collection Mode', 'Web', 114, 35.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '1-5 Years', 114, 44.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '10 Years or More', 114, 27.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '6-9 Years', 114, 16.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '<1 Year', 114, 11.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'How Long at Current Job', 'Missing', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 114, 5.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 114, 8.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 114, 63.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 114, 18.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 114, 4.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Accommodation and food services', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Construction', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Education services', 114, 15.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Finance and insurance', 114, 5.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Health care and social assistance', 114, 0.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Information', 114, 2.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Management of Companies and Enterprises', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Manufacturing', 114, 7.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Mining', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Other services, except public administration', 114, 1.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Public administration', 114, 63.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Real estate and rental and leasing', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Retail trade', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Transportation and warehousing', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Unclassified', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Utilities', 114, 2.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Wholesale trade', 114, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 67.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 73.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Total Completes for O*NET-SOC', NULL, 114, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Data Collection Mode', 'Paper', 30, 60.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Data Collection Mode', 'Web', 30, 40.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Long at Current Job', '1-5 Years', 30, 6.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Long at Current Job', '10 Years or More', 30, 73.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Long at Current Job', '6-9 Years', 30, 20.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Long at Current Job', '<1 Year', 30, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Long at Current Job', 'Missing', 30, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 62.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 96.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Total Completes for O*NET-SOC', NULL, 30, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Data Collection Mode', 'Paper', 87, 59.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Data Collection Mode', 'Web', 87, 40.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'How Long at Current Job', '1-5 Years', 87, 57.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'How Long at Current Job', '10 Years or More', 87, 13.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'How Long at Current Job', '6-9 Years', 87, 16.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'How Long at Current Job', '<1 Year', 87, 11.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'How Long at Current Job', 'Missing', 87, 1.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 87, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 87, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 87, 67.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 87, 13.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 87, 2.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 87, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 87, 4.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 87, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 87, 10.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 87, 1.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 87, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 80.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 60.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 50.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Total Completes for O*NET-SOC', NULL, 87, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Data Collection Mode', 'Paper', 93, 68.8, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Data Collection Mode', 'Web', 93, 31.2, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Long at Current Job', '1-5 Years', 93, 19.4, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Long at Current Job', '10 Years or More', 93, 59.1, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Long at Current Job', '6-9 Years', 93, 17.2, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Long at Current Job', '<1 Year', 93, 4.3, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Long at Current Job', 'Missing', 93, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 93, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 93, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 93, 86.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 93, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 93, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 93, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 93, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 93, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 93, 14.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 93, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 93, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 90.3, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 64.8, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 73.5, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Total Completes for O*NET-SOC', NULL, 93, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Data Collection Mode', 'Paper', 26, 65.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Data Collection Mode', 'Web', 26, 34.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Long at Current Job', '1-5 Years', 26, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Long at Current Job', '10 Years or More', 26, 80.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Long at Current Job', '6-9 Years', 26, 19.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Long at Current Job', '<1 Year', 26, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Long at Current Job', 'Missing', 26, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 61.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 90.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Total Completes for O*NET-SOC', NULL, 26, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Data Collection Mode', 'Paper', 106, 75.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Data Collection Mode', 'Web', 106, 24.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Long at Current Job', '1-5 Years', 106, 35.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Long at Current Job', '10 Years or More', 106, 35.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Long at Current Job', '6-9 Years', 106, 18.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Long at Current Job', '<1 Year', 106, 8.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Long at Current Job', 'Missing', 106, 0.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 106, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 106, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 106, 91.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 106, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 106, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 106, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 106, 1.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 106, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 106, 4.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 106, 1.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 106, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 82.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 57.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 57.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Total Completes for O*NET-SOC', NULL, 106, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Data Collection Mode', 'Paper', 64, 75.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Data Collection Mode', 'Web', 64, 25.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'How Long at Current Job', '1-5 Years', 64, 50.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'How Long at Current Job', '10 Years or More', 64, 20.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'How Long at Current Job', '6-9 Years', 64, 7.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'How Long at Current Job', '<1 Year', 64, 20.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'How Long at Current Job', 'Missing', 64, 1.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 64, 34.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 64, 10.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 64, 54.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 94.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 60.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 55.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Total Completes for O*NET-SOC', NULL, 64, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Data Collection Mode', 'Paper', 108, 86.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Data Collection Mode', 'Web', 108, 13.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '1-5 Years', 108, 37.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '10 Years or More', 108, 37.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '6-9 Years', 108, 19.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '<1 Year', 108, 5.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'How Long at Current Job', 'Missing', 108, 0.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 108, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Accommodation and food services', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Construction', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Education services', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Finance and insurance', 108, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Health care and social assistance', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Information', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Management of Companies and Enterprises', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Manufacturing', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Mining', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Other services, except public administration', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Public administration', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Real estate and rental and leasing', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Retail trade', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Transportation and warehousing', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Unclassified', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Utilities', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Wholesale trade', 108, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 95.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 68.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 63.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Total Completes for O*NET-SOC', NULL, 108, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Data Collection Mode', 'Paper', 111, 82.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Data Collection Mode', 'Web', 111, 18.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '1-5 Years', 111, 35.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '10 Years or More', 111, 44.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '6-9 Years', 111, 15.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '<1 Year', 111, 5.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'How Long at Current Job', 'Missing', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 111, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Accommodation and food services', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Construction', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Education services', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Finance and insurance', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Health care and social assistance', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Information', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Management of Companies and Enterprises', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Manufacturing', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Mining', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Other services, except public administration', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Public administration', 111, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Real estate and rental and leasing', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Retail trade', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Transportation and warehousing', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Unclassified', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Utilities', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Wholesale trade', 111, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 85.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 73.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 74.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Total Completes for O*NET-SOC', NULL, 111, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Data Collection Mode', 'Paper', 135, 83.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Data Collection Mode', 'Web', 135, 17.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Long at Current Job', '1-5 Years', 135, 37.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Long at Current Job', '10 Years or More', 135, 40.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Long at Current Job', '6-9 Years', 135, 13.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Long at Current Job', '<1 Year', 135, 8.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Long at Current Job', 'Missing', 135, 0.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 135, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 135, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 135, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 135, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 135, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 135, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 135, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 135, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 135, 100.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 135, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 135, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 78.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 60.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Total Completes for O*NET-SOC', NULL, 135, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Data Collection Mode', 'Paper', 47, 36.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Data Collection Mode', 'Web', 47, 63.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'How Long at Current Job', '1-5 Years', 47, 2.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'How Long at Current Job', '10 Years or More', 47, 66.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'How Long at Current Job', '6-9 Years', 47, 27.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'How Long at Current Job', '<1 Year', 47, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'How Long at Current Job', 'Missing', 47, 4.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 94.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 59.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 89.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Total Completes for O*NET-SOC', NULL, 47, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Data Collection Mode', 'Paper', 32, 56.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Data Collection Mode', 'Web', 32, 43.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Long at Current Job', '1-5 Years', 32, 3.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Long at Current Job', '10 Years or More', 32, 96.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Long at Current Job', '6-9 Years', 32, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Long at Current Job', '<1 Year', 32, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Long at Current Job', 'Missing', 32, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Construction', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Education services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Information', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Mining', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Retail trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Unclassified', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Utilities', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 91.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'O*NET-SOC Employee Response Rate', NULL, NULL, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Total Completes for O*NET-SOC', NULL, 32, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Data Collection Mode', 'Paper', 109, 38.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Data Collection Mode', 'Web', 109, 61.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'How Long at Current Job', '1-5 Years', 109, 44.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'How Long at Current Job', '10 Years or More', 109, 33.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'How Long at Current Job', '6-9 Years', 109, 18.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'How Long at Current Job', '<1 Year', 109, 4.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'How Long at Current Job', 'Missing', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 109, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 109, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 62.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 85.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Total Completes for O*NET-SOC', NULL, 109, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Data Collection Mode', 'Paper', 123, 52.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Data Collection Mode', 'Web', 123, 47.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'How Long at Current Job', '1-5 Years', 123, 28.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'How Long at Current Job', '10 Years or More', 123, 30.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'How Long at Current Job', '6-9 Years', 123, 26.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'How Long at Current Job', '<1 Year', 123, 13.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'How Long at Current Job', 'Missing', 123, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 123, 2.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 123, 4.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 123, 30.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 123, 61.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 123, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Accommodation and food services', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 123, 2.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Construction', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Education services', 123, 12.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Finance and insurance', 123, 2.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Health care and social assistance', 123, 15.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Information', 123, 8.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Management of Companies and Enterprises', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Manufacturing', 123, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Mining', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Other services, except public administration', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 123, 26.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Public administration', 123, 30.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Real estate and rental and leasing', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Retail trade', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Transportation and warehousing', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Unclassified', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Utilities', 123, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Wholesale trade', 123, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 87.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 63.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 70.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Total Completes for O*NET-SOC', NULL, 123, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Data Collection Mode', 'Paper', 23, 65.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Data Collection Mode', 'Web', 23, 34.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'How Long at Current Job', '1-5 Years', 23, 4.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'How Long at Current Job', '10 Years or More', 23, 60.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'How Long at Current Job', '6-9 Years', 23, 34.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'How Long at Current Job', '<1 Year', 23, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'How Long at Current Job', 'Missing', 23, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 92.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 89.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 96.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Total Completes for O*NET-SOC', NULL, 23, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Data Collection Mode', 'Paper', 74, 44.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Data Collection Mode', 'Web', 74, 55.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'How Long at Current Job', '1-5 Years', 74, 37.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'How Long at Current Job', '10 Years or More', 74, 27.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'How Long at Current Job', '6-9 Years', 74, 29.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'How Long at Current Job', '<1 Year', 74, 5.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'How Long at Current Job', 'Missing', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 74, 14.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 74, 14.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 74, 14.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 74, 4.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 74, 50.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 74, 1.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Accommodation and food services', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Construction', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Education services', 74, 33.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Finance and insurance', 74, 14.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Health care and social assistance', 74, 5.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Information', 74, 4.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Management of Companies and Enterprises', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Manufacturing', 74, 12.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Mining', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Other services, except public administration', 74, 2.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 74, 6.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Public administration', 74, 14.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Real estate and rental and leasing', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Retail trade', 74, 4.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Transportation and warehousing', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Unclassified', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Utilities', 74, 1.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Wholesale trade', 74, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 64.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 69.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Total Completes for O*NET-SOC', NULL, 74, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Data Collection Mode', 'Paper', 112, 50.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Data Collection Mode', 'Web', 112, 49.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'How Long at Current Job', '1-5 Years', 112, 32.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'How Long at Current Job', '10 Years or More', 112, 36.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'How Long at Current Job', '6-9 Years', 112, 23.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'How Long at Current Job', '<1 Year', 112, 8.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'How Long at Current Job', 'Missing', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 112, 5.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 112, 10.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 112, 5.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 112, 77.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 112, 0.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Accommodation and food services', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Construction', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Education services', 112, 42.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Finance and insurance', 112, 5.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Health care and social assistance', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Information', 112, 9.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Management of Companies and Enterprises', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Manufacturing', 112, 7.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Mining', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Other services, except public administration', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 112, 30.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Public administration', 112, 5.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Real estate and rental and leasing', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Retail trade', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Transportation and warehousing', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Unclassified', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Utilities', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Wholesale trade', 112, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 68.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 69.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Total Completes for O*NET-SOC', NULL, 112, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Data Collection Mode', 'Paper', 85, 43.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Data Collection Mode', 'Web', 85, 56.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'How Long at Current Job', '1-5 Years', 85, 27.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'How Long at Current Job', '10 Years or More', 85, 36.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'How Long at Current Job', '6-9 Years', 85, 23.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'How Long at Current Job', '<1 Year', 85, 12.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'How Long at Current Job', 'Missing', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 85, 24.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 85, 4.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 85, 70.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Accommodation and food services', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Construction', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Education services', 85, 14.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Finance and insurance', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Health care and social assistance', 85, 1.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Information', 85, 9.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Management of Companies and Enterprises', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Manufacturing', 85, 23.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Mining', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Other services, except public administration', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 85, 47.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Public administration', 85, 4.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Real estate and rental and leasing', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Retail trade', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Transportation and warehousing', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Unclassified', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Utilities', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Wholesale trade', 85, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 87.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 61.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 71.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Total Completes for O*NET-SOC', NULL, 85, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Data Collection Mode', 'Paper', 117, 52.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Data Collection Mode', 'Web', 117, 47.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'How Long at Current Job', '1-5 Years', 117, 28.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'How Long at Current Job', '10 Years or More', 117, 41.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'How Long at Current Job', '6-9 Years', 117, 16.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'How Long at Current Job', '<1 Year', 117, 12.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'How Long at Current Job', 'Missing', 117, 1.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 117, 17.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 117, 4.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 117, 4.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 117, 73.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Accommodation and food services', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Construction', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Education services', 117, 8.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Finance and insurance', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Health care and social assistance', 117, 3.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Information', 117, 6.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Management of Companies and Enterprises', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Manufacturing', 117, 17.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Mining', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Other services, except public administration', 117, 0.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 117, 53.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Public administration', 117, 4.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Real estate and rental and leasing', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Retail trade', 117, 4.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Transportation and warehousing', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Unclassified', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Utilities', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Wholesale trade', 117, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 88.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 68.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 73.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Total Completes for O*NET-SOC', NULL, 117, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Data Collection Mode', 'Paper', 30, 26.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Data Collection Mode', 'Web', 30, 73.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'How Long at Current Job', '1-5 Years', 30, 3.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'How Long at Current Job', '10 Years or More', 30, 30.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'How Long at Current Job', '6-9 Years', 30, 63.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'How Long at Current Job', '<1 Year', 30, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'How Long at Current Job', 'Missing', 30, 3.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 84.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 88.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Total Completes for O*NET-SOC', NULL, 30, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Data Collection Mode', 'Paper', 85, 55.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Data Collection Mode', 'Web', 85, 44.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'How Long at Current Job', '1-5 Years', 85, 32.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'How Long at Current Job', '10 Years or More', 85, 30.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'How Long at Current Job', '6-9 Years', 85, 28.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'How Long at Current Job', '<1 Year', 85, 7.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'How Long at Current Job', 'Missing', 85, 1.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 85, 12.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 85, 25.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 85, 5.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 85, 55.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Accommodation and food services', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 85, 2.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Construction', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Education services', 85, 35.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Finance and insurance', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Health care and social assistance', 85, 4.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Information', 85, 4.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Management of Companies and Enterprises', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Manufacturing', 85, 8.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Mining', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Other services, except public administration', 85, 2.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 85, 10.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Public administration', 85, 25.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Real estate and rental and leasing', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Retail trade', 85, 5.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Transportation and warehousing', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Unclassified', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Utilities', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Wholesale trade', 85, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 83.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 65.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 62.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Total Completes for O*NET-SOC', NULL, 85, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Data Collection Mode', 'Paper', 77, 41.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Data Collection Mode', 'Web', 77, 58.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'How Long at Current Job', '1-5 Years', 77, 48.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'How Long at Current Job', '10 Years or More', 77, 18.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'How Long at Current Job', '6-9 Years', 77, 23.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'How Long at Current Job', '<1 Year', 77, 10.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'How Long at Current Job', 'Missing', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 77, 1.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 77, 15.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 77, 1.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 77, 10.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 77, 1.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 77, 63.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 77, 2.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 77, 3.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Accommodation and food services', 77, 5.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 77, 3.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Construction', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Education services', 77, 27.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Finance and insurance', 77, 1.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Health care and social assistance', 77, 11.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Information', 77, 7.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Management of Companies and Enterprises', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Manufacturing', 77, 13.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Mining', 77, 1.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Other services, except public administration', 77, 3.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 77, 9.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Public administration', 77, 10.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Real estate and rental and leasing', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Retail trade', 77, 1.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Transportation and warehousing', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Unclassified', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Utilities', 77, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Wholesale trade', 77, 3.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 88.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 48.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 60.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Total Completes for O*NET-SOC', NULL, 77, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Data Collection Mode', 'Paper', 141, 42.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Data Collection Mode', 'Web', 141, 57.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'How Long at Current Job', '1-5 Years', 141, 47.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'How Long at Current Job', '10 Years or More', 141, 17.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'How Long at Current Job', '6-9 Years', 141, 22.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'How Long at Current Job', '<1 Year', 141, 9.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'How Long at Current Job', 'Missing', 141, 2.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 141, 5.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 141, 10.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 141, 0.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 141, 11.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 141, 2.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 141, 67.4, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 141, 2.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Accommodation and food services', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 141, 0.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 141, 0.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Construction', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Education services', 141, 44.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Finance and insurance', 141, 5.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Health care and social assistance', 141, 2.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Information', 141, 5.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Management of Companies and Enterprises', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Manufacturing', 141, 9.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Mining', 141, 0.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Other services, except public administration', 141, 3.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 141, 11.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Public administration', 141, 11.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Real estate and rental and leasing', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Retail trade', 141, 2.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Transportation and warehousing', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Unclassified', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Utilities', 141, 2.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Wholesale trade', 141, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 65.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 70.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Total Completes for O*NET-SOC', NULL, 141, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Data Collection Mode', 'Paper', 23, 47.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Data Collection Mode', 'Web', 23, 52.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'How Long at Current Job', '1-5 Years', 23, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'How Long at Current Job', '10 Years or More', 23, 69.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'How Long at Current Job', '6-9 Years', 23, 26.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'How Long at Current Job', '<1 Year', 23, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'How Long at Current Job', 'Missing', 23, 4.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 92.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 75.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.6, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Total Completes for O*NET-SOC', NULL, 23, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Data Collection Mode', 'Paper', 23, 65.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Data Collection Mode', 'Web', 23, 34.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'How Long at Current Job', '1-5 Years', 23, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'How Long at Current Job', '10 Years or More', 23, 78.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'How Long at Current Job', '6-9 Years', 23, 21.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'How Long at Current Job', '<1 Year', 23, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'How Long at Current Job', 'Missing', 23, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 69.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 95.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Total Completes for O*NET-SOC', NULL, 23, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Data Collection Mode', 'Paper', 23, 39.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Data Collection Mode', 'Web', 23, 60.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'How Long at Current Job', '1-5 Years', 23, 4.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'How Long at Current Job', '10 Years or More', 23, 39.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'How Long at Current Job', '6-9 Years', 23, 56.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'How Long at Current Job', '<1 Year', 23, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'How Long at Current Job', 'Missing', 23, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 85.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 81.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'O*NET-SOC Employee Response Rate', NULL, NULL, 90.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Total Completes for O*NET-SOC', NULL, 23, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Data Collection Mode', 'Paper', 28, 46.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Data Collection Mode', 'Web', 28, 53.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'How Long at Current Job', '1-5 Years', 28, 3.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'How Long at Current Job', '10 Years or More', 28, 75.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'How Long at Current Job', '6-9 Years', 28, 17.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'How Long at Current Job', '<1 Year', 28, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'How Long at Current Job', 'Missing', 28, 3.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 85.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'O*NET-SOC Employee Response Rate', NULL, NULL, 96.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Total Completes for O*NET-SOC', NULL, 28, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Data Collection Mode', 'Paper', 56, 58.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Data Collection Mode', 'Web', 56, 41.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'How Long at Current Job', '1-5 Years', 56, 41.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'How Long at Current Job', '10 Years or More', 56, 33.9, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'How Long at Current Job', '6-9 Years', 56, 23.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'How Long at Current Job', '<1 Year', 56, 1.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'How Long at Current Job', 'Missing', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 56, 75.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 56, 25.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Accommodation and food services', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Arts, entertainment, and recreation', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Construction', 56, 3.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Education services', 56, 3.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Finance and insurance', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Health care and social assistance', 56, 1.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Information', 56, 1.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Management of Companies and Enterprises', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Manufacturing', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Mining', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Other services, except public administration', 56, 5.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Professional, Scientific and Technical Services', 56, 17.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Public administration', 56, 57.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Real estate and rental and leasing', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Retail trade', 56, 5.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Transportation and warehousing', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Unclassified', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Utilities', 56, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Wholesale trade', 56, 3.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'O*NET-SOC Employee Response Rate', NULL, NULL, 90.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 88.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Total Completes for O*NET-SOC', NULL, 56, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Data Collection Mode', 'Paper', 33, 54.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Data Collection Mode', 'Web', 33, 45.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Long at Current Job', '1-5 Years', 33, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Long at Current Job', '10 Years or More', 33, 93.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Long at Current Job', '6-9 Years', 33, 6.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Long at Current Job', '<1 Year', 33, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Long at Current Job', 'Missing', 33, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 94.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 97.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Total Completes for O*NET-SOC', NULL, 33, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Data Collection Mode', 'Paper', 27, 100.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Data Collection Mode', 'Web', 27, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Long at Current Job', '1-5 Years', 27, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Long at Current Job', '10 Years or More', 27, 74.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Long at Current Job', '6-9 Years', 27, 25.9, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Long at Current Job', '<1 Year', 27, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Long at Current Job', 'Missing', 27, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 90.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 96.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Total Completes for O*NET-SOC', NULL, 27, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Data Collection Mode', 'Paper', 27, 37.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Data Collection Mode', 'Web', 27, 63.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Long at Current Job', '1-5 Years', 27, 14.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Long at Current Job', '10 Years or More', 27, 70.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Long at Current Job', '6-9 Years', 27, 14.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Long at Current Job', '<1 Year', 27, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Long at Current Job', 'Missing', 27, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 87.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 100.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Total Completes for O*NET-SOC', NULL, 27, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Data Collection Mode', 'Paper', 105, 66.7, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Data Collection Mode', 'Web', 105, 33.3, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Long at Current Job', '1-5 Years', 105, 55.2, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Long at Current Job', '10 Years or More', 105, 24.8, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Long at Current Job', '6-9 Years', 105, 11.4, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Long at Current Job', '<1 Year', 105, 6.7, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Long at Current Job', 'Missing', 105, 1.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 105, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 105, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 105, 10.5, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 105, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 105, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 105, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 105, 19.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 105, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 105, 70.5, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 105, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 105, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.3, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 77.2, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 69.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Total Completes for O*NET-SOC', NULL, 105, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Data Collection Mode', 'Paper', 31, 48.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Data Collection Mode', 'Web', 31, 51.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Long at Current Job', '1-5 Years', 31, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Long at Current Job', '10 Years or More', 31, 87.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Long at Current Job', '6-9 Years', 31, 12.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Long at Current Job', '<1 Year', 31, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Long at Current Job', 'Missing', 31, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Construction', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Education services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Information', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Mining', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 81.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 93.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Total Completes for O*NET-SOC', NULL, 31, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Data Collection Mode', 'Paper', 22, 68.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Data Collection Mode', 'Web', 22, 31.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'How Long at Current Job', '1-5 Years', 22, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'How Long at Current Job', '10 Years or More', 22, 72.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'How Long at Current Job', '6-9 Years', 22, 27.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'How Long at Current Job', '<1 Year', 22, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'How Long at Current Job', 'Missing', 22, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Construction', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Education services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Information', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Mining', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Retail trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Unclassified', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Utilities', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 64.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 95.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Total Completes for O*NET-SOC', NULL, 22, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Data Collection Mode', 'Paper', 65, 78.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Data Collection Mode', 'Web', 65, 21.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Long at Current Job', '1-5 Years', 65, 20.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Long at Current Job', '10 Years or More', 65, 58.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Long at Current Job', '6-9 Years', 65, 21.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Long at Current Job', '<1 Year', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Long at Current Job', 'Missing', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 65, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Accommodation and food services', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Construction', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Education services', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Finance and insurance', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Health care and social assistance', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Information', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Management of Companies and Enterprises', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Manufacturing', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Mining', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Other services, except public administration', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 65, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Public administration', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Real estate and rental and leasing', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Retail trade', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Transportation and warehousing', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Unclassified', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Utilities', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'NAICS Sector', 'Wholesale trade', 65, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 73.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 59.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Total Completes for O*NET-SOC', NULL, 65, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Data Collection Mode', 'Paper', 29, 79.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Data Collection Mode', 'Web', 29, 20.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Long at Current Job', '1-5 Years', 29, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Long at Current Job', '10 Years or More', 29, 89.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Long at Current Job', '6-9 Years', 29, 10.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Long at Current Job', '<1 Year', 29, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Long at Current Job', 'Missing', 29, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 83.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 90.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Total Completes for O*NET-SOC', NULL, 29, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Data Collection Mode', 'Paper', 110, 80.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Data Collection Mode', 'Web', 110, 19.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'How Long at Current Job', '1-5 Years', 110, 20.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'How Long at Current Job', '10 Years or More', 110, 47.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'How Long at Current Job', '6-9 Years', 110, 24.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'How Long at Current Job', '<1 Year', 110, 7.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'How Long at Current Job', 'Missing', 110, 0.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 110, 18.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 110, 80.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 110, 0.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Accommodation and food services', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Construction', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Education services', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Finance and insurance', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Health care and social assistance', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Information', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Manufacturing', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Mining', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Other services, except public administration', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 110, 80.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Public administration', 110, 18.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Real estate and rental and leasing', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Retail trade', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Transportation and warehousing', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Unclassified', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Utilities', 110, 0.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Wholesale trade', 110, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 81.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 78.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Total Completes for O*NET-SOC', NULL, 110, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Data Collection Mode', 'Paper', 33, 78.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Data Collection Mode', 'Web', 33, 21.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Long at Current Job', '1-5 Years', 33, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Long at Current Job', '10 Years or More', 33, 97.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Long at Current Job', '6-9 Years', 33, 3.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Long at Current Job', '<1 Year', 33, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Long at Current Job', 'Missing', 33, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 97.1, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 85.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 91.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Total Completes for O*NET-SOC', NULL, 33, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Data Collection Mode', 'Paper', 24, 62.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Data Collection Mode', 'Web', 24, 37.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Long at Current Job', '1-5 Years', 24, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Long at Current Job', '10 Years or More', 24, 87.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Long at Current Job', '6-9 Years', 24, 8.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Long at Current Job', '<1 Year', 24, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Long at Current Job', 'Missing', 24, 4.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Construction', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Education services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Information', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Mining', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 70.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Total Completes for O*NET-SOC', NULL, 24, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Data Collection Mode', 'Paper', 100, 57.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Data Collection Mode', 'Web', 100, 43.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'How Long at Current Job', '1-5 Years', 100, 32.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'How Long at Current Job', '10 Years or More', 100, 34.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'How Long at Current Job', '6-9 Years', 100, 21.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'How Long at Current Job', '<1 Year', 100, 12.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'How Long at Current Job', 'Missing', 100, 1.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 100, 76.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 100, 13.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 100, 11.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Accommodation and food services', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Construction', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Education services', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Finance and insurance', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Health care and social assistance', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Information', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Management of Companies and Enterprises', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Manufacturing', 100, 76.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Mining', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Other services, except public administration', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 100, 11.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Public administration', 100, 13.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Real estate and rental and leasing', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Retail trade', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Transportation and warehousing', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Unclassified', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Utilities', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Wholesale trade', 100, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 88.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 69.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 76.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Total Completes for O*NET-SOC', NULL, 100, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Data Collection Mode', 'Paper', 24, 83.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Data Collection Mode', 'Web', 24, 16.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Long at Current Job', '1-5 Years', 24, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Long at Current Job', '10 Years or More', 24, 91.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Long at Current Job', '6-9 Years', 24, 8.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Long at Current Job', '<1 Year', 24, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Long at Current Job', 'Missing', 24, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Construction', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Education services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Information', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Mining', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 92.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 96.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Total Completes for O*NET-SOC', NULL, 24, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Data Collection Mode', 'Paper', 20, 60.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Data Collection Mode', 'Web', 20, 40.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Long at Current Job', '1-5 Years', 20, 5.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Long at Current Job', '10 Years or More', 20, 85.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Long at Current Job', '6-9 Years', 20, 10.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Long at Current Job', '<1 Year', 20, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Long at Current Job', 'Missing', 20, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Construction', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Education services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Information', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Mining', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 95.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 65.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 87.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Total Completes for O*NET-SOC', NULL, 20, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Data Collection Mode', 'Paper', 25, 88.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Data Collection Mode', 'Web', 25, 12.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Long at Current Job', '1-5 Years', 25, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Long at Current Job', '10 Years or More', 25, 100.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Long at Current Job', '6-9 Years', 25, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Long at Current Job', '<1 Year', 25, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Long at Current Job', 'Missing', 25, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 83.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 96.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Total Completes for O*NET-SOC', NULL, 25, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Data Collection Mode', 'Paper', 21, 85.7, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Data Collection Mode', 'Web', 21, 14.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Long at Current Job', '1-5 Years', 21, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Long at Current Job', '10 Years or More', 21, 95.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Long at Current Job', '6-9 Years', 21, 4.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Long at Current Job', '<1 Year', 21, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Long at Current Job', 'Missing', 21, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Construction', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Education services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Information', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Mining', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 74.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 92.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Total Completes for O*NET-SOC', NULL, 21, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Data Collection Mode', 'Paper', 24, 54.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Data Collection Mode', 'Web', 24, 45.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Long at Current Job', '1-5 Years', 24, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Long at Current Job', '10 Years or More', 24, 95.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Long at Current Job', '6-9 Years', 24, 4.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Long at Current Job', '<1 Year', 24, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Long at Current Job', 'Missing', 24, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 96.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 86.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 96.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Total Completes for O*NET-SOC', NULL, 24, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Data Collection Mode', 'Paper', 64, 62.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Data Collection Mode', 'Web', 64, 37.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Long at Current Job', '1-5 Years', 64, 48.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Long at Current Job', '10 Years or More', 64, 31.3, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Long at Current Job', '6-9 Years', 64, 12.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Long at Current Job', '<1 Year', 64, 7.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Long at Current Job', 'Missing', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 64, 1.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 64, 34.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 64, 7.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 64, 54.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 64, 1.6, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 64, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 83.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 47.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 58.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Total Completes for O*NET-SOC', NULL, 64, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Data Collection Mode', 'Paper', 122, 47.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Data Collection Mode', 'Web', 122, 52.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'How Long at Current Job', '1-5 Years', 122, 34.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'How Long at Current Job', '10 Years or More', 122, 44.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'How Long at Current Job', '6-9 Years', 122, 16.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'How Long at Current Job', '<1 Year', 122, 4.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'How Long at Current Job', 'Missing', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 122, 70.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 122, 2.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 122, 20.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 122, 6.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Accommodation and food services', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Construction', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Education services', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Finance and insurance', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Health care and social assistance', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Information', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Management of Companies and Enterprises', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Manufacturing', 122, 70.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Mining', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Other services, except public administration', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 122, 20.5, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Public administration', 122, 2.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Real estate and rental and leasing', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Retail trade', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Transportation and warehousing', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Unclassified', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Utilities', 122, 6.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Wholesale trade', 122, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 87.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 65.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 61.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Total Completes for O*NET-SOC', NULL, 122, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Data Collection Mode', 'Paper', 98, 53.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Data Collection Mode', 'Web', 98, 46.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'How Long at Current Job', '1-5 Years', 98, 35.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'How Long at Current Job', '10 Years or More', 98, 41.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'How Long at Current Job', '6-9 Years', 98, 11.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'How Long at Current Job', '<1 Year', 98, 11.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'How Long at Current Job', 'Missing', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 98, 87.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 98, 1.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 98, 2.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 98, 9.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Accommodation and food services', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Construction', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Education services', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Finance and insurance', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Health care and social assistance', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Information', 98, 9.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Management of Companies and Enterprises', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Manufacturing', 98, 87.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Mining', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Other services, except public administration', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 98, 2.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Public administration', 98, 1.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Real estate and rental and leasing', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Retail trade', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Transportation and warehousing', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Unclassified', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Utilities', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Wholesale trade', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 94.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 62.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 69.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Total Completes for O*NET-SOC', NULL, 98, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Data Collection Mode', 'Paper', 51, 58.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Data Collection Mode', 'Web', 51, 41.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Long at Current Job', '1-5 Years', 51, 25.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Long at Current Job', '10 Years or More', 51, 54.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Long at Current Job', '6-9 Years', 51, 11.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Long at Current Job', '<1 Year', 51, 7.8, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Long at Current Job', 'Missing', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 51, 2.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 51, 56.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 51, 39.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 51, 2.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Accommodation and food services', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 51, 2.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Construction', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Education services', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Finance and insurance', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Health care and social assistance', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Information', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Management of Companies and Enterprises', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Manufacturing', 51, 2.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Mining', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Other services, except public administration', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 51, 39.2, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Public administration', 51, 56.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Real estate and rental and leasing', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Retail trade', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Transportation and warehousing', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Unclassified', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Utilities', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'NAICS Sector', 'Wholesale trade', 51, 0.0, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 89.5, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 63.3, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 72.9, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Total Completes for O*NET-SOC', NULL, 51, NULL, '2008-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Data Collection Mode', 'Paper', 22, 63.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Data Collection Mode', 'Web', 22, 36.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'How Long at Current Job', '1-5 Years', 22, 4.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'How Long at Current Job', '10 Years or More', 22, 86.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'How Long at Current Job', '6-9 Years', 22, 4.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'How Long at Current Job', '<1 Year', 22, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'How Long at Current Job', 'Missing', 22, 4.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Construction', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Education services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Information', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Mining', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 57.9, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 84.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Total Completes for O*NET-SOC', NULL, 22, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Data Collection Mode', 'Paper', 28, 100.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Data Collection Mode', 'Web', 28, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Long at Current Job', '1-5 Years', 28, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Long at Current Job', '10 Years or More', 28, 82.1, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Long at Current Job', '6-9 Years', 28, 17.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Long at Current Job', '<1 Year', 28, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Long at Current Job', 'Missing', 28, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.3, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 78.9, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 93.8, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Total Completes for O*NET-SOC', NULL, 28, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Data Collection Mode', 'Paper', 29, 100.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Data Collection Mode', 'Web', 29, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'How Long at Current Job', '1-5 Years', 29, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'How Long at Current Job', '10 Years or More', 29, 72.4, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'How Long at Current Job', '6-9 Years', 29, 27.6, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'How Long at Current Job', '<1 Year', 29, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'How Long at Current Job', 'Missing', 29, 0.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 100.0, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 80.6, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'O*NET-SOC Employee Response Rate', NULL, NULL, 87.9, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Total Completes for O*NET-SOC', NULL, 29, NULL, '2007-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Data Collection Mode', 'Paper', 98, 69.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Data Collection Mode', 'Web', 98, 30.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'How Long at Current Job', '1-5 Years', 98, 29.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'How Long at Current Job', '10 Years or More', 98, 48.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'How Long at Current Job', '6-9 Years', 98, 17.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'How Long at Current Job', '<1 Year', 98, 5.1, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'How Long at Current Job', 'Missing', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 98, 91.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 98, 8.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Accommodation and food services', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Construction', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Education services', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Finance and insurance', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Health care and social assistance', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Information', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Management of Companies and Enterprises', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Manufacturing', 98, 91.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Mining', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Other services, except public administration', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 98, 8.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Public administration', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Real estate and rental and leasing', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Retail trade', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Transportation and warehousing', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Unclassified', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Utilities', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Wholesale trade', 98, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 93.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 79.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 84.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Total Completes for O*NET-SOC', NULL, 98, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Data Collection Mode', 'Paper', 86, 80.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Data Collection Mode', 'Web', 86, 19.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'How Long at Current Job', '1-5 Years', 86, 22.1, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'How Long at Current Job', '10 Years or More', 86, 62.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'How Long at Current Job', '6-9 Years', 86, 10.5, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'How Long at Current Job', '<1 Year', 86, 4.7, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'How Long at Current Job', 'Missing', 86, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 86, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 86, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 86, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 86, 1.2, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 86, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 86, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 86, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 86, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 86, 98.8, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 86, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 86, 0.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 86.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 65.0, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 82.4, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Total Completes for O*NET-SOC', NULL, 86, NULL, '2005-12-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Data Collection Mode', 'Paper', 88, 85.2, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Data Collection Mode', 'Web', 88, 14.8, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'How Long at Current Job', '1-5 Years', 88, 22.7, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'How Long at Current Job', '10 Years or More', 88, 63.6, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'How Long at Current Job', '6-9 Years', 88, 6.8, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'How Long at Current Job', '<1 Year', 88, 5.7, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'How Long at Current Job', 'Missing', 88, 1.1, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 88, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 88, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 88, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 88, 58.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 88, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 88, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 88, 5.7, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 88, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 88, 36.4, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 88, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 88, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 78.6, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 82.1, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 81.5, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Total Completes for O*NET-SOC', NULL, 88, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Data Collection Mode', 'Paper', 82, 70.7, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Data Collection Mode', 'Web', 82, 29.3, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Long at Current Job', '1-5 Years', 82, 35.4, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Long at Current Job', '10 Years or More', 82, 40.2, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Long at Current Job', '6-9 Years', 82, 17.1, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Long at Current Job', '<1 Year', 82, 7.3, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Long at Current Job', 'Missing', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 82, 22.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 82, 6.1, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 82, 72.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 82, 0.0, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 95.3, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 64.7, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 70.1, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Total Completes for O*NET-SOC', NULL, 82, NULL, '2006-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Data Collection Mode', 'Paper', 125, 68.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Data Collection Mode', 'Web', 125, 32.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'How Long at Current Job', '1-5 Years', 125, 36.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'How Long at Current Job', '10 Years or More', 125, 34.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'How Long at Current Job', '6-9 Years', 125, 15.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'How Long at Current Job', '<1 Year', 125, 12.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'How Long at Current Job', 'Missing', 125, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 125, 75.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 125, 23.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 125, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Accommodation and food services', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Construction', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Education services', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Finance and insurance', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Health care and social assistance', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Information', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Management of Companies and Enterprises', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Manufacturing', 125, 75.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Mining', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Other services, except public administration', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 125, 23.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Public administration', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Real estate and rental and leasing', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Retail trade', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Transportation and warehousing', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Unclassified', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Utilities', 125, 1.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Wholesale trade', 125, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.9, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 71.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 64.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Total Completes for O*NET-SOC', NULL, 125, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Data Collection Mode', 'Paper', 73, 57.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Data Collection Mode', 'Web', 73, 42.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'How Long at Current Job', '1-5 Years', 73, 31.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'How Long at Current Job', '10 Years or More', 73, 54.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'How Long at Current Job', '6-9 Years', 73, 6.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'How Long at Current Job', '<1 Year', 73, 6.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'How Long at Current Job', 'Missing', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 73, 72.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 73, 27.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Accommodation and food services', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Construction', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Education services', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Finance and insurance', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Health care and social assistance', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Information', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Management of Companies and Enterprises', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Manufacturing', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Mining', 73, 72.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Other services, except public administration', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 73, 27.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Public administration', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Real estate and rental and leasing', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Retail trade', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Transportation and warehousing', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Unclassified', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Utilities', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Wholesale trade', 73, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 89.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 70.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 81.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Total Completes for O*NET-SOC', NULL, 73, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Data Collection Mode', 'Paper', 22, 63.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Data Collection Mode', 'Web', 22, 36.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Long at Current Job', '1-5 Years', 22, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Long at Current Job', '10 Years or More', 22, 95.4, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Long at Current Job', '6-9 Years', 22, 4.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Long at Current Job', '<1 Year', 22, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Long at Current Job', 'Missing', 22, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Construction', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Education services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Information', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Mining', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Public administration', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Retail trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Unclassified', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Utilities', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 91.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 75.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 96.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Total Completes for O*NET-SOC', NULL, 22, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Data Collection Mode', 'Paper', 105, 66.7, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Data Collection Mode', 'Web', 105, 33.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'How Long at Current Job', '1-5 Years', 105, 35.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'How Long at Current Job', '10 Years or More', 105, 50.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'How Long at Current Job', '6-9 Years', 105, 9.5, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'How Long at Current Job', '<1 Year', 105, 4.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'How Long at Current Job', 'Missing', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 105, 75.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 105, 24.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Accommodation and food services', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Construction', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Education services', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Finance and insurance', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Health care and social assistance', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Information', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Management of Companies and Enterprises', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Manufacturing', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Mining', 105, 75.2, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Other services, except public administration', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 105, 24.8, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Public administration', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Real estate and rental and leasing', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Retail trade', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Transportation and warehousing', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Unclassified', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Utilities', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Wholesale trade', 105, 0.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 94.6, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'O*NET-SOC Employee Response Rate', NULL, NULL, 81.0, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'O*NET-SOC Establishment Response Rate', NULL, NULL, 81.3, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Total Completes for O*NET-SOC', NULL, 105, NULL, '2010-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Data Collection Mode', 'Paper', 22, 36.4, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Data Collection Mode', 'Web', 22, 63.6, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'How Long at Current Job', '1-5 Years', 22, 9.1, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'How Long at Current Job', '10 Years or More', 22, 68.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'How Long at Current Job', '6-9 Years', 22, 18.2, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'How Long at Current Job', '<1 Year', 22, 0.0, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'How Long at Current Job', 'Missing', 22, 4.5, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Construction', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Education services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Information', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Mining', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Public administration', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Retail trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Unclassified', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Utilities', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 95.7, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 79.3, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'O*NET-SOC Employee Response Rate', NULL, NULL, 95.8, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Total Completes for O*NET-SOC', NULL, 22, NULL, '2011-07-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Data Collection Mode', 'Paper', 29, 51.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Data Collection Mode', 'Web', 29, 48.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'How Long at Current Job', '1-5 Years', 29, 3.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'How Long at Current Job', '10 Years or More', 29, 72.4, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'How Long at Current Job', '6-9 Years', 29, 24.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'How Long at Current Job', '<1 Year', 29, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'How Long at Current Job', 'Missing', 29, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Accommodation and food services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Arts, entertainment, and recreation', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Construction', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Education services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Finance and insurance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Health care and social assistance', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Information', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Management of Companies and Enterprises', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Manufacturing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Mining', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Other services, except public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Public administration', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Real estate and rental and leasing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Retail trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Transportation and warehousing', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Unclassified', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Utilities', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'NAICS Sector', 'Wholesale trade', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'O*NET-SOC Case Completeness Rate', NULL, NULL, 90.6, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'O*NET-SOC Eligible Expert Response Rate', NULL, NULL, 94.1, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'O*NET-SOC Employee Response Rate', NULL, NULL, 97.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'O*NET-SOC Establishment Response Rate', NULL, NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Total Completes for O*NET-SOC', NULL, 29, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'Data Collection Mode', 'Paper', 26, 69.2, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'Data Collection Mode', 'Web', 26, 30.8, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'How Long at Current Job', '1-5 Years', 26, 7.7, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'How Long at Current Job', '10 Years or More', 26, 92.3, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'How Long at Current Job', '6-9 Years', 26, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'How Long at Current Job', '<1 Year', 26, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'How Long at Current Job', 'Missing', 26, 0.0, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', NULL, NULL, '2009-06-01');
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'Industry Division (Major Group Codes (SIC) within Division in parent