CREATE TABLE work_styles (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(5,2),
  lower_ci_bound DECIMAL(5,2),
  upper_ci_bound DECIMAL(5,2),
  recommend_suppress CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id));
GO

INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.1.a', 'IM', 4.66, 30, 0.18, 4.30, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.1.b', 'IM', 4.61, 30, 0.19, 4.23, 4.99, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.1.c', 'IM', 4.79, 30, 0.14, 4.51, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.2.b', 'IM', 4.84, 30, 0.13, 4.57, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.3.a', 'IM', 4.42, 30, 0.19, 4.02, 4.81, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.3.b', 'IM', 3.95, 30, 0.15, 3.64, 4.26, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.3.c', 'IM', 4.02, 29, 0.04, 3.94, 4.09, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.4.a', 'IM', 4.28, 30, 0.15, 3.97, 4.59, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.4.b', 'IM', 4.75, 30, 0.15, 4.45, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.4.c', 'IM', 4.48, 30, 0.21, 4.05, 4.90, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.5.a', 'IM', 4.67, 30, 0.18, 4.31, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.5.b', 'IM', 4.26, 30, 0.31, 3.62, 4.90, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.5.c', 'IM', 4.85, 30, 0.13, 4.59, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.6', 'IM', 4.63, 30, 0.18, 4.26, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.7.a', 'IM', 4.22, 30, 0.14, 3.94, 4.50, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.7.b', 'IM', 4.24, 30, 0.14, 3.95, 4.53, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.1.a', 'IM', 4.07, 44, 0.14, 3.80, 4.35, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.1.b', 'IM', 4.24, 44, 0.11, 4.03, 4.46, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.1.c', 'IM', 4.36, 44, 0.14, 4.09, 4.64, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.2.b', 'IM', 4.50, 44, 0.10, 4.29, 4.71, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.3.a', 'IM', 4.26, 44, 0.14, 3.98, 4.53, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.3.b', 'IM', 3.96, 44, 0.18, 3.61, 4.32, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.3.c', 'IM', 3.56, 44, 0.18, 3.19, 3.93, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.4.a', 'IM', 4.38, 44, 0.15, 4.08, 4.68, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.4.b', 'IM', 4.35, 44, 0.14, 4.07, 4.64, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.4.c', 'IM', 4.21, 44, 0.18, 3.84, 4.58, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.5.a', 'IM', 4.73, 44, 0.08, 4.57, 4.89, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.5.b', 'IM', 4.52, 44, 0.11, 4.29, 4.75, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.5.c', 'IM', 4.36, 44, 0.14, 4.07, 4.65, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.6', 'IM', 3.96, 44, 0.15, 3.66, 4.27, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.7.a', 'IM', 3.88, 44, 0.22, 3.44, 4.32, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.7.b', 'IM', 4.22, 44, 0.17, 3.88, 4.55, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.1.a', 'IM', 4.30, 24, 0.12, 4.06, 4.55, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.1.b', 'IM', 4.23, 24, 0.13, 3.96, 4.50, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.1.c', 'IM', 4.71, 24, 0.11, 4.49, 4.94, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.2.b', 'IM', 4.23, 24, 0.12, 3.99, 4.48, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.3.a', 'IM', 4.40, 24, 0.17, 4.06, 4.75, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.3.b', 'IM', 3.93, 24, 0.16, 3.59, 4.26, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.3.c', 'IM', 3.99, 24, 0.17, 3.64, 4.34, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.4.a', 'IM', 4.42, 24, 0.17, 4.07, 4.76, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.4.b', 'IM', 4.39, 24, 0.21, 3.96, 4.81, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.4.c', 'IM', 4.54, 24, 0.14, 4.25, 4.84, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.5.a', 'IM', 4.74, 24, 0.09, 4.56, 4.93, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.5.b', 'IM', 4.70, 24, 0.11, 4.48, 4.93, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.5.c', 'IM', 4.66, 24, 0.12, 4.41, 4.91, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.6', 'IM', 4.08, 24, 0.16, 3.74, 4.42, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.7.a', 'IM', 4.51, 24, 0.15, 4.19, 4.83, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.7.b', 'IM', 4.16, 24, 0.22, 3.69, 4.62, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.1.a', 'IM', 4.24, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.1.b', 'IM', 4.28, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.1.c', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.2.b', 'IM', 4.36, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.3.a', 'IM', 4.44, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.3.b', 'IM', 3.72, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.3.c', 'IM', 3.88, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.4.a', 'IM', 4.04, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.4.b', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.4.c', 'IM', 4.24, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.5.a', 'IM', 4.56, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.5.b', 'IM', 4.48, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.5.c', 'IM', 4.40, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.6', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.7.a', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.7.b', 'IM', 3.84, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.1.a', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.1.b', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.1.c', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.2.b', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.3.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.3.b', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.3.c', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.4.a', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.4.b', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.4.c', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.5.a', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.5.b', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.5.c', 'IM', 4.67, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.6', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.7.a', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.7.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.1.a', 'IM', 4.36, 36, 0.15, 4.06, 4.67, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.1.b', 'IM', 4.30, 36, 0.19, 3.91, 4.69, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.1.c', 'IM', 4.38, 36, 0.21, 3.96, 4.80, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.2.b', 'IM', 4.33, 36, 0.16, 4.01, 4.65, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.3.a', 'IM', 4.42, 36, 0.11, 4.19, 4.64, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.3.b', 'IM', 4.31, 36, 0.14, 4.03, 4.58, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.3.c', 'IM', 4.26, 36, 0.15, 3.95, 4.58, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.4.a', 'IM', 4.26, 36, 0.17, 3.91, 4.60, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.4.b', 'IM', 4.47, 36, 0.11, 4.24, 4.69, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.4.c', 'IM', 4.35, 36, 0.13, 4.09, 4.62, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.5.a', 'IM', 4.57, 36, 0.11, 4.34, 4.79, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.5.b', 'IM', 4.62, 36, 0.14, 4.33, 4.90, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.5.c', 'IM', 4.57, 36, 0.18, 4.20, 4.93, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.6', 'IM', 4.31, 36, 0.15, 4.01, 4.61, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.7.a', 'IM', 4.21, 36, 0.18, 3.85, 4.57, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '1.C.7.b', 'IM', 3.99, 36, 0.17, 3.66, 4.33, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.1.a', 'IM', 3.46, 37, 0.27, 2.92, 4.01, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.1.b', 'IM', 3.59, 37, 0.28, 3.03, 4.15, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.1.c', 'IM', 4.37, 37, 0.14, 4.10, 4.65, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.2.b', 'IM', 4.00, 37, 0.20, 3.60, 4.40, 'N', '2009-06-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.3.a', 'IM', 4.52, 37, 0.11, 4.29, 4.75, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.3.b', 'IM', 4.21, 37, 0.24, 3.73, 4.69, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.3.c', 'IM', 3.46, 37, 0.43, 2.58, 4.34, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.4.a', 'IM', 4.37, 37, 0.26, 3.85, 4.90, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.4.b', 'IM', 4.19, 37, 0.24, 3.71, 4.66, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.4.c', 'IM', 4.27, 37, 0.13, 4.00, 4.54, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.5.a', 'IM', 4.73, 37, 0.09, 4.54, 4.92, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.5.b', 'IM', 4.63, 37, 0.12, 4.40, 4.87, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.5.c', 'IM', 4.77, 37, 0.09, 4.58, 4.95, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.6', 'IM', 4.49, 37, 0.13, 4.21, 4.76, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.7.a', 'IM', 3.55, 37, 0.14, 3.27, 3.82, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '1.C.7.b', 'IM', 3.48, 37, 0.26, 2.94, 4.01, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.1.a', 'IM', 3.95, 32, 0.11, 3.73, 4.17, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.1.b', 'IM', 3.43, 32, 0.19, 3.04, 3.82, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.1.c', 'IM', 4.00, 32, 0.11, 3.78, 4.23, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.2.b', 'IM', 4.11, 32, 0.14, 3.83, 4.38, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.3.a', 'IM', 4.37, 32, 0.23, 3.91, 4.83, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.3.b', 'IM', 4.09, 32, 0.31, 3.46, 4.73, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.3.c', 'IM', 2.94, 32, 0.25, 2.44, 3.44, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.4.a', 'IM', 4.00, 31, 0.12, 3.75, 4.25, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.4.b', 'IM', 3.57, 32, 0.41, 2.72, 4.41, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.4.c', 'IM', 4.71, 32, 0.14, 4.43, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.5.a', 'IM', 4.75, 32, 0.13, 4.49, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.5.b', 'IM', 4.41, 32, 0.20, 4.01, 4.82, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.5.c', 'IM', 4.76, 32, 0.13, 4.49, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.6', 'IM', 4.17, 32, 0.35, 3.46, 4.89, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.7.a', 'IM', 4.00, 32, 0.05, 3.91, 4.10, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.7.b', 'IM', 4.23, 32, 0.12, 3.99, 4.48, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.1.a', 'IM', 4.04, 40, 0.12, 3.79, 4.29, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.1.b', 'IM', 4.18, 40, 0.12, 3.94, 4.42, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.1.c', 'IM', 4.17, 40, 0.13, 3.91, 4.43, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.2.b', 'IM', 3.64, 40, 0.34, 2.96, 4.33, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.3.a', 'IM', 4.75, 40, 0.14, 4.47, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.3.b', 'IM', 3.48, 40, 0.26, 2.95, 4.01, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.3.c', 'IM', 3.25, 40, 0.22, 2.81, 3.70, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.4.a', 'IM', 3.95, 40, 0.16, 3.63, 4.27, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.4.b', 'IM', 3.63, 40, 0.33, 2.95, 4.30, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.4.c', 'IM', 3.60, 40, 0.32, 2.95, 4.25, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.5.a', 'IM', 4.36, 39, 0.21, 3.95, 4.78, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.5.b', 'IM', 4.34, 40, 0.19, 3.96, 4.73, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.5.c', 'IM', 4.94, 40, 0.06, 4.82, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.6', 'IM', 4.20, 40, 0.14, 3.90, 4.49, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.7.a', 'IM', 3.93, 40, 0.13, 3.66, 4.19, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.7.b', 'IM', 4.70, 40, 0.17, 4.36, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.1.a', 'IM', 4.33, 16, 0.24, 3.81, 4.85, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.1.b', 'IM', 3.76, 16, 0.24, 3.25, 4.27, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.1.c', 'IM', 4.06, 16, 0.40, 3.19, 4.92, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.2.b', 'IM', 4.34, 16, 0.24, 3.82, 4.86, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.3.a', 'IM', 4.33, 16, 0.24, 3.81, 4.85, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.3.b', 'IM', 3.73, 16, 0.24, 3.22, 4.24, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.3.c', 'IM', 4.30, 16, 0.25, 3.76, 4.83, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.4.a', 'IM', 4.34, 16, 0.24, 3.82, 4.86, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.4.b', 'IM', 4.05, 16, 0.40, 3.19, 4.91, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.4.c', 'IM', 3.77, 16, 0.24, 3.26, 4.29, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.5.a', 'IM', 4.38, 15, 0.24, 3.86, 4.90, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.5.b', 'IM', 4.38, 15, 0.24, 3.86, 4.90, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.5.c', 'IM', 4.71, 16, 0.24, 4.19, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.6', 'IM', 4.25, 16, 0.25, 3.72, 4.78, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.7.a', 'IM', 3.91, 16, 0.06, 3.77, 4.05, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '1.C.7.b', 'IM', 3.40, 16, 0.25, 2.87, 3.93, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.1.a', 'IM', 3.93, 39, 0.15, 3.64, 4.23, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.1.b', 'IM', 4.00, 39, 0.24, 3.53, 4.48, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.1.c', 'IM', 4.49, 39, 0.10, 4.29, 4.70, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.2.b', 'IM', 4.74, 39, 0.13, 4.48, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.3.a', 'IM', 4.18, 39, 0.28, 3.62, 4.75, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.3.b', 'IM', 4.08, 39, 0.36, 3.36, 4.80, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.3.c', 'IM', 3.89, 39, 0.23, 3.42, 4.36, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.4.a', 'IM', 4.41, 39, 0.24, 3.92, 4.90, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.4.b', 'IM', 4.21, 39, 0.28, 3.65, 4.77, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.4.c', 'IM', 4.34, 39, 0.20, 3.93, 4.74, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.5.a', 'IM', 4.66, 39, 0.13, 4.39, 4.92, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.5.b', 'IM', 4.34, 39, 0.22, 3.89, 4.78, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.5.c', 'IM', 4.36, 39, 0.21, 3.93, 4.79, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.6', 'IM', 3.90, 39, 0.30, 3.29, 4.51, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.7.a', 'IM', 4.19, 38, 0.21, 3.76, 4.62, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.7.b', 'IM', 4.27, 38, 0.19, 3.89, 4.65, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.1.a', 'IM', 4.14, 21, 0.10, 3.92, 4.35, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.1.b', 'IM', 3.95, 21, 0.12, 3.71, 4.19, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.1.c', 'IM', 4.21, 21, 0.16, 3.88, 4.53, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.2.b', 'IM', 4.48, 21, 0.11, 4.24, 4.71, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.3.a', 'IM', 4.29, 21, 0.12, 4.05, 4.54, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.3.b', 'IM', 4.06, 21, 0.15, 3.75, 4.37, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.3.c', 'IM', 3.81, 21, 0.19, 3.42, 4.20, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.4.a', 'IM', 4.15, 20, 0.12, 3.90, 4.40, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.4.b', 'IM', 4.38, 21, 0.11, 4.15, 4.61, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.4.c', 'IM', 4.13, 21, 0.12, 3.89, 4.38, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.5.a', 'IM', 4.46, 21, 0.11, 4.22, 4.69, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.5.b', 'IM', 4.41, 21, 0.16, 4.07, 4.75, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.5.c', 'IM', 4.57, 21, 0.08, 4.40, 4.73, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.6', 'IM', 3.80, 21, 0.24, 3.30, 4.30, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.7.a', 'IM', 4.35, 21, 0.16, 4.02, 4.68, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.7.b', 'IM', 4.41, 21, 0.15, 4.09, 4.73, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.1.a', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.1.b', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.1.c', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.2.b', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.3.a', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.3.b', 'IM', 3.12, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.3.c', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.4.a', 'IM', 4.38, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.4.b', 'IM', 4.25, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.4.c', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.5.a', 'IM', 4.38, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.5.b', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.5.c', 'IM', 4.92, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.6', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.7.a', 'IM', 3.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.7.b', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.1.a', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.1.b', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.1.c', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.2.b', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.3.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.3.b', 'IM', 3.17, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.3.c', 'IM', 3.13, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.4.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.4.b', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.4.c', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.5.a', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.5.b', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.5.c', 'IM', 4.61, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.6', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.7.a', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '1.C.7.b', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.1.a', 'IM', 3.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.1.b', 'IM', 3.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.1.c', 'IM', 3.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.2.b', 'IM', 4.21, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.3.a', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.3.b', 'IM', 3.38, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.3.c', 'IM', 3.25, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.4.a', 'IM', 3.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.4.b', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.4.c', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.5.a', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.5.b', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.5.c', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.6', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.7.a', 'IM', 3.12, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '1.C.7.b', 'IM', 3.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.1.a', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.1.b', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.1.c', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.2.b', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.3.a', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.3.b', 'IM', 3.13, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.3.c', 'IM', 2.87, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.4.a', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.4.b', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.4.c', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.5.a', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.5.b', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.5.c', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.6', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.7.a', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', '1.C.7.b', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.1.a', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.1.b', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.1.c', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.2.b', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.3.a', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.3.b', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.3.c', 'IM', 3.14, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.4.a', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.4.b', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.4.c', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.5.a', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.5.b', 'IM', 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.5.c', 'IM', 4.86, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.6', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.7.a', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.7.b', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.1.a', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.1.b', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.1.c', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.2.b', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.3.a', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.3.b', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.3.c', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.4.a', 'IM', 4.41, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.4.b', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.4.c', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.5.a', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.5.b', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.5.c', 'IM', 4.86, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.6', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.7.a', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.7.b', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.1.a', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.1.b', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.1.c', 'IM', 4.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.2.b', 'IM', 4.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.3.a', 'IM', 4.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.3.b', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.3.c', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.4.a', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.4.b', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.4.c', 'IM', 4.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.5.a', 'IM', 4.62, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.5.b', 'IM', 4.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.5.c', 'IM', 4.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.6', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.7.a', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.7.b', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.1.a', 'IM', 4.21, 24, 0.15, 3.91, 4.51, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.1.b', 'IM', 4.17, 24, 0.11, 3.94, 4.39, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.1.c', 'IM', 4.38, 24, 0.15, 4.06, 4.70, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.2.b', 'IM', 4.69, 24, 0.13, 4.43, 4.96, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.3.a', 'IM', 4.33, 24, 0.18, 3.96, 4.71, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.3.b', 'IM', 3.74, 24, 0.18, 3.37, 4.11, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.3.c', 'IM', 3.81, 24, 0.25, 3.28, 4.33, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.4.a', 'IM', 4.41, 24, 0.18, 4.04, 4.78, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.4.b', 'IM', 4.09, 24, 0.12, 3.85, 4.34, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.4.c', 'IM', 4.12, 24, 0.31, 3.48, 4.75, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.5.a', 'IM', 4.75, 24, 0.12, 4.51, 5.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.5.b', 'IM', 4.15, 24, 0.25, 3.63, 4.67, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.5.c', 'IM', 4.30, 24, 0.21, 3.86, 4.73, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.6', 'IM', 3.85, 24, 0.38, 3.07, 4.63, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.7.a', 'IM', 3.92, 24, 0.16, 3.58, 4.26, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '1.C.7.b', 'IM', 4.41, 24, 0.18, 4.03, 4.79, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.1.a', 'IM', 4.19, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.1.b', 'IM', 4.35, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.1.c', 'IM', 4.48, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.2.b', 'IM', 4.10, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.3.a', 'IM', 3.90, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.3.b', 'IM', 3.68, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.3.c', 'IM', 2.97, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.4.a', 'IM', 4.00, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.4.b', 'IM', 4.00, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.4.c', 'IM', 4.10, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.5.a', 'IM', 4.71, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.5.b', 'IM', 4.48, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.5.c', 'IM', 4.52, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.6', 'IM', 4.00, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.7.a', 'IM', 4.13, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '1.C.7.b', 'IM', 4.39, 31, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.1.a', 'IM', 4.00, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.1.b', 'IM', 4.12, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.1.c', 'IM', 4.31, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.2.b', 'IM', 4.34, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.3.a', 'IM', 4.19, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.3.b', 'IM', 3.03, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.3.c', 'IM', 3.34, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.4.a', 'IM', 4.03, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.4.b', 'IM', 4.09, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.4.c', 'IM', 4.00, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.5.a', 'IM', 4.50, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.5.b', 'IM', 4.44, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.5.c', 'IM', 4.75, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.6', 'IM', 3.47, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.7.a', 'IM', 3.16, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.7.b', 'IM', 4.06, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.1.a', 'IM', 3.75, 22, 0.19, 3.36, 4.14, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.1.b', 'IM', 4.26, 22, 0.22, 3.80, 4.73, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.1.c', 'IM', 4.38, 22, 0.15, 4.07, 4.69, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.2.b', 'IM', 4.67, 22, 0.16, 4.34, 4.99, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.3.a', 'IM', 4.51, 22, 0.15, 4.20, 4.83, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.3.b', 'IM', 4.75, 22, 0.13, 4.49, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.3.c', 'IM', 4.47, 22, 0.16, 4.14, 4.81, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.4.a', 'IM', 4.70, 22, 0.14, 4.41, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.4.b', 'IM', 4.77, 22, 0.12, 4.52, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.4.c', 'IM', 4.61, 22, 0.16, 4.28, 4.94, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.5.a', 'IM', 4.80, 22, 0.12, 4.55, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.5.b', 'IM', 4.55, 22, 0.15, 4.25, 4.86, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.5.c', 'IM', 4.79, 22, 0.12, 4.54, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.6', 'IM', 4.66, 22, 0.15, 4.36, 4.97, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.7.a', 'IM', 4.22, 22, 0.21, 3.79, 4.65, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.7.b', 'IM', 4.05, 22, 0.24, 3.56, 4.55, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.1.a', 'IM', 4.35, 29, 0.12, 4.10, 4.59, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.1.b', 'IM', 4.48, 29, 0.11, 4.25, 4.71, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.1.c', 'IM', 4.56, 29, 0.14, 4.28, 4.85, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.2.b', 'IM', 4.80, 29, 0.08, 4.63, 4.97, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.3.a', 'IM', 4.72, 29, 0.09, 4.53, 4.91, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.3.b', 'IM', 4.60, 29, 0.14, 4.32, 4.88, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.3.c', 'IM', 4.17, 29, 0.28, 3.60, 4.74, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.4.a', 'IM', 4.60, 29, 0.12, 4.36, 4.84, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.4.b', 'IM', 4.62, 28, 0.10, 4.42, 4.82, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.4.c', 'IM', 4.68, 29, 0.12, 4.44, 4.92, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.5.a', 'IM', 4.75, 29, 0.11, 4.52, 4.98, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.5.b', 'IM', 4.44, 29, 0.12, 4.20, 4.69, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.5.c', 'IM', 4.69, 29, 0.14, 4.40, 4.98, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.6', 'IM', 4.15, 29, 0.25, 3.64, 4.65, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.7.a', 'IM', 4.01, 29, 0.20, 3.59, 4.43, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.7.b', 'IM', 4.46, 29, 0.11, 4.22, 4.69, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.1.a', 'IM', 3.95, 29, 0.43, 3.07, 4.83, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.1.b', 'IM', 4.27, 29, 0.27, 3.72, 4.83, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.1.c', 'IM', 4.59, 29, 0.08, 4.43, 4.74, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.2.b', 'IM', 4.74, 29, 0.12, 4.49, 4.99, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.3.a', 'IM', 4.59, 28, 0.13, 4.33, 4.85, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.3.b', 'IM', 4.50, 28, 0.18, 4.13, 4.87, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.3.c', 'IM', 3.79, 28, 0.15, 3.48, 4.11, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.4.a', 'IM', 4.61, 28, 0.18, 4.25, 4.97, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.4.b', 'IM', 3.91, 28, 0.43, 3.04, 4.78, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.4.c', 'IM', 4.13, 28, 0.09, 3.94, 4.31, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.5.a', 'IM', 4.75, 28, 0.14, 4.46, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.5.b', 'IM', 4.14, 28, 0.27, 3.60, 4.69, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.5.c', 'IM', 4.60, 29, 0.17, 4.24, 4.95, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.6', 'IM', 3.96, 29, 0.18, 3.58, 4.33, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.7.a', 'IM', 3.97, 29, 0.28, 3.40, 4.54, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.7.b', 'IM', 4.06, 29, 0.50, 3.03, 5.00, 'N', '2010-06-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.1.a', 'IM', 4.23, 58, 0.20, 3.83, 4.63, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.1.b', 'IM', 4.25, 58, 0.17, 3.91, 4.58, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.1.c', 'IM', 4.53, 58, 0.13, 4.27, 4.79, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.2.b', 'IM', 4.25, 58, 0.15, 3.96, 4.54, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.3.a', 'IM', 4.04, 58, 0.18, 3.68, 4.40, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.3.b', 'IM', 3.39, 58, 0.18, 3.02, 3.76, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.3.c', 'IM', 3.15, 58, 0.18, 2.79, 3.52, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.4.a', 'IM', 3.76, 58, 0.25, 3.25, 4.27, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.4.b', 'IM', 4.03, 58, 0.29, 3.45, 4.61, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.4.c', 'IM', 3.84, 58, 0.20, 3.44, 4.25, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.5.a', 'IM', 4.43, 58, 0.15, 4.13, 4.72, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.5.b', 'IM', 4.21, 58, 0.25, 3.71, 4.72, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.5.c', 'IM', 4.45, 58, 0.17, 4.11, 4.79, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.6', 'IM', 3.95, 58, 0.13, 3.68, 4.22, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.7.a', 'IM', 3.92, 58, 0.14, 3.63, 4.21, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.7.b', 'IM', 4.38, 58, 0.15, 4.07, 4.68, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.1.a', 'IM', 3.96, 23, 0.23, 3.49, 4.43, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.1.b', 'IM', 4.04, 22, 0.25, 3.53, 4.56, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.1.c', 'IM', 4.12, 23, 0.35, 3.39, 4.84, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.2.b', 'IM', 4.59, 23, 0.19, 4.19, 4.99, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.3.a', 'IM', 4.57, 23, 0.13, 4.29, 4.85, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.3.b', 'IM', 4.31, 23, 0.18, 3.92, 4.69, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.3.c', 'IM', 4.24, 23, 0.18, 3.86, 4.62, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.4.a', 'IM', 4.55, 23, 0.13, 4.28, 4.83, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.4.b', 'IM', 4.57, 23, 0.14, 4.28, 4.87, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.4.c', 'IM', 4.44, 23, 0.21, 4.01, 4.88, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.5.a', 'IM', 4.59, 23, 0.18, 4.21, 4.97, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.5.b', 'IM', 4.48, 23, 0.16, 4.14, 4.82, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.5.c', 'IM', 4.62, 23, 0.13, 4.35, 4.90, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.6', 'IM', 3.67, 23, 0.35, 2.94, 4.40, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.7.a', 'IM', 3.56, 23, 0.29, 2.95, 4.17, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.7.b', 'IM', 3.71, 23, 0.29, 3.11, 4.31, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.1.a', 'IM', 4.09, 34, 0.14, 3.81, 4.36, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.1.b', 'IM', 3.86, 34, 0.14, 3.58, 4.14, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.1.c', 'IM', 4.38, 34, 0.16, 4.05, 4.72, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.2.b', 'IM', 4.69, 34, 0.10, 4.48, 4.90, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.3.a', 'IM', 4.79, 34, 0.08, 4.63, 4.95, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.3.b', 'IM', 4.39, 34, 0.13, 4.13, 4.66, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.3.c', 'IM', 4.28, 34, 0.20, 3.88, 4.68, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.4.a', 'IM', 4.84, 34, 0.06, 4.71, 4.97, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.4.b', 'IM', 4.63, 34, 0.11, 4.41, 4.85, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.4.c', 'IM', 4.48, 34, 0.10, 4.28, 4.68, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.5.a', 'IM', 4.78, 34, 0.12, 4.55, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.5.b', 'IM', 4.44, 34, 0.10, 4.24, 4.63, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.5.c', 'IM', 4.79, 34, 0.12, 4.55, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.6', 'IM', 3.99, 34, 0.18, 3.62, 4.37, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.7.a', 'IM', 3.79, 34, 0.17, 3.44, 4.13, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.7.b', 'IM', 3.98, 34, 0.11, 3.75, 4.21, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.1.a', 'IM', 3.95, 20, 0.25, 3.43, 4.48, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.1.b', 'IM', 3.91, 20, 0.25, 3.39, 4.43, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.1.c', 'IM', 4.03, 20, 0.19, 3.65, 4.42, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.2.b', 'IM', 4.12, 20, 0.29, 3.51, 4.73, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.3.a', 'IM', 4.40, 20, 0.19, 3.99, 4.80, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.3.b', 'IM', 4.09, 20, 0.21, 3.65, 4.52, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.3.c', 'IM', 3.89, 19, 0.29, 3.28, 4.50, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.4.a', 'IM', 4.40, 20, 0.15, 4.08, 4.71, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.4.b', 'IM', 4.30, 20, 0.21, 3.86, 4.74, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.4.c', 'IM', 4.23, 20, 0.20, 3.81, 4.64, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.5.a', 'IM', 4.67, 20, 0.14, 4.37, 4.97, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.5.b', 'IM', 4.30, 20, 0.20, 3.88, 4.71, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.5.c', 'IM', 4.17, 20, 0.26, 3.63, 4.72, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.6', 'IM', 4.09, 20, 0.26, 3.54, 4.64, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.7.a', 'IM', 3.54, 20, 0.29, 2.94, 4.14, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.7.b', 'IM', 3.94, 20, 0.25, 3.43, 4.46, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.1.a', 'IM', 4.41, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.1.b', 'IM', 4.28, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.1.c', 'IM', 4.72, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.2.b', 'IM', 4.83, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.3.a', 'IM', 4.48, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.3.b', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.3.c', 'IM', 3.93, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.4.a', 'IM', 4.43, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.4.b', 'IM', 4.52, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.4.c', 'IM', 4.48, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.5.a', 'IM', 4.66, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.5.b', 'IM', 4.34, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.5.c', 'IM', 4.83, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.6', 'IM', 4.31, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.7.a', 'IM', 3.97, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.7.b', 'IM', 4.38, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.1.a', 'IM', 3.72, 25, 0.17, 3.37, 4.07, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.1.b', 'IM', 3.99, 25, 0.26, 3.46, 4.52, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.1.c', 'IM', 4.34, 25, 0.17, 3.98, 4.69, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.2.b', 'IM', 4.22, 25, 0.15, 3.91, 4.54, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.3.a', 'IM', 3.83, 25, 0.18, 3.46, 4.20, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.3.b', 'IM', 3.04, 25, 0.25, 2.52, 3.57, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.3.c', 'IM', 3.17, 25, 0.21, 2.74, 3.60, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.4.a', 'IM', 3.69, 25, 0.16, 3.35, 4.02, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.4.b', 'IM', 3.74, 25, 0.23, 3.26, 4.21, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.4.c', 'IM', 4.04, 25, 0.21, 3.60, 4.47, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.5.a', 'IM', 3.84, 25, 0.20, 3.43, 4.25, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.5.b', 'IM', 3.74, 25, 0.16, 3.41, 4.07, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.5.c', 'IM', 4.27, 25, 0.14, 3.99, 4.55, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.6', 'IM', 3.81, 25, 0.38, 3.03, 4.59, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.7.a', 'IM', 3.57, 25, 0.38, 2.79, 4.35, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.7.b', 'IM', 4.43, 25, 0.19, 4.03, 4.83, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.1.a', 'IM', 4.02, 34, 0.17, 3.67, 4.37, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.1.b', 'IM', 3.99, 34, 0.17, 3.66, 4.33, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.1.c', 'IM', 4.41, 34, 0.17, 4.06, 4.76, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.2.b', 'IM', 4.05, 34, 0.17, 3.70, 4.39, 'N', '2011-07-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.3.a', 'IM', 4.04, 34, 0.20, 3.64, 4.45, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.3.b', 'IM', 3.59, 34, 0.32, 2.95, 4.24, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.3.c', 'IM', 3.39, 34, 0.18, 3.02, 3.75, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.4.a', 'IM', 4.15, 34, 0.19, 3.77, 4.53, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.4.b', 'IM', 4.20, 34, 0.22, 3.75, 4.64, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.4.c', 'IM', 4.23, 34, 0.24, 3.73, 4.73, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.5.a', 'IM', 4.70, 34, 0.12, 4.45, 4.95, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.5.b', 'IM', 4.62, 34, 0.16, 4.29, 4.95, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.5.c', 'IM', 4.73, 34, 0.15, 4.43, 5.00, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.6', 'IM', 3.83, 34, 0.29, 3.23, 4.43, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.7.a', 'IM', 3.20, 34, 0.12, 2.95, 3.44, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.7.b', 'IM', 3.66, 34, 0.17, 3.31, 4.00, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.1.a', 'IM', 4.04, 24, 0.19, 3.64, 4.44, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.1.b', 'IM', 4.02, 24, 0.14, 3.73, 4.30, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.1.c', 'IM', 4.09, 23, 0.18, 3.71, 4.47, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.2.b', 'IM', 4.45, 24, 0.20, 4.04, 4.87, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.3.a', 'IM', 4.14, 23, 0.09, 3.95, 4.33, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.3.b', 'IM', 3.89, 24, 0.13, 3.63, 4.15, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.3.c', 'IM', 3.38, 24, 0.25, 2.86, 3.91, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.4.a', 'IM', 4.53, 24, 0.16, 4.20, 4.87, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.4.b', 'IM', 4.40, 24, 0.19, 4.00, 4.80, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.4.c', 'IM', 4.10, 24, 0.20, 3.68, 4.52, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.5.a', 'IM', 4.53, 24, 0.14, 4.25, 4.81, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.5.b', 'IM', 4.04, 24, 0.15, 3.74, 4.34, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.5.c', 'IM', 4.42, 24, 0.19, 4.02, 4.81, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.6', 'IM', 3.66, 24, 0.19, 3.26, 4.06, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.7.a', 'IM', 3.22, 24, 0.22, 2.77, 3.67, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.7.b', 'IM', 3.45, 24, 0.28, 2.87, 4.04, 'N', '2005-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.1.a', 'IM', 3.82, 18, 0.20, 3.39, 4.25, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.1.b', 'IM', 3.92, 18, 0.30, 3.28, 4.55, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.1.c', 'IM', 3.89, 18, 0.15, 3.57, 4.20, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.2.b', 'IM', 4.00, 18, 0.32, 3.33, 4.68, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.3.a', 'IM', 4.06, 18, 0.35, 3.31, 4.80, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.3.b', 'IM', 3.65, 18, 0.33, 2.96, 4.34, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.3.c', 'IM', 3.59, 18, 0.33, 2.90, 4.28, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.4.a', 'IM', 4.33, 18, 0.17, 3.97, 4.68, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.4.b', 'IM', 4.45, 18, 0.20, 4.02, 4.87, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.4.c', 'IM', 4.09, 18, 0.31, 3.43, 4.74, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.5.a', 'IM', 4.62, 18, 0.18, 4.24, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.5.b', 'IM', 4.46, 18, 0.18, 4.08, 4.84, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.5.c', 'IM', 4.64, 18, 0.18, 4.26, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.6', 'IM', 4.04, 18, 0.36, 3.27, 4.80, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.7.a', 'IM', 4.06, 18, 0.23, 3.57, 4.54, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.7.b', 'IM', 3.97, 18, 0.35, 3.24, 4.71, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.1.a', 'IM', 4.11, 27, 0.17, 3.75, 4.46, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.1.b', 'IM', 4.26, 27, 0.30, 3.65, 4.87, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.1.c', 'IM', 4.39, 27, 0.16, 4.07, 4.72, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.2.b', 'IM', 4.49, 27, 0.19, 4.11, 4.88, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.3.a', 'IM', 4.57, 27, 0.14, 4.28, 4.86, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.3.b', 'IM', 4.58, 27, 0.14, 4.29, 4.87, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.3.c', 'IM', 4.29, 27, 0.21, 3.86, 4.72, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.4.a', 'IM', 4.40, 27, 0.21, 3.96, 4.84, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.4.b', 'IM', 4.48, 27, 0.26, 3.94, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.4.c', 'IM', 4.36, 27, 0.14, 4.08, 4.65, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.5.a', 'IM', 4.65, 27, 0.11, 4.44, 4.87, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.5.b', 'IM', 4.32, 27, 0.19, 3.93, 4.71, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.5.c', 'IM', 4.86, 27, 0.09, 4.68, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.6', 'IM', 4.46, 27, 0.16, 4.13, 4.78, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.7.a', 'IM', 3.85, 27, 0.20, 3.44, 4.26, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.7.b', 'IM', 4.10, 27, 0.20, 3.69, 4.52, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.1.a', 'IM', 3.85, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.1.b', 'IM', 4.30, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.1.c', 'IM', 4.56, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.2.b', 'IM', 4.52, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.3.a', 'IM', 4.37, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.3.b', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.3.c', 'IM', 3.74, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.4.a', 'IM', 4.41, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.4.b', 'IM', 4.59, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.4.c', 'IM', 4.33, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.5.a', 'IM', 4.81, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.5.b', 'IM', 4.26, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.5.c', 'IM', 4.81, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.6', 'IM', 3.74, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.7.a', 'IM', 3.96, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.7.b', 'IM', 4.44, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.1.a', 'IM', 4.06, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.1.b', 'IM', 4.09, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.1.c', 'IM', 4.33, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.2.b', 'IM', 4.18, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.3.a', 'IM', 4.12, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.3.b', 'IM', 2.97, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.3.c', 'IM', 3.24, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.4.a', 'IM', 4.03, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.4.b', 'IM', 4.15, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.4.c', 'IM', 4.12, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.5.a', 'IM', 4.39, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.5.b', 'IM', 4.79, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.5.c', 'IM', 4.85, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.6', 'IM', 3.70, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.7.a', 'IM', 3.45, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.7.b', 'IM', 4.12, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.1.a', 'IM', 4.12, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.1.b', 'IM', 4.00, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.1.c', 'IM', 4.31, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.2.b', 'IM', 4.19, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.3.a', 'IM', 3.81, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.3.b', 'IM', 3.07, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.3.c', 'IM', 3.00, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.4.a', 'IM', 3.67, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.4.b', 'IM', 4.19, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.4.c', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.5.a', 'IM', 4.52, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.5.b', 'IM', 4.37, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.5.c', 'IM', 4.30, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.6', 'IM', 3.56, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.7.a', 'IM', 3.52, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '1.C.7.b', 'IM', 4.41, 27, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.1.a', 'IM', 4.45, 34, 0.15, 4.14, 4.76, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.1.b', 'IM', 4.54, 34, 0.13, 4.27, 4.81, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.1.c', 'IM', 4.63, 34, 0.12, 4.39, 4.87, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.2.b', 'IM', 4.32, 34, 0.19, 3.94, 4.71, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.3.a', 'IM', 4.39, 34, 0.19, 4.00, 4.79, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.3.b', 'IM', 3.89, 34, 0.21, 3.46, 4.32, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.3.c', 'IM', 4.08, 34, 0.25, 3.56, 4.60, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.4.a', 'IM', 4.03, 34, 0.25, 3.51, 4.55, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.4.b', 'IM', 4.70, 34, 0.12, 4.45, 4.95, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.4.c', 'IM', 4.37, 34, 0.19, 3.99, 4.75, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.5.a', 'IM', 4.50, 34, 0.21, 4.08, 4.92, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.5.b', 'IM', 4.52, 34, 0.14, 4.25, 4.80, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.5.c', 'IM', 4.34, 34, 0.16, 4.02, 4.67, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.6', 'IM', 4.10, 34, 0.22, 3.65, 4.56, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.7.a', 'IM', 4.03, 34, 0.24, 3.55, 4.51, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.7.b', 'IM', 3.98, 34, 0.21, 3.56, 4.41, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.1.a', 'IM', 3.68, 31, 0.20, 3.28, 4.08, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.1.b', 'IM', 3.69, 31, 0.20, 3.29, 4.09, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.1.c', 'IM', 3.87, 31, 0.13, 3.62, 4.13, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.2.b', 'IM', 2.94, 31, 0.35, 2.22, 3.66, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.3.a', 'IM', 4.08, 31, 0.11, 3.85, 4.31, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.3.b', 'IM', 3.48, 31, 0.20, 3.06, 3.89, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.3.c', 'IM', 3.17, 31, 0.31, 2.53, 3.81, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.4.a', 'IM', 4.03, 31, 0.29, 3.44, 4.62, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.4.b', 'IM', 3.92, 31, 0.30, 3.31, 4.53, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.4.c', 'IM', 3.92, 31, 0.14, 3.64, 4.19, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.5.a', 'IM', 4.38, 31, 0.20, 3.98, 4.78, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.5.b', 'IM', 4.25, 31, 0.25, 3.74, 4.75, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.5.c', 'IM', 4.63, 31, 0.16, 4.31, 4.94, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.6', 'IM', 3.33, 31, 0.16, 3.00, 3.67, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.7.a', 'IM', 3.04, 31, 0.27, 2.49, 3.58, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.7.b', 'IM', 3.41, 31, 0.19, 3.02, 3.80, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.1.a', 'IM', 3.60, 24, 0.23, 3.13, 4.07, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.1.b', 'IM', 4.10, 24, 0.15, 3.79, 4.41, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.1.c', 'IM', 4.06, 24, 0.24, 3.58, 4.55, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.2.b', 'IM', 4.18, 24, 0.20, 3.78, 4.59, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.3.a', 'IM', 4.24, 24, 0.11, 4.00, 4.47, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.3.b', 'IM', 3.78, 24, 0.14, 3.50, 4.07, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.3.c', 'IM', 3.79, 24, 0.13, 3.52, 4.05, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.4.a', 'IM', 4.47, 24, 0.14, 4.18, 4.76, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.4.b', 'IM', 4.55, 24, 0.16, 4.22, 4.89, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.4.c', 'IM', 4.03, 24, 0.15, 3.73, 4.33, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.5.a', 'IM', 4.28, 24, 0.19, 3.87, 4.68, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.5.b', 'IM', 4.12, 24, 0.16, 3.79, 4.46, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.5.c', 'IM', 4.61, 24, 0.10, 4.42, 4.81, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.6', 'IM', 3.84, 24, 0.35, 3.11, 4.57, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.7.a', 'IM', 3.57, 24, 0.23, 3.09, 4.04, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.7.b', 'IM', 4.13, 24, 0.23, 3.66, 4.60, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.1.a', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.1.b', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.1.c', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.2.b', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.3.a', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.3.b', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.3.c', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.4.a', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.4.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.4.c', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.5.a', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.5.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.5.c', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.6', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.7.a', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.7.b', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.1.a', 'IM', 3.91, 25, 0.12, 3.66, 4.15, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.1.b', 'IM', 4.25, 25, 0.15, 3.94, 4.55, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.1.c', 'IM', 4.14, 25, 0.13, 3.86, 4.41, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.2.b', 'IM', 3.83, 25, 0.19, 3.43, 4.22, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.3.a', 'IM', 4.32, 25, 0.15, 4.01, 4.62, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.3.b', 'IM', 3.92, 25, 0.24, 3.44, 4.41, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.3.c', 'IM', 3.30, 25, 0.20, 2.89, 3.72, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.4.a', 'IM', 4.38, 25, 0.13, 4.10, 4.66, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.4.b', 'IM', 4.48, 25, 0.09, 4.30, 4.67, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.4.c', 'IM', 4.18, 25, 0.15, 3.88, 4.48, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.5.a', 'IM', 4.53, 25, 0.17, 4.17, 4.88, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.5.b', 'IM', 4.49, 25, 0.09, 4.31, 4.67, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.5.c', 'IM', 4.82, 25, 0.13, 4.55, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.6', 'IM', 4.25, 25, 0.31, 3.61, 4.89, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.7.a', 'IM', 3.52, 25, 0.33, 2.84, 4.20, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '1.C.7.b', 'IM', 4.20, 24, 0.18, 3.83, 4.57, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.1.a', 'IM', 3.97, 32, 0.16, 3.64, 4.29, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.1.b', 'IM', 3.94, 32, 0.16, 3.60, 4.27, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.1.c', 'IM', 4.23, 32, 0.20, 3.82, 4.63, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.2.b', 'IM', 3.33, 32, 0.41, 2.49, 4.16, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.3.a', 'IM', 4.27, 32, 0.23, 3.80, 4.74, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.3.b', 'IM', 3.91, 32, 0.31, 3.28, 4.54, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.3.c', 'IM', 3.37, 31, 0.29, 2.78, 3.95, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.4.a', 'IM', 4.32, 32, 0.27, 3.78, 4.86, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.4.b', 'IM', 4.67, 32, 0.11, 4.44, 4.90, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.4.c', 'IM', 4.08, 32, 0.22, 3.64, 4.52, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.5.a', 'IM', 4.69, 32, 0.10, 4.49, 4.88, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.5.b', 'IM', 4.72, 32, 0.12, 4.47, 4.97, 'N', '2009-06-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.5.c', 'IM', 4.52, 32, 0.27, 3.96, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.6', 'IM', 4.02, 32, 0.21, 3.60, 4.44, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.7.a', 'IM', 2.89, 32, 0.36, 2.16, 3.63, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '1.C.7.b', 'IM', 4.06, 31, 0.21, 3.62, 4.50, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.1.a', 'IM', 3.72, 27, 0.07, 3.58, 3.85, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.1.b', 'IM', 4.03, 27, 0.10, 3.83, 4.23, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.1.c', 'IM', 4.10, 27, 0.10, 3.89, 4.30, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.2.b', 'IM', 3.32, 27, 0.31, 2.68, 3.95, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.3.a', 'IM', 4.10, 27, 0.10, 3.89, 4.30, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.3.b', 'IM', 4.15, 27, 0.14, 3.85, 4.44, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.3.c', 'IM', 3.20, 27, 0.49, 2.19, 4.22, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.4.a', 'IM', 4.51, 27, 0.15, 4.19, 4.82, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.4.b', 'IM', 4.71, 27, 0.08, 4.55, 4.87, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.4.c', 'IM', 4.39, 27, 0.12, 4.14, 4.65, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.5.a', 'IM', 4.75, 27, 0.08, 4.59, 4.91, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.5.b', 'IM', 4.48, 27, 0.14, 4.19, 4.76, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.5.c', 'IM', 4.27, 27, 0.23, 3.80, 4.75, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.6', 'IM', 4.23, 27, 0.11, 4.02, 4.45, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.7.a', 'IM', 3.38, 27, 0.34, 2.69, 4.07, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.7.b', 'IM', 3.77, 27, 0.16, 3.43, 4.11, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.1.a', 'IM', 3.54, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.1.b', 'IM', 3.89, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.1.c', 'IM', 3.84, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.2.b', 'IM', 3.39, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.3.a', 'IM', 3.89, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.3.b', 'IM', 3.18, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.3.c', 'IM', 2.88, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.4.a', 'IM', 4.26, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.4.b', 'IM', 3.96, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.4.c', 'IM', 3.88, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.5.a', 'IM', 4.18, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.5.b', 'IM', 4.30, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.5.c', 'IM', 4.58, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.6', 'IM', 3.77, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.7.a', 'IM', 3.14, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.7.b', 'IM', 4.00, 57, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.1.a', 'IM', 3.92, 36, 0.24, 3.43, 4.40, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.1.b', 'IM', 3.96, 36, 0.18, 3.59, 4.33, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.1.c', 'IM', 3.83, 36, 0.32, 3.17, 4.48, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.2.b', 'IM', 3.76, 36, 0.28, 3.20, 4.32, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.3.a', 'IM', 4.48, 36, 0.19, 4.10, 4.86, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.3.b', 'IM', 4.01, 35, 0.30, 3.40, 4.62, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.3.c', 'IM', 3.97, 36, 0.37, 3.23, 4.72, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.4.a', 'IM', 4.33, 36, 0.21, 3.91, 4.76, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.4.b', 'IM', 4.75, 36, 0.12, 4.50, 4.99, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.4.c', 'IM', 4.27, 36, 0.23, 3.81, 4.74, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.5.a', 'IM', 4.73, 36, 0.13, 4.46, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.5.b', 'IM', 4.49, 36, 0.19, 4.10, 4.87, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.5.c', 'IM', 4.72, 36, 0.13, 4.45, 4.99, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.6', 'IM', 4.29, 36, 0.18, 3.92, 4.66, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.7.a', 'IM', 3.51, 36, 0.24, 3.02, 4.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '1.C.7.b', 'IM', 3.94, 36, 0.28, 3.36, 4.51, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.1.a', 'IM', 4.36, 24, 0.29, 3.77, 4.96, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.1.b', 'IM', 4.41, 24, 0.27, 3.85, 4.96, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.1.c', 'IM', 4.42, 24, 0.19, 4.02, 4.81, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.2.b', 'IM', 3.94, 24, 0.18, 3.57, 4.32, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.3.a', 'IM', 4.65, 24, 0.12, 4.40, 4.90, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.3.b', 'IM', 4.56, 24, 0.17, 4.21, 4.92, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.3.c', 'IM', 3.87, 24, 0.35, 3.16, 4.59, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.4.a', 'IM', 4.68, 24, 0.15, 4.36, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.4.b', 'IM', 4.59, 24, 0.16, 4.26, 4.93, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.4.c', 'IM', 4.49, 24, 0.16, 4.16, 4.81, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.5.a', 'IM', 4.64, 24, 0.11, 4.40, 4.87, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.5.b', 'IM', 4.55, 24, 0.17, 4.20, 4.89, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.5.c', 'IM', 4.82, 24, 0.08, 4.66, 4.98, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.6', 'IM', 4.54, 24, 0.16, 4.20, 4.87, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.7.a', 'IM', 3.64, 24, 0.34, 2.94, 4.34, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.7.b', 'IM', 4.46, 24, 0.22, 4.01, 4.91, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.1.a', 'IM', 3.32, 20, 0.25, 2.80, 3.84, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.1.b', 'IM', 3.08, 20, 0.38, 2.29, 3.87, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.1.c', 'IM', 4.00, 20, 0.00, 4.00, 4.01, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.2.b', 'IM', 3.52, 20, 0.31, 2.86, 4.18, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.3.a', 'IM', 4.46, 20, 0.15, 4.15, 4.77, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.3.b', 'IM', 3.68, 20, 0.46, 2.72, 4.64, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.3.c', 'IM', 2.82, 20, 0.19, 2.43, 3.21, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.4.a', 'IM', 4.22, 20, 0.20, 3.80, 4.63, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.4.b', 'IM', 3.48, 20, 0.62, 2.18, 4.79, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.4.c', 'IM', 4.21, 20, 0.20, 3.79, 4.62, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.5.a', 'IM', 4.75, 20, 0.21, 4.31, 5.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.5.b', 'IM', 4.55, 20, 0.30, 3.92, 5.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.5.c', 'IM', 4.51, 20, 0.31, 3.85, 5.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.6', 'IM', 4.46, 19, 0.15, 4.15, 4.77, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.7.a', 'IM', 3.35, 20, 0.24, 2.85, 3.85, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.7.b', 'IM', 4.05, 20, 0.05, 3.93, 4.16, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.1.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.1.b', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.1.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.2.b', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.3.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.3.b', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.3.c', 'IM', 2.70, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.4.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.4.b', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.4.c', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.5.a', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.5.b', 'IM', 4.70, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.5.c', 'IM', 4.80, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.6', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.7.a', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.7.b', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.1.a', 'IM', 4.03, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.1.b', 'IM', 4.28, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.1.c', 'IM', 4.28, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.2.b', 'IM', 3.81, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.3.a', 'IM', 4.19, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.3.b', 'IM', 3.19, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.3.c', 'IM', 2.88, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.4.a', 'IM', 3.88, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.4.b', 'IM', 4.34, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.4.c', 'IM', 4.41, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.5.a', 'IM', 4.81, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.5.b', 'IM', 4.84, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.5.c', 'IM', 4.94, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.6', 'IM', 3.88, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.7.a', 'IM', 3.50, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.7.b', 'IM', 4.38, 32, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.1.a', 'IM', 3.86, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.1.b', 'IM', 4.04, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.1.c', 'IM', 4.04, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.2.b', 'IM', 3.54, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.3.a', 'IM', 4.04, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.3.b', 'IM', 3.11, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.3.c', 'IM', 2.64, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.4.a', 'IM', 3.68, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.4.b', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.4.c', 'IM', 3.82, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.5.a', 'IM', 4.50, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.5.b', 'IM', 4.79, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.5.c', 'IM', 4.43, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.6', 'IM', 3.82, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.7.a', 'IM', 3.46, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.7.b', 'IM', 4.50, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.1.a', 'IM', 4.00, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.1.b', 'IM', 4.24, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.1.c', 'IM', 4.50, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.2.b', 'IM', 3.76, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.3.a', 'IM', 4.45, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.3.b', 'IM', 4.11, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.3.c', 'IM', 4.03, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.4.a', 'IM', 4.55, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.4.b', 'IM', 4.43, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.4.c', 'IM', 4.47, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.5.a', 'IM', 4.68, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.5.b', 'IM', 4.41, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.5.c', 'IM', 4.67, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.6', 'IM', 3.98, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.7.a', 'IM', 3.75, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.7.b', 'IM', 3.77, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.1.a', 'IM', 4.03, 13, 0.26, 3.46, 4.60, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.1.b', 'IM', 3.88, 13, 0.32, 3.20, 4.57, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.1.c', 'IM', 3.89, 13, 0.32, 3.20, 4.58, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.2.b', 'IM', 3.80, 13, 0.21, 3.33, 4.26, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.3.a', 'IM', 3.98, 13, 0.30, 3.32, 4.64, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.3.b', 'IM', 3.88, 13, 0.32, 3.19, 4.57, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.3.c', 'IM', 3.40, 13, 0.68, 1.91, 4.89, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.4.a', 'IM', 3.65, 13, 0.49, 2.57, 4.72, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.4.b', 'IM', 3.40, 13, 0.48, 2.35, 4.44, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.4.c', 'IM', 3.40, 13, 0.48, 2.36, 4.44, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.5.a', 'IM', 4.16, 13, 0.36, 3.38, 4.95, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.5.b', 'IM', 3.75, 13, 0.35, 2.98, 4.51, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.5.c', 'IM', 4.16, 13, 0.36, 3.37, 4.95, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.6', 'IM', 3.40, 13, 0.48, 2.35, 4.44, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.7.a', 'IM', 2.97, 13, 0.44, 2.02, 3.92, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.7.b', 'IM', 3.31, 13, 0.49, 2.24, 4.38, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.1.a', 'IM', 4.12, 17, 0.22, 3.65, 4.58, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.1.b', 'IM', 4.47, 17, 0.23, 3.97, 4.96, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.1.c', 'IM', 4.35, 17, 0.18, 3.96, 4.74, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.2.b', 'IM', 4.22, 17, 0.34, 3.50, 4.93, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.3.a', 'IM', 4.55, 18, 0.19, 4.15, 4.95, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.3.b', 'IM', 4.11, 18, 0.28, 3.51, 4.71, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.3.c', 'IM', 3.27, 18, 0.54, 2.13, 4.41, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.4.a', 'IM', 4.45, 18, 0.23, 3.97, 4.92, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.4.b', 'IM', 4.34, 18, 0.27, 3.76, 4.92, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.4.c', 'IM', 4.33, 18, 0.18, 3.94, 4.72, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.5.a', 'IM', 4.65, 18, 0.18, 4.26, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.5.b', 'IM', 4.54, 18, 0.23, 4.07, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.5.c', 'IM', 4.67, 18, 0.18, 4.28, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.6', 'IM', 3.46, 18, 0.41, 2.60, 4.33, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.7.a', 'IM', 4.12, 18, 0.22, 3.66, 4.59, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.7.b', 'IM', 4.64, 18, 0.18, 4.26, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.1.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.1.b', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.1.c', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.2.b', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.3.a', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.3.b', 'IM', 3.09, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.3.c', 'IM', 2.91, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.4.a', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.4.b', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.4.c', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.5.a', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.5.b', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.5.c', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.6', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.7.a', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.7.b', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.1.a', 'IM', 4.04, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.1.b', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.1.c', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.2.b', 'IM', 3.84, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.3.a', 'IM', 4.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.3.b', 'IM', 3.12, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.3.c', 'IM', 2.79, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.4.a', 'IM', 3.92, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.4.b', 'IM', 4.00, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.4.c', 'IM', 4.12, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.5.a', 'IM', 4.48, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.5.b', 'IM', 4.56, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.5.c', 'IM', 4.56, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.6', 'IM', 4.12, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.7.a', 'IM', 3.88, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.7.b', 'IM', 4.44, 25, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.1.a', 'IM', 4.10, 19, 0.11, 3.86, 4.34, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.1.b', 'IM', 4.37, 19, 0.19, 3.97, 4.77, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.1.c', 'IM', 4.19, 19, 0.30, 3.57, 4.82, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.2.b', 'IM', 4.39, 19, 0.22, 3.92, 4.86, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.3.a', 'IM', 4.47, 19, 0.22, 4.00, 4.94, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.3.b', 'IM', 4.40, 19, 0.24, 3.88, 4.91, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.3.c', 'IM', 3.90, 19, 0.41, 3.04, 4.76, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.4.a', 'IM', 3.96, 19, 0.30, 3.34, 4.59, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.4.b', 'IM', 4.46, 19, 0.22, 3.99, 4.93, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.4.c', 'IM', 4.53, 19, 0.19, 4.13, 4.93, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.5.a', 'IM', 4.59, 19, 0.18, 4.21, 4.97, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.5.b', 'IM', 4.17, 19, 0.29, 3.57, 4.77, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.5.c', 'IM', 4.42, 19, 0.19, 4.02, 4.82, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.6', 'IM', 3.95, 19, 0.18, 3.57, 4.34, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.7.a', 'IM', 3.88, 19, 0.42, 3.00, 4.76, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.7.b', 'IM', 4.22, 19, 0.15, 3.91, 4.53, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.1.a', 'IM', 4.28, 22, 0.18, 3.91, 4.64, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.1.b', 'IM', 4.04, 22, 0.22, 3.59, 4.49, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.1.c', 'IM', 4.37, 22, 0.15, 4.05, 4.69, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.2.b', 'IM', 3.99, 22, 0.20, 3.58, 4.40, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.3.a', 'IM', 4.63, 22, 0.14, 4.34, 4.93, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.3.b', 'IM', 3.95, 22, 0.24, 3.45, 4.45, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.3.c', 'IM', 3.82, 22, 0.23, 3.33, 4.30, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.4.a', 'IM', 4.04, 22, 0.13, 3.76, 4.31, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.4.b', 'IM', 4.19, 22, 0.21, 3.76, 4.62, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.4.c', 'IM', 3.84, 22, 0.20, 3.43, 4.25, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.5.a', 'IM', 4.41, 22, 0.12, 4.16, 4.66, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.5.b', 'IM', 4.70, 22, 0.10, 4.49, 4.91, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.5.c', 'IM', 4.06, 22, 0.22, 3.60, 4.51, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.6', 'IM', 3.73, 22, 0.19, 3.34, 4.12, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.7.a', 'IM', 3.38, 22, 0.15, 3.06, 3.70, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.7.b', 'IM', 3.27, 22, 0.25, 2.76, 3.78, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.1.a', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.1.b', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.1.c', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.2.b', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.3.a', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.3.b', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.3.c', 'IM', 3.15, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.4.a', 'IM', 3.75, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.4.b', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.4.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.5.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.5.b', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.5.c', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.6', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.7.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.7.b', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.1.a', 'IM', 4.34, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.1.b', 'IM', 4.16, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.1.c', 'IM', 4.50, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.2.b', 'IM', 4.38, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.3.a', 'IM', 4.53, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.3.b', 'IM', 4.16, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.3.c', 'IM', 4.16, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.4.a', 'IM', 4.34, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.4.b', 'IM', 3.97, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.4.c', 'IM', 4.38, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.5.a', 'IM', 4.66, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.5.b', 'IM', 4.59, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.5.c', 'IM', 4.44, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.6', 'IM', 3.88, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.7.a', 'IM', 3.91, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.7.b', 'IM', 4.16, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.1.a', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.1.b', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.1.c', 'IM', 4.42, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.2.b', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.3.a', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.3.b', 'IM', 3.38, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.3.c', 'IM', 3.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.4.a', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.4.b', 'IM', 4.21, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.4.c', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.5.a', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.5.b', 'IM', 4.62, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.5.c', 'IM', 4.71, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.6', 'IM', 4.21, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.7.a', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.7.b', 'IM', 4.67, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.1.a', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.1.b', 'IM', 3.60, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.1.c', 'IM', 4.12, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.2.b', 'IM', 2.96, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.3.a', 'IM', 3.76, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.3.b', 'IM', 3.40, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.3.c', 'IM', 2.38, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.4.a', 'IM', 3.76, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.4.b', 'IM', 3.25, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.4.c', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.5.a', 'IM', 4.52, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.5.b', 'IM', 4.56, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.5.c', 'IM', 4.80, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.6', 'IM', 3.68, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.7.a', 'IM', 3.20, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '1.C.7.b', 'IM', 4.00, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.1.a', 'IM', 3.78, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.1.b', 'IM', 3.65, 26, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.1.c', 'IM', 3.89, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.2.b', 'IM', 3.37, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.3.a', 'IM', 4.04, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.3.b', 'IM', 3.30, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.3.c', 'IM', 3.26, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.4.a', 'IM', 4.04, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.4.b', 'IM', 4.19, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.4.c', 'IM', 3.88, 26, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.5.a', 'IM', 4.37, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.5.b', 'IM', 4.56, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.5.c', 'IM', 4.63, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.6', 'IM', 3.37, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.7.a', 'IM', 3.11, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.03', '1.C.7.b', 'IM', 3.63, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.1.a', 'IM', 4.11, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.1.b', 'IM', 4.24, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.1.c', 'IM', 4.52, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.2.b', 'IM', 4.52, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.3.a', 'IM', 4.62, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.3.b', 'IM', 3.86, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.3.c', 'IM', 3.72, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.4.a', 'IM', 4.10, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.4.b', 'IM', 4.31, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.4.c', 'IM', 4.38, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.5.a', 'IM', 4.45, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.5.b', 'IM', 4.38, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.5.c', 'IM', 4.52, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.6', 'IM', 3.83, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.7.a', 'IM', 3.48, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.7.b', 'IM', 3.93, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.1.a', 'IM', 4.24, 63, 0.12, 3.99, 4.48, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.1.b', 'IM', 4.11, 63, 0.14, 3.82, 4.40, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.1.c', 'IM', 4.21, 63, 0.13, 3.96, 4.46, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.2.b', 'IM', 3.73, 63, 0.12, 3.48, 3.98, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.3.a', 'IM', 4.25, 62, 0.13, 4.00, 4.51, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.3.b', 'IM', 3.68, 62, 0.20, 3.27, 4.08, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.3.c', 'IM', 3.14, 62, 0.21, 2.72, 3.56, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.4.a', 'IM', 3.97, 62, 0.18, 3.62, 4.33, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.4.b', 'IM', 4.12, 62, 0.11, 3.90, 4.35, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.4.c', 'IM', 3.81, 62, 0.19, 3.43, 4.19, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.5.a', 'IM', 4.39, 62, 0.09, 4.21, 4.57, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.5.b', 'IM', 4.81, 62, 0.06, 4.69, 4.94, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.5.c', 'IM', 4.74, 63, 0.09, 4.56, 4.93, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.6', 'IM', 4.11, 63, 0.13, 3.85, 4.38, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.7.a', 'IM', 3.69, 63, 0.14, 3.42, 3.96, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '1.C.7.b', 'IM', 4.35, 63, 0.12, 4.12, 4.58, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.1.a', 'IM', 3.96, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.1.b', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.1.c', 'IM', 4.04, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.2.b', 'IM', 3.92, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.3.a', 'IM', 3.92, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.3.b', 'IM', 3.12, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.3.c', 'IM', 3.08, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.4.a', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.4.b', 'IM', 4.12, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.4.c', 'IM', 3.88, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.5.a', 'IM', 4.40, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.5.b', 'IM', 4.72, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.5.c', 'IM', 4.96, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.6', 'IM', 3.92, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.7.a', 'IM', 3.12, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '1.C.7.b', 'IM', 4.68, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.1.a', 'IM', 3.53, 26, 0.13, 3.26, 3.81, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.1.b', 'IM', 3.55, 26, 0.08, 3.38, 3.71, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.1.c', 'IM', 3.78, 26, 0.17, 3.43, 4.13, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.2.b', 'IM', 3.33, 26, 0.15, 3.01, 3.65, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.3.a', 'IM', 4.02, 26, 0.09, 3.84, 4.20, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.3.b', 'IM', 3.49, 26, 0.14, 3.21, 3.78, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.3.c', 'IM', 3.05, 26, 0.21, 2.61, 3.48, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.4.a', 'IM', 4.37, 26, 0.18, 4.01, 4.73, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.4.b', 'IM', 4.08, 26, 0.17, 3.74, 4.43, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.4.c', 'IM', 3.71, 26, 0.18, 3.35, 4.07, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.5.a', 'IM', 4.18, 26, 0.14, 3.89, 4.48, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.5.b', 'IM', 4.38, 26, 0.13, 4.11, 4.65, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.5.c', 'IM', 4.63, 26, 0.15, 4.33, 4.93, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.6', 'IM', 3.74, 26, 0.22, 3.29, 4.19, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.7.a', 'IM', 3.08, 26, 0.13, 2.82, 3.34, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '1.C.7.b', 'IM', 3.97, 26, 0.11, 3.74, 4.20, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.1.a', 'IM', 3.90, 43, 0.16, 3.58, 4.23, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.1.b', 'IM', 3.79, 43, 0.18, 3.41, 4.16, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.1.c', 'IM', 4.12, 43, 0.14, 3.84, 4.41, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.2.b', 'IM', 3.44, 43, 0.24, 2.96, 3.91, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.3.a', 'IM', 3.82, 42, 0.15, 3.52, 4.12, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.3.b', 'IM', 3.46, 42, 0.19, 3.08, 3.83, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.3.c', 'IM', 2.72, 42, 0.19, 2.33, 3.11, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.4.a', 'IM', 3.95, 42, 0.18, 3.59, 4.31, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.4.b', 'IM', 3.82, 42, 0.16, 3.49, 4.16, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.4.c', 'IM', 3.89, 42, 0.19, 3.51, 4.27, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.5.a', 'IM', 4.64, 42, 0.09, 4.45, 4.83, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.5.b', 'IM', 4.56, 42, 0.10, 4.36, 4.76, 'N', '2005-12-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.5.c', 'IM', 4.86, 43, 0.07, 4.71, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.6', 'IM', 4.10, 43, 0.18, 3.75, 4.46, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.7.a', 'IM', 3.29, 43, 0.20, 2.89, 3.68, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '1.C.7.b', 'IM', 4.41, 43, 0.11, 4.18, 4.65, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.1.a', 'IM', 4.08, 39, 0.12, 3.84, 4.31, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.1.b', 'IM', 4.17, 39, 0.14, 3.90, 4.45, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.1.c', 'IM', 4.19, 39, 0.12, 3.94, 4.44, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.2.b', 'IM', 4.03, 39, 0.19, 3.64, 4.41, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.3.a', 'IM', 4.37, 39, 0.14, 4.10, 4.65, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.3.b', 'IM', 3.55, 39, 0.17, 3.20, 3.90, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.3.c', 'IM', 3.60, 38, 0.14, 3.32, 3.88, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.4.a', 'IM', 4.01, 39, 0.13, 3.74, 4.27, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.4.b', 'IM', 4.09, 39, 0.12, 3.85, 4.32, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.4.c', 'IM', 4.03, 39, 0.18, 3.67, 4.39, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.5.a', 'IM', 4.56, 39, 0.12, 4.31, 4.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.5.b', 'IM', 4.89, 39, 0.05, 4.78, 4.99, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.5.c', 'IM', 4.63, 39, 0.11, 4.41, 4.86, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.6', 'IM', 4.15, 39, 0.22, 3.69, 4.60, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.7.a', 'IM', 3.38, 39, 0.13, 3.11, 3.64, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.7.b', 'IM', 4.56, 39, 0.11, 4.32, 4.79, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.1.a', 'IM', 3.70, 30, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.1.b', 'IM', 3.80, 30, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.1.c', 'IM', 3.93, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.2.b', 'IM', 3.17, 30, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.3.a', 'IM', 3.80, 30, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.3.b', 'IM', 3.13, 30, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.3.c', 'IM', 2.90, 30, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.4.a', 'IM', 4.10, 30, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.4.b', 'IM', 4.03, 30, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.4.c', 'IM', 3.67, 30, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.5.a', 'IM', 4.33, 30, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.5.b', 'IM', 4.53, 30, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.5.c', 'IM', 4.60, 30, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.6', 'IM', 3.67, 30, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.7.a', 'IM', 2.60, 30, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.7.b', 'IM', 4.43, 30, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.1.a', 'IM', 4.24, 21, 0.41, 3.39, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.1.b', 'IM', 4.60, 21, 0.15, 4.29, 4.90, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.1.c', 'IM', 4.52, 21, 0.30, 3.89, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.2.b', 'IM', 3.89, 21, 0.39, 3.07, 4.71, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.3.a', 'IM', 4.09, 21, 0.09, 3.91, 4.27, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.3.b', 'IM', 3.46, 21, 0.34, 2.75, 4.18, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.3.c', 'IM', 3.22, 21, 0.17, 2.87, 3.58, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.4.a', 'IM', 4.02, 21, 0.21, 3.58, 4.46, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.4.b', 'IM', 4.66, 21, 0.14, 4.38, 4.94, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.4.c', 'IM', 4.57, 21, 0.14, 4.27, 4.87, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.5.a', 'IM', 4.62, 21, 0.15, 4.31, 4.94, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.5.b', 'IM', 4.96, 21, 0.02, 4.91, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.5.c', 'IM', 4.60, 21, 0.30, 3.97, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.6', 'IM', 3.41, 21, 0.48, 2.41, 4.41, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.7.a', 'IM', 3.21, 21, 0.30, 2.58, 3.83, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '1.C.7.b', 'IM', 4.57, 21, 0.28, 3.98, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.1.a', 'IM', 4.05, 22, 0.35, 3.33, 4.77, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.1.b', 'IM', 4.38, 22, 0.38, 3.59, 5.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.1.c', 'IM', 4.28, 22, 0.37, 3.51, 5.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.2.b', 'IM', 3.23, 22, 0.23, 2.74, 3.72, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.3.a', 'IM', 3.51, 22, 0.29, 2.91, 4.11, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.3.b', 'IM', 3.82, 21, 0.32, 3.15, 4.49, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.3.c', 'IM', 2.88, 20, 0.39, 2.07, 3.69, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.4.a', 'IM', 3.89, 22, 0.31, 3.25, 4.54, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.4.b', 'IM', 3.92, 21, 0.30, 3.28, 4.55, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.4.c', 'IM', 3.51, 22, 0.37, 2.74, 4.29, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.5.a', 'IM', 4.30, 22, 0.22, 3.85, 4.75, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.5.b', 'IM', 4.42, 22, 0.12, 4.18, 4.66, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.5.c', 'IM', 4.68, 22, 0.16, 4.35, 5.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.6', 'IM', 4.32, 22, 0.14, 4.02, 4.61, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.7.a', 'IM', 3.17, 22, 0.16, 2.85, 3.50, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.7.b', 'IM', 4.07, 22, 0.20, 3.66, 4.47, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.1.a', 'IM', 4.00, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.1.b', 'IM', 3.96, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.1.c', 'IM', 3.96, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.2.b', 'IM', 3.46, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.3.a', 'IM', 4.15, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.3.b', 'IM', 3.27, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.3.c', 'IM', 2.62, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.4.a', 'IM', 4.19, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.4.b', 'IM', 4.15, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.4.c', 'IM', 4.12, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.5.a', 'IM', 4.69, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.5.b', 'IM', 4.85, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.5.c', 'IM', 4.85, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.6', 'IM', 3.88, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.7.a', 'IM', 2.96, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.7.b', 'IM', 4.58, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.1.a', 'IM', 4.15, 26, 0.19, 3.77, 4.53, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.1.b', 'IM', 4.01, 26, 0.21, 3.59, 4.43, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.1.c', 'IM', 3.98, 26, 0.25, 3.47, 4.49, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.2.b', 'IM', 3.85, 26, 0.26, 3.31, 4.40, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.3.a', 'IM', 4.50, 25, 0.14, 4.20, 4.80, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.3.b', 'IM', 3.92, 25, 0.20, 3.50, 4.34, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.3.c', 'IM', 3.22, 25, 0.22, 2.77, 3.67, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.4.a', 'IM', 3.75, 25, 0.22, 3.29, 4.21, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.4.b', 'IM', 3.96, 24, 0.38, 3.16, 4.75, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.4.c', 'IM', 4.11, 25, 0.17, 3.75, 4.47, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.5.a', 'IM', 4.30, 25, 0.19, 3.91, 4.69, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.5.b', 'IM', 4.65, 25, 0.21, 4.21, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.5.c', 'IM', 4.71, 26, 0.13, 4.45, 4.98, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.6', 'IM', 4.09, 26, 0.24, 3.59, 4.59, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.7.a', 'IM', 3.58, 26, 0.22, 3.13, 4.02, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.7.b', 'IM', 4.50, 26, 0.14, 4.21, 4.78, 'N', '2005-12-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.1.a', 'IM', 3.90, 16, 0.53, 2.76, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.1.b', 'IM', 3.90, 16, 0.53, 2.76, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.1.c', 'IM', 4.39, 16, 0.28, 3.78, 4.99, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.2.b', 'IM', 3.61, 16, 0.77, 1.97, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.3.a', 'IM', 4.25, 16, 0.53, 3.12, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.3.b', 'IM', 4.24, 16, 0.53, 3.11, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.3.c', 'IM', 4.13, 16, 0.52, 3.03, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.4.a', 'IM', 4.13, 16, 0.52, 3.02, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.4.b', 'IM', 4.60, 16, 0.26, 4.04, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.4.c', 'IM', 4.54, 16, 0.27, 3.98, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.5.a', 'IM', 4.25, 16, 0.53, 3.13, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.5.b', 'IM', 4.21, 16, 0.52, 3.10, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.5.c', 'IM', 4.64, 16, 0.27, 4.08, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.6', 'IM', 3.70, 16, 0.77, 2.06, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.7.a', 'IM', 3.83, 16, 0.52, 2.71, 4.94, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '1.C.7.b', 'IM', 4.05, 16, 0.51, 2.96, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.1.a', 'IM', 4.34, 37, 0.12, 4.11, 4.58, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.1.b', 'IM', 4.11, 37, 0.14, 3.82, 4.39, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.1.c', 'IM', 4.28, 37, 0.12, 4.05, 4.52, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.2.b', 'IM', 3.86, 37, 0.25, 3.36, 4.36, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.3.a', 'IM', 4.12, 37, 0.14, 3.84, 4.40, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.3.b', 'IM', 3.92, 37, 0.16, 3.59, 4.25, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.3.c', 'IM', 3.78, 37, 0.16, 3.45, 4.11, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.4.a', 'IM', 4.17, 37, 0.12, 3.93, 4.42, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.4.b', 'IM', 4.41, 37, 0.15, 4.10, 4.72, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.4.c', 'IM', 4.04, 37, 0.17, 3.69, 4.39, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.5.a', 'IM', 4.34, 37, 0.12, 4.09, 4.59, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.5.b', 'IM', 4.41, 37, 0.10, 4.21, 4.62, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.5.c', 'IM', 4.66, 37, 0.08, 4.50, 4.81, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.6', 'IM', 3.98, 37, 0.19, 3.60, 4.36, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.7.a', 'IM', 3.65, 37, 0.21, 3.22, 4.07, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.7.b', 'IM', 4.24, 37, 0.14, 3.96, 4.52, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.1.a', 'IM', 4.09, 39, 0.13, 3.83, 4.35, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.1.b', 'IM', 3.91, 39, 0.15, 3.60, 4.22, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.1.c', 'IM', 4.18, 39, 0.13, 3.92, 4.43, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.2.b', 'IM', 3.82, 39, 0.20, 3.40, 4.23, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.3.a', 'IM', 4.31, 39, 0.14, 4.02, 4.60, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.3.b', 'IM', 4.04, 39, 0.15, 3.74, 4.34, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.3.c', 'IM', 3.80, 39, 0.27, 3.25, 4.35, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.4.a', 'IM', 4.52, 39, 0.09, 4.34, 4.70, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.4.b', 'IM', 4.37, 39, 0.16, 4.04, 4.69, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.4.c', 'IM', 4.22, 39, 0.12, 3.96, 4.47, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.5.a', 'IM', 4.40, 39, 0.15, 4.09, 4.71, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.5.b', 'IM', 4.43, 39, 0.17, 4.09, 4.77, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.5.c', 'IM', 4.71, 39, 0.12, 4.47, 4.95, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.6', 'IM', 4.45, 39, 0.17, 4.10, 4.80, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.7.a', 'IM', 3.77, 39, 0.17, 3.43, 4.10, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.7.b', 'IM', 4.38, 37, 0.17, 4.03, 4.72, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.1.a', 'IM', 3.71, 33, 0.34, 3.02, 4.40, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.1.b', 'IM', 3.82, 33, 0.11, 3.60, 4.05, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.1.c', 'IM', 4.07, 33, 0.18, 3.70, 4.44, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.2.b', 'IM', 3.11, 33, 0.26, 2.58, 3.65, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.3.a', 'IM', 4.20, 33, 0.13, 3.93, 4.48, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.3.b', 'IM', 3.49, 33, 0.31, 2.86, 4.12, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.3.c', 'IM', 2.94, 33, 0.34, 2.24, 3.64, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.4.a', 'IM', 4.36, 33, 0.09, 4.18, 4.53, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.4.b', 'IM', 4.31, 33, 0.12, 4.06, 4.56, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.4.c', 'IM', 3.71, 33, 0.20, 3.30, 4.11, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.5.a', 'IM', 4.37, 32, 0.15, 4.06, 4.67, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.5.b', 'IM', 4.59, 33, 0.16, 4.26, 4.92, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.5.c', 'IM', 4.63, 33, 0.15, 4.33, 4.94, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.6', 'IM', 4.00, 33, 0.24, 3.52, 4.49, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.7.a', 'IM', 2.91, 32, 0.21, 2.47, 3.34, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.7.b', 'IM', 4.25, 31, 0.27, 3.69, 4.81, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.1.a', 'IM', 4.09, 44, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.1.b', 'IM', 4.00, 45, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.1.c', 'IM', 4.20, 44, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.2.b', 'IM', 3.91, 45, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.3.a', 'IM', 4.15, 46, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.3.b', 'IM', 3.00, 46, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.3.c', 'IM', 3.04, 46, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.4.a', 'IM', 3.93, 46, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.4.b', 'IM', 4.09, 46, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.4.c', 'IM', 4.04, 46, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.5.a', 'IM', 4.48, 46, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.5.b', 'IM', 4.65, 46, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.5.c', 'IM', 4.63, 46, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.6', 'IM', 3.96, 46, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.7.a', 'IM', 3.63, 46, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.02', '1.C.7.b', 'IM', 4.63, 46, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.1.a', 'IM', 4.12, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.1.b', 'IM', 4.59, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.1.c', 'IM', 4.50, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.2.b', 'IM', 3.97, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.3.a', 'IM', 4.25, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.3.b', 'IM', 3.53, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.3.c', 'IM', 3.16, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.4.a', 'IM', 4.47, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.4.b', 'IM', 4.50, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.4.c', 'IM', 4.34, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.5.a', 'IM', 4.59, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.5.b', 'IM', 4.81, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.5.c', 'IM', 4.94, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.6', 'IM', 4.25, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.7.a', 'IM', 4.00, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.7.b', 'IM', 4.72, 32, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.1.a', 'IM', 4.49, 25, 0.15, 4.17, 4.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.1.b', 'IM', 4.63, 25, 0.21, 4.19, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.1.c', 'IM', 4.87, 25, 0.06, 4.74, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.2.b', 'IM', 3.97, 25, 0.35, 3.26, 4.69, 'N', '2008-06-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.3.a', 'IM', 4.20, 25, 0.39, 3.40, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.3.b', 'IM', 4.02, 25, 0.20, 3.62, 4.43, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.3.c', 'IM', 3.40, 25, 0.45, 2.48, 4.33, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.4.a', 'IM', 3.70, 25, 0.53, 2.60, 4.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.4.b', 'IM', 4.30, 25, 0.38, 3.52, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.4.c', 'IM', 4.45, 25, 0.26, 3.91, 4.98, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.5.a', 'IM', 4.43, 25, 0.22, 3.97, 4.89, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.5.b', 'IM', 3.90, 25, 0.18, 3.53, 4.27, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.5.c', 'IM', 4.23, 25, 0.28, 3.64, 4.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.6', 'IM', 4.49, 25, 0.16, 4.17, 4.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.7.a', 'IM', 4.06, 25, 0.24, 3.57, 4.55, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '1.C.7.b', 'IM', 4.14, 25, 0.24, 3.65, 4.63, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.1.a', 'IM', 3.87, 44, 0.09, 3.69, 4.05, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.1.b', 'IM', 4.05, 44, 0.14, 3.77, 4.32, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.1.c', 'IM', 4.11, 44, 0.12, 3.87, 4.36, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.2.b', 'IM', 3.40, 44, 0.36, 2.68, 4.13, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.3.a', 'IM', 4.30, 44, 0.16, 3.98, 4.62, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.3.b', 'IM', 3.78, 44, 0.23, 3.31, 4.25, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.3.c', 'IM', 3.62, 44, 0.26, 3.10, 4.15, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.4.a', 'IM', 3.93, 44, 0.23, 3.46, 4.40, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.4.b', 'IM', 4.06, 44, 0.11, 3.84, 4.28, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.4.c', 'IM', 4.50, 44, 0.12, 4.26, 4.75, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.5.a', 'IM', 4.59, 44, 0.12, 4.36, 4.83, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.5.b', 'IM', 4.78, 44, 0.08, 4.62, 4.94, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.5.c', 'IM', 4.58, 44, 0.11, 4.36, 4.80, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.6', 'IM', 3.99, 44, 0.22, 3.54, 4.44, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.7.a', 'IM', 4.34, 43, 0.17, 4.00, 4.69, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '1.C.7.b', 'IM', 4.71, 44, 0.12, 4.48, 4.94, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.1.a', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.1.b', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.1.c', 'IM', 4.74, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.2.b', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.3.a', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.3.b', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.3.c', 'IM', 3.52, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.4.a', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.4.b', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.4.c', 'IM', 4.70, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.5.a', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.5.b', 'IM', 4.70, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.5.c', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.6', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.7.a', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.01', '1.C.7.b', 'IM', 4.61, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.1.a', 'IM', 3.99, 26, 0.19, 3.59, 4.39, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.1.b', 'IM', 4.25, 26, 0.17, 3.90, 4.60, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.1.c', 'IM', 4.50, 26, 0.17, 4.14, 4.86, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.2.b', 'IM', 4.06, 25, 0.27, 3.51, 4.61, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.3.a', 'IM', 4.11, 26, 0.26, 3.58, 4.64, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.3.b', 'IM', 3.17, 26, 0.37, 2.42, 3.93, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.3.c', 'IM', 3.29, 26, 0.30, 2.68, 3.90, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.4.a', 'IM', 4.19, 26, 0.27, 3.64, 4.75, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.4.b', 'IM', 4.50, 26, 0.17, 4.15, 4.85, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.4.c', 'IM', 4.14, 26, 0.26, 3.60, 4.68, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.5.a', 'IM', 4.43, 26, 0.16, 4.10, 4.77, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.5.b', 'IM', 4.31, 26, 0.16, 3.98, 4.64, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.5.c', 'IM', 4.73, 26, 0.13, 4.46, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.6', 'IM', 3.52, 26, 0.53, 2.42, 4.62, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.7.a', 'IM', 3.52, 25, 0.42, 2.65, 4.38, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1122.00', '1.C.7.b', 'IM', 4.57, 26, 0.17, 4.22, 4.92, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.1.a', 'IM', 4.10, 28, 0.28, 3.53, 4.66, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.1.b', 'IM', 3.95, 28, 0.29, 3.36, 4.54, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.1.c', 'IM', 4.16, 28, 0.23, 3.69, 4.62, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.2.b', 'IM', 3.65, 28, 0.24, 3.16, 4.13, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.3.a', 'IM', 4.04, 28, 0.21, 3.61, 4.47, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.3.b', 'IM', 3.11, 28, 0.28, 2.53, 3.70, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.3.c', 'IM', 2.80, 28, 0.21, 2.38, 3.23, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.4.a', 'IM', 3.60, 28, 0.29, 3.00, 4.20, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.4.b', 'IM', 3.96, 28, 0.21, 3.53, 4.38, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.4.c', 'IM', 3.94, 28, 0.24, 3.44, 4.43, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.5.a', 'IM', 3.75, 28, 0.17, 3.40, 4.11, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.5.b', 'IM', 4.30, 28, 0.19, 3.91, 4.69, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.5.c', 'IM', 3.70, 28, 0.22, 3.25, 4.15, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.6', 'IM', 3.77, 28, 0.27, 3.21, 4.34, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.7.a', 'IM', 3.76, 28, 0.34, 3.06, 4.46, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1131.00', '1.C.7.b', 'IM', 4.35, 28, 0.23, 3.88, 4.81, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.1.a', 'IM', 3.88, 27, 0.10, 3.69, 4.08, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.1.b', 'IM', 3.82, 27, 0.22, 3.37, 4.26, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.1.c', 'IM', 3.72, 27, 0.32, 3.05, 4.38, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.2.b', 'IM', 3.82, 27, 0.22, 3.36, 4.28, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.3.a', 'IM', 3.90, 27, 0.21, 3.47, 4.32, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.3.b', 'IM', 2.93, 27, 0.30, 2.31, 3.56, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.3.c', 'IM', 2.94, 27, 0.28, 2.37, 3.52, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.4.a', 'IM', 3.36, 27, 0.32, 2.69, 4.02, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.4.b', 'IM', 3.60, 27, 0.32, 2.93, 4.26, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.4.c', 'IM', 3.60, 27, 0.20, 3.19, 4.01, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.5.a', 'IM', 4.25, 27, 0.25, 3.74, 4.75, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.5.b', 'IM', 4.34, 27, 0.17, 3.99, 4.70, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.5.c', 'IM', 3.64, 27, 0.36, 2.90, 4.38, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.6', 'IM', 3.84, 27, 0.23, 3.37, 4.30, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.7.a', 'IM', 4.04, 26, 0.16, 3.71, 4.37, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1132.00', '1.C.7.b', 'IM', 4.46, 27, 0.14, 4.17, 4.75, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.1.a', 'IM', 4.02, 42, 0.12, 3.78, 4.27, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.1.b', 'IM', 4.05, 42, 0.13, 3.78, 4.32, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.1.c', 'IM', 4.12, 42, 0.12, 3.89, 4.36, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.2.b', 'IM', 3.54, 42, 0.29, 2.95, 4.13, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.3.a', 'IM', 3.99, 42, 0.17, 3.64, 4.33, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.3.b', 'IM', 3.27, 42, 0.24, 2.78, 3.76, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.3.c', 'IM', 2.99, 42, 0.24, 2.51, 3.47, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.4.a', 'IM', 3.59, 42, 0.28, 3.02, 4.15, 'N', '2009-06-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.4.b', 'IM', 3.87, 42, 0.20, 3.47, 4.27, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.4.c', 'IM', 3.85, 42, 0.25, 3.35, 4.35, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.5.a', 'IM', 3.90, 42, 0.15, 3.59, 4.21, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.5.b', 'IM', 4.33, 42, 0.07, 4.19, 4.46, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.5.c', 'IM', 3.33, 42, 0.22, 2.88, 3.78, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.6', 'IM', 4.11, 42, 0.15, 3.80, 4.41, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.7.a', 'IM', 3.72, 42, 0.19, 3.34, 4.09, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1133.00', '1.C.7.b', 'IM', 4.27, 42, 0.15, 3.97, 4.57, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.1.a', 'IM', 4.00, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.1.b', 'IM', 3.93, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.1.c', 'IM', 4.17, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.2.b', 'IM', 3.33, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.3.a', 'IM', 4.03, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.3.b', 'IM', 3.17, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.3.c', 'IM', 2.43, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.4.a', 'IM', 3.67, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.4.b', 'IM', 4.00, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.4.c', 'IM', 4.07, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.5.a', 'IM', 4.28, 29, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.5.b', 'IM', 4.60, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.5.c', 'IM', 4.23, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.6', 'IM', 3.87, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.7.a', 'IM', 3.97, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1134.00', '1.C.7.b', 'IM', 4.37, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.1.a', 'IM', 3.99, 26, 0.11, 3.76, 4.23, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.1.b', 'IM', 4.07, 26, 0.11, 3.84, 4.29, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.1.c', 'IM', 4.13, 26, 0.16, 3.81, 4.46, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.2.b', 'IM', 2.89, 26, 0.21, 2.46, 3.31, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.3.a', 'IM', 3.94, 26, 0.22, 3.49, 4.39, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.3.b', 'IM', 3.67, 26, 0.22, 3.22, 4.12, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.3.c', 'IM', 3.10, 26, 0.20, 2.70, 3.51, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.4.a', 'IM', 3.81, 26, 0.18, 3.44, 4.18, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.4.b', 'IM', 4.12, 26, 0.21, 3.68, 4.56, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.4.c', 'IM', 4.14, 26, 0.17, 3.80, 4.49, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.5.a', 'IM', 4.36, 26, 0.12, 4.12, 4.60, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.5.b', 'IM', 4.47, 26, 0.12, 4.22, 4.72, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.5.c', 'IM', 4.44, 26, 0.25, 3.93, 4.95, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.6', 'IM', 3.97, 26, 0.09, 3.78, 4.16, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.7.a', 'IM', 4.02, 26, 0.22, 3.56, 4.48, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1141.00', '1.C.7.b', 'IM', 4.37, 26, 0.10, 4.16, 4.58, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.1.a', 'IM', 3.91, 18, 0.14, 3.61, 4.20, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.1.b', 'IM', 3.94, 18, 0.14, 3.65, 4.22, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.1.c', 'IM', 4.00, 18, 0.10, 3.79, 4.21, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.2.b', 'IM', 2.84, 18, 0.44, 1.91, 3.78, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.3.a', 'IM', 4.69, 18, 0.18, 4.31, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.3.b', 'IM', 3.31, 18, 0.20, 2.89, 3.73, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.3.c', 'IM', 2.54, 17, 0.29, 1.92, 3.16, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.4.a', 'IM', 4.42, 17, 0.29, 3.80, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.4.b', 'IM', 4.04, 17, 0.13, 3.77, 4.31, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.4.c', 'IM', 4.64, 17, 0.21, 4.19, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.5.a', 'IM', 4.70, 17, 0.17, 4.35, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.5.b', 'IM', 4.67, 18, 0.19, 4.28, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.5.c', 'IM', 4.54, 18, 0.25, 4.01, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.6', 'IM', 2.82, 18, 0.42, 1.93, 3.72, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.7.a', 'IM', 3.41, 18, 0.23, 2.94, 3.89, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1142.00', '1.C.7.b', 'IM', 4.62, 18, 0.22, 4.16, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.1.a', 'IM', 3.76, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.1.b', 'IM', 3.98, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.1.c', 'IM', 4.19, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.2.b', 'IM', 3.47, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.3.a', 'IM', 4.10, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.3.b', 'IM', 3.25, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.3.c', 'IM', 2.67, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.4.a', 'IM', 3.60, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.4.b', 'IM', 3.90, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.4.c', 'IM', 4.24, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.5.a', 'IM', 4.40, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.5.b', 'IM', 4.55, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.5.c', 'IM', 4.23, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.6', 'IM', 3.85, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.7.a', 'IM', 3.44, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1143.00', '1.C.7.b', 'IM', 4.35, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.1.a', 'IM', 3.91, 47, 0.28, 3.34, 4.48, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.1.b', 'IM', 4.18, 47, 0.18, 3.83, 4.54, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.1.c', 'IM', 4.20, 47, 0.18, 3.85, 4.56, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.2.b', 'IM', 3.48, 47, 0.27, 2.93, 4.03, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.3.a', 'IM', 4.33, 46, 0.13, 4.07, 4.59, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.3.b', 'IM', 3.89, 46, 0.18, 3.52, 4.26, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.3.c', 'IM', 3.16, 46, 0.34, 2.46, 3.85, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.4.a', 'IM', 3.88, 46, 0.19, 3.49, 4.27, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.4.b', 'IM', 4.14, 46, 0.13, 3.87, 4.40, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.4.c', 'IM', 4.00, 46, 0.26, 3.49, 4.52, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.5.a', 'IM', 4.51, 46, 0.10, 4.32, 4.71, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.5.b', 'IM', 4.34, 46, 0.11, 4.12, 4.56, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.5.c', 'IM', 4.24, 47, 0.33, 3.59, 4.90, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.6', 'IM', 3.79, 47, 0.10, 3.59, 4.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.7.a', 'IM', 3.34, 46, 0.21, 2.92, 3.76, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1151.00', '1.C.7.b', 'IM', 4.27, 47, 0.15, 3.96, 4.57, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.1.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.1.b', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.1.c', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.2.b', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.3.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.3.b', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.3.c', 'IM', 2.91, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.4.a', 'IM', 3.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.4.b', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.4.c', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.5.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.5.b', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.5.c', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.6', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.7.a', 'IM', 3.32, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.01', '1.C.7.b', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.1.a', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.1.b', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.1.c', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.2.b', 'IM', 3.52, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.3.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.3.b', 'IM', 2.96, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.3.c', 'IM', 2.74, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.4.a', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.4.b', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.4.c', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.5.a', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.5.b', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.5.c', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.6', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.7.a', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.02', '1.C.7.b', 'IM', 4.70, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.1.a', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.1.b', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.1.c', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.2.b', 'IM', 3.35, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.3.a', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.3.b', 'IM', 2.91, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.3.c', 'IM', 2.26, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.4.a', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.4.b', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.4.c', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.5.a', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.5.b', 'IM', 4.52, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.5.c', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.6', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.7.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.03', '1.C.7.b', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.1.a', 'IM', 3.82, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.1.b', 'IM', 4.00, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.1.c', 'IM', 4.04, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.2.b', 'IM', 3.43, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.3.a', 'IM', 4.00, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.3.b', 'IM', 3.00, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.3.c', 'IM', 2.89, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.4.a', 'IM', 3.50, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.4.b', 'IM', 3.32, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.4.c', 'IM', 3.64, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.5.a', 'IM', 4.21, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.5.b', 'IM', 4.46, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.5.c', 'IM', 4.32, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.6', 'IM', 3.82, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.7.a', 'IM', 3.93, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.04', '1.C.7.b', 'IM', 4.61, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.1.a', 'IM', 3.71, 18, 0.15, 3.39, 4.03, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.1.b', 'IM', 4.18, 18, 0.12, 3.92, 4.44, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.1.c', 'IM', 4.29, 18, 0.22, 3.82, 4.75, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.2.b', 'IM', 3.20, 18, 0.23, 2.70, 3.69, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.3.a', 'IM', 3.88, 18, 0.28, 3.29, 4.46, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.3.b', 'IM', 3.30, 18, 0.14, 3.00, 3.59, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.3.c', 'IM', 2.73, 18, 0.33, 2.03, 3.42, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.4.a', 'IM', 3.38, 18, 0.27, 2.81, 3.96, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.4.b', 'IM', 3.36, 18, 0.17, 3.00, 3.71, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.4.c', 'IM', 3.98, 18, 0.06, 3.85, 4.11, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.5.a', 'IM', 4.20, 18, 0.33, 3.51, 4.90, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.5.b', 'IM', 4.58, 18, 0.20, 4.16, 4.99, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.5.c', 'IM', 4.27, 18, 0.13, 4.00, 4.54, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.6', 'IM', 4.65, 18, 0.14, 4.34, 4.95, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.7.a', 'IM', 4.60, 18, 0.14, 4.32, 4.89, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1199.05', '1.C.7.b', 'IM', 4.72, 18, 0.11, 4.49, 4.95, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.1.a', 'IM', 4.30, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.1.b', 'IM', 4.18, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.1.c', 'IM', 4.27, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.2.b', 'IM', 3.82, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.3.a', 'IM', 3.79, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.3.b', 'IM', 2.73, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.3.c', 'IM', 2.36, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.4.a', 'IM', 3.30, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.4.b', 'IM', 3.55, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.4.c', 'IM', 3.76, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.5.a', 'IM', 4.48, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.5.b', 'IM', 4.64, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.5.c', 'IM', 4.70, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.6', 'IM', 3.64, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.7.a', 'IM', 3.52, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.7.b', 'IM', 4.85, 33, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.1.a', 'IM', 4.48, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.1.b', 'IM', 4.30, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.1.c', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.2.b', 'IM', 2.52, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.3.a', 'IM', 3.22, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.3.b', 'IM', 2.33, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.3.c', 'IM', 2.19, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.4.a', 'IM', 2.48, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.4.b', 'IM', 2.67, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.4.c', 'IM', 3.26, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.5.a', 'IM', 3.67, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.5.b', 'IM', 4.63, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.5.c', 'IM', 4.11, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.6', 'IM', 4.04, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.7.a', 'IM', 4.63, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.7.b', 'IM', 4.81, 27, NULL, NULL, NULL, NULL, '2005-12-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.1.a', 'IM', 4.48, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.1.b', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.1.c', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.2.b', 'IM', 3.44, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.3.a', 'IM', 3.59, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.3.b', 'IM', 2.85, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.3.c', 'IM', 2.70, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.4.a', 'IM', 3.11, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.4.b', 'IM', 3.52, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.4.c', 'IM', 3.78, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.5.a', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.5.b', 'IM', 4.41, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.5.c', 'IM', 4.15, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.6', 'IM', 3.70, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.7.a', 'IM', 4.41, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.7.b', 'IM', 4.85, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.1.a', 'IM', 3.58, 28, 0.41, 2.74, 4.43, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.1.b', 'IM', 4.11, 28, 0.26, 3.58, 4.64, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.1.c', 'IM', 4.24, 28, 0.13, 3.97, 4.51, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.2.b', 'IM', 2.83, 28, 0.35, 2.11, 3.55, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.3.a', 'IM', 4.61, 28, 0.16, 4.28, 4.95, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.3.b', 'IM', 3.33, 28, 0.24, 2.83, 3.82, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.3.c', 'IM', 3.00, 28, 0.32, 2.35, 3.65, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.4.a', 'IM', 3.93, 28, 0.25, 3.41, 4.45, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.4.b', 'IM', 3.28, 28, 0.24, 2.78, 3.77, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.4.c', 'IM', 3.86, 28, 0.31, 3.24, 4.49, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.5.a', 'IM', 4.25, 28, 0.26, 3.71, 4.78, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.5.b', 'IM', 4.74, 28, 0.16, 4.42, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.5.c', 'IM', 4.21, 27, 0.45, 3.28, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.6', 'IM', 4.28, 28, 0.13, 4.01, 4.55, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.7.a', 'IM', 4.04, 28, 0.20, 3.63, 4.46, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.7.b', 'IM', 4.93, 28, 0.06, 4.80, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.1.a', 'IM', 4.06, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.1.b', 'IM', 4.03, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.1.c', 'IM', 4.06, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.2.b', 'IM', 3.58, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.3.a', 'IM', 3.87, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.3.b', 'IM', 2.90, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.3.c', 'IM', 2.58, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.4.a', 'IM', 3.39, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.4.b', 'IM', 3.55, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.4.c', 'IM', 3.81, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.5.a', 'IM', 4.32, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.5.b', 'IM', 4.71, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.5.c', 'IM', 4.81, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.6', 'IM', 3.87, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.7.a', 'IM', 3.55, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.7.b', 'IM', 4.84, 31, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.1.a', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.1.b', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.1.c', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.2.b', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.3.a', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.3.b', 'IM', 2.91, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.3.c', 'IM', 3.00, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.4.a', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.4.b', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.4.c', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.5.a', 'IM', 4.41, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.5.b', 'IM', 4.91, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.5.c', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.6', 'IM', 3.00, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.7.a', 'IM', 2.82, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.02', '1.C.7.b', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.1.a', 'IM', 4.19, 24, 0.12, 3.95, 4.43, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.1.b', 'IM', 4.37, 24, 0.15, 4.07, 4.67, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.1.c', 'IM', 4.54, 24, 0.11, 4.32, 4.76, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.2.b', 'IM', 4.15, 24, 0.11, 3.93, 4.37, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.3.a', 'IM', 4.37, 24, 0.19, 3.97, 4.77, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.3.b', 'IM', 3.86, 24, 0.18, 3.50, 4.22, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.3.c', 'IM', 3.72, 24, 0.10, 3.52, 3.92, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.4.a', 'IM', 4.19, 24, 0.14, 3.91, 4.48, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.4.b', 'IM', 4.31, 24, 0.26, 3.78, 4.84, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.4.c', 'IM', 4.21, 24, 0.16, 3.89, 4.54, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.5.a', 'IM', 4.61, 24, 0.10, 4.41, 4.82, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.5.b', 'IM', 4.77, 24, 0.13, 4.50, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.5.c', 'IM', 4.25, 24, 0.22, 3.80, 4.71, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.6', 'IM', 3.48, 24, 0.18, 3.11, 3.85, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.7.a', 'IM', 4.24, 24, 0.16, 3.90, 4.58, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.7.b', 'IM', 4.59, 24, 0.10, 4.39, 4.80, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.1.a', 'IM', 4.14, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.1.b', 'IM', 3.83, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.1.c', 'IM', 4.31, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.2.b', 'IM', 3.97, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.3.a', 'IM', 4.31, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.3.b', 'IM', 3.52, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.3.c', 'IM', 3.52, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.4.a', 'IM', 4.03, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.4.b', 'IM', 4.31, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.4.c', 'IM', 4.21, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.5.a', 'IM', 4.45, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.5.b', 'IM', 4.62, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.5.c', 'IM', 4.72, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.6', 'IM', 3.59, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.7.a', 'IM', 4.28, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.7.b', 'IM', 4.38, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.1.a', 'IM', 3.91, 36, 0.19, 3.53, 4.29, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.1.b', 'IM', 3.52, 36, 0.16, 3.19, 3.84, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.1.c', 'IM', 3.76, 36, 0.26, 3.24, 4.28, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.2.b', 'IM', 3.18, 36, 0.29, 2.59, 3.77, 'N', '2010-06-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.3.a', 'IM', 4.03, 36, 0.16, 3.70, 4.35, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.3.b', 'IM', 3.21, 36, 0.19, 2.83, 3.59, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.3.c', 'IM', 2.88, 36, 0.19, 2.49, 3.26, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.4.a', 'IM', 3.12, 36, 0.20, 2.70, 3.53, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.4.b', 'IM', 3.22, 36, 0.19, 2.83, 3.60, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.4.c', 'IM', 3.23, 36, 0.23, 2.76, 3.71, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.5.a', 'IM', 4.28, 36, 0.16, 3.94, 4.61, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.5.b', 'IM', 4.87, 36, 0.07, 4.73, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.5.c', 'IM', 3.83, 36, 0.24, 3.34, 4.32, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.6', 'IM', 3.70, 36, 0.29, 3.11, 4.28, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.7.a', 'IM', 3.44, 36, 0.24, 2.95, 3.92, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.7.b', 'IM', 3.80, 36, 0.28, 3.24, 4.36, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.1.a', 'IM', 4.06, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.1.b', 'IM', 4.21, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.1.c', 'IM', 4.24, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.2.b', 'IM', 4.12, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.3.a', 'IM', 4.09, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.3.b', 'IM', 3.36, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.3.c', 'IM', 3.12, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.4.a', 'IM', 4.03, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.4.b', 'IM', 3.82, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.4.c', 'IM', 3.82, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.5.a', 'IM', 4.45, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.5.b', 'IM', 4.94, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.5.c', 'IM', 4.73, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.6', 'IM', 3.97, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.7.a', 'IM', 3.70, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.7.b', 'IM', 4.61, 33, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.1.a', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.1.b', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.1.c', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.2.b', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.3.a', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.3.b', 'IM', 3.25, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.3.c', 'IM', 2.75, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.4.a', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.4.b', 'IM', 3.25, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.4.c', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.5.a', 'IM', 4.46, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.5.b', 'IM', 4.79, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.5.c', 'IM', 4.54, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.6', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.7.a', 'IM', 3.38, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.7.b', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.1.a', 'IM', 4.37, 32, 0.19, 3.98, 4.76, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.1.b', 'IM', 4.44, 32, 0.13, 4.18, 4.70, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.1.c', 'IM', 4.40, 32, 0.15, 4.10, 4.70, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.2.b', 'IM', 4.05, 32, 0.20, 3.63, 4.46, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.3.a', 'IM', 4.27, 33, 0.17, 3.91, 4.62, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.3.b', 'IM', 3.25, 33, 0.24, 2.75, 3.75, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.3.c', 'IM', 3.06, 33, 0.18, 2.69, 3.43, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.4.a', 'IM', 3.68, 33, 0.23, 3.20, 4.16, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.4.b', 'IM', 4.16, 33, 0.15, 3.86, 4.46, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.4.c', 'IM', 4.14, 33, 0.25, 3.64, 4.64, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.5.a', 'IM', 4.51, 33, 0.08, 4.35, 4.68, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.5.b', 'IM', 4.64, 33, 0.13, 4.39, 4.90, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.5.c', 'IM', 4.30, 33, 0.16, 3.96, 4.63, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.6', 'IM', 3.94, 33, 0.12, 3.70, 4.19, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.7.a', 'IM', 4.42, 33, 0.19, 4.04, 4.80, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.7.b', 'IM', 4.50, 33, 0.11, 4.27, 4.72, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.1.a', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.1.b', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.1.c', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.2.b', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.3.a', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.3.b', 'IM', 2.87, 23, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.3.c', 'IM', 2.61, 23, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.4.a', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.4.b', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.4.c', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.5.a', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.5.b', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.5.c', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.6', 'IM', 3.57, 23, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.7.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.7.b', 'IM', 4.48, 23, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.1.a', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.1.b', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.1.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.2.b', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.3.a', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.3.b', 'IM', 2.85, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.3.c', 'IM', 2.30, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.4.a', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.4.b', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.4.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.5.a', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.5.b', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.5.c', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.6', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.7.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.7.b', 'IM', 4.42, 19, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.1.a', 'IM', 4.12, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.1.b', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.1.c', 'IM', 4.28, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.2.b', 'IM', 3.84, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.3.a', 'IM', 3.92, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.3.b', 'IM', 3.08, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.3.c', 'IM', 2.88, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.4.a', 'IM', 3.76, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.4.b', 'IM', 3.84, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.4.c', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.5.a', 'IM', 4.48, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.5.b', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.5.c', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.6', 'IM', 3.52, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.7.a', 'IM', 3.88, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.7.b', 'IM', 4.56, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.1.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.1.b', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.1.c', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.2.b', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.3.a', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.3.b', 'IM', 3.38, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.3.c', 'IM', 2.86, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.4.a', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.4.b', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.4.c', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.5.a', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.5.b', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.5.c', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.6', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.7.a', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.7.b', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.1.a', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.1.b', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.1.c', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.2.b', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.3.a', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.3.b', 'IM', 3.17, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.3.c', 'IM', 2.88, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.4.a', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.4.b', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.4.c', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.5.a', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.5.b', 'IM', 4.62, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.5.c', 'IM', 4.54, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.6', 'IM', 3.38, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.7.a', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.7.b', 'IM', 4.71, 24, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.1.a', 'IM', 3.85, 17, 0.35, 3.11, 4.59, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.1.b', 'IM', 4.35, 17, 0.18, 3.97, 4.73, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.1.c', 'IM', 4.27, 17, 0.19, 3.87, 4.67, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.2.b', 'IM', 3.91, 17, 0.31, 3.25, 4.58, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.3.a', 'IM', 4.15, 16, 0.31, 3.49, 4.82, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.3.b', 'IM', 4.07, 16, 0.33, 3.37, 4.76, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.3.c', 'IM', 3.01, 16, 0.66, 1.60, 4.42, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.4.a', 'IM', 3.93, 16, 0.31, 3.26, 4.60, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.4.b', 'IM', 3.96, 16, 0.31, 3.29, 4.63, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.4.c', 'IM', 3.93, 16, 0.31, 3.27, 4.60, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.5.a', 'IM', 3.93, 16, 0.32, 3.25, 4.61, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.5.b', 'IM', 4.28, 16, 0.19, 3.88, 4.69, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.5.c', 'IM', 4.12, 17, 0.31, 3.45, 4.79, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.6', 'IM', 4.06, 17, 0.24, 3.56, 4.56, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.7.a', 'IM', 3.99, 17, 0.26, 3.44, 4.53, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.7.b', 'IM', 4.26, 17, 0.19, 3.86, 4.66, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.1.a', 'IM', 4.01, 44, 0.11, 3.80, 4.22, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.1.b', 'IM', 4.38, 44, 0.09, 4.20, 4.56, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.1.c', 'IM', 4.36, 44, 0.10, 4.17, 4.56, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.2.b', 'IM', 4.02, 44, 0.12, 3.77, 4.27, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.3.a', 'IM', 4.30, 44, 0.14, 4.02, 4.59, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.3.b', 'IM', 3.61, 44, 0.19, 3.22, 3.99, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.3.c', 'IM', 3.51, 44, 0.14, 3.23, 3.79, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.4.a', 'IM', 3.79, 44, 0.10, 3.59, 3.98, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.4.b', 'IM', 4.06, 42, 0.08, 3.90, 4.21, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.4.c', 'IM', 4.13, 44, 0.11, 3.90, 4.36, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.5.a', 'IM', 4.39, 44, 0.09, 4.21, 4.56, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.5.b', 'IM', 4.69, 44, 0.14, 4.41, 4.97, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.5.c', 'IM', 4.37, 44, 0.09, 4.20, 4.54, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.6', 'IM', 4.08, 44, 0.09, 3.90, 4.27, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.7.a', 'IM', 3.89, 44, 0.14, 3.60, 4.17, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.7.b', 'IM', 4.54, 44, 0.10, 4.34, 4.74, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.1.a', 'IM', 3.41, 30, 0.26, 2.88, 3.93, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.1.b', 'IM', 3.85, 30, 0.28, 3.27, 4.43, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.1.c', 'IM', 3.77, 30, 0.20, 3.35, 4.18, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.2.b', 'IM', 3.36, 30, 0.21, 2.94, 3.79, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.3.a', 'IM', 4.11, 30, 0.26, 3.57, 4.65, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.3.b', 'IM', 3.22, 30, 0.12, 2.97, 3.47, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.3.c', 'IM', 2.71, 30, 0.18, 2.34, 3.08, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.4.a', 'IM', 3.41, 30, 0.18, 3.05, 3.78, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.4.b', 'IM', 3.73, 30, 0.11, 3.52, 3.95, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.4.c', 'IM', 3.75, 30, 0.21, 3.32, 4.17, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.5.a', 'IM', 4.03, 30, 0.16, 3.70, 4.37, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.5.b', 'IM', 4.53, 30, 0.18, 4.17, 4.90, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.5.c', 'IM', 3.95, 30, 0.23, 3.47, 4.43, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.6', 'IM', 3.92, 30, 0.17, 3.58, 4.27, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.7.a', 'IM', 3.75, 30, 0.31, 3.11, 4.39, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.7.b', 'IM', 4.20, 30, 0.18, 3.84, 4.57, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.1.a', 'IM', 4.04, 17, 0.16, 3.69, 4.38, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.1.b', 'IM', 3.85, 17, 0.17, 3.49, 4.20, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.1.c', 'IM', 3.92, 17, 0.22, 3.46, 4.39, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.2.b', 'IM', 3.64, 17, 0.20, 3.22, 4.06, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.3.a', 'IM', 4.06, 17, 0.16, 3.74, 4.39, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.3.b', 'IM', 3.25, 17, 0.17, 2.89, 3.62, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.3.c', 'IM', 3.34, 17, 0.23, 2.85, 3.84, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.4.a', 'IM', 3.49, 17, 0.25, 2.95, 4.02, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.4.b', 'IM', 3.86, 17, 0.28, 3.27, 4.44, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.4.c', 'IM', 4.26, 17, 0.17, 3.90, 4.63, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.5.a', 'IM', 4.68, 17, 0.21, 4.24, 5.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.5.b', 'IM', 4.88, 17, 0.10, 4.66, 5.00, 'N', '2008-06-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.5.c', 'IM', 4.47, 17, 0.19, 4.07, 4.86, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.6', 'IM', 3.50, 17, 0.12, 3.25, 3.75, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.7.a', 'IM', 3.75, 17, 0.29, 3.13, 4.38, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.7.b', 'IM', 4.32, 17, 0.20, 3.89, 4.75, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.1.a', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.1.b', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.1.c', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.2.b', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.3.a', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.3.b', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.3.c', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.4.a', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.4.b', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.4.c', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.5.a', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.5.b', 'IM', 4.64, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.5.c', 'IM', 4.73, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.6', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.7.a', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.01', '1.C.7.b', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.1.a', 'IM', 3.75, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.1.b', 'IM', 3.75, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.1.c', 'IM', 4.07, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.2.b', 'IM', 3.43, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.3.a', 'IM', 3.71, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.3.b', 'IM', 2.93, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.3.c', 'IM', 3.00, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.4.a', 'IM', 3.46, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.4.b', 'IM', 3.75, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.4.c', 'IM', 3.71, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.5.a', 'IM', 4.29, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.5.b', 'IM', 4.39, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.5.c', 'IM', 4.46, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.6', 'IM', 3.75, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.7.a', 'IM', 3.50, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.7.b', 'IM', 4.32, 28, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.1.a', 'IM', 3.76, 29, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.1.b', 'IM', 4.03, 29, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.1.c', 'IM', 4.03, 29, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.2.b', 'IM', 3.59, 29, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.3.a', 'IM', 3.82, 28, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.3.b', 'IM', 3.14, 29, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.3.c', 'IM', 3.07, 29, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.4.a', 'IM', 3.86, 29, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.4.b', 'IM', 3.90, 29, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.4.c', 'IM', 3.55, 29, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.5.a', 'IM', 4.38, 29, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.5.b', 'IM', 4.48, 29, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.5.c', 'IM', 4.69, 29, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.6', 'IM', 3.72, 29, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.7.a', 'IM', 3.41, 29, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.03', '1.C.7.b', 'IM', 4.21, 29, NULL, NULL, NULL, NULL, '2007-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.1.a', 'IM', 4.22, 31, 0.15, 3.92, 4.53, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.1.b', 'IM', 4.36, 31, 0.15, 4.06, 4.66, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.1.c', 'IM', 4.47, 31, 0.13, 4.20, 4.74, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.2.b', 'IM', 4.07, 31, 0.22, 3.63, 4.52, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.3.a', 'IM', 4.38, 30, 0.15, 4.07, 4.68, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.3.b', 'IM', 3.81, 30, 0.21, 3.37, 4.24, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.3.c', 'IM', 3.49, 30, 0.18, 3.13, 3.85, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.4.a', 'IM', 4.29, 30, 0.20, 3.87, 4.70, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.4.b', 'IM', 4.29, 30, 0.18, 3.92, 4.66, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.4.c', 'IM', 4.17, 30, 0.20, 3.77, 4.58, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.5.a', 'IM', 4.64, 30, 0.09, 4.46, 4.82, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.5.b', 'IM', 4.70, 30, 0.09, 4.52, 4.89, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.5.c', 'IM', 4.52, 31, 0.15, 4.21, 4.83, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.6', 'IM', 4.07, 31, 0.16, 3.74, 4.40, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.7.a', 'IM', 4.14, 31, 0.16, 3.81, 4.47, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.7.b', 'IM', 4.45, 30, 0.13, 4.19, 4.72, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.1.a', 'IM', 3.73, 17, 0.33, 3.02, 4.44, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.1.b', 'IM', 4.22, 17, 0.14, 3.92, 4.52, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.1.c', 'IM', 4.32, 17, 0.16, 3.98, 4.67, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.2.b', 'IM', 4.23, 17, 0.17, 3.87, 4.59, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.3.a', 'IM', 3.99, 17, 0.27, 3.42, 4.57, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.3.b', 'IM', 3.42, 17, 0.17, 3.06, 3.79, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.3.c', 'IM', 2.91, 17, 0.20, 2.49, 3.34, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.4.a', 'IM', 4.00, 17, 0.28, 3.42, 4.59, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.4.b', 'IM', 3.87, 17, 0.24, 3.36, 4.38, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.4.c', 'IM', 4.05, 17, 0.17, 3.70, 4.40, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.5.a', 'IM', 4.44, 17, 0.16, 4.10, 4.77, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.5.b', 'IM', 4.36, 17, 0.24, 3.86, 4.87, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.5.c', 'IM', 4.95, 17, 0.04, 4.87, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.6', 'IM', 4.16, 17, 0.23, 3.68, 4.64, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.7.a', 'IM', 3.97, 17, 0.25, 3.45, 4.50, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.01', '1.C.7.b', 'IM', 4.58, 17, 0.18, 4.21, 4.96, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.1.a', 'IM', 3.54, 23, 0.36, 2.79, 4.29, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.1.b', 'IM', 3.83, 23, 0.31, 3.18, 4.48, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.1.c', 'IM', 4.04, 23, 0.24, 3.54, 4.54, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.2.b', 'IM', 3.52, 23, 0.42, 2.64, 4.40, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.3.a', 'IM', 4.25, 23, 0.20, 3.84, 4.67, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.3.b', 'IM', 3.20, 23, 0.33, 2.51, 3.89, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.3.c', 'IM', 2.66, 23, 0.48, 1.65, 3.67, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.4.a', 'IM', 3.54, 23, 0.23, 3.06, 4.03, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.4.b', 'IM', 3.49, 23, 0.21, 3.06, 3.91, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.4.c', 'IM', 3.91, 22, 0.17, 3.55, 4.27, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.5.a', 'IM', 4.27, 23, 0.27, 3.70, 4.83, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.5.b', 'IM', 4.58, 23, 0.12, 4.34, 4.82, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.5.c', 'IM', 4.40, 23, 0.21, 3.97, 4.83, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.6', 'IM', 3.76, 23, 0.30, 3.13, 4.39, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.7.a', 'IM', 3.77, 23, 0.29, 3.16, 4.37, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.02', '1.C.7.b', 'IM', 4.44, 22, 0.16, 4.10, 4.77, 'N', '2006-06-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.1.a', 'IM', 3.79, 20, 0.31, 3.14, 4.45, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.1.b', 'IM', 3.68, 20, 0.26, 3.14, 4.21, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.1.c', 'IM', 3.66, 20, 0.19, 3.27, 4.06, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.2.b', 'IM', 3.19, 20, 0.37, 2.42, 3.96, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.3.a', 'IM', 3.66, 20, 0.28, 3.08, 4.25, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.3.b', 'IM', 2.83, 20, 0.33, 2.13, 3.53, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.3.c', 'IM', 2.32, 20, 0.26, 1.78, 2.86, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.4.a', 'IM', 3.11, 19, 0.36, 2.37, 3.86, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.4.b', 'IM', 3.52, 20, 0.22, 3.06, 3.98, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.4.c', 'IM', 3.44, 20, 0.30, 2.81, 4.07, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.5.a', 'IM', 4.32, 20, 0.18, 3.94, 4.70, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.5.b', 'IM', 4.31, 20, 0.28, 3.73, 4.89, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.5.c', 'IM', 4.20, 20, 0.29, 3.58, 4.82, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.6', 'IM', 3.05, 20, 0.20, 2.63, 3.47, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.7.a', 'IM', 3.54, 20, 0.34, 2.82, 4.26, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.7.b', 'IM', 4.35, 20, 0.28, 3.77, 4.94, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.1.a', 'IM', 3.85, 41, 0.18, 3.48, 4.21, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.1.b', 'IM', 4.07, 41, 0.21, 3.64, 4.50, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.1.c', 'IM', 4.10, 41, 0.13, 3.84, 4.36, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.2.b', 'IM', 3.77, 41, 0.26, 3.25, 4.28, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.3.a', 'IM', 4.07, 39, 0.16, 3.75, 4.39, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.3.b', 'IM', 3.57, 40, 0.19, 3.19, 3.96, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.3.c', 'IM', 2.84, 40, 0.15, 2.53, 3.14, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.4.a', 'IM', 3.65, 40, 0.21, 3.23, 4.07, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.4.b', 'IM', 3.89, 40, 0.18, 3.53, 4.25, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.4.c', 'IM', 4.00, 40, 0.12, 3.74, 4.25, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.5.a', 'IM', 4.36, 40, 0.09, 4.17, 4.55, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.5.b', 'IM', 4.55, 40, 0.12, 4.31, 4.79, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.5.c', 'IM', 3.85, 41, 0.15, 3.55, 4.15, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.6', 'IM', 3.85, 41, 0.18, 3.48, 4.21, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.7.a', 'IM', 4.02, 41, 0.10, 3.81, 4.23, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.7.b', 'IM', 4.42, 41, 0.11, 4.19, 4.65, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.1.a', 'IM', 3.77, 24, 0.20, 3.36, 4.18, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.1.b', 'IM', 3.96, 24, 0.13, 3.70, 4.22, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.1.c', 'IM', 4.35, 24, 0.12, 4.11, 4.59, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.2.b', 'IM', 3.73, 24, 0.16, 3.41, 4.06, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.3.a', 'IM', 3.72, 24, 0.22, 3.26, 4.18, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.3.b', 'IM', 3.02, 24, 0.25, 2.51, 3.53, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.3.c', 'IM', 2.75, 23, 0.25, 2.24, 3.25, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.4.a', 'IM', 3.83, 24, 0.17, 3.47, 4.18, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.4.b', 'IM', 4.05, 24, 0.21, 3.62, 4.48, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.4.c', 'IM', 3.95, 24, 0.08, 3.79, 4.10, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.5.a', 'IM', 4.33, 24, 0.13, 4.05, 4.60, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.5.b', 'IM', 4.36, 24, 0.13, 4.10, 4.63, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.5.c', 'IM', 4.09, 24, 0.18, 3.72, 4.46, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.6', 'IM', 4.19, 24, 0.19, 3.79, 4.58, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.7.a', 'IM', 3.96, 24, 0.22, 3.50, 4.42, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.7.b', 'IM', 4.37, 24, 0.19, 3.97, 4.76, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.1.a', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.1.b', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.1.c', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.2.b', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.3.a', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.3.b', 'IM', 3.14, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.3.c', 'IM', 2.59, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.4.a', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.4.b', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.4.c', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.5.a', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.5.b', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.5.c', 'IM', 4.68, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.6', 'IM', 3.23, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.7.a', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.7.b', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.1.a', 'IM', 4.20, 35, 0.19, 3.81, 4.59, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.1.b', 'IM', 4.02, 35, 0.18, 3.65, 4.39, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.1.c', 'IM', 4.20, 35, 0.12, 3.97, 4.44, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.2.b', 'IM', 3.82, 35, 0.17, 3.47, 4.17, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.3.a', 'IM', 4.32, 35, 0.23, 3.86, 4.78, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.3.b', 'IM', 3.07, 35, 0.29, 2.48, 3.65, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.3.c', 'IM', 3.03, 35, 0.20, 2.62, 3.44, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.4.a', 'IM', 3.33, 35, 0.27, 2.79, 3.87, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.4.b', 'IM', 3.89, 35, 0.23, 3.42, 4.37, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.4.c', 'IM', 4.00, 35, 0.15, 3.71, 4.30, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.5.a', 'IM', 4.30, 35, 0.15, 4.00, 4.61, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.5.b', 'IM', 4.17, 35, 0.27, 3.63, 4.72, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.5.c', 'IM', 4.29, 35, 0.13, 4.03, 4.55, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.6', 'IM', 4.13, 35, 0.17, 3.79, 4.47, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.7.a', 'IM', 4.05, 34, 0.28, 3.49, 4.61, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.7.b', 'IM', 4.51, 35, 0.16, 4.18, 4.85, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.1.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.1.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.1.c', 'IM', 3.80, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.2.b', 'IM', 3.15, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.3.a', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.3.b', 'IM', 2.90, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.3.c', 'IM', 2.38, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.4.a', 'IM', 3.38, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.4.b', 'IM', 3.38, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.4.c', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.5.a', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.5.b', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.5.c', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.6', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.7.a', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.01', '1.C.7.b', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.1.a', 'IM', 3.86, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.1.b', 'IM', 4.03, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.1.c', 'IM', 4.10, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.2.b', 'IM', 3.76, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.3.a', 'IM', 4.17, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.3.b', 'IM', 3.28, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.3.c', 'IM', 2.90, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.4.a', 'IM', 4.00, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.4.b', 'IM', 4.10, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.4.c', 'IM', 3.97, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.5.a', 'IM', 4.21, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.5.b', 'IM', 4.55, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.5.c', 'IM', 4.69, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.6', 'IM', 3.72, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.7.a', 'IM', 3.55, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.02', '1.C.7.b', 'IM', 4.45, 29, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.1.a', 'IM', 3.73, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.1.b', 'IM', 3.88, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.1.c', 'IM', 4.27, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.2.b', 'IM', 3.58, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.3.a', 'IM', 4.19, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.3.b', 'IM', 3.00, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.3.c', 'IM', 2.85, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.4.a', 'IM', 3.35, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.4.b', 'IM', 3.54, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.4.c', 'IM', 3.96, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.5.a', 'IM', 4.38, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.5.b', 'IM', 4.46, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.5.c', 'IM', 4.54, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.6', 'IM', 3.73, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.7.a', 'IM', 3.77, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.7.b', 'IM', 4.65, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.1.a', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.1.b', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.1.c', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.2.b', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.3.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.3.b', 'IM', 3.24, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.3.c', 'IM', 3.05, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.4.a', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.4.b', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.4.c', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.5.a', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.5.b', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.5.c', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.6', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.7.a', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.04', '1.C.7.b', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.1.a', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.1.b', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.1.c', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.2.b', 'IM', 3.25, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.3.a', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.3.b', 'IM', 2.96, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.3.c', 'IM', 2.58, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.4.a', 'IM', 3.38, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.4.b', 'IM', 3.46, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.4.c', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.5.a', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.5.b', 'IM', 4.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.5.c', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.6', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.7.a', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.7.b', 'IM', 4.54, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.1.a', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.1.b', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.1.c', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.2.b', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.3.a', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.3.b', 'IM', 3.25, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.3.c', 'IM', 2.95, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.4.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.4.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.4.c', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.5.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.5.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.5.c', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.6', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.7.a', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.7.b', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.1.a', 'IM', 4.12, 20, 0.12, 3.87, 4.37, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.1.b', 'IM', 3.84, 20, 0.20, 3.41, 4.26, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.1.c', 'IM', 4.13, 20, 0.23, 3.64, 4.62, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.2.b', 'IM', 3.42, 20, 0.43, 2.52, 4.33, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.3.a', 'IM', 4.14, 20, 0.25, 3.61, 4.67, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.3.b', 'IM', 3.35, 20, 0.29, 2.74, 3.95, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.3.c', 'IM', 3.39, 20, 0.40, 2.54, 4.23, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.4.a', 'IM', 3.36, 20, 0.27, 2.80, 3.92, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.4.b', 'IM', 3.91, 20, 0.20, 3.49, 4.32, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.4.c', 'IM', 4.09, 20, 0.16, 3.74, 4.43, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.5.a', 'IM', 4.26, 20, 0.24, 3.76, 4.76, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.5.b', 'IM', 4.76, 20, 0.15, 4.45, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.5.c', 'IM', 4.35, 19, 0.29, 3.74, 4.96, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.6', 'IM', 3.60, 20, 0.27, 3.03, 4.17, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.7.a', 'IM', 4.09, 20, 0.37, 3.32, 4.87, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.01', '1.C.7.b', 'IM', 3.98, 20, 0.28, 3.40, 4.56, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.1.a', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.1.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.1.c', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.2.b', 'IM', 3.24, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.3.a', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.3.b', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.3.c', 'IM', 2.95, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.4.a', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.4.b', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.4.c', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.5.a', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.5.b', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.5.c', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.6', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.7.a', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.02', '1.C.7.b', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.1.a', 'IM', 4.21, 19, 0.13, 3.93, 4.48, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.1.b', 'IM', 3.89, 19, 0.27, 3.33, 4.46, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.1.c', 'IM', 3.93, 19, 0.20, 3.51, 4.36, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.2.b', 'IM', 2.95, 19, 0.31, 2.30, 3.59, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.3.a', 'IM', 3.65, 19, 0.28, 3.06, 4.23, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.3.b', 'IM', 3.48, 19, 0.36, 2.72, 4.24, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.3.c', 'IM', 3.12, 19, 0.40, 2.28, 3.95, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.4.a', 'IM', 3.67, 19, 0.16, 3.33, 4.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.4.b', 'IM', 3.96, 19, 0.27, 3.40, 4.53, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.4.c', 'IM', 3.93, 19, 0.28, 3.35, 4.51, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.5.a', 'IM', 4.09, 19, 0.21, 3.65, 4.53, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.5.b', 'IM', 4.64, 19, 0.12, 4.38, 4.90, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.5.c', 'IM', 3.30, 19, 0.52, 2.22, 4.38, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.6', 'IM', 3.56, 19, 0.27, 3.00, 4.12, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.7.a', 'IM', 3.05, 19, 0.45, 2.10, 4.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.01', '1.C.7.b', 'IM', 3.76, 19, 0.32, 3.08, 4.43, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.1.a', 'IM', 3.21, 18, 0.19, 2.81, 3.60, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.1.b', 'IM', 2.84, 18, 0.43, 1.94, 3.74, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.1.c', 'IM', 3.43, 18, 0.30, 2.79, 4.08, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.2.b', 'IM', 3.83, 18, 0.24, 3.33, 4.33, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.3.a', 'IM', 4.51, 18, 0.29, 3.91, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.3.b', 'IM', 4.05, 18, 0.49, 3.02, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.3.c', 'IM', 3.23, 18, 0.19, 2.83, 3.64, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.4.a', 'IM', 3.04, 18, 0.51, 1.96, 4.12, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.4.b', 'IM', 3.41, 18, 0.25, 2.87, 3.94, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.4.c', 'IM', 3.47, 18, 0.24, 2.95, 3.98, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.5.a', 'IM', 4.20, 18, 0.20, 3.78, 4.62, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.5.b', 'IM', 4.75, 18, 0.18, 4.36, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.5.c', 'IM', 4.80, 18, 0.13, 4.53, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.6', 'IM', 3.82, 18, 0.27, 3.24, 4.40, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.7.a', 'IM', 3.43, 18, 0.23, 2.95, 3.91, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.02', '1.C.7.b', 'IM', 3.37, 18, 0.20, 2.94, 3.80, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.1.a', 'IM', 3.48, 32, 0.16, 3.14, 3.81, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.1.b', 'IM', 3.67, 32, 0.14, 3.37, 3.96, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.1.c', 'IM', 3.89, 32, 0.14, 3.60, 4.17, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.2.b', 'IM', 3.39, 32, 0.19, 3.01, 3.78, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.3.a', 'IM', 3.90, 32, 0.13, 3.63, 4.16, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.3.b', 'IM', 3.14, 32, 0.24, 2.65, 3.63, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.3.c', 'IM', 2.82, 31, 0.18, 2.46, 3.18, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.4.a', 'IM', 3.52, 32, 0.20, 3.11, 3.94, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.4.b', 'IM', 3.88, 32, 0.14, 3.60, 4.16, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.4.c', 'IM', 3.76, 32, 0.14, 3.48, 4.04, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.5.a', 'IM', 4.19, 32, 0.12, 3.93, 4.44, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.5.b', 'IM', 4.69, 32, 0.10, 4.47, 4.90, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.5.c', 'IM', 3.91, 32, 0.17, 3.57, 4.25, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.6', 'IM', 3.24, 32, 0.29, 2.64, 3.83, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.7.a', 'IM', 3.76, 32, 0.21, 3.33, 4.18, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.7.b', 'IM', 4.10, 32, 0.16, 3.78, 4.43, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.1.a', 'IM', 4.58, 25, 0.25, 4.06, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.1.b', 'IM', 4.76, 25, 0.15, 4.45, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.1.c', 'IM', 4.85, 25, 0.11, 4.63, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.2.b', 'IM', 4.47, 25, 0.17, 4.11, 4.82, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.3.a', 'IM', 4.69, 25, 0.19, 4.31, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.3.b', 'IM', 3.76, 25, 0.44, 2.85, 4.67, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.3.c', 'IM', 3.17, 25, 0.14, 2.88, 3.46, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.4.a', 'IM', 3.93, 25, 0.08, 3.76, 4.11, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.4.b', 'IM', 4.18, 25, 0.21, 3.75, 4.61, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.4.c', 'IM', 4.59, 25, 0.25, 4.07, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.5.a', 'IM', 4.80, 25, 0.14, 4.51, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.5.b', 'IM', 4.94, 25, 0.05, 4.84, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.5.c', 'IM', 4.88, 25, 0.08, 4.72, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.6', 'IM', 4.24, 25, 0.44, 3.34, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.7.a', 'IM', 4.14, 25, 0.47, 3.18, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.7.b', 'IM', 4.44, 25, 0.29, 3.85, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.1.a', 'IM', 3.45, 31, 0.10, 3.25, 3.65, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.1.b', 'IM', 3.64, 31, 0.19, 3.25, 4.02, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.1.c', 'IM', 3.56, 31, 0.09, 3.38, 3.75, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.2.b', 'IM', 2.75, 31, 0.37, 2.00, 3.51, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.3.a', 'IM', 4.01, 31, 0.22, 3.55, 4.46, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.3.b', 'IM', 3.24, 31, 0.18, 2.86, 3.61, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.3.c', 'IM', 3.43, 31, 0.24, 2.95, 3.92, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.4.a', 'IM', 3.61, 31, 0.19, 3.22, 4.01, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.4.b', 'IM', 3.64, 31, 0.19, 3.26, 4.02, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.4.c', 'IM', 3.82, 31, 0.31, 3.19, 4.44, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.5.a', 'IM', 4.19, 31, 0.16, 3.85, 4.52, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.5.b', 'IM', 3.90, 31, 0.13, 3.63, 4.16, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.5.c', 'IM', 4.00, 31, 0.24, 3.51, 4.50, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.6', 'IM', 3.61, 31, 0.22, 3.16, 4.07, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.7.a', 'IM', 2.84, 31, 0.16, 2.51, 3.17, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.7.b', 'IM', 3.83, 30, 0.24, 3.35, 4.32, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.1.a', 'IM', 3.43, 18, 0.23, 2.96, 3.91, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.1.b', 'IM', 3.55, 18, 0.28, 2.96, 4.14, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.1.c', 'IM', 3.84, 18, 0.25, 3.33, 4.36, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.2.b', 'IM', 3.12, 18, 0.42, 2.24, 4.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.3.a', 'IM', 3.98, 18, 0.22, 3.51, 4.46, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.3.b', 'IM', 3.22, 18, 0.24, 2.70, 3.74, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.3.c', 'IM', 2.89, 18, 0.31, 2.22, 3.55, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.4.a', 'IM', 3.31, 18, 0.29, 2.70, 3.91, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.4.b', 'IM', 3.19, 18, 0.32, 2.52, 3.86, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.4.c', 'IM', 3.59, 18, 0.26, 3.05, 4.13, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.5.a', 'IM', 4.02, 18, 0.18, 3.63, 4.41, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.5.b', 'IM', 3.91, 18, 0.23, 3.42, 4.40, 'N', '2008-06-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.5.c', 'IM', 3.79, 18, 0.17, 3.43, 4.14, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.6', 'IM', 3.52, 18, 0.20, 3.08, 3.95, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.7.a', 'IM', 3.49, 18, 0.28, 2.90, 4.07, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.01', '1.C.7.b', 'IM', 3.59, 18, 0.30, 2.95, 4.22, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.1.a', 'IM', 3.61, 31, 0.20, 3.20, 4.02, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.1.b', 'IM', 3.76, 31, 0.39, 2.97, 4.55, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.1.c', 'IM', 4.14, 30, 0.20, 3.73, 4.54, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.2.b', 'IM', 3.24, 31, 0.29, 2.66, 3.82, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.3.a', 'IM', 4.00, 31, 0.25, 3.50, 4.51, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.3.b', 'IM', 3.49, 31, 0.21, 3.07, 3.91, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.3.c', 'IM', 2.85, 31, 0.17, 2.50, 3.21, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.4.a', 'IM', 4.07, 31, 0.19, 3.69, 4.45, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.4.b', 'IM', 3.76, 31, 0.30, 3.14, 4.39, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.4.c', 'IM', 3.72, 31, 0.30, 3.11, 4.33, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.5.a', 'IM', 4.30, 31, 0.29, 3.70, 4.90, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.5.b', 'IM', 4.31, 31, 0.15, 4.00, 4.63, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.5.c', 'IM', 4.01, 31, 0.27, 3.46, 4.57, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.6', 'IM', 4.28, 31, 0.21, 3.86, 4.70, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.7.a', 'IM', 3.91, 31, 0.27, 3.36, 4.45, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.03', '1.C.7.b', 'IM', 4.37, 31, 0.19, 3.99, 4.76, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.1.a', 'IM', 3.37, 23, 0.43, 2.49, 4.26, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.1.b', 'IM', 4.16, 23, 0.20, 3.74, 4.57, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.1.c', 'IM', 4.30, 23, 0.17, 3.94, 4.66, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.2.b', 'IM', 2.96, 23, 0.32, 2.29, 3.63, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.3.a', 'IM', 4.37, 23, 0.14, 4.08, 4.65, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.3.b', 'IM', 4.39, 23, 0.21, 3.95, 4.82, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.3.c', 'IM', 3.15, 23, 0.31, 2.50, 3.79, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.4.a', 'IM', 4.14, 23, 0.15, 3.82, 4.46, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.4.b', 'IM', 3.79, 23, 0.38, 3.01, 4.57, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.4.c', 'IM', 4.07, 22, 0.14, 3.78, 4.36, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.5.a', 'IM', 4.24, 23, 0.14, 3.96, 4.53, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.5.b', 'IM', 4.88, 23, 0.07, 4.74, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.5.c', 'IM', 4.32, 23, 0.37, 3.55, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.6', 'IM', 4.21, 23, 0.16, 3.88, 4.53, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.7.a', 'IM', 3.38, 23, 0.41, 2.53, 4.24, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.7.b', 'IM', 4.01, 23, 0.27, 3.44, 4.58, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.1.a', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.1.b', 'IM', 4.21, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.1.c', 'IM', 4.07, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.2.b', 'IM', 3.61, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.3.a', 'IM', 4.14, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.3.b', 'IM', 3.43, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.3.c', 'IM', 3.07, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.4.a', 'IM', 4.26, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.4.b', 'IM', 4.04, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.4.c', 'IM', 4.15, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.5.a', 'IM', 4.57, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.5.b', 'IM', 4.68, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.5.c', 'IM', 4.32, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.6', 'IM', 4.00, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.7.a', 'IM', 3.54, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.7.b', 'IM', 4.43, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.1.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.1.b', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.1.c', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.2.b', 'IM', 3.38, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.3.a', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.3.b', 'IM', 3.29, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.3.c', 'IM', 2.67, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.4.a', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.4.b', 'IM', 3.48, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.4.c', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.5.a', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.5.b', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.5.c', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.6', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.7.a', 'IM', 3.05, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.7.b', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.1.a', 'IM', 3.87, 18, 0.38, 3.08, 4.66, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.1.b', 'IM', 4.49, 18, 0.05, 4.38, 4.60, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.1.c', 'IM', 4.29, 18, 0.13, 4.01, 4.56, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.2.b', 'IM', 4.18, 18, 0.15, 3.85, 4.51, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.3.a', 'IM', 4.11, 17, 0.09, 3.92, 4.29, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.3.b', 'IM', 3.80, 17, 0.14, 3.50, 4.11, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.3.c', 'IM', 2.88, 17, 0.20, 2.46, 3.31, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.4.a', 'IM', 4.09, 17, 0.09, 3.91, 4.27, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.4.b', 'IM', 4.38, 17, 0.08, 4.20, 4.55, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.4.c', 'IM', 4.30, 17, 0.14, 3.99, 4.60, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.5.a', 'IM', 4.70, 17, 0.14, 4.40, 5.00, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.5.b', 'IM', 4.67, 17, 0.14, 4.37, 4.97, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.5.c', 'IM', 4.48, 18, 0.06, 4.36, 4.59, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.6', 'IM', 4.19, 18, 0.15, 3.87, 4.50, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.7.a', 'IM', 4.07, 18, 0.07, 3.92, 4.22, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.7.b', 'IM', 4.35, 18, 0.37, 3.57, 5.00, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.1.a', 'IM', 3.62, 43, 0.15, 3.32, 3.93, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.1.b', 'IM', 3.72, 43, 0.13, 3.45, 3.98, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.1.c', 'IM', 3.86, 43, 0.13, 3.60, 4.12, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.2.b', 'IM', 3.61, 43, 0.18, 3.25, 3.97, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.3.a', 'IM', 3.97, 43, 0.13, 3.71, 4.23, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.3.b', 'IM', 3.50, 43, 0.16, 3.19, 3.82, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.3.c', 'IM', 2.76, 43, 0.18, 2.40, 3.13, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.4.a', 'IM', 3.50, 43, 0.23, 3.03, 3.97, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.4.b', 'IM', 3.91, 43, 0.13, 3.65, 4.17, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.4.c', 'IM', 3.92, 43, 0.09, 3.73, 4.11, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.5.a', 'IM', 4.29, 43, 0.14, 4.01, 4.57, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.5.b', 'IM', 4.19, 43, 0.13, 3.94, 4.45, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.5.c', 'IM', 3.82, 43, 0.18, 3.45, 4.20, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.6', 'IM', 3.80, 43, 0.18, 3.44, 4.15, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.7.a', 'IM', 3.61, 43, 0.14, 3.33, 3.88, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.7.b', 'IM', 3.91, 43, 0.17, 3.57, 4.25, 'N', '2009-06-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.1.a', 'IM', 3.59, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.1.b', 'IM', 3.69, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.1.c', 'IM', 3.76, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.2.b', 'IM', 3.24, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.3.a', 'IM', 3.55, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.3.b', 'IM', 3.10, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.3.c', 'IM', 2.62, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.4.a', 'IM', 3.66, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.4.b', 'IM', 3.64, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.4.c', 'IM', 3.55, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.5.a', 'IM', 4.41, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.5.b', 'IM', 4.55, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.5.c', 'IM', 4.59, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.6', 'IM', 3.52, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.7.a', 'IM', 3.10, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.7.b', 'IM', 3.83, 29, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.1.a', 'IM', 4.07, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.1.b', 'IM', 4.17, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.1.c', 'IM', 4.10, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.2.b', 'IM', 3.21, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.3.a', 'IM', 4.10, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.3.b', 'IM', 3.34, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.3.c', 'IM', 2.97, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.4.a', 'IM', 4.00, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.4.b', 'IM', 3.83, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.4.c', 'IM', 3.86, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.5.a', 'IM', 4.62, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.5.b', 'IM', 4.66, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.5.c', 'IM', 4.10, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.6', 'IM', 3.62, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.7.a', 'IM', 3.69, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.04', '1.C.7.b', 'IM', 4.24, 29, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.1.a', 'IM', 4.00, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.1.b', 'IM', 4.12, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.1.c', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.2.b', 'IM', 3.88, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.3.a', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.3.b', 'IM', 3.60, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.3.c', 'IM', 3.28, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.4.a', 'IM', 4.12, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.4.b', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.4.c', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.5.a', 'IM', 4.60, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.5.b', 'IM', 4.64, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.5.c', 'IM', 4.48, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.6', 'IM', 3.56, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.7.a', 'IM', 3.96, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.06', '1.C.7.b', 'IM', 4.46, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.1.a', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.1.b', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.1.c', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.2.b', 'IM', 3.14, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.3.a', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.3.b', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.3.c', 'IM', 2.77, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.4.a', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.4.b', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.4.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.5.a', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.5.b', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.5.c', 'IM', 4.41, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.6', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.7.a', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.09', '1.C.7.b', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.1.a', 'IM', 3.93, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.1.b', 'IM', 3.86, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.1.c', 'IM', 4.00, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.2.b', 'IM', 3.86, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.3.a', 'IM', 3.79, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.3.b', 'IM', 3.00, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.3.c', 'IM', 2.89, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.4.a', 'IM', 3.75, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.4.b', 'IM', 3.68, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.4.c', 'IM', 3.93, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.5.a', 'IM', 4.43, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.5.b', 'IM', 4.68, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.5.c', 'IM', 4.46, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.6', 'IM', 3.57, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.7.a', 'IM', 3.36, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.01', '1.C.7.b', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.1.a', 'IM', 3.87, 33, 0.16, 3.54, 4.21, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.1.b', 'IM', 3.56, 33, 0.18, 3.19, 3.93, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.1.c', 'IM', 3.77, 33, 0.17, 3.42, 4.11, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.2.b', 'IM', 3.33, 33, 0.20, 2.93, 3.74, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.3.a', 'IM', 3.87, 33, 0.15, 3.57, 4.17, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.3.b', 'IM', 3.42, 32, 0.19, 3.04, 3.80, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.3.c', 'IM', 2.87, 32, 0.21, 2.44, 3.29, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.4.a', 'IM', 3.44, 32, 0.21, 3.01, 3.88, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.4.b', 'IM', 3.65, 33, 0.20, 3.25, 4.05, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.4.c', 'IM', 3.57, 33, 0.22, 3.12, 4.02, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.5.a', 'IM', 4.19, 33, 0.15, 3.89, 4.49, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.5.b', 'IM', 4.66, 33, 0.09, 4.48, 4.84, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.5.c', 'IM', 4.13, 33, 0.16, 3.81, 4.45, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.6', 'IM', 3.82, 33, 0.18, 3.45, 4.20, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.7.a', 'IM', 3.46, 33, 0.19, 3.08, 3.84, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.02', '1.C.7.b', 'IM', 3.58, 33, 0.22, 3.13, 4.03, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.1.a', 'IM', 3.97, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.1.b', 'IM', 4.16, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.1.c', 'IM', 4.34, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.2.b', 'IM', 3.91, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.3.a', 'IM', 4.03, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.3.b', 'IM', 3.26, 31, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.3.c', 'IM', 2.94, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.4.a', 'IM', 3.69, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.4.b', 'IM', 3.84, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.4.c', 'IM', 3.94, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.5.a', 'IM', 4.39, 31, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.5.b', 'IM', 4.44, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.5.c', 'IM', 4.66, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.6', 'IM', 4.28, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.7.a', 'IM', 4.12, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.7.b', 'IM', 4.50, 32, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.1.a', 'IM', 3.92, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.1.b', 'IM', 3.81, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.1.c', 'IM', 3.92, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.2.b', 'IM', 3.65, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.3.a', 'IM', 4.12, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.3.b', 'IM', 3.23, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.3.c', 'IM', 3.27, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.4.a', 'IM', 3.77, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.4.b', 'IM', 3.23, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.4.c', 'IM', 3.88, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.5.a', 'IM', 4.38, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.5.b', 'IM', 4.42, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.5.c', 'IM', 4.54, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.6', 'IM', 3.27, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.7.a', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.7.b', 'IM', 4.31, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.1.a', 'IM', 4.03, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.1.b', 'IM', 4.10, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.1.c', 'IM', 4.20, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.2.b', 'IM', 3.63, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.3.a', 'IM', 3.80, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.3.b', 'IM', 3.30, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.3.c', 'IM', 2.97, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.4.a', 'IM', 3.50, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.4.b', 'IM', 3.40, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.4.c', 'IM', 3.93, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.5.a', 'IM', 4.17, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.5.b', 'IM', 4.40, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.5.c', 'IM', 4.40, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.6', 'IM', 4.10, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.7.a', 'IM', 3.87, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.7.b', 'IM', 4.53, 30, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.1.a', 'IM', 4.05, 19, 0.28, 3.46, 4.65, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.1.b', 'IM', 4.11, 19, 0.26, 3.57, 4.65, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.1.c', 'IM', 4.27, 19, 0.20, 3.84, 4.69, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.2.b', 'IM', 3.83, 19, 0.33, 3.13, 4.53, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.3.a', 'IM', 3.97, 19, 0.31, 3.32, 4.63, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.3.b', 'IM', 3.31, 19, 0.26, 2.76, 3.86, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.3.c', 'IM', 2.73, 19, 0.34, 2.01, 3.45, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.4.a', 'IM', 3.94, 19, 0.19, 3.54, 4.33, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.4.b', 'IM', 4.17, 19, 0.24, 3.66, 4.67, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.4.c', 'IM', 4.05, 19, 0.26, 3.50, 4.60, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.5.a', 'IM', 4.33, 18, 0.18, 3.94, 4.71, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.5.b', 'IM', 4.96, 19, 0.03, 4.90, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.5.c', 'IM', 4.75, 19, 0.12, 4.50, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.6', 'IM', 4.11, 19, 0.21, 3.66, 4.55, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.7.a', 'IM', 3.86, 19, 0.32, 3.19, 4.53, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1020.01', '1.C.7.b', 'IM', 4.47, 19, 0.26, 3.92, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.1.a', 'IM', 3.98, 24, 0.20, 3.56, 4.40, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.1.b', 'IM', 4.58, 24, 0.20, 4.16, 4.99, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.1.c', 'IM', 4.10, 24, 0.15, 3.80, 4.40, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.2.b', 'IM', 3.71, 24, 0.14, 3.42, 3.99, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.3.a', 'IM', 4.26, 24, 0.30, 3.64, 4.87, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.3.b', 'IM', 3.26, 24, 0.20, 2.85, 3.67, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.3.c', 'IM', 3.39, 24, 0.32, 2.72, 4.06, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.4.a', 'IM', 3.25, 24, 0.25, 2.73, 3.77, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.4.b', 'IM', 4.10, 24, 0.35, 3.38, 4.81, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.4.c', 'IM', 4.36, 24, 0.25, 3.85, 4.87, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.5.a', 'IM', 3.99, 24, 0.13, 3.72, 4.27, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.5.b', 'IM', 4.29, 24, 0.15, 3.99, 4.60, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.5.c', 'IM', 3.84, 24, 0.32, 3.18, 4.51, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.6', 'IM', 3.99, 24, 0.20, 3.57, 4.41, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.7.a', 'IM', 4.42, 24, 0.25, 3.90, 4.93, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.7.b', 'IM', 4.34, 24, 0.16, 4.01, 4.66, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.1.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.1.b', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.1.c', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.2.b', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.3.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.3.b', 'IM', 3.14, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.3.c', 'IM', 2.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.4.a', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.4.b', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.4.c', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.5.a', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.5.b', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.5.c', 'IM', 4.41, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.6', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.7.a', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.7.b', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.1.a', 'IM', 3.44, 21, 0.12, 3.19, 3.69, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.1.b', 'IM', 3.67, 21, 0.12, 3.43, 3.91, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.1.c', 'IM', 3.72, 21, 0.15, 3.41, 4.03, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.2.b', 'IM', 3.56, 21, 0.12, 3.30, 3.81, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.3.a', 'IM', 4.46, 21, 0.20, 4.04, 4.88, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.3.b', 'IM', 3.72, 21, 0.15, 3.41, 4.03, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.3.c', 'IM', 3.47, 21, 0.21, 3.02, 3.91, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.4.a', 'IM', 3.84, 21, 0.23, 3.35, 4.32, 'N', '2010-06-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.4.b', 'IM', 3.90, 21, 0.21, 3.46, 4.33, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.4.c', 'IM', 4.01, 21, 0.05, 3.90, 4.12, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.5.a', 'IM', 4.19, 21, 0.15, 3.89, 4.50, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.5.b', 'IM', 4.15, 21, 0.24, 3.65, 4.64, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.5.c', 'IM', 4.04, 21, 0.08, 3.88, 4.20, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.6', 'IM', 3.63, 21, 0.22, 3.17, 4.09, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.7.a', 'IM', 3.44, 21, 0.14, 3.16, 3.73, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.7.b', 'IM', 4.04, 21, 0.21, 3.60, 4.47, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.1.a', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.1.b', 'IM', 4.64, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.1.c', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.2.b', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.3.a', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.3.b', 'IM', 2.91, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.3.c', 'IM', 2.36, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.4.a', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.4.b', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.4.c', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.5.a', 'IM', 4.41, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.5.b', 'IM', 4.82, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.5.c', 'IM', 4.77, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.6', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.7.a', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.7.b', 'IM', 4.64, 22, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.1.a', 'IM', 4.44, 36, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.1.b', 'IM', 4.50, 36, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.1.c', 'IM', 4.25, 36, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.2.b', 'IM', 3.64, 36, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.3.a', 'IM', 3.86, 36, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.3.b', 'IM', 3.14, 36, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.3.c', 'IM', 2.75, 36, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.4.a', 'IM', 3.58, 36, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.4.b', 'IM', 3.81, 36, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.4.c', 'IM', 3.94, 36, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.5.a', 'IM', 4.33, 36, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.5.b', 'IM', 4.83, 36, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.5.c', 'IM', 4.67, 36, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.6', 'IM', 3.97, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.7.a', 'IM', 4.00, 36, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.7.b', 'IM', 4.72, 36, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.1.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.1.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.1.c', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.2.b', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.3.a', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.3.b', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.3.c', 'IM', 3.38, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.4.a', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.4.b', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.4.c', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.5.a', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.5.b', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.5.c', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.6', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.7.a', 'IM', 3.48, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.01', '1.C.7.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.1.a', 'IM', 3.40, 23, 0.21, 2.97, 3.83, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.1.b', 'IM', 3.60, 23, 0.20, 3.17, 4.02, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.1.c', 'IM', 3.90, 23, 0.14, 3.61, 4.18, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.2.b', 'IM', 3.65, 23, 0.20, 3.23, 4.07, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.3.a', 'IM', 4.28, 23, 0.21, 3.85, 4.71, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.3.b', 'IM', 3.68, 23, 0.25, 3.17, 4.19, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.3.c', 'IM', 3.03, 23, 0.35, 2.31, 3.75, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.4.a', 'IM', 3.58, 23, 0.21, 3.15, 4.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.4.b', 'IM', 3.68, 23, 0.22, 3.22, 4.13, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.4.c', 'IM', 4.10, 23, 0.24, 3.61, 4.59, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.5.a', 'IM', 4.09, 23, 0.16, 3.76, 4.42, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.5.b', 'IM', 3.81, 23, 0.24, 3.32, 4.31, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.5.c', 'IM', 4.49, 23, 0.17, 4.14, 4.84, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.6', 'IM', 4.19, 23, 0.13, 3.92, 4.46, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.7.a', 'IM', 3.74, 23, 0.20, 3.33, 4.15, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.7.b', 'IM', 3.83, 23, 0.22, 3.36, 4.29, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.1.a', 'IM', 3.68, 21, 0.20, 3.26, 4.10, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.1.b', 'IM', 3.45, 21, 0.21, 3.01, 3.88, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.1.c', 'IM', 3.89, 21, 0.36, 3.14, 4.64, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.2.b', 'IM', 3.16, 21, 0.36, 2.40, 3.92, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.3.a', 'IM', 4.46, 22, 0.39, 3.65, 5.00, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.3.b', 'IM', 3.56, 22, 0.41, 2.70, 4.42, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.3.c', 'IM', 4.09, 22, 0.41, 3.25, 4.94, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.4.a', 'IM', 4.17, 22, 0.36, 3.42, 4.93, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.4.b', 'IM', 3.88, 22, 0.24, 3.39, 4.37, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.4.c', 'IM', 4.52, 22, 0.21, 4.09, 4.96, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.5.a', 'IM', 4.35, 22, 0.21, 3.91, 4.78, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.5.b', 'IM', 3.77, 22, 0.21, 3.33, 4.20, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.5.c', 'IM', 3.94, 22, 0.25, 3.42, 4.46, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.6', 'IM', 3.75, 22, 0.21, 3.30, 4.20, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.7.a', 'IM', 3.96, 22, 0.34, 3.25, 4.66, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.7.b', 'IM', 3.14, 22, 0.10, 2.95, 3.34, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.1.a', 'IM', 3.17, 16, 0.21, 2.73, 3.62, 'N', '2003-03-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.1.b', 'IM', 3.64, 16, 0.20, 3.21, 4.07, 'N', '2003-03-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.1.c', 'IM', 3.87, 16, 0.10, 3.65, 4.09, 'N', '2003-03-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.2.b', 'IM', 3.05, 16, 0.10, 2.83, 3.28, 'N', '2003-03-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.3.a', 'IM', 4.31, 16, 0.11, 4.07, 4.56, 'N', '2003-03-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.3.b', 'IM', 3.31, 16, 0.12, 3.04, 3.57, 'N', '2003-03-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.3.c', 'IM', 3.00, 16, 0.15, 2.69, 3.31, 'N', '2003-03-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.4.a', 'IM', 3.63, 16, 0.16, 3.28, 3.97, 'N', '2003-03-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.4.b', 'IM', 2.77, 16, 0.13, 2.48, 3.05, 'N', '2003-03-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.4.c', 'IM', 3.58, 16, 0.15, 3.27, 3.90, 'N', '2003-03-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.5.a', 'IM', 3.99, 16, 0.03, 3.92, 4.06, 'N', '2003-03-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.5.b', 'IM', 3.83, 16, 0.22, 3.37, 4.29, 'N', '2003-03-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.5.c', 'IM', 3.89, 16, 0.12, 3.63, 4.15, 'N', '2003-03-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.6', 'IM', 4.07, 16, 0.06, 3.94, 4.19, 'N', '2003-03-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.7.a', 'IM', 3.15, 16, 0.22, 2.68, 3.62, 'N', '2003-03-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.7.b', 'IM', 3.27, 16, 0.10, 3.06, 3.49, 'N', '2003-03-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.1.a', 'IM', 4.27, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.1.b', 'IM', 4.27, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.1.c', 'IM', 4.43, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.2.b', 'IM', 3.90, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.3.a', 'IM', 4.27, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.3.b', 'IM', 3.63, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.3.c', 'IM', 3.60, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.4.a', 'IM', 3.53, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.4.b', 'IM', 4.00, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.4.c', 'IM', 3.93, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.5.a', 'IM', 4.27, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.5.b', 'IM', 4.60, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.5.c', 'IM', 4.73, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.6', 'IM', 3.87, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.7.a', 'IM', 3.77, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.7.b', 'IM', 4.80, 30, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.1.a', 'IM', 4.65, 24, 0.19, 4.26, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.1.b', 'IM', 4.79, 24, 0.13, 4.53, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.1.c', 'IM', 4.61, 24, 0.25, 4.08, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.2.b', 'IM', 4.18, 24, 0.27, 3.62, 4.73, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.3.a', 'IM', 4.48, 24, 0.10, 4.26, 4.70, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.3.b', 'IM', 3.36, 24, 0.39, 2.56, 4.16, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.3.c', 'IM', 3.95, 24, 0.35, 3.22, 4.67, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.4.a', 'IM', 4.31, 24, 0.30, 3.69, 4.94, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.4.b', 'IM', 4.53, 24, 0.18, 4.16, 4.91, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.4.c', 'IM', 4.21, 24, 0.25, 3.70, 4.72, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.5.a', 'IM', 4.33, 24, 0.18, 3.95, 4.70, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.5.b', 'IM', 4.68, 24, 0.07, 4.53, 4.82, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.5.c', 'IM', 4.91, 24, 0.07, 4.76, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.6', 'IM', 4.09, 24, 0.41, 3.24, 4.94, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.7.a', 'IM', 4.22, 24, 0.09, 4.03, 4.41, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.7.b', 'IM', 4.66, 24, 0.18, 4.28, 5.00, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.1.a', 'IM', 4.55, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.1.b', 'IM', 4.58, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.1.c', 'IM', 4.61, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.2.b', 'IM', 3.30, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.3.a', 'IM', 3.39, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.3.b', 'IM', 2.30, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.3.c', 'IM', 1.94, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.4.a', 'IM', 2.94, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.4.b', 'IM', 3.48, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.4.c', 'IM', 3.48, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.5.a', 'IM', 3.55, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.5.b', 'IM', 4.12, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.5.c', 'IM', 4.33, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.6', 'IM', 4.45, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.7.a', 'IM', 4.48, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.7.b', 'IM', 4.85, 33, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.1.a', 'IM', 4.13, 19, 0.30, 3.51, 4.75, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.1.b', 'IM', 4.59, 19, 0.19, 4.18, 4.99, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.1.c', 'IM', 4.63, 18, 0.15, 4.30, 4.95, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.2.b', 'IM', 3.40, 19, 0.26, 2.86, 3.93, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.3.a', 'IM', 3.95, 19, 0.28, 3.37, 4.53, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.3.b', 'IM', 3.40, 19, 0.51, 2.33, 4.46, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.3.c', 'IM', 2.49, 19, 0.24, 1.99, 2.99, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.4.a', 'IM', 3.82, 19, 0.33, 3.12, 4.53, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.4.b', 'IM', 3.45, 19, 0.14, 3.16, 3.74, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.4.c', 'IM', 4.28, 19, 0.18, 3.91, 4.65, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.5.a', 'IM', 4.26, 19, 0.24, 3.75, 4.77, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.5.b', 'IM', 4.82, 19, 0.12, 4.57, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.5.c', 'IM', 4.49, 19, 0.18, 4.12, 4.86, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.6', 'IM', 4.26, 19, 0.16, 3.92, 4.61, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.7.a', 'IM', 4.10, 19, 0.31, 3.45, 4.75, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.7.b', 'IM', 4.71, 19, 0.14, 4.42, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.1.a', 'IM', 3.63, 29, 0.31, 3.00, 4.25, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.1.b', 'IM', 3.57, 29, 0.28, 3.01, 4.14, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.1.c', 'IM', 3.62, 29, 0.30, 3.00, 4.24, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.2.b', 'IM', 3.64, 29, 0.32, 2.99, 4.30, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.3.a', 'IM', 4.26, 29, 0.15, 3.94, 4.57, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.3.b', 'IM', 3.46, 29, 0.25, 2.96, 3.96, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.3.c', 'IM', 3.76, 29, 0.14, 3.47, 4.05, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.4.a', 'IM', 4.03, 29, 0.11, 3.81, 4.25, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.4.b', 'IM', 3.37, 29, 0.64, 2.07, 4.68, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.4.c', 'IM', 3.83, 29, 0.39, 3.03, 4.63, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.5.a', 'IM', 3.88, 29, 0.41, 3.04, 4.72, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.5.b', 'IM', 4.19, 29, 0.11, 3.97, 4.42, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.5.c', 'IM', 4.11, 29, 0.12, 3.87, 4.35, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.6', 'IM', 3.98, 29, 0.09, 3.81, 4.15, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.7.a', 'IM', 2.93, 29, 0.43, 2.04, 3.81, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.7.b', 'IM', 3.70, 29, 0.33, 3.02, 4.39, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.1.a', 'IM', 3.94, 32, 0.13, 3.66, 4.21, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.1.b', 'IM', 3.90, 32, 0.17, 3.56, 4.24, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.1.c', 'IM', 4.16, 32, 0.11, 3.93, 4.39, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.2.b', 'IM', 3.69, 32, 0.13, 3.41, 3.96, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.3.a', 'IM', 4.06, 31, 0.17, 3.71, 4.42, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.3.b', 'IM', 3.51, 31, 0.18, 3.15, 3.87, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.3.c', 'IM', 3.02, 31, 0.23, 2.56, 3.49, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.4.a', 'IM', 3.73, 31, 0.13, 3.47, 3.99, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.4.b', 'IM', 3.94, 31, 0.13, 3.66, 4.21, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.4.c', 'IM', 3.82, 31, 0.14, 3.54, 4.10, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.5.a', 'IM', 4.41, 31, 0.09, 4.23, 4.59, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.5.b', 'IM', 4.68, 31, 0.09, 4.50, 4.87, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.5.c', 'IM', 4.66, 32, 0.10, 4.45, 4.87, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.6', 'IM', 4.05, 32, 0.13, 3.80, 4.31, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.7.a', 'IM', 3.61, 32, 0.15, 3.31, 3.91, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.7.b', 'IM', 4.47, 32, 0.10, 4.27, 4.67, 'N', '2009-06-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.1.a', 'IM', 4.03, 30, 0.07, 3.89, 4.16, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.1.b', 'IM', 3.78, 30, 0.30, 3.17, 4.39, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.1.c', 'IM', 4.00, 30, 0.06, 3.87, 4.13, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.2.b', 'IM', 3.86, 30, 0.12, 3.61, 4.11, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.3.a', 'IM', 3.52, 30, 0.27, 2.96, 4.08, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.3.b', 'IM', 3.19, 30, 0.31, 2.55, 3.82, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.3.c', 'IM', 2.83, 30, 0.55, 1.71, 3.94, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.4.a', 'IM', 3.47, 30, 0.28, 2.89, 4.05, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.4.b', 'IM', 3.48, 30, 0.29, 2.89, 4.06, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.4.c', 'IM', 3.75, 30, 0.30, 3.15, 4.36, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.5.a', 'IM', 3.91, 30, 0.08, 3.74, 4.07, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.5.b', 'IM', 3.40, 30, 0.57, 2.24, 4.57, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.5.c', 'IM', 3.56, 30, 0.59, 2.36, 4.77, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.6', 'IM', 3.56, 30, 0.59, 2.34, 4.77, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.7.a', 'IM', 4.14, 30, 0.09, 3.96, 4.32, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.7.b', 'IM', 4.33, 30, 0.14, 4.04, 4.63, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.1.a', 'IM', 4.10, 27, 0.26, 3.55, 4.64, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.1.b', 'IM', 3.82, 27, 0.24, 3.32, 4.32, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.1.c', 'IM', 4.09, 27, 0.23, 3.61, 4.57, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.2.b', 'IM', 3.88, 27, 0.16, 3.54, 4.22, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.3.a', 'IM', 4.50, 27, 0.15, 4.20, 4.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.3.b', 'IM', 3.66, 27, 0.20, 3.26, 4.07, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.3.c', 'IM', 3.36, 27, 0.23, 2.89, 3.82, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.4.a', 'IM', 3.70, 27, 0.14, 3.40, 3.99, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.4.b', 'IM', 3.73, 27, 0.20, 3.32, 4.15, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.4.c', 'IM', 3.76, 27, 0.23, 3.29, 4.23, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.5.a', 'IM', 4.55, 27, 0.10, 4.35, 4.74, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.5.b', 'IM', 4.49, 27, 0.11, 4.25, 4.72, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.5.c', 'IM', 4.51, 27, 0.17, 4.17, 4.85, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.6', 'IM', 4.18, 27, 0.15, 3.87, 4.49, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.7.a', 'IM', 3.64, 27, 0.23, 3.17, 4.12, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.7.b', 'IM', 4.19, 27, 0.12, 3.95, 4.43, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.1.a', 'IM', 4.09, 28, 0.17, 3.75, 4.44, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.1.b', 'IM', 4.20, 28, 0.15, 3.89, 4.52, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.1.c', 'IM', 4.01, 28, 0.28, 3.44, 4.59, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.2.b', 'IM', 3.73, 28, 0.21, 3.30, 4.16, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.3.a', 'IM', 4.34, 28, 0.14, 4.05, 4.63, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.3.b', 'IM', 3.83, 28, 0.18, 3.47, 4.20, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.3.c', 'IM', 3.16, 28, 0.25, 2.64, 3.68, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.4.a', 'IM', 3.75, 28, 0.33, 3.08, 4.42, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.4.b', 'IM', 3.87, 28, 0.24, 3.39, 4.36, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.4.c', 'IM', 3.93, 28, 0.22, 3.47, 4.38, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.5.a', 'IM', 4.40, 28, 0.15, 4.10, 4.70, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.5.b', 'IM', 4.43, 28, 0.15, 4.12, 4.75, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.5.c', 'IM', 4.48, 28, 0.14, 4.20, 4.76, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.6', 'IM', 4.42, 28, 0.19, 4.03, 4.82, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.7.a', 'IM', 4.30, 28, 0.25, 3.78, 4.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.7.b', 'IM', 4.72, 28, 0.10, 4.52, 4.93, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.1.a', 'IM', 3.65, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.1.b', 'IM', 3.77, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.1.c', 'IM', 4.04, 25, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.2.b', 'IM', 3.42, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.3.a', 'IM', 3.92, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.3.b', 'IM', 3.23, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.3.c', 'IM', 2.65, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.4.a', 'IM', 3.62, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.4.b', 'IM', 3.62, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.4.c', 'IM', 3.73, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.5.a', 'IM', 4.31, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.5.b', 'IM', 4.19, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.5.c', 'IM', 4.46, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.6', 'IM', 3.77, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.7.a', 'IM', 3.46, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.7.b', 'IM', 4.50, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.1.a', 'IM', 3.92, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.1.b', 'IM', 4.08, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.1.c', 'IM', 3.81, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.2.b', 'IM', 3.15, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.3.a', 'IM', 3.65, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.3.b', 'IM', 2.58, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.3.c', 'IM', 2.15, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.4.a', 'IM', 3.00, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.4.b', 'IM', 3.08, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.4.c', 'IM', 3.62, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.5.a', 'IM', 4.15, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.5.b', 'IM', 4.42, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.5.c', 'IM', 4.52, 25, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.6', 'IM', 3.73, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.7.a', 'IM', 3.96, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.7.b', 'IM', 4.62, 26, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.1.a', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.1.b', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.1.c', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.2.b', 'IM', 2.83, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.3.a', 'IM', 2.95, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.3.b', 'IM', 2.52, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.3.c', 'IM', 2.39, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.4.a', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.4.b', 'IM', 3.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.4.c', 'IM', 3.57, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.5.a', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.5.b', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.5.c', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.6', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.7.a', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.7.b', 'IM', 4.87, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.1.a', 'IM', 4.07, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.1.b', 'IM', 4.07, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.1.c', 'IM', 4.46, 26, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.2.b', 'IM', 3.89, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.3.a', 'IM', 4.26, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.3.b', 'IM', 3.33, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.3.c', 'IM', 3.35, 26, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.4.a', 'IM', 3.85, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.4.b', 'IM', 3.85, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.4.c', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.5.a', 'IM', 4.56, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.5.b', 'IM', 4.81, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.5.c', 'IM', 4.65, 26, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.6', 'IM', 3.67, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.7.a', 'IM', 3.59, 27, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.7.b', 'IM', 4.65, 26, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.1.a', 'IM', 4.25, 18, 0.40, 3.40, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.1.b', 'IM', 4.09, 18, 0.29, 3.47, 4.71, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.1.c', 'IM', 4.31, 18, 0.27, 3.75, 4.87, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.2.b', 'IM', 4.39, 18, 0.18, 4.02, 4.76, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.3.a', 'IM', 4.78, 18, 0.14, 4.48, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.3.b', 'IM', 4.84, 18, 0.12, 4.60, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.3.c', 'IM', 4.18, 18, 0.29, 3.57, 4.79, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.4.a', 'IM', 4.72, 18, 0.18, 4.35, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.4.b', 'IM', 4.53, 18, 0.19, 4.14, 4.92, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.4.c', 'IM', 4.27, 18, 0.23, 3.77, 4.76, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.5.a', 'IM', 4.76, 18, 0.17, 4.40, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.5.b', 'IM', 4.58, 18, 0.18, 4.21, 4.96, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.5.c', 'IM', 4.84, 18, 0.10, 4.64, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.6', 'IM', 4.42, 18, 0.25, 3.89, 4.95, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.7.a', 'IM', 3.33, 18, 0.36, 2.57, 4.10, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.01', '1.C.7.b', 'IM', 4.37, 18, 0.25, 3.85, 4.90, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.1.a', 'IM', 3.89, 25, 0.14, 3.60, 4.18, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.1.b', 'IM', 4.27, 25, 0.23, 3.79, 4.75, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.1.c', 'IM', 4.34, 25, 0.15, 4.03, 4.65, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.2.b', 'IM', 4.32, 25, 0.16, 3.99, 4.65, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.3.a', 'IM', 4.45, 25, 0.17, 4.09, 4.81, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.3.b', 'IM', 4.63, 25, 0.17, 4.29, 4.98, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.3.c', 'IM', 4.51, 25, 0.21, 4.08, 4.94, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.4.a', 'IM', 4.80, 25, 0.15, 4.49, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.4.b', 'IM', 4.77, 25, 0.15, 4.46, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.4.c', 'IM', 4.16, 25, 0.17, 3.81, 4.51, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.5.a', 'IM', 4.66, 25, 0.17, 4.30, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.5.b', 'IM', 4.37, 25, 0.19, 3.97, 4.76, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.5.c', 'IM', 4.70, 25, 0.17, 4.35, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.6', 'IM', 4.13, 25, 0.22, 3.67, 4.59, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.7.a', 'IM', 4.06, 25, 0.25, 3.53, 4.58, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.02', '1.C.7.b', 'IM', 4.13, 25, 0.25, 3.60, 4.65, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.1.a', 'IM', 4.02, 21, 0.23, 3.54, 4.49, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.1.b', 'IM', 4.46, 21, 0.19, 4.07, 4.84, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.1.c', 'IM', 4.63, 21, 0.16, 4.29, 4.97, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.2.b', 'IM', 4.17, 21, 0.17, 3.82, 4.53, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.3.a', 'IM', 4.95, 20, 0.03, 4.89, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.3.b', 'IM', 5.00, 20, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.3.c', 'IM', 4.67, 20, 0.20, 4.26, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.4.a', 'IM', 4.97, 20, 0.03, 4.90, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.4.b', 'IM', 4.64, 20, 0.19, 4.24, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.4.c', 'IM', 4.25, 20, 0.15, 3.93, 4.58, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.5.a', 'IM', 4.81, 20, 0.14, 4.52, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.5.b', 'IM', 3.87, 20, 0.53, 2.75, 4.99, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.5.c', 'IM', 4.99, 21, 0.01, 4.96, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.6', 'IM', 4.55, 21, 0.20, 4.13, 4.97, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.7.a', 'IM', 3.47, 21, 0.46, 2.52, 4.42, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3031.03', '1.C.7.b', 'IM', 4.31, 21, 0.18, 3.93, 4.69, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.1.a', 'IM', 4.60, 44, 0.10, 4.39, 4.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.1.b', 'IM', 3.90, 44, 0.39, 3.11, 4.69, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.1.c', 'IM', 4.59, 44, 0.14, 4.31, 4.86, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.2.b', 'IM', 4.29, 44, 0.18, 3.93, 4.65, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.3.a', 'IM', 4.56, 44, 0.12, 4.32, 4.79, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.3.b', 'IM', 3.92, 44, 0.28, 3.35, 4.48, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.3.c', 'IM', 4.11, 44, 0.24, 3.63, 4.59, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.4.a', 'IM', 4.27, 44, 0.21, 3.85, 4.69, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.4.b', 'IM', 4.18, 44, 0.20, 3.78, 4.58, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.4.c', 'IM', 4.52, 44, 0.17, 4.17, 4.87, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.5.a', 'IM', 4.69, 44, 0.11, 4.47, 4.92, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.5.b', 'IM', 4.20, 44, 0.27, 3.65, 4.74, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.5.c', 'IM', 4.65, 44, 0.16, 4.33, 4.98, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.6', 'IM', 4.45, 44, 0.13, 4.18, 4.72, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.7.a', 'IM', 4.02, 44, 0.23, 3.56, 4.48, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.7.b', 'IM', 4.73, 44, 0.08, 4.56, 4.90, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.1.a', 'IM', 4.15, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.1.b', 'IM', 4.26, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.1.c', 'IM', 4.09, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.2.b', 'IM', 3.62, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.3.a', 'IM', 4.24, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.3.b', 'IM', 4.82, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.3.c', 'IM', 4.03, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.4.a', 'IM', 4.68, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.4.b', 'IM', 4.38, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.4.c', 'IM', 4.12, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.5.a', 'IM', 4.71, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.5.b', 'IM', 4.82, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.5.c', 'IM', 4.88, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.6', 'IM', 4.53, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.7.a', 'IM', 3.59, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.01', '1.C.7.b', 'IM', 4.82, 34, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.1.a', 'IM', 4.48, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.1.b', 'IM', 4.34, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.1.c', 'IM', 4.41, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.2.b', 'IM', 3.59, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.3.a', 'IM', 3.28, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.3.b', 'IM', 2.72, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.3.c', 'IM', 3.03, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.4.a', 'IM', 3.24, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.4.b', 'IM', 3.66, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.4.c', 'IM', 3.72, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.5.a', 'IM', 4.00, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.5.b', 'IM', 3.97, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.5.c', 'IM', 4.31, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.6', 'IM', 4.48, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.7.a', 'IM', 4.17, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.7.b', 'IM', 4.76, 29, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.1.a', 'IM', 3.92, 32, 0.22, 3.47, 4.38, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.1.b', 'IM', 4.12, 32, 0.18, 3.76, 4.48, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.1.c', 'IM', 4.13, 32, 0.13, 3.86, 4.40, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.2.b', 'IM', 3.67, 32, 0.22, 3.24, 4.11, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.3.a', 'IM', 4.14, 32, 0.13, 3.87, 4.42, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.3.b', 'IM', 3.45, 32, 0.21, 3.02, 3.88, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.3.c', 'IM', 3.28, 32, 0.32, 2.63, 3.92, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.4.a', 'IM', 4.04, 32, 0.30, 3.44, 4.65, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.4.b', 'IM', 3.76, 32, 0.20, 3.36, 4.17, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.4.c', 'IM', 3.95, 32, 0.18, 3.58, 4.31, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.5.a', 'IM', 4.21, 32, 0.18, 3.84, 4.58, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.5.b', 'IM', 4.24, 32, 0.12, 3.98, 4.49, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.5.c', 'IM', 4.51, 32, 0.16, 4.18, 4.84, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.6', 'IM', 3.95, 32, 0.16, 3.62, 4.27, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.7.a', 'IM', 3.42, 32, 0.22, 2.96, 3.88, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.7.b', 'IM', 4.03, 32, 0.22, 3.58, 4.49, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.1.a', 'IM', 4.43, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.1.b', 'IM', 4.43, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.1.c', 'IM', 4.71, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.2.b', 'IM', 3.89, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.3.a', 'IM', 4.00, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.3.b', 'IM', 3.96, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.3.c', 'IM', 3.71, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.4.a', 'IM', 4.21, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.4.b', 'IM', 3.96, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.4.c', 'IM', 4.50, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.5.a', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.5.b', 'IM', 4.54, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.5.c', 'IM', 4.61, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.6', 'IM', 4.25, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.7.a', 'IM', 4.00, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.01', '1.C.7.b', 'IM', 4.75, 28, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.1.a', 'IM', 3.89, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.1.b', 'IM', 3.89, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.1.c', 'IM', 4.18, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.2.b', 'IM', 3.63, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.3.a', 'IM', 4.16, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.3.b', 'IM', 3.16, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.3.c', 'IM', 3.50, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.4.a', 'IM', 3.34, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.4.b', 'IM', 3.29, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.4.c', 'IM', 4.21, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.5.a', 'IM', 4.34, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.5.b', 'IM', 4.68, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.5.c', 'IM', 4.66, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.6', 'IM', 3.53, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.7.a', 'IM', 3.55, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.02', '1.C.7.b', 'IM', 4.63, 38, NULL, NULL, NULL, NULL, '2006-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.1.a', 'IM', 3.96, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.1.b', 'IM', 3.96, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.1.c', 'IM', 4.16, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.2.b', 'IM', 3.46, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.3.a', 'IM', 3.84, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.3.b', 'IM', 3.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.3.c', 'IM', 3.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.4.a', 'IM', 3.24, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.4.b', 'IM', 3.32, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.4.c', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.5.a', 'IM', 4.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.5.b', 'IM', 4.40, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.5.c', 'IM', 4.44, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.6', 'IM', 4.48, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.7.a', 'IM', 4.28, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.7.b', 'IM', 4.92, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.1.a', 'IM', 4.17, 18, 0.17, 3.80, 4.53, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.1.b', 'IM', 4.48, 18, 0.25, 3.96, 5.00, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.1.c', 'IM', 4.14, 18, 0.18, 3.76, 4.53, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.2.b', 'IM', 3.66, 17, 0.31, 2.99, 4.32, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.3.a', 'IM', 4.47, 18, 0.25, 3.93, 5.00, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.3.b', 'IM', 3.99, 18, 0.24, 3.49, 4.49, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.3.c', 'IM', 3.48, 18, 0.21, 3.04, 3.92, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.4.a', 'IM', 4.45, 18, 0.20, 4.04, 4.87, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.4.b', 'IM', 3.63, 18, 0.24, 3.12, 4.14, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.4.c', 'IM', 3.86, 18, 0.13, 3.58, 4.14, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.5.a', 'IM', 4.58, 18, 0.24, 4.06, 5.00, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.5.b', 'IM', 4.48, 18, 0.09, 4.29, 4.66, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.5.c', 'IM', 4.61, 18, 0.16, 4.27, 4.96, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.6', 'IM', 3.95, 18, 0.34, 3.23, 4.67, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.7.a', 'IM', 3.73, 18, 0.25, 3.20, 4.26, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.7.b', 'IM', 3.60, 18, 0.21, 3.15, 4.04, 'N', '2004-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.1.a', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.1.b', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.1.c', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.2.b', 'IM', 3.22, 23, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.3.a', 'IM', 3.00, 23, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.3.b', 'IM', 3.00, 22, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.3.c', 'IM', 2.64, 22, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.4.a', 'IM', 3.39, 23, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.4.b', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.4.c', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.5.a', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.5.b', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.5.c', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.6', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.7.a', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.7.b', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2005-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.1.a', 'IM', 3.77, 31, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.1.b', 'IM', 3.68, 31, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.1.c', 'IM', 4.13, 31, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.2.b', 'IM', 3.81, 31, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.3.a', 'IM', 4.32, 31, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.3.b', 'IM', 3.58, 31, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.3.c', 'IM', 3.48, 31, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.4.a', 'IM', 3.94, 31, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.4.b', 'IM', 3.71, 31, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.4.c', 'IM', 3.97, 31, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.5.a', 'IM', 4.32, 31, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.5.b', 'IM', 4.29, 31, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.5.c', 'IM', 4.48, 31, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.6', 'IM', 3.63, 30, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.7.a', 'IM', 3.52, 31, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.7.b', 'IM', 4.52, 31, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.1.a', 'IM', 3.45, 26, 0.27, 2.91, 4.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.1.b', 'IM', 3.87, 26, 0.29, 3.27, 4.47, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.1.c', 'IM', 3.86, 26, 0.29, 3.27, 4.46, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.2.b', 'IM', 3.57, 26, 0.37, 2.81, 4.34, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.3.a', 'IM', 4.17, 26, 0.15, 3.85, 4.49, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.3.b', 'IM', 3.46, 26, 0.17, 3.10, 3.81, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.3.c', 'IM', 3.28, 26, 0.23, 2.81, 3.75, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.4.a', 'IM', 3.53, 25, 0.22, 3.08, 3.98, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.4.b', 'IM', 3.72, 26, 0.23, 3.25, 4.19, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.4.c', 'IM', 3.97, 26, 0.17, 3.63, 4.31, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.5.a', 'IM', 4.29, 26, 0.09, 4.09, 4.48, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.5.b', 'IM', 4.47, 26, 0.17, 4.12, 4.82, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.5.c', 'IM', 3.90, 26, 0.29, 3.30, 4.49, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.6', 'IM', 3.68, 26, 0.29, 3.07, 4.28, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.7.a', 'IM', 3.12, 26, 0.29, 2.51, 3.72, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.01', '1.C.7.b', 'IM', 3.36, 26, 0.28, 2.78, 3.95, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.1.a', 'IM', 3.58, 74, 0.14, 3.29, 3.87, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.1.b', 'IM', 3.55, 74, 0.16, 3.24, 3.86, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.1.c', 'IM', 3.92, 75, 0.09, 3.73, 4.10, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.2.b', 'IM', 3.64, 74, 0.13, 3.38, 3.89, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.3.a', 'IM', 4.39, 75, 0.16, 4.06, 4.71, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.3.b', 'IM', 3.71, 75, 0.13, 3.45, 3.97, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.3.c', 'IM', 3.21, 75, 0.12, 2.96, 3.46, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.4.a', 'IM', 3.84, 75, 0.22, 3.41, 4.26, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.4.b', 'IM', 4.10, 74, 0.24, 3.62, 4.57, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.4.c', 'IM', 4.20, 74, 0.21, 3.78, 4.62, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.5.a', 'IM', 4.66, 75, 0.10, 4.47, 4.85, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.5.b', 'IM', 4.47, 75, 0.12, 4.22, 4.72, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.5.c', 'IM', 4.67, 74, 0.10, 4.48, 4.86, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.6', 'IM', 3.81, 73, 0.22, 3.38, 4.25, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.7.a', 'IM', 3.41, 74, 0.18, 3.05, 3.76, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4011.02', '1.C.7.b', 'IM', 3.83, 73, 0.10, 3.63, 4.03, 'N', '2005-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.1.a', 'IM', 3.54, 31, 0.26, 3.01, 4.07, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.1.b', 'IM', 3.60, 31, 0.15, 3.30, 3.91, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.1.c', 'IM', 4.01, 31, 0.18, 3.64, 4.39, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.2.b', 'IM', 3.00, 31, 0.24, 2.51, 3.49, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.3.a', 'IM', 3.83, 31, 0.15, 3.53, 4.14, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.3.b', 'IM', 3.01, 31, 0.14, 2.73, 3.29, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.3.c', 'IM', 2.29, 31, 0.19, 1.90, 2.67, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.4.a', 'IM', 2.98, 31, 0.20, 2.56, 3.39, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.4.b', 'IM', 2.87, 31, 0.21, 2.45, 3.29, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.4.c', 'IM', 3.49, 31, 0.21, 3.05, 3.93, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.5.a', 'IM', 4.22, 31, 0.15, 3.91, 4.53, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.5.b', 'IM', 4.65, 31, 0.11, 4.42, 4.87, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.5.c', 'IM', 4.14, 31, 0.17, 3.79, 4.49, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.6', 'IM', 4.12, 31, 0.19, 3.72, 4.51, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.7.a', 'IM', 3.08, 31, 0.24, 2.59, 3.57, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4021.00', '1.C.7.b', 'IM', 3.95, 31, 0.24, 3.45, 4.45, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.1.a', 'IM', 3.32, 28, 0.22, 2.88, 3.77, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.1.b', 'IM', 3.67, 28, 0.18, 3.30, 4.04, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.1.c', 'IM', 3.73, 28, 0.26, 3.19, 4.27, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.2.b', 'IM', 3.12, 28, 0.22, 2.67, 3.58, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.3.a', 'IM', 4.16, 28, 0.25, 3.64, 4.68, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.3.b', 'IM', 3.84, 28, 0.31, 3.21, 4.48, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.3.c', 'IM', 2.59, 27, 0.30, 1.97, 3.21, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.4.a', 'IM', 3.90, 28, 0.31, 3.26, 4.55, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.4.b', 'IM', 3.10, 28, 0.39, 2.31, 3.89, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.4.c', 'IM', 4.07, 28, 0.22, 3.61, 4.52, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.5.a', 'IM', 4.13, 28, 0.25, 3.61, 4.64, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.5.b', 'IM', 4.65, 28, 0.12, 4.41, 4.90, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.5.c', 'IM', 4.09, 28, 0.25, 3.58, 4.60, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.6', 'IM', 3.83, 28, 0.25, 3.32, 4.34, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.7.a', 'IM', 3.15, 28, 0.32, 2.50, 3.80, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4031.00', '1.C.7.b', 'IM', 4.18, 28, 0.24, 3.69, 4.66, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.1.a', 'IM', 3.43, 18, 0.19, 3.02, 3.84, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.1.b', 'IM', 3.84, 18, 0.18, 3.46, 4.22, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.1.c', 'IM', 4.06, 18, 0.21, 3.62, 4.50, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.2.b', 'IM', 3.70, 18, 0.30, 3.07, 4.32, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.3.a', 'IM', 3.59, 18, 0.22, 3.12, 4.05, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.3.b', 'IM', 3.00, 18, 0.33, 2.29, 3.70, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.3.c', 'IM', 3.11, 18, 0.41, 2.25, 3.98, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.4.a', 'IM', 3.83, 18, 0.21, 3.40, 4.27, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.4.b', 'IM', 3.70, 18, 0.21, 3.27, 4.14, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.4.c', 'IM', 4.17, 18, 0.12, 3.92, 4.42, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.5.a', 'IM', 4.25, 18, 0.16, 3.90, 4.59, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.5.b', 'IM', 4.33, 18, 0.11, 4.09, 4.57, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.5.c', 'IM', 4.39, 18, 0.26, 3.84, 4.93, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.6', 'IM', 4.30, 18, 0.18, 3.92, 4.68, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.7.a', 'IM', 3.87, 18, 0.23, 3.40, 4.35, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.01', '1.C.7.b', 'IM', 4.00, 18, 0.20, 3.58, 4.41, 'N', '2006-12-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.1.a', 'IM', 4.02, 17, 0.20, 3.59, 4.44, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.1.b', 'IM', 3.95, 17, 0.08, 3.77, 4.12, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.1.c', 'IM', 4.30, 17, 0.15, 3.99, 4.61, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.2.b', 'IM', 4.08, 17, 0.31, 3.43, 4.74, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.3.a', 'IM', 4.08, 17, 0.22, 3.62, 4.54, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.3.b', 'IM', 4.06, 17, 0.23, 3.56, 4.56, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.3.c', 'IM', 3.48, 17, 0.38, 2.68, 4.28, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.4.a', 'IM', 3.85, 17, 0.27, 3.27, 4.42, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.4.b', 'IM', 3.72, 17, 0.40, 2.88, 4.57, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.4.c', 'IM', 4.25, 17, 0.22, 3.79, 4.71, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.5.a', 'IM', 4.68, 17, 0.14, 4.39, 4.98, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.5.b', 'IM', 4.82, 17, 0.09, 4.62, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.5.c', 'IM', 4.34, 17, 0.22, 3.88, 4.81, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.6', 'IM', 4.23, 17, 0.19, 3.83, 4.63, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.7.a', 'IM', 3.58, 17, 0.14, 3.27, 3.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4041.02', '1.C.7.b', 'IM', 3.98, 17, 0.42, 3.09, 4.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.1.a', 'IM', 3.39, 22, 0.24, 2.88, 3.90, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.1.b', 'IM', 3.59, 22, 0.24, 3.08, 4.09, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.1.c', 'IM', 3.58, 22, 0.20, 3.16, 4.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.2.b', 'IM', 3.11, 22, 0.27, 2.54, 3.68, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.3.a', 'IM', 3.59, 22, 0.26, 3.06, 4.12, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.3.b', 'IM', 2.93, 22, 0.21, 2.48, 3.37, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.3.c', 'IM', 2.93, 22, 0.21, 2.49, 3.36, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.4.a', 'IM', 3.80, 22, 0.17, 3.45, 4.15, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.4.b', 'IM', 4.13, 22, 0.20, 3.72, 4.54, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.4.c', 'IM', 4.13, 22, 0.22, 3.66, 4.59, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.5.a', 'IM', 4.45, 22, 0.17, 4.09, 4.81, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.5.b', 'IM', 4.91, 22, 0.06, 4.78, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.5.c', 'IM', 4.83, 22, 0.13, 4.56, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.6', 'IM', 3.41, 22, 0.24, 2.92, 3.90, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.7.a', 'IM', 2.26, 22, 0.18, 1.90, 2.63, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.01', '1.C.7.b', 'IM', 3.86, 22, 0.23, 3.38, 4.35, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.1.a', 'IM', 3.59, 33, 0.23, 3.13, 4.05, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.1.b', 'IM', 3.67, 33, 0.23, 3.20, 4.15, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.1.c', 'IM', 3.61, 33, 0.23, 3.14, 4.08, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.2.b', 'IM', 3.53, 33, 0.27, 2.98, 4.08, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.3.a', 'IM', 4.04, 33, 0.21, 3.60, 4.47, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.3.b', 'IM', 3.52, 33, 0.23, 3.05, 3.99, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.3.c', 'IM', 2.96, 33, 0.26, 2.44, 3.48, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.4.a', 'IM', 3.93, 33, 0.20, 3.53, 4.34, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.4.b', 'IM', 3.65, 32, 0.29, 3.05, 4.25, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.4.c', 'IM', 3.55, 33, 0.24, 3.06, 4.04, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.5.a', 'IM', 4.05, 33, 0.31, 3.41, 4.69, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.5.b', 'IM', 4.75, 33, 0.10, 4.55, 4.94, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.5.c', 'IM', 4.69, 33, 0.11, 4.47, 4.91, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.6', 'IM', 3.81, 32, 0.17, 3.46, 4.16, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.7.a', 'IM', 3.04, 33, 0.24, 2.55, 3.53, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4051.02', '1.C.7.b', 'IM', 3.61, 33, 0.12, 3.38, 3.85, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.1.a', 'IM', 4.22, 37, 0.17, 3.87, 4.57, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.1.b', 'IM', 4.28, 37, 0.16, 3.95, 4.61, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.1.c', 'IM', 4.28, 37, 0.12, 4.04, 4.51, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.2.b', 'IM', 3.43, 37, 0.44, 2.53, 4.33, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.3.a', 'IM', 4.29, 37, 0.24, 3.80, 4.78, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.3.b', 'IM', 3.71, 37, 0.29, 3.12, 4.30, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.3.c', 'IM', 3.09, 37, 0.27, 2.54, 3.64, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.4.a', 'IM', 3.65, 37, 0.33, 2.99, 4.32, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.4.b', 'IM', 3.47, 37, 0.38, 2.69, 4.25, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.4.c', 'IM', 4.38, 37, 0.19, 3.99, 4.77, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.5.a', 'IM', 4.50, 37, 0.14, 4.22, 4.79, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.5.b', 'IM', 4.58, 37, 0.18, 4.22, 4.93, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.5.c', 'IM', 4.62, 37, 0.15, 4.32, 4.91, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.6', 'IM', 4.47, 37, 0.13, 4.22, 4.73, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.7.a', 'IM', 3.87, 37, 0.26, 3.34, 4.41, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.00', '1.C.7.b', 'IM', 4.54, 37, 0.17, 4.20, 4.88, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.1.a', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.1.b', 'IM', 3.80, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.1.c', 'IM', 3.75, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.2.b', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.3.a', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.3.b', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.3.c', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.4.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.4.b', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.4.c', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.5.a', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.5.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.5.c', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.6', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.7.a', 'IM', 3.25, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4061.01', '1.C.7.b', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.1.a', 'IM', 3.89, 37, 0.12, 3.64, 4.14, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.1.b', 'IM', 3.74, 37, 0.18, 3.37, 4.11, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.1.c', 'IM', 4.07, 37, 0.22, 3.62, 4.51, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.2.b', 'IM', 3.58, 37, 0.32, 2.93, 4.24, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.3.a', 'IM', 4.08, 37, 0.21, 3.66, 4.50, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.3.b', 'IM', 3.65, 37, 0.21, 3.23, 4.07, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.3.c', 'IM', 2.69, 37, 0.22, 2.24, 3.14, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.4.a', 'IM', 3.58, 37, 0.21, 3.16, 4.01, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.4.b', 'IM', 3.42, 37, 0.21, 3.00, 3.84, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.4.c', 'IM', 3.88, 37, 0.23, 3.41, 4.35, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.5.a', 'IM', 4.27, 37, 0.19, 3.88, 4.65, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.5.b', 'IM', 4.28, 37, 0.21, 3.85, 4.70, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.5.c', 'IM', 4.33, 37, 0.16, 4.00, 4.65, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.6', 'IM', 3.87, 37, 0.25, 3.36, 4.38, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.7.a', 'IM', 3.22, 37, 0.24, 2.73, 3.71, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4091.00', '1.C.7.b', 'IM', 4.26, 37, 0.14, 3.97, 4.55, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.1.a', 'IM', 3.87, 33, 0.17, 3.52, 4.22, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.1.b', 'IM', 4.31, 33, 0.18, 3.93, 4.68, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.1.c', 'IM', 4.27, 33, 0.20, 3.87, 4.68, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.2.b', 'IM', 3.84, 33, 0.21, 3.42, 4.27, 'N', '2009-06-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.3.a', 'IM', 4.43, 33, 0.19, 4.05, 4.82, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.3.b', 'IM', 3.51, 33, 0.17, 3.17, 3.86, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.3.c', 'IM', 3.39, 33, 0.27, 2.85, 3.94, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.4.a', 'IM', 4.30, 33, 0.17, 3.95, 4.66, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.4.b', 'IM', 4.37, 33, 0.23, 3.91, 4.83, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.4.c', 'IM', 4.16, 33, 0.21, 3.73, 4.59, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.5.a', 'IM', 4.71, 33, 0.11, 4.48, 4.94, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.5.b', 'IM', 4.93, 33, 0.05, 4.84, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.5.c', 'IM', 5.00, 33, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.6', 'IM', 4.21, 33, 0.24, 3.73, 4.69, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.7.a', 'IM', 4.09, 33, 0.27, 3.54, 4.64, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4092.00', '1.C.7.b', 'IM', 4.37, 33, 0.11, 4.14, 4.60, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.1.a', 'IM', 3.68, 25, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.1.b', 'IM', 3.76, 25, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.1.c', 'IM', 4.24, 25, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.2.b', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.3.a', 'IM', 4.04, 25, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.3.b', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.3.c', 'IM', 3.40, 25, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.4.a', 'IM', 4.04, 25, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.4.b', 'IM', 3.80, 25, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.4.c', 'IM', 3.96, 25, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.5.a', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.5.b', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.5.c', 'IM', 4.27, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.6', 'IM', 4.04, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.7.a', 'IM', 3.54, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4093.00', '1.C.7.b', 'IM', 3.73, 26, NULL, NULL, NULL, NULL, '2010-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.1.a', 'IM', 3.79, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.1.b', 'IM', 3.93, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.1.c', 'IM', 4.07, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.2.b', 'IM', 3.25, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.3.a', 'IM', 3.93, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.3.b', 'IM', 3.57, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.3.c', 'IM', 2.86, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.4.a', 'IM', 3.43, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.4.b', 'IM', 3.32, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.4.c', 'IM', 3.57, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.5.a', 'IM', 4.36, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.5.b', 'IM', 4.43, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.5.c', 'IM', 4.46, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.6', 'IM', 3.68, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.7.a', 'IM', 3.71, 28, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4099.02', '1.C.7.b', 'IM', 4.11, 27, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.1.a', 'IM', 3.63, 30, 0.20, 3.22, 4.05, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.1.b', 'IM', 4.08, 30, 0.19, 3.69, 4.47, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.1.c', 'IM', 4.11, 30, 0.16, 3.78, 4.44, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.2.b', 'IM', 3.69, 30, 0.29, 3.10, 4.27, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.3.a', 'IM', 4.36, 29, 0.17, 4.01, 4.71, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.3.b', 'IM', 4.64, 29, 0.11, 4.43, 4.86, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.3.c', 'IM', 4.43, 29, 0.12, 4.19, 4.67, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.4.a', 'IM', 4.68, 29, 0.10, 4.47, 4.89, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.4.b', 'IM', 4.68, 29, 0.06, 4.55, 4.81, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.4.c', 'IM', 4.27, 29, 0.13, 4.00, 4.55, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.5.a', 'IM', 4.64, 29, 0.11, 4.42, 4.85, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.5.b', 'IM', 4.26, 29, 0.10, 4.05, 4.48, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.5.c', 'IM', 4.56, 30, 0.13, 4.29, 4.83, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.6', 'IM', 4.16, 30, 0.22, 3.71, 4.61, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.7.a', 'IM', 4.08, 30, 0.17, 3.73, 4.42, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1011.00', '1.C.7.b', 'IM', 4.06, 30, 0.17, 3.71, 4.42, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.1.a', 'IM', 3.90, 39, 0.23, 3.44, 4.36, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.1.b', 'IM', 4.41, 39, 0.14, 4.12, 4.70, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.1.c', 'IM', 4.52, 39, 0.14, 4.23, 4.82, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.2.b', 'IM', 4.48, 39, 0.14, 4.19, 4.77, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.3.a', 'IM', 4.66, 39, 0.14, 4.37, 4.94, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.3.b', 'IM', 4.86, 39, 0.11, 4.63, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.3.c', 'IM', 4.50, 39, 0.19, 4.12, 4.88, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.4.a', 'IM', 4.67, 39, 0.14, 4.39, 4.96, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.4.b', 'IM', 4.51, 39, 0.14, 4.21, 4.80, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.4.c', 'IM', 4.54, 38, 0.14, 4.25, 4.83, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.5.a', 'IM', 4.53, 39, 0.15, 4.23, 4.82, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.5.b', 'IM', 4.38, 39, 0.13, 4.12, 4.65, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.5.c', 'IM', 4.88, 39, 0.09, 4.70, 5.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.6', 'IM', 4.19, 39, 0.18, 3.83, 4.55, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.7.a', 'IM', 3.96, 39, 0.25, 3.45, 4.47, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1012.00', '1.C.7.b', 'IM', 3.91, 39, 0.31, 3.29, 4.52, 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.1.a', 'IM', 4.04, 23, 0.30, 3.41, 4.66, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.1.b', 'IM', 4.47, 23, 0.23, 4.00, 4.94, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.1.c', 'IM', 4.30, 23, 0.26, 3.76, 4.84, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.2.b', 'IM', 4.35, 23, 0.22, 3.89, 4.81, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.3.a', 'IM', 4.56, 23, 0.17, 4.21, 4.92, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.3.b', 'IM', 4.97, 23, 0.03, 4.92, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.3.c', 'IM', 4.40, 23, 0.16, 4.07, 4.74, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.4.a', 'IM', 4.87, 23, 0.09, 4.68, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.4.b', 'IM', 4.72, 23, 0.08, 4.56, 4.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.4.c', 'IM', 4.37, 23, 0.24, 3.86, 4.87, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.5.a', 'IM', 4.92, 23, 0.08, 4.76, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.5.b', 'IM', 4.27, 23, 0.24, 3.78, 4.76, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.5.c', 'IM', 5.00, 22, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.6', 'IM', 4.43, 22, 0.11, 4.20, 4.66, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.7.a', 'IM', 4.32, 21, 0.19, 3.92, 4.72, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1013.00', '1.C.7.b', 'IM', 4.43, 22, 0.23, 3.96, 4.91, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.1.a', 'IM', 4.10, 25, 0.21, 3.68, 4.52, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.1.b', 'IM', 4.12, 25, 0.20, 3.70, 4.54, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.1.c', 'IM', 4.02, 25, 0.25, 3.51, 4.52, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.2.b', 'IM', 3.70, 25, 0.18, 3.33, 4.07, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.3.a', 'IM', 4.35, 26, 0.18, 3.98, 4.71, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.3.b', 'IM', 4.83, 26, 0.08, 4.67, 4.99, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.3.c', 'IM', 4.63, 26, 0.15, 4.32, 4.94, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.4.a', 'IM', 4.87, 26, 0.08, 4.70, 5.00, 'N', '2009-06-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.4.b', 'IM', 4.67, 26, 0.12, 4.43, 4.92, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.4.c', 'IM', 4.53, 26, 0.16, 4.20, 4.85, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.5.a', 'IM', 4.77, 26, 0.08, 4.60, 4.94, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.5.b', 'IM', 4.30, 26, 0.25, 3.78, 4.81, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.5.c', 'IM', 4.50, 26, 0.32, 3.85, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.6', 'IM', 4.13, 26, 0.11, 3.90, 4.36, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.7.a', 'IM', 3.57, 26, 0.21, 3.13, 4.01, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1014.00', '1.C.7.b', 'IM', 4.05, 26, 0.16, 3.72, 4.37, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.1.a', 'IM', 3.87, 21, 0.11, 3.63, 4.11, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.1.b', 'IM', 3.91, 21, 0.21, 3.46, 4.36, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.1.c', 'IM', 4.13, 21, 0.08, 3.96, 4.31, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.2.b', 'IM', 3.98, 21, 0.31, 3.33, 4.63, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.3.a', 'IM', 4.03, 21, 0.13, 3.75, 4.30, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.3.b', 'IM', 4.39, 21, 0.23, 3.91, 4.86, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.3.c', 'IM', 4.29, 21, 0.21, 3.86, 4.72, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.4.a', 'IM', 4.50, 21, 0.26, 3.97, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.4.b', 'IM', 4.25, 21, 0.23, 3.77, 4.74, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.4.c', 'IM', 4.22, 21, 0.25, 3.69, 4.75, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.5.a', 'IM', 4.70, 21, 0.21, 4.26, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.5.b', 'IM', 4.38, 21, 0.13, 4.11, 4.65, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.5.c', 'IM', 4.37, 21, 0.19, 3.97, 4.76, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.6', 'IM', 4.07, 21, 0.27, 3.50, 4.64, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.7.a', 'IM', 3.65, 21, 0.17, 3.29, 4.01, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1015.00', '1.C.7.b', 'IM', 3.88, 21, 0.21, 3.43, 4.32, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.1.a', 'IM', 3.88, 30, 0.26, 3.34, 4.42, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.1.b', 'IM', 4.20, 30, 0.32, 3.54, 4.86, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.1.c', 'IM', 4.10, 30, 0.27, 3.56, 4.65, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.2.b', 'IM', 3.81, 29, 0.11, 3.59, 4.04, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.3.a', 'IM', 4.76, 30, 0.12, 4.53, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.3.b', 'IM', 4.84, 30, 0.10, 4.64, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.3.c', 'IM', 4.16, 30, 0.18, 3.79, 4.54, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.4.a', 'IM', 4.84, 30, 0.10, 4.63, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.4.b', 'IM', 4.73, 30, 0.11, 4.50, 4.96, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.4.c', 'IM', 4.77, 30, 0.11, 4.54, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.5.a', 'IM', 4.72, 30, 0.12, 4.47, 4.96, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.5.b', 'IM', 4.33, 30, 0.12, 4.09, 4.58, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.5.c', 'IM', 4.69, 29, 0.20, 4.29, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.6', 'IM', 3.60, 30, 0.17, 3.25, 3.95, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.7.a', 'IM', 3.35, 30, 0.21, 2.92, 3.78, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1021.00', '1.C.7.b', 'IM', 3.78, 30, 0.20, 3.38, 4.19, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.1.a', 'IM', 3.89, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.1.b', 'IM', 4.33, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.1.c', 'IM', 4.44, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.2.b', 'IM', 4.07, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.3.a', 'IM', 4.52, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.3.b', 'IM', 4.88, 26, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.3.c', 'IM', 4.59, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.4.a', 'IM', 4.78, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.4.b', 'IM', 4.63, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.4.c', 'IM', 4.63, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.5.a', 'IM', 4.78, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.5.b', 'IM', 4.30, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.5.c', 'IM', 4.93, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.6', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.7.a', 'IM', 3.78, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1022.00', '1.C.7.b', 'IM', 4.11, 27, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.1.a', 'IM', 4.08, 29, 0.15, 3.77, 4.38, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.1.b', 'IM', 4.31, 29, 0.14, 4.02, 4.61, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.1.c', 'IM', 4.27, 29, 0.18, 3.89, 4.65, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.2.b', 'IM', 3.72, 29, 0.17, 3.38, 4.07, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.3.a', 'IM', 4.64, 29, 0.08, 4.46, 4.81, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.3.b', 'IM', 4.80, 29, 0.16, 4.47, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.3.c', 'IM', 4.66, 29, 0.09, 4.48, 4.84, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.4.a', 'IM', 4.80, 29, 0.10, 4.60, 4.99, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.4.b', 'IM', 4.41, 29, 0.12, 4.16, 4.66, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.4.c', 'IM', 4.53, 29, 0.13, 4.26, 4.80, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.5.a', 'IM', 4.65, 29, 0.09, 4.46, 4.84, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.5.b', 'IM', 4.34, 29, 0.08, 4.18, 4.50, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.5.c', 'IM', 4.79, 29, 0.10, 4.58, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.6', 'IM', 4.29, 29, 0.17, 3.95, 4.63, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.7.a', 'IM', 3.97, 29, 0.23, 3.49, 4.45, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1023.00', '1.C.7.b', 'IM', 3.93, 29, 0.24, 3.43, 4.42, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.1.a', 'IM', 4.36, 26, 0.20, 3.95, 4.77, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.1.b', 'IM', 4.33, 26, 0.20, 3.91, 4.75, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.1.c', 'IM', 4.49, 26, 0.15, 4.18, 4.80, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.2.b', 'IM', 4.44, 26, 0.15, 4.13, 4.76, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.3.a', 'IM', 4.92, 26, 0.05, 4.82, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.3.b', 'IM', 4.87, 26, 0.08, 4.71, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.3.c', 'IM', 4.67, 26, 0.11, 4.45, 4.89, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.4.a', 'IM', 4.82, 26, 0.09, 4.65, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.4.b', 'IM', 4.65, 26, 0.20, 4.24, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.4.c', 'IM', 4.73, 26, 0.15, 4.41, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.5.a', 'IM', 4.83, 25, 0.11, 4.61, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.5.b', 'IM', 4.59, 25, 0.20, 4.17, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.5.c', 'IM', 4.93, 26, 0.05, 4.82, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.6', 'IM', 4.81, 26, 0.11, 4.58, 5.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.7.a', 'IM', 4.62, 26, 0.18, 4.24, 4.99, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1091.00', '1.C.7.b', 'IM', 4.56, 26, 0.15, 4.25, 4.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.1.a', 'IM', 4.05, 41, 0.19, 3.67, 4.44, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.1.b', 'IM', 4.27, 41, 0.15, 3.96, 4.58, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.1.c', 'IM', 4.16, 41, 0.17, 3.81, 4.51, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.2.b', 'IM', 4.01, 41, 0.16, 3.67, 4.34, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.3.a', 'IM', 4.49, 41, 0.14, 4.21, 4.78, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.3.b', 'IM', 4.47, 41, 0.14, 4.19, 4.76, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.3.c', 'IM', 4.16, 41, 0.17, 3.82, 4.51, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.4.a', 'IM', 4.77, 41, 0.08, 4.61, 4.94, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.4.b', 'IM', 4.76, 41, 0.09, 4.59, 4.94, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.4.c', 'IM', 4.54, 41, 0.12, 4.30, 4.77, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.5.a', 'IM', 4.68, 41, 0.10, 4.47, 4.89, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.5.b', 'IM', 4.63, 41, 0.08, 4.47, 4.80, 'N', '2011-07-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.5.c', 'IM', 4.86, 41, 0.06, 4.75, 4.98, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.6', 'IM', 4.54, 41, 0.13, 4.28, 4.80, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.7.a', 'IM', 3.90, 41, 0.15, 3.59, 4.21, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1092.00', '1.C.7.b', 'IM', 4.19, 41, 0.22, 3.75, 4.63, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.1.a', 'IM', 3.95, 23, 0.15, 3.64, 4.25, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.1.b', 'IM', 4.14, 23, 0.15, 3.83, 4.46, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.1.c', 'IM', 3.88, 23, 0.16, 3.54, 4.21, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.2.b', 'IM', 3.82, 23, 0.17, 3.48, 4.17, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.3.a', 'IM', 4.62, 24, 0.16, 4.29, 4.95, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.3.b', 'IM', 4.70, 24, 0.10, 4.49, 4.90, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.3.c', 'IM', 4.44, 24, 0.13, 4.17, 4.71, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.4.a', 'IM', 4.69, 24, 0.12, 4.45, 4.93, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.4.b', 'IM', 4.40, 24, 0.19, 4.00, 4.79, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.4.c', 'IM', 3.98, 24, 0.19, 3.57, 4.38, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.5.a', 'IM', 4.76, 23, 0.08, 4.59, 4.93, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.5.b', 'IM', 4.48, 24, 0.13, 4.22, 4.75, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.5.c', 'IM', 4.55, 24, 0.16, 4.23, 4.88, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.6', 'IM', 3.67, 24, 0.13, 3.40, 3.93, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.7.a', 'IM', 3.54, 24, 0.19, 3.15, 3.92, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-1093.00', '1.C.7.b', 'IM', 3.68, 23, 0.17, 3.33, 4.04, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.1.a', 'IM', 3.48, 20, 0.48, 2.47, 4.49, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.1.b', 'IM', 3.98, 20, 0.26, 3.43, 4.52, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.1.c', 'IM', 3.92, 20, 0.24, 3.41, 4.43, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.2.b', 'IM', 3.99, 20, 0.22, 3.53, 4.44, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.3.a', 'IM', 4.17, 20, 0.22, 3.72, 4.62, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.3.b', 'IM', 4.20, 20, 0.30, 3.58, 4.82, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.3.c', 'IM', 3.77, 20, 0.26, 3.23, 4.31, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.4.a', 'IM', 4.19, 19, 0.30, 3.57, 4.82, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.4.b', 'IM', 4.09, 20, 0.29, 3.49, 4.68, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.4.c', 'IM', 3.97, 20, 0.26, 3.42, 4.51, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.5.a', 'IM', 4.15, 20, 0.21, 3.71, 4.59, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.5.b', 'IM', 3.94, 20, 0.21, 3.50, 4.39, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.5.c', 'IM', 4.38, 20, 0.31, 3.74, 5.00, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.6', 'IM', 3.61, 20, 0.47, 2.62, 4.60, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.7.a', 'IM', 3.80, 20, 0.36, 3.05, 4.54, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2011.00', '1.C.7.b', 'IM', 3.57, 20, 0.16, 3.23, 3.92, 'N', '2006-12-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.1.a', 'IM', 3.60, 48, 0.48, 2.63, 4.57, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.1.b', 'IM', 4.07, 48, 0.44, 3.19, 4.95, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.1.c', 'IM', 4.56, 47, 0.19, 4.18, 4.94, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.2.b', 'IM', 4.96, 47, 0.02, 4.92, 5.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.3.a', 'IM', 4.72, 48, 0.15, 4.42, 5.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.3.b', 'IM', 4.74, 46, 0.15, 4.44, 5.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.3.c', 'IM', 4.88, 48, 0.08, 4.72, 5.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.4.a', 'IM', 4.80, 48, 0.14, 4.52, 5.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.4.b', 'IM', 4.54, 48, 0.17, 4.19, 4.89, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.4.c', 'IM', 4.32, 47, 0.19, 3.94, 4.70, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.5.a', 'IM', 4.80, 48, 0.14, 4.52, 5.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.5.b', 'IM', 3.85, 48, 0.25, 3.35, 4.35, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.5.c', 'IM', 4.82, 48, 0.14, 4.53, 5.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.6', 'IM', 4.43, 48, 0.22, 3.99, 4.88, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.7.a', 'IM', 4.29, 48, 0.19, 3.91, 4.67, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('21-2021.00', '1.C.7.b', 'IM', 4.02, 48, 0.29, 3.43, 4.62, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.1.a', 'IM', 4.59, 40, 0.14, 4.30, 4.88, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.1.b', 'IM', 4.61, 40, 0.12, 4.37, 4.85, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.1.c', 'IM', 4.47, 40, 0.12, 4.22, 4.72, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.2.b', 'IM', 4.22, 40, 0.18, 3.86, 4.58, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.3.a', 'IM', 4.24, 40, 0.18, 3.89, 4.60, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.3.b', 'IM', 3.84, 40, 0.28, 3.28, 4.40, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.3.c', 'IM', 3.26, 40, 0.31, 2.64, 3.88, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.4.a', 'IM', 4.31, 40, 0.15, 4.00, 4.62, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.4.b', 'IM', 4.63, 40, 0.12, 4.38, 4.88, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.4.c', 'IM', 4.01, 40, 0.18, 3.65, 4.36, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.5.a', 'IM', 4.66, 40, 0.12, 4.41, 4.91, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.5.b', 'IM', 4.67, 40, 0.10, 4.48, 4.87, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.5.c', 'IM', 4.98, 39, 0.02, 4.94, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.6', 'IM', 4.44, 40, 0.11, 4.21, 4.67, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.7.a', 'IM', 3.89, 40, 0.24, 3.41, 4.37, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1011.00', '1.C.7.b', 'IM', 4.77, 40, 0.12, 4.53, 5.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.1.a', 'IM', 4.31, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.1.b', 'IM', 4.38, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.1.c', 'IM', 4.48, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.2.b', 'IM', 3.58, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.3.a', 'IM', 4.27, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.3.b', 'IM', 3.59, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.3.c', 'IM', 3.06, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.4.a', 'IM', 4.16, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.4.b', 'IM', 4.48, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.4.c', 'IM', 3.90, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.5.a', 'IM', 4.70, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.5.b', 'IM', 4.71, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.5.c', 'IM', 4.74, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.6', 'IM', 4.42, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.7.a', 'IM', 3.31, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1012.00', '1.C.7.b', 'IM', 4.36, NULL, NULL, NULL, NULL, 'N', '2011-02-01', 'Analyst');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.1.a', 'IM', 4.15, 32, 0.17, 3.81, 4.49, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.1.b', 'IM', 4.07, 33, 0.15, 3.77, 4.37, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.1.c', 'IM', 3.97, 33, 0.21, 3.55, 4.39, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.2.b', 'IM', 3.99, 33, 0.26, 3.46, 4.51, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.3.a', 'IM', 4.08, 33, 0.17, 3.73, 4.43, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.3.b', 'IM', 3.81, 33, 0.21, 3.37, 4.24, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.3.c', 'IM', 3.54, 33, 0.27, 3.00, 4.09, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.4.a', 'IM', 4.72, 33, 0.13, 4.46, 4.98, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.4.b', 'IM', 4.38, 33, 0.16, 4.06, 4.70, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.4.c', 'IM', 3.99, 33, 0.21, 3.57, 4.41, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.5.a', 'IM', 4.55, 33, 0.16, 4.23, 4.88, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.5.b', 'IM', 4.53, 33, 0.16, 4.20, 4.85, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.5.c', 'IM', 4.87, 33, 0.08, 4.70, 5.00, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.6', 'IM', 4.04, 33, 0.30, 3.43, 4.64, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.7.a', 'IM', 3.45, 33, 0.21, 3.03, 3.86, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1021.00', '1.C.7.b', 'IM', 4.39, 33, 0.16, 4.05, 4.72, 'N', '2011-07-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('23-1022.00', '1.C.1.a', 'IM', 4.29, 34, 0.20, 3.89, 4.69, 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower