CREATE TABLE task_ratings (
  onetsoc_code CHARACTER(10) NOT NULL,
  task_id DECIMAL(8,0) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  category DECIMAL(3,0),
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(5,2),
  lower_ci_bound DECIMAL(5,2),
  upper_ci_bound DECIMAL(5,2),
  recommend_suppress CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (task_id) REFERENCES task_statements(task_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id),
  FOREIGN KEY (scale_id, category) REFERENCES task_categories(scale_id, category));
GO

INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 1, 0.23, 93, 0.22, 0.04, 1.49, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 2, 22.77, 93, 10.16, 8.56, 48.15, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 3, 34.24, 93, 10.62, 16.94, 57.06, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 4, 13.14, 93, 5.65, 5.36, 28.81, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 5, 19.56, 93, 8.87, 7.35, 42.69, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 6, 5.58, 93, 4.36, 1.13, 23.44, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 7, 4.48, 93, 4.09, 0.70, 23.82, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'IM', NULL, 4.51, 93, 0.13, 4.26, 4.77, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'RT', NULL, 90.54, 105, 5.42, 73.17, 97.11, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 1, 0.00, 103, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 2, 1.05, 103, 0.52, 0.39, 2.77, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 3, 41.58, 103, 9.39, 24.85, 60.50, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 4, 12.21, 103, 4.82, 5.40, 25.32, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 5, 34.12, 103, 10.79, 16.66, 57.29, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 6, 6.30, 103, 3.98, 1.73, 20.40, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 7, 4.74, 103, 3.75, 0.95, 20.54, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'IM', NULL, 4.38, 102, 0.12, 4.15, 4.61, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'RT', NULL, 99.82, 104, 0.18, 98.67, 99.98, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 1, 3.94, 96, 3.48, 0.66, 20.25, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 2, 22.55, 96, 8.60, 9.87, 43.63, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 3, 35.07, 96, 9.23, 19.45, 54.71, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 4, 6.73, 96, 4.10, 1.94, 20.85, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 5, 18.82, 96, 7.94, 7.63, 39.42, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 6, 8.23, 96, 7.09, 1.37, 36.62, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 7, 4.65, 96, 4.05, 0.79, 23.06, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'IM', NULL, 4.34, 96, 0.15, 4.03, 4.64, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'RT', NULL, 91.67, 105, 4.89, 75.56, 97.51, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 1, 0.00, 99, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 2, 25.14, 99, 10.14, 10.34, 49.46, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 3, 21.89, 99, 6.81, 11.28, 38.18, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 4, 5.23, 99, 2.24, 2.21, 11.91, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 5, 39.45, 99, 11.03, 20.66, 61.97, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 6, 7.67, 99, 7.02, 1.15, 37.29, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 7, 0.62, 99, 0.59, 0.09, 4.01, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'IM', NULL, 4.19, 98, 0.14, 3.91, 4.47, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'RT', NULL, 92.33, 105, 4.78, 75.93, 97.87, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 1, 25.97, 98, 8.86, 12.32, 46.69, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 2, 38.34, 98, 11.32, 19.39, 61.65, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 3, 18.57, 98, 7.68, 7.69, 38.44, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 4, 9.76, 98, 4.90, 3.46, 24.61, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 5, 7.29, 98, 4.60, 2.00, 23.26, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 6, 0.00, 98, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 7, 0.07, 98, 0.07, 0.01, 0.55, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'IM', NULL, 4.13, 96, 0.14, 3.84, 4.42, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'RT', NULL, 94.73, 105, 3.77, 80.10, 98.77, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 1, 0.67, 68, 0.66, 0.09, 4.69, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 2, 6.77, 68, 5.53, 1.24, 29.47, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 3, 54.31, 68, 11.85, 31.42, 75.52, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 4, 8.55, 68, 4.68, 2.75, 23.57, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 5, 16.47, 68, 7.80, 5.98, 37.94, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 6, 1.95, 68, 1.33, 0.49, 7.41, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 7, 11.29, 68, 7.74, 2.65, 37.29, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'IM', NULL, 4.06, 66, 0.19, 3.69, 4.43, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'RT', NULL, 67.57, 104, 10.34, 44.98, 84.15, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 1, 5.03, 89, 4.30, 0.88, 24.02, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 2, 38.07, 89, 11.68, 18.68, 62.20, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 3, 39.48, 89, 9.87, 22.30, 59.73, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 4, 1.77, 89, 0.98, 0.59, 5.24, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 5, 15.64, 89, 7.68, 5.51, 37.10, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 6, 0.00, 89, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 7, 0.00, 89, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'IM', NULL, 4.03, 89, 0.18, 3.66, 4.39, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'RT', NULL, 85.46, 104, 6.56, 67.35, 94.37, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 1, 0.00, 99, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 2, 8.41, 99, 5.39, 2.24, 26.91, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 3, 43.68, 99, 10.85, 24.44, 65.04, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 4, 13.90, 99, 6.18, 5.47, 31.02, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 5, 20.51, 99, 6.76, 10.18, 37.02, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 6, 9.61, 99, 6.91, 2.15, 33.99, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 7, 3.88, 99, 3.84, 0.52, 23.78, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'IM', NULL, 3.98, 94, 0.13, 3.72, 4.24, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'RT', NULL, 95.45, 105, 3.27, 82.47, 98.94, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 1, 20.41, 100, 9.39, 7.53, 44.68, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 2, 41.17, 100, 10.42, 22.96, 62.17, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 3, 20.46, 100, 8.51, 8.35, 42.07, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 4, 6.17, 100, 3.98, 1.66, 20.43, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 5, 7.40, 100, 4.13, 2.37, 20.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 6, 3.82, 100, 3.73, 0.53, 22.91, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 7, 0.56, 100, 0.56, 0.07, 4.04, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'IM', NULL, 3.97, 97, 0.15, 3.66, 4.27, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'RT', NULL, 98.93, 104, 0.63, 96.61, 99.67, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 1, 9.75, 97, 5.49, 3.04, 27.17, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 2, 35.81, 97, 11.88, 16.67, 60.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 3, 19.82, 97, 7.89, 8.45, 39.84, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 4, 9.59, 97, 4.26, 3.85, 21.94, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 5, 17.65, 97, 8.28, 6.47, 39.92, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 6, 7.37, 97, 5.16, 1.74, 26.30, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 7, 0.00, 97, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'IM', NULL, 3.96, 96, 0.14, 3.68, 4.23, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'RT', NULL, 98.58, 104, 0.84, 95.51, 99.56, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 1, 0.34, 85, 0.21, 0.10, 1.15, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 2, 37.01, 85, 14.20, 14.89, 66.35, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 3, 43.67, 85, 13.21, 21.04, 69.28, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 4, 12.64, 85, 5.82, 4.82, 29.21, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 5, 6.35, 85, 4.92, 1.30, 25.97, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 6, 0.00, 85, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 7, 0.00, 85, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'IM', NULL, 3.84, 85, 0.23, 3.39, 4.29, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'RT', NULL, 75.10, 105, 8.84, 54.16, 88.51, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 1, 4.64, 99, 4.04, 0.79, 22.94, 'N', '2006-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 2, 34.46, 99, 11.73, 15.80, 59.57, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 3, 42.27, 99, 11.00, 23.04, 64.16, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 4, 12.64, 99, 5.86, 4.80, 29.33, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 5, 5.78, 99, 4.03, 1.39, 21.04, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 6, 0.21, 99, 0.21, 0.03, 1.52, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 7, 0.00, 99, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'IM', NULL, 3.80, 99, 0.13, 3.55, 4.06, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'RT', NULL, 92.63, 105, 4.31, 78.23, 97.77, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 1, 14.25, 96, 8.14, 4.24, 38.42, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 2, 9.71, 96, 4.49, 3.75, 22.92, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 3, 25.49, 96, 9.29, 11.47, 47.46, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 4, 21.94, 96, 6.56, 11.62, 37.55, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 5, 23.72, 96, 9.50, 9.88, 46.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 6, 4.62, 96, 3.99, 0.79, 22.64, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 7, 0.27, 96, 0.25, 0.04, 1.67, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'IM', NULL, 3.76, 95, 0.22, 3.31, 4.21, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'RT', NULL, 92.45, 104, 4.86, 75.49, 97.99, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 1, 8.90, 100, 5.42, 2.53, 26.89, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 2, 28.15, 100, 8.18, 14.94, 46.64, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 3, 34.87, 100, 10.20, 18.01, 56.62, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 4, 14.90, 100, 8.13, 4.68, 38.46, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 5, 9.06, 100, 4.75, 3.08, 23.82, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 6, 4.11, 100, 4.08, 0.55, 25.08, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 7, 0.00, 100, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'IM', NULL, 3.75, 98, 0.16, 3.42, 4.07, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'RT', NULL, 90.18, 105, 8.58, 57.32, 98.43, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 1, 15.24, 81, 7.00, 5.77, 34.58, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 2, 20.24, 81, 10.24, 6.70, 47.27, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 3, 42.46, 81, 11.32, 22.70, 64.98, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 4, 8.70, 81, 4.36, 3.09, 22.13, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 5, 6.72, 81, 4.69, 1.60, 24.17, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 6, 6.63, 81, 4.57, 1.61, 23.57, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 7, 0.00, 81, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'IM', NULL, 3.63, 79, 0.17, 3.29, 3.97, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'RT', NULL, 86.29, 103, 6.51, 67.86, 94.94, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 1, 0.62, 73, 0.63, 0.08, 4.59, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 2, 7.94, 73, 5.46, 1.91, 27.63, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 3, 38.66, 73, 10.78, 20.29, 60.93, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 4, 17.24, 73, 11.94, 3.78, 52.48, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 5, 34.38, 73, 11.38, 16.08, 58.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 6, 0.35, 73, 0.33, 0.05, 2.28, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 7, 0.81, 73, 0.58, 0.19, 3.36, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'IM', NULL, 3.61, 73, 0.22, 3.17, 4.04, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'RT', NULL, 68.15, 105, 9.69, 46.88, 83.84, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 1, 5.62, 91, 4.58, 1.06, 24.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 2, 37.17, 91, 11.95, 17.63, 62.05, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 3, 42.41, 91, 13.14, 20.19, 68.20, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 4, 10.12, 91, 8.02, 1.92, 39.34, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 5, 3.73, 91, 2.86, 0.79, 15.87, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 6, 0.95, 91, 0.68, 0.22, 3.92, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 7, 0.00, 91, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'IM', NULL, 3.50, 90, 0.15, 3.20, 3.79, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'RT', NULL, 80.79, 105, 6.31, 65.24, 90.41, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 1, 6.25, 67, 6.08, 0.83, 34.63, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 2, 16.53, 67, 7.91, 5.93, 38.36, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 3, 17.52, 67, 9.65, 5.30, 44.64, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 4, 32.20, 67, 15.31, 10.48, 65.83, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 5, 20.22, 67, 10.30, 6.61, 47.55, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 6, 6.90, 67, 6.14, 1.09, 33.31, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 7, 0.39, 67, 0.39, 0.05, 2.86, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'IM', NULL, 4.09, 67, 0.23, 3.64, 4.54, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'RT', NULL, 60.83, 103, 10.43, 39.46, 78.72, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8841, 'FT', 1, 1.16, 50, 0.73, 0.33, 4.02, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8841, 'FT', 2, 48.75, 50, 12.75, 25.43, 72.63, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8841, 'FT', 3, 13.40, 50, 5.10, 6.01, 27.22, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8841, 'FT', 4, 34.77, 50, 13.95, 13.41, 64.73, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8841, 'FT', 5, 1.93, 50, 1.32, 0.48, 7.43, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8841, 'FT', 6, 0.00, 50, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8841, 'FT', 7, 0.00, 50, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8841, 'IM', NULL, 4.07, 49, 0.24, 3.58, 4.56, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8841, 'RT', NULL, 33.72, 103, 8.19, 19.74, 51.27, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 1, 61.46, 31, 15.67, 29.23, 86.03, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 2, 30.97, 31, 15.18, 9.52, 65.67, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 3, 0.71, 31, 0.74, 0.08, 5.68, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 4, 6.87, 31, 6.15, 1.03, 34.41, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 5, 0.00, 31, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 6, 0.00, 31, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 7, 0.00, 31, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'IM', NULL, 3.81, 31, 0.38, 3.03, 4.60, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'RT', NULL, 38.22, 103, 10.24, 20.75, 59.37, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 1, 1.04, 71, 0.62, 0.31, 3.39, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 2, 27.68, 71, 10.67, 11.67, 52.57, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 3, 44.62, 71, 12.64, 22.50, 69.09, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 4, 16.05, 71, 7.19, 6.19, 35.66, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 5, 10.09, 71, 6.18, 2.80, 30.40, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 6, 0.52, 71, 0.36, 0.13, 2.07, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 7, 0.00, 71, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'IM', NULL, 3.74, 70, 0.26, 3.21, 4.26, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'RT', NULL, 63.08, 104, 9.85, 42.49, 79.80, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 1, 25.46, 52, 14.29, 7.00, 60.78, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 2, 60.00, 52, 15.52, 29.05, 84.60, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 3, 7.25, 52, 4.70, 1.89, 24.10, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 4, 1.09, 52, 0.84, 0.23, 5.01, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 5, 5.45, 52, 5.50, 0.67, 32.96, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 6, 0.58, 52, 0.59, 0.07, 4.39, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 7, 0.17, 52, 0.18, 0.02, 1.40, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'IM', NULL, 3.73, 51, 0.35, 3.03, 4.43, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'RT', NULL, 39.94, 105, 10.47, 21.87, 61.23, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 1, 31.05, 37, 19.10, 6.87, 73.34, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 2, 25.02, 37, 14.99, 6.20, 62.78, 'N', '2006-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 3, 35.40, 37, 16.58, 11.19, 70.44, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 4, 0.18, 37, 0.19, 0.02, 1.49, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 5, 7.56, 37, 6.18, 1.35, 32.93, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 6, 0.60, 37, 0.61, 0.07, 4.66, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 7, 0.18, 37, 0.19, 0.02, 1.49, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'IM', NULL, 3.67, 35, 0.18, 3.30, 4.04, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'RT', NULL, 38.50, 105, 9.89, 21.47, 58.90, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 1, 15.50, 54, 8.92, 4.47, 41.84, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 2, 46.70, 54, 15.68, 19.85, 75.61, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 3, 20.10, 54, 11.95, 5.36, 52.81, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 4, 11.10, 54, 7.72, 2.54, 37.49, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 5, 6.59, 54, 6.37, 0.88, 36.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 6, 0.00, 54, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 7, 0.00, 54, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'IM', NULL, 3.66, 53, 0.25, 3.16, 4.17, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'RT', NULL, 49.34, 104, 10.73, 29.36, 69.53, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 1, 0.87, 30, 0.79, 0.13, 5.45, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 2, 21.94, 30, 13.52, 5.30, 58.55, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 3, 24.37, 30, 12.78, 7.24, 57.11, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 4, 36.55, 30, 18.67, 9.99, 74.94, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 5, 16.26, 30, 11.68, 3.25, 52.87, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 6, 0.00, 30, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 7, 0.00, 30, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'IM', NULL, 3.66, 29, 0.24, 3.16, 4.15, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'RT', NULL, 29.83, 105, 8.37, 16.13, 48.44, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 1, 3.33, 75, 1.44, 1.39, 7.74, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 2, 41.33, 75, 12.76, 19.80, 66.78, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 3, 40.27, 75, 13.41, 18.16, 67.19, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 4, 15.07, 75, 8.34, 4.62, 39.41, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 5, 0.00, 75, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 6, 0.00, 75, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 7, 0.00, 75, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'IM', NULL, 3.58, 74, 0.17, 3.23, 3.92, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'RT', NULL, 58.44, 105, 9.34, 39.60, 75.09, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 1, 12.61, 52, 8.87, 2.79, 42.07, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 2, 57.81, 52, 13.04, 31.91, 80.03, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 3, 9.99, 52, 4.20, 4.17, 22.07, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 4, 19.59, 52, 9.93, 6.43, 46.34, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 5, 0.00, 52, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 6, 0.00, 52, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 7, 0.00, 52, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'IM', NULL, 3.54, 51, 0.22, 3.09, 3.99, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'RT', NULL, 41.35, 105, 9.49, 24.50, 60.50, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 1, 29.41, 57, 16.58, 7.76, 67.35, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 2, 15.37, 57, 8.33, 4.80, 39.57, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 3, 24.13, 57, 12.64, 7.39, 55.93, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 4, 18.07, 57, 11.28, 4.57, 50.37, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 5, 13.02, 57, 8.61, 3.16, 40.70, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 6, 0.00, 57, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 7, 0.00, 57, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'IM', NULL, 3.48, 55, 0.24, 3.00, 3.95, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'RT', NULL, 48.03, 105, 9.66, 30.03, 66.57, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 1, 29.71, 45, 11.51, 12.22, 56.21, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 2, 39.71, 45, 13.35, 17.64, 66.96, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 3, 17.22, 45, 13.13, 3.14, 57.12, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 4, 2.56, 45, 1.94, 0.55, 11.15, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 5, 10.53, 45, 8.58, 1.84, 42.44, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 6, 0.27, 45, 0.28, 0.03, 2.19, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 7, 0.00, 45, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'IM', NULL, 3.42, 44, 0.31, 2.79, 4.05, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'RT', NULL, 25.91, 104, 7.99, 13.29, 44.40, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 1, 0.97, 76, 0.96, 0.13, 6.68, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 2, 50.89, 76, 12.91, 27.02, 74.36, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 3, 22.31, 76, 9.25, 9.02, 45.41, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 4, 13.25, 76, 6.47, 4.74, 31.92, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 5, 12.18, 76, 6.73, 3.80, 32.71, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 6, 0.41, 76, 0.37, 0.06, 2.51, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 7, 0.00, 76, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'IM', NULL, 3.27, 73, 0.23, 2.82, 3.72, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'RT', NULL, 60.80, 104, 11.29, 37.75, 79.87, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 1, 40.94, 31, 18.34, 12.83, 76.54, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 2, 22.32, 31, 12.53, 6.16, 55.71, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 3, 29.13, 31, 15.87, 7.88, 66.40, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 4, 0.24, 31, 0.25, 0.03, 2.01, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 5, 0.00, 31, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 6, 7.37, 31, 7.33, 0.88, 41.62, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 7, 0.00, 31, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'IM', NULL, 2.90, 28, 0.59, 1.70, 4.10, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'RT', NULL, 29.56, 104, 8.90, 15.24, 49.49, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8854, 'FT', 1, 5.64, 12, 5.74, 0.55, 39.13, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8854, 'FT', 2, 53.60, 12, 27.20, 9.43, 92.77, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8854, 'FT', 3, 25.72, 12, 22.93, 2.41, 82.93, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8854, 'FT', 4, 0.00, 12, 0.00, NULL, NULL, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8854, 'FT', 5, 15.04, 12, 15.13, 1.29, 70.58, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8854, 'FT', 6, 0.00, 12, 0.00, NULL, NULL, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8854, 'FT', 7, 0.00, 12, 0.00, NULL, NULL, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8854, 'IM', NULL, 2.20, 11, 0.16, 1.84, 2.57, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8854, 'RT', NULL, 14.52, 103, 7.70, 4.73, 36.75, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 939, 'FT', 1, 2.23, 111, 2.19, 0.31, 14.33, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 939, 'FT', 2, 0.64, 111, 0.65, 0.09, 4.62, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 939, 'FT', 3, 2.84, 111, 2.67, 0.43, 16.59, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 939, 'FT', 4, 8.99, 111, 3.16, 4.39, 17.52, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 939, 'FT', 5, 28.40, 111, 4.84, 19.83, 38.86, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 939, 'FT', 6, 22.85, 111, 5.11, 14.29, 34.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 939, 'FT', 7, 34.05, 111, 5.94, 23.41, 46.58, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 939, 'IM', NULL, 4.06, 113, 0.13, 3.80, 4.33, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 939, 'RT', NULL, 94.57, 120, 2.40, 87.36, 97.77, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 1, 0.00, 82, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 2, 6.64, 82, 2.95, 2.68, 15.49, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 3, 17.85, 82, 5.63, 9.19, 31.82, 'N', '2008-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 4, 13.09, 82, 4.20, 6.74, 23.91, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 5, 42.39, 82, 7.22, 29.01, 56.99, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 6, 6.95, 82, 3.56, 2.44, 18.25, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 7, 13.07, 82, 6.59, 4.53, 32.27, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'IM', NULL, 3.97, 83, 0.15, 3.67, 4.27, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'RT', NULL, 68.53, 116, 5.88, 55.92, 78.89, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 935, 'FT', 1, 5.43, 108, 3.55, 1.43, 18.45, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 935, 'FT', 2, 3.97, 108, 1.93, 1.49, 10.15, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 935, 'FT', 3, 33.91, 108, 5.72, 23.62, 45.98, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 935, 'FT', 4, 29.38, 108, 6.45, 18.34, 43.53, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 935, 'FT', 5, 20.11, 108, 5.07, 11.87, 31.99, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 935, 'FT', 6, 6.92, 108, 3.65, 2.36, 18.62, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 935, 'FT', 7, 0.28, 108, 0.20, 0.07, 1.11, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 935, 'IM', NULL, 3.92, 109, 0.14, 3.64, 4.21, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 935, 'RT', NULL, 93.35, 118, 2.81, 85.12, 97.18, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 934, 'FT', 1, 2.22, 115, 1.68, 0.48, 9.56, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 934, 'FT', 2, 5.45, 115, 3.63, 1.40, 18.90, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 934, 'FT', 3, 13.34, 115, 3.99, 7.20, 23.39, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 934, 'FT', 4, 14.19, 115, 4.85, 6.99, 26.67, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 934, 'FT', 5, 33.25, 115, 5.54, 23.30, 44.96, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 934, 'FT', 6, 17.37, 115, 5.39, 9.09, 30.66, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 934, 'FT', 7, 14.19, 115, 5.00, 6.83, 27.15, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 934, 'IM', NULL, 3.87, 117, 0.13, 3.60, 4.13, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 934, 'RT', NULL, 98.11, 119, 1.28, 93.01, 99.51, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 940, 'FT', 1, 4.20, 90, 2.49, 1.27, 13.01, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 940, 'FT', 2, 17.24, 90, 4.28, 10.30, 27.44, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 940, 'FT', 3, 30.20, 90, 6.85, 18.49, 45.22, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 940, 'FT', 4, 23.10, 90, 6.80, 12.32, 39.11, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 940, 'FT', 5, 22.61, 90, 6.08, 12.77, 36.82, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 940, 'FT', 6, 2.07, 90, 1.33, 0.57, 7.22, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 940, 'FT', 7, 0.59, 90, 0.43, 0.14, 2.51, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 940, 'IM', NULL, 3.85, 91, 0.17, 3.50, 4.20, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 940, 'RT', NULL, 76.25, 117, 5.19, 64.53, 85.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 936, 'FT', 1, 6.76, 112, 3.30, 2.50, 17.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 936, 'FT', 2, 12.77, 112, 4.72, 5.95, 25.31, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 936, 'FT', 3, 21.03, 112, 5.30, 12.40, 33.39, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 936, 'FT', 4, 22.44, 112, 5.57, 13.30, 35.30, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 936, 'FT', 5, 28.64, 112, 5.37, 19.25, 40.31, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 936, 'FT', 6, 4.41, 112, 1.77, 1.97, 9.57, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 936, 'FT', 7, 3.95, 112, 2.90, 0.90, 15.74, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 936, 'IM', NULL, 3.67, 111, 0.13, 3.41, 3.92, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 936, 'RT', NULL, 96.89, 120, 1.65, 91.35, 98.92, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 937, 'FT', 1, 9.02, 111, 3.79, 3.82, 19.83, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 937, 'FT', 2, 25.35, 111, 5.50, 16.03, 37.65, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 937, 'FT', 3, 36.56, 111, 5.67, 26.20, 48.34, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 937, 'FT', 4, 13.18, 111, 4.59, 6.41, 25.16, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 937, 'FT', 5, 10.73, 111, 3.51, 5.49, 19.92, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 937, 'FT', 6, 0.78, 111, 0.57, 0.18, 3.27, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 937, 'FT', 7, 4.38, 111, 3.10, 1.04, 16.59, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 937, 'IM', NULL, 3.62, 111, 0.13, 3.36, 3.89, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 937, 'RT', NULL, 93.41, 119, 2.76, 85.37, 97.18, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 946, 'FT', 1, 4.58, 73, 2.93, 1.24, 15.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 946, 'FT', 2, 24.06, 73, 6.27, 13.79, 38.56, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 946, 'FT', 3, 32.68, 73, 7.81, 19.31, 49.63, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 946, 'FT', 4, 20.03, 73, 5.46, 11.26, 33.08, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 946, 'FT', 5, 15.24, 73, 5.34, 7.32, 29.07, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 946, 'FT', 6, 3.40, 73, 2.17, 0.94, 11.59, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 946, 'FT', 7, 0.00, 73, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 946, 'IM', NULL, 3.31, 74, 0.14, 3.03, 3.60, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 946, 'RT', NULL, 70.48, 117, 5.59, 58.38, 80.25, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 941, 'FT', 1, 0.49, 65, 0.49, 0.07, 3.56, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 941, 'FT', 2, 19.57, 65, 6.52, 9.61, 35.77, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 941, 'FT', 3, 27.30, 65, 6.73, 16.02, 42.51, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 941, 'FT', 4, 19.40, 65, 6.10, 9.95, 34.41, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 941, 'FT', 5, 29.16, 65, 5.75, 19.10, 41.79, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 941, 'FT', 6, 3.82, 65, 2.70, 0.90, 14.74, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 941, 'FT', 7, 0.26, 65, 0.26, 0.03, 1.88, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 941, 'IM', NULL, 3.56, 66, 0.14, 3.28, 3.83, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 941, 'RT', NULL, 56.07, 117, 6.34, 43.40, 67.99, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 943, 'FT', 1, 9.19, 71, 5.05, 2.94, 25.27, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 943, 'FT', 2, 11.22, 71, 4.40, 4.97, 23.38, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 943, 'FT', 3, 14.63, 71, 4.95, 7.21, 27.42, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 943, 'FT', 4, 20.98, 71, 6.46, 10.88, 36.61, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 943, 'FT', 5, 27.48, 71, 8.30, 14.17, 46.52, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 943, 'FT', 6, 9.24, 71, 4.18, 3.62, 21.59, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 943, 'FT', 7, 7.27, 71, 4.89, 1.81, 24.98, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 943, 'IM', NULL, 3.50, 70, 0.19, 3.12, 3.88, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 943, 'RT', NULL, 57.27, 120, 6.28, 44.63, 69.02, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 938, 'FT', 1, 0.00, 76, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 938, 'FT', 2, 10.46, 76, 4.97, 3.90, 25.18, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 938, 'FT', 3, 19.90, 76, 6.70, 9.71, 36.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 938, 'FT', 4, 28.00, 76, 6.73, 16.66, 43.06, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 938, 'FT', 5, 39.56, 76, 8.22, 24.81, 56.48, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 938, 'FT', 6, 0.19, 76, 0.19, 0.03, 1.41, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 938, 'FT', 7, 1.89, 76, 1.03, 0.63, 5.52, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 938, 'IM', NULL, 3.50, 77, 0.19, 3.11, 3.88, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 938, 'RT', NULL, 63.42, 117, 5.95, 51.07, 74.23, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 1, 7.66, 52, 3.89, 2.68, 20.01, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 2, 8.20, 52, 4.73, 2.46, 23.99, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 3, 14.37, 52, 6.40, 5.58, 32.27, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 4, 7.61, 52, 4.29, 2.36, 21.92, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 5, 21.86, 52, 6.79, 11.19, 38.32, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 6, 12.40, 52, 7.08, 3.68, 34.39, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 7, 27.89, 52, 8.99, 13.62, 48.68, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'IM', NULL, 3.48, 54, 0.22, 3.04, 3.93, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'RT', NULL, 54.75, 120, 6.54, 41.78, 67.11, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 942, 'FT', 1, 0.73, 52, 0.74, 0.09, 5.42, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 942, 'FT', 2, 15.89, 52, 7.93, 5.43, 38.34, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 942, 'FT', 3, 17.51, 52, 6.60, 7.81, 34.70, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 942, 'FT', 4, 14.41, 52, 5.42, 6.51, 28.93, 'N', '2008-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 942, 'FT', 5, 46.09, 52, 10.47, 26.83, 66.58, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 942, 'FT', 6, 4.53, 52, 2.91, 1.21, 15.51, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 942, 'FT', 7, 0.85, 52, 0.84, 0.12, 5.91, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 942, 'IM', NULL, 3.45, 53, 0.28, 2.89, 4.01, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 942, 'RT', NULL, 42.49, 117, 6.27, 30.77, 55.12, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 1, 3.77, 64, 2.72, 0.87, 14.92, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 2, 29.16, 64, 7.06, 17.21, 44.91, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 3, 47.17, 64, 9.06, 30.16, 64.86, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 4, 7.84, 64, 4.14, 2.64, 21.07, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 5, 11.82, 64, 5.29, 4.64, 26.98, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 6, 0.00, 64, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 7, 0.24, 64, 0.24, 0.03, 1.79, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'IM', NULL, 3.30, 64, 0.12, 3.05, 3.55, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'RT', NULL, 58.79, 117, 6.16, 46.30, 70.24, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 1, 36.67, 37, 10.96, 18.18, 60.14, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 2, 22.18, 37, 11.10, 7.18, 51.23, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 3, 24.10, 37, 10.33, 9.18, 49.95, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 4, 9.97, 37, 6.42, 2.53, 32.06, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 5, 7.08, 37, 6.30, 1.08, 34.70, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 6, 0.00, 37, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 7, 0.00, 37, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'IM', NULL, 3.25, 37, 0.23, 2.78, 3.72, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'RT', NULL, 33.89, 116, 6.32, 22.68, 47.26, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 1, 3.99, 82, 2.61, 1.06, 13.87, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 2, 25.73, 82, 6.64, 14.79, 40.89, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 3, 15.07, 82, 4.61, 7.98, 26.65, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 4, 24.63, 82, 6.77, 13.66, 40.30, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 5, 24.54, 82, 6.56, 13.85, 39.70, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 6, 4.41, 82, 2.18, 1.62, 11.42, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 7, 1.62, 82, 1.46, 0.26, 9.30, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'IM', NULL, 3.17, 81, 0.15, 2.87, 3.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'RT', NULL, 65.35, 120, 6.69, 51.23, 77.20, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 1, 23.37, 28, 9.00, 9.81, 46.10, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 2, 32.65, 28, 10.63, 15.24, 56.66, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 3, 22.03, 28, 7.34, 10.52, 40.45, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 4, 7.47, 28, 6.14, 1.29, 33.29, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 5, 14.47, 28, 8.30, 4.10, 40.13, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 6, 0.00, 28, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 7, 0.00, 28, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'IM', NULL, 2.72, 30, 0.19, 2.34, 3.10, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'RT', NULL, 32.49, 117, 6.15, 21.64, 45.61, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 1, 0.60, 55, 0.62, 0.07, 4.64, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 2, 11.05, 55, 5.55, 3.85, 27.81, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 3, 21.78, 55, 7.95, 9.85, 41.51, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 4, 10.75, 55, 4.40, 4.58, 23.20, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 5, 20.19, 55, 7.64, 8.91, 39.55, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 6, 29.17, 55, 18.82, 6.22, 71.88, 'Y', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 7, 6.47, 55, 3.95, 1.83, 20.39, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'IM', NULL, 4.45, 55, 0.17, 4.10, 4.79, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'RT', NULL, 93.62, 62, 3.26, 83.14, 97.76, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 1, 0.00, 57, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 2, 8.53, 57, 4.75, 2.68, 24.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 3, 18.26, 57, 7.66, 7.40, 38.43, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 4, 19.61, 57, 7.07, 9.04, 37.45, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 5, 40.65, 57, 9.42, 23.85, 59.97, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 6, 10.88, 57, 6.08, 3.36, 30.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 7, 2.07, 57, 2.13, 0.26, 14.77, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'IM', NULL, 4.34, 57, 0.21, 3.93, 4.76, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'RT', NULL, 93.07, 61, 3.70, 81.00, 97.69, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'FT', 1, 3.08, 53, 3.12, 0.39, 20.58, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'FT', 2, 14.57, 53, 6.52, 5.63, 32.80, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'FT', 3, 16.97, 53, 6.73, 7.27, 34.77, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'FT', 4, 20.53, 53, 7.38, 9.43, 39.05, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'FT', 5, 23.63, 53, 5.73, 14.06, 36.92, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'FT', 6, 18.21, 53, 13.43, 3.52, 57.61, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'FT', 7, 3.00, 53, 2.44, 0.57, 14.29, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'IM', NULL, 4.12, 53, 0.27, 3.59, 4.65, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'RT', NULL, 87.98, 62, 5.85, 70.77, 95.68, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'FT', 1, 1.81, 49, 1.53, 0.32, 9.44, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'FT', 2, 10.67, 49, 5.64, 3.50, 28.20, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'FT', 3, 25.31, 49, 5.70, 15.60, 38.31, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'FT', 4, 29.37, 49, 12.24, 11.27, 57.66, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'FT', 5, 20.44, 49, 7.85, 8.87, 40.41, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'FT', 6, 5.61, 49, 3.31, 1.67, 17.25, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'FT', 7, 6.80, 49, 4.24, 1.86, 21.86, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'IM', NULL, 4.00, 49, 0.23, 3.53, 4.47, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'RT', NULL, 82.03, 61, 6.33, 65.91, 91.51, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 1, 0.00, 43, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 2, 11.13, 43, 6.03, 3.53, 30.02, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 3, 42.99, 43, 9.52, 25.61, 62.29, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 4, 15.33, 43, 8.05, 4.92, 38.77, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 5, 26.15, 43, 5.36, 16.83, 38.26, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 6, 1.31, 43, 1.05, 0.26, 6.41, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 7, 3.08, 43, 2.80, 0.48, 17.45, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'IM', NULL, 3.97, 43, 0.25, 3.47, 4.47, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'RT', NULL, 73.83, 62, 8.31, 54.41, 86.97, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 1, 5.78, 59, 4.21, 1.29, 22.38, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 2, 6.09, 59, 3.22, 2.06, 16.70, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 3, 13.53, 59, 5.37, 5.88, 28.16, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 4, 26.57, 59, 8.69, 12.92, 46.89, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 5, 44.18, 59, 14.91, 19.09, 72.63, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 6, 3.84, 59, 2.79, 0.87, 15.36, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 7, 0.00, 59, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'IM', NULL, 3.96, 60, 0.08, 3.80, 4.13, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'RT', NULL, 98.52, 62, 1.13, 93.41, 99.68, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 1, 17.69, 52, 6.71, 7.86, 35.15, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 2, 43.60, 52, 6.28, 31.65, 56.34, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 3, 13.97, 52, 4.93, 6.65, 27.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 4, 17.76, 52, 7.17, 7.46, 36.66, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 5, 6.98, 52, 4.66, 1.74, 24.08, 'N', '2010-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 6, 0.00, 52, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 7, 0.00, 52, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'IM', NULL, 3.74, 52, 0.13, 3.49, 4.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'RT', NULL, 80.88, 62, 5.20, 68.35, 89.23, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 1, 13.73, 51, 5.92, 5.50, 30.30, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 2, 16.46, 51, 5.99, 7.60, 32.08, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 3, 44.19, 51, 12.07, 22.86, 67.90, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 4, 7.56, 51, 4.17, 2.41, 21.33, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 5, 12.79, 51, 5.64, 5.04, 28.84, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 6, 5.27, 51, 3.63, 1.27, 19.34, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 7, 0.00, 51, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'IM', NULL, 3.74, 51, 0.27, 3.21, 4.28, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'RT', NULL, 77.26, 62, 11.38, 48.19, 92.55, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 1, 1.76, 49, 1.12, 0.49, 6.15, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 2, 27.57, 49, 7.38, 15.34, 44.45, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 3, 30.22, 49, 6.94, 18.27, 45.63, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 4, 17.28, 49, 6.70, 7.53, 34.90, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 5, 20.09, 49, 7.18, 9.28, 38.19, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 6, 0.49, 49, 0.51, 0.06, 3.83, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 7, 2.57, 49, 2.62, 0.32, 17.69, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'IM', NULL, 3.72, 50, 0.12, 3.49, 3.95, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'RT', NULL, 74.65, 62, 5.14, 63.10, 83.53, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'FT', 1, 48.31, 48, 7.02, 34.68, 62.20, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'FT', 2, 29.86, 48, 7.21, 17.55, 45.99, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'FT', 3, 17.45, 48, 6.90, 7.46, 35.67, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'FT', 4, 3.55, 48, 3.54, 0.46, 22.80, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'FT', 5, 0.83, 48, 0.86, 0.10, 6.36, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'FT', 6, 0.00, 48, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'FT', 7, 0.00, 48, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'IM', NULL, 3.56, 48, 0.18, 3.20, 3.93, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'RT', NULL, 72.45, 62, 6.63, 57.52, 83.63, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 1, 5.65, 43, 3.61, 1.50, 19.01, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 2, 16.53, 43, 7.92, 5.85, 38.67, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 3, 45.38, 43, 9.55, 27.63, 64.38, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 4, 14.30, 43, 8.53, 3.94, 40.46, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 5, 14.18, 43, 6.73, 5.14, 33.52, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 6, 0.48, 43, 0.50, 0.06, 3.86, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 7, 3.49, 43, 2.85, 0.65, 16.63, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'IM', NULL, 3.42, 44, 0.15, 3.11, 3.73, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'RT', NULL, 78.60, 62, 7.57, 59.89, 90.04, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 1, 4.78, 44, 3.59, 1.01, 19.75, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 2, 22.97, 44, 8.45, 10.22, 43.86, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 3, 22.31, 44, 7.94, 10.23, 41.98, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 4, 15.63, 44, 6.49, 6.43, 33.32, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 5, 23.17, 44, 8.08, 10.78, 42.95, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 6, 7.47, 44, 4.01, 2.44, 20.62, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 7, 3.68, 44, 3.04, 0.67, 17.74, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'IM', NULL, 3.41, 44, 0.37, 2.67, 4.15, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'RT', NULL, 68.07, 62, 5.70, 55.78, 78.27, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 1, 4.13, 36, 2.95, 0.94, 16.39, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 2, 43.84, 36, 8.48, 27.95, 61.10, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 3, 9.48, 36, 5.91, 2.52, 29.76, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 4, 23.37, 36, 6.04, 13.32, 37.69, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 5, 4.18, 36, 3.26, 0.83, 18.54, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 6, 12.22, 36, 7.61, 3.20, 37.01, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 7, 2.79, 36, 2.91, 0.32, 20.21, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'IM', NULL, 3.37, 35, 0.28, 2.81, 3.93, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'RT', NULL, 68.52, 62, 9.13, 48.28, 83.54, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 1, 1.47, 49, 1.50, 0.19, 10.68, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 2, 37.29, 49, 14.30, 14.82, 67.04, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 3, 23.99, 49, 7.69, 11.91, 42.43, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 4, 25.21, 49, 8.15, 12.38, 44.56, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 5, 7.55, 49, 3.63, 2.79, 18.87, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 6, 0.97, 49, 0.72, 0.22, 4.22, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 7, 3.52, 49, 2.78, 0.70, 15.92, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'IM', NULL, 3.28, 50, 0.30, 2.67, 3.88, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'RT', NULL, 75.89, 62, 5.45, 63.43, 85.10, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 1, 21.51, 43, 5.92, 11.91, 35.73, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 2, 63.66, 43, 6.29, 50.30, 75.20, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 3, 8.82, 43, 5.25, 2.52, 26.55, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 4, 2.81, 43, 2.22, 0.56, 12.94, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 5, 0.51, 43, 0.54, 0.06, 4.13, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 6, 0.00, 43, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 7, 2.68, 43, 2.78, 0.32, 19.15, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'IM', NULL, 3.17, 43, 0.16, 2.85, 3.49, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'RT', NULL, 73.98, 62, 9.56, 51.30, 88.47, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 1, 3.41, 59, 2.94, 0.59, 17.40, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 2, 8.82, 59, 4.67, 2.94, 23.60, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 3, 19.04, 59, 7.33, 8.32, 37.85, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 4, 21.66, 59, 7.49, 10.26, 40.09, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 5, 44.47, 59, 15.11, 19.05, 73.16, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 6, 0.62, 59, 0.64, 0.08, 4.81, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 7, 1.98, 59, 2.03, 0.25, 14.16, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'IM', NULL, 3.17, 59, 0.16, 2.86, 3.48, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'RT', NULL, 96.77, 62, 2.20, 87.98, 99.19, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'FT', 1, 17.21, 51, 7.63, 6.62, 37.86, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'FT', 2, 32.02, 51, 8.14, 18.18, 49.96, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'FT', 3, 24.78, 51, 9.90, 10.18, 48.91, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'FT', 4, 20.44, 51, 7.49, 9.25, 39.31, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'FT', 5, 0.89, 51, 0.67, 0.20, 3.93, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'FT', 6, 4.22, 51, 3.13, 0.92, 17.26, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'FT', 7, 0.45, 51, 0.45, 0.06, 3.38, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'IM', NULL, 3.08, 50, 0.19, 2.70, 3.46, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'RT', NULL, 81.50, 62, 5.49, 68.03, 90.12, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 1, 0.88, 45, 0.90, 0.11, 6.63, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 2, 4.63, 45, 4.08, 0.75, 23.86, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 3, 18.53, 45, 5.99, 9.28, 33.59, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 4, 30.01, 45, 7.50, 17.27, 46.83, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 5, 27.23, 45, 6.99, 15.53, 43.24, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 6, 13.85, 45, 10.93, 2.47, 50.47, 'N', '2010-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 7, 4.87, 45, 3.26, 1.23, 17.43, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'IM', NULL, 3.94, 45, 0.18, 3.57, 4.30, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'RT', NULL, 66.41, 62, 10.22, 44.17, 83.17, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 1, 3.27, 42, 3.33, 0.40, 22.00, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 2, 12.98, 42, 6.07, 4.80, 30.63, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 3, 31.37, 42, 10.29, 14.83, 54.54, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 4, 16.17, 42, 8.91, 4.86, 42.13, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 5, 14.24, 42, 6.38, 5.46, 32.31, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 6, 16.66, 42, 8.79, 5.28, 41.78, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 7, 5.31, 42, 3.63, 1.29, 19.41, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'IM', NULL, 3.83, 42, 0.12, 3.59, 4.08, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'RT', NULL, 65.90, 62, 4.86, 55.63, 74.86, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 1, 0.57, 40, 0.59, 0.07, 4.54, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 2, 26.44, 40, 9.88, 11.40, 50.11, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 3, 24.38, 40, 8.99, 10.73, 46.36, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 4, 26.30, 40, 7.87, 13.57, 44.78, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 5, 18.36, 40, 9.18, 6.12, 43.69, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 6, 0.94, 40, 0.99, 0.11, 7.44, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 7, 3.01, 40, 3.05, 0.37, 20.41, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'IM', NULL, 3.80, 40, 0.25, 3.29, 4.30, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'RT', NULL, 63.99, 61, 4.89, 53.75, 73.10, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 1, 1.62, 41, 1.63, 0.21, 11.51, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 2, 33.96, 41, 11.82, 15.05, 59.87, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 3, 29.26, 41, 8.76, 14.95, 49.32, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 4, 10.41, 41, 5.68, 3.29, 28.45, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 5, 19.22, 41, 7.55, 8.18, 38.85, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 6, 2.13, 41, 1.54, 0.48, 8.85, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 7, 3.41, 41, 3.40, 0.43, 22.18, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'IM', NULL, 3.52, 41, 0.17, 3.18, 3.87, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'RT', NULL, 56.57, 61, 8.09, 40.27, 71.56, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 1, 7.94, 45, 4.43, 2.48, 22.61, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 2, 26.94, 45, 8.81, 13.02, 47.62, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 3, 23.09, 45, 6.33, 12.78, 38.10, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 4, 29.13, 45, 10.55, 12.80, 53.51, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 5, 9.31, 45, 5.17, 2.91, 26.05, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 6, 0.57, 45, 0.57, 0.08, 4.18, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 7, 3.00, 45, 3.01, 0.38, 19.90, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'IM', NULL, 3.40, 46, 0.18, 3.05, 3.76, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'RT', NULL, 65.18, 62, 8.93, 46.00, 80.44, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 1, 3.18, 36, 2.54, 0.61, 14.93, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 2, 23.80, 36, 8.38, 10.89, 44.39, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 3, 31.40, 36, 8.50, 17.04, 50.50, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 4, 21.96, 36, 8.36, 9.47, 43.10, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 5, 5.25, 36, 3.55, 1.28, 19.11, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 6, 10.22, 36, 8.77, 1.61, 44.21, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 7, 4.18, 36, 4.16, 0.53, 26.49, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'IM', NULL, 3.40, 36, 0.22, 2.95, 3.84, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'RT', NULL, 46.04, 61, 12.60, 23.63, 70.17, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 1, 14.14, 21, 10.31, 2.72, 49.20, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 2, 27.07, 21, 12.76, 8.79, 58.82, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 3, 5.76, 21, 4.54, 1.06, 25.94, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 4, 11.31, 21, 8.22, 2.25, 41.35, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 5, 31.88, 21, 10.69, 14.36, 56.65, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 6, 7.49, 21, 7.19, 0.92, 41.34, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 7, 2.35, 21, 2.40, 0.27, 17.53, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'IM', NULL, 3.10, 21, 0.34, 2.38, 3.82, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'RT', NULL, 25.68, 61, 8.06, 12.93, 44.57, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 1, 4.11, 39, 3.38, 0.75, 19.58, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 2, 55.08, 39, 13.91, 28.20, 79.29, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 3, 28.03, 39, 9.94, 12.56, 51.37, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 4, 9.04, 39, 5.31, 2.62, 26.84, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 5, 0.00, 39, 0.00, NULL, NULL, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 6, 0.60, 39, 0.62, 0.07, 4.71, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 7, 3.14, 39, 3.22, 0.38, 21.63, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'IM', NULL, 3.08, 39, 0.15, 2.78, 3.38, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'RT', NULL, 60.91, 62, 6.76, 46.90, 73.33, 'N', '2010-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 953, 'FT', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 953, 'FT', 2, 23.81, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 953, 'FT', 3, 28.57, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 953, 'FT', 4, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 953, 'FT', 5, 9.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 953, 'FT', 6, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 953, 'FT', 7, 9.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 953, 'IM', NULL, 4.30, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 953, 'RT', NULL, 88.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 1, 12.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 2, 45.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 3, 12.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 4, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 5, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 6, 12.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'IM', NULL, 4.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'RT', NULL, 100.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 1, 5.26, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 2, 26.32, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 3, 5.26, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 4, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 5, 52.63, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 7, 10.53, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'IM', NULL, 3.89, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'RT', NULL, 80.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 1, 29.41, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 2, 35.29, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 3, 23.53, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 4, 0.00, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 5, 11.76, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 6, 0.00, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 7, 0.00, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'IM', NULL, 3.83, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'RT', NULL, 72.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 1, 10.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 2, 35.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 3, 35.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 4, 15.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 5, 5.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'IM', NULL, 3.75, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'RT', NULL, 84.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 1, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 2, 33.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 3, 19.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 4, 23.81, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 5, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 6, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'IM', NULL, 3.67, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'RT', NULL, 88.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 1, 37.50, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 2, 43.75, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 3, 18.75, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 4, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 5, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 6, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 7, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'IM', NULL, 3.65, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'RT', NULL, 68.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 1, 39.13, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 2, 30.43, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 3, 13.04, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 4, 17.39, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 5, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'IM', NULL, 3.52, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'RT', NULL, 96.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 1, 22.73, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 2, 31.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 3, 31.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 4, 4.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 5, 4.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 6, 4.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'IM', NULL, 3.48, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'RT', NULL, 92.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 1, 22.22, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 2, 50.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 3, 27.78, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 4, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'IM', NULL, 3.06, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'RT', NULL, 76.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 1, 38.10, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 2, 42.86, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 3, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 4, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 5, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'IM', NULL, 3.05, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'RT', NULL, 88.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 1, 33.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 2, 47.62, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 3, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 4, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 5, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'IM', NULL, 3.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'RT', NULL, 88.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 1, 27.27, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 2, 18.18, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 3, 54.55, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 4, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 5, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 6, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 7, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'IM', NULL, 3.67, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'RT', NULL, 50.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 1, 7.69, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 2, 46.15, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 3, 30.77, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 4, 7.69, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 5, 7.69, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 6, 0.00, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 7, 0.00, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'IM', NULL, 3.64, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'RT', NULL, 56.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 1, 53.33, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 2, 26.67, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 3, 20.00, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 4, 0.00, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 5, 0.00, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 6, 0.00, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 7, 0.00, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'IM', NULL, 2.81, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'RT', NULL, 68.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 1, 57.14, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 2, 28.57, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 3, 14.29, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 4, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 5, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 6, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 7, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'IM', NULL, 2.60, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'RT', NULL, 60.00, 25, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 1, 5.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 2, 5.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 3, 40.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 4, 20.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 5, 15.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 6, 15.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'IM', NULL, 4.45, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'RT', NULL, 95.24, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 1, 0.00, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 2, 5.88, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 3, 29.41, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 4, 17.65, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 5, 35.29, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 6, 5.88, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 7, 5.88, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'IM', NULL, 4.18, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'RT', NULL, 80.95, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 2, 42.86, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 3, 28.57, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 4, 19.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 5, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 7, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'IM', NULL, 4.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'RT', NULL, 100.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 1, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 2, 19.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 3, 33.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 4, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 5, 19.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 6, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 7, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'IM', NULL, 3.80, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'RT', NULL, 100.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 2, 9.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 3, 38.10, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 4, 33.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 5, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 6, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'IM', NULL, 3.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'RT', NULL, 100.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 1, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 2, 33.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 3, 33.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 4, 19.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 5, 9.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'IM', NULL, 3.55, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'RT', NULL, 100.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 1, 15.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 2, 65.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 3, 10.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 4, 10.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'IM', NULL, 3.40, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'RT', NULL, 95.24, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 1, 10.53, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 2, 26.32, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 3, 52.63, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 4, 10.53, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 5, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'IM', NULL, 3.17, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'RT', NULL, 90.48, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 1, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 2, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 3, 21.43, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 4, 21.43, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 5, 35.71, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 6, 14.29, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 7, 7.14, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'IM', NULL, 4.07, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'RT', NULL, 66.67, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 1, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 2, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 3, 28.57, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 4, 42.86, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 5, 28.57, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 6, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 7, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'IM', NULL, 3.79, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'RT', NULL, 66.67, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 1, 0.00, 4, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 2, 0.00, 4, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 3, 75.00, 4, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 4, 25.00, 4, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 5, 0.00, 4, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 6, 0.00, 4, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 7, 0.00, 4, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'IM', NULL, 3.75, 4, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'RT', NULL, 19.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 1, 8.33, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 2, 41.67, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 3, 25.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 4, 16.67, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 5, 8.33, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 6, 0.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 7, 0.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'IM', NULL, 3.55, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'RT', NULL, 57.14, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 1, 20.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 2, 0.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 3, 40.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 4, 20.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 5, 20.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 6, 0.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 7, 0.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'IM', NULL, 3.40, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'RT', NULL, 23.81, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 1, 0.00, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 2, 20.00, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 3, 30.00, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 4, 40.00, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 5, 0.00, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 6, 10.00, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 7, 0.00, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'IM', NULL, 3.30, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'RT', NULL, 47.62, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 1, 7.14, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 2, 28.57, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 3, 28.57, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 4, 21.43, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 5, 7.14, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 6, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 7, 7.14, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'IM', NULL, 3.14, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'RT', NULL, 66.67, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 1, 11.11, 9, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 2, 66.67, 9, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 3, 11.11, 9, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 4, 0.00, 9, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 5, 11.11, 9, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 6, 0.00, 9, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 7, 0.00, 9, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'IM', NULL, 3.00, 8, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'RT', NULL, 42.86, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 1, 5.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 2, 72.22, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 3, 22.22, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 4, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'IM', NULL, 2.89, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'RT', NULL, 85.71, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'FT', 1, 0.00, 96, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'FT', 2, 5.11, 96, 2.54, 1.87, 13.24, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'FT', 3, 0.50, 96, 0.40, 0.10, 2.42, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'FT', 4, 19.64, 96, 5.16, 11.33, 31.86, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'FT', 5, 56.57, 96, 7.61, 41.32, 70.67, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'FT', 6, 3.33, 96, 1.50, 1.35, 8.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'FT', 7, 14.85, 96, 5.16, 7.20, 28.15, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'IM', NULL, 4.39, 99, 0.11, 4.17, 4.62, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'RT', NULL, 96.49, 102, 2.72, 84.83, 99.27, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'FT', 1, 0.00, 96, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'FT', 2, 1.93, 96, 1.92, 0.26, 12.85, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'FT', 3, 20.39, 96, 5.66, 11.37, 33.85, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'FT', 4, 25.50, 96, 5.29, 16.45, 37.30, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'FT', 5, 32.24, 96, 8.20, 18.42, 50.07, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'FT', 6, 8.41, 96, 4.25, 2.98, 21.53, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'FT', 7, 11.52, 96, 5.35, 4.39, 26.94, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'IM', NULL, 4.35, 97, 0.11, 4.14, 4.56, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'RT', NULL, 88.45, 103, 7.96, 62.00, 97.30, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'FT', 1, 2.86, 96, 2.09, 0.66, 11.56, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'FT', 2, 3.12, 96, 1.56, 1.14, 8.24, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'FT', 3, 19.12, 96, 4.94, 11.14, 30.82, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'FT', 4, 25.96, 96, 7.27, 14.20, 42.61, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'FT', 5, 34.38, 96, 8.42, 19.98, 52.36, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'FT', 6, 5.35, 96, 3.46, 1.43, 18.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'FT', 7, 9.22, 96, 4.51, 3.36, 22.85, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'IM', NULL, 4.24, 98, 0.12, 4.00, 4.48, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'RT', NULL, 89.37, 103, 7.81, 62.20, 97.73, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'FT', 1, 0.00, 85, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'FT', 2, 2.11, 85, 1.31, 0.61, 7.07, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'FT', 3, 10.94, 85, 4.12, 5.03, 22.17, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'FT', 4, 6.77, 85, 3.89, 2.09, 19.82, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'FT', 5, 46.30, 85, 8.37, 30.62, 62.75, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'FT', 6, 16.84, 85, 6.44, 7.51, 33.56, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'FT', 7, 17.03, 85, 5.73, 8.40, 31.48, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'IM', NULL, 4.13, 86, 0.17, 3.78, 4.47, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'RT', NULL, 86.34, 103, 4.37, 75.18, 92.95, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'FT', 1, 1.16, 90, 1.16, 0.16, 8.06, 'N', '2009-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'FT', 2, 5.08, 90, 3.14, 1.45, 16.33, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'FT', 3, 26.55, 90, 9.82, 11.73, 49.58, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'FT', 4, 13.07, 90, 5.37, 5.55, 27.77, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'FT', 5, 40.40, 90, 8.16, 25.69, 57.06, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'FT', 6, 9.55, 90, 4.19, 3.88, 21.67, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'FT', 7, 4.19, 90, 2.05, 1.56, 10.77, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'IM', NULL, 4.06, 91, 0.22, 3.63, 4.50, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'RT', NULL, 88.87, 103, 4.87, 75.04, 95.50, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'FT', 1, 0.82, 86, 0.83, 0.11, 5.95, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'FT', 2, 6.33, 86, 3.03, 2.39, 15.71, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'FT', 3, 20.58, 86, 8.56, 8.38, 42.32, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'FT', 4, 10.41, 86, 3.74, 4.97, 20.50, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'FT', 5, 40.07, 86, 8.99, 24.11, 58.45, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'FT', 6, 16.77, 86, 5.18, 8.79, 29.64, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'FT', 7, 5.02, 86, 2.99, 1.50, 15.52, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'IM', NULL, 3.96, 84, 0.15, 3.67, 4.26, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'RT', NULL, 87.57, 103, 3.19, 79.77, 92.64, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'FT', 1, 3.44, 90, 1.88, 1.14, 9.91, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'FT', 2, 9.07, 90, 2.22, 5.52, 14.56, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'FT', 3, 33.16, 90, 8.61, 18.65, 51.77, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'FT', 4, 15.91, 90, 4.90, 8.38, 28.14, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'FT', 5, 36.19, 90, 7.56, 22.83, 52.09, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'FT', 6, 2.22, 90, 1.31, 0.68, 7.01, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'FT', 7, 0.00, 90, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'IM', NULL, 3.84, 89, 0.15, 3.54, 4.15, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'RT', NULL, 89.87, 103, 4.15, 78.21, 95.64, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'FT', 1, 1.35, 68, 1.19, 0.23, 7.50, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'FT', 2, 5.83, 68, 2.43, 2.49, 13.05, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'FT', 3, 18.22, 68, 7.04, 7.98, 36.38, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'FT', 4, 39.94, 68, 9.58, 23.06, 59.60, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'FT', 5, 27.99, 68, 9.26, 13.45, 49.30, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'FT', 6, 4.84, 68, 2.35, 1.80, 12.35, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'FT', 7, 1.84, 68, 1.77, 0.26, 11.72, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'IM', NULL, 3.84, 69, 0.13, 3.59, 4.09, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'RT', NULL, 69.73, 100, 8.00, 52.06, 83.01, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'FT', 1, 13.62, 91, 8.58, 3.57, 40.16, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'FT', 2, 11.93, 91, 3.62, 6.40, 21.18, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'FT', 3, 21.78, 91, 6.79, 11.20, 38.06, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'FT', 4, 27.26, 91, 7.95, 14.45, 45.39, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'FT', 5, 19.54, 91, 7.55, 8.55, 38.68, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'FT', 6, 5.82, 91, 2.82, 2.18, 14.65, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'FT', 7, 0.05, 91, 0.05, 0.01, 0.39, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'IM', NULL, 3.82, 91, 0.22, 3.39, 4.24, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'RT', NULL, 92.92, 103, 3.38, 82.59, 97.32, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'FT', 1, 0.50, 92, 0.40, 0.10, 2.42, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'FT', 2, 5.86, 92, 2.16, 2.78, 11.94, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'FT', 3, 33.52, 92, 10.99, 15.92, 57.32, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'FT', 4, 30.71, 92, 8.71, 16.42, 49.99, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'FT', 5, 24.95, 92, 7.39, 13.18, 42.12, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'FT', 6, 1.95, 92, 1.09, 0.63, 5.82, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'FT', 7, 2.52, 92, 2.47, 0.35, 16.01, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'IM', NULL, 3.76, 94, 0.19, 3.37, 4.14, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'RT', NULL, 92.57, 103, 3.47, 82.10, 97.13, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'FT', 1, 7.80, 94, 5.08, 2.04, 25.59, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'FT', 2, 25.04, 94, 6.77, 14.03, 40.61, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'FT', 3, 43.32, 94, 8.96, 27.03, 61.20, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'FT', 4, 10.22, 94, 3.82, 4.74, 20.66, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'FT', 5, 7.15, 94, 3.35, 2.75, 17.32, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'FT', 6, 4.00, 94, 2.91, 0.92, 15.78, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'FT', 7, 2.47, 94, 2.68, 0.28, 18.78, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'IM', NULL, 3.65, 94, 0.20, 3.25, 4.05, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'RT', NULL, 92.54, 103, 3.19, 83.21, 96.88, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'FT', 1, 15.44, 71, 10.63, 3.47, 48.08, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'FT', 2, 7.86, 71, 3.80, 2.91, 19.54, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'FT', 3, 21.33, 71, 6.57, 11.04, 37.19, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'FT', 4, 33.01, 71, 8.99, 17.97, 52.56, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'FT', 5, 15.57, 71, 5.57, 7.34, 30.04, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'FT', 6, 1.70, 71, 1.27, 0.38, 7.29, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'FT', 7, 5.10, 71, 3.54, 1.23, 18.77, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'IM', NULL, 3.49, 71, 0.24, 3.01, 3.96, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'RT', NULL, 73.48, 103, 6.64, 58.51, 84.48, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'FT', 1, 15.31, 78, 9.59, 3.98, 44.10, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'FT', 2, 18.00, 78, 7.31, 7.57, 37.05, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'FT', 3, 25.32, 78, 7.05, 13.89, 41.60, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'FT', 4, 8.00, 78, 2.95, 3.77, 16.19, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'FT', 5, 26.92, 78, 8.54, 13.44, 46.64, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'FT', 6, 3.64, 78, 2.65, 0.83, 14.55, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'FT', 7, 2.81, 78, 2.75, 0.39, 17.72, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'IM', NULL, 3.47, 79, 0.29, 2.88, 4.05, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'RT', NULL, 83.15, 103, 4.33, 72.78, 90.11, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'FT', 1, 8.77, 25, 7.13, 1.50, 37.71, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'FT', 2, 22.69, 25, 10.17, 8.14, 49.28, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'FT', 3, 27.76, 25, 12.12, 9.94, 57.23, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'FT', 4, 29.93, 25, 13.29, 10.35, 61.24, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'FT', 5, 6.68, 25, 6.24, 0.90, 36.12, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'FT', 6, 0.00, 25, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'FT', 7, 4.17, 25, 3.21, 0.82, 18.56, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'IM', NULL, 3.65, 24, 0.34, 2.95, 4.34, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'RT', NULL, 24.98, 103, 5.92, 15.11, 38.37, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'FT', 1, 15.12, 53, 5.83, 6.68, 30.70, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'FT', 2, 33.28, 53, 12.78, 13.57, 61.30, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'FT', 3, 30.12, 53, 9.77, 14.52, 52.23, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'FT', 4, 15.82, 53, 7.04, 6.11, 35.19, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'FT', 5, 5.66, 53, 3.83, 1.40, 20.22, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'FT', 6, 0.00, 53, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'FT', 7, 0.00, 53, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'IM', NULL, 3.28, 55, 0.20, 2.87, 3.69, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'RT', NULL, 60.10, 103, 7.33, 45.11, 73.41, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'FT', 1, 20.20, 62, 6.66, 9.98, 36.63, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'FT', 2, 32.21, 62, 8.90, 17.37, 51.78, 'N', '2009-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'FT', 3, 46.84, 62, 11.31, 26.21, 68.61, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'FT', 4, 0.32, 62, 0.32, 0.04, 2.39, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'FT', 5, 0.36, 62, 0.37, 0.05, 2.75, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'FT', 6, 0.00, 62, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'FT', 7, 0.07, 62, 0.07, 0.01, 0.55, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'IM', NULL, 3.28, 64, 0.15, 2.98, 3.58, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'RT', NULL, 65.91, 103, 6.86, 51.33, 77.99, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'FT', 1, 9.04, 63, 4.05, 3.58, 21.03, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'FT', 2, 23.03, 63, 8.34, 10.47, 43.38, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'FT', 3, 46.65, 63, 12.87, 23.72, 71.09, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'FT', 4, 8.63, 63, 4.90, 2.66, 24.63, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'FT', 5, 11.67, 63, 6.60, 3.54, 32.22, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'FT', 6, 0.97, 63, 0.74, 0.21, 4.34, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'FT', 7, 0.00, 63, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'IM', NULL, 3.20, 61, 0.17, 2.86, 3.55, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'RT', NULL, 58.03, 103, 9.09, 39.75, 74.34, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'FT', 1, 0.72, 58, 0.57, 0.15, 3.49, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'FT', 2, 19.32, 58, 8.38, 7.54, 41.28, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'FT', 3, 37.36, 58, 9.21, 21.34, 56.73, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'FT', 4, 9.17, 58, 4.54, 3.27, 23.14, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'FT', 5, 27.68, 58, 11.57, 10.74, 54.91, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'FT', 6, 1.73, 58, 1.39, 0.34, 8.27, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'FT', 7, 4.01, 58, 3.66, 0.62, 21.86, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'IM', NULL, 3.10, 60, 0.18, 2.74, 3.46, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'RT', NULL, 63.38, 103, 6.86, 49.06, 75.67, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'FT', 1, 42.08, 52, 12.47, 20.64, 66.99, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'FT', 2, 23.40, 52, 8.54, 10.50, 44.30, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'FT', 3, 16.64, 52, 9.17, 5.03, 42.94, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'FT', 4, 2.00, 52, 1.44, 0.47, 8.16, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'FT', 5, 4.74, 52, 4.28, 0.74, 25.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'FT', 6, 2.23, 52, 1.57, 0.53, 8.83, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'FT', 7, 8.91, 52, 5.64, 2.37, 28.28, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'IM', NULL, 2.81, 50, 0.29, 2.22, 3.40, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'RT', NULL, 60.34, 103, 6.75, 46.51, 72.70, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'FT', 1, 2.36, 86, 2.19, 0.36, 13.82, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'FT', 2, 7.30, 86, 4.97, 1.80, 25.31, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'FT', 3, 5.99, 86, 2.84, 2.29, 14.79, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'FT', 4, 11.99, 86, 5.51, 4.60, 27.80, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'FT', 5, 37.42, 86, 8.20, 22.96, 54.53, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'FT', 6, 15.78, 86, 5.16, 7.97, 28.84, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'FT', 7, 19.17, 86, 7.11, 8.69, 37.13, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'IM', NULL, 3.73, 87, 0.15, 3.43, 4.02, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'RT', NULL, 77.16, 115, 6.14, 62.90, 87.07, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'FT', 1, 3.80, 80, 2.62, 0.94, 14.13, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'FT', 2, 21.75, 80, 6.27, 11.77, 36.67, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'FT', 3, 21.68, 80, 5.79, 12.32, 35.29, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'FT', 4, 20.93, 80, 5.58, 11.92, 34.12, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'FT', 5, 22.52, 80, 5.50, 13.44, 35.23, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'FT', 6, 9.33, 80, 3.92, 3.93, 20.56, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'FT', 7, 0.00, 80, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'IM', NULL, 3.60, 80, 0.15, 3.29, 3.90, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'RT', NULL, 67.75, 113, 7.11, 52.44, 80.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'FT', 1, 2.57, 92, 2.25, 0.44, 13.59, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'FT', 2, 24.23, 92, 6.57, 13.58, 39.43, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'FT', 3, 24.90, 92, 5.95, 14.98, 38.43, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'FT', 4, 16.44, 92, 4.95, 8.78, 28.71, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'FT', 5, 29.52, 92, 6.14, 18.89, 42.95, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'FT', 6, 1.04, 92, 1.01, 0.15, 6.91, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'FT', 7, 1.29, 92, 1.29, 0.18, 8.82, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'IM', NULL, 3.57, 93, 0.15, 3.27, 3.87, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'RT', NULL, 73.11, 114, 6.60, 58.31, 84.09, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'FT', 1, 2.43, 86, 1.72, 0.58, 9.57, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'FT', 2, 13.08, 86, 6.30, 4.76, 31.19, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'FT', 3, 31.28, 86, 6.68, 19.70, 45.77, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'FT', 4, 30.55, 86, 7.39, 18.04, 46.79, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'FT', 5, 18.86, 86, 6.60, 8.98, 35.38, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'FT', 6, 2.79, 86, 2.09, 0.62, 11.70, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'FT', 7, 1.02, 86, 1.00, 0.14, 6.93, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'IM', NULL, 3.27, 84, 0.16, 2.96, 3.59, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'RT', NULL, 73.97, 116, 6.00, 60.51, 84.05, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'FT', 1, 5.51, 98, 2.79, 1.97, 14.44, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'FT', 2, 25.98, 98, 6.90, 14.70, 41.70, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'FT', 3, 25.16, 98, 5.03, 16.52, 36.36, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'FT', 4, 22.47, 98, 4.59, 14.66, 32.84, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'FT', 5, 16.86, 98, 4.90, 9.20, 28.88, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'FT', 6, 3.35, 98, 2.57, 0.71, 14.37, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'FT', 7, 0.66, 98, 0.63, 0.10, 4.27, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'IM', NULL, 3.12, 97, 0.16, 2.80, 3.45, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'RT', NULL, 83.44, 116, 5.14, 70.69, 91.32, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'FT', 1, 2.60, 81, 1.50, 0.82, 7.97, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'FT', 2, 24.67, 81, 7.07, 13.32, 41.11, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'FT', 3, 9.67, 81, 3.55, 4.55, 19.36, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'FT', 4, 25.97, 81, 7.59, 13.79, 43.48, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'FT', 5, 24.23, 81, 5.53, 14.94, 36.80, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'FT', 6, 6.68, 81, 3.45, 2.33, 17.70, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'FT', 7, 6.18, 81, 3.63, 1.86, 18.65, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'IM', NULL, 4.11, 80, 0.13, 3.85, 4.36, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'RT', NULL, 62.32, 116, 6.99, 47.83, 74.90, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'FT', 1, 0.04, 72, 0.04, 0.01, 0.30, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'FT', 2, 19.66, 72, 7.49, 8.68, 38.66, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'FT', 3, 15.99, 72, 5.26, 8.03, 29.34, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'FT', 4, 25.02, 72, 6.79, 13.96, 40.71, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'FT', 5, 32.77, 72, 7.96, 19.17, 50.03, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'FT', 6, 3.06, 72, 1.89, 0.88, 10.08, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'FT', 7, 3.46, 72, 2.31, 0.89, 12.48, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'IM', NULL, 3.71, 74, 0.13, 3.44, 3.97, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'RT', NULL, 54.54, 116, 6.97, 40.73, 67.68, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'FT', 1, 36.90, 60, 9.70, 20.27, 57.37, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'FT', 2, 45.31, 60, 9.15, 28.36, 63.43, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'FT', 3, 9.32, 60, 5.17, 2.93, 25.91, 'N', '2009-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'FT', 4, 5.93, 60, 3.79, 1.59, 19.72, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'FT', 5, 1.43, 60, 1.44, 0.19, 10.12, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'FT', 6, 0.00, 60, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'FT', 7, 1.11, 60, 1.12, 0.15, 7.93, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'IM', NULL, 3.58, 59, 0.21, 3.17, 4.00, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'RT', NULL, 46.71, 116, 6.33, 34.63, 59.19, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'FT', 1, 3.98, 61, 3.91, 0.53, 24.32, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'FT', 2, 28.92, 61, 8.75, 14.80, 48.79, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'FT', 3, 30.33, 61, 8.48, 16.32, 49.28, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'FT', 4, 21.01, 61, 5.98, 11.46, 35.35, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'FT', 5, 13.49, 61, 5.33, 5.89, 27.99, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'FT', 6, 0.28, 61, 0.16, 0.08, 0.91, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'FT', 7, 1.99, 61, 1.50, 0.43, 8.67, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'IM', NULL, 3.46, 62, 0.19, 3.07, 3.84, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'RT', NULL, 51.88, 114, 6.21, 39.71, 63.83, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'FT', 1, 26.03, 38, 9.92, 11.02, 49.98, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'FT', 2, 39.03, 38, 10.44, 20.83, 60.90, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'FT', 3, 20.94, 38, 10.16, 7.09, 47.88, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'FT', 4, 8.96, 38, 6.53, 1.90, 33.28, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'FT', 5, 5.05, 38, 3.11, 1.41, 16.54, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'FT', 6, 0.00, 38, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'FT', 7, 0.00, 38, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'IM', NULL, 3.32, 38, 0.21, 2.89, 3.75, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'RT', NULL, 32.29, 113, 5.77, 22.04, 44.58, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'FT', 1, 25.79, 58, 7.50, 13.68, 43.24, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'FT', 2, 55.06, 58, 7.89, 39.28, 69.88, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'FT', 3, 7.74, 58, 4.36, 2.41, 22.15, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'FT', 4, 7.94, 58, 4.75, 2.30, 24.04, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'FT', 5, 1.44, 58, 1.45, 0.19, 10.18, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'FT', 6, 2.03, 58, 2.02, 0.27, 13.67, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'FT', 7, 0.00, 58, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'IM', NULL, 3.21, 56, 0.12, 2.98, 3.45, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'RT', NULL, 47.12, 112, 6.30, 35.06, 59.52, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'FT', 1, 45.62, 38, 12.70, 22.92, 70.30, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'FT', 2, 22.79, 38, 8.76, 9.72, 44.74, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'FT', 3, 16.00, 38, 7.36, 5.91, 36.63, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'FT', 4, 13.10, 38, 7.98, 3.52, 38.41, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'FT', 5, 2.49, 38, 2.26, 0.38, 14.42, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'FT', 6, 0.00, 38, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'FT', 7, 0.00, 38, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'IM', NULL, 3.20, 38, 0.18, 2.83, 3.57, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'RT', NULL, 30.56, 114, 6.22, 19.77, 44.02, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'FT', 1, 30.28, 25, 11.74, 12.12, 57.78, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'FT', 2, 34.68, 25, 14.30, 12.61, 66.14, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'FT', 3, 21.12, 25, 9.06, 8.02, 45.13, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'FT', 4, 3.26, 25, 3.32, 0.38, 22.80, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'FT', 5, 7.19, 25, 4.84, 1.70, 25.71, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'FT', 6, 0.00, 25, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'FT', 7, 3.47, 25, 3.48, 0.42, 23.42, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'IM', NULL, 2.84, 24, 0.18, 2.46, 3.22, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'RT', NULL, 21.82, 114, 5.53, 12.80, 34.66, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'FT', 1, 35.38, 52, 10.26, 18.20, 57.40, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'FT', 2, 53.21, 52, 9.79, 34.07, 71.46, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'FT', 3, 5.98, 52, 3.59, 1.73, 18.67, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'FT', 4, 0.00, 52, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'FT', 5, 5.42, 52, 2.98, 1.75, 15.55, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'FT', 6, 0.00, 52, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'FT', 7, 0.00, 52, 0.00, NULL, NULL, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'IM', NULL, 2.23, 51, 0.19, 1.85, 2.60, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'RT', NULL, 35.35, 115, 6.43, 23.84, 48.84, 'N', '2009-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 1, 0.15, 119, 0.15, 0.02, 1.12, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 2, 4.07, 119, 2.28, 1.32, 11.86, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 3, 9.11, 119, 4.06, 3.66, 20.95, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 4, 54.55, 119, 11.60, 32.21, 75.19, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 5, 24.77, 119, 8.82, 11.42, 45.66, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 6, 6.52, 119, 3.01, 2.55, 15.64, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 7, 0.84, 119, 0.53, 0.24, 2.89, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'IM', NULL, 4.36, 119, 0.14, 4.08, 4.64, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'RT', NULL, 99.81, 120, 0.19, 98.58, 99.98, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 1, 3.06, 91, 2.80, 0.48, 17.10, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 2, 19.84, 91, 11.97, 5.26, 52.46, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 3, 16.88, 91, 6.78, 7.21, 34.66, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 4, 4.54, 91, 1.84, 2.00, 9.97, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 5, 26.93, 91, 10.17, 11.66, 50.70, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 6, 28.21, 91, 15.57, 7.86, 64.41, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 7, 0.54, 91, 0.41, 0.12, 2.39, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'IM', NULL, 4.12, 91, 0.30, 3.52, 4.72, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'RT', NULL, 76.71, 120, 8.42, 56.44, 89.33, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 1, 5.11, 118, 4.37, 0.89, 24.31, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 2, 16.33, 118, 5.39, 8.20, 29.90, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 3, 22.79, 118, 12.06, 7.06, 53.42, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 4, 22.45, 118, 7.83, 10.62, 41.37, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 5, 20.47, 118, 5.16, 12.08, 32.52, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 6, 9.58, 118, 6.72, 2.23, 33.02, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 7, 3.26, 118, 2.29, 0.80, 12.41, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'IM', NULL, 4.03, 117, 0.14, 3.76, 4.30, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'RT', NULL, 99.70, 120, 0.23, 98.63, 99.93, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 1, 4.10, 109, 2.73, 1.07, 14.48, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 2, 28.80, 109, 8.71, 14.84, 48.43, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 3, 19.64, 109, 5.43, 10.99, 32.59, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 4, 13.13, 109, 6.18, 4.91, 30.69, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 5, 12.80, 109, 4.75, 5.94, 25.45, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 6, 21.21, 109, 13.90, 4.92, 58.33, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 7, 0.33, 109, 0.26, 0.07, 1.57, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'IM', NULL, 3.98, 110, 0.23, 3.54, 4.43, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'RT', NULL, 93.04, 120, 3.69, 81.24, 97.64, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 1, 0.00, 120, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 2, 7.41, 120, 4.69, 2.02, 23.67, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 3, 27.18, 120, 10.47, 11.58, 51.54, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 4, 17.87, 120, 4.93, 10.07, 29.74, 'N', '2008-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 5, 31.88, 120, 11.09, 14.55, 56.27, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 6, 15.47, 120, 6.80, 6.13, 33.88, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 7, 0.19, 120, 0.20, 0.03, 1.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'IM', NULL, 3.97, 120, 0.12, 3.73, 4.20, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'RT', NULL, 100.00, 120, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 1, 6.24, 119, 4.46, 1.45, 23.17, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 2, 8.48, 119, 4.29, 3.01, 21.67, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 3, 12.75, 119, 3.92, 6.78, 22.70, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 4, 42.50, 119, 10.40, 24.14, 63.19, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 5, 19.87, 119, 6.89, 9.53, 36.87, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 6, 8.70, 119, 6.04, 2.07, 30.05, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 7, 1.46, 119, 1.48, 0.19, 10.26, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'IM', NULL, 3.97, 119, 0.16, 3.64, 4.29, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'RT', NULL, 100.00, 119, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 1, 3.90, 119, 2.71, 0.96, 14.51, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 2, 4.16, 119, 2.29, 1.38, 11.90, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 3, 41.17, 119, 12.11, 20.64, 65.32, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 4, 26.74, 119, 7.74, 14.30, 44.39, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 5, 12.45, 119, 4.85, 5.57, 25.54, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 6, 11.38, 119, 5.48, 4.19, 27.37, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 7, 0.19, 119, 0.20, 0.03, 1.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'IM', NULL, 3.84, 118, 0.19, 3.47, 4.22, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'RT', NULL, 99.85, 120, 0.15, 98.88, 99.98, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 1, 0.87, 109, 0.68, 0.18, 4.03, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 2, 1.55, 109, 0.84, 0.53, 4.48, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 3, 7.01, 109, 4.57, 1.84, 23.24, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 4, 14.72, 109, 6.90, 5.49, 33.92, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 5, 38.55, 109, 11.71, 19.06, 62.56, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 6, 17.37, 109, 6.99, 7.42, 35.56, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 7, 19.92, 109, 6.35, 10.15, 35.40, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'IM', NULL, 3.79, 110, 0.16, 3.47, 4.10, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'RT', NULL, 98.33, 120, 0.78, 95.82, 99.35, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 1, 14.58, 106, 6.30, 5.89, 31.75, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 2, 41.93, 106, 10.90, 22.91, 63.69, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 3, 22.22, 106, 8.45, 9.77, 42.97, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 4, 0.78, 106, 0.50, 0.22, 2.75, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 5, 11.70, 106, 6.13, 3.92, 30.08, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 6, 7.25, 106, 4.28, 2.17, 21.63, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 7, 1.55, 106, 0.82, 0.54, 4.37, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'IM', NULL, 3.74, 106, 0.12, 3.51, 3.97, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'RT', NULL, 84.78, 120, 5.89, 69.29, 93.22, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 1, 4.83, 106, 4.74, 0.65, 28.14, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 2, 20.78, 106, 9.44, 7.76, 44.99, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 3, 14.87, 106, 5.01, 7.38, 27.69, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 4, 39.61, 106, 11.88, 19.68, 63.71, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 5, 16.59, 106, 7.98, 5.97, 38.42, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 6, 3.31, 106, 2.50, 0.72, 13.86, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 7, 0.00, 106, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'IM', NULL, 3.72, 105, 0.20, 3.32, 4.12, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'RT', NULL, 93.44, 117, 3.31, 83.00, 97.65, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 1, 1.17, 96, 0.65, 0.38, 3.49, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 2, 20.49, 96, 9.37, 7.60, 44.67, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 3, 31.71, 96, 10.48, 15.08, 54.83, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 4, 8.86, 96, 3.72, 3.75, 19.53, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 5, 37.46, 96, 14.74, 14.66, 67.63, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 6, 0.00, 96, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 7, 0.31, 96, 0.32, 0.04, 2.41, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'IM', NULL, 3.72, 96, 0.15, 3.43, 4.01, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'RT', NULL, 77.61, 119, 5.94, 63.80, 87.21, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 1, 3.74, 95, 2.82, 0.81, 15.57, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 2, 7.29, 95, 3.30, 2.90, 17.18, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 3, 38.51, 95, 12.16, 18.43, 63.46, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 4, 28.79, 95, 12.05, 11.18, 56.49, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 5, 21.44, 95, 14.01, 4.97, 58.73, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 6, 0.22, 95, 0.23, 0.03, 1.75, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 7, 0.00, 95, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'IM', NULL, 3.72, 95, 0.15, 3.42, 4.02, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'RT', NULL, 88.67, 119, 4.39, 76.71, 94.89, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 1, 0.11, 108, 0.11, 0.01, 0.86, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 2, 2.17, 108, 1.75, 0.43, 10.19, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 3, 20.15, 108, 8.98, 7.70, 43.28, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 4, 9.96, 108, 3.99, 4.38, 21.10, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 5, 44.81, 108, 14.05, 20.84, 71.46, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 6, 15.58, 108, 6.38, 6.59, 32.56, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 7, 7.22, 108, 3.77, 2.49, 19.18, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'IM', NULL, 3.70, 108, 0.14, 3.42, 3.98, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'RT', NULL, 90.79, 119, 3.30, 81.87, 95.56, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 1, 0.00, 104, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 2, 5.51, 104, 3.54, 1.49, 18.33, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 3, 37.15, 104, 11.74, 17.91, 61.57, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 4, 15.02, 104, 4.59, 7.96, 26.52, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 5, 31.99, 104, 10.59, 15.19, 55.25, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 6, 9.29, 104, 4.22, 3.66, 21.65, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 7, 1.05, 104, 0.62, 0.32, 3.36, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'IM', NULL, 3.69, 105, 0.18, 3.33, 4.06, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'RT', NULL, 86.62, 120, 6.10, 69.53, 94.83, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 1, 10.20, 116, 6.25, 2.86, 30.49, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 2, 26.08, 116, 7.53, 13.99, 43.34, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 3, 11.36, 116, 4.01, 5.50, 21.99, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 4, 18.03, 116, 6.19, 8.75, 33.53, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 5, 25.41, 116, 11.67, 9.14, 53.55, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 6, 8.66, 116, 5.42, 2.38, 26.92, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 7, 0.26, 116, 0.27, 0.03, 1.96, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'IM', NULL, 3.64, 116, 0.26, 3.13, 4.15, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'RT', NULL, 97.47, 120, 2.22, 86.64, 99.57, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 1, 2.01, 111, 1.69, 0.38, 10.09, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 2, 6.93, 111, 3.03, 2.85, 15.89, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 3, 45.20, 111, 10.32, 26.53, 65.33, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 4, 31.93, 111, 9.42, 16.57, 52.55, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 5, 13.48, 111, 6.92, 4.59, 33.54, 'N', '2008-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 6, 0.45, 111, 0.34, 0.10, 2.01, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 7, 0.00, 111, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'IM', NULL, 3.59, 112, 0.10, 3.40, 3.79, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'RT', NULL, 91.76, 120, 5.20, 74.07, 97.75, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 1, 2.84, 105, 1.66, 0.88, 8.79, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 2, 21.98, 105, 6.93, 11.22, 38.57, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 3, 29.90, 105, 10.77, 13.34, 54.18, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 4, 21.38, 105, 7.21, 10.41, 38.90, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 5, 23.49, 105, 13.44, 6.52, 57.49, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 6, 0.41, 105, 0.42, 0.05, 3.11, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 7, 0.00, 105, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'IM', NULL, 3.42, 105, 0.16, 3.10, 3.73, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'RT', NULL, 84.32, 119, 6.11, 68.28, 93.08, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 1, 32.63, 112, 9.23, 17.41, 52.67, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 2, 46.43, 112, 12.24, 24.63, 69.68, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 3, 12.62, 112, 4.70, 5.85, 25.14, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 4, 0.15, 112, 0.10, 0.04, 0.59, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 5, 1.04, 112, 1.06, 0.14, 7.47, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 6, 5.19, 112, 4.01, 1.07, 21.61, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 7, 1.94, 112, 1.58, 0.38, 9.29, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'IM', NULL, 4.39, 112, 0.17, 4.06, 4.72, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'RT', NULL, 80.00, 173, 5.69, 66.46, 88.97, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 1, 0.74, 169, 0.56, 0.17, 3.27, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 2, 13.52, 169, 4.77, 6.53, 25.92, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 3, 69.40, 169, 7.58, 52.86, 82.10, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 4, 8.86, 169, 4.14, 3.41, 21.12, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 5, 4.30, 169, 2.09, 1.63, 10.91, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 6, 0.08, 169, 0.09, 0.01, 0.63, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 7, 3.08, 169, 1.91, 0.89, 10.13, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'IM', NULL, 4.38, 169, 0.13, 4.13, 4.64, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'RT', NULL, 99.81, 172, 0.14, 99.18, 99.96, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 1, 1.57, 152, 1.58, 0.21, 10.75, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 2, 1.49, 152, 1.18, 0.31, 6.93, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 3, 13.89, 152, 5.71, 5.91, 29.29, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 4, 19.00, 152, 14.91, 3.34, 61.40, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 5, 49.06, 152, 11.09, 28.61, 69.82, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 6, 10.31, 152, 4.73, 4.02, 24.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 7, 4.68, 152, 2.19, 1.83, 11.47, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'IM', NULL, 4.36, 153, 0.14, 4.08, 4.64, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'RT', NULL, 88.17, 172, 4.60, 75.74, 94.68, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 1, 4.49, 149, 3.37, 0.98, 18.19, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 2, 21.94, 149, 14.09, 5.24, 58.81, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 3, 8.86, 149, 4.18, 3.38, 21.28, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 4, 9.83, 149, 4.18, 4.12, 21.69, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 5, 44.42, 149, 10.18, 26.14, 64.35, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 6, 7.38, 149, 3.45, 2.86, 17.77, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 7, 3.08, 149, 1.95, 0.86, 10.37, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'IM', NULL, 4.23, 148, 0.17, 3.89, 4.57, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'RT', NULL, 90.82, 172, 4.38, 77.82, 96.54, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 1, 2.97, 170, 2.24, 0.66, 12.41, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 2, 35.41, 170, 11.85, 16.47, 60.38, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 3, 22.32, 170, 6.61, 11.93, 37.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 4, 8.90, 170, 3.64, 3.88, 19.15, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 5, 22.56, 170, 6.00, 12.88, 36.47, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 6, 3.96, 170, 3.12, 0.81, 17.24, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 7, 3.88, 170, 2.06, 1.34, 10.70, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'IM', NULL, 4.17, 169, 0.17, 3.83, 4.51, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'RT', NULL, 99.88, 173, 0.09, 99.48, 99.97, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 1, 30.11, 151, 8.27, 16.55, 48.35, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 2, 41.27, 151, 11.67, 21.35, 64.53, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 3, 15.72, 151, 5.31, 7.79, 29.17, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 4, 6.04, 151, 3.66, 1.76, 18.70, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 5, 3.43, 151, 1.59, 1.36, 8.41, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 6, 3.35, 151, 3.35, 0.45, 21.12, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 7, 0.07, 151, 0.07, 0.01, 0.54, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'IM', NULL, 4.14, 150, 0.19, 3.76, 4.52, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'RT', NULL, 91.19, 173, 3.49, 81.47, 96.06, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 1, 0.00, 158, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 2, 0.72, 158, 0.49, 0.19, 2.71, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 3, 31.29, 158, 12.64, 12.48, 59.27, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 4, 21.53, 158, 6.64, 11.22, 37.35, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 5, 31.72, 158, 8.27, 17.94, 49.68, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 6, 12.76, 158, 5.44, 5.28, 27.74, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 7, 1.97, 158, 1.27, 0.55, 6.87, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'IM', NULL, 4.14, 158, 0.08, 3.98, 4.30, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'RT', NULL, 95.13, 173, 2.69, 86.12, 98.40, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8862, 'FT', 1, 1.13, 144, 1.14, 0.15, 7.95, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8862, 'FT', 2, 10.17, 144, 3.88, 4.66, 20.79, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8862, 'FT', 3, 52.51, 144, 11.06, 31.51, 72.66, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8862, 'FT', 4, 13.50, 144, 5.67, 5.64, 28.96, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8862, 'FT', 5, 21.51, 144, 6.88, 10.91, 38.01, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8862, 'FT', 6, 0.13, 144, 0.10, 0.03, 0.62, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8862, 'FT', 7, 1.05, 144, 0.64, 0.31, 3.46, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8862, 'IM', NULL, 4.05, 145, 0.20, 3.66, 4.44, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8862, 'RT', NULL, 87.82, 172, 4.60, 75.51, 94.40, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 1, 10.64, 149, 4.74, 4.25, 24.19, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 2, 19.78, 149, 6.82, 9.54, 36.57, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 3, 30.34, 149, 14.48, 10.11, 62.79, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 4, 14.34, 149, 5.87, 6.11, 30.09, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 5, 14.61, 149, 5.23, 6.96, 28.15, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 6, 6.73, 149, 4.32, 1.82, 21.94, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 7, 3.55, 149, 2.13, 1.06, 11.20, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'IM', NULL, 4.00, 149, 0.23, 3.55, 4.45, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'RT', NULL, 83.96, 173, 5.23, 70.87, 91.84, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 1, 2.87, 149, 1.85, 0.79, 9.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 2, 20.45, 149, 6.19, 10.81, 35.29, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 3, 37.01, 149, 12.44, 16.99, 62.79, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 4, 16.82, 149, 6.36, 7.62, 33.16, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 5, 20.56, 149, 6.59, 10.44, 36.50, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 6, 2.10, 149, 1.72, 0.41, 10.08, 'N', '2006-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 7, 0.18, 149, 0.18, 0.02, 1.33, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'IM', NULL, 3.98, 149, 0.22, 3.55, 4.42, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'RT', NULL, 92.49, 172, 3.86, 80.45, 97.36, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 1, 4.84, 156, 2.83, 1.49, 14.60, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 2, 44.90, 156, 11.39, 24.72, 66.92, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 3, 14.06, 156, 5.08, 6.66, 27.29, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 4, 15.30, 156, 5.66, 7.08, 29.98, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 5, 18.80, 156, 6.00, 9.62, 33.48, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 6, 0.63, 156, 0.40, 0.18, 2.20, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 7, 1.47, 156, 1.04, 0.36, 5.80, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'IM', NULL, 3.97, 155, 0.11, 3.76, 4.19, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'RT', NULL, 90.71, 172, 4.14, 78.74, 96.26, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 1, 6.50, 160, 2.57, 2.93, 13.81, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 2, 46.30, 160, 10.29, 27.57, 66.14, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 3, 20.39, 160, 6.05, 10.93, 34.83, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 4, 10.97, 160, 4.57, 4.67, 23.68, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 5, 9.02, 160, 4.07, 3.59, 20.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 6, 5.19, 160, 3.49, 1.33, 18.17, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 7, 1.63, 160, 1.16, 0.40, 6.50, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'IM', NULL, 3.96, 160, 0.10, 3.77, 4.16, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'RT', NULL, 99.40, 172, 0.23, 98.71, 99.72, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 1, 5.89, 153, 3.73, 1.63, 19.12, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 2, 20.23, 153, 6.55, 10.22, 36.11, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 3, 32.46, 153, 8.58, 18.15, 51.02, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 4, 29.02, 153, 14.04, 9.61, 61.13, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 5, 12.02, 153, 4.49, 5.58, 24.01, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 6, 0.08, 153, 0.07, 0.01, 0.43, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 7, 0.29, 153, 0.30, 0.04, 2.15, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'IM', NULL, 3.95, 153, 0.22, 3.51, 4.40, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'RT', NULL, 85.45, 172, 5.38, 71.41, 93.24, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 1, 2.81, 159, 2.32, 0.54, 13.39, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 2, 40.96, 159, 11.23, 21.70, 63.45, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 3, 27.06, 159, 6.62, 16.05, 41.85, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 4, 16.24, 159, 5.48, 8.05, 30.04, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 5, 10.19, 159, 4.35, 4.25, 22.47, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 6, 1.61, 159, 0.96, 0.49, 5.15, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 7, 1.13, 159, 1.13, 0.16, 7.74, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'IM', NULL, 3.95, 158, 0.21, 3.54, 4.36, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'RT', NULL, 96.75, 173, 1.70, 91.09, 98.86, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 1, 4.31, 147, 3.37, 0.89, 18.49, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 2, 29.16, 147, 13.95, 9.78, 60.99, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 3, 32.78, 147, 9.01, 17.85, 52.26, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 4, 12.92, 147, 4.51, 6.30, 24.67, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 5, 17.16, 147, 6.08, 8.17, 32.54, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 6, 1.91, 147, 1.79, 0.29, 11.46, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 7, 1.75, 147, 1.33, 0.38, 7.61, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'IM', NULL, 3.88, 147, 0.11, 3.65, 4.11, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'RT', NULL, 89.05, 172, 4.58, 76.29, 95.36, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 1, 6.80, 132, 4.26, 1.90, 21.61, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 2, 40.32, 132, 12.87, 19.00, 66.06, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 3, 19.09, 132, 6.26, 9.57, 34.49, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 4, 16.98, 132, 6.51, 7.58, 33.78, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 5, 15.74, 132, 5.53, 7.57, 29.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 6, 0.00, 132, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 7, 1.05, 132, 1.05, 0.14, 7.30, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'IM', NULL, 3.81, 132, 0.12, 3.57, 4.05, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'RT', NULL, 83.69, 172, 5.72, 69.17, 92.15, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 1, 18.09, 132, 6.98, 8.00, 35.94, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 2, 35.50, 132, 10.02, 18.80, 56.67, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 3, 35.79, 132, 14.49, 13.79, 66.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 4, 0.92, 132, 0.57, 0.27, 3.11, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 5, 7.88, 132, 3.69, 3.04, 18.94, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 6, 0.07, 132, 0.07, 0.01, 0.54, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 7, 1.75, 132, 1.48, 0.32, 8.89, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'IM', NULL, 3.51, 132, 0.16, 3.20, 3.82, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'RT', NULL, 76.81, 171, 6.45, 61.83, 87.14, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 1, 3.50, 124, 2.40, 0.88, 12.89, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 2, 23.11, 124, 16.30, 4.66, 64.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 3, 9.97, 124, 4.71, 3.78, 23.83, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 4, 6.74, 124, 3.19, 2.58, 16.48, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 5, 43.15, 124, 11.32, 23.34, 65.43, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 6, 9.87, 124, 5.19, 3.34, 25.79, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 7, 3.65, 124, 2.30, 1.03, 12.13, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'IM', NULL, 3.47, 124, 0.52, 2.43, 4.50, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'RT', NULL, 78.26, 172, 5.92, 64.42, 87.74, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 1, 27.44, 98, 16.76, 6.64, 66.78, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 2, 3.17, 98, 1.92, 0.94, 10.18, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 3, 45.43, 98, 12.34, 23.66, 69.10, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 4, 16.42, 98, 6.58, 7.05, 33.71, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 5, 1.59, 98, 1.00, 0.45, 5.42, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 6, 4.41, 98, 4.33, 0.60, 26.16, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 7, 1.54, 98, 1.57, 0.20, 10.85, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'IM', NULL, 3.44, 99, 0.55, 2.34, 4.54, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'RT', NULL, 72.49, 173, 6.91, 57.08, 83.93, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 1, 27.55, 66, 10.66, 11.57, 52.49, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 2, 47.36, 66, 15.34, 20.84, 75.46, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 3, 19.03, 66, 8.56, 7.19, 41.62, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 4, 6.06, 66, 5.14, 1.05, 28.17, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 5, 0.00, 66, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 6, 0.00, 66, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 7, 0.00, 66, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'IM', NULL, 3.16, 67, 0.18, 2.79, 3.52, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'RT', NULL, 62.85, 172, 8.24, 45.75, 77.25, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 1, 21.38, 126, 7.05, 10.60, 38.41, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 2, 46.29, 126, 12.40, 24.31, 69.80, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 3, 22.97, 126, 7.40, 11.53, 40.55, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 4, 6.56, 126, 3.51, 2.21, 17.91, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 5, 1.89, 126, 1.39, 0.44, 7.84, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 6, 0.71, 126, 0.55, 0.15, 3.22, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 7, 0.20, 126, 0.21, 0.03, 1.53, 'N', '2006-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'IM', NULL, 2.76, 126, 0.20, 2.37, 3.15, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'RT', NULL, 81.05, 173, 5.80, 66.98, 90.01, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'FT', 1, 0.00, 60, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'FT', 2, 5.63, 60, 5.54, 0.73, 32.50, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'FT', 3, 6.84, 60, 5.43, 1.32, 28.78, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'FT', 4, 0.87, 60, 0.82, 0.13, 5.60, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'FT', 5, 45.89, 60, 9.43, 28.40, 64.46, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'FT', 6, 13.83, 60, 6.78, 4.89, 33.39, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'FT', 7, 26.93, 60, 8.71, 13.19, 47.20, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'IM', NULL, 4.57, 61, 0.18, 4.22, 4.93, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'RT', NULL, 99.63, 65, 0.27, 98.46, 99.91, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'FT', 1, 0.00, 44, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'FT', 2, 0.04, 44, 0.04, 0.01, 0.30, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'FT', 3, 8.28, 44, 6.97, 1.40, 36.49, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'FT', 4, 21.90, 44, 9.61, 8.28, 46.53, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'FT', 5, 26.31, 44, 11.10, 10.12, 53.11, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'FT', 6, 15.12, 44, 8.39, 4.55, 39.97, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'FT', 7, 28.36, 44, 11.17, 11.55, 54.54, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'IM', NULL, 4.55, 44, 0.15, 4.24, 4.85, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'RT', NULL, 76.55, 65, 7.96, 57.36, 88.79, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'FT', 1, 0.00, 58, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'FT', 2, 0.01, 58, 0.01, 0.00, 0.03, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'FT', 3, 2.94, 58, 2.71, 0.45, 16.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'FT', 4, 15.22, 58, 9.11, 4.18, 42.48, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'FT', 5, 40.23, 58, 11.89, 20.00, 64.44, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'FT', 6, 18.53, 58, 8.73, 6.67, 41.99, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'FT', 7, 23.08, 58, 8.79, 10.02, 44.72, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'IM', NULL, 4.32, 58, 0.19, 3.95, 4.69, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'RT', NULL, 80.74, 65, 8.01, 59.97, 92.14, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'FT', 1, 0.00, 41, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'FT', 2, 0.01, 41, 0.01, 0.00, 0.04, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'FT', 3, 17.73, 41, 10.33, 4.89, 47.43, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'FT', 4, 24.00, 41, 11.82, 7.85, 53.93, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'FT', 5, 41.89, 41, 12.70, 20.08, 67.41, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'FT', 6, 7.74, 41, 7.60, 0.97, 41.87, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'FT', 7, 8.64, 41, 5.24, 2.41, 26.59, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'IM', NULL, 4.19, 42, 0.27, 3.65, 4.73, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'RT', NULL, 72.47, 65, 7.17, 56.22, 84.36, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8880, 'FT', 1, 18.48, 57, 8.95, 6.45, 42.71, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8880, 'FT', 2, 49.97, 57, 10.66, 29.83, 70.11, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8880, 'FT', 3, 23.66, 57, 9.03, 10.23, 45.76, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8880, 'FT', 4, 0.81, 57, 0.78, 0.12, 5.33, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8880, 'FT', 5, 5.10, 57, 5.10, 0.65, 30.70, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8880, 'FT', 6, 0.00, 57, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8880, 'FT', 7, 1.97, 57, 1.96, 0.26, 13.35, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8880, 'IM', NULL, 3.59, 57, 0.27, 3.04, 4.14, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8880, 'RT', NULL, 91.64, 65, 5.61, 71.74, 97.93, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'FT', 1, 0.00, 38, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'FT', 2, 5.14, 38, 3.75, 1.13, 20.46, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'FT', 3, 14.37, 38, 8.47, 4.00, 40.36, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'FT', 4, 22.44, 38, 11.64, 6.94, 52.87, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'FT', 5, 51.44, 38, 14.86, 24.09, 77.96, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'FT', 6, 1.25, 38, 1.25, 0.16, 9.00, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'FT', 7, 5.35, 38, 3.59, 1.33, 19.23, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'IM', NULL, 4.49, 38, 0.13, 4.23, 4.76, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'RT', NULL, 62.01, 64, 10.08, 40.98, 79.34, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'FT', 1, 0.00, 42, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'FT', 2, 0.03, 42, 0.03, 0.00, 0.20, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'FT', 3, 16.79, 42, 10.86, 4.03, 49.22, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'FT', 4, 9.95, 42, 8.35, 1.66, 42.04, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'FT', 5, 21.73, 42, 9.98, 7.82, 47.60, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'FT', 6, 25.14, 42, 11.53, 8.88, 53.64, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'FT', 7, 26.36, 42, 11.75, 9.54, 54.85, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'IM', NULL, 4.34, 43, 0.27, 3.79, 4.88, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'RT', NULL, 66.69, 65, 8.79, 47.59, 81.53, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'FT', 1, 30.16, 28, 15.65, 8.60, 66.48, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'FT', 2, 41.77, 28, 16.54, 15.09, 74.32, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'FT', 3, 22.46, 28, 13.48, 5.59, 58.64, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'FT', 4, 1.13, 28, 1.20, 0.13, 9.39, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'FT', 5, 4.47, 28, 4.61, 0.51, 30.02, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'FT', 6, 0.00, 28, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'FT', 7, 0.00, 28, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'IM', NULL, 4.24, 27, 0.28, 3.66, 4.82, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'RT', NULL, 35.52, 65, 9.69, 19.13, 56.18, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'FT', 1, 8.22, 31, 5.99, 1.74, 31.20, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'FT', 2, 29.58, 31, 12.61, 10.87, 59.12, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'FT', 3, 11.24, 31, 6.43, 3.28, 32.07, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'FT', 4, 3.90, 31, 3.90, 0.48, 25.37, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'FT', 5, 35.01, 31, 14.76, 12.53, 66.96, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'FT', 6, 12.05, 31, 11.22, 1.55, 54.37, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'FT', 7, 0.01, 31, 0.01, 0.00, 0.07, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'IM', NULL, 4.19, 31, 0.27, 3.64, 4.74, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'RT', NULL, 46.26, 65, 11.45, 25.54, 68.37, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'FT', 1, 8.55, 38, 8.30, 1.08, 44.53, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'FT', 2, 0.73, 38, 0.67, 0.11, 4.53, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'FT', 3, 23.36, 38, 11.21, 7.89, 52.02, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'FT', 4, 13.17, 38, 6.94, 4.24, 34.17, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'FT', 5, 27.61, 38, 9.98, 12.18, 51.19, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'FT', 6, 23.81, 38, 11.22, 8.20, 52.24, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'FT', 7, 2.77, 38, 2.75, 0.36, 18.40, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'IM', NULL, 3.90, 37, 0.29, 3.32, 4.48, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'RT', NULL, 65.21, 65, 8.66, 46.64, 80.07, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'FT', 1, 0.10, 26, 0.10, 0.01, 0.73, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'FT', 2, 28.23, 26, 13.79, 8.83, 61.52, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'FT', 3, 49.61, 26, 15.73, 21.23, 78.25, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'FT', 4, 18.48, 26, 12.30, 4.05, 54.91, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'FT', 5, 3.58, 26, 3.76, 0.39, 25.95, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'FT', 6, 0.00, 26, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'FT', 7, 0.00, 26, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'IM', NULL, 3.70, 26, 0.26, 3.17, 4.22, 'N', '2006-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'RT', NULL, 44.40, 65, 9.12, 27.63, 62.56, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'FT', 1, 15.97, 37, 11.03, 3.46, 50.15, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'FT', 2, 9.66, 37, 5.32, 3.01, 26.92, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'FT', 3, 30.83, 37, 12.09, 12.36, 58.46, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'FT', 4, 10.01, 37, 7.87, 1.86, 39.53, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'FT', 5, 32.78, 37, 13.89, 11.96, 63.65, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'FT', 6, 0.02, 37, 0.02, 0.00, 0.17, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'FT', 7, 0.73, 37, 0.78, 0.08, 6.13, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'IM', NULL, 3.68, 36, 0.20, 3.27, 4.08, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'RT', NULL, 55.00, 65, 10.84, 33.75, 74.56, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'FT', 1, 0.24, 14, 0.25, 0.02, 2.25, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'FT', 2, 55.81, 14, 22.95, 14.47, 90.41, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'FT', 3, 8.72, 14, 8.69, 0.89, 50.28, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'FT', 4, 2.34, 14, 2.51, 0.22, 20.51, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'FT', 5, 30.67, 14, 23.71, 3.82, 83.11, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'FT', 6, 0.00, 14, 0.00, NULL, NULL, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'FT', 7, 2.22, 14, 2.49, 0.19, 21.28, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'IM', NULL, 3.63, 14, 0.24, 3.12, 4.15, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'RT', NULL, 18.17, 65, 8.19, 6.88, 40.02, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'FT', 1, 20.35, 19, 11.56, 5.40, 53.36, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'FT', 2, 33.41, 19, 15.54, 10.36, 68.52, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'FT', 3, 46.24, 19, 15.21, 19.21, 75.68, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'FT', 4, 0.00, 19, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'FT', 5, 0.00, 19, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'FT', 6, 0.00, 19, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'FT', 7, 0.00, 19, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'IM', NULL, 3.54, 19, 0.30, 2.92, 4.16, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'RT', NULL, 38.00, 65, 10.10, 20.65, 59.08, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'FT', 1, 46.28, 15, 15.86, 17.99, 77.18, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'FT', 2, 5.08, 15, 3.72, 1.01, 21.87, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'FT', 3, 12.81, 15, 12.58, 1.29, 62.22, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'FT', 4, 20.16, 15, 15.26, 3.20, 65.87, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'FT', 5, 15.67, 15, 11.96, 2.60, 56.42, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'FT', 6, 0.00, 15, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'FT', 7, 0.00, 15, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'IM', NULL, 3.45, 15, 0.33, 2.74, 4.16, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'RT', NULL, 35.46, 65, 12.10, 16.04, 61.24, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'FT', 1, 4.31, 44, 4.12, 0.60, 25.25, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'FT', 2, 45.32, 44, 14.30, 20.56, 72.63, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'FT', 3, 30.29, 44, 11.44, 12.71, 56.45, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'FT', 4, 10.04, 44, 9.58, 1.30, 48.63, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'FT', 5, 10.04, 44, 9.58, 1.30, 48.63, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'FT', 6, 0.00, 44, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'FT', 7, 0.00, 44, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'IM', NULL, 3.31, 44, 0.30, 2.72, 3.91, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'RT', NULL, 55.35, 65, 9.66, 36.21, 73.02, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'FT', 1, 0.02, 8, 0.02, 0.00, 0.28, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'FT', 2, 35.17, 8, 12.55, 12.86, 66.61, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'FT', 3, 46.07, 8, 8.59, 27.39, 65.91, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'FT', 4, 18.73, 8, 17.04, 1.61, 76.49, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'FT', 5, 0.02, 8, 0.02, 0.00, 0.28, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'FT', 6, 0.00, 8, 0.00, NULL, NULL, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'FT', 7, 0.00, 8, 0.00, NULL, NULL, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'IM', NULL, 3.25, 8, 0.23, 2.71, 3.78, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'RT', NULL, 15.80, 65, 10.18, 3.91, 46.39, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'FT', 1, 1.34, 16, 1.39, 0.15, 11.32, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'FT', 2, 26.02, 16, 14.64, 6.51, 64.01, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'FT', 3, 25.94, 16, 17.52, 4.77, 71.00, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'FT', 4, 26.54, 16, 16.85, 5.42, 69.51, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'FT', 5, 20.15, 16, 16.76, 2.67, 69.93, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'FT', 6, 0.00, 16, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'FT', 7, 0.00, 16, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'IM', NULL, 3.11, 16, 0.08, 2.95, 3.27, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'RT', NULL, 29.74, 65, 8.88, 15.33, 49.74, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'FT', 1, 28.60, 15, 22.52, 3.63, 81.00, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'FT', 2, 35.50, 15, 22.51, 6.27, 81.92, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'FT', 3, 0.10, 15, 0.09, 0.01, 0.68, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'FT', 4, 31.57, 15, 19.04, 6.51, 75.34, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'FT', 5, 4.23, 15, 4.44, 0.42, 31.72, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'FT', 6, 0.00, 15, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'FT', 7, 0.00, 15, 0.00, NULL, NULL, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'IM', NULL, 2.96, 15, 0.33, 2.26, 3.67, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'RT', NULL, 19.49, 65, 7.29, 8.73, 37.99, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'FT', 1, 21.36, 10, 19.23, 2.00, 78.34, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'FT', 2, 35.87, 10, 20.18, 7.14, 80.27, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'FT', 3, 0.00, 10, 0.00, NULL, NULL, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'FT', 4, 42.71, 10, 22.61, 8.44, 85.78, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'FT', 5, 0.06, 10, 0.06, 0.01, 0.68, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'FT', 6, 0.00, 10, 0.00, NULL, NULL, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'FT', 7, 0.00, 10, 0.00, NULL, NULL, 'Y', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'IM', NULL, 2.73, 10, 0.19, 2.29, 3.17, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'RT', NULL, 26.03, 65, 9.41, 11.71, 48.29, 'N', '2006-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 1, 0.00, 117, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 2, 0.19, 117, 0.19, 0.03, 1.42, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 3, 0.53, 117, 0.41, 0.12, 2.42, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 4, 3.41, 117, 2.71, 0.69, 15.28, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 5, 43.87, 117, 5.35, 33.69, 54.58, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 6, 32.65, 117, 6.51, 21.24, 46.56, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 7, 19.35, 117, 5.70, 10.42, 33.10, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'IM', NULL, 4.28, 117, 0.12, 4.05, 4.52, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'RT', NULL, 86.05, 127, 3.82, 76.68, 92.04, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 1, 0.00, 122, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 2, 1.66, 122, 0.85, 0.60, 4.51, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 3, 5.49, 122, 2.41, 2.27, 12.71, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 4, 11.43, 122, 4.27, 5.30, 22.92, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 5, 52.03, 122, 5.89, 40.47, 63.37, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 6, 23.47, 122, 5.25, 14.67, 35.36, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 7, 5.93, 122, 2.86, 2.23, 14.82, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'IM', NULL, 4.20, 123, 0.09, 4.02, 4.38, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'RT', NULL, 97.01, 127, 1.85, 90.17, 99.14, 'N', '2008-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 1, 0.00, 126, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 2, 2.30, 126, 2.36, 0.29, 15.83, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 3, 8.06, 126, 4.13, 2.82, 20.92, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 4, 35.40, 126, 7.23, 22.66, 50.62, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 5, 40.73, 126, 6.37, 28.96, 53.68, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 6, 9.58, 126, 2.96, 5.12, 17.23, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 7, 3.93, 126, 2.22, 1.26, 11.56, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'IM', NULL, 4.11, 125, 0.09, 3.93, 4.28, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'RT', NULL, 98.68, 127, 1.35, 90.54, 99.83, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 1, 0.00, 108, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 2, 13.16, 108, 5.47, 5.54, 28.13, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 3, 16.94, 108, 4.75, 9.46, 28.48, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 4, 5.78, 108, 2.65, 2.29, 13.85, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 5, 44.59, 108, 6.63, 32.09, 57.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 6, 11.83, 108, 5.21, 4.75, 26.51, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 7, 7.70, 108, 3.39, 3.14, 17.69, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'IM', NULL, 4.02, 109, 0.14, 3.75, 4.29, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'RT', NULL, 81.03, 127, 4.06, 71.69, 87.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 1, 2.44, 121, 2.47, 0.32, 16.31, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 2, 22.85, 121, 4.86, 14.65, 33.83, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 3, 24.05, 121, 5.31, 15.12, 36.01, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 4, 21.19, 121, 5.73, 12.00, 34.65, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 5, 21.96, 121, 4.99, 13.66, 33.37, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 6, 4.60, 121, 1.94, 1.98, 10.36, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 7, 2.90, 121, 2.28, 0.60, 12.89, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'IM', NULL, 3.99, 120, 0.09, 3.81, 4.17, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'RT', NULL, 93.04, 128, 2.77, 85.14, 96.89, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 1, 0.32, 98, 0.33, 0.04, 2.41, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 2, 12.24, 98, 5.81, 4.55, 29.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 3, 17.70, 98, 4.64, 10.25, 28.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 4, 28.58, 98, 7.57, 16.08, 45.51, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 5, 23.24, 98, 5.50, 14.10, 35.84, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 6, 11.88, 98, 5.01, 4.95, 25.84, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 7, 6.04, 98, 3.26, 2.01, 16.72, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'IM', NULL, 3.81, 99, 0.16, 3.50, 4.12, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'RT', NULL, 79.30, 126, 5.68, 65.89, 88.37, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 1, 0.00, 115, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 2, 6.32, 115, 3.43, 2.10, 17.52, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 3, 18.93, 115, 6.17, 9.53, 34.11, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 4, 16.88, 115, 6.34, 7.66, 33.21, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 5, 48.11, 115, 7.48, 33.85, 62.67, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 6, 9.02, 115, 3.39, 4.19, 18.35, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 7, 0.75, 115, 0.51, 0.19, 2.87, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'IM', NULL, 3.69, 114, 0.21, 3.29, 4.10, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'RT', NULL, 83.39, 127, 4.96, 71.19, 91.07, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 1, 1.60, 107, 0.74, 0.64, 3.98, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 2, 19.42, 107, 6.76, 9.28, 36.21, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 3, 27.14, 107, 5.59, 17.53, 39.49, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 4, 22.15, 107, 7.90, 10.30, 41.36, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 5, 23.27, 107, 6.18, 13.25, 37.58, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 6, 4.14, 107, 2.51, 1.22, 13.12, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 7, 2.27, 107, 1.85, 0.45, 10.80, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'IM', NULL, 3.52, 108, 0.15, 3.22, 3.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'RT', NULL, 87.68, 126, 3.57, 78.72, 93.19, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 1, 12.95, 100, 5.41, 5.43, 27.82, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 2, 12.02, 100, 4.15, 5.91, 22.94, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 3, 37.31, 100, 8.45, 22.51, 54.94, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 4, 15.17, 100, 5.07, 7.57, 28.08, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 5, 22.19, 100, 6.32, 12.12, 37.08, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 6, 0.36, 100, 0.36, 0.05, 2.62, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 7, 0.00, 100, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'IM', NULL, 3.47, 100, 0.17, 3.14, 3.80, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'RT', NULL, 71.25, 127, 7.56, 54.43, 83.72, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'FT', 1, 4.42, 103, 3.37, 0.94, 18.34, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'FT', 2, 21.76, 103, 5.27, 13.09, 33.93, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'FT', 3, 29.05, 103, 6.14, 18.48, 42.50, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'FT', 4, 22.45, 103, 6.48, 12.15, 37.73, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'FT', 5, 17.73, 103, 4.27, 10.76, 27.79, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'FT', 6, 1.42, 103, 0.95, 0.37, 5.23, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'FT', 7, 3.18, 103, 2.97, 0.48, 18.20, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'IM', NULL, 3.39, 104, 0.12, 3.14, 3.63, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'RT', NULL, 74.41, 127, 6.05, 60.80, 84.50, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 1, 0.97, 99, 0.59, 0.29, 3.21, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 2, 20.53, 99, 7.25, 9.67, 38.41, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 3, 33.75, 99, 7.89, 20.18, 50.64, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 4, 14.59, 99, 6.17, 6.01, 31.34, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 5, 26.35, 99, 8.45, 13.10, 45.93, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 6, 3.03, 99, 2.58, 0.55, 15.13, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 7, 0.77, 99, 0.50, 0.21, 2.76, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'IM', NULL, 3.37, 100, 0.18, 3.02, 3.73, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'RT', NULL, 73.22, 128, 6.60, 58.41, 84.18, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 1, 15.85, 92, 5.39, 7.78, 29.59, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 2, 13.91, 92, 6.08, 5.56, 30.69, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 3, 35.43, 92, 6.30, 24.10, 48.68, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 4, 18.22, 92, 5.80, 9.33, 32.55, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 5, 9.06, 92, 4.47, 3.28, 22.62, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 6, 3.58, 92, 2.64, 0.81, 14.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 7, 3.95, 92, 3.24, 0.75, 18.31, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'IM', NULL, 3.36, 93, 0.23, 2.91, 3.81, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'RT', NULL, 69.34, 125, 8.07, 51.61, 82.74, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 1, 7.31, 98, 5.11, 1.74, 26.07, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 2, 11.40, 98, 4.29, 5.25, 23.00, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 3, 24.63, 98, 6.51, 14.00, 39.60, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 4, 25.78, 98, 6.88, 14.54, 41.49, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 5, 25.58, 98, 6.34, 15.08, 39.97, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 6, 5.29, 98, 3.53, 1.36, 18.42, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 7, 0.00, 98, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'IM', NULL, 3.75, 98, 0.19, 3.37, 4.12, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'RT', NULL, 66.92, 127, 7.47, 50.91, 79.78, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 1, 14.44, 47, 7.56, 4.69, 36.66, 'N', '2008-06-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 2, 31.67, 47, 11.17, 14.09, 56.70, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 3, 24.16, 47, 8.75, 10.86, 45.46, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 4, 7.78, 47, 6.82, 1.23, 36.38, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 5, 21.60, 47, 10.02, 7.72, 47.55, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 6, 0.36, 47, 0.37, 0.05, 2.76, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 7, 0.00, 47, 0.00, NULL, NULL, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'IM', NULL, 3.49, 49, 0.27, 2.95, 4.04, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'RT', NULL, 33.59, 125, 7.47, 20.68, 49.52, 'N', '2008-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 1, 0.00, 46, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 2, 0.00, 46, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 3, 1.38, 46, 1.42, 0.17, 10.21, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 4, 3.61, 46, 3.56, 0.47, 22.74, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 5, 46.31, 46, 7.16, 32.57, 60.63, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 6, 25.10, 46, 6.01, 14.96, 38.96, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 7, 23.60, 46, 5.53, 14.27, 36.43, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'IM', NULL, 4.36, 47, 0.09, 4.18, 4.53, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'RT', NULL, 90.22, 51, 5.99, 70.25, 97.30, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 1, 0.00, 47, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 2, 3.46, 47, 3.16, 0.53, 19.44, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 3, 8.48, 47, 4.47, 2.83, 22.79, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 4, 10.87, 47, 4.39, 4.67, 23.27, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 5, 44.01, 47, 5.69, 33.06, 55.58, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 6, 23.48, 47, 5.49, 14.23, 36.20, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 7, 9.70, 47, 6.28, 2.47, 31.28, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'IM', NULL, 4.34, 49, 0.08, 4.19, 4.50, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'RT', NULL, 98.67, 50, 1.36, 90.20, 99.83, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 1, 0.00, 47, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 2, 0.00, 47, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 3, 10.52, 47, 3.50, 5.27, 19.90, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 4, 14.68, 47, 6.09, 6.08, 31.40, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 5, 54.06, 47, 6.44, 41.12, 66.48, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 6, 19.34, 47, 4.54, 11.77, 30.12, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 7, 1.39, 47, 1.43, 0.17, 10.27, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'IM', NULL, 4.09, 48, 0.12, 3.84, 4.33, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'RT', NULL, 94.36, 51, 3.26, 83.04, 98.28, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 1, 2.25, 49, 2.23, 0.30, 15.05, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 2, 6.59, 49, 3.60, 2.13, 18.63, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 3, 19.99, 49, 7.79, 8.58, 39.95, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 4, 23.35, 49, 5.54, 14.06, 36.20, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 5, 35.25, 49, 8.35, 20.69, 53.19, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 6, 7.92, 49, 6.12, 1.57, 31.72, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 7, 4.64, 49, 3.06, 1.20, 16.37, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'IM', NULL, 4.01, 50, 0.17, 3.67, 4.36, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'RT', NULL, 98.70, 51, 1.33, 90.40, 99.84, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 1, 0.00, 45, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 2, 13.16, 45, 5.38, 5.54, 28.13, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 3, 2.84, 45, 2.08, 0.64, 11.79, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 4, 35.30, 45, 7.04, 22.67, 50.39, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 5, 34.40, 45, 7.47, 21.20, 50.55, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 6, 14.29, 45, 4.57, 7.29, 26.12, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 7, 0.00, 45, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'IM', NULL, 4.00, 46, 0.08, 3.84, 4.16, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'RT', NULL, 90.70, 51, 4.37, 77.51, 96.50, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 1, 3.60, 45, 3.28, 0.55, 20.09, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 2, 6.59, 45, 4.00, 1.87, 20.70, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 3, 9.93, 45, 5.47, 3.11, 27.45, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 4, 33.40, 45, 4.95, 24.26, 43.99, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 5, 30.35, 45, 7.31, 17.84, 46.66, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 6, 12.53, 45, 4.86, 5.54, 25.93, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 7, 3.60, 45, 3.13, 0.60, 18.72, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'IM', NULL, 3.95, 46, 0.11, 3.72, 4.17, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'RT', NULL, 90.54, 51, 4.75, 75.84, 96.69, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 1, 8.26, 45, 4.32, 2.78, 22.12, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 2, 18.27, 45, 6.20, 8.82, 34.05, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 3, 4.07, 45, 2.92, 0.93, 16.08, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 4, 26.57, 45, 6.53, 15.56, 41.52, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 5, 35.52, 45, 8.17, 21.17, 53.06, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 6, 1.93, 45, 1.89, 0.26, 12.84, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 7, 5.38, 45, 3.78, 1.26, 20.24, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'IM', NULL, 3.93, 46, 0.15, 3.63, 4.24, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'RT', NULL, 83.92, 52, 6.65, 66.00, 93.34, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 1, 28.13, 40, 8.13, 14.79, 46.88, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 2, 14.27, 40, 5.97, 5.84, 30.88, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 3, 24.27, 40, 5.08, 15.48, 35.92, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 4, 15.89, 40, 5.31, 7.80, 29.66, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 5, 17.45, 40, 10.92, 4.36, 49.49, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 6, 0.00, 40, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 7, 0.00, 40, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'IM', NULL, 3.91, 40, 0.16, 3.58, 4.24, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'RT', NULL, 80.04, 51, 5.17, 67.66, 88.49, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 1, 6.39, 44, 3.58, 2.00, 18.57, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 2, 7.68, 44, 4.34, 2.36, 22.23, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 3, 14.74, 44, 5.99, 6.20, 31.12, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 4, 26.59, 44, 7.81, 13.91, 44.80, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 5, 30.98, 44, 6.54, 19.49, 45.41, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 6, 9.83, 44, 3.73, 4.46, 20.30, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 7, 3.79, 44, 3.26, 0.65, 19.27, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'IM', NULL, 3.89, 45, 0.10, 3.69, 4.09, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'RT', NULL, 84.50, 52, 5.49, 70.16, 92.67, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 1, 3.75, 44, 3.70, 0.49, 23.52, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 2, 0.00, 44, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 3, 4.22, 44, 3.19, 0.89, 17.77, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 4, 16.77, 44, 7.11, 6.72, 36.01, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 5, 57.70, 44, 8.22, 40.88, 72.91, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 6, 10.76, 44, 4.65, 4.34, 24.25, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 7, 6.80, 44, 3.46, 2.37, 17.98, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'IM', NULL, 3.85, 45, 0.14, 3.57, 4.12, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'RT', NULL, 86.79, 51, 6.11, 69.26, 95.04, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 1, 0.00, 37, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 2, 12.64, 37, 5.26, 5.22, 27.55, 'N', '2011-07-01', 'Incumbent');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 3, 13.62, 37, 6.68, 4.75, 33.29, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 4, 4.79, 37, 3.53, 1.04, 19.46, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 5, 34.28, 37, 7.77, 20.58, 51.21, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 6, 16.48, 37, 6.45, 7.09, 33.80, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 7, 18.19, 37, 8.52, 6.50, 41.53, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'IM', NULL, 3.77, 38, 0.21, 3.36, 4.19, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'RT', NULL, 71.19, 51, 5.70, 58.56, 81.20, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 1, 0.00, 43, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 2, 21.47, 43, 5.93, 11.85, 35.75, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 3, 25.63, 43, 7.55, 13.42, 43.40, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 4, 33.03, 43, 6.64, 21.20, 47.48, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 5, 10.77, 43, 4.12, 4.84, 22.29, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 6, 9.09, 43, 6.46, 2.03, 32.61, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 7, 0.00, 43, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'IM', NULL, 3.77, 43, 0.15, 3.46, 4.09, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'RT', NULL, 86.33, 51, 5.57, 70.98, 94.23, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 1, 0.00, 46, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 2, 26.16, 46, 5.16, 17.13, 37.77, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 3, 24.22, 46, 6.07, 14.11, 38.35, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 4, 18.88, 46, 5.39, 10.28, 32.11, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 5, 25.79, 46, 5.29, 16.61, 37.75, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 6, 0.00, 46, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 7, 4.95, 46, 3.35, 1.23, 17.92, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'IM', NULL, 3.67, 47, 0.14, 3.38, 3.96, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'RT', NULL, 92.69, 51, 3.67, 81.04, 97.41, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 1, 9.74, 30, 5.36, 3.01, 27.29, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 2, 46.57, 30, 8.70, 29.89, 64.06, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 3, 28.62, 30, 7.71, 15.64, 46.45, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 4, 9.93, 30, 6.09, 2.66, 30.76, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 5, 5.14, 30, 3.44, 1.26, 18.65, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 6, 0.00, 30, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 7, 0.00, 30, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'IM', NULL, 4.29, 31, 0.10, 4.08, 4.51, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'RT', NULL, 55.79, 52, 6.70, 42.24, 68.53, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 1, 43.71, 16, 12.83, 20.35, 70.24, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 2, 32.01, 16, 9.40, 15.79, 54.16, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 3, 9.41, 16, 6.72, 1.90, 35.79, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 4, 14.88, 16, 9.30, 3.52, 45.55, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 5, 0.00, 16, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 6, 0.00, 16, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 7, 0.00, 16, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'IM', NULL, 4.16, 17, 0.23, 3.67, 4.66, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'RT', NULL, 31.92, 50, 5.99, 21.22, 44.94, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 1, 33.28, 25, 10.32, 16.05, 56.55, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 2, 33.93, 25, 8.00, 19.73, 51.74, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 3, 30.33, 25, 9.73, 14.40, 52.97, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 4, 0.00, 25, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 5, 2.47, 25, 2.51, 0.29, 17.86, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 6, 0.00, 25, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 7, 0.00, 25, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'IM', NULL, 3.92, 26, 0.21, 3.49, 4.36, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'RT', NULL, 50.34, 52, 6.74, 37.10, 63.53, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 1, 13.35, 33, 7.77, 3.77, 37.70, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 2, 20.56, 33, 5.64, 11.35, 34.35, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 3, 26.92, 33, 9.80, 11.78, 50.39, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 4, 9.64, 33, 4.95, 3.24, 25.36, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 5, 17.42, 33, 8.27, 6.14, 40.48, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 6, 7.13, 33, 5.51, 1.39, 29.51, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 7, 4.99, 33, 4.19, 0.86, 24.13, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'IM', NULL, 3.46, 34, 0.22, 3.02, 3.90, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'RT', NULL, 65.57, 51, 7.40, 49.64, 78.62, 'N', '2011-07-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 2, 27.27, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 3, 45.45, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 4, 13.64, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 5, 13.64, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'IM', NULL, 4.55, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'RT', NULL, 91.67, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 2, 4.35, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 3, 4.35, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 4, 8.70, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 5, 43.48, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 6, 17.39, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 7, 21.74, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'IM', NULL, 4.35, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'RT', NULL, 95.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 1, 30.43, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 2, 52.17, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 3, 13.04, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 4, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'IM', NULL, 4.26, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'RT', NULL, 95.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 2, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 3, 29.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 4, 37.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 5, 25.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'IM', NULL, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 2, 8.70, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 3, 4.35, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 4, 8.70, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 5, 39.13, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 6, 30.43, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 7, 8.70, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'IM', NULL, 4.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'RT', NULL, 95.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 1, 12.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 2, 50.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 3, 29.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 4, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 5, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'IM', NULL, 3.96, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 3, 20.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 4, 10.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 5, 45.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 6, 20.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 7, 5.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'IM', NULL, 3.90, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'RT', NULL, 83.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 2, 20.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 3, 29.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 4, 33.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 5, 12.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 6, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'IM', NULL, 3.79, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 2, 20.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 3, 45.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 4, 20.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 5, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 6, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'IM', NULL, 3.79, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 1, 8.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 2, 29.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 3, 37.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 4, 25.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'IM', NULL, 3.67, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 1, 12.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 2, 20.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 3, 45.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 4, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 5, 12.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 6, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'IM', NULL, 3.62, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 1, 4.35, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 2, 21.74, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 3, 34.78, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 4, 26.09, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 6, 8.70, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'IM', NULL, 3.61, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'RT', NULL, 95.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 2, 17.39, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 3, 52.17, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 4, 13.04, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 5, 17.39, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'IM', NULL, 3.48, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'RT', NULL, 95.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 1, 10.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 2, 5.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 3, 15.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 4, 20.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 5, 35.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 6, 5.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 7, 10.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'IM', NULL, 3.40, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'RT', NULL, 83.33, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 1, 4.35, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 2, 30.43, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 3, 47.83, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 4, 13.04, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'IM', NULL, 3.39, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'RT', NULL, 95.83, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 1, 18.75, 16, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 2, 43.75, 16, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 3, 12.50, 16, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 4, 12.50, 16, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 5, 12.50, 16, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 6, 0.00, 16, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 7, 0.00, 16, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'IM', NULL, 3.81, 16, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'RT', NULL, 66.67, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 1, 12.50, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 2, 79.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 3, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 4, 4.17, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'IM', NULL, 2.75, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'FT', 2, 17.39, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'FT', 3, 39.13, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'FT', 4, 34.78, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'FT', 5, 8.70, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'IM', NULL, 4.22, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1053, 'FT', 1, 30.43, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1053, 'FT', 2, 47.83, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1053, 'FT', 3, 8.70, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1053, 'FT', 4, 8.70, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1053, 'FT', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1053, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1053, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1053, 'IM', NULL, 4.17, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1053, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'FT', 2, 8.70, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'FT', 3, 17.39, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'FT', 4, 34.78, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'FT', 5, 21.74, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'FT', 6, 17.39, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'IM', NULL, 4.09, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1051, 'FT', 1, 15.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1051, 'FT', 2, 55.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1051, 'FT', 3, 20.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1051, 'FT', 4, 5.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1051, 'FT', 5, 5.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1051, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1051, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1051, 'IM', NULL, 3.90, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1051, 'RT', NULL, 86.96, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1042, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1042, 'FT', 2, 21.74, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1042, 'FT', 3, 43.48, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1042, 'FT', 4, 21.74, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1042, 'FT', 5, 8.70, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1042, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1042, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1042, 'IM', NULL, 3.87, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1042, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'FT', 2, 8.70, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'FT', 3, 47.83, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'FT', 4, 39.13, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'FT', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'IM', NULL, 3.87, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1052, 'FT', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1052, 'FT', 2, 19.05, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1052, 'FT', 3, 47.62, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1052, 'FT', 4, 9.52, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1052, 'FT', 5, 23.81, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1052, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1052, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1052, 'IM', NULL, 3.86, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1052, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'FT', 1, 10.53, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'FT', 2, 42.11, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'FT', 3, 36.84, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'FT', 4, 10.53, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'FT', 5, 0.00, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'IM', NULL, 3.79, 19, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'RT', NULL, 82.61, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'FT', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'FT', 2, 13.64, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'FT', 3, 22.73, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'FT', 4, 31.82, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'FT', 5, 27.27, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'FT', 6, 4.55, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'IM', NULL, 3.77, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'RT', NULL, 95.65, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1059, 'FT', 1, 4.76, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1059, 'FT', 2, 38.10, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1059, 'FT', 3, 33.33, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1059, 'FT', 4, 4.76, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1059, 'FT', 5, 14.29, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1059, 'FT', 6, 4.76, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1059, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1059, 'IM', NULL, 3.76, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1059, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1054, 'FT', 1, 25.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1054, 'FT', 2, 55.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1054, 'FT', 3, 15.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1054, 'FT', 4, 5.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1054, 'FT', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1054, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1054, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1054, 'IM', NULL, 3.75, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1054, 'RT', NULL, 86.96, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1043, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1043, 'FT', 2, 17.39, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1043, 'FT', 3, 30.43, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1043, 'FT', 4, 21.74, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1043, 'FT', 5, 26.09, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1043, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1043, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1043, 'IM', NULL, 3.70, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1043, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'FT', 1, 4.76, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'FT', 2, 4.76, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'FT', 3, 14.29, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'FT', 4, 23.81, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'FT', 5, 28.57, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'FT', 6, 19.05, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'FT', 7, 4.76, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'IM', NULL, 3.67, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1047, 'FT', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1047, 'FT', 2, 20.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1047, 'FT', 3, 20.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1047, 'FT', 4, 30.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1047, 'FT', 5, 30.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1047, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1047, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1047, 'IM', NULL, 3.55, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1047, 'RT', NULL, 86.96, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1056, 'FT', 1, 5.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1056, 'FT', 2, 75.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1056, 'FT', 3, 20.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1056, 'FT', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1056, 'FT', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1056, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1056, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1056, 'IM', NULL, 3.50, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1056, 'RT', NULL, 86.96, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'FT', 1, 4.76, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'FT', 2, 47.62, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'FT', 3, 42.86, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'FT', 4, 4.76, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'FT', 5, 0.00, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'IM', NULL, 3.45, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1041, 'FT', 1, 9.09, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1041, 'FT', 2, 63.64, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1041, 'FT', 3, 22.73, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1041, 'FT', 4, 4.55, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1041, 'FT', 5, 0.00, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1041, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1041, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1041, 'IM', NULL, 3.35, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1041, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'FT', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'FT', 2, 5.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'FT', 3, 15.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'FT', 4, 40.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'FT', 5, 30.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'FT', 6, 10.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'IM', NULL, 3.30, 20, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'RT', NULL, 86.96, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1049, 'FT', 1, 70.00, 10, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1049, 'FT', 2, 30.00, 10, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1049, 'FT', 3, 0.00, 10, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1049, 'FT', 4, 0.00, 10, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1049, 'FT', 5, 0.00, 10, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1049, 'FT', 6, 0.00, 10, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1049, 'FT', 7, 0.00, 10, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1049, 'IM', NULL, 4.00, 9, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1049, 'RT', NULL, 43.48, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1057, 'FT', 1, 37.50, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1057, 'FT', 2, 50.00, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1057, 'FT', 3, 12.50, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1057, 'FT', 4, 0.00, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1057, 'FT', 5, 0.00, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1057, 'FT', 6, 0.00, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1057, 'FT', 7, 0.00, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1057, 'IM', NULL, 3.75, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1057, 'RT', NULL, 34.78, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1048, 'FT', 1, 0.00, 11, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1048, 'FT', 2, 18.18, 11, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1048, 'FT', 3, 27.27, 11, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1048, 'FT', 4, 36.36, 11, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1048, 'FT', 5, 18.18, 11, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1048, 'FT', 6, 0.00, 11, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1048, 'FT', 7, 0.00, 11, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1048, 'IM', NULL, 3.64, 11, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1048, 'RT', NULL, 47.83, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1045, 'FT', 1, 37.50, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1045, 'FT', 2, 62.50, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1045, 'FT', 3, 0.00, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1045, 'FT', 4, 0.00, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1045, 'FT', 5, 0.00, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1045, 'FT', 6, 0.00, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1045, 'FT', 7, 0.00, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1045, 'IM', NULL, 3.25, 8, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1045, 'RT', NULL, 34.78, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1058, 'FT', 1, 40.00, 5, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1058, 'FT', 2, 20.00, 5, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1058, 'FT', 3, 0.00, 5, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1058, 'FT', 4, 40.00, 5, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1058, 'FT', 5, 0.00, 5, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1058, 'FT', 6, 0.00, 5, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1058, 'FT', 7, 0.00, 5, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1058, 'IM', NULL, 2.80, 5, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1058, 'RT', NULL, 21.74, 23, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3304, 'FT', 1, 13.64, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3304, 'FT', 2, 27.27, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3304, 'FT', 3, 45.45, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3304, 'FT', 4, 9.09, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3304, 'FT', 5, 4.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3304, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3304, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3304, 'IM', NULL, 4.22, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3304, 'RT', NULL, 95.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3291, 'FT', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3291, 'FT', 2, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3291, 'FT', 3, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3291, 'FT', 4, 16.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3291, 'FT', 5, 25.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3291, 'FT', 6, 25.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3291, 'FT', 7, 20.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3291, 'IM', NULL, 4.13, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3291, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3295, 'FT', 1, 17.39, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3295, 'FT', 2, 56.52, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3295, 'FT', 3, 13.04, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3295, 'FT', 4, 4.35, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3295, 'FT', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3295, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3295, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3295, 'IM', NULL, 4.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3295, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3292, 'FT', 1, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3292, 'FT', 2, 42.86, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3292, 'FT', 3, 33.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3292, 'FT', 4, 9.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3292, 'FT', 5, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3292, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3292, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3292, 'IM', NULL, 3.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3292, 'RT', NULL, 91.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3305, 'FT', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3305, 'FT', 2, 31.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3305, 'FT', 3, 22.73, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3305, 'FT', 4, 18.18, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3305, 'FT', 5, 13.64, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3305, 'FT', 6, 13.64, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3305, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3305, 'IM', NULL, 3.70, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3305, 'RT', NULL, 95.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3302, 'FT', 1, 5.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3302, 'FT', 2, 15.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3302, 'FT', 3, 20.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3302, 'FT', 4, 5.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3302, 'FT', 5, 30.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3302, 'FT', 6, 15.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3302, 'FT', 7, 10.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3302, 'IM', NULL, 3.67, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3302, 'RT', NULL, 87.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3296, 'FT', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3296, 'FT', 2, 5.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3296, 'FT', 3, 30.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3296, 'FT', 4, 10.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3296, 'FT', 5, 50.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3296, 'FT', 6, 5.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3296, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3296, 'IM', NULL, 3.62, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3296, 'RT', NULL, 87.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3293, 'FT', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3293, 'FT', 2, 10.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3293, 'FT', 3, 20.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3293, 'FT', 4, 35.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3293, 'FT', 5, 35.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3293, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3293, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3293, 'IM', NULL, 3.62, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3293, 'RT', NULL, 87.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3298, 'FT', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3298, 'FT', 2, 22.73, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3298, 'FT', 3, 31.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3298, 'FT', 4, 13.64, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3298, 'FT', 5, 31.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3298, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3298, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3298, 'IM', NULL, 3.57, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3298, 'RT', NULL, 91.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3294, 'FT', 1, 5.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3294, 'FT', 2, 5.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3294, 'FT', 3, 27.78, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3294, 'FT', 4, 5.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3294, 'FT', 5, 44.44, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3294, 'FT', 6, 11.11, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3294, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3294, 'IM', NULL, 3.53, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3294, 'RT', NULL, 79.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3297, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3297, 'FT', 2, 17.39, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3297, 'FT', 3, 34.78, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3297, 'FT', 4, 21.74, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3297, 'FT', 5, 17.39, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3297, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3297, 'FT', 7, 4.35, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3297, 'IM', NULL, 3.46, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3297, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3299, 'FT', 1, 26.09, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3299, 'FT', 2, 43.48, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3299, 'FT', 3, 26.09, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3299, 'FT', 4, 4.35, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3299, 'FT', 5, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3299, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3299, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3299, 'IM', NULL, 3.42, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3299, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3312, 'FT', 1, 38.10, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3312, 'FT', 2, 47.62, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3312, 'FT', 3, 9.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3312, 'FT', 4, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3312, 'FT', 5, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3312, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3312, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3312, 'IM', NULL, 3.36, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3312, 'RT', NULL, 91.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3310, 'FT', 1, 5.88, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3310, 'FT', 2, 29.41, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3310, 'FT', 3, 11.76, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3310, 'FT', 4, 35.29, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3310, 'FT', 5, 17.65, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3310, 'FT', 6, 0.00, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3310, 'FT', 7, 0.00, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3310, 'IM', NULL, 3.17, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3310, 'RT', NULL, 75.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3301, 'FT', 1, 13.33, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3301, 'FT', 2, 73.33, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3301, 'FT', 3, 0.00, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3301, 'FT', 4, 13.33, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3301, 'FT', 5, 0.00, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3301, 'FT', 6, 0.00, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3301, 'FT', 7, 0.00, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3301, 'IM', NULL, 3.47, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3301, 'RT', NULL, 62.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3306, 'FT', 1, 23.08, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3306, 'FT', 2, 15.38, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3306, 'FT', 3, 23.08, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3306, 'FT', 4, 7.69, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3306, 'FT', 5, 30.77, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3306, 'FT', 6, 0.00, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3306, 'FT', 7, 0.00, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3306, 'IM', NULL, 3.43, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3306, 'RT', NULL, 58.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3308, 'FT', 1, 6.25, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3308, 'FT', 2, 25.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3308, 'FT', 3, 25.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3308, 'FT', 4, 18.75, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3308, 'FT', 5, 25.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3308, 'FT', 6, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3308, 'FT', 7, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3308, 'IM', NULL, 3.38, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3308, 'RT', NULL, 66.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3307, 'FT', 1, 0.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3307, 'FT', 2, 8.33, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3307, 'FT', 3, 41.67, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3307, 'FT', 4, 16.67, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3307, 'FT', 5, 33.33, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3307, 'FT', 6, 0.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3307, 'FT', 7, 0.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3307, 'IM', NULL, 3.33, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3307, 'RT', NULL, 50.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3303, 'FT', 1, 8.33, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3303, 'FT', 2, 33.33, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3303, 'FT', 3, 25.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3303, 'FT', 4, 8.33, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3303, 'FT', 5, 16.67, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3303, 'FT', 6, 8.33, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3303, 'FT', 7, 0.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3303, 'IM', NULL, 3.15, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3303, 'RT', NULL, 54.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3313, 'FT', 1, 64.29, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3313, 'FT', 2, 28.57, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3313, 'FT', 3, 7.14, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3313, 'FT', 4, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3313, 'FT', 5, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3313, 'FT', 6, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3313, 'FT', 7, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3313, 'IM', NULL, 2.93, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3313, 'RT', NULL, 62.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3309, 'FT', 1, 46.67, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3309, 'FT', 2, 40.00, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3309, 'FT', 3, 0.00, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3309, 'FT', 4, 13.33, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3309, 'FT', 5, 0.00, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3309, 'FT', 6, 0.00, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3309, 'FT', 7, 0.00, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3309, 'IM', NULL, 2.93, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3309, 'RT', NULL, 66.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3300, 'FT', 1, 12.50, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3300, 'FT', 2, 37.50, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3300, 'FT', 3, 18.75, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3300, 'FT', 4, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3300, 'FT', 5, 31.25, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3300, 'FT', 6, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3300, 'FT', 7, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3300, 'IM', NULL, 2.82, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3300, 'RT', NULL, 70.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3311, 'FT', 1, 65.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3311, 'FT', 2, 30.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3311, 'FT', 3, 5.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3311, 'FT', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3311, 'FT', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3311, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3311, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3311, 'IM', NULL, 2.57, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', 3311, 'RT', NULL, 87.50, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15740, 'FT', 1, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15740, 'FT', 2, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15740, 'FT', 3, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15740, 'FT', 4, 17.39, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15740, 'FT', 5, 34.78, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15740, 'FT', 6, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15740, 'FT', 7, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15740, 'IM', NULL, 4.26, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15740, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15752, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15752, 'FT', 2, 26.09, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15752, 'FT', 3, 8.70, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15752, 'FT', 4, 26.09, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15752, 'FT', 5, 17.39, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15752, 'FT', 6, 21.74, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15752, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15752, 'IM', NULL, 3.96, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15752, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15737, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15737, 'FT', 2, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15737, 'FT', 3, 34.78, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15737, 'FT', 4, 30.43, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15737, 'FT', 5, 26.09, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15737, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15737, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15737, 'IM', NULL, 3.96, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15737, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15754, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15754, 'FT', 2, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15754, 'FT', 3, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15754, 'FT', 4, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15754, 'FT', 5, 47.83, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15754, 'FT', 6, 26.09, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15754, 'FT', 7, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15754, 'IM', NULL, 3.91, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15754, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15756, 'FT', 1, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15756, 'FT', 2, 8.70, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15756, 'FT', 3, 21.74, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15756, 'FT', 4, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15756, 'FT', 5, 39.13, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15756, 'FT', 6, 21.74, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15756, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15756, 'IM', NULL, 3.91, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15756, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19987, 'FT', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19987, 'FT', 2, 13.64, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19987, 'FT', 3, 18.18, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19987, 'FT', 4, 9.09, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19987, 'FT', 5, 50.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19987, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19987, 'FT', 7, 9.09, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19987, 'IM', NULL, 3.86, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19987, 'RT', NULL, 95.65, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19988, 'FT', 1, 8.70, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19988, 'FT', 2, 30.43, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19988, 'FT', 3, 43.48, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19988, 'FT', 4, 8.70, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19988, 'FT', 5, 8.70, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19988, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19988, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19988, 'IM', NULL, 3.74, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19988, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15749, 'FT', 1, 9.52, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15749, 'FT', 2, 14.29, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15749, 'FT', 3, 23.81, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15749, 'FT', 4, 14.29, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15749, 'FT', 5, 23.81, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15749, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15749, 'FT', 7, 14.29, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15749, 'IM', NULL, 3.71, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15749, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15745, 'FT', 1, 35.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15745, 'FT', 2, 40.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15745, 'FT', 3, 20.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15745, 'FT', 4, 5.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15745, 'FT', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15745, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15745, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15745, 'IM', NULL, 3.70, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15745, 'RT', NULL, 86.96, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15753, 'FT', 1, 26.09, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15753, 'FT', 2, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15753, 'FT', 3, 30.43, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15753, 'FT', 4, 26.09, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15753, 'FT', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15753, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15753, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15753, 'IM', NULL, 3.70, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15753, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15743, 'FT', 1, 22.73, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15743, 'FT', 2, 13.64, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15743, 'FT', 3, 18.18, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15743, 'FT', 4, 18.18, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15743, 'FT', 5, 22.73, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15743, 'FT', 6, 4.55, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15743, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15743, 'IM', NULL, 3.68, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15743, 'RT', NULL, 95.65, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15746, 'FT', 1, 9.52, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15746, 'FT', 2, 23.81, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15746, 'FT', 3, 33.33, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15746, 'FT', 4, 14.29, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15746, 'FT', 5, 14.29, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15746, 'FT', 6, 4.76, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15746, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15746, 'IM', NULL, 3.62, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15746, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15744, 'FT', 1, 25.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15744, 'FT', 2, 45.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15744, 'FT', 3, 20.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15744, 'FT', 4, 5.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15744, 'FT', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15744, 'FT', 6, 5.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15744, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15744, 'IM', NULL, 3.60, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15744, 'RT', NULL, 86.96, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15741, 'FT', 1, 28.57, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15741, 'FT', 2, 38.10, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15741, 'FT', 3, 33.33, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15741, 'FT', 4, 0.00, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15741, 'FT', 5, 0.00, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15741, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15741, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15741, 'IM', NULL, 3.57, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15741, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15742, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15742, 'FT', 2, 39.13, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15742, 'FT', 3, 43.48, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15742, 'FT', 4, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15742, 'FT', 5, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15742, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15742, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15742, 'IM', NULL, 3.57, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15742, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15755, 'FT', 1, 33.33, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15755, 'FT', 2, 19.05, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15755, 'FT', 3, 14.29, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15755, 'FT', 4, 14.29, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15755, 'FT', 5, 14.29, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15755, 'FT', 6, 4.76, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15755, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15755, 'IM', NULL, 3.52, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15755, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15757, 'FT', 1, 19.05, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15757, 'FT', 2, 33.33, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15757, 'FT', 3, 23.81, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15757, 'FT', 4, 14.29, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15757, 'FT', 5, 9.52, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15757, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15757, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15757, 'IM', NULL, 3.52, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15757, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15751, 'FT', 1, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15751, 'FT', 2, 39.13, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15751, 'FT', 3, 47.83, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15751, 'FT', 4, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15751, 'FT', 5, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15751, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15751, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15751, 'IM', NULL, 3.52, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15751, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19989, 'FT', 1, 9.09, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19989, 'FT', 2, 4.55, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19989, 'FT', 3, 31.82, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19989, 'FT', 4, 22.73, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19989, 'FT', 5, 18.18, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19989, 'FT', 6, 13.64, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19989, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19989, 'IM', NULL, 3.50, 22, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19989, 'RT', NULL, 95.65, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15747, 'FT', 1, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15747, 'FT', 2, 21.74, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15747, 'FT', 3, 30.43, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15747, 'FT', 4, 17.39, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15747, 'FT', 5, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15747, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15747, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15747, 'IM', NULL, 3.48, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15747, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15739, 'FT', 1, 21.74, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15739, 'FT', 2, 21.74, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15739, 'FT', 3, 34.78, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15739, 'FT', 4, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15739, 'FT', 5, 13.04, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15739, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15739, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15739, 'IM', NULL, 3.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15739, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15748, 'FT', 1, 19.05, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15748, 'FT', 2, 14.29, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15748, 'FT', 3, 33.33, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15748, 'FT', 4, 14.29, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15748, 'FT', 5, 19.05, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15748, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15748, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15748, 'IM', NULL, 3.29, 21, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15748, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15736, 'FT', 1, 10.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15736, 'FT', 2, 65.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15736, 'FT', 3, 20.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15736, 'FT', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15736, 'FT', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15736, 'FT', 6, 5.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15736, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15736, 'IM', NULL, 3.05, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15736, 'RT', NULL, 86.96, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19990, 'FT', 1, 21.05, 19, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19990, 'FT', 2, 47.37, 19, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19990, 'FT', 3, 15.79, 19, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19990, 'FT', 4, 10.53, 19, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19990, 'FT', 5, 5.26, 19, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19990, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19990, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19990, 'IM', NULL, 3.00, 19, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19990, 'RT', NULL, 82.61, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19991, 'FT', 1, 58.33, 12, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19991, 'FT', 2, 25.00, 12, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19991, 'FT', 3, 16.67, 12, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19991, 'FT', 4, 0.00, 12, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19991, 'FT', 5, 0.00, 12, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19991, 'FT', 6, 0.00, 12, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19991, 'FT', 7, 0.00, 12, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19991, 'IM', NULL, 3.08, 12, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19991, 'RT', NULL, 52.17, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15750, 'FT', 1, 40.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15750, 'FT', 2, 40.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15750, 'FT', 3, 15.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15750, 'FT', 4, 5.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15750, 'FT', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15750, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15750, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15750, 'IM', NULL, 2.80, 20, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15750, 'RT', NULL, 86.96, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15738, 'FT', 1, 60.87, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15738, 'FT', 2, 26.09, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15738, 'FT', 3, 8.70, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15738, 'FT', 4, 4.35, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15738, 'FT', 5, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15738, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15738, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15738, 'IM', NULL, 2.78, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 15738, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19992, 'FT', 1, 47.06, 17, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19992, 'FT', 2, 23.53, 17, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19992, 'FT', 3, 29.41, 17, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19992, 'FT', 4, 0.00, 17, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19992, 'FT', 5, 0.00, 17, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19992, 'FT', 6, 0.00, 17, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19992, 'FT', 7, 0.00, 17, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19992, 'IM', NULL, 2.65, 17, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19992, 'RT', NULL, 73.91, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19993, 'FT', 1, 50.00, 14, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19993, 'FT', 2, 35.71, 14, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19993, 'FT', 3, 14.29, 14, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19993, 'FT', 4, 0.00, 14, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19993, 'FT', 5, 0.00, 14, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19993, 'FT', 6, 0.00, 14, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19993, 'FT', 7, 0.00, 14, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19993, 'IM', NULL, 2.64, 14, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19993, 'RT', NULL, 60.87, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19994, 'FT', 1, 73.33, 15, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19994, 'FT', 2, 20.00, 15, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19994, 'FT', 3, 6.67, 15, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19994, 'FT', 4, 0.00, 15, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19994, 'FT', 5, 0.00, 15, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19994, 'FT', 6, 0.00, 15, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19994, 'FT', 7, 0.00, 15, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19994, 'IM', NULL, 2.40, 15, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.03', 19994, 'RT', NULL, 65.22, 23, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3272, 'FT', 1, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3272, 'FT', 2, 50.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3272, 'FT', 3, 38.89, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3272, 'FT', 4, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3272, 'FT', 5, 11.11, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3272, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3272, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3272, 'IM', NULL, 4.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3272, 'RT', NULL, 85.71, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3273, 'FT', 1, 15.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3273, 'FT', 2, 15.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3273, 'FT', 3, 30.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3273, 'FT', 4, 30.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3273, 'FT', 5, 10.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3273, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3273, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3273, 'IM', NULL, 4.55, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3273, 'RT', NULL, 95.24, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3276, 'FT', 1, 22.22, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3276, 'FT', 2, 66.67, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3276, 'FT', 3, 11.11, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3276, 'FT', 4, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3276, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3276, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3276, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3276, 'IM', NULL, 4.33, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3276, 'RT', NULL, 85.71, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3267, 'FT', 1, 5.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3267, 'FT', 2, 45.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3267, 'FT', 3, 35.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3267, 'FT', 4, 10.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3267, 'FT', 5, 5.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3267, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3267, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3267, 'IM', NULL, 4.25, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3267, 'RT', NULL, 95.24, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3268, 'FT', 1, 6.25, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3268, 'FT', 2, 75.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3268, 'FT', 3, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3268, 'FT', 4, 6.25, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3268, 'FT', 5, 12.50, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3268, 'FT', 6, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3268, 'FT', 7, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3268, 'IM', NULL, 4.18, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3268, 'RT', NULL, 80.95, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3270, 'FT', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3270, 'FT', 2, 10.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3270, 'FT', 3, 5.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3270, 'FT', 4, 10.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3270, 'FT', 5, 60.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3270, 'FT', 6, 15.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3270, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3270, 'IM', NULL, 4.16, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3270, 'RT', NULL, 95.24, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3271, 'FT', 1, 11.11, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3271, 'FT', 2, 33.33, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3271, 'FT', 3, 38.89, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3271, 'FT', 4, 16.67, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3271, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3271, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3271, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3271, 'IM', NULL, 4.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3271, 'RT', NULL, 85.71, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3285, 'FT', 1, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3285, 'FT', 2, 63.16, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3285, 'FT', 3, 26.32, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3285, 'FT', 4, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3285, 'FT', 5, 10.53, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3285, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3285, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3285, 'IM', NULL, 4.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3285, 'RT', NULL, 90.48, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3283, 'FT', 1, 15.79, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3283, 'FT', 2, 26.32, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3283, 'FT', 3, 26.32, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3283, 'FT', 4, 26.32, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3283, 'FT', 5, 5.26, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3283, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3283, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3283, 'IM', NULL, 3.83, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3283, 'RT', NULL, 90.48, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3287, 'FT', 1, 58.82, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3287, 'FT', 2, 41.18, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3287, 'FT', 3, 0.00, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3287, 'FT', 4, 0.00, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3287, 'FT', 5, 0.00, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3287, 'FT', 6, 0.00, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3287, 'FT', 7, 0.00, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3287, 'IM', NULL, 3.76, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3287, 'RT', NULL, 80.95, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3274, 'FT', 1, 10.53, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3274, 'FT', 2, 68.42, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3274, 'FT', 3, 21.05, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3274, 'FT', 4, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3274, 'FT', 5, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3274, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3274, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3274, 'IM', NULL, 3.53, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3274, 'RT', NULL, 90.48, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3275, 'FT', 1, 0.00, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3275, 'FT', 2, 11.76, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3275, 'FT', 3, 23.53, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3275, 'FT', 4, 47.06, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3275, 'FT', 5, 11.76, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3275, 'FT', 6, 5.88, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3275, 'FT', 7, 0.00, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3275, 'IM', NULL, 3.41, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3275, 'RT', NULL, 80.95, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3279, 'FT', 1, 15.79, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3279, 'FT', 2, 52.63, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3279, 'FT', 3, 26.32, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3279, 'FT', 4, 5.26, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3279, 'FT', 5, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3279, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3279, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3279, 'IM', NULL, 3.32, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3279, 'RT', NULL, 90.48, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3290, 'FT', 1, 18.75, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3290, 'FT', 2, 50.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3290, 'FT', 3, 31.25, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3290, 'FT', 4, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3290, 'FT', 5, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3290, 'FT', 6, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3290, 'FT', 7, 0.00, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3290, 'IM', NULL, 3.25, 16, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3290, 'RT', NULL, 76.19, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3277, 'FT', 1, 6.67, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3277, 'FT', 2, 26.67, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3277, 'FT', 3, 46.67, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3277, 'FT', 4, 6.67, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3277, 'FT', 5, 6.67, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3277, 'FT', 6, 6.67, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3277, 'FT', 7, 0.00, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3277, 'IM', NULL, 3.13, 15, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3277, 'RT', NULL, 71.43, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3280, 'FT', 1, 80.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3280, 'FT', 2, 20.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3280, 'FT', 3, 0.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3280, 'FT', 4, 0.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3280, 'FT', 5, 0.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3280, 'FT', 6, 0.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3280, 'FT', 7, 0.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3280, 'IM', NULL, 4.40, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3280, 'RT', NULL, 23.81, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3286, 'FT', 1, 40.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3286, 'FT', 2, 0.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3286, 'FT', 3, 60.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3286, 'FT', 4, 0.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3286, 'FT', 5, 0.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3286, 'FT', 6, 0.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3286, 'FT', 7, 0.00, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3286, 'IM', NULL, 3.60, 5, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3286, 'RT', NULL, 23.81, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3269, 'FT', 1, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3269, 'FT', 2, 36.36, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3269, 'FT', 3, 54.55, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3269, 'FT', 4, 9.09, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3269, 'FT', 5, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3269, 'FT', 6, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3269, 'FT', 7, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3269, 'IM', NULL, 3.55, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3269, 'RT', NULL, 52.38, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3266, 'FT', 1, 54.55, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3266, 'FT', 2, 36.36, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3266, 'FT', 3, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3266, 'FT', 4, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3266, 'FT', 5, 9.09, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3266, 'FT', 6, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3266, 'FT', 7, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3266, 'IM', NULL, 3.45, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3266, 'RT', NULL, 52.38, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3281, 'FT', 1, 0.00, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3281, 'FT', 2, 30.00, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3281, 'FT', 3, 50.00, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3281, 'FT', 4, 10.00, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3281, 'FT', 5, 10.00, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3281, 'FT', 6, 0.00, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3281, 'FT', 7, 0.00, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3281, 'IM', NULL, 3.40, 10, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3281, 'RT', NULL, 47.62, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3288, 'FT', 1, 28.57, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3288, 'FT', 2, 71.43, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3288, 'FT', 3, 0.00, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3288, 'FT', 4, 0.00, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3288, 'FT', 5, 0.00, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3288, 'FT', 6, 0.00, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3288, 'FT', 7, 0.00, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3288, 'IM', NULL, 3.14, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3288, 'RT', NULL, 33.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3278, 'FT', 1, 8.33, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3278, 'FT', 2, 75.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3278, 'FT', 3, 8.33, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3278, 'FT', 4, 8.33, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3278, 'FT', 5, 0.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3278, 'FT', 6, 0.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3278, 'FT', 7, 0.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3278, 'IM', NULL, 3.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3278, 'RT', NULL, 57.14, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3282, 'FT', 1, 63.64, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3282, 'FT', 2, 36.36, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3282, 'FT', 3, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3282, 'FT', 4, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3282, 'FT', 5, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3282, 'FT', 6, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3282, 'FT', 7, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3282, 'IM', NULL, 2.82, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3282, 'RT', NULL, 52.38, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3289, 'FT', 1, 57.14, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3289, 'FT', 2, 42.86, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3289, 'FT', 3, 0.00, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3289, 'FT', 4, 0.00, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3289, 'FT', 5, 0.00, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3289, 'FT', 6, 0.00, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3289, 'FT', 7, 0.00, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3289, 'IM', NULL, 2.71, 7, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', 3289, 'RT', NULL, 33.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 990, 'FT', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 990, 'FT', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 990, 'FT', 3, 22.73, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 990, 'FT', 4, 18.18, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 990, 'FT', 5, 27.27, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 990, 'FT', 6, 31.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 990, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 990, 'IM', NULL, 4.36, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 990, 'RT', NULL, 100.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 988, 'FT', 1, 33.33, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 988, 'FT', 2, 38.89, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 988, 'FT', 3, 16.67, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 988, 'FT', 4, 11.11, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 988, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 988, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 988, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 988, 'IM', NULL, 4.28, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 988, 'RT', NULL, 81.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 987, 'FT', 1, 4.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 987, 'FT', 2, 18.18, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 987, 'FT', 3, 22.73, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 987, 'FT', 4, 22.73, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 987, 'FT', 5, 27.27, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 987, 'FT', 6, 4.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 987, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 987, 'IM', NULL, 4.23, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 987, 'RT', NULL, 100.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 986, 'FT', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 986, 'FT', 2, 13.64, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 986, 'FT', 3, 22.73, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 986, 'FT', 4, 50.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 986, 'FT', 5, 13.64, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 986, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 986, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 986, 'IM', NULL, 4.18, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 986, 'RT', NULL, 100.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 989, 'FT', 1, 5.26, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 989, 'FT', 2, 26.32, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 989, 'FT', 3, 52.63, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 989, 'FT', 4, 10.53, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 989, 'FT', 5, 5.26, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 989, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 989, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 989, 'IM', NULL, 4.16, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 989, 'RT', NULL, 86.36, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 983, 'FT', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 983, 'FT', 2, 23.81, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 983, 'FT', 3, 52.38, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 983, 'FT', 4, 19.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 983, 'FT', 5, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 983, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 983, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 983, 'IM', NULL, 4.10, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 983, 'RT', NULL, 95.45, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 991, 'FT', 1, 5.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 991, 'FT', 2, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 991, 'FT', 3, 5.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 991, 'FT', 4, 11.11, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 991, 'FT', 5, 55.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 991, 'FT', 6, 22.22, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 991, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 991, 'IM', NULL, 4.05, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 991, 'RT', NULL, 86.36, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 995, 'FT', 1, 5.26, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 995, 'FT', 2, 15.79, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 995, 'FT', 3, 31.58, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 995, 'FT', 4, 26.32, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 995, 'FT', 5, 15.79, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 995, 'FT', 6, 5.26, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 995, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 995, 'IM', NULL, 4.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 995, 'RT', NULL, 90.91, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 998, 'FT', 1, 36.84, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 998, 'FT', 2, 47.37, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 998, 'FT', 3, 10.53, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 998, 'FT', 4, 5.26, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 998, 'FT', 5, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 998, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 998, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 998, 'IM', NULL, 3.95, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 998, 'RT', NULL, 86.36, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 982, 'FT', 1, 13.64, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 982, 'FT', 2, 13.64, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 982, 'FT', 3, 40.91, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 982, 'FT', 4, 13.64, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 982, 'FT', 5, 18.18, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 982, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 982, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 982, 'IM', NULL, 3.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 982, 'RT', NULL, 100.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 985, 'FT', 1, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 985, 'FT', 2, 38.10, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 985, 'FT', 3, 19.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 985, 'FT', 4, 9.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 985, 'FT', 5, 28.57, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 985, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 985, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 985, 'IM', NULL, 3.68, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 985, 'RT', NULL, 100.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 994, 'FT', 1, 15.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 994, 'FT', 2, 40.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 994, 'FT', 3, 30.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 994, 'FT', 4, 10.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 994, 'FT', 5, 5.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 994, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 994, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 994, 'IM', NULL, 3.65, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 994, 'RT', NULL, 90.91, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1001, 'FT', 1, 33.33, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1001, 'FT', 2, 27.78, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1001, 'FT', 3, 22.22, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1001, 'FT', 4, 5.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1001, 'FT', 5, 5.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1001, 'FT', 6, 5.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1001, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1001, 'IM', NULL, 3.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1001, 'RT', NULL, 81.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 993, 'FT', 1, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 993, 'FT', 2, 47.62, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 993, 'FT', 3, 23.81, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 993, 'FT', 4, 9.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 993, 'FT', 5, 9.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 993, 'FT', 6, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 993, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 993, 'IM', NULL, 3.52, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 993, 'RT', NULL, 95.45, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 992, 'FT', 1, 22.22, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 992, 'FT', 2, 55.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 992, 'FT', 3, 16.67, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 992, 'FT', 4, 5.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 992, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 992, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 992, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 992, 'IM', NULL, 3.50, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 992, 'RT', NULL, 81.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 996, 'FT', 1, 10.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 996, 'FT', 2, 40.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 996, 'FT', 3, 45.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 996, 'FT', 4, 5.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 996, 'FT', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 996, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 996, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 996, 'IM', NULL, 3.50, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 996, 'RT', NULL, 90.91, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1003, 'FT', 1, 47.62, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1003, 'FT', 2, 19.05, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1003, 'FT', 3, 23.81, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1003, 'FT', 4, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1003, 'FT', 5, 4.76, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1003, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1003, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1003, 'IM', NULL, 3.48, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1003, 'RT', NULL, 95.45, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1000, 'FT', 1, 27.78, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1000, 'FT', 2, 61.11, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1000, 'FT', 3, 5.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1000, 'FT', 4, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1000, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1000, 'FT', 6, 5.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1000, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1000, 'IM', NULL, 3.47, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1000, 'RT', NULL, 86.36, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1004, 'FT', 1, 11.11, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1004, 'FT', 2, 27.78, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1004, 'FT', 3, 27.78, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1004, 'FT', 4, 33.33, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1004, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1004, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1004, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1004, 'IM', NULL, 3.33, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1004, 'RT', NULL, 81.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 984, 'FT', 1, 15.79, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 984, 'FT', 2, 36.84, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 984, 'FT', 3, 31.58, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 984, 'FT', 4, 10.53, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 984, 'FT', 5, 5.26, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 984, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 984, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 984, 'IM', NULL, 3.16, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 984, 'RT', NULL, 86.36, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1005, 'FT', 1, 36.84, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1005, 'FT', 2, 42.11, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1005, 'FT', 3, 15.79, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1005, 'FT', 4, 5.26, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1005, 'FT', 5, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1005, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1005, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1005, 'IM', NULL, 3.00, 19, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1005, 'RT', NULL, 86.36, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 999, 'FT', 1, 45.45, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 999, 'FT', 2, 18.18, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 999, 'FT', 3, 9.09, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 999, 'FT', 4, 18.18, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 999, 'FT', 5, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 999, 'FT', 6, 0.00, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 999, 'FT', 7, 9.09, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 999, 'IM', NULL, 4.45, 11, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 999, 'RT', NULL, 50.00, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 997, 'FT', 1, 7.14, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 997, 'FT', 2, 64.29, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 997, 'FT', 3, 14.29, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 997, 'FT', 4, 7.14, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 997, 'FT', 5, 7.14, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 997, 'FT', 6, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 997, 'FT', 7, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 997, 'IM', NULL, 3.57, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 997, 'RT', NULL, 63.64, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1002, 'FT', 1, 21.43, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1002, 'FT', 2, 42.86, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1002, 'FT', 3, 14.29, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1002, 'FT', 4, 21.43, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1002, 'FT', 5, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1002, 'FT', 6, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1002, 'FT', 7, 0.00, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1002, 'IM', NULL, 2.86, 14, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1002, 'RT', NULL, 63.64, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1006, 'FT', 1, 50.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1006, 'FT', 2, 33.33, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1006, 'FT', 3, 11.11, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1006, 'FT', 4, 5.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1006, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1006, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1006, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1006, 'IM', NULL, 2.83, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1006, 'RT', NULL, 81.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1007, 'FT', 1, 66.67, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1007, 'FT', 2, 33.33, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1007, 'FT', 3, 0.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1007, 'FT', 4, 0.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1007, 'FT', 5, 0.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1007, 'FT', 6, 0.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1007, 'FT', 7, 0.00, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1007, 'IM', NULL, 2.42, 12, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', 1007, 'RT', NULL, 54.55, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1019, 'FT', 1, 69.57, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1019, 'FT', 2, 26.09, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1019, 'FT', 3, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1019, 'FT', 4, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1019, 'FT', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1019, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1019, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1019, 'IM', NULL, 4.22, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1019, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1009, 'FT', 1, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1009, 'FT', 2, 29.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1009, 'FT', 3, 66.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1009, 'FT', 4, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1009, 'FT', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1009, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1009, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1009, 'IM', NULL, 4.13, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1009, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1015, 'FT', 1, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1015, 'FT', 2, 45.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1015, 'FT', 3, 29.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1015, 'FT', 4, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1015, 'FT', 5, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1015, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1015, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1015, 'IM', NULL, 4.09, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1015, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1011, 'FT', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1011, 'FT', 2, 41.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1011, 'FT', 3, 33.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1011, 'FT', 4, 16.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1011, 'FT', 5, 8.33, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1011, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1011, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1011, 'IM', NULL, 3.96, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1011, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1014, 'FT', 1, 4.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1014, 'FT', 2, 25.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1014, 'FT', 3, 54.17, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1014, 'FT', 4, 16.67, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1014, 'FT', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1014, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1014, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1014, 'IM', NULL, 3.91, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1014, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1008, 'FT', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1008, 'FT', 2, 33.33, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1008, 'FT', 3, 52.38, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1008, 'FT', 4, 14.29, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1008, 'FT', 5, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1008, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1008, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
GO
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1008, 'IM', NULL, 3.85, 20, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1008, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1012, 'FT', 1, 13.04, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1012, 'FT', 2, 60.87, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1012, 'FT', 3, 26.09, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1012, 'FT', 4, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1012, 'FT', 5, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1012, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1012, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1012, 'IM', NULL, 3.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1012, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1017, 'FT', 1, 17.39, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1017, 'FT', 2, 52.17, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1017, 'FT', 3, 30.43, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1017, 'FT', 4, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1017, 'FT', 5, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1017, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1017, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1017, 'IM', NULL, 3.52, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1017, 'RT', NULL, 95.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1013, 'FT', 1, 21.74, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1013, 'FT', 2, 26.09, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1013, 'FT', 3, 43.48, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1013, 'FT', 4, 4.35, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1013, 'FT', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1013, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1013, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1013, 'IM', NULL, 3.50, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1013, 'RT', NULL, 95.83, 24, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1010, 'FT', 1, 26.09, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1010, 'FT', 2, 60.87, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1010, 'FT', 3, 8.70, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1010, 'FT', 4, 4.35, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1010, 'FT', 5, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1010, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1010, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1010, 'IM', NULL, 3.43, 21, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1010, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1016, 'FT', 1, 30.77, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1016, 'FT', 2, 46.15, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1016, 'FT', 3, 23.08, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1016, 'FT', 4, 0.00, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1016, 'FT', 5, 0.00, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1016, 'FT', 6, 0.00, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1016, 'FT', 7, 0.00, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1016, 'IM', NULL, 3.77, 13, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1016, 'RT', NULL, 59.09, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1018, 'FT', 1, 38.89, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1018, 'FT', 2, 55.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1018, 'FT', 3, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1018, 'FT', 4, 5.56, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1018, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1018, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1018, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1018, 'IM', NULL, 2.65, 17, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', 1018, 'RT', NULL, 81.82, 22, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12811, 'FT', 1, 0.52, 76, 0.42, 0.11, 2.53, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12811, 'FT', 2, 2.83, 76, 2.59, 0.44, 16.00, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12811, 'FT', 3, 0.00, 76, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12811, 'FT', 4, 1.14, 76, 0.82, 0.27, 4.70, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12811, 'FT', 5, 37.73, 76, 13.85, 15.77, 66.22, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12811, 'FT', 6, 7.12, 76, 4.31, 2.05, 21.91, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12811, 'FT', 7, 50.65, 76, 13.57, 25.82, 75.17, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12811, 'IM', NULL, 4.36, 77, 0.26, 3.85, 4.87, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12811, 'RT', NULL, 89.16, 91, 4.26, 77.41, 95.18, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12812, 'FT', 1, 0.00, 81, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12812, 'FT', 2, 2.79, 81, 2.58, 0.43, 15.98, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12812, 'FT', 3, 1.38, 81, 1.27, 0.22, 8.26, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12812, 'FT', 4, 30.05, 81, 13.27, 10.90, 60.13, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12812, 'FT', 5, 38.45, 81, 11.33, 19.42, 61.83, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12812, 'FT', 6, 8.02, 81, 5.77, 1.80, 29.26, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12812, 'FT', 7, 19.30, 81, 13.29, 4.20, 56.65, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12812, 'IM', NULL, 4.32, 83, 0.25, 3.82, 4.82, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12812, 'RT', NULL, 95.01, 91, 2.60, 86.50, 98.27, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12813, 'FT', 1, 0.00, 88, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12813, 'FT', 2, 1.87, 88, 1.69, 0.31, 10.61, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12813, 'FT', 3, 9.65, 88, 4.03, 4.09, 21.12, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12813, 'FT', 4, 14.14, 88, 5.62, 6.15, 29.24, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12813, 'FT', 5, 27.77, 88, 8.06, 14.75, 46.08, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12813, 'FT', 6, 33.65, 88, 12.81, 13.95, 61.34, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12813, 'FT', 7, 12.92, 88, 7.17, 4.02, 34.48, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12813, 'IM', NULL, 4.27, 89, 0.25, 3.78, 4.76, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12813, 'RT', NULL, 97.47, 92, 2.31, 85.71, 99.60, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12814, 'FT', 1, 0.00, 82, 0.00, NULL, NULL, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12814, 'FT', 2, 0.29, 82, 0.20, 0.08, 1.10, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12814, 'FT', 3, 8.68, 82, 5.47, 2.35, 27.28, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12814, 'FT', 4, 24.81, 82, 13.53, 7.23, 58.29, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12814, 'FT', 5, 27.80, 82, 8.02, 14.80, 46.03, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12814, 'FT', 6, 4.62, 82, 2.15, 1.80, 11.35, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12814, 'FT', 7, 33.80, 82, 13.63, 13.19, 63.18, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12814, 'IM', NULL, 4.15, 82, 0.27, 3.62, 4.69, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12814, 'RT', NULL, 91.61, 92, 6.56, 66.72, 98.34, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12815, 'FT', 1, 5.52, 76, 3.30, 1.63, 17.08, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', 12815, 'FT', 2, 6.66, 76, 3.72, 2.12, 19.01, 'N', '2007-06-01', 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VA