CREATE TABLE knowledge (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(5,2),
  lower_ci_bound DECIMAL(5,2),
  upper_ci_bound DECIMAL(5,2),
  recommend_suppress CHARACTER(1),
  not_relevant CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id));

INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.a', 'IM', 4.45, 30, 0.20, 4.04, 4.86, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.a', 'LV', 6.25, 30, 0.24, 5.75, 6.75, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.b', 'IM', 2.46, 30, 0.28, 1.89, 3.04, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.b', 'LV', 3.50, 30, 0.42, 2.65, 4.35, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.c', 'IM', 4.00, 30, 0.24, 3.51, 4.49, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.c', 'LV', 4.89, 30, 0.12, 4.63, 5.14, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.d', 'IM', 3.68, 30, 0.18, 3.31, 4.05, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.d', 'LV', 4.86, 30, 0.28, 4.28, 5.44, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.e', 'IM', 3.90, 30, 0.32, 3.25, 4.54, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.e', 'LV', 4.90, 28, 0.64, 3.58, 6.22, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.f', 'IM', 3.29, 30, 0.26, 2.76, 3.82, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.f', 'LV', 4.65, 30, 0.33, 3.98, 5.33, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.2.a', 'IM', 2.21, 30, 0.37, 1.46, 2.95, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.2.a', 'LV', 2.67, 30, 0.66, 1.32, 4.01, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.2.b', 'IM', 1.44, 29, 0.22, 1.00, 1.89, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.2.b', 'LV', 1.27, 29, 0.66, 0.00, 2.62, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.a', 'IM', 2.91, 30, 0.17, 2.57, 3.26, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.a', 'LV', 3.60, 30, 0.22, 3.14, 4.06, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.b', 'IM', 1.59, 30, 0.40, 1.00, 2.42, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.b', 'LV', 1.06, 29, 0.68, 0.00, 2.46, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.c', 'IM', 2.03, 30, 0.45, 1.10, 2.95, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.c', 'LV', 1.90, 30, 0.78, 0.30, 3.50, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.d', 'IM', 1.99, 29, 0.31, 1.35, 2.64, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.d', 'LV', 2.00, 29, 0.57, 0.82, 3.17, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.e', 'IM', 1.79, 29, 0.23, 1.33, 2.26, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.e', 'LV', 1.92, 29, 0.58, 0.74, 3.10, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.a', 'IM', 2.99, 29, 0.20, 2.59, 3.40, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.a', 'LV', 4.29, 29, 0.19, 3.89, 4.69, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.b', 'IM', 1.52, 28, 0.23, 1.05, 1.98, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.b', 'LV', 1.41, 28, 0.65, 0.07, 2.75, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.c', 'IM', 1.60, 28, 0.26, 1.07, 2.12, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.c', 'LV', 1.46, 28, 0.65, 0.13, 2.78, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.d', 'IM', 1.54, 27, 0.23, 1.06, 2.01, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.d', 'LV', 1.31, 27, 0.66, 0.00, 2.66, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.e', 'IM', 2.89, 30, 0.30, 2.27, 3.50, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.e', 'LV', 3.40, 30, 0.55, 2.28, 4.53, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.f', 'IM', 1.66, 28, 0.35, 1.00, 2.38, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.f', 'LV', 1.18, 28, 0.58, 0.00, 2.37, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.g', 'IM', 1.96, 29, 0.42, 1.10, 2.82, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.g', 'LV', 1.75, 29, 0.63, 0.45, 3.04, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.5.a', 'IM', 2.99, 29, 0.47, 2.02, 3.95, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.5.a', 'LV', 2.41, 29, 0.64, 1.09, 3.73, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.5.b', 'IM', 2.19, 29, 0.38, 1.42, 2.96, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.5.b', 'LV', 1.91, 29, 0.58, 0.73, 3.10, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.6', 'IM', 2.96, 29, 0.34, 2.27, 3.65, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.6', 'LV', 4.35, 29, 0.71, 2.89, 5.82, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.a', 'IM', 3.93, 30, 0.31, 3.29, 4.57, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.a', 'LV', 4.69, 30, 0.27, 4.15, 5.24, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.b', 'IM', 1.44, 30, 0.22, 1.00, 1.89, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.b', 'LV', 0.88, 30, 0.46, 0.00, 1.82, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.c', 'IM', 1.23, 29, 0.16, 1.00, 1.55, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.c', 'LV', 0.29, 29, 0.18, 0.00, 0.65, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.d', 'IM', 1.32, 28, 0.19, 1.00, 1.72, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.d', 'LV', 0.84, 28, 0.49, 0.00, 1.84, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.e', 'IM', 2.08, 28, 0.38, 1.30, 2.85, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.e', 'LV', 2.50, 28, 0.74, 0.99, 4.01, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.8.a', 'IM', 3.04, 29, 0.47, 2.09, 4.00, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.8.a', 'LV', 3.56, 28, 0.71, 2.10, 5.02, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.8.b', 'IM', 3.97, 29, 0.56, 2.83, 5.00, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.8.b', 'LV', 3.76, 28, 0.70, 2.32, 5.20, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.9.a', 'IM', 1.71, 30, 0.34, 1.01, 2.40, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.9.a', 'LV', 1.00, 30, 0.49, 0.01, 2.00, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.9.b', 'IM', 2.53, 30, 0.58, 1.35, 3.71, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.9.b', 'LV', 2.36, 30, 0.87, 0.59, 4.13, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.10', 'IM', 2.13, 30, 0.44, 1.23, 3.04, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.10', 'LV', 1.89, 30, 0.84, 0.17, 3.61, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.a', 'IM', 4.33, 43, 0.12, 4.08, 4.58, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.a', 'LV', 5.00, 43, 0.20, 4.59, 5.40, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.b', 'IM', 3.20, 43, 0.17, 2.86, 3.55, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.b', 'LV', 4.56, 41, 0.34, 3.87, 5.25, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.c', 'IM', 3.68, 43, 0.17, 3.33, 4.03, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.c', 'LV', 4.21, 42, 0.26, 3.69, 4.72, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.d', 'IM', 3.18, 42, 0.31, 2.55, 3.80, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.d', 'LV', 3.82, 41, 0.48, 2.85, 4.78, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.e', 'IM', 3.98, 43, 0.23, 3.51, 4.45, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.e', 'LV', 5.18, 44, 0.33, 4.51, 5.84, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.f', 'IM', 4.00, 43, 0.21, 3.57, 4.43, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.f', 'LV', 4.67, 44, 0.28, 4.09, 5.24, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.2.a', 'IM', 2.98, 44, 0.29, 2.40, 3.56, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.2.a', 'LV', 3.78, 43, 0.42, 2.94, 4.62, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.2.b', 'IM', 1.05, 44, 0.03, 1.00, 1.10, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.2.b', 'LV', 0.10, 44, 0.05, 0.00, 0.20, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.a', 'IM', 3.41, 44, 0.16, 3.08, 3.73, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.a', 'LV', 4.24, 43, 0.24, 3.74, 4.73, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.b', 'IM', 2.50, 44, 0.35, 1.78, 3.21, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.b', 'LV', 2.77, 43, 0.57, 1.62, 3.93, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.c', 'IM', 2.97, 44, 0.33, 2.31, 3.63, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.c', 'LV', 3.41, 43, 0.46, 2.48, 4.34, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.d', 'IM', 2.92, 44, 0.32, 2.27, 3.57, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.d', 'LV', 3.08, 44, 0.50, 2.07, 4.08, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.e', 'IM', 2.61, 44, 0.33, 1.94, 3.28, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.e', 'LV', 3.06, 44, 0.57, 1.92, 4.21, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.a', 'IM', 3.56, 44, 0.16, 3.24, 3.88, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.a', 'LV', 4.49, 44, 0.15, 4.19, 4.79, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.b', 'IM', 1.84, 44, 0.21, 1.42, 2.26, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.b', 'LV', 1.69, 43, 0.42, 0.84, 2.55, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.c', 'IM', 1.92, 44, 0.32, 1.26, 2.57, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.c', 'LV', 1.71, 43, 0.45, 0.80, 2.61, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.d', 'IM', 1.46, 43, 0.12, 1.21, 1.70, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.d', 'LV', 1.03, 41, 0.31, 0.40, 1.65, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.e', 'IM', 2.91, 43, 0.15, 2.61, 3.21, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.e', 'LV', 3.55, 43, 0.28, 2.98, 4.12, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.f', 'IM', 1.86, 43, 0.16, 1.54, 2.17, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.f', 'LV', 1.67, 42, 0.29, 1.10, 2.25, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.g', 'IM', 2.09, 43, 0.28, 1.52, 2.65, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.g', 'LV', 1.90, 42, 0.46, 0.97, 2.82, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.5.a', 'IM', 1.27, 44, 0.11, 1.04, 1.49, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.5.a', 'LV', 0.47, 42, 0.19, 0.08, 0.86, 'N', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.5.b', 'IM', 1.36, 44, 0.13, 1.10, 1.62, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.5.b', 'LV', 0.91, 43, 0.31, 0.28, 1.54, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.6', 'IM', 2.84, 44, 0.17, 2.49, 3.18, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.6', 'LV', 3.77, 44, 0.27, 3.22, 4.32, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.a', 'IM', 3.34, 44, 0.27, 2.79, 3.89, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.a', 'LV', 3.43, 44, 0.36, 2.70, 4.17, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.b', 'IM', 1.41, 44, 0.14, 1.12, 1.69, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.b', 'LV', 0.79, 44, 0.24, 0.30, 1.28, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.c', 'IM', 1.05, 44, 0.04, 1.00, 1.14, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.c', 'LV', 0.06, 44, 0.05, 0.00, 0.16, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.d', 'IM', 1.10, 44, 0.05, 1.00, 1.20, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.d', 'LV', 0.31, 44, 0.16, 0.00, 0.63, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.e', 'IM', 1.24, 44, 0.11, 1.02, 1.47, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.e', 'LV', 0.67, 44, 0.30, 0.08, 1.27, 'N', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.8.a', 'IM', 2.92, 44, 0.22, 2.48, 3.36, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.8.a', 'LV', 3.19, 44, 0.30, 2.59, 3.79, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.8.b', 'IM', 2.88, 44, 0.21, 2.47, 3.29, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.8.b', 'LV', 3.26, 44, 0.25, 2.76, 3.75, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.9.a', 'IM', 2.28, 44, 0.20, 1.87, 2.70, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.9.a', 'LV', 1.91, 43, 0.40, 1.11, 2.71, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.9.b', 'IM', 2.32, 44, 0.15, 2.01, 2.63, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.9.b', 'LV', 2.59, 44, 0.23, 2.13, 3.05, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.10', 'IM', 2.83, 44, 0.31, 2.19, 3.46, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.10', 'LV', 2.62, 44, 0.39, 1.84, 3.40, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.a', 'IM', 4.11, 23, 0.20, 3.70, 4.51, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.a', 'LV', 4.39, 23, 0.15, 4.07, 4.70, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.b', 'IM', 3.10, 24, 0.28, 2.51, 3.68, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.b', 'LV', 3.86, 24, 0.50, 2.82, 4.91, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.c', 'IM', 2.21, 23, 0.34, 1.51, 2.92, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.c', 'LV', 1.98, 23, 0.53, 0.89, 3.07, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.d', 'IM', 3.88, 24, 0.60, 2.65, 5.00, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.d', 'LV', 4.73, 24, 0.98, 2.71, 6.76, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.e', 'IM', 3.79, 24, 0.35, 3.07, 4.51, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.e', 'LV', 4.47, 24, 0.43, 3.59, 5.35, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.f', 'IM', 2.40, 24, 0.29, 1.79, 3.01, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.f', 'LV', 3.12, 24, 0.57, 1.95, 4.30, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.2.a', 'IM', 3.12, 24, 0.42, 2.25, 4.00, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.2.a', 'LV', 3.51, 24, 0.61, 2.25, 4.77, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.2.b', 'IM', 1.20, 24, 0.16, 1.00, 1.54, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.2.b', 'LV', 0.34, 24, 0.24, 0.00, 0.83, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.a', 'IM', 3.43, 23, 0.38, 2.65, 4.22, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.a', 'LV', 4.27, 23, 0.69, 2.84, 5.70, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.b', 'IM', 1.33, 23, 0.16, 1.00, 1.66, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.b', 'LV', 0.62, 23, 0.30, 0.01, 1.23, 'N', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.c', 'IM', 2.94, 23, 0.52, 1.87, 4.02, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.c', 'LV', 3.33, 23, 0.88, 1.52, 5.15, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.d', 'IM', 1.12, 23, 0.07, 1.00, 1.26, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.d', 'LV', 0.19, 23, 0.12, 0.00, 0.44, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.e', 'IM', 1.14, 23, 0.08, 1.00, 1.29, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.e', 'LV', 0.38, 24, 0.20, 0.00, 0.79, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.a', 'IM', 2.66, 24, 0.17, 2.31, 3.02, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.a', 'LV', 3.27, 24, 0.32, 2.60, 3.94, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.b', 'IM', 1.06, 24, 0.04, 1.00, 1.15, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.b', 'LV', 0.17, 24, 0.11, 0.00, 0.40, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.c', 'IM', 1.09, 24, 0.06, 1.00, 1.22, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.c', 'LV', 0.23, 24, 0.17, 0.00, 0.58, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.d', 'IM', 1.11, 24, 0.08, 1.00, 1.27, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.d', 'LV', 0.19, 24, 0.14, 0.00, 0.47, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.e', 'IM', 2.63, 24, 0.24, 2.14, 3.13, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.e', 'LV', 2.95, 24, 0.39, 2.14, 3.76, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.f', 'IM', 1.73, 24, 0.23, 1.25, 2.22, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.f', 'LV', 1.48, 24, 0.48, 0.48, 2.48, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.g', 'IM', 1.65, 24, 0.16, 1.32, 1.97, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.g', 'LV', 1.97, 24, 0.44, 1.07, 2.88, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.5.a', 'IM', 1.00, 24, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.5.a', 'LV', 0.00, 24, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.5.b', 'IM', 1.28, 24, 0.14, 1.00, 1.57, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.5.b', 'LV', 0.55, 24, 0.28, 0.00, 1.14, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.6', 'IM', 2.48, 24, 0.40, 1.65, 3.31, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.6', 'LV', 2.78, 24, 0.67, 1.39, 4.17, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.a', 'IM', 4.35, 24, 0.19, 3.96, 4.75, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.a', 'LV', 5.06, 24, 0.18, 4.69, 5.42, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.b', 'IM', 1.68, 24, 0.26, 1.13, 2.23, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.b', 'LV', 1.29, 24, 0.53, 0.19, 2.40, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.c', 'IM', 2.90, 23, 0.50, 1.85, 3.94, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.c', 'LV', 3.51, 23, 0.88, 1.68, 5.34, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.d', 'IM', 1.34, 24, 0.13, 1.06, 1.62, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.d', 'LV', 0.64, 24, 0.26, 0.10, 1.19, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.e', 'IM', 1.47, 24, 0.17, 1.12, 1.83, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.e', 'LV', 1.06, 24, 0.37, 0.29, 1.83, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.8.a', 'IM', 1.78, 24, 0.21, 1.34, 2.21, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.8.a', 'LV', 1.22, 24, 0.34, 0.52, 1.92, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.8.b', 'IM', 1.87, 24, 0.25, 1.35, 2.39, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.8.b', 'LV', 1.73, 24, 0.51, 0.67, 2.79, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.9.a', 'IM', 3.06, 24, 0.36, 2.32, 3.80, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.9.a', 'LV', 2.91, 24, 0.58, 1.72, 4.10, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.9.b', 'IM', 4.33, 24, 0.23, 3.86, 4.79, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.9.b', 'LV', 5.30, 24, 0.29, 4.71, 5.89, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.10', 'IM', 1.61, 24, 0.19, 1.21, 2.01, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.10', 'LV', 1.38, 24, 0.41, 0.53, 2.23, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.a', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.a', 'LV', 4.24, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.b', 'IM', 2.92, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.b', 'LV', 4.00, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.c', 'IM', 2.84, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.c', 'LV', 2.96, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.d', 'IM', 4.72, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.d', 'LV', 5.92, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.e', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.e', 'LV', 5.40, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.f', 'IM', 2.88, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.f', 'LV', 3.84, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.2.a', 'IM', 2.28, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.2.a', 'LV', 2.28, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.2.b', 'IM', 1.00, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.2.b', 'LV', 0.00, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.a', 'IM', 3.00, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.a', 'LV', 3.28, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.b', 'IM', 2.48, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.b', 'LV', 2.16, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.c', 'IM', 2.88, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.c', 'LV', 2.88, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.d', 'IM', 2.16, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.d', 'LV', 1.64, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.e', 'IM', 1.52, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.e', 'LV', 0.88, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.a', 'IM', 2.56, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.a', 'LV', 3.28, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.b', 'IM', 1.24, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.b', 'LV', 0.44, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.c', 'IM', 1.08, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.c', 'LV', 0.24, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.d', 'IM', 1.04, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.d', 'LV', 0.08, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.e', 'IM', 2.56, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.e', 'LV', 2.72, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.f', 'IM', 2.40, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.f', 'LV', 2.84, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.g', 'IM', 2.08, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.g', 'LV', 2.40, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.5.a', 'IM', 1.08, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.5.a', 'LV', 0.20, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.5.b', 'IM', 1.28, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.5.b', 'LV', 0.84, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.6', 'IM', 2.88, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.6', 'LV', 3.72, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.a', 'IM', 4.24, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.a', 'LV', 4.84, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.b', 'IM', 1.36, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.b', 'LV', 0.64, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.c', 'IM', 1.84, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.c', 'LV', 1.52, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.d', 'IM', 1.52, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.d', 'LV', 1.20, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.e', 'IM', 1.40, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.e', 'LV', 1.00, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.8.a', 'IM', 1.64, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.8.a', 'LV', 1.36, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.8.b', 'IM', 2.24, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.8.b', 'LV', 2.08, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.9.a', 'IM', 1.76, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.9.a', 'LV', 1.36, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.9.b', 'IM', 3.80, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.9.b', 'LV', 3.64, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.10', 'IM', 1.80, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.10', 'LV', 1.80, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.a', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.a', 'LV', 4.62, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.b', 'IM', 2.86, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.b', 'LV', 4.10, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.c', 'IM', 3.24, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.c', 'LV', 3.35, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.d', 'IM', 4.76, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.d', 'LV', 5.90, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.e', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.e', 'LV', 5.26, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.f', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.f', 'LV', 4.55, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.2.a', 'IM', 2.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.2.a', 'LV', 1.95, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.2.b', 'IM', 1.10, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.2.b', 'LV', 0.24, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.a', 'IM', 2.67, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.a', 'LV', 3.52, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.b', 'IM', 1.71, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.b', 'LV', 1.48, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.c', 'IM', 1.45, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.c', 'LV', 1.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.d', 'IM', 1.29, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.d', 'LV', 0.62, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.e', 'IM', 1.81, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.e', 'LV', 1.38, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.a', 'IM', 3.10, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.a', 'LV', 4.38, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.b', 'IM', 1.29, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.b', 'LV', 0.67, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.c', 'IM', 1.24, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.c', 'LV', 0.76, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.d', 'IM', 1.24, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.d', 'LV', 0.52, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.e', 'IM', 3.24, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.e', 'LV', 3.76, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.f', 'IM', 2.19, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.f', 'LV', 2.52, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.g', 'IM', 2.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.g', 'LV', 1.86, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.5.a', 'IM', 1.38, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.5.a', 'LV', 0.60, 20, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.5.b', 'IM', 1.62, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.5.b', 'LV', 1.24, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.6', 'IM', 3.14, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.6', 'LV', 4.52, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.a', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.a', 'LV', 4.14, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.b', 'IM', 1.35, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.b', 'LV', 0.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.c', 'IM', 1.15, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.c', 'LV', 0.50, 20, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.d', 'IM', 1.35, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.d', 'LV', 0.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.e', 'IM', 1.50, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.e', 'LV', 1.15, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.8.a', 'IM', 1.81, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.8.a', 'LV', 1.33, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.8.b', 'IM', 2.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.8.b', 'LV', 2.95, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.9.a', 'IM', 2.43, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.9.a', 'LV', 2.05, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.9.b', 'IM', 2.76, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.9.b', 'LV', 2.67, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.10', 'IM', 1.76, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.10', 'LV', 1.43, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.a', 'IM', 4.21, 36, 0.16, 3.89, 4.54, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.a', 'LV', 4.49, 36, 0.16, 4.17, 4.82, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.b', 'IM', 3.15, 36, 0.25, 2.65, 3.65, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.b', 'LV', 4.17, 36, 0.49, 3.18, 5.15, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.c', 'IM', 2.63, 36, 0.27, 2.09, 3.18, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.c', 'LV', 2.92, 35, 0.38, 2.15, 3.70, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.d', 'IM', 4.28, 36, 0.22, 3.84, 4.73, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.d', 'LV', 5.68, 34, 0.27, 5.13, 6.22, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.e', 'IM', 4.42, 36, 0.25, 3.92, 4.92, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.e', 'LV', 6.01, 36, 0.19, 5.62, 6.41, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.f', 'IM', 3.49, 36, 0.20, 3.09, 3.89, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.f', 'LV', 4.25, 36, 0.19, 3.86, 4.64, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.2.a', 'IM', 2.15, 36, 0.28, 1.58, 2.73, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.2.a', 'LV', 2.10, 36, 0.46, 1.15, 3.04, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.2.b', 'IM', 1.01, 36, 0.01, 1.00, 1.03, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.2.b', 'LV', 0.02, 36, 0.01, 0.00, 0.04, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.a', 'IM', 3.01, 35, 0.21, 2.57, 3.44, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.a', 'LV', 3.93, 36, 0.37, 3.18, 4.68, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.b', 'IM', 1.35, 36, 0.19, 1.00, 1.73, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.b', 'LV', 0.44, 36, 0.26, 0.00, 0.97, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.c', 'IM', 1.85, 36, 0.25, 1.35, 2.36, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.c', 'LV', 1.23, 36, 0.43, 0.36, 2.10, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.d', 'IM', 1.38, 35, 0.26, 1.00, 1.92, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.d', 'LV', 0.23, 35, 0.13, 0.00, 0.48, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.e', 'IM', 1.12, 35, 0.08, 1.00, 1.28, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.e', 'LV', 0.31, 36, 0.17, 0.00, 0.65, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.a', 'IM', 2.39, 36, 0.23, 1.93, 2.84, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.a', 'LV', 2.61, 36, 0.31, 1.98, 3.24, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.b', 'IM', 1.02, 36, 0.02, 1.00, 1.06, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.b', 'LV', 0.04, 36, 0.04, 0.00, 0.11, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.c', 'IM', 1.02, 36, 0.01, 1.00, 1.05, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.c', 'LV', 0.04, 36, 0.03, 0.00, 0.10, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.d', 'IM', 1.02, 36, 0.01, 1.00, 1.03, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.d', 'LV', 0.04, 36, 0.02, 0.01, 0.08, 'N', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.e', 'IM', 2.62, 36, 0.30, 2.02, 3.23, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.e', 'LV', 2.43, 36, 0.39, 1.63, 3.22, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.f', 'IM', 2.24, 36, 0.22, 1.80, 2.68, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.f', 'LV', 2.54, 36, 0.42, 1.68, 3.40, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.g', 'IM', 1.52, 36, 0.14, 1.24, 1.80, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.g', 'LV', 1.40, 35, 0.43, 0.53, 2.26, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.5.a', 'IM', 1.75, 36, 0.31, 1.12, 2.38, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.5.a', 'LV', 0.97, 36, 0.32, 0.32, 1.62, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.5.b', 'IM', 1.45, 36, 0.18, 1.08, 1.81, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.5.b', 'LV', 0.95, 36, 0.34, 0.27, 1.64, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.6', 'IM', 2.52, 35, 0.16, 2.20, 2.85, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.6', 'LV', 3.65, 36, 0.37, 2.89, 4.40, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.a', 'IM', 4.56, 36, 0.14, 4.28, 4.84, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.a', 'LV', 5.60, 36, 0.27, 5.06, 6.14, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.b', 'IM', 1.72, 35, 0.19, 1.33, 2.11, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.b', 'LV', 1.10, 35, 0.30, 0.48, 1.71, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.c', 'IM', 1.70, 35, 0.27, 1.16, 2.24, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.c', 'LV', 0.97, 35, 0.29, 0.38, 1.56, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.d', 'IM', 1.70, 34, 0.22, 1.25, 2.15, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.d', 'LV', 1.40, 34, 0.40, 0.58, 2.22, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.e', 'IM', 1.69, 34, 0.17, 1.35, 2.04, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.e', 'LV', 1.71, 34, 0.40, 0.89, 2.52, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.8.a', 'IM', 2.11, 34, 0.16, 1.79, 2.43, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.8.a', 'LV', 1.87, 34, 0.23, 1.41, 2.34, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.8.b', 'IM', 2.32, 35, 0.18, 1.95, 2.68, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.8.b', 'LV', 2.36, 34, 0.36, 1.62, 3.10, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.9.a', 'IM', 2.27, 35, 0.20, 1.87, 2.68, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.9.a', 'LV', 1.88, 35, 0.34, 1.19, 2.58, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.9.b', 'IM', 4.39, 35, 0.30, 3.77, 5.00, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.9.b', 'LV', 5.33, 35, 0.57, 4.17, 6.48, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.10', 'IM', 1.38, 35, 0.11, 1.16, 1.60, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.10', 'LV', 1.02, 35, 0.30, 0.41, 1.62, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.a', 'IM', 3.89, 37, 0.22, 3.43, 4.34, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.a', 'LV', 4.12, 37, 0.27, 3.58, 4.67, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.b', 'IM', 4.24, 37, 0.18, 3.87, 4.60, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.b', 'LV', 5.81, 35, 0.28, 5.25, 6.38, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.c', 'IM', 3.57, 37, 0.17, 3.22, 3.92, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.c', 'LV', 4.06, 35, 0.30, 3.44, 4.68, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.d', 'IM', 3.07, 37, 0.42, 2.20, 3.93, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.d', 'LV', 3.13, 36, 0.53, 2.06, 4.20, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.e', 'IM', 4.17, 37, 0.17, 3.83, 4.52, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.e', 'LV', 5.33, 36, 0.34, 4.65, 6.02, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.f', 'IM', 3.61, 37, 0.24, 3.11, 4.10, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.f', 'LV', 4.21, 36, 0.25, 3.69, 4.72, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.2.a', 'IM', 2.21, 37, 0.31, 1.58, 2.85, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.2.a', 'LV', 2.32, 36, 0.60, 1.10, 3.53, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.2.b', 'IM', 1.51, 37, 0.21, 1.08, 1.94, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.2.b', 'LV', 0.94, 37, 0.39, 0.16, 1.72, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.a', 'IM', 3.54, 37, 0.17, 3.20, 3.89, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.a', 'LV', 4.18, 36, 0.19, 3.79, 4.58, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.b', 'IM', 1.57, 37, 0.17, 1.23, 1.90, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.b', 'LV', 1.06, 36, 0.33, 0.38, 1.74, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.c', 'IM', 1.84, 37, 0.25, 1.33, 2.35, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.c', 'LV', 1.69, 37, 0.45, 0.77, 2.62, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.d', 'IM', 1.81, 37, 0.24, 1.32, 2.31, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.d', 'LV', 1.40, 36, 0.40, 0.58, 2.21, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.e', 'IM', 1.55, 36, 0.18, 1.19, 1.91, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.e', 'LV', 1.05, 35, 0.35, 0.33, 1.77, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.a', 'IM', 3.42, 36, 0.30, 2.81, 4.03, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.a', 'LV', 3.70, 35, 0.30, 3.10, 4.31, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.b', 'IM', 1.15, 36, 0.07, 1.00, 1.30, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.b', 'LV', 0.28, 36, 0.14, 0.00, 0.56, 'N', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.c', 'IM', 1.19, 36, 0.08, 1.02, 1.36, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.c', 'LV', 0.51, 35, 0.25, 0.00, 1.01, 'N', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.d', 'IM', 1.12, 37, 0.07, 1.00, 1.27, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.d', 'LV', 0.24, 36, 0.17, 0.00, 0.59, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.e', 'IM', 2.13, 37, 0.30, 1.51, 2.75, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.e', 'LV', 1.99, 37, 0.51, 0.96, 3.01, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.f', 'IM', 1.69, 37, 0.24, 1.20, 2.18, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.f', 'LV', 1.10, 36, 0.39, 0.31, 1.89, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.g', 'IM', 1.59, 37, 0.19, 1.21, 1.98, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.g', 'LV', 1.20, 37, 0.36, 0.46, 1.93, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.5.a', 'IM', 1.42, 37, 0.17, 1.08, 1.76, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.5.a', 'LV', 0.68, 37, 0.27, 0.13, 1.23, 'N', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.5.b', 'IM', 1.51, 37, 0.23, 1.04, 1.98, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.5.b', 'LV', 0.97, 37, 0.40, 0.14, 1.79, 'N', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.6', 'IM', 2.40, 37, 0.35, 1.69, 3.11, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.6', 'LV', 2.59, 37, 0.62, 1.33, 3.85, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.a', 'IM', 4.10, 37, 0.12, 3.86, 4.34, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.a', 'LV', 4.04, 37, 0.23, 3.58, 4.51, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.b', 'IM', 1.30, 37, 0.10, 1.11, 1.50, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.b', 'LV', 0.43, 36, 0.16, 0.11, 0.76, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.c', 'IM', 1.22, 36, 0.16, 1.00, 1.54, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.c', 'LV', 0.37, 37, 0.23, 0.00, 0.85, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.d', 'IM', 1.27, 37, 0.14, 1.00, 1.55, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.d', 'LV', 0.55, 37, 0.28, 0.00, 1.11, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.e', 'IM', 1.47, 37, 0.25, 1.00, 1.97, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.e', 'LV', 0.87, 37, 0.41, 0.03, 1.70, 'N', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.8.a', 'IM', 2.39, 37, 0.31, 1.77, 3.02, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.8.a', 'LV', 2.03, 36, 0.42, 1.17, 2.89, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.8.b', 'IM', 2.23, 37, 0.30, 1.62, 2.85, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.8.b', 'LV', 1.98, 37, 0.46, 1.04, 2.91, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.9.a', 'IM', 2.83, 36, 0.21, 2.41, 3.25, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.9.a', 'LV', 1.63, 37, 0.24, 1.14, 2.11, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.9.b', 'IM', 2.46, 36, 0.32, 1.81, 3.11, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.9.b', 'LV', 2.18, 37, 0.43, 1.30, 3.06, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.10', 'IM', 1.88, 37, 0.25, 1.38, 2.39, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.10', 'LV', 1.67, 37, 0.44, 0.78, 2.56, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.a', 'IM', 4.03, 32, 0.08, 3.86, 4.20, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.a', 'LV', 4.83, 32, 0.42, 3.97, 5.69, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.b', 'IM', 2.56, 32, 0.20, 2.14, 2.97, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.b', 'LV', 4.13, 31, 0.34, 3.43, 4.84, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.c', 'IM', 3.07, 32, 0.23, 2.61, 3.53, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.c', 'LV', 3.59, 32, 0.51, 2.56, 4.63, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.d', 'IM', 2.01, 32, 0.14, 1.72, 2.30, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.d', 'LV', 3.06, 32, 0.44, 2.16, 3.96, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.e', 'IM', 3.87, 32, 0.14, 3.59, 4.14, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.e', 'LV', 5.11, 32, 0.24, 4.61, 5.61, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.f', 'IM', 3.29, 32, 0.25, 2.78, 3.80, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.f', 'LV', 4.03, 32, 0.34, 3.33, 4.72, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.2.a', 'IM', 3.44, 32, 0.43, 2.56, 4.32, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.2.a', 'LV', 4.03, 32, 0.52, 2.97, 5.10, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.2.b', 'IM', 1.01, 31, 0.01, 1.00, 1.04, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.2.b', 'LV', 0.02, 31, 0.03, 0.00, 0.08, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.a', 'IM', 4.52, 32, 0.21, 4.10, 4.94, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.a', 'LV', 5.69, 32, 0.31, 5.04, 6.33, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.b', 'IM', 2.67, 32, 0.63, 1.39, 3.95, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.b', 'LV', 2.47, 32, 0.87, 0.69, 4.25, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.c', 'IM', 2.33, 32, 0.48, 1.35, 3.31, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.c', 'LV', 2.53, 32, 0.91, 0.68, 4.38, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.d', 'IM', 1.36, 32, 0.23, 1.00, 1.82, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.d', 'LV', 0.92, 32, 0.57, 0.00, 2.08, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.e', 'IM', 1.81, 32, 0.35, 1.10, 2.52, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.e', 'LV', 1.72, 32, 0.65, 0.39, 3.06, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.a', 'IM', 2.88, 32, 0.23, 2.41, 3.35, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.a', 'LV', 4.34, 32, 0.23, 3.88, 4.81, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.b', 'IM', 1.33, 32, 0.22, 1.00, 1.78, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.b', 'LV', 0.66, 32, 0.44, 0.00, 1.56, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.c', 'IM', 1.27, 32, 0.21, 1.00, 1.70, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.c', 'LV', 0.57, 32, 0.42, 0.00, 1.43, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.d', 'IM', 1.25, 32, 0.21, 1.00, 1.68, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.d', 'LV', 0.51, 32, 0.41, 0.00, 1.35, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.e', 'IM', 2.12, 32, 0.32, 1.47, 2.77, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.e', 'LV', 2.02, 32, 0.55, 0.90, 3.13, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.f', 'IM', 1.46, 32, 0.24, 1.00, 1.96, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.f', 'LV', 0.99, 32, 0.58, 0.00, 2.17, 'Y', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.g', 'IM', 1.41, 32, 0.32, 1.00, 2.05, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.g', 'LV', 0.76, 32, 0.54, 0.00, 1.85, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.5.a', 'IM', 1.46, 32, 0.20, 1.05, 1.86, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.5.a', 'LV', 0.86, 32, 0.39, 0.06, 1.66, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.5.b', 'IM', 1.46, 32, 0.32, 1.00, 2.11, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.5.b', 'LV', 0.96, 32, 0.65, 0.00, 2.28, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.6', 'IM', 2.35, 31, 0.37, 1.59, 3.11, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.6', 'LV', 3.84, 32, 0.94, 1.92, 5.76, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.a', 'IM', 3.41, 32, 0.18, 3.05, 3.78, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.a', 'LV', 4.32, 32, 0.42, 3.46, 5.18, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.b', 'IM', 1.25, 32, 0.21, 1.00, 1.67, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.b', 'LV', 0.43, 32, 0.32, 0.00, 1.08, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.c', 'IM', 1.04, 31, 0.03, 1.00, 1.09, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.c', 'LV', 0.27, 32, 0.21, 0.00, 0.70, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.d', 'IM', 1.03, 32, 0.02, 1.00, 1.07, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.d', 'LV', 0.09, 32, 0.07, 0.00, 0.24, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.e', 'IM', 1.20, 32, 0.12, 1.00, 1.44, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.e', 'LV', 0.40, 32, 0.24, 0.00, 0.89, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.8.a', 'IM', 2.17, 32, 0.45, 1.26, 3.08, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.8.a', 'LV', 2.43, 32, 0.91, 0.58, 4.28, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.8.b', 'IM', 1.84, 32, 0.40, 1.02, 2.67, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.8.b', 'LV', 1.42, 32, 0.67, 0.05, 2.79, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.9.a', 'IM', 3.14, 32, 0.43, 2.27, 4.01, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.9.a', 'LV', 4.11, 32, 0.47, 3.14, 5.08, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.9.b', 'IM', 2.43, 32, 0.32, 1.78, 3.09, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.9.b', 'LV', 2.87, 32, 0.18, 2.50, 3.24, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.10', 'IM', 1.85, 32, 0.41, 1.00, 2.70, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.10', 'LV', 1.41, 32, 0.61, 0.17, 2.65, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.a', 'IM', 4.08, 40, 0.11, 3.86, 4.29, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.a', 'LV', 6.21, 40, 0.44, 5.31, 7.00, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.b', 'IM', 2.97, 40, 0.52, 1.93, 4.02, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.b', 'LV', 3.92, 39, 1.02, 1.85, 5.99, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.c', 'IM', 4.28, 40, 0.18, 3.92, 4.64, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.c', 'LV', 6.40, 40, 0.33, 5.73, 7.00, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.d', 'IM', 2.04, 40, 0.14, 1.77, 2.32, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.d', 'LV', 2.51, 40, 0.38, 1.74, 3.27, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.e', 'IM', 3.20, 40, 0.23, 2.74, 3.65, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.e', 'LV', 3.67, 39, 0.46, 2.74, 4.60, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.f', 'IM', 3.61, 40, 0.30, 3.01, 4.22, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.f', 'LV', 4.31, 40, 0.49, 3.31, 5.31, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.2.a', 'IM', 1.76, 40, 0.45, 1.00, 2.68, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.2.a', 'LV', 1.29, 40, 0.73, 0.00, 2.76, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.2.b', 'IM', 1.07, 40, 0.06, 1.00, 1.19, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.2.b', 'LV', 0.26, 40, 0.23, 0.00, 0.72, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.a', 'IM', 2.66, 40, 0.38, 1.89, 3.43, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.a', 'LV', 3.38, 39, 0.32, 2.74, 4.02, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.b', 'IM', 1.40, 40, 0.25, 1.00, 1.91, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.b', 'LV', 0.73, 40, 0.45, 0.00, 1.64, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.c', 'IM', 1.32, 40, 0.24, 1.00, 1.81, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.c', 'LV', 0.69, 40, 0.46, 0.00, 1.62, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.d', 'IM', 1.34, 40, 0.25, 1.00, 1.85, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.d', 'LV', 0.74, 40, 0.49, 0.00, 1.72, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.e', 'IM', 1.33, 40, 0.25, 1.00, 1.84, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.e', 'LV', 0.50, 40, 0.36, 0.00, 1.23, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.a', 'IM', 3.86, 40, 0.17, 3.50, 4.21, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.a', 'LV', 4.57, 40, 0.32, 3.93, 5.21, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.b', 'IM', 1.12, 40, 0.09, 1.00, 1.30, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.b', 'LV', 0.30, 40, 0.23, 0.00, 0.77, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.c', 'IM', 1.12, 40, 0.09, 1.00, 1.30, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.c', 'LV', 0.38, 40, 0.29, 0.00, 0.97, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.d', 'IM', 1.09, 40, 0.07, 1.00, 1.24, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.d', 'LV', 0.27, 40, 0.22, 0.00, 0.71, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.e', 'IM', 2.70, 40, 0.22, 2.24, 3.15, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.e', 'LV', 3.29, 39, 0.49, 2.30, 4.28, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.f', 'IM', 1.84, 40, 0.13, 1.58, 2.09, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.f', 'LV', 1.84, 40, 0.24, 1.35, 2.34, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.g', 'IM', 1.30, 40, 0.18, 1.00, 1.67, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.g', 'LV', 0.85, 40, 0.50, 0.00, 1.85, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.5.a', 'IM', 1.05, 40, 0.04, 1.00, 1.13, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.5.a', 'LV', 0.13, 40, 0.11, 0.00, 0.36, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.5.b', 'IM', 1.37, 40, 0.22, 1.00, 1.82, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.5.b', 'LV', 0.63, 40, 0.37, 0.00, 1.37, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.6', 'IM', 3.10, 40, 0.16, 2.77, 3.43, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.6', 'LV', 4.08, 40, 0.20, 3.67, 4.49, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.a', 'IM', 4.61, 40, 0.21, 4.17, 5.00, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.a', 'LV', 4.79, 40, 0.14, 4.50, 5.08, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.b', 'IM', 1.18, 40, 0.11, 1.00, 1.41, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.b', 'LV', 0.25, 40, 0.16, 0.00, 0.57, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.c', 'IM', 1.13, 40, 0.09, 1.00, 1.31, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.c', 'LV', 0.30, 40, 0.20, 0.00, 0.71, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.d', 'IM', 1.23, 39, 0.15, 1.00, 1.53, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.d', 'LV', 0.50, 39, 0.33, 0.00, 1.17, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.e', 'IM', 1.25, 39, 0.14, 1.00, 1.54, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.e', 'LV', 0.76, 39, 0.46, 0.00, 1.69, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.8.a', 'IM', 1.71, 40, 0.41, 1.00, 2.53, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.8.a', 'LV', 1.25, 39, 0.69, 0.00, 2.65, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.8.b', 'IM', 3.60, 40, 0.31, 2.97, 4.22, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.8.b', 'LV', 4.09, 40, 0.57, 2.94, 5.25, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.9.a', 'IM', 2.13, 40, 0.18, 1.76, 2.49, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.9.a', 'LV', 1.54, 40, 0.34, 0.85, 2.23, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.9.b', 'IM', 1.78, 40, 0.43, 1.00, 2.65, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.9.b', 'LV', 1.35, 39, 0.72, 0.00, 2.80, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.10', 'IM', 1.56, 40, 0.33, 1.00, 2.23, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.10', 'LV', 1.05, 40, 0.60, 0.00, 2.27, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.a', 'IM', 4.34, 16, 0.24, 3.82, 4.86, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.a', 'LV', 4.64, 16, 0.25, 4.11, 5.17, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.b', 'IM', 3.67, 16, 0.45, 2.70, 4.64, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.b', 'LV', 4.76, 16, 0.96, 2.71, 6.82, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.c', 'IM', 3.94, 16, 0.42, 3.03, 4.84, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.c', 'LV', 4.36, 16, 0.46, 3.38, 5.33, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.d', 'IM', 3.90, 16, 0.42, 3.00, 4.80, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.d', 'LV', 4.57, 16, 0.25, 4.04, 5.10, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.e', 'IM', 4.57, 15, 0.27, 3.98, 5.00, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.e', 'LV', 5.65, 15, 0.50, 4.57, 6.72, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.f', 'IM', 3.63, 15, 0.24, 3.12, 4.14, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.f', 'LV', 4.35, 15, 0.25, 3.81, 4.89, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.2.a', 'IM', 2.63, 14, 0.24, 2.11, 3.14, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.2.a', 'LV', 2.91, 15, 0.42, 2.01, 3.82, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.2.b', 'IM', 1.00, 15, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.2.b', 'LV', 0.00, 15, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.a', 'IM', 3.96, 16, 0.42, 3.06, 4.86, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.a', 'LV', 4.36, 16, 0.25, 3.83, 4.89, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.b', 'IM', 1.41, 16, 0.26, 1.00, 1.97, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.b', 'LV', 0.78, 16, 0.51, 0.00, 1.86, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.c', 'IM', 1.37, 16, 0.23, 1.00, 1.87, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.c', 'LV', 1.06, 16, 0.69, 0.00, 2.54, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.d', 'IM', 1.00, 16, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.d', 'LV', 0.00, 16, 0.00, 0.00, 0.00, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.e', 'IM', 1.28, 16, 0.23, 1.00, 1.78, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.e', 'LV', 0.85, 16, 0.69, 0.00, 2.32, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.a', 'IM', 3.97, 16, 0.42, 3.07, 4.87, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.a', 'LV', 4.93, 16, 0.41, 4.07, 5.80, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.b', 'IM', 1.28, 16, 0.23, 1.00, 1.77, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.b', 'LV', 0.57, 16, 0.46, 0.00, 1.55, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.c', 'IM', 1.00, 15, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.c', 'LV', 0.00, 15, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.d', 'IM', 1.00, 16, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.d', 'LV', 0.00, 16, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.e', 'IM', 1.71, 16, 0.25, 1.17, 2.25, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.e', 'LV', 1.13, 16, 0.44, 0.20, 2.07, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.f', 'IM', 1.00, 16, 0.00, 1.00, 1.01, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.f', 'LV', 0.00, 16, 0.00, 0.00, 0.01, 'Y', 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.g', 'IM', 1.28, 15, 0.24, 1.00, 1.80, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.g', 'LV', 0.85, 15, 0.72, 0.00, 2.40, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.5.a', 'IM', 1.85, 16, 0.72, 1.00, 3.39, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.5.a', 'LV', 0.28, 16, 0.24, 0.00, 0.80, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.5.b', 'IM', 2.17, 16, 0.26, 1.62, 2.73, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.5.b', 'LV', 1.87, 16, 0.43, 0.94, 2.80, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.6', 'IM', 3.36, 16, 0.24, 2.84, 3.88, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.6', 'LV', 4.68, 16, 0.61, 3.38, 5.98, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.a', 'IM', 4.12, 15, 0.09, 3.92, 4.33, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.a', 'LV', 3.92, 16, 0.31, 3.27, 4.57, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.b', 'IM', 1.29, 16, 0.24, 1.00, 1.80, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.b', 'LV', 0.29, 16, 0.24, 0.00, 0.80, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.c', 'IM', 1.28, 16, 0.24, 1.00, 1.80, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.c', 'LV', 0.28, 16, 0.24, 0.00, 0.80, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.d', 'IM', 1.28, 16, 0.23, 1.00, 1.77, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.d', 'LV', 0.57, 16, 0.46, 0.00, 1.55, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.e', 'IM', 1.28, 16, 0.23, 1.00, 1.77, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.e', 'LV', 0.57, 16, 0.46, 0.00, 1.55, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.8.a', 'IM', 2.80, 16, 0.86, 1.00, 4.64, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.8.a', 'LV', 2.42, 16, 1.09, 0.10, 4.74, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.8.b', 'IM', 3.62, 15, 0.25, 3.08, 4.15, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.8.b', 'LV', 3.42, 15, 0.25, 2.88, 3.97, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.9.a', 'IM', 2.14, 16, 0.43, 1.23, 3.06, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.9.a', 'LV', 1.65, 15, 0.86, 0.00, 3.49, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.9.b', 'IM', 2.65, 15, 0.23, 2.17, 3.14, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.9.b', 'LV', 2.35, 15, 0.24, 1.84, 2.87, 'N', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.10', 'IM', 1.70, 16, 0.48, 1.00, 2.72, 'N', NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.10', 'LV', 1.24, 16, 0.75, 0.00, 2.83, 'Y', 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.a', 'IM', 3.66, 39, 0.10, 3.45, 3.86, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.a', 'LV', 4.54, 39, 0.20, 4.14, 4.93, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.b', 'IM', 2.75, 38, 0.38, 1.99, 3.51, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.b', 'LV', 2.87, 38, 0.47, 1.91, 3.82, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.c', 'IM', 2.00, 39, 0.30, 1.40, 2.61, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.c', 'LV', 1.53, 39, 0.36, 0.80, 2.26, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.d', 'IM', 2.05, 39, 0.36, 1.33, 2.77, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.d', 'LV', 1.80, 39, 0.49, 0.80, 2.80, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.e', 'IM', 3.09, 39, 0.29, 2.50, 3.68, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.e', 'LV', 3.26, 38, 0.43, 2.38, 4.14, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.f', 'IM', 2.87, 39, 0.20, 2.46, 3.28, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.f', 'LV', 3.28, 39, 0.30, 2.67, 3.88, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.2.a', 'IM', 4.80, 38, 0.09, 4.62, 4.98, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.2.a', 'LV', 4.96, 39, 0.16, 4.64, 5.28, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.2.b', 'IM', 1.46, 39, 0.28, 1.00, 2.03, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.2.b', 'LV', 0.74, 39, 0.41, 0.00, 1.56, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.a', 'IM', 2.45, 39, 0.43, 1.58, 3.33, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.a', 'LV', 2.64, 39, 0.69, 1.25, 4.03, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.b', 'IM', 2.91, 39, 0.35, 2.20, 3.62, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.b', 'LV', 3.16, 39, 0.42, 2.30, 4.02, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.c', 'IM', 3.09, 39, 0.61, 1.87, 4.32, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.c', 'LV', 3.08, 39, 0.39, 2.30, 3.86, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.d', 'IM', 1.93, 39, 0.40, 1.11, 2.75, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.d', 'LV', 1.50, 39, 0.57, 0.35, 2.65, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.e', 'IM', 3.94, 39, 0.18, 3.58, 4.30, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.e', 'LV', 4.56, 39, 0.25, 4.05, 5.08, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.a', 'IM', 3.70, 39, 0.19, 3.32, 4.07, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.a', 'LV', 3.92, 39, 0.26, 3.40, 4.45, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.b', 'IM', 2.25, 39, 0.32, 1.60, 2.90, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.b', 'LV', 2.13, 39, 0.38, 1.36, 2.90, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.c', 'IM', 2.48, 39, 0.28, 1.92, 3.05, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.c', 'LV', 2.74, 39, 0.34, 2.05, 3.44, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.d', 'IM', 1.51, 39, 0.35, 1.00, 2.22, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.d', 'LV', 0.58, 39, 0.30, 0.00, 1.19, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.e', 'IM', 2.45, 39, 0.28, 1.88, 3.02, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.e', 'LV', 2.69, 39, 0.39, 1.89, 3.49, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.f', 'IM', 1.78, 39, 0.22, 1.33, 2.23, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.f', 'LV', 1.48, 39, 0.40, 0.67, 2.28, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.g', 'IM', 1.44, 39, 0.28, 1.00, 2.00, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.g', 'LV', 0.87, 39, 0.49, 0.00, 1.86, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.5.a', 'IM', 1.70, 37, 0.18, 1.32, 2.07, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.5.a', 'LV', 1.06, 38, 0.25, 0.56, 1.57, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.5.b', 'IM', 1.83, 38, 0.19, 1.44, 2.22, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.5.b', 'LV', 1.59, 38, 0.35, 0.87, 2.30, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.6', 'IM', 3.23, 38, 0.34, 2.54, 3.93, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.6', 'LV', 4.06, 38, 0.33, 3.39, 4.73, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.a', 'IM', 2.78, 38, 0.27, 2.24, 3.32, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.a', 'LV', 2.82, 38, 0.41, 1.99, 3.64, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.b', 'IM', 1.45, 39, 0.18, 1.10, 1.81, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.b', 'LV', 0.76, 39, 0.30, 0.15, 1.38, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.c', 'IM', 1.03, 39, 0.02, 1.00, 1.06, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.c', 'LV', 0.05, 39, 0.03, 0.00, 0.12, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.d', 'IM', 1.25, 39, 0.11, 1.02, 1.48, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.d', 'LV', 0.57, 39, 0.24, 0.07, 1.06, 'N', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.e', 'IM', 1.21, 39, 0.09, 1.03, 1.40, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.e', 'LV', 0.40, 39, 0.17, 0.07, 0.74, 'N', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.8.a', 'IM', 2.66, 39, 0.35, 1.96, 3.37, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.8.a', 'LV', 2.53, 39, 0.50, 1.52, 3.54, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.8.b', 'IM', 2.21, 39, 0.26, 1.69, 2.73, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.8.b', 'LV', 1.91, 39, 0.34, 1.23, 2.60, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.9.a', 'IM', 1.81, 39, 0.25, 1.30, 2.32, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.9.a', 'LV', 1.26, 39, 0.41, 0.43, 2.10, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.9.b', 'IM', 2.01, 39, 0.23, 1.54, 2.48, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.9.b', 'LV', 2.05, 39, 0.49, 1.05, 3.05, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.10', 'IM', 2.11, 39, 0.28, 1.55, 2.67, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.10', 'LV', 1.82, 39, 0.68, 0.45, 3.19, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.a', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.a', 'LV', 5.08, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.b', 'IM', 2.88, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.b', 'LV', 4.29, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.c', 'IM', 3.42, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.c', 'LV', 3.83, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.d', 'IM', 2.57, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.d', 'LV', 3.50, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.e', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.e', 'LV', 4.50, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.f', 'IM', 3.42, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.f', 'LV', 4.17, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.2.a', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.2.a', 'LV', 4.83, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.2.b', 'IM', 1.42, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.2.b', 'LV', 0.88, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.a', 'IM', 2.92, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.a', 'LV', 3.96, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.b', 'IM', 2.75, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.b', 'LV', 3.54, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.c', 'IM', 2.33, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.c', 'LV', 3.33, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.d', 'IM', 2.12, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.d', 'LV', 2.50, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.e', 'IM', 2.62, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.e', 'LV', 3.04, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.a', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.a', 'LV', 4.58, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.b', 'IM', 1.50, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.b', 'LV', 1.29, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.c', 'IM', 1.88, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.c', 'LV', 2.08, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.d', 'IM', 1.62, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.d', 'LV', 1.21, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.e', 'IM', 2.83, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.e', 'LV', 3.50, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.f', 'IM', 2.17, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.f', 'LV', 2.04, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.g', 'IM', 2.29, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.g', 'LV', 3.17, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.5.a', 'IM', 1.26, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.5.a', 'LV', 0.52, 23, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.5.b', 'IM', 1.35, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.5.b', 'LV', 0.83, 23, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.6', 'IM', 2.54, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.6', 'LV', 3.50, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.a', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.a', 'LV', 4.33, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.b', 'IM', 2.00, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.b', 'LV', 1.92, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.c', 'IM', 1.17, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.c', 'LV', 0.42, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.d', 'IM', 1.50, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.d', 'LV', 1.00, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.e', 'IM', 1.58, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.e', 'LV', 1.29, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.8.a', 'IM', 2.33, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.8.a', 'LV', 2.50, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.8.b', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.8.b', 'LV', 3.67, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.9.a', 'IM', 2.42, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.9.a', 'LV', 1.75, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.9.b', 'IM', 2.58, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.9.b', 'LV', 3.00, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.10', 'IM', 3.50, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.10', 'LV', 3.83, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.a', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.a', 'LV', 5.17, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.b', 'IM', 2.78, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.b', 'LV', 3.65, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.c', 'IM', 3.30, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.c', 'LV', 3.74, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.d', 'IM', 3.00, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.d', 'LV', 3.87, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.e', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.e', 'LV', 4.96, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.f', 'IM', 3.35, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.f', 'LV', 4.43, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.2.a', 'IM', 3.57, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.2.a', 'LV', 4.87, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.2.b', 'IM', 1.26, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.2.b', 'LV', 0.65, 23, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.a', 'IM', 2.91, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.a', 'LV', 3.48, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.b', 'IM', 2.13, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.b', 'LV', 2.74, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.c', 'IM', 1.87, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.c', 'LV', 1.91, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.d', 'IM', 1.65, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.d', 'LV', 1.70, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.e', 'IM', 1.78, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.e', 'LV', 1.87, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.a', 'IM', 3.48, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.a', 'LV', 4.43, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.b', 'IM', 1.48, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.b', 'LV', 1.00, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.c', 'IM', 1.83, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.c', 'LV', 2.09, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.d', 'IM', 1.26, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.d', 'LV', 0.61, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.e', 'IM', 2.61, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.e', 'LV', 3.57, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.f', 'IM', 1.87, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.f', 'LV', 1.78, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.g', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.g', 'LV', 4.61, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.5.a', 'IM', 1.17, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.5.a', 'LV', 0.39, 23, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.5.b', 'IM', 1.83, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.5.b', 'LV', 2.17, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.6', 'IM', 3.30, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.6', 'LV', 4.39, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.a', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.a', 'LV', 4.22, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.b', 'IM', 1.91, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.b', 'LV', 1.48, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.c', 'IM', 1.22, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.c', 'LV', 0.39, 23, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.d', 'IM', 1.43, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.d', 'LV', 1.13, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.e', 'IM', 1.65, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.e', 'LV', 1.48, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.8.a', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.8.a', 'LV', 3.83, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.8.b', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.8.b', 'LV', 3.65, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.9.a', 'IM', 2.39, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.9.a', 'LV', 1.65, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.9.b', 'IM', 2.48, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.9.b', 'LV', 2.57, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.10', 'IM', 4.78, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.10', 'LV', 4.96, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.a', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.a', 'LV', 4.50, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.b', 'IM', 2.75, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.b', 'LV', 3.42, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.c', 'IM', 2.79, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.c', 'LV', 2.83, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.d', 'IM', 1.88, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.d', 'LV', 1.50, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.e', 'IM', 3.42, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.e', 'LV', 4.29, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.f', 'IM', 3.67, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.f', 'LV', 3.96, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.2.a', 'IM', 3.17, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.2.a', 'LV', 3.88, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.2.b', 'IM', 1.54, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.2.b', 'LV', 0.88, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.a', 'IM', 2.48, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.a', 'LV', 3.00, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.b', 'IM', 1.83, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.b', 'LV', 2.00, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.c', 'IM', 1.54, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.c', 'LV', 1.38, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.d', 'IM', 1.38, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.d', 'LV', 0.83, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.e', 'IM', 1.79, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.e', 'LV', 1.92, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.a', 'IM', 3.50, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.a', 'LV', 3.54, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.b', 'IM', 1.29, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.b', 'LV', 0.58, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.c', 'IM', 1.29, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.c', 'LV', 0.62, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.d', 'IM', 1.04, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.d', 'LV', 0.08, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.e', 'IM', 2.52, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.e', 'LV', 3.08, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.f', 'IM', 1.88, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.f', 'LV', 1.46, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.g', 'IM', 1.96, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.g', 'LV', 2.04, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.5.a', 'IM', 1.25, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.5.a', 'LV', 0.54, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.5.b', 'IM', 1.46, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.5.b', 'LV', 1.25, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.6', 'IM', 2.79, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.6', 'LV', 3.50, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.a', 'IM', 3.21, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.a', 'LV', 3.17, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.b', 'IM', 1.50, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.b', 'LV', 0.88, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.c', 'IM', 1.00, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.c', 'LV', 0.00, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.d', 'IM', 1.12, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.d', 'LV', 0.12, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.e', 'IM', 1.33, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.e', 'LV', 0.78, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.8.a', 'IM', 2.75, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.8.a', 'LV', 3.08, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.8.b', 'IM', 2.25, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.8.b', 'LV', 2.38, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.9.a', 'IM', 1.83, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.9.a', 'LV', 0.88, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.9.b', 'IM', 2.22, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.9.b', 'LV', 2.00, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.10', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.10', 'LV', 3.71, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.a', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.a', 'LV', 4.67, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.b', 'IM', 2.67, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.b', 'LV', 3.43, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.c', 'IM', 3.14, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.c', 'LV', 3.33, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.d', 'IM', 1.86, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.d', 'LV', 2.19, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.e', 'IM', 3.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.e', 'LV', 3.95, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.f', 'IM', 4.71, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.f', 'LV', 5.71, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.2.a', 'IM', 1.52, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.2.a', 'LV', 0.95, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.2.b', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.2.b', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.a', 'IM', 2.14, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.a', 'LV', 2.35, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.b', 'IM', 1.10, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.b', 'LV', 0.19, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.c', 'IM', 1.14, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.c', 'LV', 0.24, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.d', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.d', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.e', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.e', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.a', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.a', 'LV', 4.90, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.b', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.b', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.c', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.c', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.d', 'IM', 1.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.d', 'LV', 0.10, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.e', 'IM', 2.62, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.e', 'LV', 3.19, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.f', 'IM', 2.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.f', 'LV', 2.14, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.g', 'IM', 1.33, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.g', 'LV', 1.05, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.5.a', 'IM', 1.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.5.a', 'LV', 1.00, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.5.b', 'IM', 1.62, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.5.b', 'LV', 1.48, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.6', 'IM', 2.52, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.6', 'LV', 3.86, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.a', 'LV', 4.33, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.b', 'IM', 1.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.b', 'LV', 0.71, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.c', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.c', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.d', 'IM', 1.24, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.d', 'LV', 0.67, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.e', 'IM', 1.57, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.e', 'LV', 1.57, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.8.a', 'IM', 1.62, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.8.a', 'LV', 1.10, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.8.b', 'IM', 3.24, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.8.b', 'LV', 3.60, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.9.a', 'IM', 1.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.9.a', 'LV', 0.52, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.9.b', 'IM', 2.43, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.9.b', 'LV', 2.90, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.10', 'IM', 1.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.10', 'LV', 1.24, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.a', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.a', 'LV', 4.86, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.b', 'IM', 2.86, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.b', 'LV', 4.76, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.c', 'IM', 2.64, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.c', 'LV', 2.73, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.d', 'IM', 2.27, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.d', 'LV', 2.64, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.e', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.e', 'LV', 4.86, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.f', 'IM', 4.86, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.f', 'LV', 5.55, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.2.a', 'IM', 1.68, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.2.a', 'LV', 1.36, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.2.b', 'IM', 1.14, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.2.b', 'LV', 0.18, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.a', 'IM', 2.59, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.a', 'LV', 3.32, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.b', 'IM', 1.45, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.b', 'LV', 0.71, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.c', 'IM', 1.41, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.c', 'LV', 0.73, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.d', 'IM', 1.32, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.d', 'LV', 0.59, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.e', 'IM', 1.32, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.e', 'LV', 0.59, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.a', 'IM', 3.32, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.a', 'LV', 4.18, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.b', 'IM', 1.27, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.b', 'LV', 0.45, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.c', 'IM', 1.27, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.c', 'LV', 0.59, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.d', 'IM', 1.32, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.d', 'LV', 0.68, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.e', 'IM', 3.55, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.e', 'LV', 4.36, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.f', 'IM', 2.82, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.f', 'LV', 3.50, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.g', 'IM', 1.50, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.g', 'LV', 1.18, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.5.a', 'IM', 1.55, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.5.a', 'LV', 0.95, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.5.b', 'IM', 2.68, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.5.b', 'LV', 3.82, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.6', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.6', 'LV', 5.00, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.a', 'LV', 4.50, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.b', 'IM', 1.82, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.b', 'LV', 1.59, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.c', 'IM', 1.18, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.c', 'LV', 0.41, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.d', 'IM', 1.41, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.d', 'LV', 0.91, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.e', 'IM', 2.38, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.e', 'LV', 3.05, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.8.a', 'IM', 2.68, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.8.a', 'LV', 2.86, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.8.b', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.8.b', 'LV', 4.05, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.9.a', 'IM', 1.64, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.9.a', 'LV', 0.82, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.9.b', 'IM', 2.68, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.9.b', 'LV', 2.68, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.10', 'IM', 1.55, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.10', 'LV', 1.18, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.a', 'IM', 4.25, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.a', 'LV', 4.62, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.b', 'IM', 2.88, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.b', 'LV', 4.58, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.c', 'IM', 2.67, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.c', 'LV', 2.83, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.d', 'IM', 3.08, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.d', 'LV', 3.96, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.e', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.e', 'LV', 5.04, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.f', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.f', 'LV', 4.96, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.2.a', 'IM', 2.42, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.2.a', 'LV', 2.48, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.2.b', 'IM', 1.42, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.2.b', 'LV', 0.79, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.a', 'IM', 2.92, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.a', 'LV', 3.54, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.b', 'IM', 1.67, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.b', 'LV', 1.08, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.c', 'IM', 1.67, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.c', 'LV', 1.29, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.d', 'IM', 1.33, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.d', 'LV', 0.67, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.e', 'IM', 1.83, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.e', 'LV', 1.46, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.a', 'IM', 2.91, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.a', 'LV', 3.50, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.b', 'IM', 1.25, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.b', 'LV', 0.38, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.c', 'IM', 1.33, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.c', 'LV', 0.62, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.d', 'IM', 1.21, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.d', 'LV', 0.33, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.e', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.e', 'LV', 3.79, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.f', 'IM', 3.25, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.f', 'LV', 4.17, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.g', 'IM', 1.54, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.g', 'LV', 1.12, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.5.a', 'IM', 1.35, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.5.a', 'LV', 0.65, 23, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.5.b', 'IM', 2.43, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.5.b', 'LV', 3.22, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.6', 'IM', 4.70, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.6', 'LV', 6.17, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.a', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.a', 'LV', 5.39, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.b', 'IM', 1.88, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.b', 'LV', 1.52, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.c', 'IM', 1.67, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.c', 'LV', 1.46, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.d', 'IM', 1.79, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.d', 'LV', 1.62, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.e', 'IM', 2.42, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.e', 'LV', 2.92, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.8.a', 'IM', 2.50, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.8.a', 'LV', 2.58, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.8.b', 'IM', 2.83, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.8.b', 'LV', 2.92, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.9.a', 'IM', 2.46, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.9.a', 'LV', 2.13, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.9.b', 'IM', 3.46, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.9.b', 'LV', 3.75, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.10', 'IM', 1.54, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.10', 'LV', 1.21, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.a', 'IM', 4.39, 24, 0.16, 4.06, 4.72, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.a', 'LV', 4.44, 24, 0.16, 4.10, 4.77, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.b', 'IM', 2.84, 24, 0.36, 2.10, 3.58, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.b', 'LV', 3.72, 24, 0.71, 2.25, 5.19, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.c', 'IM', 3.32, 23, 0.23, 2.85, 3.80, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.c', 'LV', 3.31, 23, 0.44, 2.40, 4.21, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.d', 'IM', 3.92, 24, 0.22, 3.46, 4.38, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.d', 'LV', 4.52, 24, 0.25, 4.01, 5.03, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.e', 'IM', 3.82, 24, 0.35, 3.08, 4.55, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.e', 'LV', 4.66, 24, 0.36, 3.92, 5.41, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.f', 'IM', 4.10, 24, 0.27, 3.54, 4.67, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.f', 'LV', 3.99, 24, 0.17, 3.64, 4.34, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.2.a', 'IM', 4.17, 24, 0.40, 3.35, 4.99, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.2.a', 'LV', 5.10, 23, 0.42, 4.23, 5.97, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.2.b', 'IM', 2.16, 24, 0.43, 1.26, 3.06, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.2.b', 'LV', 1.96, 24, 0.73, 0.46, 3.47, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.a', 'IM', 1.82, 24, 0.16, 1.50, 2.15, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.a', 'LV', 2.66, 24, 0.55, 1.53, 3.79, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.b', 'IM', 2.69, 24, 0.48, 1.69, 3.68, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.b', 'LV', 2.77, 24, 0.73, 1.25, 4.29, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.c', 'IM', 2.98, 24, 0.27, 2.41, 3.54, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.c', 'LV', 3.65, 24, 0.34, 2.96, 4.35, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.d', 'IM', 2.46, 24, 0.33, 1.78, 3.14, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.d', 'LV', 2.58, 24, 0.53, 1.48, 3.67, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.e', 'IM', 3.08, 24, 0.42, 2.21, 3.94, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.e', 'LV', 3.73, 24, 0.75, 2.19, 5.27, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.a', 'IM', 3.43, 24, 0.19, 3.03, 3.83, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.a', 'LV', 4.07, 24, 0.26, 3.53, 4.61, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.b', 'IM', 1.85, 24, 0.23, 1.38, 2.32, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.b', 'LV', 2.31, 24, 0.64, 0.99, 3.63, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.c', 'IM', 3.35, 24, 0.31, 2.71, 3.98, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.c', 'LV', 3.83, 24, 0.37, 3.06, 4.60, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.d', 'IM', 3.92, 23, 0.39, 3.12, 4.73, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.d', 'LV', 4.53, 23, 0.64, 3.19, 5.86, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.e', 'IM', 2.89, 23, 0.17, 2.54, 3.24, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.e', 'LV', 3.57, 22, 0.37, 2.79, 4.34, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.f', 'IM', 1.89, 23, 0.35, 1.17, 2.60, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.f', 'LV', 1.27, 22, 0.49, 0.25, 2.28, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.g', 'IM', 2.41, 23, 0.20, 2.00, 2.82, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.g', 'LV', 3.18, 23, 0.48, 2.19, 4.16, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.5.a', 'IM', 1.26, 24, 0.12, 1.02, 1.51, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.5.a', 'LV', 0.54, 24, 0.24, 0.04, 1.03, 'N', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.5.b', 'IM', 1.39, 24, 0.16, 1.06, 1.72, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.5.b', 'LV', 0.80, 24, 0.33, 0.13, 1.48, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.6', 'IM', 3.16, 24, 0.24, 2.65, 3.66, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.6', 'LV', 4.11, 24, 0.43, 3.22, 5.01, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.a', 'IM', 3.11, 24, 0.26, 2.56, 3.65, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.a', 'LV', 3.25, 24, 0.19, 2.85, 3.66, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.b', 'IM', 2.24, 23, 0.38, 1.45, 3.03, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.b', 'LV', 2.01, 23, 0.59, 0.80, 3.23, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.c', 'IM', 1.11, 23, 0.09, 1.00, 1.30, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.c', 'LV', 0.13, 23, 0.10, 0.00, 0.33, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.d', 'IM', 1.68, 23, 0.18, 1.32, 2.05, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.d', 'LV', 1.63, 23, 0.50, 0.60, 2.67, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.e', 'IM', 2.48, 23, 0.41, 1.63, 3.33, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.e', 'LV', 2.31, 23, 0.55, 1.17, 3.45, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.8.a', 'IM', 2.91, 24, 0.38, 2.13, 3.70, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.8.a', 'LV', 2.87, 24, 0.29, 2.27, 3.48, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.8.b', 'IM', 2.88, 24, 0.32, 2.23, 3.54, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.8.b', 'LV', 3.13, 24, 0.39, 2.33, 3.94, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.9.a', 'IM', 1.35, 24, 0.13, 1.08, 1.61, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.9.a', 'LV', 0.46, 24, 0.17, 0.10, 0.82, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.9.b', 'IM', 2.14, 24, 0.17, 1.80, 2.49, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.9.b', 'LV', 2.65, 24, 0.19, 2.26, 3.05, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.10', 'IM', 3.23, 24, 0.29, 2.62, 3.83, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.10', 'LV', 3.21, 24, 0.29, 2.61, 3.82, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.a', 'IM', 3.97, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.a', 'LV', 4.74, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.b', 'IM', 2.94, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.b', 'LV', 4.00, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.c', 'IM', 3.26, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.c', 'LV', 3.55, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.d', 'IM', 3.29, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.d', 'LV', 4.19, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.e', 'IM', 3.55, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.e', 'LV', 4.23, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.f', 'IM', 3.45, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.f', 'LV', 4.00, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.2.a', 'IM', 3.74, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.2.a', 'LV', 4.42, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.2.b', 'IM', 4.23, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.2.b', 'LV', 5.13, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.a', 'IM', 3.13, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.a', 'LV', 4.00, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.b', 'IM', 3.81, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.b', 'LV', 5.19, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.c', 'IM', 3.19, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.c', 'LV', 4.23, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.d', 'IM', 3.29, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.d', 'LV', 4.32, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.e', 'IM', 3.55, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.e', 'LV', 4.77, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.a', 'IM', 3.71, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.a', 'LV', 4.52, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.b', 'IM', 3.29, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.b', 'LV', 3.81, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.c', 'IM', 3.68, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.c', 'LV', 4.52, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.d', 'IM', 4.42, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.d', 'LV', 5.52, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.e', 'IM', 2.55, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.e', 'LV', 3.10, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.f', 'IM', 1.97, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.f', 'LV', 2.00, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.g', 'IM', 2.35, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.g', 'LV', 3.13, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.5.a', 'IM', 1.68, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.5.a', 'LV', 1.42, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.5.b', 'IM', 1.61, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.5.b', 'LV', 1.58, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.6', 'IM', 2.97, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.6', 'LV', 4.23, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.a', 'IM', 3.45, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.a', 'LV', 4.00, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.b', 'IM', 1.97, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.b', 'LV', 1.87, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.c', 'IM', 1.03, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.c', 'LV', 0.06, 31, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.d', 'IM', 1.35, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.d', 'LV', 0.81, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.e', 'IM', 1.42, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.e', 'LV', 0.94, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.8.a', 'IM', 2.87, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.8.a', 'LV', 3.39, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.8.b', 'IM', 3.19, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.8.b', 'LV', 3.57, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.9.a', 'IM', 2.13, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.9.a', 'LV', 1.87, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.9.b', 'IM', 2.45, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.9.b', 'LV', 2.39, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.10', 'IM', 2.97, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.10', 'LV', 3.26, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.a', 'IM', 4.19, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.a', 'LV', 4.88, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.b', 'IM', 2.88, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.b', 'LV', 3.84, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.c', 'IM', 3.06, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.c', 'LV', 3.31, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.d', 'IM', 2.62, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.d', 'LV', 3.28, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.e', 'IM', 3.94, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.e', 'LV', 4.84, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.f', 'IM', 3.25, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.f', 'LV', 3.97, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.2.a', 'IM', 2.81, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.2.a', 'LV', 3.53, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.2.b', 'IM', 1.16, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.2.b', 'LV', 0.38, 32, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.a', 'IM', 2.97, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.a', 'LV', 3.53, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.b', 'IM', 3.94, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.b', 'LV', 4.81, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.c', 'IM', 3.66, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.c', 'LV', 4.88, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.d', 'IM', 4.75, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.d', 'LV', 6.12, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.e', 'IM', 3.31, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.e', 'LV', 4.34, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.a', 'IM', 3.47, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.a', 'LV', 4.38, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.b', 'IM', 2.31, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.b', 'LV', 2.94, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.c', 'IM', 1.94, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.c', 'LV', 2.44, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.d', 'IM', 1.31, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.d', 'LV', 0.69, 32, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.e', 'IM', 2.31, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.e', 'LV', 2.84, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.f', 'IM', 1.50, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.f', 'LV', 0.84, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.g', 'IM', 1.62, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.g', 'LV', 1.53, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.5.a', 'IM', 1.34, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.5.a', 'LV', 0.75, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.5.b', 'IM', 1.44, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.5.b', 'LV', 1.19, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.6', 'IM', 2.50, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.6', 'LV', 3.22, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.a', 'IM', 3.66, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.a', 'LV', 4.25, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.b', 'IM', 1.44, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.b', 'LV', 0.97, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.c', 'IM', 1.12, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.c', 'LV', 0.31, 32, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.d', 'IM', 1.28, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.d', 'LV', 0.59, 32, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.e', 'IM', 1.28, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.e', 'LV', 0.72, 32, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.8.a', 'IM', 3.50, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.8.a', 'LV', 4.12, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.8.b', 'IM', 3.16, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.8.b', 'LV', 3.66, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.9.a', 'IM', 1.69, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.9.a', 'LV', 1.44, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.9.b', 'IM', 2.09, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.9.b', 'LV', 2.22, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.10', 'IM', 2.34, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.10', 'LV', 2.47, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.a', 'IM', 4.51, 22, 0.16, 4.19, 4.84, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.a', 'LV', 4.33, 22, 0.14, 4.03, 4.63, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.b', 'IM', 3.43, 22, 0.16, 3.10, 3.77, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.b', 'LV', 4.60, 22, 0.16, 4.28, 4.93, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.c', 'IM', 2.90, 22, 0.25, 2.38, 3.41, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.c', 'LV', 2.94, 21, 0.58, 1.72, 4.16, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.d', 'IM', 2.34, 22, 0.46, 1.38, 3.31, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.d', 'LV', 2.11, 22, 0.61, 0.83, 3.38, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.e', 'IM', 4.29, 22, 0.24, 3.79, 4.78, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.e', 'LV', 5.25, 22, 0.28, 4.66, 5.83, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.f', 'IM', 3.64, 22, 0.24, 3.15, 4.13, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.f', 'LV', 4.41, 22, 0.20, 4.01, 4.82, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.2.a', 'IM', 1.15, 22, 0.12, 1.00, 1.40, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.2.a', 'LV', 0.14, 22, 0.11, 0.00, 0.37, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.2.b', 'IM', 2.03, 22, 0.51, 1.00, 3.09, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.2.b', 'LV', 0.85, 22, 0.45, 0.00, 1.79, 'Y', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.a', 'IM', 2.38, 22, 0.25, 1.86, 2.90, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.a', 'LV', 3.23, 22, 0.50, 2.19, 4.28, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.b', 'IM', 1.06, 22, 0.06, 1.00, 1.18, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.b', 'LV', 0.11, 22, 0.09, 0.00, 0.31, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.c', 'IM', 1.30, 22, 0.23, 1.00, 1.78, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.c', 'LV', 0.53, 22, 0.36, 0.00, 1.28, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.d', 'IM', 1.05, 22, 0.05, 1.00, 1.16, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.d', 'LV', 0.09, 22, 0.09, 0.00, 0.27, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.e', 'IM', 1.25, 22, 0.13, 1.00, 1.53, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.e', 'LV', 0.62, 22, 0.36, 0.00, 1.36, 'Y', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.a', 'IM', 2.88, 22, 0.32, 2.21, 3.54, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.a', 'LV', 3.44, 21, 0.53, 2.34, 4.54, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.b', 'IM', 1.00, 22, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.b', 'LV', 0.00, 22, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.c', 'IM', 1.37, 22, 0.16, 1.04, 1.70, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.c', 'LV', 1.10, 22, 0.51, 0.04, 2.16, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.d', 'IM', 1.42, 22, 0.16, 1.09, 1.75, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.d', 'LV', 0.88, 22, 0.34, 0.17, 1.58, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.e', 'IM', 3.88, 22, 0.20, 3.46, 4.29, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.e', 'LV', 3.93, 22, 0.45, 2.99, 4.88, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.f', 'IM', 2.82, 22, 0.31, 2.18, 3.47, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.f', 'LV', 3.50, 22, 0.44, 2.58, 4.42, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.g', 'IM', 2.15, 22, 0.31, 1.50, 2.80, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.g', 'LV', 2.70, 22, 0.60, 1.44, 3.96, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.5.a', 'IM', 2.13, 22, 0.24, 1.62, 2.63, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.5.a', 'LV', 1.76, 22, 0.37, 1.00, 2.51, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.5.b', 'IM', 2.86, 22, 0.33, 2.17, 3.56, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.5.b', 'LV', 3.64, 22, 0.49, 2.61, 4.66, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.6', 'IM', 4.42, 22, 0.24, 3.92, 4.91, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.6', 'LV', 5.36, 22, 0.30, 4.75, 5.97, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.a', 'IM', 4.27, 22, 0.13, 4.00, 4.55, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.a', 'LV', 3.82, 22, 0.28, 3.25, 4.40, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.b', 'IM', 1.53, 22, 0.15, 1.22, 1.85, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.b', 'LV', 0.81, 22, 0.22, 0.35, 1.27, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.c', 'IM', 1.53, 22, 0.17, 1.17, 1.88, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.c', 'LV', 0.82, 22, 0.26, 0.28, 1.36, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.d', 'IM', 1.66, 22, 0.18, 1.29, 2.04, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.d', 'LV', 2.02, 22, 0.60, 0.78, 3.26, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.e', 'IM', 2.79, 22, 0.27, 2.23, 3.34, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.e', 'LV', 3.70, 22, 0.44, 2.79, 4.61, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.8.a', 'IM', 3.15, 22, 0.33, 2.46, 3.83, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.8.a', 'LV', 2.62, 21, 0.31, 1.97, 3.28, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.8.b', 'IM', 2.52, 22, 0.26, 1.98, 3.06, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.8.b', 'LV', 2.48, 22, 0.22, 2.01, 2.94, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.9.a', 'IM', 1.72, 22, 0.13, 1.46, 1.99, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.9.a', 'LV', 0.87, 22, 0.16, 0.52, 1.21, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.9.b', 'IM', 2.47, 22, 0.25, 1.96, 2.99, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.9.b', 'LV', 2.56, 22, 0.35, 1.83, 3.30, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.10', 'IM', 1.35, 22, 0.14, 1.05, 1.65, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.10', 'LV', 0.93, 22, 0.41, 0.07, 1.79, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.a', 'IM', 4.63, 29, 0.12, 4.38, 4.88, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.a', 'LV', 4.81, 29, 0.17, 4.46, 5.17, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.b', 'IM', 3.38, 29, 0.24, 2.90, 3.87, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.b', 'LV', 4.37, 29, 0.20, 3.96, 4.77, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.c', 'IM', 2.81, 29, 0.28, 2.24, 3.38, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.c', 'LV', 3.36, 29, 0.57, 2.20, 4.52, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.d', 'IM', 2.47, 29, 0.22, 2.03, 2.92, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.d', 'LV', 3.04, 29, 0.38, 2.26, 3.82, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.e', 'IM', 4.45, 29, 0.15, 4.15, 4.74, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.e', 'LV', 5.77, 29, 0.18, 5.40, 6.13, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.f', 'IM', 3.86, 29, 0.30, 3.25, 4.47, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.f', 'LV', 4.67, 29, 0.42, 3.82, 5.52, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.2.a', 'IM', 2.30, 29, 0.32, 1.64, 2.95, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.2.a', 'LV', 2.46, 29, 0.57, 1.29, 3.63, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.2.b', 'IM', 1.34, 29, 0.17, 1.00, 1.68, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.2.b', 'LV', 0.68, 29, 0.31, 0.04, 1.31, 'N', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.a', 'IM', 3.75, 29, 0.24, 3.25, 4.25, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.a', 'LV', 4.54, 29, 0.23, 4.07, 5.01, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.b', 'IM', 1.93, 29, 0.26, 1.40, 2.47, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.b', 'LV', 1.55, 29, 0.42, 0.69, 2.41, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.c', 'IM', 2.08, 29, 0.27, 1.53, 2.63, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.c', 'LV', 2.32, 29, 0.51, 1.28, 3.37, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.d', 'IM', 1.84, 29, 0.19, 1.45, 2.23, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.d', 'LV', 1.94, 29, 0.45, 1.02, 2.86, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.e', 'IM', 1.81, 29, 0.19, 1.42, 2.20, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.e', 'LV', 1.71, 29, 0.44, 0.82, 2.61, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.a', 'IM', 3.03, 29, 0.27, 2.48, 3.58, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.a', 'LV', 3.85, 29, 0.31, 3.21, 4.48, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.b', 'IM', 1.42, 29, 0.16, 1.09, 1.75, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.b', 'LV', 0.81, 29, 0.32, 0.15, 1.46, 'N', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.c', 'IM', 1.55, 29, 0.18, 1.18, 1.91, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.c', 'LV', 1.26, 29, 0.38, 0.48, 2.03, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.d', 'IM', 1.76, 28, 0.23, 1.28, 2.24, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.d', 'LV', 1.36, 28, 0.38, 0.58, 2.15, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.e', 'IM', 3.82, 28, 0.21, 3.38, 4.25, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.e', 'LV', 4.47, 28, 0.27, 3.91, 5.03, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.f', 'IM', 3.22, 28, 0.29, 2.63, 3.81, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.f', 'LV', 4.23, 28, 0.29, 3.63, 4.83, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.g', 'IM', 2.16, 28, 0.26, 1.63, 2.69, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.g', 'LV', 2.65, 28, 0.55, 1.52, 3.78, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.5.a', 'IM', 2.00, 29, 0.21, 1.58, 2.42, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.5.a', 'LV', 1.74, 29, 0.34, 1.03, 2.44, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.5.b', 'IM', 3.19, 29, 0.28, 2.61, 3.76, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.5.b', 'LV', 4.52, 29, 0.49, 3.52, 5.52, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.6', 'IM', 4.69, 29, 0.12, 4.44, 4.94, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.6', 'LV', 6.35, 28, 0.19, 5.97, 6.73, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.a', 'IM', 4.73, 29, 0.09, 4.54, 4.92, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.a', 'LV', 5.65, 29, 0.26, 5.12, 6.18, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.b', 'IM', 2.33, 29, 0.37, 1.57, 3.09, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.b', 'LV', 2.14, 29, 0.56, 0.98, 3.29, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.c', 'IM', 2.65, 29, 0.33, 1.98, 3.32, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.c', 'LV', 2.64, 29, 0.51, 1.60, 3.68, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.d', 'IM', 2.50, 29, 0.31, 1.87, 3.13, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.d', 'LV', 3.03, 29, 0.50, 2.01, 4.05, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.e', 'IM', 2.92, 29, 0.26, 2.40, 3.44, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.e', 'LV', 3.99, 29, 0.37, 3.22, 4.75, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.8.a', 'IM', 4.02, 29, 0.28, 3.46, 4.59, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.8.a', 'LV', 4.19, 29, 0.31, 3.55, 4.83, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.8.b', 'IM', 3.60, 28, 0.29, 3.00, 4.20, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.8.b', 'LV', 3.63, 29, 0.30, 3.01, 4.25, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.9.a', 'IM', 2.39, 29, 0.28, 1.82, 2.96, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.9.a', 'LV', 1.88, 29, 0.57, 0.72, 3.05, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.9.b', 'IM', 3.73, 29, 0.26, 3.20, 4.26, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.9.b', 'LV', 3.58, 29, 0.29, 2.98, 4.18, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.10', 'IM', 2.26, 29, 0.27, 1.71, 2.80, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.10', 'LV', 1.93, 29, 0.37, 1.17, 2.69, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.a', 'IM', 4.27, 28, 0.22, 3.81, 4.73, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.a', 'LV', 4.56, 28, 0.19, 4.17, 4.95, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.b', 'IM', 2.94, 29, 0.53, 1.84, 4.03, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.b', 'LV', 3.85, 29, 0.67, 2.47, 5.23, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.c', 'IM', 2.32, 29, 0.23, 1.85, 2.80, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.c', 'LV', 2.27, 29, 0.48, 1.30, 3.24, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.d', 'IM', 2.76, 29, 0.22, 2.31, 3.20, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.d', 'LV', 3.90, 29, 0.37, 3.15, 4.66, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.e', 'IM', 4.36, 29, 0.17, 4.02, 4.70, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.e', 'LV', 5.37, 29, 0.23, 4.90, 5.85, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.f', 'IM', 3.84, 29, 0.18, 3.48, 4.21, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.f', 'LV', 4.44, 29, 0.18, 4.07, 4.82, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.2.a', 'IM', 1.90, 29, 0.33, 1.21, 2.58, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.2.a', 'LV', 1.30, 29, 0.57, 0.13, 2.47, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.2.b', 'IM', 1.05, 29, 0.04, 1.00, 1.14, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.2.b', 'LV', 0.11, 29, 0.09, 0.00, 0.28, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.a', 'IM', 3.03, 28, 0.35, 2.31, 3.75, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.a', 'LV', 3.51, 28, 0.50, 2.48, 4.54, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.b', 'IM', 1.53, 29, 0.14, 1.24, 1.81, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.b', 'LV', 1.14, 29, 0.37, 0.38, 1.89, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.c', 'IM', 1.42, 29, 0.17, 1.08, 1.76, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.c', 'LV', 0.88, 29, 0.31, 0.24, 1.53, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.d', 'IM', 1.54, 29, 0.29, 1.00, 2.13, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.d', 'LV', 1.22, 29, 0.68, 0.00, 2.61, 'Y', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.e', 'IM', 1.28, 29, 0.11, 1.04, 1.51, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.e', 'LV', 0.49, 29, 0.19, 0.10, 0.89, 'N', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.a', 'IM', 2.82, 29, 0.21, 2.39, 3.24, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.a', 'LV', 3.44, 29, 0.26, 2.91, 3.96, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.b', 'IM', 1.12, 29, 0.06, 1.00, 1.23, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.b', 'LV', 0.27, 29, 0.12, 0.02, 0.51, 'N', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.c', 'IM', 1.10, 29, 0.04, 1.01, 1.19, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.c', 'LV', 0.22, 29, 0.10, 0.02, 0.42, 'N', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.d', 'IM', 1.11, 29, 0.06, 1.00, 1.22, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.d', 'LV', 0.17, 29, 0.08, 0.00, 0.34, 'N', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.e', 'IM', 3.80, 29, 0.18, 3.42, 4.17, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.e', 'LV', 4.73, 29, 0.29, 4.14, 5.32, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.f', 'IM', 3.35, 29, 0.38, 2.56, 4.13, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.f', 'LV', 4.35, 29, 0.40, 3.53, 5.17, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.g', 'IM', 1.69, 29, 0.21, 1.26, 2.13, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.g', 'LV', 1.38, 29, 0.30, 0.76, 1.99, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.5.a', 'IM', 1.58, 29, 0.21, 1.16, 2.00, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.5.a', 'LV', 0.98, 29, 0.44, 0.07, 1.89, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.5.b', 'IM', 3.67, 29, 0.26, 3.15, 4.19, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.5.b', 'LV', 4.52, 29, 0.50, 3.49, 5.55, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.6', 'IM', 3.92, 29, 0.29, 3.33, 4.51, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.6', 'LV', 5.57, 29, 0.25, 5.06, 6.08, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.a', 'IM', 4.24, 29, 0.21, 3.81, 4.67, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.a', 'LV', 5.52, 29, 0.28, 4.95, 6.09, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.b', 'IM', 1.62, 29, 0.18, 1.24, 1.99, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.b', 'LV', 1.11, 29, 0.30, 0.49, 1.73, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.c', 'IM', 1.29, 29, 0.17, 1.00, 1.63, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.c', 'LV', 0.37, 29, 0.17, 0.01, 0.72, 'N', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.d', 'IM', 1.87, 29, 0.41, 1.04, 2.71, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.d', 'LV', 1.71, 29, 0.73, 0.22, 3.20, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.e', 'IM', 2.77, 29, 0.50, 1.75, 3.78, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.e', 'LV', 3.41, 29, 0.57, 2.25, 4.58, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.8.a', 'IM', 2.25, 29, 0.21, 1.82, 2.68, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.8.a', 'LV', 2.09, 29, 0.17, 1.74, 2.43, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.8.b', 'IM', 2.81, 29, 0.50, 1.78, 3.85, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.8.b', 'LV', 2.87, 29, 0.79, 1.25, 4.50, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.9.a', 'IM', 1.76, 29, 0.23, 1.29, 2.23, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.9.a', 'LV', 1.12, 29, 0.32, 0.46, 1.78, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.9.b', 'IM', 3.27, 29, 0.34, 2.58, 3.97, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.9.b', 'LV', 3.54, 29, 0.63, 2.26, 4.82, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.10', 'IM', 1.58, 29, 0.20, 1.17, 1.98, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.10', 'LV', 1.00, 29, 0.36, 0.27, 1.73, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.a', 'IM', 3.89, 58, 0.13, 3.63, 4.14, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.a', 'LV', 4.51, 58, 0.10, 4.31, 4.71, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.b', 'IM', 2.49, 58, 0.27, 1.95, 3.03, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.b', 'LV', 2.78, 58, 0.49, 1.81, 3.76, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.c', 'IM', 2.89, 58, 0.14, 2.61, 3.17, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.c', 'LV', 3.01, 58, 0.16, 2.69, 3.32, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.d', 'IM', 2.95, 58, 0.17, 2.62, 3.29, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.d', 'LV', 3.53, 58, 0.30, 2.93, 4.13, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.e', 'IM', 3.48, 58, 0.25, 2.97, 3.98, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.e', 'LV', 3.94, 58, 0.51, 2.92, 4.96, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.f', 'IM', 3.22, 58, 0.23, 2.77, 3.68, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.f', 'LV', 3.74, 58, 0.28, 3.19, 4.30, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.2.a', 'IM', 3.29, 58, 0.32, 2.64, 3.94, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.2.a', 'LV', 3.75, 58, 0.42, 2.91, 4.59, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.2.b', 'IM', 1.01, 58, 0.01, 1.00, 1.02, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.2.b', 'LV', 0.02, 58, 0.01, 0.00, 0.05, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.a', 'IM', 4.05, 58, 0.16, 3.73, 4.37, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.a', 'LV', 5.29, 58, 0.22, 4.85, 5.73, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.b', 'IM', 4.80, 58, 0.08, 4.64, 4.97, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.b', 'LV', 6.37, 57, 0.16, 6.05, 6.70, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.c', 'IM', 4.19, 58, 0.26, 3.66, 4.71, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.c', 'LV', 5.91, 58, 0.28, 5.34, 6.48, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.d', 'IM', 3.09, 58, 0.36, 2.38, 3.80, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.d', 'LV', 4.11, 58, 0.66, 2.79, 5.44, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.e', 'IM', 3.12, 58, 0.29, 2.55, 3.69, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.e', 'LV', 3.86, 58, 0.43, 3.00, 4.72, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.a', 'IM', 4.18, 58, 0.23, 3.72, 4.65, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.a', 'LV', 5.28, 58, 0.23, 4.81, 5.75, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.b', 'IM', 3.53, 57, 0.19, 3.15, 3.91, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.b', 'LV', 4.46, 58, 0.20, 4.06, 4.87, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.c', 'IM', 2.42, 58, 0.26, 1.89, 2.95, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.c', 'LV', 2.87, 58, 0.50, 1.86, 3.88, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.d', 'IM', 1.30, 57, 0.12, 1.05, 1.54, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.d', 'LV', 0.75, 57, 0.31, 0.13, 1.37, 'N', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.e', 'IM', 2.40, 57, 0.22, 1.97, 2.83, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.e', 'LV', 2.94, 57, 0.25, 2.43, 3.45, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.f', 'IM', 1.73, 57, 0.17, 1.39, 2.06, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.f', 'LV', 1.56, 57, 0.33, 0.91, 2.21, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.g', 'IM', 2.07, 57, 0.14, 1.80, 2.35, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.g', 'LV', 2.91, 57, 0.45, 2.01, 3.82, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.5.a', 'IM', 1.11, 58, 0.06, 1.00, 1.22, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.5.a', 'LV', 0.18, 58, 0.08, 0.01, 0.35, 'N', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.5.b', 'IM', 1.52, 58, 0.20, 1.12, 1.91, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.5.b', 'LV', 0.98, 58, 0.33, 0.33, 1.64, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.6', 'IM', 3.16, 58, 0.18, 2.79, 3.52, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.6', 'LV', 4.30, 58, 0.21, 3.89, 4.72, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.a', 'IM', 4.18, 58, 0.20, 3.79, 4.58, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.a', 'LV', 4.42, 58, 0.28, 3.86, 4.99, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.b', 'IM', 1.50, 58, 0.15, 1.21, 1.80, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.b', 'LV', 1.09, 57, 0.34, 0.40, 1.78, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.c', 'IM', 1.09, 58, 0.05, 1.00, 1.20, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.c', 'LV', 0.19, 58, 0.11, 0.00, 0.40, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.d', 'IM', 1.22, 58, 0.10, 1.01, 1.43, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.d', 'LV', 0.49, 58, 0.21, 0.07, 0.91, 'N', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.e', 'IM', 1.39, 58, 0.13, 1.14, 1.64, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.e', 'LV', 0.77, 58, 0.23, 0.30, 1.23, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.8.a', 'IM', 3.18, 58, 0.35, 2.48, 3.87, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.8.a', 'LV', 3.58, 58, 0.37, 2.85, 4.31, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.8.b', 'IM', 2.96, 58, 0.34, 2.28, 3.64, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.8.b', 'LV', 3.15, 58, 0.35, 2.45, 3.85, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.9.a', 'IM', 2.63, 58, 0.23, 2.16, 3.10, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.9.a', 'LV', 3.05, 58, 0.61, 1.83, 4.27, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.9.b', 'IM', 2.59, 58, 0.18, 2.24, 2.94, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.9.b', 'LV', 2.10, 58, 0.23, 1.64, 2.56, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.10', 'IM', 2.26, 58, 0.21, 1.83, 2.68, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.10', 'LV', 2.24, 58, 0.31, 1.61, 2.86, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.a', 'IM', 3.93, 23, 0.19, 3.53, 4.33, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.a', 'LV', 4.29, 23, 0.27, 3.74, 4.85, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.b', 'IM', 2.60, 23, 0.32, 1.93, 3.27, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.b', 'LV', 3.13, 22, 0.57, 1.94, 4.32, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.c', 'IM', 2.62, 23, 0.35, 1.90, 3.34, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.c', 'LV', 2.58, 23, 0.55, 1.44, 3.72, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.d', 'IM', 3.37, 23, 0.23, 2.88, 3.85, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.d', 'LV', 4.08, 23, 0.39, 3.28, 4.89, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.e', 'IM', 3.97, 23, 0.17, 3.61, 4.33, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.e', 'LV', 4.70, 23, 0.37, 3.94, 5.46, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.f', 'IM', 3.47, 23, 0.22, 3.01, 3.94, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.f', 'LV', 4.25, 23, 0.43, 3.37, 5.14, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.2.a', 'IM', 3.63, 23, 0.23, 3.16, 4.10, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.2.a', 'LV', 3.91, 23, 0.43, 3.02, 4.81, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.2.b', 'IM', 3.25, 23, 0.31, 2.60, 3.90, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.2.b', 'LV', 3.96, 23, 0.41, 3.11, 4.81, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.a', 'IM', 2.18, 23, 0.33, 1.50, 2.87, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.a', 'LV', 2.24, 23, 0.56, 1.07, 3.40, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.b', 'IM', 1.80, 22, 0.21, 1.36, 2.24, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.b', 'LV', 1.47, 22, 0.35, 0.74, 2.20, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.c', 'IM', 1.61, 23, 0.24, 1.11, 2.10, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.c', 'LV', 1.06, 23, 0.40, 0.23, 1.89, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.d', 'IM', 1.87, 23, 0.35, 1.13, 2.60, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.d', 'LV', 1.52, 23, 0.61, 0.26, 2.78, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.e', 'IM', 2.17, 23, 0.24, 1.67, 2.67, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.e', 'LV', 2.08, 23, 0.50, 1.04, 3.12, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.a', 'IM', 2.67, 22, 0.28, 2.08, 3.25, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.a', 'LV', 3.31, 23, 0.37, 2.53, 4.08, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.b', 'IM', 1.72, 23, 0.36, 1.00, 2.46, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.b', 'LV', 0.88, 23, 0.44, 0.00, 1.79, 'Y', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.c', 'IM', 1.74, 23, 0.32, 1.09, 2.40, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.c', 'LV', 1.36, 22, 0.47, 0.37, 2.34, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.d', 'IM', 1.42, 23, 0.22, 1.00, 1.87, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.d', 'LV', 0.88, 22, 0.44, 0.00, 1.80, 'Y', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.e', 'IM', 2.60, 23, 0.27, 2.03, 3.17, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.e', 'LV', 3.01, 22, 0.53, 1.91, 4.12, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.f', 'IM', 2.02, 23, 0.35, 1.30, 2.74, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.f', 'LV', 1.37, 22, 0.49, 0.36, 2.38, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.g', 'IM', 1.93, 23, 0.42, 1.07, 2.79, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.g', 'LV', 1.49, 22, 0.59, 0.26, 2.72, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.5.a', 'IM', 1.92, 23, 0.27, 1.36, 2.48, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.5.a', 'LV', 1.59, 23, 0.52, 0.50, 2.67, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.5.b', 'IM', 1.90, 23, 0.34, 1.19, 2.62, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.5.b', 'LV', 1.74, 23, 0.58, 0.54, 2.95, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.6', 'IM', 3.58, 23, 0.29, 2.98, 4.18, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.6', 'LV', 4.78, 23, 0.44, 3.86, 5.69, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.a', 'IM', 3.25, 23, 0.34, 2.55, 3.95, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.a', 'LV', 3.41, 23, 0.54, 2.30, 4.53, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.b', 'IM', 2.20, 23, 0.37, 1.44, 2.95, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.b', 'LV', 1.69, 23, 0.52, 0.61, 2.77, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.c', 'IM', 1.62, 23, 0.35, 1.00, 2.34, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.c', 'LV', 0.91, 23, 0.50, 0.00, 1.95, 'Y', 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.d', 'IM', 1.55, 23, 0.32, 1.00, 2.21, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.d', 'LV', 0.91, 23, 0.44, 0.00, 1.83, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.e', 'IM', 1.59, 23, 0.31, 1.00, 2.24, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.e', 'LV', 1.11, 23, 0.38, 0.32, 1.89, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.8.a', 'IM', 2.91, 23, 0.34, 2.20, 3.62, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.8.a', 'LV', 2.89, 22, 0.55, 1.75, 4.02, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.8.b', 'IM', 2.72, 23, 0.40, 1.90, 3.55, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.8.b', 'LV', 2.47, 23, 0.58, 1.27, 3.68, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.9.a', 'IM', 2.42, 23, 0.39, 1.61, 3.24, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.9.a', 'LV', 1.69, 23, 0.56, 0.52, 2.86, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.9.b', 'IM', 2.24, 23, 0.32, 1.59, 2.90, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.9.b', 'LV', 2.54, 23, 0.76, 0.97, 4.11, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.10', 'IM', 2.73, 23, 0.43, 1.84, 3.63, 'N', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.10', 'LV', 2.18, 23, 0.60, 0.94, 3.42, 'N', 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.a', 'IM', 4.25, 33, 0.21, 3.81, 4.68, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.a', 'LV', 4.68, 32, 0.13, 4.42, 4.95, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.b', 'IM', 2.99, 34, 0.24, 2.50, 3.48, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.b', 'LV', 3.81, 33, 0.50, 2.79, 4.84, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.c', 'IM', 3.22, 33, 0.30, 2.60, 3.84, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.c', 'LV', 3.01, 33, 0.53, 1.93, 4.09, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.d', 'IM', 3.33, 34, 0.25, 2.83, 3.84, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.d', 'LV', 4.05, 34, 0.31, 3.42, 4.68, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.e', 'IM', 4.60, 34, 0.11, 4.37, 4.84, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.e', 'LV', 5.61, 34, 0.23, 5.14, 6.09, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.f', 'IM', 3.46, 34, 0.22, 3.00, 3.91, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.f', 'LV', 4.08, 33, 0.35, 3.36, 4.80, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.2.a', 'IM', 1.84, 34, 0.18, 1.47, 2.20, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.2.a', 'LV', 1.61, 34, 0.37, 0.86, 2.35, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.2.b', 'IM', 1.72, 33, 0.26, 1.18, 2.26, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.2.b', 'LV', 1.22, 33, 0.46, 0.29, 2.15, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.a', 'IM', 2.53, 33, 0.27, 1.98, 3.08, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.a', 'LV', 2.64, 33, 0.39, 1.86, 3.43, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.b', 'IM', 1.48, 33, 0.15, 1.17, 1.78, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.b', 'LV', 0.93, 33, 0.27, 0.38, 1.49, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.c', 'IM', 1.49, 33, 0.15, 1.18, 1.79, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.c', 'LV', 1.27, 33, 0.38, 0.49, 2.05, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.d', 'IM', 1.28, 33, 0.14, 1.00, 1.57, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.d', 'LV', 0.71, 33, 0.28, 0.14, 1.28, 'N', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.e', 'IM', 1.60, 33, 0.18, 1.24, 1.96, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.e', 'LV', 1.28, 33, 0.32, 0.62, 1.93, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.a', 'IM', 3.76, 33, 0.34, 3.07, 4.46, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.a', 'LV', 4.42, 33, 0.44, 3.52, 5.33, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.b', 'IM', 1.25, 32, 0.10, 1.06, 1.45, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.b', 'LV', 0.53, 32, 0.22, 0.08, 0.97, 'N', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.c', 'IM', 1.34, 32, 0.13, 1.08, 1.60, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.c', 'LV', 0.81, 32, 0.27, 0.26, 1.35, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.d', 'IM', 1.06, 33, 0.04, 1.00, 1.14, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.d', 'LV', 0.14, 32, 0.11, 0.00, 0.37, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.e', 'IM', 2.68, 34, 0.34, 1.99, 3.36, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.e', 'LV', 3.02, 34, 0.52, 1.96, 4.08, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.f', 'IM', 1.76, 33, 0.25, 1.25, 2.27, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.f', 'LV', 1.48, 33, 0.47, 0.53, 2.43, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.g', 'IM', 1.22, 33, 0.09, 1.03, 1.41, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.g', 'LV', 0.49, 33, 0.23, 0.03, 0.96, 'N', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.5.a', 'IM', 1.16, 33, 0.08, 1.00, 1.32, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.5.a', 'LV', 0.31, 33, 0.14, 0.03, 0.58, 'N', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.5.b', 'IM', 1.55, 34, 0.21, 1.14, 1.97, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.5.b', 'LV', 1.02, 34, 0.36, 0.28, 1.75, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.6', 'IM', 3.37, 34, 0.24, 2.88, 3.87, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.6', 'LV', 4.04, 33, 0.36, 3.31, 4.77, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.a', 'IM', 3.68, 33, 0.11, 3.45, 3.91, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.a', 'LV', 3.90, 33, 0.30, 3.28, 4.52, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.b', 'IM', 1.60, 33, 0.16, 1.27, 1.92, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.b', 'LV', 0.78, 33, 0.20, 0.37, 1.20, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.c', 'IM', 1.09, 33, 0.05, 1.00, 1.20, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.c', 'LV', 0.21, 33, 0.12, 0.00, 0.46, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.d', 'IM', 1.20, 33, 0.09, 1.02, 1.39, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.d', 'LV', 0.52, 33, 0.23, 0.06, 0.98, 'N', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.e', 'IM', 1.63, 33, 0.16, 1.30, 1.96, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.e', 'LV', 1.42, 33, 0.38, 0.65, 2.19, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.8.a', 'IM', 3.19, 34, 0.26, 2.67, 3.71, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.8.a', 'LV', 3.15, 34, 0.29, 2.57, 3.74, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.8.b', 'IM', 2.95, 34, 0.28, 2.38, 3.53, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.8.b', 'LV', 2.83, 34, 0.39, 2.04, 3.61, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.9.a', 'IM', 1.55, 34, 0.14, 1.28, 1.83, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.9.a', 'LV', 0.89, 34, 0.23, 0.42, 1.36, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.9.b', 'IM', 2.07, 33, 0.23, 1.59, 2.55, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.9.b', 'LV', 1.82, 33, 0.31, 1.19, 2.44, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.10', 'IM', 1.56, 32, 0.17, 1.22, 1.90, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.10', 'LV', 1.21, 33, 0.36, 0.48, 1.94, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.a', 'IM', 4.49, 20, 0.11, 4.26, 4.72, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.a', 'LV', 4.47, 19, 0.15, 4.14, 4.79, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.b', 'IM', 3.78, 19, 0.25, 3.26, 4.30, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.b', 'LV', 4.77, 20, 0.39, 3.96, 5.57, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.c', 'IM', 3.69, 20, 0.28, 3.11, 4.27, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.c', 'LV', 3.10, 20, 0.33, 2.40, 3.80, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.d', 'IM', 3.96, 20, 0.29, 3.35, 4.58, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.d', 'LV', 4.36, 20, 0.24, 3.84, 4.87, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.e', 'IM', 4.69, 20, 0.14, 4.40, 4.98, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.e', 'LV', 4.56, 20, 0.35, 3.82, 5.30, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.f', 'IM', 3.85, 20, 0.25, 3.33, 4.37, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.f', 'LV', 4.10, 20, 0.32, 3.43, 4.77, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.2.a', 'IM', 2.58, 20, 0.39, 1.75, 3.41, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.2.a', 'LV', 2.47, 20, 0.64, 1.13, 3.82, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.2.b', 'IM', 1.45, 20, 0.21, 1.01, 1.88, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.2.b', 'LV', 0.68, 20, 0.32, 0.02, 1.34, 'N', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.a', 'IM', 3.55, 20, 0.29, 2.94, 4.15, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.a', 'LV', 4.33, 20, 0.33, 3.64, 5.01, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.b', 'IM', 2.57, 20, 0.29, 1.95, 3.18, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.b', 'LV', 1.93, 20, 0.40, 1.09, 2.76, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.c', 'IM', 1.89, 20, 0.30, 1.27, 2.50, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.c', 'LV', 1.59, 20, 0.39, 0.78, 2.40, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.d', 'IM', 2.00, 20, 0.35, 1.27, 2.73, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.d', 'LV', 1.96, 20, 0.64, 0.63, 3.29, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.e', 'IM', 2.05, 20, 0.25, 1.54, 2.57, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.e', 'LV', 1.80, 20, 0.46, 0.84, 2.76, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.a', 'IM', 4.00, 20, 0.26, 3.44, 4.55, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.a', 'LV', 4.17, 20, 0.28, 3.60, 4.75, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.b', 'IM', 1.50, 20, 0.20, 1.09, 1.91, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.b', 'LV', 0.88, 20, 0.32, 0.20, 1.56, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.c', 'IM', 1.92, 20, 0.28, 1.33, 2.51, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.c', 'LV', 1.79, 20, 0.50, 0.75, 2.84, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.d', 'IM', 1.28, 20, 0.20, 1.00, 1.69, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.d', 'LV', 0.60, 20, 0.40, 0.00, 1.45, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.e', 'IM', 2.37, 20, 0.38, 1.58, 3.16, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.e', 'LV', 2.63, 20, 0.58, 1.41, 3.84, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.f', 'IM', 1.37, 20, 0.16, 1.04, 1.70, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.f', 'LV', 0.61, 20, 0.24, 0.12, 1.11, 'N', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.g', 'IM', 2.78, 20, 0.23, 2.30, 3.25, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.g', 'LV', 3.70, 20, 0.29, 3.10, 4.31, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.5.a', 'IM', 1.58, 20, 0.15, 1.27, 1.89, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.5.a', 'LV', 1.12, 20, 0.39, 0.30, 1.95, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.5.b', 'IM', 1.94, 20, 0.26, 1.40, 2.49, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.5.b', 'LV', 1.88, 20, 0.41, 1.02, 2.73, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.6', 'IM', 3.28, 20, 0.40, 2.44, 4.12, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.6', 'LV', 3.71, 20, 0.54, 2.57, 4.84, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.a', 'IM', 4.06, 20, 0.23, 3.58, 4.54, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.a', 'LV', 3.59, 19, 0.26, 3.04, 4.14, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.b', 'IM', 2.30, 20, 0.31, 1.65, 2.96, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.b', 'LV', 1.84, 20, 0.42, 0.96, 2.72, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.c', 'IM', 1.61, 20, 0.22, 1.16, 2.07, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.c', 'LV', 1.01, 20, 0.35, 0.28, 1.74, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.d', 'IM', 1.68, 20, 0.26, 1.15, 2.22, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.d', 'LV', 1.46, 20, 0.46, 0.49, 2.43, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.e', 'IM', 1.94, 20, 0.29, 1.33, 2.54, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.e', 'LV', 2.16, 20, 0.55, 1.01, 3.31, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.8.a', 'IM', 3.33, 20, 0.28, 2.75, 3.91, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.8.a', 'LV', 3.29, 20, 0.31, 2.63, 3.95, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.8.b', 'IM', 2.73, 20, 0.29, 2.11, 3.34, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.8.b', 'LV', 2.55, 20, 0.43, 1.66, 3.45, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.9.a', 'IM', 3.05, 20, 0.34, 2.34, 3.76, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.9.a', 'LV', 2.48, 19, 0.65, 1.11, 3.85, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.9.b', 'IM', 2.66, 20, 0.36, 1.91, 3.40, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.9.b', 'LV', 2.27, 20, 0.37, 1.49, 3.04, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.10', 'IM', 2.34, 20, 0.38, 1.55, 3.13, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.10', 'LV', 2.24, 20, 0.44, 1.31, 3.17, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.a', 'IM', 4.69, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.a', 'LV', 5.61, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.b', 'IM', 3.00, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.b', 'LV', 4.25, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.c', 'IM', 3.86, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.c', 'LV', 4.86, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.d', 'IM', 3.07, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.d', 'LV', 4.28, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.e', 'IM', 4.29, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.e', 'LV', 5.54, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.f', 'IM', 4.07, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.f', 'LV', 4.93, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.2.a', 'IM', 2.41, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.2.a', 'LV', 2.82, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.2.b', 'IM', 1.39, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.2.b', 'LV', 0.97, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.a', 'IM', 3.03, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.a', 'LV', 3.76, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.b', 'IM', 1.93, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.b', 'LV', 1.59, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.c', 'IM', 1.76, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.c', 'LV', 1.57, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.d', 'IM', 1.93, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.d', 'LV', 2.11, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.e', 'IM', 1.83, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.e', 'LV', 1.64, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.a', 'IM', 3.21, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.a', 'LV', 4.10, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.b', 'IM', 1.28, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.b', 'LV', 0.45, 29, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.c', 'IM', 1.62, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.c', 'LV', 1.07, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.d', 'IM', 1.90, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.d', 'LV', 1.68, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.e', 'IM', 3.28, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.e', 'LV', 3.93, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.f', 'IM', 3.00, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.f', 'LV', 3.44, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.g', 'IM', 1.44, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.g', 'LV', 1.11, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.5.a', 'IM', 3.55, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.5.a', 'LV', 3.38, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.5.b', 'IM', 2.64, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.5.b', 'LV', 2.93, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.6', 'IM', 3.04, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.6', 'LV', 4.21, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.a', 'IM', 4.14, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.a', 'LV', 4.82, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.b', 'IM', 1.89, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.b', 'LV', 1.36, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.c', 'IM', 1.41, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.c', 'LV', 0.69, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.d', 'IM', 1.64, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.d', 'LV', 1.43, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.e', 'IM', 1.93, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.e', 'LV', 2.28, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.8.a', 'IM', 3.10, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.8.a', 'LV', 3.41, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.8.b', 'IM', 3.79, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.8.b', 'LV', 4.24, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.9.a', 'IM', 2.55, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.9.a', 'LV', 1.64, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.9.b', 'IM', 3.00, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.9.b', 'LV', 3.21, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.10', 'IM', 1.69, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.10', 'LV', 1.52, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.a', 'IM', 3.38, 25, 0.25, 2.86, 3.90, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.a', 'LV', 4.64, 25, 0.28, 4.07, 5.20, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.b', 'IM', 2.18, 25, 0.26, 1.65, 2.71, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.b', 'LV', 2.62, 25, 0.63, 1.33, 3.91, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.c', 'IM', 2.13, 25, 0.29, 1.53, 2.73, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.c', 'LV', 2.04, 25, 0.55, 0.89, 3.18, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.d', 'IM', 2.13, 25, 0.23, 1.66, 2.60, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.d', 'LV', 2.78, 25, 0.49, 1.76, 3.79, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.e', 'IM', 3.21, 24, 0.42, 2.33, 4.08, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.e', 'LV', 4.57, 24, 0.84, 2.84, 6.30, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.f', 'IM', 2.81, 24, 0.39, 2.01, 3.60, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.f', 'LV', 3.23, 24, 0.62, 1.94, 4.52, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.2.a', 'IM', 2.89, 24, 0.44, 1.97, 3.80, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.2.a', 'LV', 3.55, 24, 0.70, 2.11, 4.99, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.2.b', 'IM', 1.21, 24, 0.18, 1.00, 1.58, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.2.b', 'LV', 0.31, 24, 0.23, 0.00, 0.79, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.a', 'IM', 3.10, 25, 0.30, 2.48, 3.72, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.a', 'LV', 3.95, 25, 0.25, 3.44, 4.46, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.b', 'IM', 3.28, 25, 0.31, 2.63, 3.93, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.b', 'LV', 4.10, 25, 0.49, 3.08, 5.12, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.c', 'IM', 1.93, 25, 0.35, 1.20, 2.66, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.c', 'LV', 1.75, 25, 0.61, 0.48, 3.01, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.d', 'IM', 1.94, 25, 0.30, 1.33, 2.56, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.d', 'LV', 2.05, 25, 0.60, 0.82, 3.28, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.e', 'IM', 2.22, 25, 0.31, 1.59, 2.85, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.e', 'LV', 2.27, 25, 0.54, 1.15, 3.40, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.a', 'IM', 3.39, 25, 0.25, 2.87, 3.90, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.a', 'LV', 4.55, 25, 0.33, 3.88, 5.22, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.b', 'IM', 2.53, 25, 0.36, 1.79, 3.27, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.b', 'LV', 3.00, 25, 0.67, 1.62, 4.38, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.c', 'IM', 3.64, 25, 0.33, 2.96, 4.32, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.c', 'LV', 4.53, 25, 0.58, 3.34, 5.72, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.d', 'IM', 3.37, 25, 0.24, 2.88, 3.87, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.d', 'LV', 4.16, 25, 0.34, 3.46, 4.86, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.e', 'IM', 2.23, 25, 0.26, 1.69, 2.77, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.e', 'LV', 2.52, 25, 0.48, 1.53, 3.51, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.f', 'IM', 1.57, 25, 0.18, 1.19, 1.94, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.f', 'LV', 1.06, 25, 0.34, 0.36, 1.75, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.g', 'IM', 2.27, 25, 0.35, 1.53, 3.00, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.g', 'LV', 2.69, 25, 0.74, 1.16, 4.22, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.5.a', 'IM', 1.77, 25, 0.42, 1.00, 2.64, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.5.a', 'LV', 1.14, 25, 0.56, 0.00, 2.30, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.5.b', 'IM', 1.35, 25, 0.16, 1.03, 1.68, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.5.b', 'LV', 0.80, 25, 0.33, 0.13, 1.47, 'N', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.6', 'IM', 2.63, 25, 0.25, 2.11, 3.15, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.6', 'LV', 3.99, 25, 0.30, 3.38, 4.61, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.a', 'IM', 3.45, 25, 0.40, 2.61, 4.28, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.a', 'LV', 4.05, 25, 0.59, 2.83, 5.27, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.b', 'IM', 1.28, 24, 0.17, 1.00, 1.64, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.b', 'LV', 0.59, 24, 0.36, 0.00, 1.34, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.c', 'IM', 1.16, 24, 0.10, 1.00, 1.37, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.c', 'LV', 0.33, 24, 0.20, 0.00, 0.74, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.d', 'IM', 1.69, 25, 0.22, 1.24, 2.14, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.d', 'LV', 1.65, 25, 0.49, 0.64, 2.67, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.e', 'IM', 1.25, 25, 0.10, 1.04, 1.46, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.e', 'LV', 0.66, 25, 0.28, 0.09, 1.24, 'N', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.8.a', 'IM', 2.44, 25, 0.34, 1.74, 3.14, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.8.a', 'LV', 2.81, 25, 0.57, 1.64, 3.97, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.8.b', 'IM', 3.47, 25, 0.28, 2.89, 4.05, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.8.b', 'LV', 4.13, 24, 0.32, 3.46, 4.80, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.9.a', 'IM', 1.77, 25, 0.24, 1.27, 2.26, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.9.a', 'LV', 1.43, 25, 0.46, 0.48, 2.38, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.9.b', 'IM', 2.70, 25, 0.34, 2.00, 3.40, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.9.b', 'LV', 3.01, 25, 0.58, 1.80, 4.22, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.10', 'IM', 1.76, 25, 0.22, 1.30, 2.22, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.10', 'LV', 1.55, 25, 0.40, 0.72, 2.39, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.a', 'IM', 4.22, 24, 0.24, 3.72, 4.71, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.a', 'LV', 4.15, 24, 0.17, 3.79, 4.51, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.b', 'IM', 3.67, 24, 0.22, 3.20, 4.13, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.b', 'LV', 4.44, 24, 0.33, 3.75, 5.13, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.c', 'IM', 2.86, 24, 0.35, 2.15, 3.57, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.c', 'LV', 3.20, 23, 0.60, 1.95, 4.45, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.d', 'IM', 2.16, 24, 0.25, 1.64, 2.68, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.d', 'LV', 2.14, 24, 0.42, 1.27, 3.02, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.e', 'IM', 4.09, 24, 0.23, 3.62, 4.56, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.e', 'LV', 4.86, 24, 0.31, 4.22, 5.49, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.f', 'IM', 3.37, 24, 0.23, 2.90, 3.85, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.f', 'LV', 3.85, 24, 0.33, 3.16, 4.54, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.2.a', 'IM', 3.88, 24, 0.21, 3.46, 4.31, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.2.a', 'LV', 4.52, 24, 0.31, 3.87, 5.16, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.2.b', 'IM', 1.11, 24, 0.09, 1.00, 1.29, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.2.b', 'LV', 0.25, 24, 0.19, 0.00, 0.64, 'Y', 'Y', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.a', 'IM', 3.22, 24, 0.23, 2.74, 3.70, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.a', 'LV', 4.12, 24, 0.21, 3.69, 4.55, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.b', 'IM', 1.61, 24, 0.18, 1.24, 1.97, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.b', 'LV', 1.42, 24, 0.43, 0.54, 2.31, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.c', 'IM', 1.33, 24, 0.16, 1.00, 1.67, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.c', 'LV', 0.53, 24, 0.27, 0.00, 1.08, 'Y', 'Y', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.d', 'IM', 1.14, 24, 0.10, 1.00, 1.35, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.d', 'LV', 0.26, 24, 0.18, 0.00, 0.64, 'Y', 'Y', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.e', 'IM', 1.63, 24, 0.20, 1.22, 2.04, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.e', 'LV', 1.20, 24, 0.39, 0.39, 2.00, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.a', 'IM', 3.17, 24, 0.19, 2.77, 3.57, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.a', 'LV', 3.63, 24, 0.20, 3.21, 4.04, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.b', 'IM', 1.24, 24, 0.13, 1.00, 1.50, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.b', 'LV', 0.55, 24, 0.28, 0.00, 1.12, 'Y', 'Y', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.c', 'IM', 1.39, 24, 0.16, 1.06, 1.72, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.c', 'LV', 0.90, 24, 0.38, 0.12, 1.68, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.d', 'IM', 1.25, 24, 0.18, 1.00, 1.62, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.d', 'LV', 0.45, 24, 0.32, 0.00, 1.12, 'Y', 'Y', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.e', 'IM', 3.25, 24, 0.15, 2.93, 3.56, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.e', 'LV', 3.70, 24, 0.23, 3.22, 4.17, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.f', 'IM', 2.16, 24, 0.27, 1.60, 2.73, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.f', 'LV', 2.06, 23, 0.49, 1.04, 3.07, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.g', 'IM', 1.76, 24, 0.23, 1.29, 2.23, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.g', 'LV', 1.70, 24, 0.44, 0.80, 2.60, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.5.a', 'IM', 1.33, 24, 0.13, 1.06, 1.59, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.5.a', 'LV', 0.63, 24, 0.24, 0.13, 1.12, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.5.b', 'IM', 1.96, 24, 0.26, 1.42, 2.50, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.5.b', 'LV', 2.16, 24, 0.57, 0.99, 3.34, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.6', 'IM', 3.43, 24, 0.22, 2.98, 3.88, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.6', 'LV', 4.56, 24, 0.35, 3.84, 5.28, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.a', 'IM', 4.03, 24, 0.16, 3.70, 4.35, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.a', 'LV', 4.10, 24, 0.24, 3.60, 4.59, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.b', 'IM', 1.23, 24, 0.10, 1.03, 1.43, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.b', 'LV', 0.35, 24, 0.16, 0.02, 0.68, 'N', 'Y', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.c', 'IM', 1.09, 24, 0.09, 1.00, 1.26, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.c', 'LV', 0.09, 24, 0.09, 0.00, 0.26, 'Y', 'Y', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.d', 'IM', 1.34, 24, 0.18, 1.00, 1.72, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.d', 'LV', 0.74, 24, 0.39, 0.00, 1.54, 'Y', 'Y', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.e', 'IM', 1.71, 24, 0.20, 1.29, 2.13, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.e', 'LV', 1.65, 24, 0.48, 0.65, 2.64, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.8.a', 'IM', 3.87, 24, 0.25, 3.35, 4.39, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.8.a', 'LV', 4.10, 24, 0.22, 3.64, 4.56, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.8.b', 'IM', 2.20, 24, 0.29, 1.60, 2.81, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.8.b', 'LV', 1.81, 24, 0.43, 0.93, 2.70, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.9.a', 'IM', 2.02, 24, 0.22, 1.56, 2.49, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.9.a', 'LV', 1.24, 24, 0.31, 0.61, 1.88, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.9.b', 'IM', 2.52, 24, 0.18, 2.14, 2.90, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.9.b', 'LV', 2.88, 24, 0.30, 2.26, 3.49, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.10', 'IM', 2.29, 24, 0.30, 1.66, 2.92, 'N', NULL, TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.10', 'LV', 1.94, 24, 0.45, 1.01, 2.88, 'N', 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.a', 'IM', 4.04, 18, 0.43, 3.13, 4.94, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.a', 'LV', 4.47, 18, 0.56, 3.29, 5.64, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.b', 'IM', 3.67, 18, 0.41, 2.80, 4.54, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.b', 'LV', 5.21, 18, 0.68, 3.77, 6.65, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.c', 'IM', 3.27, 18, 0.39, 2.44, 4.09, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.c', 'LV', 3.95, 18, 0.79, 2.29, 5.62, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.d', 'IM', 4.03, 18, 0.40, 3.18, 4.88, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.d', 'LV', 4.45, 18, 0.31, 3.80, 5.11, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.e', 'IM', 4.21, 18, 0.22, 3.74, 4.68, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.e', 'LV', 5.22, 18, 0.43, 4.33, 6.12, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.f', 'IM', 2.98, 18, 0.44, 2.04, 3.91, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.f', 'LV', 3.55, 18, 0.59, 2.30, 4.79, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.2.a', 'IM', 2.17, 18, 0.48, 1.17, 3.17, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.2.a', 'LV', 1.79, 18, 0.68, 0.35, 3.22, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.2.b', 'IM', 1.41, 18, 0.36, 1.00, 2.16, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.2.b', 'LV', 0.81, 18, 0.72, 0.00, 2.33, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.a', 'IM', 2.74, 18, 0.42, 1.85, 3.63, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.a', 'LV', 3.17, 18, 0.53, 2.06, 4.28, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.b', 'IM', 1.64, 18, 0.54, 1.00, 2.77, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.b', 'LV', 1.11, 18, 0.89, 0.00, 2.99, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.c', 'IM', 1.37, 18, 0.20, 1.00, 1.79, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.c', 'LV', 0.93, 18, 0.56, 0.00, 2.11, 'Y', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.d', 'IM', 2.78, 18, 0.46, 1.81, 3.76, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.d', 'LV', 2.86, 18, 0.77, 1.24, 4.49, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.e', 'IM', 1.53, 18, 0.26, 1.00, 2.09, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.e', 'LV', 0.81, 18, 0.39, 0.00, 1.63, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.a', 'IM', 3.49, 18, 0.33, 2.80, 4.18, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.a', 'LV', 3.27, 18, 0.43, 2.36, 4.18, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.b', 'IM', 1.36, 18, 0.18, 1.00, 1.74, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.b', 'LV', 0.90, 18, 0.51, 0.00, 1.98, 'Y', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.c', 'IM', 1.11, 18, 0.09, 1.00, 1.30, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.c', 'LV', 0.17, 18, 0.12, 0.00, 0.43, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.d', 'IM', 1.03, 18, 0.03, 1.00, 1.09, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.d', 'LV', 0.09, 18, 0.09, 0.00, 0.28, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.e', 'IM', 1.81, 18, 0.21, 1.38, 2.25, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.e', 'LV', 1.87, 18, 0.53, 0.75, 2.98, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.f', 'IM', 1.70, 18, 0.29, 1.09, 2.31, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.f', 'LV', 1.24, 18, 0.55, 0.07, 2.41, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.g', 'IM', 1.22, 18, 0.15, 1.00, 1.54, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.g', 'LV', 0.44, 18, 0.30, 0.00, 1.08, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.5.a', 'IM', 1.03, 18, 0.03, 1.00, 1.09, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.5.a', 'LV', 0.06, 18, 0.06, 0.00, 0.19, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.5.b', 'IM', 1.19, 18, 0.14, 1.00, 1.48, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.5.b', 'LV', 0.40, 18, 0.29, 0.00, 1.01, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.6', 'IM', 1.83, 18, 0.32, 1.16, 2.50, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.6', 'LV', 1.54, 18, 0.55, 0.37, 2.70, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.a', 'IM', 3.59, 18, 0.32, 2.92, 4.27, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.a', 'LV', 4.01, 18, 0.61, 2.72, 5.30, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.b', 'IM', 1.78, 18, 0.33, 1.09, 2.47, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.b', 'LV', 0.78, 18, 0.33, 0.09, 1.47, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.c', 'IM', 1.03, 18, 0.03, 1.00, 1.09, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.c', 'LV', 0.06, 18, 0.06, 0.00, 0.19, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.d', 'IM', 1.03, 18, 0.03, 1.00, 1.09, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.d', 'LV', 0.09, 18, 0.09, 0.00, 0.28, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.e', 'IM', 1.56, 18, 0.18, 1.17, 1.95, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.e', 'LV', 1.41, 18, 0.51, 0.34, 2.47, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.8.a', 'IM', 2.61, 18, 0.24, 2.11, 3.11, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.8.a', 'LV', 2.45, 18, 0.21, 2.02, 2.89, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.8.b', 'IM', 2.61, 18, 0.35, 1.87, 3.35, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.8.b', 'LV', 2.56, 18, 0.57, 1.36, 3.76, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.9.a', 'IM', 1.32, 18, 0.18, 1.00, 1.70, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.9.a', 'LV', 0.38, 18, 0.21, 0.00, 0.81, 'Y', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.9.b', 'IM', 2.20, 18, 0.42, 1.31, 3.09, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.9.b', 'LV', 2.04, 18, 0.49, 1.00, 3.07, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.10', 'IM', 1.15, 18, 0.10, 1.00, 1.35, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.10', 'LV', 0.27, 18, 0.19, 0.00, 0.66, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.a', 'IM', 4.50, 27, 0.20, 4.08, 4.92, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.a', 'LV', 4.41, 27, 0.17, 4.07, 4.76, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.b', 'IM', 3.43, 27, 0.27, 2.87, 3.99, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.b', 'LV', 4.27, 27, 0.30, 3.65, 4.89, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.c', 'IM', 2.48, 27, 0.42, 1.61, 3.34, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.c', 'LV', 2.41, 27, 0.54, 1.29, 3.53, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.d', 'IM', 2.82, 27, 0.35, 2.09, 3.55, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.d', 'LV', 3.14, 27, 0.62, 1.87, 4.41, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.e', 'IM', 4.65, 26, 0.19, 4.26, 5.00, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.e', 'LV', 5.69, 26, 0.21, 5.27, 6.12, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.f', 'IM', 3.71, 26, 0.29, 3.10, 4.31, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.f', 'LV', 4.28, 26, 0.28, 3.70, 4.86, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.2.a', 'IM', 2.16, 26, 0.33, 1.48, 2.84, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.2.a', 'LV', 1.84, 26, 0.51, 0.80, 2.89, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.2.b', 'IM', 1.68, 26, 0.22, 1.24, 2.13, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.2.b', 'LV', 1.58, 26, 0.39, 0.79, 2.38, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.a', 'IM', 3.16, 27, 0.20, 2.74, 3.58, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.a', 'LV', 4.03, 27, 0.14, 3.73, 4.32, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.b', 'IM', 1.45, 27, 0.12, 1.22, 1.69, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.b', 'LV', 1.15, 27, 0.32, 0.49, 1.82, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.c', 'IM', 1.57, 27, 0.23, 1.09, 2.04, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.c', 'LV', 1.40, 27, 0.58, 0.21, 2.58, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.d', 'IM', 1.30, 27, 0.14, 1.02, 1.59, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.d', 'LV', 0.65, 27, 0.36, 0.00, 1.39, 'Y', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.e', 'IM', 1.55, 27, 0.11, 1.32, 1.78, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.e', 'LV', 1.23, 27, 0.30, 0.61, 1.85, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.a', 'IM', 2.93, 27, 0.30, 2.32, 3.55, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.a', 'LV', 3.56, 27, 0.23, 3.08, 4.04, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.b', 'IM', 1.22, 27, 0.14, 1.00, 1.50, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.b', 'LV', 0.67, 27, 0.41, 0.00, 1.51, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.c', 'IM', 1.37, 27, 0.19, 1.00, 1.75, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.c', 'LV', 0.78, 27, 0.39, 0.00, 1.57, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.d', 'IM', 1.51, 27, 0.15, 1.20, 1.82, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.d', 'LV', 1.07, 27, 0.36, 0.32, 1.81, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.e', 'IM', 4.14, 27, 0.37, 3.37, 4.90, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.e', 'LV', 5.21, 27, 0.36, 4.47, 5.95, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.f', 'IM', 3.53, 27, 0.36, 2.80, 4.27, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.f', 'LV', 3.96, 27, 0.54, 2.85, 5.07, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.g', 'IM', 2.12, 27, 0.21, 1.69, 2.56, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.g', 'LV', 2.18, 27, 0.41, 1.34, 3.02, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.5.a', 'IM', 2.92, 27, 0.17, 2.57, 3.27, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.5.a', 'LV', 2.78, 27, 0.24, 2.29, 3.27, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.5.b', 'IM', 3.91, 27, 0.35, 3.20, 4.63, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.5.b', 'LV', 5.26, 27, 0.55, 4.12, 6.40, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.6', 'IM', 3.70, 27, 0.25, 3.19, 4.22, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.6', 'LV', 4.83, 27, 0.42, 3.96, 5.71, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.a', 'IM', 4.43, 27, 0.14, 4.15, 4.71, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.a', 'LV', 4.51, 27, 0.30, 3.90, 5.12, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.b', 'IM', 1.95, 27, 0.29, 1.36, 2.54, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.b', 'LV', 1.35, 27, 0.32, 0.69, 2.01, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.c', 'IM', 1.62, 27, 0.25, 1.11, 2.14, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.c', 'LV', 1.22, 27, 0.51, 0.16, 2.28, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.d', 'IM', 1.63, 27, 0.15, 1.32, 1.94, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.d', 'LV', 1.67, 27, 0.48, 0.68, 2.65, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.e', 'IM', 2.81, 27, 0.26, 2.28, 3.34, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.e', 'LV', 3.52, 27, 0.40, 2.69, 4.34, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.8.a', 'IM', 3.34, 27, 0.47, 2.37, 4.31, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.8.a', 'LV', 3.29, 27, 0.33, 2.62, 3.97, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.8.b', 'IM', 2.97, 27, 0.21, 2.55, 3.40, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.8.b', 'LV', 3.57, 27, 0.34, 2.86, 4.27, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.9.a', 'IM', 2.16, 27, 0.19, 1.77, 2.55, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.9.a', 'LV', 1.22, 27, 0.16, 0.89, 1.56, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.9.b', 'IM', 2.86, 27, 0.35, 2.14, 3.58, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.9.b', 'LV', 2.91, 27, 0.23, 2.43, 3.39, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.10', 'IM', 2.88, 27, 0.33, 2.21, 3.55, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.10', 'LV', 2.43, 27, 0.33, 1.75, 3.11, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.a', 'IM', 4.19, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.a', 'LV', 4.81, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.b', 'IM', 3.15, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.b', 'LV', 4.52, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.c', 'IM', 2.85, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.c', 'LV', 3.26, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.d', 'IM', 2.50, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.d', 'LV', 3.37, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.e', 'IM', 3.54, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.e', 'LV', 5.22, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.f', 'IM', 3.23, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.f', 'LV', 4.30, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.2.a', 'IM', 2.42, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.2.a', 'LV', 3.11, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.2.b', 'IM', 1.58, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.2.b', 'LV', 1.26, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.a', 'IM', 3.50, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.a', 'LV', 4.56, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.b', 'IM', 2.81, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.b', 'LV', 3.41, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.c', 'IM', 2.58, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.c', 'LV', 3.30, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.d', 'IM', 2.65, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.d', 'LV', 3.19, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.e', 'IM', 2.62, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.e', 'LV', 2.81, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.a', 'IM', 2.81, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.a', 'LV', 3.56, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.b', 'IM', 2.64, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.b', 'LV', 2.67, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.c', 'IM', 2.81, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.c', 'LV', 3.33, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.d', 'IM', 2.42, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.d', 'LV', 2.59, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.e', 'IM', 3.42, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.e', 'LV', 4.11, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.f', 'IM', 2.96, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.f', 'LV', 3.56, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.g', 'IM', 3.23, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.g', 'LV', 4.30, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.5.a', 'IM', 2.04, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.5.a', 'LV', 2.26, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.5.b', 'IM', 2.50, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.5.b', 'LV', 2.93, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.6', 'IM', 3.96, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.6', 'LV', 5.44, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.a', 'IM', 4.15, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.a', 'LV', 4.56, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.b', 'IM', 1.88, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.b', 'LV', 1.59, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.c', 'IM', 1.15, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.c', 'LV', 0.30, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.d', 'IM', 2.08, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.d', 'LV', 2.48, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.e', 'IM', 2.15, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.e', 'LV', 2.63, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.8.a', 'IM', 4.81, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.8.a', 'LV', 5.44, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.8.b', 'IM', 4.50, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.8.b', 'LV', 4.48, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.9.a', 'IM', 3.46, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.9.a', 'LV', 3.59, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.9.b', 'IM', 3.62, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.9.b', 'LV', 3.85, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.10', 'IM', 3.38, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.10', 'LV', 3.93, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.a', 'IM', 3.52, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.a', 'LV', 4.42, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.b', 'IM', 3.24, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.b', 'LV', 4.52, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.c', 'IM', 1.70, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.c', 'LV', 1.09, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.d', 'IM', 2.45, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.d', 'LV', 3.03, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.e', 'IM', 3.00, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.e', 'LV', 3.97, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.f', 'IM', 2.82, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.f', 'LV', 3.70, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.2.a', 'IM', 2.85, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.2.a', 'LV', 3.24, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.2.b', 'IM', 1.52, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.2.b', 'LV', 0.97, 33, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.a', 'IM', 3.00, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.a', 'LV', 3.94, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.b', 'IM', 2.39, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.b', 'LV', 2.64, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.c', 'IM', 2.00, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.c', 'LV', 2.12, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.d', 'IM', 1.55, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.d', 'LV', 1.12, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.e', 'IM', 1.79, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.e', 'LV', 1.58, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.a', 'IM', 2.85, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.a', 'LV', 3.88, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.b', 'IM', 1.76, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.b', 'LV', 1.45, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.c', 'IM', 3.03, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.c', 'LV', 3.94, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.d', 'IM', 3.48, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.d', 'LV', 4.30, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.e', 'IM', 2.45, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.e', 'LV', 3.24, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.f', 'IM', 1.94, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.f', 'LV', 2.06, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.g', 'IM', 1.73, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.g', 'LV', 2.06, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.5.a', 'IM', 3.55, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.5.a', 'LV', 3.66, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.5.b', 'IM', 1.62, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.5.b', 'LV', 1.61, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.6', 'IM', 3.09, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.6', 'LV', 4.55, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.a', 'IM', 4.24, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.a', 'LV', 4.97, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.b', 'IM', 1.76, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.b', 'LV', 1.58, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.c', 'IM', 1.06, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.c', 'LV', 0.15, 33, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.d', 'IM', 1.52, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.d', 'LV', 1.12, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.e', 'IM', 1.52, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.e', 'LV', 1.45, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.8.a', 'IM', 2.47, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.8.a', 'LV', 2.69, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.8.b', 'IM', 4.25, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.8.b', 'LV', 4.47, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.9.a', 'IM', 1.97, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.9.a', 'LV', 1.31, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.9.b', 'IM', 2.69, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.9.b', 'LV', 3.00, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.10', 'IM', 1.64, 33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.10', 'LV', 1.30, 33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.1.a', 'IM', 4.11, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.1.a', 'LV', 4.93, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.1.b', 'IM', 2.26, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.1.b', 'LV', 3.19, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.1.c', 'IM', 3.27, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.1.c', 'LV', 3.69, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.1.d', 'IM', 2.74, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.1.d', 'LV', 3.78, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.1.e', 'IM', 3.52, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.1.e', 'LV', 4.78, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.1.f', 'IM', 3.15, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.1.f', 'LV', 4.00, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.2.a', 'IM', 4.19, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.2.a', 'LV', 5.11, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.2.b', 'IM', 1.81, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.2.b', 'LV', 1.70, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.3.a', 'IM', 3.37, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.3.a', 'LV', 4.15, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.3.b', 'IM', 2.63, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.3.b', 'LV', 3.30, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.3.c', 'IM', 2.30, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.3.c', 'LV', 3.15, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.3.d', 'IM', 1.48, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.3.d', 'LV', 0.89, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.3.e', 'IM', 1.85, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.3.e', 'LV', 1.85, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.4.a', 'IM', 3.52, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.4.a', 'LV', 4.67, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.4.b', 'IM', 1.31, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.4.b', 'LV', 0.85, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.4.c', 'IM', 1.48, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.4.c', 'LV', 1.48, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.4.d', 'IM', 1.15, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.4.d', 'LV', 0.41, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.4.e', 'IM', 2.00, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.4.e', 'LV', 2.52, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.4.f', 'IM', 1.35, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.4.f', 'LV', 1.00, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.4.g', 'IM', 2.56, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.4.g', 'LV', 3.41, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.5.a', 'IM', 1.07, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.5.a', 'LV', 0.11, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.5.b', 'IM', 1.33, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.5.b', 'LV', 0.93, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.6', 'IM', 2.93, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.6', 'LV', 4.30, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.7.a', 'IM', 4.00, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.7.a', 'LV', 3.93, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.7.b', 'IM', 1.93, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.7.b', 'LV', 2.04, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.7.c', 'IM', 1.00, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.7.c', 'LV', 0.00, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.7.d', 'IM', 1.22, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.7.d', 'LV', 0.63, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.7.e', 'IM', 1.63, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.7.e', 'LV', 1.59, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.8.a', 'IM', 2.41, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.8.a', 'LV', 2.44, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.8.b', 'IM', 2.81, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.8.b', 'LV', 3.19, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.9.a', 'IM', 1.85, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.9.a', 'LV', 1.62, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.9.b', 'IM', 2.19, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.9.b', 'LV', 2.30, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.10', 'IM', 4.11, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.04', '2.C.10', 'LV', 4.04, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.1.a', 'IM', 3.65, 34, 0.18, 3.27, 4.02, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.1.a', 'LV', 4.34, 34, 0.19, 3.96, 4.72, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.1.b', 'IM', 3.35, 34, 0.18, 2.98, 3.72, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.1.b', 'LV', 4.68, 34, 0.28, 4.10, 5.26, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.1.c', 'IM', 3.13, 33, 0.21, 2.71, 3.55, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.1.c', 'LV', 3.05, 34, 0.31, 2.41, 3.69, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.1.d', 'IM', 4.31, 34, 0.23, 3.85, 4.77, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.1.d', 'LV', 4.99, 33, 0.34, 4.29, 5.68, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.1.e', 'IM', 4.52, 33, 0.18, 4.15, 4.89, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.1.e', 'LV', 5.25, 33, 0.29, 4.66, 5.84, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.1.f', 'IM', 3.08, 33, 0.29, 2.49, 3.68, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.1.f', 'LV', 3.26, 33, 0.42, 2.40, 4.12, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.2.a', 'IM', 2.38, 34, 0.25, 1.87, 2.89, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.2.a', 'LV', 2.33, 34, 0.36, 1.60, 3.05, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.2.b', 'IM', 1.07, 34, 0.06, 1.00, 1.19, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.2.b', 'LV', 0.19, 34, 0.17, 0.00, 0.53, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.3.a', 'IM', 2.83, 34, 0.16, 2.50, 3.15, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.3.a', 'LV', 3.80, 34, 0.21, 3.38, 4.22, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.3.b', 'IM', 1.25, 34, 0.12, 1.00, 1.50, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.3.b', 'LV', 0.43, 34, 0.24, 0.00, 0.93, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.3.c', 'IM', 1.52, 34, 0.21, 1.10, 1.95, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.3.c', 'LV', 0.95, 34, 0.34, 0.25, 1.65, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.3.d', 'IM', 1.05, 34, 0.04, 1.00, 1.12, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.3.d', 'LV', 0.08, 34, 0.07, 0.00, 0.22, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.3.e', 'IM', 1.25, 34, 0.12, 1.01, 1.49, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.3.e', 'LV', 0.42, 34, 0.21, 0.00, 0.84, 'N', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.4.a', 'IM', 2.51, 34, 0.15, 2.20, 2.82, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.4.a', 'LV', 3.08, 34, 0.29, 2.50, 3.66, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.4.b', 'IM', 1.02, 34, 0.02, 1.00, 1.05, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.4.b', 'LV', 0.02, 34, 0.02, 0.00, 0.05, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.4.c', 'IM', 1.00, 34, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.4.c', 'LV', 0.00, 34, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.4.d', 'IM', 1.02, 34, 0.02, 1.00, 1.05, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.4.d', 'LV', 0.02, 34, 0.02, 0.00, 0.05, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.4.e', 'IM', 2.84, 34, 0.21, 2.41, 3.27, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.4.e', 'LV', 2.92, 34, 0.34, 2.22, 3.62, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.4.f', 'IM', 1.99, 34, 0.25, 1.48, 2.51, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.4.f', 'LV', 1.77, 34, 0.37, 1.02, 2.52, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.4.g', 'IM', 2.16, 34, 0.32, 1.52, 2.80, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.4.g', 'LV', 2.17, 34, 0.49, 1.17, 3.17, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.5.a', 'IM', 1.05, 34, 0.04, 1.00, 1.13, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.5.a', 'LV', 0.08, 34, 0.05, 0.00, 0.18, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.5.b', 'IM', 1.73, 34, 0.27, 1.19, 2.28, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.5.b', 'LV', 1.67, 34, 0.51, 0.62, 2.71, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.6', 'IM', 2.01, 34, 0.24, 1.51, 2.50, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.6', 'LV', 2.10, 34, 0.46, 1.16, 3.03, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.7.a', 'IM', 4.10, 33, 0.16, 3.78, 4.42, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.7.a', 'LV', 4.32, 34, 0.23, 3.85, 4.79, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.7.b', 'IM', 1.46, 33, 0.14, 1.18, 1.74, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.7.b', 'LV', 1.03, 33, 0.31, 0.40, 1.67, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.7.c', 'IM', 3.16, 33, 0.36, 2.43, 3.90, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.7.c', 'LV', 3.75, 33, 0.64, 2.44, 5.06, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.7.d', 'IM', 1.63, 34, 0.28, 1.07, 2.20, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.7.d', 'LV', 0.96, 34, 0.39, 0.17, 1.75, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.7.e', 'IM', 1.91, 34, 0.24, 1.42, 2.40, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.7.e', 'LV', 2.00, 34, 0.41, 1.16, 2.84, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.8.a', 'IM', 1.72, 34, 0.21, 1.28, 2.15, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.8.a', 'LV', 1.34, 34, 0.39, 0.54, 2.13, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.8.b', 'IM', 2.34, 34, 0.22, 1.90, 2.79, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.8.b', 'LV', 2.37, 34, 0.29, 1.78, 2.95, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.9.a', 'IM', 2.28, 34, 0.29, 1.69, 2.87, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.9.a', 'LV', 1.63, 34, 0.39, 0.83, 2.42, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.9.b', 'IM', 3.98, 34, 0.23, 3.51, 4.44, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.9.b', 'LV', 4.33, 34, 0.31, 3.70, 4.96, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.10', 'IM', 2.36, 34, 0.26, 1.83, 2.88, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1011.00', '2.C.10', 'LV', 2.06, 34, 0.31, 1.42, 2.70, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.1.a', 'IM', 3.59, 31, 0.19, 3.20, 3.97, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.1.a', 'LV', 3.72, 31, 0.26, 3.18, 4.26, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.1.b', 'IM', 3.40, 31, 0.55, 2.27, 4.53, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.1.b', 'LV', 3.92, 31, 0.73, 2.43, 5.41, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.1.c', 'IM', 3.09, 31, 0.37, 2.34, 3.85, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.1.c', 'LV', 3.79, 31, 0.43, 2.91, 4.67, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.1.d', 'IM', 3.56, 31, 0.66, 2.22, 4.91, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.1.d', 'LV', 3.97, 31, 1.06, 1.80, 6.14, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.1.e', 'IM', 3.57, 31, 0.44, 2.67, 4.46, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.1.e', 'LV', 5.16, 30, 0.54, 4.06, 6.25, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.1.f', 'IM', 1.71, 31, 0.27, 1.16, 2.25, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.1.f', 'LV', 1.06, 30, 0.49, 0.07, 2.06, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.2.a', 'IM', 3.30, 31, 0.27, 2.74, 3.86, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.2.a', 'LV', 4.22, 31, 0.57, 3.05, 5.39, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.2.b', 'IM', 3.71, 31, 0.36, 2.97, 4.46, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.2.b', 'LV', 3.97, 31, 0.54, 2.86, 5.08, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.3.a', 'IM', 2.68, 31, 0.38, 1.91, 3.45, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.3.a', 'LV', 3.30, 31, 0.54, 2.20, 4.39, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.3.b', 'IM', 1.82, 31, 0.23, 1.36, 2.28, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.3.b', 'LV', 2.06, 31, 0.62, 0.79, 3.33, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.3.c', 'IM', 1.43, 31, 0.17, 1.08, 1.79, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.3.c', 'LV', 1.27, 31, 0.52, 0.21, 2.33, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.3.d', 'IM', 1.75, 31, 0.35, 1.04, 2.47, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.3.d', 'LV', 1.53, 31, 0.70, 0.10, 2.96, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.3.e', 'IM', 2.34, 31, 0.39, 1.54, 3.13, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.3.e', 'LV', 2.67, 31, 0.63, 1.39, 3.95, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.4.a', 'IM', 3.30, 31, 0.26, 2.77, 3.83, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.4.a', 'LV', 3.81, 31, 0.30, 3.20, 4.42, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.4.b', 'IM', 1.40, 31, 0.18, 1.04, 1.75, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.4.b', 'LV', 1.12, 31, 0.53, 0.04, 2.20, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.4.c', 'IM', 1.79, 31, 0.23, 1.32, 2.26, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.4.c', 'LV', 1.90, 31, 0.53, 0.81, 2.99, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.4.d', 'IM', 1.90, 31, 0.39, 1.11, 2.70, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.4.d', 'LV', 1.71, 31, 0.78, 0.12, 3.29, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.4.e', 'IM', 2.33, 31, 0.53, 1.25, 3.42, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.4.e', 'LV', 2.22, 31, 0.87, 0.44, 4.00, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.4.f', 'IM', 1.86, 31, 0.37, 1.09, 2.62, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.4.f', 'LV', 1.98, 31, 0.88, 0.18, 3.79, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.4.g', 'IM', 2.61, 31, 0.24, 2.13, 3.10, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.4.g', 'LV', 3.44, 31, 0.65, 2.12, 4.77, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.5.a', 'IM', 1.19, 31, 0.12, 1.00, 1.44, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.5.a', 'LV', 0.49, 31, 0.35, 0.00, 1.21, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.5.b', 'IM', 1.10, 31, 0.05, 1.00, 1.20, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.5.b', 'LV', 0.22, 31, 0.11, 0.00, 0.43, 'N', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.6', 'IM', 3.19, 31, 0.43, 2.31, 4.07, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.6', 'LV', 3.87, 31, 0.31, 3.24, 4.51, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.7.a', 'IM', 3.36, 31, 0.19, 2.97, 3.74, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.7.a', 'LV', 3.41, 31, 0.19, 3.01, 3.80, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.7.b', 'IM', 1.79, 31, 0.39, 1.00, 2.59, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.7.b', 'LV', 1.34, 31, 0.72, 0.00, 2.81, 'Y', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.7.c', 'IM', 1.16, 31, 0.12, 1.00, 1.40, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.7.c', 'LV', 0.31, 31, 0.24, 0.00, 0.79, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.7.d', 'IM', 1.20, 31, 0.12, 1.00, 1.44, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.7.d', 'LV', 0.42, 30, 0.24, 0.00, 0.92, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.7.e', 'IM', 1.36, 31, 0.24, 1.00, 1.85, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.7.e', 'LV', 0.75, 31, 0.48, 0.00, 1.73, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.8.a', 'IM', 2.26, 31, 0.38, 1.49, 3.04, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.8.a', 'LV', 2.00, 31, 0.60, 0.77, 3.22, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.8.b', 'IM', 2.86, 31, 0.37, 2.10, 3.61, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.8.b', 'LV', 2.99, 31, 0.40, 2.17, 3.80, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.9.a', 'IM', 1.86, 31, 0.54, 1.00, 2.96, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.9.a', 'LV', 1.03, 31, 0.55, 0.00, 2.15, 'Y', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.9.b', 'IM', 1.96, 31, 0.27, 1.41, 2.52, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.9.b', 'LV', 1.98, 31, 0.51, 0.93, 3.02, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.10', 'IM', 3.55, 30, 0.20, 3.15, 3.96, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1021.00', '2.C.10', 'LV', 3.50, 31, 0.17, 3.15, 3.85, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.1.a', 'IM', 4.00, 24, 0.17, 3.65, 4.35, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.1.a', 'LV', 4.29, 22, 0.35, 3.56, 5.02, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.1.b', 'IM', 3.40, 24, 0.25, 2.88, 3.92, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.1.b', 'LV', 3.74, 23, 0.37, 2.96, 4.51, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.1.c', 'IM', 3.73, 23, 0.26, 3.20, 4.26, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.1.c', 'LV', 3.79, 22, 0.38, 3.00, 4.57, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.1.d', 'IM', 3.83, 23, 0.38, 3.05, 4.62, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.1.d', 'LV', 4.26, 23, 0.46, 3.30, 5.22, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.1.e', 'IM', 4.31, 23, 0.28, 3.73, 4.89, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.1.e', 'LV', 4.74, 23, 0.27, 4.18, 5.30, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.1.f', 'IM', 2.69, 23, 0.30, 2.07, 3.31, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.1.f', 'LV', 3.06, 22, 0.42, 2.20, 3.93, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.2.a', 'IM', 3.63, 24, 0.36, 2.88, 4.37, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.2.a', 'LV', 4.53, 24, 0.46, 3.57, 5.49, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.2.b', 'IM', 1.36, 24, 0.22, 1.00, 1.81, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.2.b', 'LV', 0.54, 24, 0.30, 0.00, 1.15, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.3.a', 'IM', 3.20, 23, 0.33, 2.52, 3.88, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.3.a', 'LV', 3.61, 23, 0.24, 3.10, 4.12, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.3.b', 'IM', 1.89, 23, 0.26, 1.35, 2.42, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.3.b', 'LV', 1.57, 22, 0.36, 0.83, 2.32, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.3.c', 'IM', 1.59, 23, 0.24, 1.08, 2.09, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.3.c', 'LV', 1.23, 23, 0.56, 0.07, 2.38, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.3.d', 'IM', 2.85, 24, 0.57, 1.67, 4.03, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.3.d', 'LV', 2.63, 24, 0.82, 0.93, 4.32, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.3.e', 'IM', 2.73, 23, 0.54, 1.62, 3.84, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.3.e', 'LV', 3.04, 23, 0.59, 1.81, 4.26, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.4.a', 'IM', 3.50, 24, 0.31, 2.87, 4.14, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.4.a', 'LV', 3.92, 23, 0.42, 3.05, 4.80, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.4.b', 'IM', 1.18, 23, 0.11, 1.00, 1.41, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.4.b', 'LV', 0.50, 23, 0.32, 0.00, 1.16, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.4.c', 'IM', 1.59, 23, 0.31, 1.00, 2.24, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.4.c', 'LV', 1.02, 23, 0.52, 0.00, 2.10, 'Y', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.4.d', 'IM', 1.33, 23, 0.21, 1.00, 1.76, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.4.d', 'LV', 0.37, 23, 0.21, 0.00, 0.80, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.4.e', 'IM', 2.36, 23, 0.38, 1.58, 3.15, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.4.e', 'LV', 2.66, 23, 0.53, 1.56, 3.76, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.4.f', 'IM', 1.31, 23, 0.14, 1.01, 1.60, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.4.f', 'LV', 0.53, 23, 0.23, 0.06, 1.00, 'N', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.4.g', 'IM', 1.99, 23, 0.26, 1.45, 2.53, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.4.g', 'LV', 1.50, 23, 0.38, 0.72, 2.28, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.5.a', 'IM', 1.37, 24, 0.32, 1.00, 2.03, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.5.a', 'LV', 0.40, 24, 0.33, 0.00, 1.07, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.5.b', 'IM', 1.23, 24, 0.18, 1.00, 1.60, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.5.b', 'LV', 0.37, 24, 0.27, 0.00, 0.93, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.6', 'IM', 3.01, 24, 0.28, 2.42, 3.59, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.6', 'LV', 3.56, 24, 0.54, 2.44, 4.68, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.7.a', 'IM', 3.81, 24, 0.14, 3.51, 4.11, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.7.a', 'LV', 3.67, 24, 0.21, 3.24, 4.10, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.7.b', 'IM', 1.60, 24, 0.29, 1.01, 2.20, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.7.b', 'LV', 1.05, 24, 0.55, 0.00, 2.19, 'Y', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.7.c', 'IM', 1.01, 23, 0.01, 1.00, 1.03, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.7.c', 'LV', 0.02, 23, 0.02, 0.00, 0.05, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.7.d', 'IM', 1.20, 23, 0.16, 1.00, 1.54, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.7.d', 'LV', 0.31, 23, 0.24, 0.00, 0.82, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.7.e', 'IM', 1.43, 23, 0.25, 1.00, 1.94, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.7.e', 'LV', 0.80, 23, 0.38, 0.02, 1.59, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.8.a', 'IM', 2.55, 23, 0.31, 1.91, 3.19, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.8.a', 'LV', 2.37, 23, 0.51, 1.32, 3.43, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.8.b', 'IM', 2.03, 23, 0.24, 1.54, 2.53, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.8.b', 'LV', 1.57, 23, 0.52, 0.50, 2.64, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.9.a', 'IM', 1.91, 23, 0.25, 1.40, 2.42, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.9.a', 'LV', 1.09, 23, 0.34, 0.38, 1.80, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.9.b', 'IM', 1.81, 23, 0.18, 1.44, 2.17, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.9.b', 'LV', 1.36, 23, 0.32, 0.69, 2.03, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.10', 'IM', 2.69, 24, 0.59, 1.48, 3.90, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1022.00', '2.C.10', 'LV', 2.44, 24, 0.60, 1.19, 3.68, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.1.a', 'IM', 3.47, 17, 0.27, 2.91, 4.03, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.1.a', 'LV', 3.91, 17, 0.32, 3.24, 4.58, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.1.b', 'IM', 3.62, 17, 0.35, 2.87, 4.36, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.1.b', 'LV', 4.98, 17, 0.59, 3.73, 6.23, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.1.c', 'IM', 3.45, 17, 0.38, 2.65, 4.25, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.1.c', 'LV', 3.56, 17, 0.65, 2.18, 4.95, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.1.d', 'IM', 2.20, 16, 0.46, 1.22, 3.17, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.1.d', 'LV', 2.39, 17, 0.78, 0.74, 4.04, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.1.e', 'IM', 2.86, 16, 0.54, 1.70, 4.01, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.1.e', 'LV', 2.36, 15, 0.81, 0.62, 4.10, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.1.f', 'IM', 2.61, 17, 0.52, 1.51, 3.70, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.1.f', 'LV', 2.28, 17, 0.66, 0.87, 3.69, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.2.a', 'IM', 3.39, 17, 0.46, 2.41, 4.37, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.2.a', 'LV', 3.61, 17, 0.70, 2.12, 5.10, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.2.b', 'IM', 1.00, 16, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.2.b', 'LV', 0.00, 16, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.3.a', 'IM', 3.33, 17, 0.34, 2.61, 4.05, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.3.a', 'LV', 3.91, 17, 0.50, 2.85, 4.98, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.3.b', 'IM', 1.64, 17, 0.28, 1.05, 2.23, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.3.b', 'LV', 1.30, 16, 0.59, 0.05, 2.55, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.3.c', 'IM', 1.26, 17, 0.17, 1.00, 1.62, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.3.c', 'LV', 0.52, 17, 0.28, 0.00, 1.12, 'Y', 'Y', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.3.d', 'IM', 1.40, 16, 0.29, 1.00, 2.02, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.3.d', 'LV', 0.78, 16, 0.54, 0.00, 1.92, 'Y', 'Y', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.3.e', 'IM', 1.55, 17, 0.20, 1.11, 1.98, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.3.e', 'LV', 1.20, 16, 0.48, 0.18, 2.22, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.4.a', 'IM', 3.79, 17, 0.25, 3.25, 4.32, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.4.a', 'LV', 3.91, 17, 0.36, 3.16, 4.67, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.4.b', 'IM', 1.46, 16, 0.29, 1.00, 2.08, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.4.b', 'LV', 0.88, 16, 0.50, 0.00, 1.94, 'Y', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.4.c', 'IM', 1.29, 17, 0.15, 1.00, 1.60, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.4.c', 'LV', 0.79, 17, 0.43, 0.00, 1.70, 'Y', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.4.d', 'IM', 1.00, 16, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.4.d', 'LV', 0.00, 16, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.4.e', 'IM', 2.09, 17, 0.34, 1.37, 2.81, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.4.e', 'LV', 2.05, 16, 0.61, 0.76, 3.34, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.4.f', 'IM', 1.27, 16, 0.14, 1.00, 1.57, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.4.f', 'LV', 0.50, 16, 0.26, 0.00, 1.05, 'Y', 'Y', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.4.g', 'IM', 1.46, 17, 0.17, 1.11, 1.81, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.4.g', 'LV', 1.36, 17, 0.57, 0.15, 2.56, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.5.a', 'IM', 1.03, 16, 0.03, 1.00, 1.10, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.5.a', 'LV', 0.06, 16, 0.06, 0.00, 0.19, 'Y', 'Y', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.5.b', 'IM', 1.06, 16, 0.06, 1.00, 1.18, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.5.b', 'LV', 0.12, 16, 0.11, 0.00, 0.36, 'Y', 'Y', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.6', 'IM', 2.12, 17, 0.33, 1.43, 2.81, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.6', 'LV', 2.45, 17, 0.74, 0.87, 4.03, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.7.a', 'IM', 3.39, 17, 0.33, 2.68, 4.10, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.7.a', 'LV', 3.85, 17, 0.28, 3.26, 4.44, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.7.b', 'IM', 1.14, 16, 0.09, 1.00, 1.34, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.7.b', 'LV', 0.14, 16, 0.09, 0.00, 0.34, 'Y', 'Y', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.7.c', 'IM', 1.00, 16, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.7.c', 'LV', 0.00, 16, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.7.d', 'IM', 1.03, 16, 0.03, 1.00, 1.08, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.7.d', 'LV', 0.05, 16, 0.05, 0.00, 0.17, 'Y', 'Y', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.7.e', 'IM', 1.39, 16, 0.16, 1.05, 1.74, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.7.e', 'LV', 1.17, 16, 0.49, 0.12, 2.21, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.8.a', 'IM', 2.17, 17, 0.44, 1.24, 3.09, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.8.a', 'LV', 1.76, 17, 0.55, 0.60, 2.92, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.8.b', 'IM', 1.99, 16, 0.21, 1.56, 2.43, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.8.b', 'LV', 2.19, 16, 0.39, 1.36, 3.02, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.9.a', 'IM', 2.24, 17, 0.34, 1.51, 2.97, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.9.a', 'LV', 1.65, 17, 0.57, 0.44, 2.87, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.9.b', 'IM', 2.62, 17, 0.31, 1.96, 3.27, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.9.b', 'LV', 2.80, 17, 0.39, 1.97, 3.62, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.10', 'IM', 2.69, 17, 0.34, 1.97, 3.41, 'N', NULL, TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1023.00', '2.C.10', 'LV', 2.33, 17, 0.51, 1.24, 3.41, 'N', 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.1.a', 'IM', 3.03, 25, 0.35, 2.31, 3.74, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.1.a', 'LV', 3.73, 25, 0.53, 2.64, 4.82, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.1.b', 'IM', 2.94, 25, 0.37, 2.17, 3.71, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.1.b', 'LV', 3.53, 25, 0.34, 2.84, 4.23, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.1.c', 'IM', 2.34, 25, 0.29, 1.76, 2.93, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.1.c', 'LV', 2.02, 25, 0.40, 1.19, 2.85, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.1.d', 'IM', 1.75, 25, 0.15, 1.43, 2.07, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.1.d', 'LV', 1.51, 25, 0.35, 0.78, 2.23, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.1.e', 'IM', 4.14, 25, 0.37, 3.37, 4.90, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.1.e', 'LV', 5.41, 25, 0.52, 4.34, 6.49, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.1.f', 'IM', 1.98, 25, 0.11, 1.74, 2.21, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.1.f', 'LV', 1.66, 25, 0.29, 1.05, 2.26, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.2.a', 'IM', 1.87, 25, 0.11, 1.65, 2.09, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.2.a', 'LV', 1.55, 25, 0.37, 0.78, 2.31, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.2.b', 'IM', 1.11, 25, 0.06, 1.00, 1.23, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.2.b', 'LV', 0.22, 25, 0.14, 0.00, 0.51, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.3.a', 'IM', 2.82, 25, 0.31, 2.19, 3.46, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.3.a', 'LV', 3.47, 25, 0.46, 2.52, 4.42, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.3.b', 'IM', 1.40, 25, 0.23, 1.00, 1.88, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.3.b', 'LV', 0.74, 25, 0.46, 0.00, 1.68, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.3.c', 'IM', 1.63, 25, 0.23, 1.15, 2.10, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.3.c', 'LV', 1.42, 25, 0.40, 0.60, 2.24, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.3.d', 'IM', 2.72, 25, 0.29, 2.12, 3.32, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.3.d', 'LV', 2.64, 25, 0.46, 1.69, 3.58, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.3.e', 'IM', 2.06, 25, 0.24, 1.56, 2.56, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.3.e', 'LV', 1.92, 25, 0.53, 0.83, 3.02, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.4.a', 'IM', 2.81, 25, 0.19, 2.43, 3.19, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.4.a', 'LV', 3.56, 25, 0.33, 2.87, 4.25, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.4.b', 'IM', 1.45, 25, 0.19, 1.06, 1.84, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.4.b', 'LV', 0.85, 25, 0.27, 0.29, 1.40, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.4.c', 'IM', 1.37, 25, 0.11, 1.14, 1.59, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.4.c', 'LV', 1.15, 25, 0.30, 0.52, 1.78, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.4.d', 'IM', 1.32, 25, 0.18, 1.00, 1.70, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.4.d', 'LV', 0.57, 25, 0.28, 0.00, 1.14, 'N', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.4.e', 'IM', 2.63, 25, 0.12, 2.38, 2.89, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.4.e', 'LV', 2.53, 25, 0.27, 1.98, 3.08, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.4.f', 'IM', 1.84, 25, 0.19, 1.45, 2.22, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.4.f', 'LV', 1.55, 25, 0.23, 1.07, 2.03, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.4.g', 'IM', 1.50, 25, 0.20, 1.10, 1.91, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.4.g', 'LV', 1.01, 25, 0.35, 0.29, 1.72, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.5.a', 'IM', 2.29, 25, 0.35, 1.56, 3.02, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.5.a', 'LV', 1.61, 25, 0.42, 0.74, 2.48, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.5.b', 'IM', 1.96, 25, 0.33, 1.28, 2.65, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.5.b', 'LV', 1.45, 25, 0.48, 0.45, 2.44, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.6', 'IM', 2.58, 25, 0.17, 2.24, 2.92, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.6', 'LV', 3.14, 25, 0.27, 2.59, 3.69, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.7.a', 'IM', 4.08, 25, 0.20, 3.66, 4.49, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.7.a', 'LV', 4.25, 25, 0.19, 3.86, 4.63, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.7.b', 'IM', 1.46, 25, 0.16, 1.13, 1.78, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.7.b', 'LV', 0.86, 25, 0.29, 0.26, 1.47, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.7.c', 'IM', 1.05, 25, 0.05, 1.00, 1.15, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.7.c', 'LV', 0.11, 25, 0.10, 0.00, 0.31, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.7.d', 'IM', 1.22, 25, 0.16, 1.00, 1.55, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.7.d', 'LV', 0.50, 25, 0.37, 0.00, 1.26, 'Y', 'Y', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.7.e', 'IM', 1.41, 25, 0.13, 1.14, 1.68, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.7.e', 'LV', 1.24, 25, 0.33, 0.56, 1.91, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.8.a', 'IM', 2.20, 25, 0.31, 1.55, 2.85, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.8.a', 'LV', 2.16, 25, 0.40, 1.32, 2.99, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.8.b', 'IM', 3.74, 25, 0.18, 3.36, 4.12, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.8.b', 'LV', 3.76, 25, 0.25, 3.24, 4.28, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.9.a', 'IM', 1.95, 25, 0.23, 1.47, 2.42, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.9.a', 'LV', 1.26, 25, 0.26, 0.72, 1.80, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.9.b', 'IM', 2.50, 25, 0.24, 2.01, 2.98, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.9.b', 'LV', 2.47, 25, 0.23, 1.99, 2.95, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.10', 'IM', 1.91, 24, 0.28, 1.33, 2.48, 'N', NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.01', '2.C.10', 'LV', 1.62, 24, 0.53, 0.51, 2.72, 'N', 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.1.a', 'IM', 2.41, 32, 0.35, 1.69, 3.12, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.1.a', 'LV', 2.65, 32, 0.52, 1.58, 3.71, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.1.b', 'IM', 3.31, 32, 0.22, 2.85, 3.77, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.1.b', 'LV', 4.49, 32, 0.27, 3.94, 5.05, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.1.c', 'IM', 1.98, 32, 0.32, 1.32, 2.64, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.1.c', 'LV', 1.24, 31, 0.39, 0.45, 2.03, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.1.d', 'IM', 1.55, 32, 0.18, 1.19, 1.91, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.1.d', 'LV', 1.27, 32, 0.41, 0.43, 2.11, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.1.e', 'IM', 4.24, 32, 0.23, 3.78, 4.71, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.1.e', 'LV', 5.47, 32, 0.63, 4.19, 6.75, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.1.f', 'IM', 2.17, 32, 0.17, 1.82, 2.52, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.1.f', 'LV', 2.03, 32, 0.34, 1.34, 2.73, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.2.a', 'IM', 1.67, 32, 0.25, 1.17, 2.17, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.2.a', 'LV', 1.03, 32, 0.39, 0.23, 1.83, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.2.b', 'IM', 1.19, 32, 0.10, 1.00, 1.39, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.2.b', 'LV', 0.48, 32, 0.23, 0.01, 0.95, 'N', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.3.a', 'IM', 2.45, 32, 0.41, 1.62, 3.28, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.3.a', 'LV', 2.80, 32, 0.76, 1.26, 4.34, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.3.b', 'IM', 1.70, 32, 0.37, 1.00, 2.46, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.3.b', 'LV', 1.06, 32, 0.48, 0.07, 2.04, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.3.c', 'IM', 1.69, 32, 0.26, 1.15, 2.23, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.3.c', 'LV', 1.60, 32, 0.58, 0.41, 2.78, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.3.d', 'IM', 2.77, 32, 0.62, 1.50, 4.04, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.3.d', 'LV', 2.51, 32, 0.89, 0.69, 4.33, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.3.e', 'IM', 1.92, 32, 0.30, 1.31, 2.53, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.3.e', 'LV', 1.98, 32, 0.67, 0.62, 3.34, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.4.a', 'IM', 3.01, 32, 0.27, 2.47, 3.55, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.4.a', 'LV', 3.42, 32, 0.39, 2.63, 4.21, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.4.b', 'IM', 1.68, 32, 0.31, 1.04, 2.31, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.4.b', 'LV', 1.38, 32, 0.62, 0.12, 2.65, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.4.c', 'IM', 1.38, 32, 0.22, 1.00, 1.82, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.4.c', 'LV', 0.73, 32, 0.43, 0.00, 1.61, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.4.d', 'IM', 1.30, 32, 0.11, 1.07, 1.53, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.4.d', 'LV', 0.59, 32, 0.22, 0.14, 1.05, 'N', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.4.e', 'IM', 2.04, 32, 0.27, 1.48, 2.59, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.4.e', 'LV', 2.07, 32, 0.57, 0.92, 3.23, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.4.f', 'IM', 1.51, 32, 0.16, 1.19, 1.83, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.4.f', 'LV', 0.74, 32, 0.23, 0.27, 1.21, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.4.g', 'IM', 1.65, 32, 0.23, 1.18, 2.12, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.4.g', 'LV', 1.77, 32, 0.72, 0.29, 3.24, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.5.a', 'IM', 1.68, 32, 0.21, 1.25, 2.11, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.5.a', 'LV', 1.41, 32, 0.43, 0.52, 2.29, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.5.b', 'IM', 1.45, 32, 0.19, 1.07, 1.83, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.5.b', 'LV', 0.80, 32, 0.31, 0.18, 1.43, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.6', 'IM', 2.47, 32, 0.24, 1.99, 2.96, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.6', 'LV', 3.03, 32, 0.42, 2.18, 3.89, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.7.a', 'IM', 4.36, 32, 0.17, 4.01, 4.70, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.7.a', 'LV', 4.68, 32, 0.31, 4.04, 5.32, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.7.b', 'IM', 1.48, 32, 0.15, 1.18, 1.79, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.7.b', 'LV', 0.81, 32, 0.23, 0.34, 1.28, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.7.c', 'IM', 1.12, 32, 0.07, 1.00, 1.26, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.7.c', 'LV', 0.24, 32, 0.14, 0.00, 0.52, 'Y', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.7.d', 'IM', 1.15, 32, 0.06, 1.03, 1.28, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.7.d', 'LV', 0.35, 32, 0.14, 0.06, 0.64, 'N', 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.7.e', 'IM', 1.45, 32, 0.14, 1.16, 1.74, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.7.e', 'LV', 0.99, 32, 0.30, 0.37, 1.60, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.8.a', 'IM', 1.95, 32, 0.31, 1.31, 2.58, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.8.a', 'LV', 1.63, 32, 0.55, 0.50, 2.75, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.8.b', 'IM', 3.07, 32, 0.34, 2.37, 3.77, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.8.b', 'LV', 3.11, 32, 0.35, 2.40, 3.81, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.9.a', 'IM', 1.79, 32, 0.25, 1.28, 2.30, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.9.a', 'LV', 1.34, 32, 0.47, 0.39, 2.29, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.9.b', 'IM', 2.10, 32, 0.15, 1.78, 2.41, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.9.b', 'LV', 2.46, 32, 0.35, 1.74, 3.18, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.10', 'IM', 1.37, 32, 0.13, 1.10, 1.63, 'N', NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1031.02', '2.C.10', 'LV', 0.87, 32, 0.34, 0.18, 1.56, 'N', 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.1.a', 'IM', 2.81, 27, 0.16, 2.47, 3.14, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.1.a', 'LV', 3.75, 26, 0.37, 3.00, 4.51, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.1.b', 'IM', 2.68, 27, 0.28, 2.10, 3.26, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.1.b', 'LV', 2.73, 27, 0.31, 2.10, 3.37, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.1.c', 'IM', 2.35, 27, 0.16, 2.02, 2.69, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.1.c', 'LV', 1.72, 27, 0.21, 1.29, 2.15, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.1.d', 'IM', 2.28, 26, 0.30, 1.67, 2.90, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.1.d', 'LV', 1.82, 24, 0.58, 0.63, 3.02, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.1.e', 'IM', 4.18, 27, 0.15, 3.87, 4.50, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.1.e', 'LV', 5.37, 27, 0.35, 4.66, 6.09, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.1.f', 'IM', 1.97, 27, 0.28, 1.39, 2.55, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.1.f', 'LV', 1.59, 27, 0.24, 1.09, 2.08, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.2.a', 'IM', 2.40, 26, 0.35, 1.67, 3.12, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.2.a', 'LV', 2.29, 26, 0.26, 1.75, 2.82, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.2.b', 'IM', 1.24, 25, 0.23, 1.00, 1.71, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.2.b', 'LV', 0.36, 25, 0.34, 0.00, 1.07, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.3.a', 'IM', 3.69, 26, 0.25, 3.18, 4.19, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.3.a', 'LV', 4.27, 26, 0.60, 3.03, 5.51, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.3.b', 'IM', 2.87, 25, 0.12, 2.62, 3.12, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.3.b', 'LV', 1.89, 25, 0.36, 1.14, 2.65, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.3.c', 'IM', 2.12, 26, 0.46, 1.16, 3.07, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.3.c', 'LV', 2.01, 26, 0.73, 0.51, 3.51, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.3.d', 'IM', 2.20, 26, 0.57, 1.03, 3.38, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.3.d', 'LV', 2.40, 26, 0.86, 0.64, 4.17, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.3.e', 'IM', 3.03, 26, 0.38, 2.25, 3.81, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.3.e', 'LV', 3.08, 26, 0.84, 1.35, 4.80, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.4.a', 'IM', 3.10, 27, 0.39, 2.29, 3.90, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.4.a', 'LV', 3.56, 27, 0.59, 2.35, 4.78, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.4.b', 'IM', 1.93, 27, 0.63, 1.00, 3.22, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.4.b', 'LV', 1.55, 27, 0.95, 0.00, 3.50, 'Y', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.4.c', 'IM', 1.43, 26, 0.41, 1.00, 2.27, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.4.c', 'LV', 0.94, 26, 0.92, 0.00, 2.83, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.4.d', 'IM', 1.28, 27, 0.29, 1.00, 1.88, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.4.d', 'LV', 0.56, 27, 0.59, 0.00, 1.76, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.4.e', 'IM', 2.65, 27, 0.33, 1.98, 3.33, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.4.e', 'LV', 2.63, 27, 0.90, 0.78, 4.48, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.4.f', 'IM', 2.43, 27, 0.24, 1.93, 2.92, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.4.f', 'LV', 1.36, 27, 0.76, 0.00, 2.91, 'Y', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.4.g', 'IM', 2.19, 27, 0.20, 1.78, 2.60, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.4.g', 'LV', 2.13, 27, 0.41, 1.29, 2.97, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.5.a', 'IM', 2.68, 27, 0.28, 2.12, 3.25, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.5.a', 'LV', 2.41, 27, 0.43, 1.53, 3.29, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.5.b', 'IM', 2.18, 27, 0.28, 1.61, 2.75, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.5.b', 'LV', 2.00, 27, 0.53, 0.92, 3.08, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.6', 'IM', 2.69, 27, 0.29, 2.09, 3.29, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.6', 'LV', 3.41, 27, 0.34, 2.70, 4.12, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.7.a', 'IM', 3.97, 27, 0.06, 3.86, 4.09, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.7.a', 'LV', 3.91, 27, 0.26, 3.37, 4.46, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.7.b', 'IM', 2.15, 27, 0.18, 1.79, 2.51, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.7.b', 'LV', 1.54, 27, 0.10, 1.32, 1.75, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.7.c', 'IM', 1.28, 27, 0.29, 1.00, 1.88, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.7.c', 'LV', 0.46, 27, 0.49, 0.00, 1.47, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.7.d', 'IM', 1.33, 27, 0.31, 1.00, 1.97, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.7.d', 'LV', 0.57, 27, 0.53, 0.00, 1.65, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.7.e', 'IM', 1.47, 27, 0.43, 1.00, 2.34, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.7.e', 'LV', 0.77, 27, 0.73, 0.00, 2.26, 'Y', 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.8.a', 'IM', 2.75, 27, 0.43, 1.87, 3.62, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.8.a', 'LV', 3.21, 27, 0.64, 1.89, 4.52, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.8.b', 'IM', 2.93, 27, 0.56, 1.78, 4.08, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.8.b', 'LV', 3.76, 27, 0.43, 2.87, 4.65, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.9.a', 'IM', 3.04, 27, 0.09, 2.86, 3.23, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.9.a', 'LV', 2.54, 27, 0.40, 1.71, 3.37, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.9.b', 'IM', 2.32, 27, 0.27, 1.77, 2.87, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.9.b', 'LV', 2.02, 27, 0.28, 1.44, 2.59, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.10', 'IM', 2.61, 27, 0.25, 2.09, 3.13, 'N', NULL, TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1032.00', '2.C.10', 'LV', 2.93, 27, 0.56, 1.78, 4.07, 'N', 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.1.a', 'IM', 2.25, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.1.a', 'LV', 2.72, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.1.b', 'IM', 2.88, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.1.b', 'LV', 3.44, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.1.c', 'IM', 1.51, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.1.c', 'LV', 1.16, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.1.d', 'IM', 1.40, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.1.d', 'LV', 0.86, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.1.e', 'IM', 3.07, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.1.e', 'LV', 3.89, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.1.f', 'IM', 1.91, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.1.f', 'LV', 2.21, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.2.a', 'IM', 2.09, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.2.a', 'LV', 1.77, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.2.b', 'IM', 1.37, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.2.b', 'LV', 0.89, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.3.a', 'IM', 2.79, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.3.a', 'LV', 3.23, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.3.b', 'IM', 3.11, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.3.b', 'LV', 3.42, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.3.c', 'IM', 2.14, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.3.c', 'LV', 2.51, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.3.d', 'IM', 1.72, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.3.d', 'LV', 1.54, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.3.e', 'IM', 2.40, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.3.e', 'LV', 2.63, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.4.a', 'IM', 3.28, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.4.a', 'LV', 4.11, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.4.b', 'IM', 2.67, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.4.b', 'LV', 3.19, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.4.c', 'IM', 3.61, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.4.c', 'LV', 4.26, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.4.d', 'IM', 3.32, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.4.d', 'LV', 4.30, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.4.e', 'IM', 2.28, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.4.e', 'LV', 2.32, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.4.f', 'IM', 1.61, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.4.f', 'LV', 1.32, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.4.g', 'IM', 2.74, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.4.g', 'LV', 3.56, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.5.a', 'IM', 1.56, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.5.a', 'LV', 1.00, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.5.b', 'IM', 1.25, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.5.b', 'LV', 0.63, 57, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.6', 'IM', 2.68, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.6', 'LV', 3.54, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.7.a', 'IM', 3.93, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.7.a', 'LV', 4.35, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.7.b', 'IM', 1.54, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.7.b', 'LV', 1.09, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.7.c', 'IM', 1.07, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.7.c', 'LV', 0.07, 57, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.7.d', 'IM', 1.39, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.7.d', 'LV', 1.02, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.7.e', 'IM', 1.42, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.7.e', 'LV', 1.11, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.8.a', 'IM', 3.30, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.8.a', 'LV', 3.68, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.8.b', 'IM', 4.35, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.8.b', 'LV', 4.60, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.9.a', 'IM', 1.79, 56, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.9.a', 'LV', 0.96, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.9.b', 'IM', 2.35, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.9.b', 'LV', 2.42, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.10', 'IM', 2.18, 57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.01', '2.C.10', 'LV', 2.19, 57, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.1.a', 'IM', 3.39, 36, 0.29, 2.79, 3.98, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.1.a', 'LV', 3.25, 35, 0.41, 2.41, 4.09, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.1.b', 'IM', 3.64, 36, 0.29, 3.04, 4.23, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.1.b', 'LV', 4.33, 35, 0.46, 3.41, 5.26, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.1.c', 'IM', 2.29, 35, 0.24, 1.81, 2.77, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.1.c', 'LV', 1.70, 35, 0.35, 0.98, 2.42, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.1.d', 'IM', 1.67, 35, 0.28, 1.09, 2.24, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.1.d', 'LV', 1.21, 35, 0.46, 0.27, 2.14, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.1.e', 'IM', 4.48, 36, 0.26, 3.96, 5.00, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.1.e', 'LV', 5.18, 35, 0.29, 4.58, 5.78, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.1.f', 'IM', 2.35, 36, 0.29, 1.77, 2.94, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.1.f', 'LV', 1.85, 35, 0.43, 0.98, 2.73, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.2.a', 'IM', 2.68, 36, 0.45, 1.75, 3.60, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.2.a', 'LV', 2.53, 36, 0.71, 1.08, 3.97, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.2.b', 'IM', 1.00, 36, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.2.b', 'LV', 0.00, 36, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.3.a', 'IM', 3.22, 36, 0.37, 2.47, 3.98, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.3.a', 'LV', 3.65, 36, 0.42, 2.79, 4.51, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.3.b', 'IM', 1.27, 36, 0.09, 1.08, 1.45, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.3.b', 'LV', 0.49, 36, 0.18, 0.13, 0.85, 'N', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.3.c', 'IM', 1.30, 36, 0.17, 1.00, 1.65, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.3.c', 'LV', 0.49, 36, 0.26, 0.00, 1.03, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.3.d', 'IM', 1.16, 36, 0.10, 1.00, 1.36, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.3.d', 'LV', 0.53, 36, 0.32, 0.00, 1.17, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.3.e', 'IM', 1.66, 36, 0.21, 1.24, 2.07, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.3.e', 'LV', 1.30, 36, 0.36, 0.57, 2.03, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.4.a', 'IM', 3.06, 36, 0.32, 2.42, 3.71, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.4.a', 'LV', 2.90, 36, 0.22, 2.45, 3.34, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.4.b', 'IM', 1.09, 36, 0.06, 1.00, 1.22, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.4.b', 'LV', 0.20, 36, 0.13, 0.00, 0.46, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.4.c', 'IM', 1.39, 36, 0.22, 1.00, 1.83, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.4.c', 'LV', 0.69, 36, 0.36, 0.00, 1.41, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.4.d', 'IM', 1.14, 36, 0.08, 1.00, 1.29, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.4.d', 'LV', 0.21, 36, 0.13, 0.00, 0.47, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.4.e', 'IM', 2.99, 36, 0.28, 2.42, 3.56, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.4.e', 'LV', 3.48, 36, 0.37, 2.72, 4.23, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.4.f', 'IM', 2.10, 36, 0.31, 1.47, 2.72, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.4.f', 'LV', 1.73, 36, 0.49, 0.74, 2.72, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.4.g', 'IM', 1.80, 36, 0.32, 1.15, 2.46, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.4.g', 'LV', 1.35, 35, 0.48, 0.38, 2.33, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.5.a', 'IM', 1.42, 36, 0.13, 1.15, 1.69, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.5.a', 'LV', 0.88, 36, 0.29, 0.29, 1.46, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.5.b', 'IM', 1.74, 36, 0.30, 1.13, 2.34, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.5.b', 'LV', 1.57, 36, 0.56, 0.43, 2.70, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.6', 'IM', 3.29, 36, 0.26, 2.77, 3.82, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.6', 'LV', 3.55, 36, 0.27, 3.01, 4.10, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.7.a', 'IM', 3.64, 36, 0.19, 3.25, 4.02, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.7.a', 'LV', 3.68, 36, 0.21, 3.26, 4.11, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.7.b', 'IM', 2.42, 35, 0.35, 1.71, 3.13, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.7.b', 'LV', 2.06, 35, 0.43, 1.18, 2.95, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.7.c', 'IM', 1.00, 35, 0.00, 1.00, 1.01, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.7.c', 'LV', 0.00, 35, 0.00, 0.00, 0.01, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.7.d', 'IM', 1.16, 35, 0.09, 1.00, 1.34, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.7.d', 'LV', 0.42, 35, 0.25, 0.00, 0.94, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.7.e', 'IM', 1.26, 35, 0.19, 1.00, 1.64, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.7.e', 'LV', 0.43, 35, 0.29, 0.00, 1.02, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.8.a', 'IM', 3.57, 35, 0.43, 2.70, 4.43, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.8.a', 'LV', 3.16, 35, 0.38, 2.40, 3.93, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.8.b', 'IM', 3.66, 35, 0.31, 3.02, 4.29, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.8.b', 'LV', 3.36, 35, 0.30, 2.75, 3.97, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.9.a', 'IM', 2.35, 35, 0.28, 1.79, 2.91, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.9.a', 'LV', 1.99, 34, 0.43, 1.12, 2.85, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.9.b', 'IM', 2.28, 35, 0.27, 1.74, 2.82, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.9.b', 'LV', 2.26, 35, 0.38, 1.48, 3.03, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.10', 'IM', 2.39, 36, 0.47, 1.44, 3.35, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.02', '2.C.10', 'LV', 1.91, 36, 0.45, 0.99, 2.83, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.1.a', 'IM', 3.30, 24, 0.37, 2.53, 4.06, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.1.a', 'LV', 3.15, 24, 0.42, 2.27, 4.02, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.1.b', 'IM', 3.73, 24, 0.44, 2.83, 4.64, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.1.b', 'LV', 4.49, 24, 0.75, 2.94, 6.05, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.1.c', 'IM', 1.34, 24, 0.27, 1.00, 1.90, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.1.c', 'LV', 0.69, 24, 0.49, 0.00, 1.70, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.1.d', 'IM', 1.49, 24, 0.22, 1.02, 1.95, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.1.d', 'LV', 1.47, 24, 0.66, 0.10, 2.83, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.1.e', 'IM', 3.80, 24, 0.42, 2.92, 4.67, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.1.e', 'LV', 4.50, 24, 0.73, 2.99, 6.00, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.1.f', 'IM', 3.77, 24, 0.33, 3.08, 4.46, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.1.f', 'LV', 4.08, 24, 0.57, 2.91, 5.25, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.2.a', 'IM', 2.17, 24, 0.52, 1.09, 3.24, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.2.a', 'LV', 1.67, 24, 0.74, 0.14, 3.21, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.2.b', 'IM', 1.00, 24, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.2.b', 'LV', 0.00, 24, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.3.a', 'IM', 2.57, 23, 0.41, 1.72, 3.42, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.3.a', 'LV', 2.94, 23, 0.73, 1.42, 4.45, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.3.b', 'IM', 1.27, 23, 0.27, 1.00, 1.83, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.3.b', 'LV', 0.40, 23, 0.38, 0.00, 1.18, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.3.c', 'IM', 1.11, 23, 0.11, 1.00, 1.33, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.3.c', 'LV', 0.26, 23, 0.27, 0.00, 0.82, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.3.d', 'IM', 1.32, 23, 0.23, 1.00, 1.80, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.3.d', 'LV', 0.70, 23, 0.46, 0.00, 1.65, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.3.e', 'IM', 1.06, 24, 0.05, 1.00, 1.17, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.3.e', 'LV', 0.13, 24, 0.11, 0.00, 0.36, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.4.a', 'IM', 2.48, 24, 0.26, 1.93, 3.02, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.4.a', 'LV', 2.82, 24, 0.49, 1.80, 3.83, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.4.b', 'IM', 1.01, 24, 0.01, 1.00, 1.03, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.4.b', 'LV', 0.03, 24, 0.03, 0.00, 0.08, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.4.c', 'IM', 1.00, 24, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.4.c', 'LV', 0.00, 24, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.4.d', 'IM', 1.00, 24, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.4.d', 'LV', 0.00, 24, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.4.e', 'IM', 2.28, 24, 0.38, 1.51, 3.06, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.4.e', 'LV', 2.94, 24, 0.71, 1.48, 4.40, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.4.f', 'IM', 2.26, 24, 0.45, 1.33, 3.20, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.4.f', 'LV', 2.36, 24, 0.70, 0.92, 3.81, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.4.g', 'IM', 1.40, 24, 0.19, 1.01, 1.79, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.4.g', 'LV', 0.77, 24, 0.38, 0.00, 1.56, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.5.a', 'IM', 1.09, 24, 0.07, 1.00, 1.22, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.5.a', 'LV', 0.16, 24, 0.12, 0.00, 0.41, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.5.b', 'IM', 2.13, 24, 0.46, 1.17, 3.08, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.5.b', 'LV', 2.30, 24, 0.78, 0.69, 3.91, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.6', 'IM', 2.49, 24, 0.44, 1.57, 3.40, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.6', 'LV', 3.18, 24, 0.98, 1.15, 5.20, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.7.a', 'IM', 4.03, 24, 0.35, 3.30, 4.76, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.7.a', 'LV', 4.64, 24, 0.17, 4.28, 5.00, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.7.b', 'IM', 1.84, 24, 0.31, 1.21, 2.47, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.7.b', 'LV', 1.63, 24, 0.61, 0.37, 2.89, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.7.c', 'IM', 1.06, 24, 0.05, 1.00, 1.17, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.7.c', 'LV', 0.12, 24, 0.11, 0.00, 0.35, 'Y', 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.7.d', 'IM', 1.83, 24, 0.45, 1.00, 2.76, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.7.d', 'LV', 1.14, 24, 0.53, 0.04, 2.24, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.7.e', 'IM', 1.98, 24, 0.31, 1.34, 2.63, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.7.e', 'LV', 2.30, 24, 0.71, 0.83, 3.77, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.8.a', 'IM', 1.79, 24, 0.21, 1.37, 2.22, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.8.a', 'LV', 1.71, 24, 0.48, 0.73, 2.70, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.8.b', 'IM', 4.28, 24, 0.20, 3.86, 4.69, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.8.b', 'LV', 4.46, 24, 0.22, 3.99, 4.92, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.9.a', 'IM', 1.72, 24, 0.36, 1.00, 2.47, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.9.a', 'LV', 0.92, 24, 0.56, 0.00, 2.08, 'Y', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.9.b', 'IM', 2.20, 24, 0.21, 1.77, 2.62, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.9.b', 'LV', 2.64, 24, 0.36, 1.90, 3.37, 'N', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.10', 'IM', 1.35, 24, 0.16, 1.02, 1.68, 'N', NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.03', '2.C.10', 'LV', 0.85, 24, 0.45, 0.00, 1.79, 'Y', 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.1.a', 'IM', 3.59, 20, 0.15, 3.29, 3.90, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.1.a', 'LV', 3.51, 20, 0.31, 2.85, 4.16, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.1.b', 'IM', 3.50, 20, 0.21, 3.06, 3.95, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.1.b', 'LV', 4.19, 20, 0.28, 3.61, 4.76, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.1.c', 'IM', 2.31, 20, 0.48, 1.32, 3.31, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.1.c', 'LV', 1.17, 20, 0.32, 0.49, 1.85, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.1.d', 'IM', 1.49, 20, 0.15, 1.18, 1.80, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.1.d', 'LV', 1.47, 20, 0.44, 0.54, 2.39, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.1.e', 'IM', 3.72, 20, 0.31, 3.07, 4.36, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.1.e', 'LV', 4.75, 20, 0.27, 4.18, 5.32, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.1.f', 'IM', 2.04, 20, 0.41, 1.18, 2.90, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.1.f', 'LV', 1.79, 20, 0.54, 0.65, 2.93, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.2.a', 'IM', 3.36, 20, 1.01, 1.25, 5.00, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.2.a', 'LV', 2.83, 20, 0.86, 1.03, 4.62, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.2.b', 'IM', 1.00, 20, 0.00, 1.00, 1.01, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.2.b', 'LV', 0.00, 20, 0.00, 0.00, 0.01, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.3.a', 'IM', 3.64, 20, 0.14, 3.35, 3.94, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.3.a', 'LV', 4.50, 19, 0.15, 4.19, 4.82, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.3.b', 'IM', 3.81, 20, 0.45, 2.88, 4.74, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.3.b', 'LV', 3.75, 20, 0.42, 2.88, 4.62, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.3.c', 'IM', 2.56, 20, 0.73, 1.04, 4.08, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.3.c', 'LV', 2.52, 20, 0.73, 1.00, 4.04, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.3.d', 'IM', 3.65, 20, 0.93, 1.71, 5.00, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.3.d', 'LV', 3.39, 19, 1.19, 0.88, 5.89, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.3.e', 'IM', 3.58, 20, 0.32, 2.91, 4.24, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.3.e', 'LV', 3.94, 18, 0.34, 3.22, 4.67, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.4.a', 'IM', 3.48, 20, 0.15, 3.16, 3.79, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.4.a', 'LV', 3.63, 20, 0.29, 3.02, 4.23, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.4.b', 'IM', 1.41, 20, 0.14, 1.11, 1.71, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.4.b', 'LV', 1.31, 20, 0.48, 0.31, 2.30, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.4.c', 'IM', 2.67, 20, 0.81, 1.00, 4.37, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.4.c', 'LV', 2.78, 20, 1.08, 0.51, 5.05, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.4.d', 'IM', 1.57, 20, 0.29, 1.00, 2.17, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.4.d', 'LV', 1.14, 20, 0.58, 0.00, 2.35, 'Y', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.4.e', 'IM', 1.58, 20, 0.29, 1.00, 2.19, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.4.e', 'LV', 1.16, 20, 0.58, 0.00, 2.37, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.4.f', 'IM', 1.58, 20, 0.29, 1.00, 2.18, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.4.f', 'LV', 1.08, 20, 0.36, 0.33, 1.83, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.4.g', 'IM', 1.86, 20, 0.27, 1.29, 2.43, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.4.g', 'LV', 1.32, 20, 0.41, 0.47, 2.18, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.5.a', 'IM', 1.32, 20, 0.36, 1.00, 2.09, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.5.a', 'LV', 0.49, 20, 0.55, 0.00, 1.63, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.5.b', 'IM', 1.17, 20, 0.18, 1.00, 1.55, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.5.b', 'LV', 0.33, 20, 0.37, 0.00, 1.10, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.6', 'IM', 2.77, 20, 0.59, 1.54, 3.99, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.6', 'LV', 2.70, 19, 1.22, 0.13, 5.27, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.7.a', 'IM', 3.40, 20, 0.26, 2.86, 3.94, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.7.a', 'LV', 4.08, 19, 0.29, 3.47, 4.69, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.7.b', 'IM', 1.35, 20, 0.16, 1.01, 1.68, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.7.b', 'LV', 0.26, 19, 0.16, 0.00, 0.60, 'Y', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.7.c', 'IM', 1.00, 20, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.7.c', 'LV', 0.00, 20, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.7.d', 'IM', 1.29, 20, 0.14, 1.00, 1.59, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.7.d', 'LV', 0.58, 20, 0.29, 0.00, 1.18, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.7.e', 'IM', 1.33, 20, 0.37, 1.00, 2.09, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.7.e', 'LV', 0.66, 20, 0.73, 0.00, 2.19, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.8.a', 'IM', 3.42, 20, 0.31, 2.78, 4.06, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.8.a', 'LV', 4.06, 20, 0.29, 3.46, 4.66, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.8.b', 'IM', 2.79, 20, 0.35, 2.05, 3.53, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.8.b', 'LV', 3.23, 19, 0.21, 2.78, 3.68, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.9.a', 'IM', 1.69, 20, 0.32, 1.02, 2.35, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.9.a', 'LV', 0.96, 20, 0.36, 0.20, 1.72, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.9.b', 'IM', 2.27, 20, 0.26, 1.73, 2.81, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.9.b', 'LV', 2.41, 19, 0.21, 1.97, 2.85, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.10', 'IM', 3.00, 20, 0.14, 2.71, 3.29, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.04', '2.C.10', 'LV', 3.18, 19, 0.59, 1.94, 4.42, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.1.a', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.1.a', 'LV', 3.80, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.1.b', 'IM', 2.90, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.1.b', 'LV', 3.95, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.1.c', 'IM', 2.25, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.1.c', 'LV', 1.75, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.1.d', 'IM', 1.20, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.1.d', 'LV', 0.65, 20, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.1.e', 'IM', 3.20, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.1.e', 'LV', 4.20, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.1.f', 'IM', 2.80, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.1.f', 'LV', 3.55, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.2.a', 'IM', 1.45, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.2.a', 'LV', 1.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.2.b', 'IM', 1.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.2.b', 'LV', 0.00, 20, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.3.a', 'IM', 2.75, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.3.a', 'LV', 3.70, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.3.b', 'IM', 1.55, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.3.b', 'LV', 1.15, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.3.c', 'IM', 1.35, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.3.c', 'LV', 0.75, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.3.d', 'IM', 1.30, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.3.d', 'LV', 0.75, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.3.e', 'IM', 1.65, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.3.e', 'LV', 1.40, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.4.a', 'IM', 2.45, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.4.a', 'LV', 2.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.4.b', 'IM', 2.15, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.4.b', 'LV', 2.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.4.c', 'IM', 2.95, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.4.c', 'LV', 3.80, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.4.d', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.4.d', 'LV', 5.30, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.4.e', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.4.e', 'LV', 4.60, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.4.f', 'IM', 2.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.4.f', 'LV', 3.25, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.4.g', 'IM', 1.90, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.4.g', 'LV', 1.90, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.5.a', 'IM', 4.85, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.5.a', 'LV', 6.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.5.b', 'IM', 2.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.5.b', 'LV', 3.40, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.6', 'IM', 2.58, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.6', 'LV', 3.89, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.7.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.7.a', 'LV', 4.75, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.7.b', 'IM', 1.35, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.7.b', 'LV', 0.75, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.7.c', 'IM', 1.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.7.c', 'LV', 0.10, 20, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.7.d', 'IM', 1.40, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.7.d', 'LV', 1.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.7.e', 'IM', 2.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.7.e', 'LV', 3.00, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.8.a', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.8.a', 'LV', 3.75, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.8.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.8.b', 'LV', 4.00, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.9.a', 'IM', 2.05, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.9.a', 'LV', 1.20, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.9.b', 'IM', 2.55, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.9.b', 'LV', 2.35, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.10', 'IM', 1.85, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.06', '2.C.10', 'LV', 1.55, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.1.a', 'IM', 2.87, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.1.a', 'LV', 3.77, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.1.b', 'IM', 3.19, 31, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.1.b', 'LV', 4.55, 31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.1.c', 'IM', 1.34, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.1.c', 'LV', 0.69, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.1.d', 'IM', 2.00, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.1.d', 'LV', 2.25, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.1.e', 'IM', 2.59, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.1.e', 'LV', 3.28, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.1.f', 'IM', 1.84, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.1.f', 'LV', 1.97, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.2.a', 'IM', 2.59, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.2.a', 'LV', 2.72, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.2.b', 'IM', 1.25, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.2.b', 'LV', 0.53, 32, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.3.a', 'IM', 2.91, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.3.a', 'LV', 3.69, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.3.b', 'IM', 2.19, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.3.b', 'LV', 2.31, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.3.c', 'IM', 2.09, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.3.c', 'LV', 2.16, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.3.d', 'IM', 1.22, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.3.d', 'LV', 0.50, 32, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.3.e', 'IM', 1.59, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.3.e', 'LV', 1.09, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.4.a', 'IM', 2.72, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.4.a', 'LV', 3.47, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.4.b', 'IM', 1.66, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.4.b', 'LV', 1.50, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.4.c', 'IM', 2.50, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.4.c', 'LV', 3.06, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.4.d', 'IM', 2.72, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.4.d', 'LV', 3.47, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.4.e', 'IM', 1.75, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.4.e', 'LV', 1.81, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.4.f', 'IM', 1.56, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.4.f', 'LV', 1.22, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.4.g', 'IM', 1.50, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.4.g', 'LV', 1.38, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.5.a', 'IM', 2.81, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.5.a', 'LV', 2.97, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.5.b', 'IM', 1.22, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.5.b', 'LV', 0.56, 32, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.6', 'IM', 2.31, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.6', 'LV', 3.28, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.7.a', 'IM', 4.41, 32, NULL, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('13-1041.07', '2.C.7.a', 'LV', 4.78, 32, NULL, NULL, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyy