CREATE TABLE education_training_experience (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  category DECIMAL(3,0),
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(5,2),
  lower_ci_bound DECIMAL(5,2),
  upper_ci_bound DECIMAL(5,2),
  recommend_suppress CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id),
  FOREIGN KEY (element_id, scale_id, category) REFERENCES ete_categories(element_id, scale_id, category));

INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 1, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 2, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 3, 0.53, 30, 0.57, 0.06, 4.69, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 4, 2.77, 30, 2.39, 0.46, 14.86, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 5, 0.09, 30, 0.09, 0.01, 0.78, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 6, 50.34, 30, 20.55, 15.87, 84.49, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 7, 13.40, 30, 12.71, 1.62, 59.25, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 8, 24.68, 30, 14.29, 6.37, 61.22, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 9, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 10, 6.76, 30, 6.87, 0.77, 40.24, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 11, 1.43, 30, 1.40, 0.19, 9.99, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 12, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 1, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 2, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 3, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 4, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 5, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 6, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 7, 2.68, 30, 2.41, 0.42, 15.39, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 8, 28.63, 30, 17.17, 6.71, 69.10, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 9, 3.16, 30, 2.22, 0.73, 12.55, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 10, 14.68, 30, 12.82, 2.08, 58.24, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 11, 50.86, 30, 20.42, 16.29, 84.62, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 1, 24.90, 30, 14.97, 6.06, 63.03, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 2, 3.38, 30, 2.56, 0.70, 14.79, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 3, 2.16, 30, 2.24, 0.25, 16.18, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 4, 15.49, 30, 12.94, 2.37, 58.05, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 5, 3.21, 30, 2.01, 0.87, 11.09, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 6, 0.45, 30, 0.42, 0.07, 2.94, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 7, 13.64, 30, 12.91, 1.65, 59.76, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 8, 3.93, 30, 2.60, 0.99, 14.35, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 9, 32.85, 30, 23.58, 5.21, 81.33, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 1, 21.60, 30, 14.37, 4.63, 60.98, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 2, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 3, 1.56, 30, 1.29, 0.28, 8.15, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 4, 21.78, 30, 13.87, 5.00, 59.55, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 5, 3.30, 30, 2.16, 0.85, 11.97, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 6, 14.26, 30, 12.93, 1.88, 59.14, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 7, 2.02, 30, 1.65, 0.37, 10.19, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 8, 1.86, 30, 1.73, 0.27, 11.58, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 9, 33.63, 30, 23.42, 5.60, 81.24, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 1, 0.33, 44, 0.33, 0.04, 2.51, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 2, 8.54, 44, 4.20, 3.06, 21.65, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 3, 10.39, 44, 8.51, 1.80, 42.28, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 4, 11.01, 44, 6.17, 3.36, 30.58, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 5, 31.86, 44, 10.28, 15.25, 54.87, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 6, 26.72, 44, 8.48, 13.21, 46.62, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 7, 6.09, 44, 4.91, 1.14, 26.78, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 8, 5.05, 44, 4.65, 0.75, 27.35, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 9, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 10, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 11, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 12, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 1, 0.69, 44, 0.70, 0.09, 5.24, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 2, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 3, 0.69, 44, 0.69, 0.09, 5.11, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 4, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 5, 6.37, 44, 4.09, 1.68, 21.34, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 6, 7.41, 44, 4.66, 2.00, 23.93, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 7, 34.82, 44, 10.13, 17.84, 56.80, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 8, 7.63, 44, 4.51, 2.22, 23.11, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 9, 7.19, 44, 4.98, 1.69, 25.86, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 10, 8.45, 44, 5.01, 2.43, 25.43, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 11, 26.75, 44, 9.80, 11.76, 50.02, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 1, 15.66, 44, 6.50, 6.44, 33.37, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 2, 12.67, 44, 5.58, 4.98, 28.63, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 3, 11.26, 44, 5.58, 3.96, 28.12, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 4, 15.97, 44, 8.74, 4.86, 41.40, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 5, 2.13, 44, 2.13, 0.28, 14.60, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 6, 22.64, 44, 9.80, 8.65, 47.49, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 7, 3.05, 44, 2.42, 0.60, 14.10, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 8, 5.64, 44, 4.73, 0.99, 26.37, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 9, 10.98, 44, 5.75, 3.63, 28.77, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 1, 4.57, 44, 3.13, 1.11, 16.92, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 2, 4.37, 44, 2.71, 1.22, 14.43, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 3, 16.71, 44, 7.37, 6.45, 36.86, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 4, 17.85, 44, 7.54, 7.15, 38.01, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 5, 9.86, 44, 5.23, 3.23, 26.40, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 6, 31.72, 44, 10.84, 14.47, 56.04, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 7, 3.05, 44, 2.42, 0.60, 14.10, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 8, 2.03, 44, 1.29, 0.56, 7.10, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 9, 9.85, 44, 5.69, 2.91, 28.48, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 1, 4.71, 24, 4.51, 0.62, 28.28, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 2, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 3, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 4, 13.57, 24, 8.00, 3.69, 39.15, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 5, 22.07, 24, 16.18, 3.89, 66.46, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 6, 54.30, 24, 14.47, 26.24, 79.87, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 7, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 8, 5.36, 24, 3.97, 1.11, 22.23, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 10, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 11, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 12, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 1, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 2, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 3, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 4, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 5, 5.00, 24, 3.38, 1.19, 18.68, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 6, 25.05, 24, 16.23, 5.29, 66.66, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 7, 41.06, 24, 14.42, 16.89, 70.49, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 8, 12.34, 24, 6.98, 3.57, 34.84, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 9, 11.58, 24, 6.58, 3.35, 33.11, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 10, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 11, 4.96, 24, 3.67, 1.04, 20.67, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 1, 16.35, 24, 8.41, 5.19, 41.09, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 2, 14.31, 24, 7.13, 4.77, 35.72, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 3, 18.25, 24, 8.63, 6.32, 42.48, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 4, 26.72, 24, 15.97, 6.32, 66.35, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 5, 11.98, 24, 7.12, 3.26, 35.50, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 6, 6.78, 24, 5.56, 1.17, 30.95, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 7, 0.90, 24, 0.93, 0.10, 7.27, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 8, 4.71, 24, 4.69, 0.57, 30.06, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 1, 6.95, 24, 5.01, 1.48, 27.04, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 2, 6.48, 24, 4.76, 1.34, 26.03, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 3, 26.41, 24, 10.65, 10.35, 52.72, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 4, 32.43, 24, 14.87, 10.54, 66.15, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 5, 15.37, 24, 7.10, 5.55, 35.95, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 6, 1.47, 24, 1.54, 0.16, 11.87, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 7, 6.19, 24, 4.60, 1.27, 25.35, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 8, 4.71, 24, 4.69, 0.57, 30.06, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 1, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 2, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 3, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 4, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 5, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 6, 84.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 7, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 8, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 9, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 10, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 11, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 12, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 3, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 4, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 5, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 7, 29.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 8, 37.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 9, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 10, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 11, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 1, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 2, 21.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 3, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 4, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 5, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 6, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 7, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 8, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 9, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 1, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 2, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 3, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 4, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 5, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 6, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 7, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 8, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 9, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 2, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 3, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 4, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 5, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 6, 57.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 7, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 8, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 10, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 11, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 12, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 2, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 3, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 4, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 5, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 6, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 7, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 8, 42.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 9, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 10, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 11, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 1, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 2, 33.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 3, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 4, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 5, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 6, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 7, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 8, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 1, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 2, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 3, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 4, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 5, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 6, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 7, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 8, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 1, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 2, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 3, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 4, 6.48, 36, 6.19, 0.86, 35.53, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 5, 7.43, 36, 7.05, 0.99, 39.12, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 6, 78.31, 36, 10.02, 52.15, 92.28, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 7, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 8, 7.79, 36, 6.32, 1.40, 33.49, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 9, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 10, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 11, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '2.D.1', 'RL', 12, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 1, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 2, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 3, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 4, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 5, 0.75, 36, 0.46, 0.22, 2.56, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 6, 5.44, 36, 5.04, 0.78, 29.60, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 7, 30.61, 36, 10.52, 13.90, 54.66, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 8, 24.10, 36, 10.93, 8.62, 51.64, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 9, 18.26, 36, 8.68, 6.42, 42.12, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 10, 5.09, 36, 3.75, 1.09, 20.62, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.1', 'RW', 11, 15.75, 36, 8.60, 4.78, 41.05, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 1, 42.57, 36, 10.26, 24.03, 63.47, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 2, 29.97, 36, 12.58, 11.25, 59.10, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 3, 8.61, 36, 5.54, 2.21, 28.22, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 4, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 5, 10.82, 36, 7.28, 2.56, 35.95, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 6, 0.38, 36, 0.39, 0.05, 2.97, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 7, 6.55, 36, 6.24, 0.88, 35.69, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 8, 1.10, 36, 1.11, 0.14, 8.12, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.2', 'PT', 9, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 1, 12.72, 36, 7.63, 3.48, 37.02, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 2, 28.77, 36, 8.09, 15.35, 47.36, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 3, 9.14, 36, 6.46, 2.03, 32.77, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 4, 5.52, 36, 5.04, 0.81, 29.38, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 5, 23.69, 36, 8.80, 10.36, 45.47, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 6, 6.48, 36, 6.19, 0.86, 35.53, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 7, 1.95, 36, 1.96, 0.25, 13.69, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 8, 11.74, 36, 7.69, 2.87, 37.50, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', '3.A.3', 'OJ', 9, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 1, 2.19, 37, 2.21, 0.27, 15.38, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 2, 18.73, 37, 7.97, 7.38, 39.99, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 3, 15.20, 37, 7.49, 5.23, 36.80, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 4, 13.40, 37, 6.80, 4.50, 33.68, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 5, 19.03, 37, 13.93, 3.62, 59.51, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 6, 27.95, 37, 8.83, 13.75, 48.57, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 7, 0.00, 37, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 8, 3.49, 37, 3.28, 0.50, 20.70, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 9, 0.00, 37, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 10, 0.00, 37, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 11, 0.00, 37, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '2.D.1', 'RL', 12, 0.00, 37, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 1, 13.66, 36, 7.50, 4.17, 36.52, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 2, 2.12, 36, 2.14, 0.27, 14.96, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 3, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 4, 0.22, 36, 0.23, 0.03, 1.78, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 5, 5.85, 36, 3.47, 1.70, 18.24, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 6, 34.87, 36, 14.01, 13.28, 65.20, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 7, 25.40, 36, 10.23, 10.22, 50.46, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 8, 11.79, 36, 5.86, 4.09, 29.54, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 9, 3.15, 36, 3.06, 0.42, 20.01, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 10, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.1', 'RW', 11, 2.94, 36, 2.88, 0.39, 19.03, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 1, 39.72, 36, 12.39, 18.73, 65.32, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 2, 12.05, 36, 6.73, 3.64, 33.22, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 3, 15.91, 36, 6.32, 6.76, 33.04, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 4, 6.53, 36, 4.07, 1.77, 21.27, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 5, 22.37, 36, 8.01, 10.15, 42.35, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 6, 3.15, 36, 3.06, 0.42, 19.92, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 7, 0.28, 36, 0.29, 0.03, 2.24, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 8, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.2', 'PT', 9, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 1, 8.30, 36, 4.93, 2.37, 25.22, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 2, 24.86, 36, 9.06, 11.00, 46.97, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 3, 33.98, 36, 13.67, 12.99, 63.95, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 4, 5.22, 36, 3.86, 1.12, 21.15, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 5, 27.36, 36, 8.32, 13.86, 46.84, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 6, 0.28, 36, 0.29, 0.03, 2.24, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 7, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 8, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', '3.A.3', 'OJ', 9, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 1, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 2, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 3, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 4, 2.50, 32, 1.86, 0.54, 10.82, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 5, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 6, 61.64, 32, 21.78, 19.71, 91.32, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 7, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 8, 35.87, 32, 22.21, 7.24, 80.03, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 9, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 10, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 11, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 12, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 1, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 2, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 3, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 4, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 5, 1.59, 32, 1.69, 0.18, 12.79, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 6, 1.11, 32, 0.92, 0.21, 5.80, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 7, 48.21, 32, 20.75, 14.60, 83.52, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 8, 18.31, 32, 9.56, 5.73, 45.22, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 9, 6.01, 32, 3.86, 1.56, 20.49, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 10, 23.03, 32, 18.46, 3.45, 71.45, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 11, 1.74, 32, 1.44, 0.32, 8.99, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 1, 4.72, 31, 2.98, 1.26, 16.11, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 2, 29.76, 31, 18.79, 6.33, 72.64, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 3, 33.80, 31, 22.95, 5.91, 80.58, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 4, 13.17, 31, 10.71, 2.19, 50.66, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 5, 7.21, 31, 4.37, 2.01, 22.80, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 6, 2.55, 31, 1.89, 0.55, 11.02, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 7, 8.79, 31, 7.31, 1.47, 38.28, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 8, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 9, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 1, 3.36, 32, 2.28, 0.82, 12.71, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 2, 4.71, 32, 3.00, 1.25, 16.19, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 3, 23.66, 32, 18.40, 3.74, 71.21, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 4, 5.76, 32, 3.78, 1.46, 20.18, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 5, 47.25, 32, 20.70, 14.13, 82.97, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 6, 12.04, 32, 7.95, 2.88, 38.74, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 7, 3.22, 32, 2.34, 0.72, 13.31, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 8, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 9, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 1, 0.00, 40, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 2, 0.04, 40, 0.04, 0.00, 0.35, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 3, 0.32, 40, 0.36, 0.03, 3.01, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 4, 6.77, 40, 5.68, 1.17, 30.93, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 5, 3.12, 40, 3.01, 0.43, 19.49, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 6, 28.60, 40, 16.53, 7.23, 67.31, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 7, 0.90, 40, 0.81, 0.14, 5.37, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 8, 55.18, 40, 23.67, 15.08, 89.51, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 9, 4.91, 40, 5.25, 0.53, 33.38, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 10, 0.00, 40, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 11, 0.16, 40, 0.18, 0.02, 1.55, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 12, 0.00, 40, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 1, 0.00, 40, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 2, 0.00, 40, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 3, 0.04, 40, 0.04, 0.00, 0.35, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 4, 0.04, 40, 0.04, 0.00, 0.35, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 5, 1.34, 40, 1.49, 0.14, 11.68, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 6, 3.33, 40, 3.07, 0.50, 19.14, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 7, 8.21, 40, 6.59, 1.50, 34.38, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 8, 15.83, 40, 9.94, 3.99, 45.97, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 9, 6.60, 40, 5.78, 1.05, 31.99, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 10, 10.44, 40, 8.74, 1.73, 43.58, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 11, 54.19, 40, 24.01, 14.33, 89.32, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 1, 62.80, 40, 19.68, 23.50, 90.27, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 2, 8.96, 40, 6.91, 1.74, 35.30, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 3, 8.88, 40, 6.26, 2.00, 31.79, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 4, 4.94, 40, 5.31, 0.53, 33.87, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 5, 2.01, 40, 1.48, 0.45, 8.53, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 6, 4.14, 40, 4.42, 0.45, 29.10, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 7, 4.85, 40, 5.23, 0.51, 33.56, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 8, 3.41, 40, 3.72, 0.36, 25.73, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 9, 0.00, 40, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 1, 49.56, 40, 26.08, 10.64, 89.02, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 2, 4.85, 40, 3.77, 0.97, 20.98, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 3, 25.01, 40, 15.05, 6.17, 62.84, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 4, 6.06, 40, 5.60, 0.87, 32.09, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 5, 1.52, 40, 1.24, 0.29, 7.62, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 6, 4.16, 40, 4.42, 0.46, 29.03, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 7, 5.20, 40, 5.32, 0.62, 32.69, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 8, 0.24, 40, 0.27, 0.02, 2.28, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 9, 3.41, 40, 3.72, 0.36, 25.73, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 1, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 2, 0.93, 16, 1.01, 0.09, 8.86, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 3, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 4, 28.34, 16, 23.03, 3.41, 81.60, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 5, 29.05, 16, 24.10, 3.28, 83.19, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 6, 37.07, 16, 24.75, 5.78, 84.97, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 7, 4.61, 16, 4.99, 0.43, 35.19, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 8, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 9, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 10, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 11, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '2.D.1', 'RL', 12, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 1, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 2, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 3, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 4, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 5, 0.91, 16, 1.00, 0.08, 9.01, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 6, 28.26, 16, 23.04, 3.38, 81.61, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 7, 1.10, 16, 0.97, 0.16, 6.97, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 8, 56.57, 16, 23.42, 14.58, 90.86, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 9, 4.27, 16, 4.43, 0.44, 31.04, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 10, 8.88, 16, 6.45, 1.75, 34.76, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.1', 'RW', 11, 0.01, 16, 0.01, 0.00, 0.13, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 1, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 2, 4.44, 16, 4.46, 0.49, 30.42, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 3, 0.18, 16, 0.16, 0.03, 1.18, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 4, 28.26, 16, 23.04, 3.38, 81.61, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 5, 62.83, 16, 23.39, 16.67, 93.46, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 6, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 7, 0.01, 16, 0.01, 0.00, 0.14, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 8, 4.27, 16, 4.43, 0.44, 31.04, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.2', 'PT', 9, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 1, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 2, 4.35, 16, 4.45, 0.46, 30.73, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 3, 0.12, 16, 0.10, 0.02, 0.65, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 4, 56.67, 16, 25.00, 12.99, 91.97, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 5, 1.70, 16, 0.82, 0.60, 4.70, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 6, 28.26, 16, 24.10, 3.03, 83.23, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 7, 4.63, 16, 4.99, 0.43, 35.14, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 8, 4.27, 16, 4.43, 0.44, 31.04, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', '3.A.3', 'OJ', 9, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 1, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 2, 25.03, 39, 6.81, 13.80, 41.03, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 3, 23.72, 39, 7.86, 11.43, 42.83, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 4, 18.50, 39, 10.34, 5.36, 47.63, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 5, 2.74, 39, 1.52, 0.88, 8.23, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 6, 28.80, 39, 9.58, 13.58, 51.02, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 7, 1.22, 39, 1.27, 0.15, 9.41, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 8, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 9, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 10, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 11, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 12, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 1, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 2, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 3, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 4, 8.75, 39, 7.74, 1.33, 40.56, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 5, 17.50, 39, 7.85, 6.58, 38.95, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 6, 3.48, 39, 2.44, 0.82, 13.58, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 7, 22.62, 39, 9.20, 9.16, 45.86, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 8, 19.82, 39, 7.94, 8.25, 40.47, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 9, 4.34, 39, 3.68, 0.75, 21.40, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 10, 7.49, 39, 5.43, 1.63, 28.33, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 11, 16.01, 39, 9.92, 4.10, 45.92, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 1, 7.53, 39, 5.50, 1.62, 28.70, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 2, 3.94, 39, 2.08, 1.33, 11.07, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 3, 10.72, 39, 6.69, 2.83, 33.09, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 4, 38.79, 39, 10.98, 19.91, 61.77, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 5, 2.66, 39, 1.77, 0.68, 9.87, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 6, 8.18, 39, 5.52, 1.97, 28.29, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 7, 17.50, 39, 10.87, 4.42, 49.33, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 8, 10.69, 39, 8.68, 1.87, 42.98, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 9, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 1, 1.65, 39, 1.31, 0.33, 7.89, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 2, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 3, 18.47, 39, 6.72, 8.41, 35.85, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 4, 28.04, 39, 6.42, 16.99, 42.59, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 5, 21.84, 39, 8.32, 9.44, 42.84, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 6, 11.29, 39, 8.74, 2.13, 42.70, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 7, 17.50, 39, 10.87, 4.42, 49.33, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 8, 1.21, 39, 1.27, 0.14, 9.55, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 9, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 2, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 3, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 4, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 5, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 6, 75.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 7, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 8, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 10, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 11, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 12, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 4, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 5, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 6, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 7, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 8, 25.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 9, 29.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 10, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 11, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 1, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 2, 25.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 3, 25.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 4, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 5, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 6, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 8, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 1, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 2, 41.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 3, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 4, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 5, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 6, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 8, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 1, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 2, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 3, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 4, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 5, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 6, 69.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 7, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 8, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 9, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 10, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 11, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '2.D.1', 'RL', 12, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 1, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 2, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 3, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 4, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 5, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 6, 17.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 7, 21.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 8, 26.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 9, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 10, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.1', 'RW', 11, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 1, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 2, 26.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 3, 17.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 4, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 5, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 6, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 7, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 8, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.2', 'PT', 9, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 1, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 2, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 3, 17.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 4, 21.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 5, 21.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 6, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 7, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 8, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', '3.A.3', 'OJ', 9, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 2, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 3, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 4, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 5, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 6, 58.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 7, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 8, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 10, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 11, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '2.D.1', 'RL', 12, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 2, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 4, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 5, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 6, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 7, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 8, 33.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 9, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 10, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.1', 'RW', 11, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 1, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 2, 33.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 3, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 4, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 5, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 6, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 7, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 8, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.2', 'PT', 9, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 1, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 2, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 3, 29.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 4, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 5, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 6, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 8, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.02', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 2, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 3, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 4, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 5, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 6, 71.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 7, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 8, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 10, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 11, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 12, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 2, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 3, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 4, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 5, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 6, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 7, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 8, 28.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 9, 28.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 10, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 11, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 1, 33.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 2, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 3, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 4, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 5, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 6, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 7, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 8, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 1, 33.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 2, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 3, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 4, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 5, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 6, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 7, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 8, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 2, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 3, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 4, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 5, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 6, 68.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 7, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 8, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 10, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 11, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 2, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 3, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 4, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 5, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 6, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 7, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 8, 59.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 9, 31.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 10, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 11, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 1, 31.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 2, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 3, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 4, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 6, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 7, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 8, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 1, 27.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 2, 31.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 3, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 4, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 5, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 6, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 7, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 8, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 2, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 3, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 4, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 5, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 6, 62.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 7, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 8, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 10, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 11, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 12, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 4, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 5, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 6, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 7, 29.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 8, 29.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 9, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 10, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 11, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 1, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 2, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 3, 29.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 4, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 5, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 6, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 8, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 1, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 2, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 3, 33.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 4, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 5, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 8, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 1, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 2, 4.16, 24, 3.58, 0.68, 21.71, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 3, 8.82, 24, 5.99, 2.03, 31.12, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 4, 18.50, 24, 13.83, 3.29, 60.22, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 5, 23.84, 24, 14.11, 5.90, 60.98, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 6, 44.67, 24, 15.95, 17.53, 75.41, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 7, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 8, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 10, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 11, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '2.D.1', 'RL', 12, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 1, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 2, 1.63, 24, 1.69, 0.19, 12.85, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 3, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 4, 2.27, 24, 2.26, 0.28, 16.01, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 5, 3.58, 24, 2.88, 0.66, 17.30, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 6, 3.71, 24, 3.52, 0.50, 22.82, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 7, 46.98, 24, 16.36, 18.55, 77.52, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 8, 15.74, 24, 10.91, 3.29, 50.60, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 9, 15.27, 24, 13.90, 1.92, 62.46, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 10, 5.36, 24, 4.74, 0.81, 28.13, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.1', 'RW', 11, 5.47, 24, 3.38, 1.47, 18.28, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 1, 21.16, 24, 14.01, 4.51, 60.40, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 2, 10.25, 24, 4.88, 3.68, 25.49, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 3, 1.57, 24, 1.62, 0.18, 12.24, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 4, 26.53, 24, 15.58, 6.47, 65.36, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 5, 10.01, 24, 8.67, 1.50, 44.91, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 6, 6.32, 24, 4.89, 1.21, 27.14, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 7, 23.78, 24, 14.09, 5.88, 60.90, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 8, 0.37, 24, 0.39, 0.04, 3.11, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.2', 'PT', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 1, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 2, 6.52, 24, 4.01, 1.76, 21.38, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 3, 3.62, 24, 3.64, 0.43, 24.49, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 4, 29.29, 24, 15.45, 8.13, 65.97, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 5, 27.45, 24, 15.05, 7.35, 64.36, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 6, 9.91, 24, 6.26, 2.51, 31.94, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 7, 21.22, 24, 14.07, 4.51, 60.57, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 8, 0.37, 24, 0.39, 0.04, 3.11, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.01', '3.A.3', 'OJ', 9, 1.63, 24, 1.69, 0.19, 12.85, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 1, 0.00, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 2, 3.23, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 3, 0.00, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 4, 6.45, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 5, 3.23, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 6, 48.39, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 7, 9.68, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 8, 22.58, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 9, 0.00, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 10, 0.00, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 11, 6.45, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '2.D.1', 'RL', 12, 0.00, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 1, 3.23, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 2, 0.00, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 3, 0.00, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 4, 0.00, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 5, 6.45, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 6, 16.13, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 7, 25.81, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 8, 25.81, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 9, 9.68, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 10, 3.23, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.1', 'RW', 11, 9.68, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 1, 19.35, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 2, 22.58, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 3, 12.90, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 4, 9.68, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 5, 22.58, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 6, 3.23, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 7, 6.45, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 8, 0.00, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.2', 'PT', 9, 3.23, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 1, 6.45, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 2, 12.90, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 3, 19.35, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 4, 9.68, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 5, 29.03, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 6, 9.68, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 7, 9.68, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 8, 0.00, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.03', '3.A.3', 'OJ', 9, 3.23, 31, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 1, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 2, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 3, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 4, 15.62, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 5, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 6, 65.62, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 7, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 8, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 9, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 10, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 11, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 12, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 1, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 2, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 3, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 4, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 5, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 6, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 7, 18.75, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 8, 31.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 9, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 10, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 11, 18.75, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 1, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 2, 12.50, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 3, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 4, 6.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 5, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 6, 12.50, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 7, 18.75, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 8, 21.88, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 9, 6.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 1, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 2, 12.50, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 3, 15.62, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 4, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 5, 12.50, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 6, 21.88, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 7, 6.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 8, 21.88, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 9, 6.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 1, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 2, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 3, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 4, 6.62, 22, 5.82, 0.99, 33.41, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 5, 24.00, 22, 13.73, 6.19, 60.19, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 6, 63.36, 22, 14.34, 32.37, 86.20, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 7, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 8, 4.01, 22, 2.56, 1.04, 14.29, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 9, 2.00, 22, 1.51, 0.41, 9.21, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 10, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 11, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 12, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 1, 13.66, 22, 11.53, 2.03, 54.72, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 2, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 3, 4.21, 22, 4.30, 0.47, 28.82, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 4, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 5, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 6, 39.71, 22, 14.75, 15.46, 70.33, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 7, 29.19, 22, 14.03, 9.13, 62.84, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 8, 10.46, 22, 5.76, 3.15, 29.54, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 9, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 10, 1.76, 22, 1.80, 0.21, 13.46, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 11, 1.03, 22, 1.06, 0.12, 8.36, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 1, 18.95, 22, 11.90, 4.46, 53.93, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 2, 28.68, 22, 12.90, 9.77, 59.89, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 3, 14.73, 22, 11.43, 2.54, 53.39, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 4, 10.15, 22, 6.52, 2.49, 33.31, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 5, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 6, 14.11, 22, 9.94, 2.89, 47.50, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 7, 13.38, 22, 11.30, 1.99, 54.00, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 8, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 9, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 1, 13.66, 22, 11.40, 2.07, 54.15, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 2, 24.00, 22, 12.58, 7.00, 57.00, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 3, 26.05, 22, 12.88, 8.06, 58.60, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 4, 3.88, 22, 2.89, 0.80, 16.83, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 5, 20.00, 22, 11.23, 5.49, 51.82, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 6, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 7, 12.41, 22, 11.31, 1.60, 55.23, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 8, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 9, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 1, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 2, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 3, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 4, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 5, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 6, 8.68, 29, 6.96, 1.55, 36.50, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 7, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 8, 62.96, 29, 11.76, 37.70, 82.68, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 9, 21.47, 29, 9.20, 8.21, 45.53, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 10, 6.89, 29, 6.58, 0.90, 37.68, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 11, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 12, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 1, 8.68, 29, 6.96, 1.55, 36.50, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 2, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 3, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 4, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 5, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 6, 8.65, 29, 6.96, 1.53, 36.50, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 7, 11.59, 29, 4.48, 5.08, 24.31, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 8, 35.52, 29, 9.02, 19.74, 55.23, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 9, 8.24, 29, 6.13, 1.67, 32.11, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 10, 11.90, 29, 7.17, 3.22, 35.39, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 11, 15.43, 29, 8.22, 4.78, 39.88, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 1, 32.33, 29, 10.15, 15.59, 55.26, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 2, 12.17, 29, 7.24, 3.34, 35.69, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 3, 6.54, 29, 6.01, 0.93, 34.39, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 4, 17.42, 29, 8.09, 6.26, 40.02, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 5, 9.96, 29, 6.89, 2.24, 34.78, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 6, 13.46, 29, 7.28, 4.14, 35.90, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 7, 1.53, 29, 1.56, 0.19, 11.40, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 8, 6.59, 29, 6.32, 0.86, 36.59, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 9, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 1, 19.61, 29, 9.57, 6.57, 45.82, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 2, 18.90, 29, 9.58, 6.09, 45.59, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 3, 17.86, 29, 7.99, 6.65, 39.88, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 4, 11.89, 29, 6.47, 3.67, 32.36, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 5, 3.49, 29, 2.54, 0.77, 14.47, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 6, 20.30, 29, 9.10, 7.45, 44.62, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 7, 1.36, 29, 1.37, 0.17, 10.12, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 8, 6.59, 29, 6.32, 0.86, 36.59, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 9, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 1, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 2, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 3, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 4, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 5, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 6, 23.13, 29, 11.17, 7.67, 52.16, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 7, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 8, 53.80, 29, 16.70, 22.72, 82.19, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 9, 0.81, 29, 0.88, 0.09, 7.17, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 10, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 11, 22.26, 29, 13.59, 5.42, 58.87, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 12, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 1, 0.81, 29, 0.82, 0.10, 6.21, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 2, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 3, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 4, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 5, 2.47, 29, 2.39, 0.33, 16.21, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 6, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 7, 8.41, 29, 4.62, 2.62, 23.87, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 8, 48.68, 29, 16.64, 19.51, 78.78, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 9, 25.05, 29, 13.84, 6.88, 60.20, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 10, 9.41, 29, 8.04, 1.48, 41.74, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 11, 5.17, 29, 4.98, 0.68, 30.39, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 1, 24.19, 29, 12.14, 7.60, 55.34, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 2, 28.19, 29, 16.72, 6.74, 68.06, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 3, 13.93, 29, 12.55, 1.86, 58.00, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 4, 4.12, 29, 2.96, 0.92, 16.60, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 5, 8.33, 29, 4.16, 2.89, 21.72, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 6, 7.96, 29, 4.63, 2.32, 24.01, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 7, 8.59, 29, 7.98, 1.16, 43.00, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 8, 4.69, 29, 4.01, 0.77, 23.65, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 9, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 1, 25.26, 29, 12.83, 7.75, 57.63, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 2, 1.63, 29, 1.25, 0.33, 7.57, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 3, 26.03, 29, 14.68, 6.87, 62.66, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 4, 20.52, 29, 13.07, 4.76, 57.14, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 5, 14.27, 29, 7.16, 4.78, 35.57, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 6, 8.42, 29, 4.56, 2.66, 23.60, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 7, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 8, 0.00, 29, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 9, 3.88, 29, 3.91, 0.47, 25.65, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 1, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 2, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 3, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 4, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 5, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 6, 68.15, 58, 13.29, 38.57, 87.94, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 7, 3.43, 58, 2.44, 0.80, 13.46, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 8, 20.15, 58, 8.10, 8.44, 40.87, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 9, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 10, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 11, 0.82, 58, 0.63, 0.17, 3.77, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 12, 7.46, 58, 6.63, 1.16, 35.57, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 1, 6.67, 58, 5.54, 1.19, 29.79, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 2, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 3, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 4, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 5, 2.71, 58, 2.62, 0.38, 16.93, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 6, 0.62, 58, 0.47, 0.13, 2.81, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 7, 4.74, 58, 4.49, 0.67, 26.73, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 8, 31.08, 58, 13.43, 11.39, 61.27, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 9, 5.89, 58, 3.15, 1.97, 16.33, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 10, 24.05, 58, 10.64, 8.97, 50.42, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 11, 24.24, 58, 9.07, 10.63, 46.26, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 1, 31.62, 58, 15.59, 9.84, 66.20, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 2, 10.69, 58, 5.81, 3.42, 28.80, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 3, 5.86, 58, 4.39, 1.25, 23.43, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 4, 7.40, 58, 4.96, 1.84, 25.42, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 5, 22.95, 58, 12.94, 6.44, 56.31, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 6, 6.70, 58, 4.85, 1.50, 25.32, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 7, 8.72, 58, 5.66, 2.25, 28.41, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 8, 3.43, 58, 2.45, 0.80, 13.48, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 9, 2.62, 58, 2.39, 0.41, 14.88, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 1, 5.21, 58, 3.08, 1.55, 16.07, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 2, 1.45, 58, 0.87, 0.43, 4.74, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 3, 12.33, 58, 6.33, 4.17, 31.25, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 4, 16.39, 58, 7.78, 5.92, 37.91, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 5, 29.34, 58, 13.39, 10.23, 60.22, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 6, 8.06, 58, 5.43, 1.98, 27.57, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 7, 12.04, 58, 6.28, 4.01, 30.97, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 8, 14.57, 58, 5.69, 6.39, 29.88, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 9, 0.61, 58, 0.47, 0.13, 2.80, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 1, 29.73, 23, 12.45, 10.95, 59.28, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 2, 28.17, 23, 11.64, 10.63, 56.38, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 3, 7.45, 23, 5.95, 1.32, 32.55, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 4, 14.47, 23, 8.75, 3.76, 42.31, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 5, 8.84, 23, 6.29, 1.88, 32.86, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 6, 11.34, 23, 10.55, 1.43, 52.99, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 7, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 8, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 9, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 10, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 11, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 12, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 1, 14.93, 23, 10.62, 3.00, 49.85, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 2, 18.37, 23, 12.13, 4.04, 54.64, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 3, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 4, 9.80, 23, 6.91, 2.11, 35.45, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 5, 17.13, 23, 9.32, 5.03, 44.65, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 6, 31.00, 23, 11.75, 12.58, 58.39, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 7, 0.35, 23, 0.29, 0.06, 1.93, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 8, 1.42, 23, 1.45, 0.17, 10.94, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 9, 5.17, 23, 5.06, 0.64, 31.68, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 10, 1.82, 23, 1.84, 0.22, 13.62, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 11, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 1, 15.37, 23, 10.93, 3.08, 50.93, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 2, 25.71, 23, 11.92, 8.66, 55.80, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 3, 13.09, 23, 7.27, 3.85, 36.17, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 4, 16.67, 23, 9.55, 4.58, 45.44, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 5, 18.05, 23, 10.67, 4.70, 49.57, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 6, 5.63, 23, 5.08, 0.82, 30.19, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 7, 3.67, 23, 3.74, 0.42, 25.48, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 8, 1.82, 23, 1.84, 0.22, 13.62, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 9, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 1, 18.97, 23, 12.04, 4.41, 54.31, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 2, 48.41, 23, 13.24, 23.81, 73.81, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 3, 5.76, 23, 5.74, 0.68, 35.38, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 4, 13.19, 23, 6.94, 4.15, 34.81, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 5, 6.22, 23, 3.84, 1.66, 20.64, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 6, 0.46, 23, 0.35, 0.10, 2.15, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 7, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 8, 6.99, 23, 5.37, 1.33, 29.45, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 9, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 1, 12.99, 33, 11.40, 1.88, 53.79, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 2, 43.50, 33, 10.70, 24.08, 65.14, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 3, 0.45, 33, 0.46, 0.05, 3.63, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 4, 6.50, 33, 3.57, 2.06, 18.72, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 5, 17.39, 33, 8.57, 5.88, 41.50, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 6, 17.95, 33, 8.56, 6.27, 41.70, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 7, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 8, 1.23, 33, 1.27, 0.15, 9.51, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 9, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 10, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 11, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 12, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 1, 14.44, 32, 12.47, 2.11, 56.96, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 2, 3.78, 32, 3.82, 0.46, 25.09, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 3, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 4, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 5, 3.32, 32, 2.17, 0.86, 11.98, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 6, 17.94, 32, 8.09, 6.65, 40.14, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 7, 10.24, 32, 6.35, 2.72, 31.81, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 8, 23.32, 32, 9.65, 9.19, 47.77, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 9, 2.58, 32, 1.95, 0.54, 11.42, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 10, 2.69, 32, 2.68, 0.34, 18.23, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 11, 21.69, 32, 8.85, 8.73, 44.50, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 1, 17.53, 33, 6.62, 7.72, 35.07, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 2, 19.72, 33, 10.49, 5.99, 48.65, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 3, 19.70, 33, 12.63, 4.60, 55.50, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 4, 15.19, 33, 8.18, 4.69, 39.49, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 5, 8.66, 33, 5.99, 1.99, 30.71, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 6, 8.09, 33, 6.41, 1.50, 33.78, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 7, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 8, 11.11, 33, 7.98, 2.35, 39.33, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 9, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 1, 25.47, 33, 13.52, 7.41, 59.32, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 2, 8.57, 33, 5.68, 2.10, 29.08, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 3, 24.90, 33, 9.25, 10.81, 47.58, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 4, 4.65, 33, 2.54, 1.50, 13.52, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 5, 12.44, 33, 6.43, 4.09, 32.12, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 6, 15.52, 33, 8.31, 4.81, 40.04, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 7, 8.45, 33, 7.77, 1.18, 41.65, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 8, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 9, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 1, 4.85, 20, 5.15, 0.49, 34.46, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 2, 24.56, 20, 12.66, 7.23, 57.64, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 3, 11.57, 20, 8.88, 2.08, 44.59, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 4, 9.23, 20, 9.41, 0.96, 51.59, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 5, 20.87, 20, 12.66, 5.03, 56.75, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 6, 27.72, 20, 10.43, 11.42, 53.28, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 7, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 8, 1.20, 20, 1.20, 0.14, 9.22, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 9, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 10, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 11, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 12, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 1, 5.34, 19, 5.18, 0.65, 32.67, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 2, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 3, 10.17, 19, 10.41, 1.02, 55.33, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 4, 10.17, 19, 10.41, 1.02, 55.33, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 5, 10.17, 19, 9.57, 1.24, 50.55, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 6, 20.60, 19, 11.17, 5.82, 52.13, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 7, 27.46, 19, 12.33, 9.35, 58.15, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 8, 14.76, 19, 8.01, 4.35, 39.75, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 9, 1.32, 19, 1.33, 0.16, 10.22, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 10, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 11, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 1, 21.67, 19, 13.94, 4.70, 60.83, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 2, 30.97, 19, 12.21, 11.91, 59.82, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 3, 24.24, 19, 14.08, 6.00, 61.58, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 4, 7.00, 19, 4.51, 1.72, 24.41, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 5, 11.49, 19, 9.59, 1.76, 48.47, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 6, 4.64, 19, 3.39, 0.96, 19.61, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 7, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 8, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 9, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 1, 5.34, 19, 5.18, 0.65, 32.67, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 2, 20.35, 19, 12.26, 4.95, 55.59, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 3, 53.45, 19, 12.52, 28.52, 76.77, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 4, 16.59, 19, 10.18, 4.07, 48.25, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 5, 1.32, 19, 1.33, 0.16, 10.22, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 6, 2.95, 19, 2.94, 0.35, 20.77, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 7, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 8, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 9, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 1, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 2, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 3, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 4, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 5, 3.45, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 6, 51.72, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 7, 10.34, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 8, 31.03, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 9, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 10, 3.45, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 11, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 12, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 1, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 2, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 3, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 4, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 5, 10.34, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 6, 17.24, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 7, 13.79, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 8, 37.93, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 9, 17.24, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 10, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 11, 3.45, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 1, 31.03, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 2, 17.24, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 3, 13.79, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 4, 13.79, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 5, 20.69, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 6, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 7, 3.45, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 8, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 9, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 1, 10.34, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 2, 13.79, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 3, 17.24, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 4, 31.03, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 5, 13.79, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 6, 3.45, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 7, 6.90, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 8, 3.45, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 9, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 1, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 2, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 3, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 4, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 5, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 6, 48.09, 25, 14.26, 22.18, 75.08, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 7, 2.87, 25, 2.27, 0.55, 13.66, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 8, 20.11, 25, 9.95, 6.56, 47.46, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 9, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 10, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 11, 3.60, 25, 3.68, 0.42, 24.98, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 12, 25.33, 25, 15.43, 5.92, 64.62, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 1, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 2, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 3, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 4, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 5, 3.60, 25, 3.68, 0.42, 24.98, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 6, 15.11, 25, 9.37, 3.79, 44.56, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 7, 2.99, 25, 2.30, 0.59, 13.71, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 8, 31.14, 25, 12.24, 12.23, 59.49, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 9, 10.79, 25, 6.16, 3.13, 31.20, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 10, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 11, 36.37, 25, 14.88, 13.16, 68.30, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 1, 10.78, 25, 6.10, 3.16, 30.90, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 2, 29.66, 25, 13.44, 10.04, 61.44, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 3, 6.05, 25, 3.40, 1.84, 18.14, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 4, 5.84, 25, 5.40, 0.81, 31.96, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 5, 7.75, 25, 5.18, 1.85, 27.23, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 6, 11.07, 25, 8.48, 2.06, 42.40, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 7, 4.08, 25, 4.15, 0.47, 27.53, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 8, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 9, 24.77, 25, 14.94, 5.92, 63.27, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 1, 5.42, 25, 4.48, 0.94, 25.80, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 2, 4.54, 25, 3.82, 0.77, 22.66, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 3, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 4, 10.75, 25, 8.45, 1.92, 42.60, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 5, 41.64, 25, 14.28, 17.50, 70.59, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 6, 13.76, 25, 8.25, 3.66, 40.14, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 7, 6.17, 25, 6.19, 0.72, 37.37, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 8, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 9, 17.72, 25, 14.57, 2.67, 62.88, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 1, 5.82, 23, 5.44, 0.78, 32.64, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 2, 57.03, 23, 12.32, 31.87, 79.01, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 3, 2.67, 23, 2.67, 0.32, 18.84, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 4, 8.08, 23, 4.86, 2.21, 25.45, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 5, 18.90, 23, 10.85, 5.10, 50.29, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 6, 2.60, 23, 2.68, 0.30, 19.33, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 7, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 8, 4.91, 23, 4.69, 0.64, 29.33, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 9, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 10, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 11, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 12, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 1, 7.60, 24, 5.38, 1.66, 28.62, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 2, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 3, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 4, 2.40, 24, 2.41, 0.29, 17.16, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 5, 36.14, 24, 12.73, 15.31, 63.91, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 6, 24.67, 24, 10.18, 9.53, 50.43, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 7, 14.80, 24, 10.34, 3.09, 48.65, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 8, 13.54, 24, 6.77, 4.52, 34.13, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 10, 0.86, 24, 0.90, 0.10, 7.14, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 11, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 1, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 2, 22.80, 24, 10.36, 8.04, 49.94, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 3, 12.88, 24, 5.98, 4.68, 30.79, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 4, 40.58, 24, 11.60, 20.16, 64.87, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 5, 16.93, 24, 10.12, 4.40, 47.46, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 6, 4.41, 24, 4.25, 0.57, 27.10, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 7, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 8, 2.40, 24, 2.41, 0.29, 17.16, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 1, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 2, 11.00, 24, 9.28, 1.71, 46.77, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 3, 47.18, 24, 11.15, 26.15, 69.27, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 4, 19.89, 24, 7.89, 8.18, 40.90, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 5, 15.11, 24, 10.02, 3.41, 47.24, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 6, 4.41, 24, 4.25, 0.57, 27.10, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 7, 2.40, 24, 2.41, 0.29, 17.16, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 8, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 1, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 2, 0.01, 18, 0.01, 0.00, 0.09, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 3, 41.95, 18, 18.34, 12.86, 77.97, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 4, 31.58, 18, 17.82, 7.50, 72.44, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 5, 21.61, 18, 16.09, 3.58, 67.17, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 6, 4.85, 18, 3.58, 0.99, 20.72, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 7, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 8, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 9, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 10, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 11, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 12, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 1, 12.73, 18, 12.43, 1.36, 60.71, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 2, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 3, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 4, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 5, 32.73, 18, 17.84, 8.09, 72.90, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 6, 0.04, 18, 0.04, 0.00, 0.33, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 7, 54.28, 18, 19.28, 18.73, 85.95, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 8, 0.22, 18, 0.16, 0.05, 0.97, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 9, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 10, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 11, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 1, 38.71, 18, 18.41, 10.94, 76.45, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 2, 8.13, 18, 8.24, 0.86, 47.55, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 3, 39.20, 18, 20.20, 9.73, 79.40, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 4, 3.32, 18, 3.44, 0.36, 24.70, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 5, 7.65, 18, 6.21, 1.28, 34.57, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 6, 2.99, 18, 3.00, 0.35, 21.47, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 7, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 8, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 9, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 1, 22.95, 17, 19.26, 2.87, 74.99, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 2, 10.04, 17, 10.01, 1.05, 53.92, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 3, 19.86, 17, 15.05, 3.23, 64.78, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 4, 0.01, 17, 0.01, 0.00, 0.11, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 5, 47.01, 17, 19.43, 14.52, 82.26, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 6, 0.12, 17, 0.13, 0.01, 1.17, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 7, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 8, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 9, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 1, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 2, 9.99, 27, 8.92, 1.42, 46.05, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 3, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 4, 9.99, 27, 8.92, 1.42, 46.05, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 5, 0.99, 27, 1.01, 0.12, 7.70, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 6, 50.82, 27, 15.66, 22.18, 78.94, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 7, 1.47, 27, 1.52, 0.17, 11.43, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 8, 14.74, 27, 9.02, 3.80, 43.04, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 9, 2.01, 27, 2.07, 0.24, 15.11, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 10, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 11, 9.99, 27, 8.92, 1.42, 46.05, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 12, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 1, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 2, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 3, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 4, 9.99, 27, 8.92, 1.42, 46.05, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 5, 10.98, 27, 9.82, 1.54, 49.29, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 6, 1.72, 27, 1.52, 0.28, 10.00, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 7, 16.16, 27, 9.06, 4.65, 43.24, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 8, 44.61, 27, 10.98, 24.41, 66.75, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 9, 3.31, 27, 2.51, 0.68, 14.63, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 10, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 11, 13.22, 27, 11.86, 1.79, 56.06, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 1, 13.95, 26, 9.21, 3.23, 44.07, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 2, 24.88, 26, 12.54, 7.68, 56.87, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 3, 15.09, 26, 10.53, 3.17, 49.12, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 4, 1.33, 26, 1.10, 0.24, 7.03, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 5, 28.21, 26, 18.95, 5.41, 72.98, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 6, 16.22, 26, 12.21, 2.95, 55.19, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 7, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 8, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 9, 0.32, 26, 0.33, 0.04, 2.68, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 1, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 2, 11.83, 27, 8.98, 2.24, 44.06, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 3, 14.47, 27, 10.35, 2.94, 48.54, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 4, 18.57, 27, 10.67, 5.07, 49.32, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 5, 41.02, 27, 19.39, 11.81, 78.32, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 6, 13.80, 27, 9.08, 3.23, 43.48, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 7, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 8, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 9, 0.31, 27, 0.33, 0.04, 2.63, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 2, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 3, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 4, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 5, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 6, 51.85, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 7, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 8, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 9, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 10, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 11, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 12, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 1, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 2, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 3, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 4, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 5, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 6, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 7, 25.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 8, 40.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 9, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 10, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 11, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 1, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 2, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 3, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 4, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 5, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 6, 22.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 7, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 8, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 9, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 1, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 2, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 3, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 4, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 5, 33.33, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 6, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 7, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 8, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 9, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 1, 0.00, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 2, 0.00, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 3, 0.00, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 4, 0.00, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 5, 0.00, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 6, 63.64, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 7, 6.06, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 8, 21.21, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 9, 3.03, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 10, 3.03, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 11, 3.03, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 12, 0.00, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 1, 0.00, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 2, 0.00, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 3, 0.00, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 4, 0.00, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 5, 6.06, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 6, 3.03, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 7, 36.36, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 8, 27.27, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 9, 18.18, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 10, 6.06, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 11, 3.03, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 1, 18.18, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 2, 27.27, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 3, 21.21, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 4, 9.09, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 5, 12.12, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 6, 9.09, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 7, 3.03, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 8, 0.00, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 9, 0.00, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 1, 3.03, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 2, 12.12, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 3, 36.36, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 4, 9.09, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 5, 21.21, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 6, 12.12, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 7, 3.03, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 8, 3.03, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 9, 0.00, 33, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 2, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 3, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 4, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 5, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 6, 66.67, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 7, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 8, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 9, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 10, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 11, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '2.D.1', 'RL', 12, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 1, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 2, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 3, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 4, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 5, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 6, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 7, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 8, 33.33, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 9, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 10, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.1', 'RW', 11, 22.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 1, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 2, 25.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 3, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 4, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 5, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 6, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 7, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 8, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.2', 'PT', 9, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 1, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 2, 29.63, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 3, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 4, 22.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 5, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 6, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 7, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 8, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.04', '3.A.3', 'OJ', 9, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 1, 0.52, 34, 0.53, 0.06, 4.04, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 2, 11.64, 34, 7.02, 3.18, 34.56, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 3, 0.00, 34, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 4, 24.65, 34, 10.63, 9.26, 51.19, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 5, 2.55, 34, 2.54, 0.33, 17.30, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 6, 49.79, 34, 11.61, 27.83, 71.83, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 7, 2.70, 34, 2.02, 0.58, 11.74, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 8, 5.60, 34, 4.01, 1.25, 21.74, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 9, 0.00, 34, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 10, 2.55, 34, 2.47, 0.34, 16.53, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 11, 0.00, 34, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 12, 0.00, 34, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 1, 3.85, 32, 3.36, 0.62, 20.31, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 2, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 3, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 4, 16.87, 32, 11.03, 3.92, 50.24, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 5, 5.33, 32, 3.55, 1.32, 19.11, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 6, 29.93, 32, 10.44, 13.40, 54.10, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 7, 13.67, 32, 8.65, 3.43, 41.38, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 8, 14.50, 32, 6.00, 5.95, 31.27, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 9, 6.26, 32, 6.05, 0.81, 35.34, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 10, 5.02, 32, 5.06, 0.60, 31.50, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 11, 4.57, 32, 3.61, 0.87, 20.60, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 1, 7.73, 33, 5.40, 1.76, 28.17, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 2, 26.03, 33, 10.37, 10.51, 51.32, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 3, 11.69, 33, 5.22, 4.51, 27.04, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 4, 22.93, 33, 11.50, 7.33, 52.83, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 5, 9.64, 33, 4.90, 3.28, 25.11, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 6, 14.10, 33, 8.88, 3.56, 42.21, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 7, 1.62, 33, 1.26, 0.33, 7.59, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 8, 6.26, 33, 4.43, 1.42, 23.69, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 9, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 1, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 2, 10.24, 33, 4.78, 3.81, 24.77, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 3, 24.58, 33, 10.93, 8.93, 52.00, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 4, 37.28, 33, 11.16, 18.35, 61.12, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 5, 8.88, 33, 5.87, 2.18, 29.92, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 6, 10.70, 33, 5.79, 3.37, 29.17, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 7, 4.98, 33, 3.27, 1.27, 17.64, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 8, 3.34, 33, 3.35, 0.41, 22.23, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 9, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 1, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 2, 43.97, 31, 16.47, 16.69, 75.46, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 3, 26.40, 31, 17.17, 5.57, 68.57, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 4, 3.19, 31, 2.08, 0.83, 11.53, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 5, 6.42, 31, 4.83, 1.31, 26.19, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 6, 20.01, 31, 12.17, 5.03, 54.17, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 7, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 8, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 9, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 10, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 11, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 12, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 1, 13.63, 31, 11.54, 2.09, 53.87, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 2, 0.56, 31, 0.59, 0.07, 4.68, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 3, 0.18, 31, 0.19, 0.02, 1.53, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 4, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 5, 2.29, 31, 1.89, 0.42, 11.60, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 6, 30.86, 31, 19.16, 6.66, 73.63, 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 7, 39.51, 31, 19.33, 11.13, 77.31, 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 8, 9.12, 31, 5.73, 2.39, 29.18, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 9, 1.49, 31, 1.54, 0.17, 11.51, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 10, 1.99, 31, 1.76, 0.32, 11.37, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 11, 0.37, 31, 0.28, 0.08, 1.72, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 1, 14.98, 31, 11.64, 2.65, 53.26, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 2, 14.63, 31, 11.69, 2.47, 53.68, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 3, 11.72, 31, 6.57, 3.50, 32.67, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 4, 30.36, 31, 19.18, 6.40, 73.55, 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 5, 4.50, 31, 3.26, 0.99, 18.12, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 6, 23.20, 31, 18.48, 3.51, 71.53, 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 7, 0.61, 31, 0.50, 0.12, 3.16, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 8, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 9, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 1, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 2, 1.39, 31, 0.93, 0.35, 5.32, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 3, 17.14, 31, 11.83, 3.64, 53.14, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 4, 37.25, 31, 19.33, 9.88, 76.27, 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 5, 3.46, 31, 2.19, 0.93, 12.01, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 6, 27.42, 31, 18.58, 5.32, 71.76, 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 7, 13.14, 31, 11.52, 1.89, 54.32, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 8, 0.20, 31, 0.21, 0.02, 1.72, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 9, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 1, 11.92, 24, 10.54, 1.67, 51.90, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 2, 13.60, 24, 7.05, 4.35, 35.25, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 3, 3.13, 24, 2.75, 0.49, 17.44, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 4, 39.59, 24, 19.46, 10.85, 77.92, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 5, 8.88, 24, 7.89, 1.28, 42.30, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 6, 22.88, 24, 18.05, 3.45, 71.11, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 7, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 8, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 10, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 11, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 12, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 1, 11.92, 24, 9.02, 2.24, 44.47, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 2, 1.95, 24, 1.60, 0.35, 10.16, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 3, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 4, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 5, 6.43, 24, 4.42, 1.48, 23.92, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 6, 10.35, 24, 8.31, 1.78, 42.41, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 7, 40.97, 24, 20.93, 10.38, 80.61, 'Y', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 8, 15.84, 24, 11.38, 3.12, 52.38, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 9, 2.04, 24, 1.65, 0.38, 10.29, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 10, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 11, 10.50, 24, 9.06, 1.57, 46.31, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 1, 3.58, 23, 2.81, 0.68, 16.72, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 2, 10.64, 23, 6.17, 3.00, 31.39, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 3, 25.08, 23, 12.44, 7.82, 56.92, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 4, 12.29, 23, 9.76, 2.10, 47.82, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 5, 12.29, 23, 11.84, 1.42, 57.73, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 6, 29.69, 23, 9.69, 13.89, 52.51, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 7, 1.58, 23, 1.64, 0.18, 12.54, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 8, 4.85, 23, 4.01, 0.83, 23.62, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 9, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 1, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 2, 5.53, 24, 3.78, 1.29, 20.74, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 3, 5.80, 24, 4.21, 1.24, 23.28, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 4, 23.92, 24, 12.93, 6.74, 57.76, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 5, 21.91, 24, 11.52, 6.52, 53.03, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 6, 38.49, 24, 9.44, 21.53, 58.81, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 7, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 8, 4.34, 24, 3.53, 0.77, 20.85, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 1, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 2, 11.19, 17, 8.56, 1.99, 43.88, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 3, 7.90, 17, 7.70, 0.90, 44.69, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 4, 41.81, 17, 16.58, 14.49, 75.28, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 5, 2.56, 17, 2.63, 0.28, 19.78, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 6, 33.40, 17, 15.94, 9.89, 69.62, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 7, 2.58, 17, 2.65, 0.28, 19.91, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 8, 0.57, 17, 0.59, 0.06, 5.05, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 9, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 10, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 11, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 12, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 1, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 2, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 3, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 4, 22.16, 17, 13.25, 5.29, 59.20, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 5, 18.57, 17, 14.00, 3.10, 61.90, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 6, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 7, 23.13, 17, 11.82, 6.84, 55.20, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 8, 29.00, 17, 14.38, 8.50, 64.22, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 9, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 10, 6.58, 17, 4.95, 1.26, 27.96, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 11, 0.57, 17, 0.59, 0.06, 5.05, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 1, 22.10, 16, 13.73, 4.93, 60.83, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 2, 28.21, 16, 14.40, 7.95, 64.14, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 3, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 4, 22.54, 16, 12.39, 6.03, 56.91, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 5, 17.09, 16, 15.02, 2.11, 66.39, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 6, 6.19, 16, 5.77, 0.79, 35.40, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 7, 3.86, 16, 3.93, 0.42, 27.76, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 8, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 9, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 1, 0.57, 17, 0.59, 0.06, 5.05, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 2, 10.79, 17, 8.44, 1.85, 43.70, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 3, 44.95, 17, 15.50, 17.79, 75.50, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 4, 31.46, 17, 15.45, 9.13, 67.71, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 5, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 6, 12.23, 17, 7.05, 3.35, 35.91, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 7, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 8, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 9, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2004-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 1, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 2, 11.58, 24, 6.64, 3.31, 33.38, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 3, 5.91, 24, 6.35, 0.59, 40.07, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 4, 7.64, 24, 6.66, 1.16, 36.82, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 5, 5.67, 24, 5.56, 0.70, 33.99, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 6, 69.21, 24, 5.32, 57.27, 79.03, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 7, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 8, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 10, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 11, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '2.D.1', 'RL', 12, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 1, 5.52, 25, 5.41, 0.68, 33.22, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 2, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 3, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 4, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 5, 11.26, 25, 6.52, 3.19, 32.80, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 6, 17.19, 25, 7.87, 6.22, 39.40, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 7, 17.00, 25, 4.08, 10.14, 27.11, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 8, 23.92, 25, 9.52, 9.65, 48.07, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 9, 8.05, 25, 5.06, 2.09, 26.39, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 10, 5.74, 25, 6.17, 0.58, 39.07, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.1', 'RW', 11, 11.32, 25, 6.95, 2.96, 34.78, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 1, 6.61, 25, 5.47, 1.12, 30.63, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 2, 21.12, 25, 13.67, 4.69, 59.27, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 3, 11.26, 25, 6.52, 3.19, 32.80, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 4, 10.95, 25, 7.87, 2.27, 39.40, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 5, 17.06, 25, 6.93, 6.96, 36.11, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 6, 19.75, 25, 9.57, 6.61, 46.11, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 7, 7.95, 25, 5.19, 1.96, 27.20, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 8, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.2', 'PT', 9, 5.30, 25, 4.92, 0.73, 29.74, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 1, 6.11, 25, 5.45, 0.91, 31.61, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 2, 12.63, 25, 8.05, 3.11, 39.47, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 3, 14.51, 25, 6.41, 5.52, 33.03, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 4, 10.72, 25, 6.89, 2.65, 34.67, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 5, 16.69, 25, 13.29, 2.71, 59.04, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 6, 25.05, 25, 9.79, 10.23, 49.50, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 7, 8.49, 25, 4.95, 2.43, 25.70, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 8, 0.50, 25, 0.51, 0.06, 4.02, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.01', '3.A.3', 'OJ', 9, 5.30, 25, 4.92, 0.73, 29.74, 'N', TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 1, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 2, 6.02, 32, 3.78, 1.61, 20.01, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 3, 25.43, 32, 8.78, 11.70, 46.73, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 4, 7.05, 32, 5.64, 1.30, 30.51, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 5, 12.86, 32, 7.15, 3.86, 35.17, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 6, 34.94, 32, 10.71, 17.05, 58.40, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 7, 13.70, 32, 7.83, 3.95, 38.00, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 8, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 9, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 10, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 11, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '2.D.1', 'RL', 12, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 1, 20.57, 32, 11.59, 5.75, 52.40, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 2, 6.64, 32, 5.68, 1.09, 31.53, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 3, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 4, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 5, 10.84, 32, 5.91, 3.38, 29.74, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 6, 19.70, 32, 7.10, 8.94, 37.99, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 7, 24.36, 32, 8.02, 11.71, 43.89, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 8, 7.33, 32, 6.34, 1.17, 34.65, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 9, 1.85, 32, 1.61, 0.31, 10.34, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 10, 1.64, 32, 1.70, 0.19, 12.56, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.1', 'RW', 11, 7.05, 32, 6.45, 1.01, 36.10, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 1, 0.41, 32, 0.44, 0.05, 3.62, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 2, 34.17, 32, 10.15, 17.14, 56.58, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 3, 19.33, 32, 8.76, 7.08, 42.97, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 4, 26.70, 32, 11.63, 9.78, 55.04, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 5, 17.60, 32, 7.29, 7.12, 37.32, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 6, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 7, 1.79, 32, 1.10, 0.51, 6.15, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 8, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.2', 'PT', 9, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 1, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 2, 10.80, 32, 5.88, 3.37, 29.62, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 3, 30.16, 32, 12.41, 11.50, 58.94, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 4, 22.02, 32, 10.70, 7.34, 50.16, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 5, 21.52, 32, 6.82, 10.75, 38.45, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 6, 6.64, 32, 6.79, 0.76, 39.89, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 7, 1.79, 32, 1.10, 0.51, 6.15, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 8, 0.41, 32, 0.44, 0.05, 3.62, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.02', '3.A.3', 'OJ', 9, 6.64, 32, 6.61, 0.80, 38.51, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 1, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 2, 30.86, 27, 8.38, 16.60, 50.02, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 3, 3.51, 27, 2.91, 0.62, 17.52, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 4, 10.67, 27, 10.36, 1.26, 52.71, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 5, 22.99, 27, 8.37, 10.16, 44.09, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 6, 31.96, 27, 4.23, 23.95, 41.20, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 7, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 8, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 9, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 10, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 11, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 12, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 1, 0.25, 26, 0.26, 0.03, 2.08, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 2, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 3, 0.06, 26, 0.08, 0.00, 0.76, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 4, 22.60, 26, 8.57, 9.63, 44.47, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 5, 0.73, 26, 0.91, 0.06, 8.83, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 6, 28.53, 26, 6.46, 17.22, 43.39, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 7, 15.79, 26, 12.74, 2.54, 57.45, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 8, 9.34, 26, 9.86, 0.93, 53.12, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 9, 0.09, 26, 0.11, 0.01, 1.12, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 10, 22.60, 26, 8.57, 9.63, 44.47, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 11, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 1, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 2, 0.60, 26, 0.58, 0.08, 4.20, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 3, 50.08, 26, 14.64, 23.09, 77.02, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 4, 5.92, 26, 5.36, 0.86, 31.33, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 5, 1.58, 26, 1.82, 0.14, 15.29, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 6, 32.05, 26, 4.22, 24.05, 41.27, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 7, 9.77, 26, 10.00, 1.04, 52.82, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 8, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 9, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 1, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 2, 0.71, 27, 0.68, 0.10, 4.98, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 3, 8.56, 27, 9.56, 0.76, 53.52, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 4, 24.52, 27, 7.83, 11.98, 43.67, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 5, 24.64, 27, 7.77, 12.14, 43.60, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 6, 32.26, 27, 4.17, 24.34, 41.34, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 7, 9.32, 27, 9.83, 0.93, 52.87, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 8, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 9, 0.00, 27, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 1, 0.00, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 2, 1.75, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 3, 0.00, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 4, 1.75, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 5, 5.26, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 6, 80.70, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 7, 8.77, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 8, 1.75, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 9, 0.00, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 10, 0.00, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 11, 0.00, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 12, 0.00, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 1, 31.58, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 2, 0.00, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 3, 0.00, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 4, 7.02, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 5, 21.05, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 6, 14.04, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 7, 12.28, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 8, 8.77, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 9, 5.26, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 10, 0.00, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 11, 0.00, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 1, 7.02, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 2, 19.30, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 3, 12.28, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 4, 15.79, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 5, 28.07, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 6, 12.28, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 7, 3.51, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 8, 1.75, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 9, 0.00, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 1, 1.75, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 2, 1.75, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 3, 10.53, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 4, 17.54, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 5, 42.11, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 6, 17.54, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 7, 8.77, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 8, 0.00, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 9, 0.00, 57, NULL, NULL, NULL, NULL, TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 1, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 2, 66.83, 36, 12.40, 39.30, 86.25, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 3, 11.00, 36, 7.24, 2.68, 35.67, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 4, 15.63, 36, 8.87, 4.51, 42.07, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 5, 1.49, 36, 1.16, 0.30, 7.03, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 6, 5.05, 36, 4.80, 0.69, 28.84, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 7, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 8, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 9, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 10, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 11, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '2.D.1', 'RL', 12, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 1, 20.53, 36, 10.30, 6.69, 48.22, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 2, 2.33, 36, 1.83, 0.46, 10.88, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 3, 10.13, 36, 8.55, 1.65, 43.16, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 4, 11.45, 36, 10.11, 1.68, 49.47, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 5, 10.22, 36, 8.19, 1.82, 41.10, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 6, 10.46, 36, 5.73, 3.26, 28.81, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 7, 20.00, 36, 9.91, 6.64, 46.79, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 8, 14.87, 36, 9.66, 3.58, 45.13, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 9, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 10, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.1', 'RW', 11, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 1, 11.66, 35, 9.49, 1.99, 46.20, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 2, 25.90, 35, 16.91, 5.51, 67.68, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 3, 23.81, 35, 12.21, 7.37, 55.11, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 4, 17.15, 35, 11.02, 4.10, 50.03, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 5, 16.19, 35, 11.06, 3.56, 50.30, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 6, 1.09, 35, 1.12, 0.13, 8.36, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 7, 4.20, 35, 4.22, 0.52, 26.99, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 8, 0.00, 35, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.2', 'PT', 9, 0.00, 35, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 1, 1.37, 36, 1.40, 0.17, 10.26, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 2, 21.59, 36, 17.04, 3.44, 68.01, 'Y', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 3, 21.87, 36, 12.07, 6.26, 54.01, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 4, 17.31, 36, 10.96, 4.24, 49.76, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 5, 30.74, 36, 13.94, 10.52, 62.64, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 6, 2.93, 36, 1.34, 1.15, 7.26, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 7, 4.19, 36, 4.21, 0.52, 26.89, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 8, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.02', '3.A.3', 'OJ', 9, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 1, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 2, 7.57, 24, 6.43, 1.21, 35.40, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 3, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 4, 7.88, 24, 7.43, 1.02, 41.57, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 5, 5.89, 24, 5.38, 0.83, 31.81, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 6, 72.25, 24, 11.94, 43.17, 89.92, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 7, 1.00, 24, 1.01, 0.12, 7.75, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 8, 5.42, 24, 5.34, 0.66, 33.07, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 10, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 11, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 12, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 1, 3.23, 24, 2.42, 0.67, 14.20, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 2, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 3, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 4, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 5, 16.53, 24, 9.09, 4.83, 43.62, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 6, 7.20, 24, 5.07, 1.59, 27.15, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 7, 61.60, 24, 12.84, 34.30, 83.14, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 8, 11.43, 24, 7.75, 2.58, 38.61, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 10, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 11, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 1, 26.67, 24, 12.63, 8.73, 58.05, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 2, 19.34, 24, 15.53, 2.97, 65.27, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 3, 2.75, 24, 2.25, 0.50, 13.88, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 4, 3.04, 24, 2.93, 0.40, 19.71, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 5, 22.16, 24, 8.82, 9.00, 45.04, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 6, 25.13, 24, 14.86, 6.15, 63.23, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 7, 0.90, 24, 0.91, 0.11, 7.04, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 8, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 1, 9.76, 24, 9.13, 1.25, 48.04, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 2, 7.88, 24, 7.43, 1.02, 41.57, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 3, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 4, 15.15, 24, 7.84, 4.81, 38.67, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 5, 19.30, 24, 9.58, 6.28, 46.06, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 6, 44.88, 24, 14.13, 19.98, 72.64, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 7, 3.04, 24, 1.99, 0.77, 11.27, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 8, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2006-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 1, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 2, 29.41, 20, 14.94, 8.45, 65.27, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 3, 41.24, 20, 14.33, 16.92, 70.75, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 4, 0.17, 20, 0.15, 0.03, 1.06, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 5, 24.22, 20, 21.23, 2.76, 78.24, 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 6, 4.91, 20, 5.90, 0.36, 42.14, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 7, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 8, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 9, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 10, 0.05, 20, 0.06, 0.01, 0.56, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 11, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 12, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 1, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 2, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 3, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 4, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 5, 63.93, 19, 31.32, 9.27, 96.85, 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 6, 0.89, 19, 0.75, 0.15, 5.10, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 7, 34.45, 19, 30.63, 2.95, 90.08, 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 8, 0.45, 19, 0.36, 0.08, 2.43, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 9, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 10, 0.07, 19, 0.08, 0.01, 0.80, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 11, 0.19, 19, 0.18, 0.03, 1.40, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 1, 24.22, 20, 15.71, 5.06, 65.73, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 2, 0.12, 20, 0.10, 0.02, 0.72, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 3, 40.53, 20, 28.36, 5.49, 88.88, 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 4, 4.60, 20, 5.79, 0.30, 43.38, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 5, 29.94, 20, 14.85, 8.85, 65.27, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 6, 0.44, 20, 0.29, 0.11, 1.74, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 7, 0.10, 20, 0.11, 0.01, 1.05, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 8, 0.05, 20, 0.06, 0.01, 0.56, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 9, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 1, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 2, 16.26, 20, 18.23, 1.16, 76.20, 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 3, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 4, 48.83, 20, 14.79, 21.66, 76.70, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 5, 34.33, 20, 14.18, 12.29, 66.10, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 6, 0.32, 20, 0.23, 0.07, 1.49, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 7, 0.17, 20, 0.15, 0.03, 1.06, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 8, 0.10, 20, 0.08, 0.02, 0.50, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 9, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 3, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 4, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 5, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 6, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 8, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 10, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 11, 35.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 12, 40.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 1, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 5, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 6, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 7, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 8, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 9, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 10, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 11, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 1, 45.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 2, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 3, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 4, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 5, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 6, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 8, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 9, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 1, 35.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 2, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 3, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 4, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 5, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 6, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 7, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 8, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 1, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 2, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 3, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 4, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 5, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 6, 78.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 7, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 8, 6.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 9, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 10, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 11, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 12, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 1, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 2, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 3, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 4, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 5, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 6, 25.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 7, 40.62, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 8, 25.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 9, 6.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 10, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 11, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 1, 18.75, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 2, 21.88, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 3, 12.50, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 4, 6.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 5, 25.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 6, 12.50, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 7, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 8, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 9, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 1, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 2, 6.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 3, 15.62, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 4, 15.62, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 5, 37.50, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 6, 18.75, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 7, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 8, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 9, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 1, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 2, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 3, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 4, 7.14, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 5, 14.29, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 6, 64.29, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 7, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 8, 7.14, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 9, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 10, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 11, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 12, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 1, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 2, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 3, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 4, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 5, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 6, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 7, 29.63, 27, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 8, 22.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 9, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 10, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 11, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 1, 10.71, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 2, 7.14, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 3, 17.86, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 4, 17.86, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 5, 14.29, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 6, 10.71, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 7, 10.71, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 8, 10.71, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 9, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 1, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 2, 7.14, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 3, 7.14, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 4, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 5, 35.71, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 6, 10.71, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 7, 28.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 8, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 9, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 1, 48.00, 13, 21.88, 12.03, 86.17, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 2, 42.83, 13, 22.34, 9.30, 84.55, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 3, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 4, 8.90, 13, 9.13, 0.83, 53.18, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 5, 0.14, 13, 0.16, 0.01, 1.72, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 6, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 7, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 8, 0.14, 13, 0.15, 0.01, 1.47, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 9, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 10, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 11, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 12, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 1, 18.06, 13, 16.64, 1.87, 71.86, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 2, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 3, 1.38, 13, 1.27, 0.18, 9.68, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 4, 3.83, 13, 4.04, 0.36, 30.31, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 5, 24.37, 13, 20.45, 2.79, 78.32, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 6, 33.54, 13, 21.23, 5.96, 80.08, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 7, 18.68, 13, 16.73, 2.04, 71.67, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 8, 0.14, 13, 0.15, 0.01, 1.47, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 9, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 10, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 11, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 1, 46.65, 13, 22.21, 11.12, 85.94, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 2, 0.14, 13, 0.15, 0.01, 1.47, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 3, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 4, 1.10, 13, 1.19, 0.10, 10.78, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 5, 33.41, 13, 21.18, 5.93, 79.97, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 6, 18.70, 13, 16.72, 2.05, 71.63, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 7, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 8, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 9, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 1, 21.89, 13, 17.05, 3.09, 71.10, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 2, 1.38, 13, 1.27, 0.18, 9.68, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 3, 24.63, 13, 20.38, 2.90, 78.13, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 4, 0.14, 13, 0.15, 0.01, 1.47, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 5, 33.41, 13, 21.18, 5.93, 79.97, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 6, 0.14, 13, 0.16, 0.01, 1.72, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 7, 18.42, 13, 16.70, 1.97, 71.78, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 8, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 9, 0.00, 13, 0.00, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 1, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 2, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 3, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 4, 0.43, 18, 0.46, 0.04, 4.10, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 5, 10.51, 18, 9.46, 1.39, 49.52, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 6, 64.85, 18, 18.39, 25.16, 91.01, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 7, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 8, 2.57, 18, 1.49, 0.74, 8.48, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 9, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 10, 21.65, 18, 18.74, 2.61, 73.99, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 11, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 12, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 1, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 2, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 3, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 4, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 5, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 6, 32.16, 18, 18.46, 7.36, 73.86, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 7, 22.07, 18, 19.32, 2.58, 75.18, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 8, 0.86, 18, 0.70, 0.15, 4.71, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 9, 0.43, 18, 0.46, 0.04, 4.10, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 10, 22.93, 18, 18.71, 3.09, 73.53, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 11, 21.55, 18, 12.52, 5.45, 56.71, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 1, 0.86, 18, 0.70, 0.15, 4.71, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 2, 21.65, 18, 18.74, 2.61, 73.99, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 3, 10.94, 18, 9.47, 1.55, 48.85, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 4, 31.84, 18, 20.41, 6.03, 77.26, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 5, 11.37, 18, 9.48, 1.73, 48.29, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 6, 22.07, 18, 18.73, 2.77, 73.81, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 7, 0.43, 18, 0.46, 0.04, 4.10, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 8, 0.86, 18, 0.70, 0.15, 4.71, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 9, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 1, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 2, 11.84, 17, 9.54, 1.90, 48.22, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 3, 22.60, 17, 18.80, 2.91, 74.02, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 4, 22.17, 17, 19.40, 2.56, 75.54, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 5, 42.53, 17, 18.96, 12.50, 79.31, 'Y', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 6, 0.43, 17, 0.47, 0.04, 4.16, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 7, 0.43, 17, 0.47, 0.04, 4.16, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 8, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 9, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 1, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 2, 8.63, 19, 7.94, 1.13, 43.91, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 3, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 4, 7.38, 19, 7.28, 0.84, 42.73, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 5, 8.23, 19, 7.91, 0.98, 44.77, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 6, 50.62, 19, 17.52, 19.03, 81.72, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 7, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 8, 19.50, 19, 16.16, 2.71, 67.82, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 9, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 10, 5.65, 19, 5.67, 0.64, 35.88, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 11, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 12, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 1, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 2, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 3, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 4, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 5, 8.07, 19, 7.91, 0.93, 45.16, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 6, 15.44, 19, 10.55, 3.24, 49.92, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 7, 51.09, 19, 17.51, 19.33, 82.00, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 8, 18.99, 19, 16.19, 2.50, 68.14, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 9, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 10, 5.65, 19, 5.67, 0.64, 35.88, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 11, 0.76, 19, 0.61, 0.14, 4.04, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 1, 14.45, 19, 12.81, 1.88, 59.84, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 2, 19.13, 19, 16.19, 2.56, 68.06, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 3, 4.58, 19, 4.38, 0.58, 28.29, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 4, 42.19, 19, 17.25, 14.17, 76.33, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 5, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 6, 19.65, 19, 11.03, 5.34, 51.47, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 7, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 8, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 9, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 1, 14.71, 18, 13.54, 1.74, 62.68, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 2, 0.48, 18, 0.52, 0.05, 4.49, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 3, 19.41, 18, 11.20, 5.05, 52.16, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 4, 55.95, 18, 17.62, 21.94, 85.16, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 5, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 6, 9.27, 18, 8.44, 1.22, 45.89, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 7, 0.17, 18, 0.18, 0.02, 1.55, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 8, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 9, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 1, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 2, 6.18, 22, 4.59, 1.26, 25.45, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 3, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 4, 14.87, 22, 8.92, 3.88, 43.05, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 5, 28.71, 22, 9.71, 13.06, 51.92, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 6, 47.95, 22, 12.20, 25.00, 71.81, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 7, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 8, 2.28, 22, 2.32, 0.27, 16.87, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 9, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 10, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 11, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 12, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 1, 5.01, 22, 4.90, 0.62, 31.00, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 2, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 3, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 4, 4.58, 22, 4.53, 0.55, 29.35, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 5, 4.58, 22, 4.56, 0.54, 29.58, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 6, 32.99, 22, 13.39, 12.26, 63.43, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 7, 44.27, 22, 12.39, 21.85, 69.29, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 8, 4.58, 22, 4.56, 0.54, 29.58, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 9, 4.01, 22, 3.99, 0.48, 26.49, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 10, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 11, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 1, 3.22, 22, 3.25, 0.38, 22.56, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 2, 61.58, 22, 10.65, 38.59, 80.34, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 3, 15.23, 22, 7.08, 5.43, 35.98, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 4, 7.86, 22, 5.62, 1.67, 29.97, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 5, 12.11, 22, 6.63, 3.63, 33.47, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 6, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 7, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 8, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 9, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 1, 8.74, 22, 6.12, 1.90, 32.07, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 2, 14.55, 22, 6.94, 5.06, 35.22, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 3, 32.22, 22, 13.30, 11.82, 62.78, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 4, 23.04, 22, 10.29, 8.21, 50.03, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 5, 16.44, 22, 7.64, 5.83, 38.47, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 6, 5.01, 22, 4.90, 0.62, 31.00, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 7, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 8, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 9, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 1, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 2, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 3, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 4, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 5, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 6, 89.47, 19, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 8, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 9, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 10, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 11, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 12, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 4, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 5, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 6, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 7, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 8, 40.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 9, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 10, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 11, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 1, 40.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 2, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 3, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 4, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 5, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 6, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 8, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 2, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 3, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 4, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 5, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 6, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 8, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 1, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 2, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 3, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 4, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 5, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 6, 84.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 7, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 8, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 9, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 10, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 11, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 12, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 1, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 2, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 3, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 4, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 5, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 6, 21.88, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 7, 56.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 8, 12.50, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 9, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 10, 6.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 11, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 1, 12.50, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 2, 28.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 3, 15.62, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 4, 15.62, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 5, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 6, 12.50, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 7, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 8, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 9, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 1, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 2, 6.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 3, 25.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 4, 21.88, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 5, 21.88, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 6, 15.62, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 7, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 8, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 9, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 2, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 3, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 4, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 5, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 6, 70.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 7, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 8, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 10, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 11, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 12, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 4, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 5, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 6, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 7, 33.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 8, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 9, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 10, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 11, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 1, 54.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 2, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 3, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 4, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 5, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 6, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 8, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 1, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 2, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 3, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 4, 33.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 5, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 6, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 7, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 8, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 2, 33.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 3, 33.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 4, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 5, 25.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 6, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 8, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 10, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 11, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '2.D.1', 'RL', 12, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 1, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 2, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 3, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 4, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 5, 21.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 6, 39.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 7, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 8, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 9, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 10, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.1', 'RW', 11, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 2, 37.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 3, 29.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 4, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 5, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 6, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 8, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 2, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 3, 37.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 4, 29.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 5, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 6, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 8, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.01', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '2.D.1', 'RL', 1, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '2.D.1', 'RL', 2, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '2.D.1', 'RL', 3, 2.11, 63, 1.55, 0.48, 8.78, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '2.D.1', 'RL', 4, 1.79, 63, 1.83, 0.23, 12.71, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '2.D.1', 'RL', 5, 4.63, 63, 3.04, 1.21, 16.12, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '2.D.1', 'RL', 6, 79.47, 63, 6.02, 64.93, 89.01, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '2.D.1', 'RL', 7, 2.93, 63, 1.84, 0.82, 9.94, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '2.D.1', 'RL', 8, 5.14, 63, 2.18, 2.16, 11.71, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '2.D.1', 'RL', 9, 0.50, 63, 0.51, 0.07, 3.75, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '2.D.1', 'RL', 10, 3.43, 63, 3.38, 0.46, 21.48, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '2.D.1', 'RL', 11, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '2.D.1', 'RL', 12, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.1', 'RW', 1, 13.05, 63, 8.23, 3.40, 39.01, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.1', 'RW', 2, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.1', 'RW', 3, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.1', 'RW', 4, 0.56, 63, 0.57, 0.07, 4.21, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.1', 'RW', 5, 4.69, 63, 3.51, 1.02, 19.09, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.1', 'RW', 6, 2.10, 63, 1.72, 0.40, 10.23, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.1', 'RW', 7, 37.60, 63, 9.70, 20.86, 57.92, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.1', 'RW', 8, 34.13, 63, 10.87, 16.46, 57.67, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.1', 'RW', 9, 5.64, 63, 3.89, 1.37, 20.47, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.1', 'RW', 10, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.1', 'RW', 11, 2.22, 63, 1.54, 0.55, 8.60, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.2', 'PT', 1, 4.41, 62, 1.98, 1.78, 10.55, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.2', 'PT', 2, 16.89, 62, 5.71, 8.26, 31.43, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.2', 'PT', 3, 27.36, 62, 10.55, 11.53, 52.12, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.2', 'PT', 4, 30.34, 62, 10.77, 13.59, 54.69, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.2', 'PT', 5, 11.95, 62, 5.69, 4.39, 28.59, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.2', 'PT', 6, 2.89, 62, 1.77, 0.84, 9.50, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.2', 'PT', 7, 3.53, 62, 3.60, 0.44, 23.25, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.2', 'PT', 8, 2.63, 62, 1.63, 0.76, 8.77, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.2', 'PT', 9, 0.00, 62, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.3', 'OJ', 1, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.3', 'OJ', 2, 7.30, 63, 3.13, 3.03, 16.55, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.3', 'OJ', 3, 30.78, 63, 10.15, 14.65, 53.54, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.3', 'OJ', 4, 18.88, 63, 8.34, 7.27, 40.86, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.3', 'OJ', 5, 27.61, 63, 9.96, 12.34, 50.81, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.3', 'OJ', 6, 3.78, 63, 1.85, 1.40, 9.79, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.3', 'OJ', 7, 7.69, 63, 4.95, 2.02, 25.16, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.3', 'OJ', 8, 2.56, 63, 1.58, 0.73, 8.55, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.01', '3.A.3', 'OJ', 9, 1.41, 63, 1.40, 0.19, 9.66, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '2.D.1', 'RL', 1, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '2.D.1', 'RL', 2, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '2.D.1', 'RL', 3, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '2.D.1', 'RL', 4, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '2.D.1', 'RL', 5, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '2.D.1', 'RL', 6, 76.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '2.D.1', 'RL', 7, 16.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '2.D.1', 'RL', 8, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '2.D.1', 'RL', 9, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '2.D.1', 'RL', 10, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '2.D.1', 'RL', 11, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '2.D.1', 'RL', 12, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.1', 'RW', 1, 44.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.1', 'RW', 2, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.1', 'RW', 3, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.1', 'RW', 4, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.1', 'RW', 5, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.1', 'RW', 6, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.1', 'RW', 7, 24.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.1', 'RW', 8, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.1', 'RW', 9, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.1', 'RW', 10, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.1', 'RW', 11, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.2', 'PT', 1, 16.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.2', 'PT', 2, 32.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.2', 'PT', 3, 16.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.2', 'PT', 4, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.2', 'PT', 5, 16.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.2', 'PT', 6, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.2', 'PT', 7, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.2', 'PT', 8, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.2', 'PT', 9, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.3', 'OJ', 1, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.3', 'OJ', 2, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.3', 'OJ', 3, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.3', 'OJ', 4, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.3', 'OJ', 5, 24.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.3', 'OJ', 6, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.3', 'OJ', 7, 16.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.3', 'OJ', 8, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.02', '3.A.3', 'OJ', 9, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '2.D.1', 'RL', 1, 0.00, 52, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '2.D.1', 'RL', 2, 25.30, 52, 10.73, 9.77, 51.43, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '2.D.1', 'RL', 3, 28.19, 52, 11.11, 11.54, 54.17, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '2.D.1', 'RL', 4, 8.94, 52, 7.11, 1.67, 36.19, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '2.D.1', 'RL', 5, 10.01, 52, 7.21, 2.18, 35.70, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '2.D.1', 'RL', 6, 27.52, 52, 9.80, 12.40, 50.44, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '2.D.1', 'RL', 7, 0.05, 52, 0.05, 0.01, 0.36, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '2.D.1', 'RL', 8, 0.00, 52, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '2.D.1', 'RL', 9, 0.00, 52, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '2.D.1', 'RL', 10, 0.00, 52, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '2.D.1', 'RL', 11, 0.00, 52, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '2.D.1', 'RL', 12, 0.00, 52, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.1', 'RW', 1, 44.92, 52, 12.07, 23.45, 68.47, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.1', 'RW', 2, 0.07, 52, 0.08, 0.01, 0.59, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.1', 'RW', 3, 0.00, 52, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.1', 'RW', 4, 0.00, 52, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.1', 'RW', 5, 9.36, 52, 7.92, 1.56, 40.25, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.1', 'RW', 6, 11.46, 52, 7.55, 2.82, 36.59, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.1', 'RW', 7, 24.35, 52, 10.00, 9.76, 48.92, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.1', 'RW', 8, 9.60, 52, 7.07, 2.02, 35.28, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.1', 'RW', 9, 0.24, 52, 0.19, 0.05, 1.13, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.1', 'RW', 10, 0.00, 52, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.1', 'RW', 11, 0.00, 52, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.2', 'PT', 1, 25.50, 53, 11.29, 9.40, 53.02, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.2', 'PT', 2, 15.18, 53, 9.04, 4.20, 42.26, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.2', 'PT', 3, 9.87, 53, 5.74, 2.91, 28.58, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.2', 'PT', 4, 1.58, 53, 1.44, 0.25, 9.32, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.2', 'PT', 5, 1.74, 53, 0.80, 0.69, 4.33, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.2', 'PT', 6, 33.53, 53, 13.33, 13.18, 62.63, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.2', 'PT', 7, 10.51, 53, 7.20, 2.47, 35.31, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.2', 'PT', 8, 0.75, 53, 0.56, 0.17, 3.27, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.2', 'PT', 9, 1.35, 53, 1.41, 0.16, 10.32, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.3', 'OJ', 1, 20.08, 53, 11.26, 5.79, 50.65, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.3', 'OJ', 2, 4.22, 53, 4.18, 0.55, 25.96, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.3', 'OJ', 3, 15.39, 53, 9.04, 4.32, 42.30, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.3', 'OJ', 4, 3.47, 53, 2.99, 0.59, 17.76, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.3', 'OJ', 5, 22.72, 53, 8.74, 9.77, 44.40, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.3', 'OJ', 6, 23.25, 53, 9.67, 9.27, 47.33, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.3', 'OJ', 7, 10.51, 53, 7.20, 2.47, 35.31, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.3', 'OJ', 8, 0.36, 53, 0.31, 0.06, 1.98, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.01', '3.A.3', 'OJ', 9, 0.00, 53, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '2.D.1', 'RL', 1, 2.14, 42, 2.16, 0.27, 14.90, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '2.D.1', 'RL', 2, 9.20, 42, 5.40, 2.68, 27.20, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '2.D.1', 'RL', 3, 16.55, 42, 7.94, 5.84, 38.78, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '2.D.1', 'RL', 4, 16.91, 42, 7.43, 6.54, 37.17, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '2.D.1', 'RL', 5, 8.10, 42, 5.37, 2.01, 27.47, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '2.D.1', 'RL', 6, 35.52, 42, 9.46, 19.31, 55.91, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '2.D.1', 'RL', 7, 10.09, 42, 6.74, 2.44, 33.46, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '2.D.1', 'RL', 8, 0.00, 42, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '2.D.1', 'RL', 9, 0.00, 42, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '2.D.1', 'RL', 10, 0.00, 42, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '2.D.1', 'RL', 11, 1.49, 42, 1.51, 0.19, 10.80, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '2.D.1', 'RL', 12, 0.00, 42, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.1', 'RW', 1, 4.32, 43, 2.34, 1.42, 12.41, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.1', 'RW', 2, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.1', 'RW', 3, 5.57, 43, 4.11, 1.20, 22.22, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.1', 'RW', 4, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.1', 'RW', 5, 2.37, 43, 1.60, 0.60, 8.89, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.1', 'RW', 6, 34.72, 43, 9.78, 18.22, 55.95, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.1', 'RW', 7, 33.84, 43, 9.28, 18.14, 54.15, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.1', 'RW', 8, 6.42, 43, 5.02, 1.25, 27.05, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.1', 'RW', 9, 10.61, 43, 6.82, 2.70, 33.65, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.1', 'RW', 10, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.1', 'RW', 11, 2.15, 43, 1.37, 0.59, 7.57, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.2', 'PT', 1, 17.54, 43, 7.98, 6.53, 39.30, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.2', 'PT', 2, 8.43, 43, 5.37, 2.21, 27.26, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.2', 'PT', 3, 20.39, 43, 8.45, 8.22, 42.26, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.2', 'PT', 4, 7.68, 43, 5.43, 1.74, 28.09, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.2', 'PT', 5, 23.28, 43, 8.38, 10.53, 43.90, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.2', 'PT', 6, 10.37, 43, 5.89, 3.12, 29.37, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.2', 'PT', 7, 10.24, 43, 4.86, 3.78, 24.89, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.2', 'PT', 8, 2.08, 43, 1.63, 0.42, 9.61, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.2', 'PT', 9, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.3', 'OJ', 1, 5.55, 43, 5.07, 0.83, 29.27, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.3', 'OJ', 2, 3.74, 43, 3.71, 0.49, 23.68, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.3', 'OJ', 3, 8.01, 43, 5.46, 1.92, 27.96, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.3', 'OJ', 4, 2.26, 43, 1.16, 0.80, 6.27, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.3', 'OJ', 5, 28.96, 43, 9.28, 14.09, 50.33, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.3', 'OJ', 6, 24.57, 43, 8.60, 11.31, 45.39, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.3', 'OJ', 7, 22.96, 43, 8.02, 10.66, 42.68, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.3', 'OJ', 8, 3.94, 43, 2.24, 1.23, 11.94, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2021.02', '3.A.3', 'OJ', 9, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 1, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 2, 7.69, 39, 4.91, 2.01, 25.25, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 3, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 4, 5.55, 39, 3.35, 1.59, 17.64, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 5, 6.47, 39, 4.83, 1.35, 25.84, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 6, 65.07, 39, 9.92, 43.50, 81.84, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 7, 3.95, 39, 2.92, 0.86, 16.34, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 8, 11.28, 39, 5.91, 3.70, 29.59, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 9, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 10, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 11, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 12, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 1, 3.78, 39, 2.89, 0.78, 16.38, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 2, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 3, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 4, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 5, 6.03, 39, 3.87, 1.59, 20.37, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 6, 29.16, 39, 8.58, 15.08, 48.85, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 7, 37.09, 39, 11.20, 18.24, 60.90, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 8, 9.64, 39, 5.03, 3.21, 25.54, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 9, 4.38, 39, 2.76, 1.19, 14.80, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 10, 4.36, 39, 3.09, 1.01, 16.96, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 11, 5.55, 39, 3.97, 1.25, 21.37, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 1, 36.39, 39, 11.08, 17.84, 60.11, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 2, 15.53, 39, 6.31, 6.49, 32.74, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 3, 15.22, 39, 7.43, 5.30, 36.56, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 4, 6.34, 39, 4.50, 1.44, 23.88, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 5, 12.49, 39, 5.78, 4.66, 29.42, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 6, 8.48, 39, 5.32, 2.26, 27.07, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 7, 2.24, 39, 2.25, 0.29, 15.52, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 8, 3.31, 39, 3.27, 0.43, 21.38, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 9, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 1, 5.57, 39, 3.72, 1.39, 19.78, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 2, 7.02, 39, 4.94, 1.61, 25.89, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 3, 18.20, 39, 8.25, 6.76, 40.58, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 4, 23.08, 39, 11.25, 7.68, 51.97, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 5, 28.22, 39, 8.20, 14.77, 47.15, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 6, 15.66, 39, 6.31, 6.60, 32.81, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 7, 2.24, 39, 2.25, 0.29, 15.52, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 8, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 9, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 1, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 2, 6.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 3, 6.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 4, 6.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 5, 26.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 6, 50.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 7, 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 8, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 9, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 10, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 11, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 12, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 1, 13.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 2, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 3, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 4, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 5, 6.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 6, 20.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 7, 53.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 8, 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 9, 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 10, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 11, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 1, 10.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 2, 20.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 3, 43.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 4, 13.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 5, 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 6, 6.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 7, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 8, 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 9, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 1, 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 2, 23.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 3, 33.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 4, 13.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 5, 13.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 6, 6.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 7, 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 8, 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 9, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '2.D.1', 'RL', 1, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '2.D.1', 'RL', 2, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '2.D.1', 'RL', 3, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '2.D.1', 'RL', 4, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '2.D.1', 'RL', 5, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '2.D.1', 'RL', 6, 84.15, 21, 7.65, 61.62, 94.61, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '2.D.1', 'RL', 7, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '2.D.1', 'RL', 8, 15.85, 21, 7.65, 5.39, 38.38, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '2.D.1', 'RL', 9, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '2.D.1', 'RL', 10, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '2.D.1', 'RL', 11, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '2.D.1', 'RL', 12, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.1', 'RW', 1, 11.93, 21, 10.18, 1.76, 50.53, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.1', 'RW', 2, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.1', 'RW', 3, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.1', 'RW', 4, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.1', 'RW', 5, 1.68, 21, 1.72, 0.19, 13.05, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.1', 'RW', 6, 1.39, 21, 1.45, 0.15, 11.38, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.1', 'RW', 7, 38.24, 21, 14.17, 15.04, 68.40, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.1', 'RW', 8, 13.58, 21, 7.06, 4.29, 35.52, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.1', 'RW', 9, 15.34, 21, 8.16, 4.66, 40.18, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.1', 'RW', 10, 1.56, 21, 1.60, 0.18, 12.31, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.1', 'RW', 11, 16.28, 21, 14.27, 2.14, 63.33, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.2', 'PT', 1, 31.93, 21, 14.28, 10.64, 64.87, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.2', 'PT', 2, 33.23, 21, 14.35, 11.44, 65.72, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.2', 'PT', 3, 6.40, 21, 3.94, 1.70, 21.26, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.2', 'PT', 4, 10.69, 21, 10.03, 1.32, 51.71, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.2', 'PT', 5, 6.54, 21, 4.69, 1.39, 25.76, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.2', 'PT', 6, 7.98, 21, 6.31, 1.42, 34.26, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.2', 'PT', 7, 1.68, 21, 1.72, 0.19, 13.05, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.2', 'PT', 8, 1.56, 21, 1.60, 0.18, 12.31, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.2', 'PT', 9, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.3', 'OJ', 1, 16.28, 21, 14.27, 2.14, 63.33, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.3', 'OJ', 2, 1.39, 21, 1.45, 0.15, 11.38, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.3', 'OJ', 3, 6.76, 21, 4.21, 1.77, 22.58, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.3', 'OJ', 4, 12.04, 21, 7.36, 3.11, 36.86, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.3', 'OJ', 5, 39.41, 21, 14.64, 15.32, 70.04, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.3', 'OJ', 6, 13.43, 21, 7.75, 3.72, 38.39, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.3', 'OJ', 7, 10.69, 21, 10.03, 1.32, 51.71, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.3', 'OJ', 8, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2051.00', '3.A.3', 'OJ', 9, 0.00, 21, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 1, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 2, 15.95, 22, 8.91, 4.55, 43.03, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 3, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 4, 10.00, 22, 7.46, 1.94, 38.40, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 5, 17.60, 22, 13.16, 3.13, 58.50, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 6, 44.84, 22, 11.85, 23.09, 68.76, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 7, 9.00, 22, 5.51, 2.38, 28.62, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 8, 0.84, 22, 0.69, 0.15, 4.52, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 9, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 10, 1.77, 22, 1.80, 0.21, 13.47, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 11, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 12, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 1, 35.26, 22, 15.88, 11.36, 69.84, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 2, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 3, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 4, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 5, 0.38, 22, 0.39, 0.04, 3.21, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 6, 5.26, 22, 3.66, 1.19, 20.33, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 7, 41.18, 22, 17.29, 13.70, 75.54, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 8, 12.32, 22, 7.06, 3.48, 35.37, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 9, 3.37, 22, 2.93, 0.53, 18.50, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 10, 1.77, 22, 1.80, 0.21, 13.47, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 11, 0.46, 22, 0.51, 0.05, 4.51, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.2', 'PT', 1, 31.06, 22, 12.99, 11.31, 61.41, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.2', 'PT', 2, 4.96, 22, 3.11, 1.31, 17.04, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.2', 'PT', 3, 1.77, 22, 1.80, 0.21, 13.47, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.2', 'PT', 4, 13.23, 22, 8.42, 3.21, 41.19, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.2', 'PT', 5, 28.71, 22, 13.39, 9.36, 61.10, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.2', 'PT', 6, 17.61, 22, 8.58, 5.88, 42.25, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.2', 'PT', 7, 2.19, 22, 2.23, 0.26, 16.36, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.2', 'PT', 8, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.2', 'PT', 9, 0.46, 22, 0.51, 0.05, 4.51, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.3', 'OJ', 1, 9.14, 22, 8.12, 1.30, 43.47, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.3', 'OJ', 2, 16.38, 22, 14.24, 2.20, 63.00, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.3', 'OJ', 3, 0.38, 22, 0.40, 0.04, 3.24, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.3', 'OJ', 4, 10.32, 22, 7.56, 2.06, 38.61, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.3', 'OJ', 5, 34.25, 22, 15.39, 11.17, 68.33, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.3', 'OJ', 6, 14.40, 22, 8.54, 3.83, 41.54, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.3', 'OJ', 7, 10.55, 22, 6.65, 2.65, 33.81, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.3', 'OJ', 8, 4.12, 22, 4.18, 0.47, 27.91, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.3', 'OJ', 9, 0.46, 22, 0.51, 0.05, 4.51, 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '2.D.1', 'RL', 1, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '2.D.1', 'RL', 2, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '2.D.1', 'RL', 3, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '2.D.1', 'RL', 4, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '2.D.1', 'RL', 5, 11.54, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '2.D.1', 'RL', 6, 80.77, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '2.D.1', 'RL', 7, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '2.D.1', 'RL', 8, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '2.D.1', 'RL', 9, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '2.D.1', 'RL', 10, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '2.D.1', 'RL', 11, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '2.D.1', 'RL', 12, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.1', 'RW', 1, 19.23, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.1', 'RW', 2, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.1', 'RW', 3, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.1', 'RW', 4, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.1', 'RW', 5, 7.69, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.1', 'RW', 6, 19.23, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.1', 'RW', 7, 38.46, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.1', 'RW', 8, 11.54, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.1', 'RW', 9, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.1', 'RW', 10, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.1', 'RW', 11, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.2', 'PT', 1, 11.54, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.2', 'PT', 2, 15.38, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.2', 'PT', 3, 15.38, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.2', 'PT', 4, 19.23, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.2', 'PT', 5, 23.08, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.2', 'PT', 6, 7.69, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.2', 'PT', 7, 7.69, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.2', 'PT', 8, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.2', 'PT', 9, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.3', 'OJ', 1, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.3', 'OJ', 2, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.3', 'OJ', 3, 7.69, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.3', 'OJ', 4, 15.38, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.3', 'OJ', 5, 46.15, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.3', 'OJ', 6, 23.08, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.3', 'OJ', 7, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.3', 'OJ', 8, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '3.A.3', 'OJ', 9, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '2.D.1', 'RL', 1, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '2.D.1', 'RL', 2, 2.16, 26, 2.21, 0.26, 15.92, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '2.D.1', 'RL', 3, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '2.D.1', 'RL', 4, 2.90, 26, 2.53, 0.47, 15.97, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '2.D.1', 'RL', 5, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '2.D.1', 'RL', 6, 81.80, 26, 9.20, 55.74, 94.14, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '2.D.1', 'RL', 7, 10.72, 26, 8.35, 1.95, 41.98, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '2.D.1', 'RL', 8, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '2.D.1', 'RL', 9, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '2.D.1', 'RL', 10, 2.42, 26, 2.45, 0.29, 17.36, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '2.D.1', 'RL', 11, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '2.D.1', 'RL', 12, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.1', 'RW', 1, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.1', 'RW', 2, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.1', 'RW', 3, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.1', 'RW', 4, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.1', 'RW', 5, 6.88, 25, 4.03, 1.98, 21.28, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.1', 'RW', 6, 13.29, 25, 10.61, 2.24, 50.61, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.1', 'RW', 7, 47.85, 25, 13.78, 22.69, 74.15, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.1', 'RW', 8, 29.77, 25, 12.45, 11.03, 59.16, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.1', 'RW', 9, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.1', 'RW', 10, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.1', 'RW', 11, 2.21, 25, 2.21, 0.27, 15.68, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.2', 'PT', 1, 7.49, 25, 4.23, 2.25, 22.19, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.2', 'PT', 2, 25.20, 25, 13.48, 7.16, 59.57, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.2', 'PT', 3, 19.47, 25, 12.15, 4.66, 54.46, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.2', 'PT', 4, 8.94, 25, 4.52, 3.03, 23.58, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.2', 'PT', 5, 18.01, 25, 9.36, 5.61, 44.83, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.2', 'PT', 6, 9.38, 25, 4.61, 3.27, 24.09, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.2', 'PT', 7, 11.50, 25, 10.56, 1.50, 52.53, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.2', 'PT', 8, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.2', 'PT', 9, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.3', 'OJ', 1, 13.71, 25, 10.60, 2.44, 50.26, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.3', 'OJ', 2, 2.31, 25, 2.35, 0.28, 16.84, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.3', 'OJ', 3, 25.70, 25, 13.45, 7.48, 59.68, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.3', 'OJ', 4, 15.22, 25, 8.99, 4.09, 43.06, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.3', 'OJ', 5, 10.12, 25, 4.91, 3.56, 25.54, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.3', 'OJ', 6, 22.76, 25, 11.20, 7.33, 52.32, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.3', 'OJ', 7, 10.18, 25, 7.84, 1.89, 39.93, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.3', 'OJ', 8, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '3.A.3', 'OJ', 9, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '2.D.1', 'RL', 1, 0.00, 15, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '2.D.1', 'RL', 2, 35.77, 15, 26.57, 4.45, 86.94, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '2.D.1', 'RL', 3, 0.00, 15, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '2.D.1', 'RL', 4, 0.00, 15, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '2.D.1', 'RL', 5, 5.98, 15, 5.64, 0.73, 35.37, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '2.D.1', 'RL', 6, 48.62, 15, 25.96, 9.24, 89.79, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '2.D.1', 'RL', 7, 0.00, 15, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '2.D.1', 'RL', 8, 9.63, 15, 8.50, 1.29, 46.41, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '2.D.1', 'RL', 9, 0.00, 15, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '2.D.1', 'RL', 10, 0.00, 15, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '2.D.1', 'RL', 11, 0.00, 15, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '2.D.1', 'RL', 12, 0.00, 15, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.1', 'RW', 1, 35.63, 16, 26.58, 4.47, 86.74, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.1', 'RW', 2, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.1', 'RW', 3, 0.04, 16, 0.05, 0.00, 0.45, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.1', 'RW', 4, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.1', 'RW', 5, 0.70, 16, 0.74, 0.07, 6.44, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.1', 'RW', 6, 42.66, 16, 26.08, 7.12, 87.83, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.1', 'RW', 7, 19.76, 16, 13.46, 3.87, 60.07, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.1', 'RW', 8, 1.21, 16, 1.24, 0.14, 9.99, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.1', 'RW', 9, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.1', 'RW', 10, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.1', 'RW', 11, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.2', 'PT', 1, 5.48, 16, 4.67, 0.84, 28.41, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.2', 'PT', 2, 13.46, 16, 10.35, 2.29, 50.81, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.2', 'PT', 3, 8.56, 16, 8.20, 0.99, 46.63, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.2', 'PT', 4, 35.76, 16, 26.56, 4.52, 86.75, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.2', 'PT', 5, 35.63, 16, 26.58, 4.47, 86.74, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.2', 'PT', 6, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.2', 'PT', 7, 0.06, 16, 0.07, 0.01, 0.68, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.2', 'PT', 8, 1.05, 16, 1.16, 0.10, 10.40, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.2', 'PT', 9, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.3', 'OJ', 1, 1.07, 16, 1.20, 0.10, 10.79, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.3', 'OJ', 2, 7.40, 16, 7.80, 0.70, 47.51, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.3', 'OJ', 3, 11.29, 16, 9.45, 1.67, 48.76, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.3', 'OJ', 4, 36.42, 16, 26.49, 4.76, 86.78, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.3', 'OJ', 5, 6.03, 16, 5.65, 0.76, 34.97, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.3', 'OJ', 6, 37.79, 16, 26.38, 5.26, 86.91, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.3', 'OJ', 7, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.3', 'OJ', 8, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.01', '3.A.3', 'OJ', 9, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '2.D.1', 'RL', 1, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '2.D.1', 'RL', 2, 74.88, 19, 11.89, 44.14, 91.83, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '2.D.1', 'RL', 3, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '2.D.1', 'RL', 4, 0.75, 19, 0.78, 0.08, 6.52, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '2.D.1', 'RL', 5, 2.43, 19, 2.54, 0.26, 19.20, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '2.D.1', 'RL', 6, 21.39, 19, 11.07, 6.39, 52.05, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '2.D.1', 'RL', 7, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '2.D.1', 'RL', 8, 0.56, 19, 0.59, 0.06, 5.01, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '2.D.1', 'RL', 9, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '2.D.1', 'RL', 10, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '2.D.1', 'RL', 11, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '2.D.1', 'RL', 12, 0.00, 19, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.1', 'RW', 1, 41.16, 20, 19.95, 11.09, 79.69, 'Y', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.1', 'RW', 2, 19.63, 20, 17.32, 2.40, 70.85, 'Y', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.1', 'RW', 3, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.1', 'RW', 4, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.1', 'RW', 5, 8.27, 20, 8.20, 0.93, 46.38, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.1', 'RW', 6, 5.14, 20, 3.58, 1.15, 20.11, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.1', 'RW', 7, 10.49, 20, 6.95, 2.43, 35.53, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.1', 'RW', 8, 13.90, 20, 12.74, 1.71, 59.97, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.1', 'RW', 9, 0.86, 20, 0.80, 0.12, 5.86, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.1', 'RW', 10, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.1', 'RW', 11, 0.55, 20, 0.58, 0.06, 4.89, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.2', 'PT', 1, 0.99, 20, 0.72, 0.22, 4.43, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.2', 'PT', 2, 16.17, 20, 9.87, 4.03, 46.98, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.2', 'PT', 3, 33.15, 20, 18.97, 7.63, 74.85, 'Y', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.2', 'PT', 4, 23.17, 20, 17.27, 3.81, 69.67, 'Y', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.2', 'PT', 5, 2.63, 20, 2.22, 0.44, 14.22, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.2', 'PT', 6, 23.89, 20, 17.55, 4.00, 70.31, 'Y', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.2', 'PT', 7, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.2', 'PT', 8, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.2', 'PT', 9, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.3', 'OJ', 1, 0.19, 20, 0.15, 0.04, 0.99, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.3', 'OJ', 2, 5.14, 20, 3.38, 1.25, 18.79, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.3', 'OJ', 3, 42.20, 20, 19.11, 12.41, 79.00, 'Y', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.3', 'OJ', 4, 22.48, 20, 17.26, 3.52, 69.73, 'Y', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.3', 'OJ', 5, 1.92, 20, 2.00, 0.21, 15.40, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.3', 'OJ', 6, 28.07, 20, 18.20, 5.59, 72.02, 'Y', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.3', 'OJ', 7, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.3', 'OJ', 8, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '3.A.3', 'OJ', 9, 0.00, 20, 0.00, NULL, NULL, 'N', TO_DATE('2004-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '2.D.1', 'RL', 1, 1.15, 26, 1.23, 0.13, 9.68, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '2.D.1', 'RL', 2, 27.12, 26, 15.48, 6.90, 65.12, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '2.D.1', 'RL', 3, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '2.D.1', 'RL', 4, 28.86, 26, 15.56, 7.85, 65.90, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '2.D.1', 'RL', 5, 1.90, 26, 1.58, 0.34, 9.96, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '2.D.1', 'RL', 6, 28.65, 26, 9.66, 13.17, 51.52, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '2.D.1', 'RL', 7, 12.32, 26, 9.80, 2.13, 47.64, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '2.D.1', 'RL', 8, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '2.D.1', 'RL', 9, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '2.D.1', 'RL', 10, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '2.D.1', 'RL', 11, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '2.D.1', 'RL', 12, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.1', 'RW', 1, 31.47, 26, 14.22, 10.56, 64.11, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.1', 'RW', 2, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.1', 'RW', 3, 1.41, 26, 1.47, 0.16, 11.25, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.1', 'RW', 4, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.1', 'RW', 5, 26.19, 26, 12.39, 8.66, 57.04, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.1', 'RW', 6, 5.30, 26, 3.52, 1.31, 19.15, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.1', 'RW', 7, 20.42, 26, 15.30, 3.56, 64.09, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.1', 'RW', 8, 6.17, 26, 4.35, 1.38, 23.61, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.1', 'RW', 9, 1.13, 26, 0.95, 0.20, 6.12, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.1', 'RW', 10, 7.91, 26, 8.08, 0.87, 45.78, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.1', 'RW', 11, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.2', 'PT', 1, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.2', 'PT', 2, 38.19, 26, 19.14, 10.42, 76.65, 'Y', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.2', 'PT', 3, 30.26, 26, 13.14, 10.74, 61.01, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.2', 'PT', 4, 2.09, 26, 1.62, 0.42, 9.79, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.2', 'PT', 5, 5.87, 26, 3.94, 1.42, 21.30, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.2', 'PT', 6, 10.92, 26, 8.76, 1.88, 43.92, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.2', 'PT', 7, 12.68, 26, 9.76, 2.31, 47.15, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.2', 'PT', 8, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.2', 'PT', 9, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.3', 'OJ', 1, 4.80, 26, 5.01, 0.52, 32.57, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.3', 'OJ', 2, 1.15, 26, 1.23, 0.13, 9.68, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.3', 'OJ', 3, 38.37, 26, 14.60, 14.87, 68.94, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.3', 'OJ', 4, 22.32, 26, 14.77, 4.73, 62.43, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.3', 'OJ', 5, 5.65, 26, 5.15, 0.81, 30.48, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.3', 'OJ', 6, 12.56, 26, 9.02, 2.58, 43.81, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.3', 'OJ', 7, 15.15, 26, 9.69, 3.64, 45.76, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.3', 'OJ', 8, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '3.A.3', 'OJ', 9, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2005-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '2.D.1', 'RL', 1, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '2.D.1', 'RL', 2, 39.03, 33, 13.19, 17.15, 66.44, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '2.D.1', 'RL', 3, 19.24, 33, 11.16, 5.23, 50.70, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '2.D.1', 'RL', 4, 0.24, 33, 0.21, 0.04, 1.47, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '2.D.1', 'RL', 5, 0.39, 33, 0.41, 0.04, 3.36, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '2.D.1', 'RL', 6, 32.75, 33, 22.45, 5.76, 79.53, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '2.D.1', 'RL', 7, 8.36, 33, 8.78, 0.88, 48.49, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '2.D.1', 'RL', 8, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '2.D.1', 'RL', 9, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '2.D.1', 'RL', 10, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '2.D.1', 'RL', 11, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '2.D.1', 'RL', 12, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.1', 'RW', 1, 46.55, 33, 16.58, 18.31, 77.19, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.1', 'RW', 2, 0.63, 33, 0.68, 0.07, 5.45, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.1', 'RW', 3, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.1', 'RW', 4, 9.30, 33, 5.27, 2.79, 26.79, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.1', 'RW', 5, 15.38, 33, 11.34, 2.99, 51.76, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.1', 'RW', 6, 11.37, 33, 8.69, 2.17, 42.65, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.1', 'RW', 7, 5.15, 33, 3.23, 1.39, 17.30, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.1', 'RW', 8, 11.62, 33, 9.37, 2.01, 45.76, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.1', 'RW', 9, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.1', 'RW', 10, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.1', 'RW', 11, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.2', 'PT', 1, 35.03, 33, 6.76, 22.75, 49.67, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.2', 'PT', 2, 23.44, 33, 12.49, 6.91, 55.82, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.2', 'PT', 3, 12.39, 33, 7.17, 3.55, 35.18, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.2', 'PT', 4, 7.83, 33, 4.71, 2.20, 24.27, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.2', 'PT', 5, 18.29, 33, 11.27, 4.60, 50.98, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.2', 'PT', 6, 0.66, 33, 0.71, 0.07, 5.65, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.2', 'PT', 7, 2.36, 33, 2.44, 0.28, 17.29, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.2', 'PT', 8, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.2', 'PT', 9, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.3', 'OJ', 1, 17.57, 32, 11.71, 3.94, 52.57, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.3', 'OJ', 2, 44.42, 32, 20.07, 13.21, 80.74, 'Y', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.3', 'OJ', 3, 6.69, 32, 3.85, 2.00, 20.15, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.3', 'OJ', 4, 5.41, 32, 4.15, 1.08, 22.99, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.3', 'OJ', 5, 21.11, 32, 11.25, 6.32, 51.49, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.3', 'OJ', 6, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.3', 'OJ', 7, 4.05, 32, 3.19, 0.78, 18.39, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.3', 'OJ', 8, 0.77, 32, 0.82, 0.09, 6.48, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '3.A.3', 'OJ', 9, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2005-12-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '2.D.1', 'RL', 1, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '2.D.1', 'RL', 2, 6.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '2.D.1', 'RL', 3, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '2.D.1', 'RL', 4, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '2.D.1', 'RL', 5, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '2.D.1', 'RL', 6, 65.62, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '2.D.1', 'RL', 7, 15.62, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '2.D.1', 'RL', 8, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '2.D.1', 'RL', 9, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '2.D.1', 'RL', 10, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '2.D.1', 'RL', 11, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '2.D.1', 'RL', 12, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.1', 'RW', 1, 6.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.1', 'RW', 2, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.1', 'RW', 3, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.1', 'RW', 4, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.1', 'RW', 5, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.1', 'RW', 6, 25.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.1', 'RW', 7, 34.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.1', 'RW', 8, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.1', 'RW', 9, 12.50, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.1', 'RW', 10, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.1', 'RW', 11, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.2', 'PT', 1, 12.50, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.2', 'PT', 2, 25.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.2', 'PT', 3, 15.62, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.2', 'PT', 4, 18.75, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.2', 'PT', 5, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.2', 'PT', 6, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.2', 'PT', 7, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.2', 'PT', 8, 6.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.2', 'PT', 9, 0.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.3', 'OJ', 1, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.3', 'OJ', 2, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.3', 'OJ', 3, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.3', 'OJ', 4, 18.75, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.3', 'OJ', 5, 15.62, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.3', 'OJ', 6, 31.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.3', 'OJ', 7, 9.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.3', 'OJ', 8, 6.25, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '3.A.3', 'OJ', 9, 3.12, 32, NULL, NULL, NULL, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '2.D.1', 'RL', 1, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '2.D.1', 'RL', 2, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '2.D.1', 'RL', 3, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '2.D.1', 'RL', 4, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '2.D.1', 'RL', 5, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '2.D.1', 'RL', 6, 1.65, 25, 1.05, 0.44, 6.00, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '2.D.1', 'RL', 7, 0.25, 25, 0.29, 0.02, 2.83, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '2.D.1', 'RL', 8, 58.79, 25, 14.63, 29.09, 83.22, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '2.D.1', 'RL', 9, 20.94, 25, 17.15, 3.03, 69.21, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '2.D.1', 'RL', 10, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '2.D.1', 'RL', 11, 14.96, 25, 6.76, 5.55, 34.48, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '2.D.1', 'RL', 12, 3.42, 25, 2.55, 0.71, 14.84, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.1', 'RW', 1, 6.00, 24, 5.53, 0.83, 32.67, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.1', 'RW', 2, 0.86, 24, 0.90, 0.10, 7.08, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.1', 'RW', 3, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.1', 'RW', 4, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.1', 'RW', 5, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.1', 'RW', 6, 6.00, 24, 2.99, 2.08, 16.06, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.1', 'RW', 7, 47.88, 24, 22.04, 12.87, 85.10, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.1', 'RW', 8, 19.71, 24, 14.76, 3.44, 62.83, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.1', 'RW', 9, 0.92, 24, 0.94, 0.11, 7.32, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.1', 'RW', 10, 17.64, 24, 18.06, 1.61, 73.70, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.1', 'RW', 11, 1.00, 24, 0.74, 0.22, 4.54, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.2', 'PT', 1, 51.61, 24, 15.41, 22.94, 79.26, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.2', 'PT', 2, 3.12, 24, 2.25, 0.69, 13.06, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.2', 'PT', 3, 1.99, 24, 1.66, 0.35, 10.54, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.2', 'PT', 4, 38.98, 24, 17.27, 12.46, 74.15, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.2', 'PT', 5, 0.51, 24, 0.53, 0.06, 4.25, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.2', 'PT', 6, 1.30, 24, 1.05, 0.24, 6.67, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.2', 'PT', 7, 2.49, 24, 2.04, 0.45, 12.65, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.2', 'PT', 8, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.2', 'PT', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.3', 'OJ', 1, 36.31, 24, 21.43, 7.74, 79.49, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.3', 'OJ', 2, 0.25, 24, 0.26, 0.03, 2.08, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.3', 'OJ', 3, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.3', 'OJ', 4, 21.24, 24, 17.15, 3.13, 69.22, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.3', 'OJ', 5, 37.24, 24, 22.41, 7.54, 81.18, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.3', 'OJ', 6, 3.50, 24, 2.36, 0.85, 13.31, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.3', 'OJ', 7, 1.47, 24, 1.53, 0.17, 11.73, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.3', 'OJ', 8, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1111.00', '3.A.3', 'OJ', 9, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '2.D.1', 'RL', 1, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '2.D.1', 'RL', 2, 1.35, 43, 0.88, 0.36, 4.93, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '2.D.1', 'RL', 3, 7.04, 43, 6.21, 1.10, 33.97, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '2.D.1', 'RL', 4, 7.80, 43, 4.43, 2.38, 22.68, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '2.D.1', 'RL', 5, 41.09, 43, 13.06, 19.01, 67.45, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '2.D.1', 'RL', 6, 26.42, 43, 7.86, 13.70, 44.80, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '2.D.1', 'RL', 7, 9.64, 43, 6.74, 2.19, 33.70, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '2.D.1', 'RL', 8, 6.66, 43, 6.19, 0.95, 34.70, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '2.D.1', 'RL', 9, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '2.D.1', 'RL', 10, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '2.D.1', 'RL', 11, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '2.D.1', 'RL', 12, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.1', 'RW', 1, 0.35, 43, 0.36, 0.04, 2.78, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.1', 'RW', 2, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.1', 'RW', 3, 0.58, 43, 0.59, 0.07, 4.41, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.1', 'RW', 4, 3.71, 43, 3.71, 0.47, 23.85, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.1', 'RW', 5, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.1', 'RW', 6, 26.93, 43, 12.57, 9.22, 57.23, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.1', 'RW', 7, 21.26, 43, 7.78, 9.56, 40.83, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.1', 'RW', 8, 27.20, 43, 11.15, 10.71, 53.79, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.1', 'RW', 9, 11.07, 43, 6.45, 3.21, 31.85, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.1', 'RW', 10, 6.92, 43, 6.24, 1.04, 34.46, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.1', 'RW', 11, 1.96, 43, 1.95, 0.26, 13.40, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.2', 'PT', 1, 11.01, 43, 6.64, 3.06, 32.68, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.2', 'PT', 2, 5.92, 43, 3.35, 1.83, 17.49, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.2', 'PT', 3, 15.60, 43, 6.64, 6.26, 33.85, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.2', 'PT', 4, 11.33, 43, 6.87, 3.11, 33.68, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.2', 'PT', 5, 11.52, 43, 6.79, 3.28, 33.33, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.2', 'PT', 6, 33.83, 43, 13.69, 12.95, 63.72, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.2', 'PT', 7, 10.21, 43, 6.81, 2.48, 33.72, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.2', 'PT', 8, 0.58, 43, 0.59, 0.07, 4.41, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.2', 'PT', 9, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.3', 'OJ', 1, 6.69, 42, 6.46, 0.88, 36.70, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.3', 'OJ', 2, 1.80, 42, 1.50, 0.33, 9.25, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.3', 'OJ', 3, 25.07, 42, 10.01, 10.24, 49.54, 'N', TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1121.00', '3.A.3', 'OJ', 4, 8.02, 42, 3.43, 3.30, 18.22, 'N